/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.SplitStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitChildOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderByMultiWarehouseDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.oms.DgSplitOrderTransferReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAuditEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.utils.DgPerformOrderNoGreateUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOmsOrderSplitSaleOrderModeDomainImpl
implements IDgOmsOrderSplitSaleOrderModeDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderSplitSaleOrderModeDomainImpl.class);
    private static final String DEFAULT_SPLIT_LOGIC_WAREHOUSE = "DEFAULT_SPLIT_LOGIC_WAREHOUSE";
    @Resource
    private DgPerformOrderNoGreateUtil performOrderNoGreateUtil;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private ISourceRecordDomain sourceRecordDomain;
    @Resource
    private IDgSaleOrderAuditDomain dgSaleOrderAuditDomain;
    @Resource
    protected IDgPerformOrderInfoDas performOrderInfoDas;

    @Override
    public DgPerformOrderReqDto createChildOrderForRemain(DgPerformOrderInfoEo shipmentOrderInfoEo, List<DgPerformOrderLineDto> dgSplitOrderItemReqDtos, DgSplitOrderTransferReqDto splitOrderTransferReqDto, String initOrderStatus, String initOmsOrderStatus, List<DgPerformOrderLineDto> orderLineDtoList, List<DgPerformOrderItemLineEo> itemLineDtoList, List<DgPerformOrderItemLineAmountDto> amountDtoList, List<Long> upIdList) {
        log.debug("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355({})\u5269\u4f59\u5546\u54c1\u8fdb\u884c\u5408\u5355\uff0c\u5408\u6210\u4e00\u5f20\u5b50\u5355", (Object)shipmentOrderInfoEo.getSaleOrderNo());
        Map<Long, List<DgPerformOrderLineDto>> skuSplitMap = dgSplitOrderItemReqDtos.stream().collect(Collectors.groupingBy(BaseDto::getId));
        HashMap splitOrderItemIdCountMap = new HashMap();
        skuSplitMap.forEach((orderLineId, splitOrderList) -> {
            BigDecimal orderItemIdCount = splitOrderList.stream().map(DgPerformOrderLineDto::getSplitItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitOrderItemIdCountMap.put(orderLineId, orderItemIdCount);
        });
        log.info("[\u624b\u52a8\u62c6\u5355]\u6c47\u603b\u5404\u4e2a\u5546\u54c1\u62c6\u5355\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemIdCountMap));
        ArrayList remainFoodsList = Lists.newArrayList();
        orderLineDtoList.forEach(orderLineDto -> {
            BigDecimal splitCount = (BigDecimal)splitOrderItemIdCountMap.get(orderLineDto.getId());
            DgPerformOrderLineDto dto = new DgPerformOrderLineDto();
            dto.setId(orderLineDto.getId());
            dto.setGiftFlag(orderLineDto.getGiftFlag());
            if (splitCount != null) {
                if (orderLineDto.getCalcItemNum().compareTo(splitCount) > 0) {
                    BigDecimal remainItemCount = orderLineDto.getCalcItemNum().subtract(splitCount);
                    dto.setSplitItemNum(remainItemCount);
                    remainFoodsList.add(dto);
                }
            } else {
                BigDecimal remainItemCount = orderLineDto.getCalcItemNum();
                dto.setSplitItemNum(remainItemCount);
                remainFoodsList.add(dto);
            }
        });
        log.info("[\u624b\u52a8\u62c6\u5355]\u5269\u4f59\u7684\u8ba2\u5355\u5546\u54c1\u7684\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)remainFoodsList));
        if (CollectionUtils.isEmpty((Collection)remainFoodsList)) {
            log.info("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u5df2\u88ab\u5168\u90e8\u62c6\u5206\u5b8c\uff0c\u6ca1\u6709\u5269\u4f59\u5546\u54c1\uff0c\u65e0\u9700\u518d\u6784\u9020\u5b50\u5355");
            return null;
        }
        DgSplitChildOrderReqDto childOrderReqDto = new DgSplitChildOrderReqDto();
        CubeBeanUtils.copyProperties((Object)childOrderReqDto, (Object)shipmentOrderInfoEo, (String[])new String[0]);
        childOrderReqDto.setOrderLineDtoList((List)remainFoodsList);
        childOrderReqDto.setBizType(shipmentOrderInfoEo.getBizType());
        DgPerformOrderReqDto childOrder = this.checkAndCreateChildOrder(splitOrderTransferReqDto, initOrderStatus, initOmsOrderStatus, childOrderReqDto);
        if (CollectionUtil.isNotEmpty(itemLineDtoList)) {
            this.omsOrderInfoDomain.createChildOrder(childOrder);
            this.copyOrderAddress(shipmentOrderInfoEo.getId(), childOrder.getId());
            this.createChildOrderItem(childOrder, childOrderReqDto, orderLineDtoList, itemLineDtoList, amountDtoList, upIdList);
        }
        return childOrder;
    }

    private void changeOrignalOrder(DgPerformOrderInfoEo orderInfoEo) {
        log.debug("[\u62c6\u5355]\u5f00\u59cb\u4fee\u6539\u539f\u8ba2\u5355\u7684\u72b6\u6001");
        DgPerformOrderInfoEo updateSaleOrderEo = new DgPerformOrderInfoEo();
        updateSaleOrderEo.setSplitStatus(SplitStatusEnum.SPLIT.getType());
        updateSaleOrderEo.setId(orderInfoEo.getId());
        log.info("[\u62c6\u5355]\u4fee\u6539\u539f\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u62c6\u5206\uff0c\u4fee\u6539\u8bf7\u6c42\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateSaleOrderEo));
        int update = this.performOrderInfoDomain.updateSaleOrderById(orderInfoEo.getId(), updateSaleOrderEo);
        if (update != 1) {
            throw DgPcpTradeExceptionCode.SPLIT_ORDER_FAIL.builderException();
        }
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByMultiWarehouse(DgPerformOrderRespDto saleOrderRespDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
        List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderRespDto.getId());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(orderLineDtoList), (String)"\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
        ArrayList dgSplitOrderByMultiWarehouseDtos = Lists.newArrayList();
        List splitSaleOrderItemRespDtos = orderLineDtoList.stream().filter(saleOrderItemRespDto -> DgSaleOrderBizTypeEnum.YHDX.getCode().equals(saleOrderItemRespDto.getItemAttr())).collect(Collectors.toList());
        log.info("[\u62c6\u5355]\u4ee5\u6362\u4ee3\u53d1\u5355:{}", (Object)JSON.toJSONString(splitSaleOrderItemRespDtos.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList())));
        dgSplitOrderByMultiWarehouseDtos.add(DgSplitOrderByMultiWarehouseDto.builder().initOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).initOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).bizType(DgSaleOrderBizTypeEnum.YHDX.getCode()).orderLineDtoList(splitSaleOrderItemRespDtos).build());
        List performOrderServiceItemDtos = orderLineDtoList.stream().filter(e -> e.getItemType().equals(DgSaleOrderItemTypeEnum.SERVICE.getType())).collect(Collectors.toList());
        log.info("[\u62c6\u5355]\u670d\u52a1\u5546\u54c1\u5355:{}", (Object)JSON.toJSONString(performOrderServiceItemDtos.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList())));
        dgSplitOrderByMultiWarehouseDtos.add(DgSplitOrderByMultiWarehouseDto.builder().initOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).initOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).bizType(DgSaleOrderBizTypeEnum.PTDT.getCode()).orderLineDtoList(performOrderServiceItemDtos).build());
        List performOrderVirtualItemDtos = orderLineDtoList.stream().filter(e -> e.getItemType().equals(DgSaleOrderItemTypeEnum.VIRTUAL.getType())).collect(Collectors.toList());
        log.info("[\u62c6\u5355]\u865a\u62df\u5546\u54c1\u5355:{}", (Object)JSON.toJSONString(performOrderVirtualItemDtos.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList())));
        dgSplitOrderByMultiWarehouseDtos.add(DgSplitOrderByMultiWarehouseDto.builder().initOrderStatus(DgOmsSaleOrderStatus.DELIVERED.getCode()).initOmsOrderStatus(DgOmsSaleOrderStatus.DELIVERY_ALL.getCode()).bizType(DgSaleOrderBizTypeEnum.PTDT.getCode()).orderLineDtoList(performOrderVirtualItemDtos).build());
        List performOrderDefaultItemDtos = orderLineDtoList.stream().filter(e -> !e.getItemType().equals(DgSaleOrderItemTypeEnum.VIRTUAL.getType()) && !e.getItemType().equals(DgSaleOrderItemTypeEnum.SERVICE.getType()) && !DgSaleOrderBizTypeEnum.YHDX.getCode().equals(e.getItemAttr())).collect(Collectors.toList());
        log.info("[\u62c6\u5355]\u5269\u4f59\u5546\u54c1\u5355:{}", (Object)JSON.toJSONString(performOrderDefaultItemDtos.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList())));
        dgSplitOrderByMultiWarehouseDtos.add(DgSplitOrderByMultiWarehouseDto.builder().initOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).initOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode()).bizType(DgSaleOrderBizTypeEnum.PTDT.getCode()).orderLineDtoList(performOrderDefaultItemDtos).build());
        return this.splitOrderByMultiWarehouse(saleOrderRespDto, dgSplitOrderByMultiWarehouseDtos, orderLineDtoList);
    }

    private List<DgPerformOrderRespDto> splitOrderByMultiWarehouse(DgPerformOrderRespDto orderRespDto, List<DgSplitOrderByMultiWarehouseDto> dgSplitOrderByMultiWarehouseDtos, List<DgPerformOrderLineDto> orderItemLineDtoList) {
        ArrayList orderList = Lists.newArrayList();
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = orderRespDto.getPerformOrderWarehouseInfoDto();
        dgSplitOrderByMultiWarehouseDtos.forEach(splitOrderByMultiWarehouseDto -> {
            List orderItemLineDtos = splitOrderByMultiWarehouseDto.getOrderLineDtoList();
            if (CollectionUtils.isNotEmpty((Collection)orderItemLineDtos)) {
                DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
                splitChildOrderReqDto.setBizType(splitOrderByMultiWarehouseDto.getBizType());
                splitChildOrderReqDto.setInitOrderStatus(splitOrderByMultiWarehouseDto.getInitOrderStatus());
                splitChildOrderReqDto.setInitOmsOrderStatus(splitOrderByMultiWarehouseDto.getInitOmsOrderStatus());
                DgSplitChildOrderReqDto.LogicWarehouse logicWarehouse = new DgSplitChildOrderReqDto.LogicWarehouse();
                logicWarehouse.setDeliveryLogicWarehouseCode(warehouseInfoDto.getDeliveryLogicalWarehouseCode());
                logicWarehouse.setSgLogicWarehouseCode(warehouseInfoDto.getDeliveryLogicalWarehouseCode());
                splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
                List splitOrderItemReqDtos = splitOrderByMultiWarehouseDto.getOrderLineDtoList().stream().map(orderItem -> {
                    DgPerformOrderLineDto splitOrderItemReqDto = new DgPerformOrderLineDto();
                    splitOrderItemReqDto.setId(orderItem.getId());
                    splitOrderItemReqDto.setCalcItemNum(orderItem.getCalcItemNum());
                    splitOrderItemReqDto.setSplitItemNum(orderItem.getCalcItemNum());
                    return splitOrderItemReqDto;
                }).collect(Collectors.toList());
                splitChildOrderReqDto.setOrderLineDtoList(splitOrderItemReqDtos);
                orderList.add(splitChildOrderReqDto);
            }
        });
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(orderRespDto.getId());
        splitOrderReqDto.setInitOrderStatus(orderRespDto.getOrderStatus());
        splitOrderReqDto.setInitOmsOrderStatus(orderRespDto.getOmsSaleOrderStatus());
        splitOrderReqDto.setOrderList((List)orderList);
        log.info("[\u62c6\u5355]\u4e00\u5355\u591a\u4ed3\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto, orderItemLineDtoList);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrder(DgSplitOrderReqDto reqDto, List<DgPerformOrderLineDto> orderLineDtoList) {
        log.info("[\u62c6\u5355]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u539f\u5355\u53c2\u6570\u4e3a\uff1a{}", StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo()) ? reqDto.getSaleOrderNo() : reqDto.getSaleOrderId(), (Object)JSON.toJSONString((Object)reqDto));
        log.info("[\u62c6\u5355]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u539f\u8ba2\u5355\u884c\u53c2\u6570\u4e3a\uff1a{}", StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo()) ? reqDto.getSaleOrderNo() : reqDto.getSaleOrderId(), (Object)JSON.toJSONString(orderLineDtoList));
        DgPerformOrderInfoEo shipmentOrderInfoEo = this.checkSplitOrder(reqDto, orderLineDtoList);
        DgPerformOrderSplitReleationEo dgPerformOrderSplitReleationEo = this.performOrderSplitReleationDomain.queryByChildId(reqDto.getSaleOrderId());
        Long mainOrderId = dgPerformOrderSplitReleationEo != null ? dgPerformOrderSplitReleationEo.getMainOrderId() : reqDto.getSaleOrderId();
        DgSplitOrderTransferReqDto splitOrderTransferReqDto = new DgSplitOrderTransferReqDto();
        splitOrderTransferReqDto.setShipmentOrderInfoEo(shipmentOrderInfoEo);
        splitOrderTransferReqDto.setShipmentPaymentEo(this.performOrderPaymentDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentSnapshotEo(this.performOrderSnapshotDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentExtensionEo(this.performOrderExtensionDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentAmountEo(this.performOrderAmountDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setShipmentWarehouseInfoEo(this.performOrderWarehouseInfoDomain.selectByOrderId(reqDto.getSaleOrderId()));
        splitOrderTransferReqDto.setLastSaleOrderAuditEo(this.dgSaleOrderAuditDomain.selectByOrderIdAndAuditType(reqDto.getSaleOrderId(), null));
        List<DgPerformOrderItemLineEo> itemLineDtoList = this.performOrderItemLineDomain.queryItemLineByOrderLineIds(orderLineDtoList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        List<DgPerformOrderItemLineAmountDto> amountDtoList = this.performOrderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountSource(itemLineDtoList.stream().map(BaseEo::getId).collect(Collectors.toList()), DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
        ArrayList<Long> upIdList = new ArrayList<Long>();
        ArrayList splitChildOrderList = Lists.newArrayList();
        reqDto.getOrderList().forEach(splitChildOrderReqDto -> {
            String initOrderStatus;
            String string = initOrderStatus = StringUtils.isNotBlank((CharSequence)splitChildOrderReqDto.getInitOrderStatus()) ? splitChildOrderReqDto.getInitOrderStatus() : reqDto.getInitOrderStatus();
            String initOmsOrderStatus = StringUtils.isNotBlank((CharSequence)splitChildOrderReqDto.getInitOmsOrderStatus()) ? splitChildOrderReqDto.getInitOmsOrderStatus() : (StringUtils.isNotBlank((CharSequence)reqDto.getInitOmsOrderStatus()) ? reqDto.getInitOmsOrderStatus() : initOrderStatus);
            DgPerformOrderReqDto childOrder = this.createChildOrder(splitOrderTransferReqDto, initOrderStatus, initOmsOrderStatus, (DgSplitChildOrderReqDto)splitChildOrderReqDto);
            this.copyOrderAddress(shipmentOrderInfoEo.getId(), childOrder.getId());
            List subIds = splitChildOrderReqDto.getOrderLineDtoList().stream().map(BaseDto::getId).collect(Collectors.toList());
            List<DgPerformOrderItemLineEo> orderItemList = itemLineDtoList.stream().filter(item -> subIds.contains(item.getOrderLineId())).collect(Collectors.toList());
            List<DgPerformOrderItemLineAmountDto> subAmountDtoList = amountDtoList.stream().filter(e -> orderItemList.stream().map(BaseEo::getId).collect(Collectors.toList()).contains(e.getOrderItemLineId())).collect(Collectors.toList());
            this.createChildOrderItem(childOrder, (DgSplitChildOrderReqDto)splitChildOrderReqDto, orderLineDtoList, orderItemList, subAmountDtoList, (List<Long>)upIdList);
            splitChildOrderList.add(childOrder);
        });
        List<DgPerformOrderLineDto> dgSplitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.toList());
        String initOrderStatus = reqDto.getInitOrderStatus();
        String initOmsOrderStatus = StringUtils.isNotBlank((CharSequence)reqDto.getInitOmsOrderStatus()) ? reqDto.getInitOmsOrderStatus() : reqDto.getOriOrderStatus();
        log.info("initOrderStatus:{},initOmsOrderStatus:{}", (Object)initOrderStatus, (Object)initOmsOrderStatus);
        DgPerformOrderReqDto childOrderForRemain = this.createChildOrderForRemain(shipmentOrderInfoEo, dgSplitOrderItemReqDtos, splitOrderTransferReqDto, initOrderStatus, initOmsOrderStatus, orderLineDtoList, itemLineDtoList, amountDtoList, upIdList);
        if (childOrderForRemain != null) {
            splitChildOrderList.add(childOrderForRemain);
        }
        ArrayList splitReleationEos = new ArrayList();
        ArrayList<DgPerformOrderRespDto> orderRespDtoList = new ArrayList<DgPerformOrderRespDto>();
        splitChildOrderList.forEach(req -> {
            log.info("\u5b50\u5355:{},\u8ba2\u5355\u72b6\u6001:{}", (Object)req.getSaleOrderNo(), (Object)req.getOrderStatus());
            DgPerformOrderRespDto resp = new DgPerformOrderRespDto();
            BeanCopyUtil.copyProperties((Object)req, (Object)resp);
            orderRespDtoList.add(resp);
            DgPerformOrderSplitReleationEo releationEo = new DgPerformOrderSplitReleationEo();
            releationEo.setOrderId(shipmentOrderInfoEo.getId());
            releationEo.setChildOrderId(req.getId());
            releationEo.setMainOrderId(mainOrderId);
            splitReleationEos.add(releationEo);
            DgPerformOrderInfoEo update = new DgPerformOrderInfoEo();
            update.setId(req.getId());
            update.setUpdateTime(new Date());
            this.performOrderInfoDomain.updateSelective((BaseEo)update);
            if (splitOrderTransferReqDto.getLastSaleOrderAuditEo() != null) {
                DgSaleOrderAuditEo lastSaleOrderAuditEo = splitOrderTransferReqDto.getLastSaleOrderAuditEo();
                DgSaleOrderAuditEo childOrderAuditEo = new DgSaleOrderAuditEo();
                CubeBeanUtils.copyProperties((Object)childOrderAuditEo, (Object)lastSaleOrderAuditEo, (String[])new String[0]);
                childOrderAuditEo.setId(null);
                childOrderAuditEo.setOrderId(req.getId());
                this.dgSaleOrderAuditDomain.saveSaleOrderAudit(req.getId(), childOrderAuditEo);
            }
        });
        this.performOrderSplitReleationDomain.insertBatch(splitReleationEos);
        return orderRespDtoList;
    }

    @Override
    public DgPerformOrderInfoEo checkSplitOrder(DgSplitOrderReqDto reqDto, List<DgPerformOrderLineDto> orderLineDtoList) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && reqDto.getSaleOrderId() == null) {
            throw new BizException(DgPcpTradeExceptionCode.ARGS_NOT_EMPTY.getCode(), "\u8ba2\u5355id\u548c\u8ba2\u5355code\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        DgPerformOrderInfoEo wrapperEo = new DgPerformOrderInfoEo();
        if (reqDto.getSaleOrderId() != null) {
            wrapperEo.setId(reqDto.getSaleOrderId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo())) {
            wrapperEo.setSaleOrderNo(reqDto.getSaleOrderNo());
        }
        DgPerformOrderInfoEo orderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDas.selectOne((BaseEo)wrapperEo);
        AssertUtils.notNull((Object)orderInfoEo, (String)"\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728\uff01");
        AssertUtils.notEmpty(orderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        List<DgPerformOrderLineDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, orderLineDtoList, reqDto.getOrderList().size());
        if (!canSplit.booleanValue()) {
            throw new BizException(DgPcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u6709\u8bef\uff01", orderInfoEo.getSaleOrderNo()));
        }
        Map<Long, BigDecimal> splitOrderItemCountMap = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.groupingBy(BaseDto::getId, Collectors.collectingAndThen(Collectors.toList(), item -> item.parallelStream().map(DgPerformOrderLineDto::getSplitItemNum).reduce(BigDecimal.ZERO, BigDecimal::add))));
        log.info("[\u624b\u5de5\u62c6\u5355]\u7edf\u8ba1\u6bcf\u4e2a\u5546\u54c1sku\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemCountMap));
        orderLineDtoList.forEach(orderItemLineDto -> {
            BigDecimal splitOrderItemCount = (BigDecimal)splitOrderItemCountMap.get(orderItemLineDto.getId());
            if (splitOrderItemCount != null && splitOrderItemCount.compareTo(orderItemLineDto.getCalcItemNum()) > 0) {
                log.error("[\u624b\u5de5\u62c6\u5355]\u62c6\u5355\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5546\u54c1saleOrderItemId={}\u8bf7\u6c42\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u539f\u8ba2\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{orderItemLineDto.getId(), splitOrderItemCount, orderItemLineDto.getItemNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
        });
        return orderInfoEo;
    }

    private Boolean checkSplitLegal(List<DgPerformOrderLineDto> splitOrderItemReqDtos, List<DgPerformOrderLineDto> orderItemLineDtoList, int splitOrderCount) {
        BigDecimal splitTotalItemCount = splitOrderItemReqDtos.stream().map(DgPerformOrderLineDto::getSplitItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oriOrderItemCount = orderItemLineDtoList.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (orderItemLineDtoList.size() == splitOrderItemReqDtos.size() && splitTotalItemCount.compareTo(oriOrderItemCount) == 0 && splitOrderCount == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public DgPerformOrderReqDto createChildOrder(DgSplitOrderTransferReqDto splitOrderTransferReqDto, String childOrderStatus, String initOmsOrderStatus, DgSplitChildOrderReqDto splitChildOrderReqDto) {
        DgPerformOrderReqDto childOrderVo = this.checkAndCreateChildOrder(splitOrderTransferReqDto, childOrderStatus, initOmsOrderStatus, splitChildOrderReqDto);
        this.omsOrderInfoDomain.createChildOrder(childOrderVo);
        return childOrderVo;
    }

    @Override
    public DgPerformOrderReqDto checkAndCreateChildOrder(DgSplitOrderTransferReqDto splitOrderTransferReqDto, String childOrderStatus, String initOmsOrderStatus, DgSplitChildOrderReqDto splitChildOrderReqDto) {
        Long childOrderId = IdGenrator.getDistributedId();
        log.info("[\u62c6\u5355]\u521b\u5efa\u5b50\u8ba2\u5355\uff0c\u5b50\u5355id\uff1a{}", (Object)childOrderId.toString());
        DgPerformOrderInfoEo childOrderEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)childOrderEo, (Object)splitOrderTransferReqDto.getShipmentOrderInfoEo(), (String[])new String[]{"id", "createTime", "updateTime", "orderStatus"});
        childOrderEo.setId(childOrderId);
        childOrderEo.setSaleOrderNo(this.performOrderNoGreateUtil.generateOrderNo());
        childOrderEo.setBizType(splitChildOrderReqDto.getBizType() != null ? splitChildOrderReqDto.getBizType() : splitOrderTransferReqDto.getShipmentOrderInfoEo().getBizType());
        childOrderEo.setOrderStatus(StringUtils.isNotBlank((CharSequence)childOrderStatus) ? childOrderStatus : splitChildOrderReqDto.getInitOrderStatus());
        childOrderEo.setOmsSaleOrderStatus(StringUtils.isNotBlank((CharSequence)initOmsOrderStatus) ? initOmsOrderStatus : splitChildOrderReqDto.getInitOmsOrderStatus());
        childOrderEo.setOrderSource(DgSaleOrderSourceEnum.SPLIT.getType());
        childOrderEo.setSaleCreateTime(new Date());
        log.info("[\u62c6\u5355]\u521b\u5efa\u5b50\u8ba2\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)childOrderEo));
        DgPerformOrderReqDto childOrderVo = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)childOrderVo, (Object)childOrderEo, (String[])new String[0]);
        if (splitOrderTransferReqDto.getShipmentPaymentEo() != null) {
            DgPerformOrderPaymentDto orderPaymentDto = DgBeanUtils.eo2Dto(splitOrderTransferReqDto.getShipmentPaymentEo(), DgPerformOrderPaymentDto.class);
            orderPaymentDto.setOrderId(childOrderId);
            childOrderVo.setPerformOrderPaymentDto(orderPaymentDto);
        }
        if (splitOrderTransferReqDto.getShipmentSnapshotEo() != null) {
            DgPerformOrderSnapshotDto orderSnapshotDto = DgBeanUtils.eo2Dto(splitOrderTransferReqDto.getShipmentSnapshotEo(), DgPerformOrderSnapshotDto.class);
            orderSnapshotDto.setOrderId(childOrderId);
            childOrderVo.setPerformOrderSnapshotDto(orderSnapshotDto);
        }
        if (splitOrderTransferReqDto.getShipmentExtensionEo() != null) {
            DgPerformOrderExtensionDto orderExtensionDto = DgBeanUtils.eo2Dto(splitOrderTransferReqDto.getShipmentExtensionEo(), DgPerformOrderExtensionDto.class);
            orderExtensionDto.setOrderId(childOrderId);
            childOrderVo.setPerformOrderExtensionDto(orderExtensionDto);
        }
        if (splitOrderTransferReqDto.getShipmentWarehouseInfoEo() != null) {
            DgPerformOrderWarehouseInfoDto orderWarehouseInfoDto = DgBeanUtils.eo2Dto(splitOrderTransferReqDto.getShipmentWarehouseInfoEo(), DgPerformOrderWarehouseInfoDto.class);
            orderWarehouseInfoDto.setOrderId(childOrderId);
            childOrderVo.setPerformOrderWarehouseInfoDto(orderWarehouseInfoDto);
        }
        if (splitOrderTransferReqDto.getShipmentAmountEo() != null) {
            DgPerformOrderAmountDto amountDto = DgBeanUtils.eo2Dto(splitOrderTransferReqDto.getShipmentAmountEo(), DgPerformOrderAmountDto.class);
            amountDto.setOrderId(childOrderId);
            childOrderVo.setPerformOrderAmountDto(amountDto);
        }
        return childOrderVo;
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySourceResult(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        List<List<DgOrderItemResultDto>> sourceOrderResultList = this.getSourceOrderResultList(respDto, sourceOrderResultRespDto, orderLineDtoList);
        this.sourceRecordDomain.saveSourceRecord(sourceOrderResultRespDto);
        return this.splitOrderBySourceResult(respDto, sourceOrderResultList, orderLineDtoList);
    }

    private List<DgPerformOrderRespDto> splitOrderBySourceResult(DgPerformOrderRespDto saleOrderRespDto, List<List<DgOrderItemResultDto>> sourceOrderResultList, List<DgPerformOrderLineDto> orderLineDtoList) {
        DgSplitOrderReqDto splitOrderReqDto = this.getSplitOrderReqDto(saleOrderRespDto, sourceOrderResultList);
        log.info("[\u62c6\u5355]\u4e00\u5355\u591a\u4ed3\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto, orderLineDtoList);
    }

    private void createChildOrderItem(DgPerformOrderReqDto childOrder, DgSplitChildOrderReqDto splitChildOrderReqDto, List<DgPerformOrderLineDto> orderItemLineDtoList, List<DgPerformOrderItemLineEo> subItemList, List<DgPerformOrderItemLineAmountDto> subAmountDtoList, List<Long> upIdList) {
        Map orderLineMap = orderItemLineDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        Map<Long, List<DgPerformOrderItemLineAmountDto>> amountItemLineMap = subAmountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountDto::getOrderItemLineId));
        log.info("\u62c6\u5355-\u91cd\u65b0\u5173\u8054\u8ba2\u5355\u884c\u5546\u54c1\u884c\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)splitChildOrderReqDto));
        LinkedList<DgPerformOrderLineEo> orderLineEos = new LinkedList<DgPerformOrderLineEo>();
        LinkedList<DgPerformOrderLineAmountEo> amountEos = new LinkedList<DgPerformOrderLineAmountEo>();
        ArrayList batchReleationInsertEoList = new ArrayList();
        for (DgPerformOrderLineDto splitOrderLineReqDto : splitChildOrderReqDto.getOrderLineDtoList()) {
            DgPerformOrderLineDto oldOrderLineDto = (DgPerformOrderLineDto)orderLineMap.get(splitOrderLineReqDto.getId());
            List subOrderItemList = subItemList.stream().filter(item -> item.getOrderLineId().equals(oldOrderLineDto.getId())).filter(item -> !upIdList.contains(item.getId())).collect(Collectors.toList());
            if (Objects.isNull(oldOrderLineDto) || CollectionUtil.isEmpty(subOrderItemList)) {
                log.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08orderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)oldOrderLineDto.getOrderId(), (Object)splitOrderLineReqDto.getSkuCode());
                AssertUtils.notNull((Object)oldOrderLineDto, (String)"\u539f\u8ba2\u5355\u8ba2\u5355\u884c\u4e0d\u5b58\u5728\uff01");
                AssertUtils.notNull(subOrderItemList, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u5b58\u5728\uff01");
            }
            if (oldOrderLineDto.getCalcItemNum().subtract(splitOrderLineReqDto.getSplitItemNum()).compareTo(BigDecimal.ZERO) < 0 || subOrderItemList.size() < splitOrderLineReqDto.getSplitItemNum().intValue()) {
                log.error("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355(skucode={})\u5269\u4f59\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{oldOrderLineDto.getSkuCode(), oldOrderLineDto.getCalcItemNum(), splitOrderLineReqDto.getSplitItemNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
            Long childOrderLineId = IdGenrator.getDistributedId();
            ArrayList amountList = new ArrayList();
            List<DgPerformOrderItemLineEo> updateOrderItemLineEos = subOrderItemList.subList(0, splitOrderLineReqDto.getSplitItemNum().intValue());
            updateOrderItemLineEos.forEach(orderItemLineEo -> {
                orderItemLineEo.setId(orderItemLineEo.getId());
                orderItemLineEo.setOrderId(childOrder.getId());
                orderItemLineEo.setOrderLineId(childOrderLineId);
                this.performOrderItemLineDomain.updateSelective((BaseEo)orderItemLineEo);
                OrderLineReleationItemLineEo orderLineReleationItemLineEo = new OrderLineReleationItemLineEo();
                orderLineReleationItemLineEo.setOrderLineId(childOrderLineId);
                orderLineReleationItemLineEo.setOrderItemLineId(orderItemLineEo.getId());
                batchReleationInsertEoList.add(orderLineReleationItemLineEo);
                amountList.addAll((Collection)amountItemLineMap.get(orderItemLineEo.getId()));
                upIdList.add(orderItemLineEo.getId());
            });
            List payAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_ORIG_PRICE.getCode())).collect(Collectors.toList());
            List realPayAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_ACTUAL_PRICE.getCode())).collect(Collectors.toList());
            List discountAmountList = amountList.stream().filter(a -> a.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_DISCOUNT_AMOUNT.getCode())).collect(Collectors.toList());
            DgPerformOrderLineEo splitOrderLineEo = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)splitOrderLineEo, (Object)oldOrderLineDto, (String[])new String[]{"id"});
            splitOrderLineEo.setId(childOrderLineId);
            splitOrderLineEo.setOrderId(childOrder.getId());
            splitOrderLineEo.setItemNum(splitOrderLineReqDto.getSplitItemNum());
            splitOrderLineEo.setCalcItemNum(splitOrderLineReqDto.getSplitItemNum());
            splitOrderLineEo.setSaleAmount(splitOrderLineReqDto.getSplitItemNum().multiply(splitOrderLineEo.getSalePrice()));
            BigDecimal payAmount = CollectionUtil.isNotEmpty(payAmountList) ? payAmountList.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            BigDecimal realPayAmount = CollectionUtil.isNotEmpty(realPayAmountList) ? realPayAmountList.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            BigDecimal discountAmount = CollectionUtil.isNotEmpty(discountAmountList) ? discountAmountList.stream().map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
            orderLineEos.add(splitOrderLineEo);
            DgPerformOrderLineAmountEo itemAmountEo = new DgPerformOrderLineAmountEo();
            itemAmountEo.setOrderId(childOrder.getId());
            itemAmountEo.setOrderLineId(childOrderLineId);
            itemAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
            itemAmountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
            DgPerformOrderLineAmountEo saleAmountEo = this.buildEo(itemAmountEo, DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode(), splitOrderLineReqDto.getSplitItemNum().multiply(splitOrderLineEo.getSalePrice()));
            amountEos.add(saleAmountEo);
            DgPerformOrderLineAmountEo payAmountEo = this.buildEo(itemAmountEo, DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode(), payAmount);
            amountEos.add(payAmountEo);
            DgPerformOrderLineAmountEo surpliusCanRefundPayAmountEo = this.buildEo(itemAmountEo, DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode(), payAmount);
            amountEos.add(surpliusCanRefundPayAmountEo);
            DgPerformOrderLineAmountEo realPayAmountEo = this.buildEo(itemAmountEo, DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode(), realPayAmount);
            amountEos.add(realPayAmountEo);
            DgPerformOrderLineAmountEo discountAmountEo = this.buildEo(itemAmountEo, DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode(), discountAmount);
            amountEos.add(discountAmountEo);
            log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5206\u6210\u529f\uff1a{}", (Object)JSON.toJSONString(orderLineEos));
        }
        this.performOrderLineDomain.insertBatch(orderLineEos);
        this.performOrderLineAmountDomain.insertBatch(amountEos);
        this.orderLineReleationItemLineDomain.insertBatch(batchReleationInsertEoList);
    }

    private void copyOrderAddress(Long oriSaleOrderId, Long childSaleOrderId) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrderId, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.performOrderAddrDomain.copyOrderAddress(oriSaleOrderId, childSaleOrderId);
    }

    private DgPerformOrderLineAmountEo buildEo(DgPerformOrderLineAmountEo eo, String accountType, BigDecimal amount) {
        DgPerformOrderLineAmountEo amountEo = new DgPerformOrderLineAmountEo();
        CubeBeanUtils.copyProperties((Object)amountEo, (Object)eo, (String[])new String[0]);
        amountEo.setAccountType(accountType);
        amountEo.setAmount(amount);
        return amountEo;
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySkus(DgSplitOrderBySkuReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getSaleOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)reqDto.getSkuCodeList(), (String)"skuCodeList \u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderLineDto> skuOrderLineDtoList = this.performOrderLineDomain.queryOrderLineDtoBySkuCodes(reqDto.getSaleOrderId(), reqDto.getSkuCodeList());
        AssertUtils.notEmpty(skuOrderLineDtoList, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
        Integer childOrderItemCountThreahold = skuOrderLineDtoList.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).intValue();
        if (reqDto.getSplitSkuNum() != null) {
            childOrderItemCountThreahold = reqDto.getSplitSkuNum();
        }
        ArrayList orderList = Lists.newArrayList();
        List dgSplitOrderItemReqDtos = skuOrderLineDtoList.stream().map(saleOrderItemRespDto -> {
            DgPerformOrderLineDto dgSplitOrderItemReqDto = new DgPerformOrderLineDto();
            dgSplitOrderItemReqDto.setId(saleOrderItemRespDto.getId());
            dgSplitOrderItemReqDto.setSplitItemNum(saleOrderItemRespDto.getItemNum());
            dgSplitOrderItemReqDto.setGiftFlag(saleOrderItemRespDto.getGiftFlag());
            return dgSplitOrderItemReqDto;
        }).collect(Collectors.toList());
        List partition = Lists.partition(dgSplitOrderItemReqDtos, (int)childOrderItemCountThreahold);
        partition.forEach(orderItemList -> {
            DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
            splitChildOrderReqDto.setOrderLineDtoList(orderItemList);
            orderList.add(splitChildOrderReqDto);
        });
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(reqDto.getSaleOrderId());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setOrderList((List)orderList);
        log.info("[\u6307\u5b9asku\u62c6\u5355]\u6307\u5b9asku\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        List<DgPerformOrderLineDto> orderLineDtoList = this.performOrderLineDomain.queryByOrderId(reqDto.getSaleOrderId());
        return this.splitOrder(splitOrderReqDto, orderLineDtoList);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByAppointResult(DgPerformOrderRespDto respDto, InventoryOperateRespDto inventoryOperateRespDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)inventoryOperateRespDto.getFailList())) {
            List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
            AssertUtils.notEmpty(orderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            if (inventoryOperateRespDto.getFailList().size() == orderLineDtoList.size()) {
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_BY_LACK_FAIL.builderException();
            }
            List skuCodeList = inventoryOperateRespDto.getFailList().stream().map(InventoryOperateCargoRespDto::getLongCode).collect(Collectors.toList());
            List splitOrderLineDtoList = orderLineDtoList.stream().filter(saleOrderItemRespDto -> skuCodeList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            List dgSplitOrderItemReqDtos = splitOrderLineDtoList.stream().map(saleOrderItemRespDto -> {
                DgPerformOrderLineDto dgSplitOrderItemReqDto = new DgPerformOrderLineDto();
                dgSplitOrderItemReqDto.setId(saleOrderItemRespDto.getId());
                dgSplitOrderItemReqDto.setSplitItemNum(saleOrderItemRespDto.getItemNum());
                dgSplitOrderItemReqDto.setGiftFlag(saleOrderItemRespDto.getGiftFlag());
                return dgSplitOrderItemReqDto;
            }).collect(Collectors.toList());
            DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
            splitChildOrderReqDto.setOrderLineDtoList(dgSplitOrderItemReqDtos);
            DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
            splitOrderReqDto.setSaleOrderId(respDto.getId());
            splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
            splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
            splitOrderReqDto.setOrderList((List)Lists.newArrayList((Object[])new DgSplitChildOrderReqDto[]{splitChildOrderReqDto}));
            log.info("[\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355]\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
            return this.splitOrder(splitOrderReqDto, orderLineDtoList);
        }
        log.warn("[\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u6ca1\u6709\u7f3a\u8d27\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        return null;
    }

    @Override
    public List<List<DgOrderItemResultDto>> getSourceOrderResultList(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto, List<DgPerformOrderLineDto> orderLineDtoList) {
        AssertUtils.notNull((Object)sourceOrderResultRespDto, (String)"\u5bfb\u6e90\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (String)"\u5bfb\u6e90\u7ed3\u679c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List linkOrderItemIds = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().map(DgOrderItemResultDto::getLinkOrderItemId).distinct().collect(Collectors.toList());
        orderLineDtoList = orderLineDtoList.stream().filter(item -> linkOrderItemIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList sourceOrderResultList = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)"ENABLE", (CharSequence)sourceOrderResultRespDto.getSeparateGiftSwitch())) {
            List itemGiftLists = orderLineDtoList.stream().filter(e -> e.getGiftFlag().equals(DgGiftEnum.GIFT.getType())).map(BaseDto::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(itemGiftLists)) {
                List sourceOrderResultGiftList = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().filter(result -> itemGiftLists.contains(result.getLinkOrderItemId())).collect(Collectors.toList());
                sourceOrderResultList.add(sourceOrderResultGiftList);
            }
            List sourceOrderResultDefaultList = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().filter(result -> !itemGiftLists.contains(result.getLinkOrderItemId())).collect(Collectors.toList());
            sourceOrderResultList.add(sourceOrderResultDefaultList);
        } else if (StringUtils.equals((CharSequence)"ENABLE", (CharSequence)sourceOrderResultRespDto.getItemQuantityDismantle())) {
            Map<String, List<DgOrderItemResultDto>> orderItemResultMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getDeliveryLogicWarehouseCode));
            orderItemResultMap.forEach((skuCode, orderItemList) -> sourceOrderResultList.add(orderItemList));
        } else {
            Map<String, List<DgOrderItemResultDto>> orderItemResultMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getDeliveryLogicWarehouseCode));
            orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemList) -> sourceOrderResultList.add(orderItemList));
        }
        return sourceOrderResultList;
    }

    @Override
    public DgSplitOrderReqDto getSplitOrderReqDto(DgPerformOrderRespDto saleOrderRespDto, List<List<DgOrderItemResultDto>> sourceOrderResultList) {
        ArrayList orderList = Lists.newArrayList();
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setSaleOrderId(saleOrderRespDto.getId());
        splitOrderReqDto.setPerformOrderRespDto(saleOrderRespDto);
        sourceOrderResultList.stream().filter(Objects::nonNull).forEach(sourceOrderResultRespDto -> {
            sourceOrderResultRespDto.stream().forEach(dto -> {
                if (Objects.isNull(dto.getDeliveryLogicWarehouseCode())) {
                    dto.setDeliveryLogicWarehouseCode(DEFAULT_SPLIT_LOGIC_WAREHOUSE);
                }
            });
            Map<String, List<DgOrderItemResultDto>> orderItemResultMap = sourceOrderResultRespDto.stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getDeliveryLogicWarehouseCode));
            orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemList) -> {
                DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
                if (!deliveryLogicWarehouseCode.equals(DEFAULT_SPLIT_LOGIC_WAREHOUSE)) {
                    DgSplitChildOrderReqDto.LogicWarehouse logicWarehouse = new DgSplitChildOrderReqDto.LogicWarehouse();
                    logicWarehouse.setDeliveryLogicWarehouseCode(deliveryLogicWarehouseCode);
                    logicWarehouse.setSgLogicWarehouseCode(deliveryLogicWarehouseCode);
                    splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
                }
                ArrayList splitOrderLineReqDtos = Lists.newArrayList();
                Map<Long, List<DgOrderItemResultDto>> linkOrderItemIdMap = orderItemList.stream().collect(Collectors.groupingBy(DgOrderItemResultDto::getLinkOrderItemId));
                linkOrderItemIdMap.forEach((itemId, itemList) -> {
                    DgOrderItemResultDto orderItemResultDto = (DgOrderItemResultDto)itemList.get(0);
                    BigDecimal deliveryItemNum = itemList.stream().map(DgOrderItemResultDto::getDeliveryItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
                    orderLineDto.setId(orderItemResultDto.getLinkOrderItemId());
                    orderLineDto.setSplitItemNum(deliveryItemNum);
                    orderLineDto.setDeliveryItemBatchNo(orderItemResultDto.getDeliveryItemBatchNo());
                    splitOrderLineReqDtos.add(orderLineDto);
                });
                AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)splitOrderLineReqDtos), (String)String.format("\u62c6\u5355\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
                splitChildOrderReqDto.setOrderLineDtoList((List)splitOrderLineReqDtos);
                orderList.add(splitChildOrderReqDto);
            });
        });
        splitOrderReqDto.setOrderList((List)orderList);
        return splitOrderReqDto;
    }

    @Override
    public DgPerformOrderInfoEo checkSplitOrder(DgSplitOrderReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && reqDto.getSaleOrderId() == null) {
            throw new BizException(DgPcpTradeExceptionCode.ARGS_NOT_EMPTY.getCode(), "\u8ba2\u5355id\u548c\u8ba2\u5355code\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        DgPerformOrderInfoEo wrapperEo = new DgPerformOrderInfoEo();
        if (reqDto.getSaleOrderId() != null) {
            wrapperEo.setId(reqDto.getSaleOrderId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo())) {
            wrapperEo.setSaleOrderNo(reqDto.getSaleOrderNo());
        }
        DgPerformOrderInfoEo shipmentInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDas.selectOne((BaseEo)wrapperEo);
        AssertUtils.notNull((Object)shipmentInfoEo, (String)"\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728\uff01");
        List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(shipmentInfoEo.getId());
        AssertUtils.notEmpty(orderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        List<DgPerformOrderLineDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, orderLineDtoList, reqDto.getOrderList().size());
        if (!canSplit.booleanValue()) {
            throw new BizException(DgPcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u6709\u8bef\uff01", shipmentInfoEo.getSaleOrderNo()));
        }
        Map<Long, BigDecimal> splitOrderItemCountMap = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getOrderLineDtoList).flatMap(Collection::stream).collect(Collectors.groupingBy(BaseDto::getId, Collectors.collectingAndThen(Collectors.toList(), item -> item.parallelStream().map(DgPerformOrderLineDto::getSplitItemNum).reduce(BigDecimal.ZERO, BigDecimal::add))));
        log.info("[\u624b\u5de5\u62c6\u5355]\u7edf\u8ba1\u6bcf\u4e2a\u5546\u54c1sku\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemCountMap));
        orderLineDtoList.forEach(saleOrderItemEo -> {
            BigDecimal splitOrderItemCount = (BigDecimal)splitOrderItemCountMap.get(saleOrderItemEo.getId());
            if (splitOrderItemCount != null && splitOrderItemCount.compareTo(saleOrderItemEo.getItemNum()) > 0) {
                log.error("[\u624b\u5de5\u62c6\u5355]\u62c6\u5355\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5546\u54c1saleOrderItemId={}\u8bf7\u6c42\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u539f\u8ba2\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{saleOrderItemEo.getId(), splitOrderItemCount, saleOrderItemEo.getItemNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
        });
        return shipmentInfoEo;
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByGift(Long saleOrderId) {
        List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        List<DgPerformOrderLineDto> giftOrderItemList = orderLineDtoList.stream().filter(saleOrderItemRespDto -> DgGiftEnum.GIFT.getType().equals(saleOrderItemRespDto.getGiftFlag())).collect(Collectors.toList());
        List<DgPerformOrderLineDto> noGiftOrderItemList = orderLineDtoList.stream().filter(saleOrderItemRespDto -> !DgGiftEnum.GIFT.getType().equals(saleOrderItemRespDto.getGiftFlag())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(giftOrderItemList)) {
            return new ArrayList<DgPerformOrderRespDto>();
        }
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        ArrayList splitChildOrderReqDtoList = Lists.newArrayList();
        ArrayList giftGoodsList = Lists.newArrayList();
        giftOrderItemList.forEach(item -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(item.getId());
            dgSplitOrderItemReqDto.setGoodsNum(item.getItemNum());
            dgSplitOrderItemReqDto.setIsGiftFlag(item.getGiftFlag());
            giftGoodsList.add(dgSplitOrderItemReqDto);
        });
        DgSplitChildOrderReqDto dgSplitChildOrderReqDto = new DgSplitChildOrderReqDto();
        dgSplitChildOrderReqDto.setGoodsList((List)giftGoodsList);
        splitChildOrderReqDtoList.add(dgSplitChildOrderReqDto);
        ArrayList noGiftGoodsList = Lists.newArrayList();
        noGiftOrderItemList.forEach(item -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(item.getId());
            dgSplitOrderItemReqDto.setGoodsNum(item.getItemNum());
            dgSplitOrderItemReqDto.setIsGiftFlag(item.getGiftFlag());
            noGiftGoodsList.add(dgSplitOrderItemReqDto);
        });
        DgSplitChildOrderReqDto dgSplitChildOrderReqDto2 = new DgSplitChildOrderReqDto();
        dgSplitChildOrderReqDto2.setGoodsList((List)noGiftGoodsList);
        splitChildOrderReqDtoList.add(dgSplitChildOrderReqDto2);
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(saleOrderId);
        splitOrderReqDto.setInitOmsOrderStatus(performOrderRespDto.getOmsSaleOrderStatus());
        splitOrderReqDto.setInitOrderStatus(performOrderRespDto.getOrderStatus());
        splitOrderReqDto.setOrderList((List)splitChildOrderReqDtoList);
        splitOrderReqDto.getOrderList().forEach(order -> {
            ArrayList splitOrderLineList = new ArrayList();
            order.getGoodsList().forEach(good -> {
                DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
                orderLineDto.setId(good.getOriginalOrderGoodsId());
                orderLineDto.setItemId(good.getGoodsId());
                orderLineDto.setItemCode(good.getGoodsCode());
                orderLineDto.setSkuCode(good.getGoodsSku());
                orderLineDto.setSplitItemNum(good.getGoodsNum());
                orderLineDto.setGiftFlag(good.getIsGiftFlag());
                splitOrderLineList.add(orderLineDto);
            });
            order.setOrderLineDtoList(splitOrderLineList);
        });
        log.info("[\u8d60\u54c1\u62c6\u5355]\u8d60\u54c1\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto, orderLineDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        List<Long> orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgPerformOrderAmountEo> orderAmountEos = this.performOrderAmountDomain.selectByOrderIds(orderIdList);
        Map orderAmountMap = orderAmountEos.stream().collect(Collectors.toMap(DgPerformOrderAmountEo::getOrderId, Function.identity(), (a, b) -> a));
        log.info("\u8ba2\u5355ID\u96c6\u5408:{}", (Object)JSON.toJSONString(orderIdList));
        List<DgPerformOrderLineDto> orderLineDtos = this.performOrderLineDomain.queryByOrderIds(orderIdList);
        AssertUtils.notEmpty(orderLineDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<DgPerformOrderLineDto>> orderLineMap = orderLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
        for (Map.Entry<Long, List<DgPerformOrderLineDto>> map : orderLineMap.entrySet()) {
            log.info("\u5b50\u8ba2\u5355ID:{}", (Object)map.getKey());
            log.info("\u5b50\u8ba2\u5355\u8ba2\u5355\u884cID\u96c6\u5408:{}", map.getValue().stream().map(BaseDto::getId).collect(Collectors.toList()));
        }
        List<DgPerformOrderLineAmountDto> orderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderIds(orderIdList);
        Map<Long, List<DgPerformOrderLineAmountDto>> orderLineAmountMap = orderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderId));
        log.info("orderLineAmountDtos:{}", (Object)JSON.toJSONString(orderLineAmountMap));
        childOrderList.forEach(childSaleOrderRespDto -> {
            log.info("\u5b50\u8ba2\u5355ID:{}", (Object)childSaleOrderRespDto.getId());
            List saleOrderLineList = (List)orderLineMap.get(childSaleOrderRespDto.getId());
            List orderLineAmounts = (List)orderLineAmountMap.get(childSaleOrderRespDto.getId());
            log.info("orderLineAmounts:{}", (Object)JSON.toJSONString((Object)orderLineAmounts));
            BigDecimal goodsTotalNum = saleOrderLineList.stream().map(DgPerformOrderLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal goodsTotalAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal realPayAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal discountAmount = orderLineAmounts.stream().filter(e -> e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal merchantReceivableAmount = goodsTotalAmount.subtract(discountAmount);
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u603b\u91d1\u989d\uff1a{}, \u5b9e\u4ed8\u603b\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{},\u5e94\u6536\u603b\u91d1\u989d\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, realPayAmount, discountAmount, merchantReceivableAmount});
            DgPerformOrderInfoEo modifyReqEo = new DgPerformOrderInfoEo();
            modifyReqEo.setId(childSaleOrderRespDto.getId());
            modifyReqEo.setGoodsTotalNum(goodsTotalNum);
            modifyReqEo.setGoodsTotalAmount(goodsTotalAmount);
            modifyReqEo.setPayAmount(payAmount);
            modifyReqEo.setRealPayAmount(realPayAmount);
            modifyReqEo.setDiscountAmount(discountAmount);
            modifyReqEo.setMerchantReceivableAmount(merchantReceivableAmount);
            this.performOrderInfoDomain.updateSelective((BaseEo)modifyReqEo);
            DgPerformOrderAmountEo orderAmountEo = (DgPerformOrderAmountEo)orderAmountMap.get(childSaleOrderRespDto.getId());
            DgPerformOrderAmountEo modifyAmountReqEo = new DgPerformOrderAmountEo();
            modifyAmountReqEo.setId(orderAmountEo.getId());
            modifyAmountReqEo.setGoodsTotalNum(goodsTotalNum);
            modifyAmountReqEo.setGoodsTotalAmount(goodsTotalAmount);
            modifyAmountReqEo.setPayAmount(payAmount);
            modifyAmountReqEo.setRealPayAmount(realPayAmount);
            modifyAmountReqEo.setDiscountAmount(discountAmount);
            modifyAmountReqEo.setMerchantReceivableAmount(merchantReceivableAmount);
            this.performOrderAmountDomain.updateSelective((BaseEo)modifyAmountReqEo);
        });
    }
}

