/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.inventory.api.baseorder.IInOutNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.constants.CsLogicWarehousePropertyEnum;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DgBaseOrderAddressAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.baseorder.GenerateInNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.entity.DgInOutOrderGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderTriggerReqExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderSalesRefundDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderSalesRefundReqDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.IDgB2CAfterSaleOrderAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.IDgB2CAfterSaleOrderSaveAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.IDgAfterSaleOrderLableAction;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundInterceptStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleFlagEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderGoodsItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderGoodsItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderGoodsItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgB2CAfterSaleOrderAction
implements IDgB2CAfterSaleOrderAction {
    private static final Logger log = LoggerFactory.getLogger(DgB2CAfterSaleOrderAction.class);
    private static final String log_prefix = "afterSaleOrderAction";
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private IDgAfterSaleOrderLableAction dgAfterSaleOrderLableAction;
    @Resource
    private IDgAfterSaleOrderService dgAfterSaleOrderService;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterSaleOrderGoodsItemService dgAfterSaleOrderGoodsItemService;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain dgOmsOrderInfoDomain;
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private IInOutNoticeOrderApi inOutNoticeOrderApi;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgB2CAfterSaleOrderSaveAction dgB2CAfterSaleOrderSaveAction;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumAndAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        updateEo.setRefundedPayAmount(BigDecimal.ZERO);
        updateEo.setSurplusCanRefundPayAmount(BigDecimal.ZERO);
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        updateEo.setRefundedItemNum(BigDecimal.ZERO);
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
    };

    @Override
    @Transactional
    public RestResponse<Long> create(DgAfterSaleOrderDto addDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        log.info("{}_create addDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)addDto));
        log.info("{}_create itemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemReqDtoList));
        List shItemList = itemReqDtoList.stream().filter(i -> i.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
        for (DgAfterSaleOrderItemModifyReqDto shItem : shItemList) {
            if (shItem.getOrigPayAmount() != null) continue;
            shItem.setOrigPayAmount(BigDecimal.ZERO);
        }
        BigDecimal origPayAmount = shItemList.stream().map(DgAfterSaleOrderItemReqDto::getOrigPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        addDto.setOrigPayAmount(origPayAmount);
        if (addDto.getRelateToPlatformOrder() != null && addDto.getRelateToPlatformOrder() == 0) {
            return this.dgB2CAfterSaleOrderSaveAction.create(addDto, itemReqDtoList, null);
        }
        return this.dgB2CAfterSaleOrderSaveAction.noOrigOrderCreate(addDto, itemReqDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> update(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        log.info("{}_update afterSaleOrderReqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        log.info("{}_update itemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemReqDtoList));
        log.info("{}_update goodsItemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(goodsItemReqDtoList));
        if (afterSaleOrderRespDto.getId() == null || StringUtils.isEmpty((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            log.warn("\u552e\u540e\u5355\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f: {}", (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
            throw new BizException("\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f");
        }
        log.info("{}_update afterSaleOrderRespDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        this.dgB2CAfterSaleOrderSaveAction.update(afterSaleOrderRespDto, itemReqDtoList, goodsItemReqDtoList);
        return RestResponse.VOID;
    }

    public void batchInsertAfterSaleOrderItem(Long afterSaleId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        if (CollectionUtils.isNotEmpty(itemReqDtoList)) {
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (DgAfterSaleOrderItemModifyReqDto dgAfterSaleOrderItemModifyReqDto : itemReqDtoList) {
                dgAfterSaleOrderItemModifyReqDto.setAfterSaleOrderId(afterSaleId);
                dgAfterSaleOrderItemModifyReqDto.setId(null);
                Long itemId = this.dgAfterSaleOrderItemService.addAfterSaleOrderItem((DgAfterSaleOrderItemReqDto)dgAfterSaleOrderItemModifyReqDto);
                idMap.put(dgAfterSaleOrderItemModifyReqDto.getSaleOrderItemId(), itemId);
            }
            if (CollectionUtils.isNotEmpty(goodsItemReqDtoList)) {
                ArrayList batchInsertDtoList = Lists.newArrayList();
                for (DgAfterSaleOrderGoodsItemReqDto goodsItemReqDto : goodsItemReqDtoList) {
                    goodsItemReqDto.setAfterSaleOrderId(afterSaleId);
                    goodsItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    goodsItemReqDto.setAfterSaleOrderItemId((Long)idMap.get(goodsItemReqDto.getLinkSaleOrderItemId()));
                    batchInsertDtoList.add(goodsItemReqDto);
                    if (batchInsertDtoList.size() < BATCH_INSERT_THRESHOLD) continue;
                    ArrayList<DgAfterSaleOrderGoodsItemEo> dgAfterSaleOrderGoodsItemEoList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, dgAfterSaleOrderGoodsItemEoList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(dgAfterSaleOrderGoodsItemEoList);
                    batchInsertDtoList = Lists.newArrayList();
                }
                if (CollectionUtils.isNotEmpty((Collection)batchInsertDtoList)) {
                    ArrayList<DgAfterSaleOrderGoodsItemEo> arrayList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, arrayList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(arrayList);
                }
            }
        }
    }

    @Override
    @Transactional
    public RestResponse<Void> audit(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<String> send2wmsByChild(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_send2wmsByChild afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        InventoryOrderSalesRefundReqDto reqDto = new InventoryOrderSalesRefundReqDto();
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        reqDto.setTotalInventory(new BigDecimal(itemRespDtoList.stream().map(DgAfterSaleOrderItemDto::getReturnNum).reduce(Integer::sum).orElseThrow(() -> new BizException("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"))));
        reqDto.setSourceNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        boolean ifTheoreticalReturn = false;
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderRespDto.getReturnWarehouseCode())) {
            LogicalWarehouseRespDto logicalWarehouse = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(afterSaleOrderRespDto.getReturnWarehouseCode()));
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)logicalWarehouse), (String)("\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + afterSaleOrderRespDto.getReturnWarehouseCode()));
            log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)logicalWarehouse));
            if (CsLogicWarehousePropertyEnum.THEORETICAL_RETURN.getCode().equals(logicalWarehouse.getWarehouseProperty())) {
                ifTheoreticalReturn = true;
            }
        }
        boolean finalIfTheoreticalReturn = ifTheoreticalReturn;
        List operateCargoReqDtoList = itemRespDtoList.stream().map(itemDto -> {
            InventoryOrderSalesRefundDetailReqDto operateCargoReqDto = new InventoryOrderSalesRefundDetailReqDto();
            operateCargoReqDto.setLongCode(itemDto.getSkuCode());
            operateCargoReqDto.setBatch(finalIfTheoreticalReturn ? afterSaleOrderRespDto.getPlatformRefundOrderSn() : itemDto.getBatchNo());
            operateCargoReqDto.setWarehouseCode(itemDto.getRefundWarehouseCode());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemDto.getReturnNum()));
            operateCargoReqDto.setPreOrderItemId(itemDto.getId());
            return operateCargoReqDto;
        }).collect(Collectors.toList());
        reqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        ContactDto contactDto = new ContactDto();
        contactDto.setPhone(afterSaleOrderRespDto.getReturnRecipientPhone());
        contactDto.setContacts(afterSaleOrderRespDto.getReturnRecipient());
        contactDto.setReciveName(afterSaleOrderRespDto.getReturnRecipient());
        contactDto.setRecivePhone(afterSaleOrderRespDto.getReturnRecipientPhone());
        contactDto.setDetailAddress(afterSaleOrderRespDto.getReturnAddress());
        reqDto.setContactDto(contactDto);
        reqDto.setUnshippedReturn(afterSaleOrderRespDto.getUnshippedReturn());
        reqDto.setReturnBizType(afterSaleOrderRespDto.getReturnBizType());
        log.info("[\u9500\u552e\u9000\u786e\u8ba4]\u8bf7\u6c42\u5e93\u5b58\u4e2d\u5fc3\u9500\u552e\u9000\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List noticeOrderNoList = (List)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.orderSalesRefundConfirm(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)noticeOrderNoList)) {
            String dgOutNoticeOrderNo = (String)noticeOrderNoList.get(0);
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseOrderNo(dgOutNoticeOrderNo);
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            modifyReqDto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            modifyReqDto.setShippingName(afterSaleOrderRespDto.getShippingName());
            this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        throw new BizException("\u4e0b\u53d1\u5230WMS\u5931\u6557\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u5e93\u901a\u77e5\u5355");
    }

    @Override
    public RestResponse<String> send2wms(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_send2wms afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        return this.send2wms(afterSaleOrderRespDto, null);
    }

    @Override
    public RestResponse<Boolean> send2wmsVirtualWarehouse(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        log.info("{}_send2wmsVirtualWarehouse afterSaleOrderNo: {}, shippingInfo: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), JacksonUtil.toJson((Object)shippingInfo)});
        log.info("{}_send2wmsVirtualWarehouse respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (shippingInfo != null) {
            afterSaleOrderRespDto.setReturnShippingSn(shippingInfo.getShippingOrderNo());
            afterSaleOrderRespDto.setShippingCode(shippingInfo.getShippingCompanyCode());
            afterSaleOrderRespDto.setShippingName(shippingInfo.getShippingCompanyName());
        }
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        log.info("{}_send2wmsVirtualWarehouse itemRespDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemRespDtoList));
        DgInOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        log.info("{}_send2wmsVirtualWarehouse reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        GenerateInNoticeOrderRespDto response = (GenerateInNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderApi.generateInNoticeOrderReturnDto(reqDto));
        log.info("{}_send2wmsVirtualWarehouse response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if (Objects.nonNull(response)) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseOrderNo(response.getInNoticeOrderNo());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            modifyReqDto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            modifyReqDto.setShippingName(afterSaleOrderRespDto.getShippingName());
            this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
            return new RestResponse((Object)response.getSinceTheClosedLoop());
        }
        log.warn("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", JacksonUtil.toJson((Object)response));
    }

    @Override
    public RestResponse<String> send2wms(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        log.info("{}_send2wms afterSaleOrderNo: {}, shippingInfo: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), JacksonUtil.toJson((Object)shippingInfo)});
        log.info("{}_send2wms respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (shippingInfo != null) {
            afterSaleOrderRespDto.setReturnShippingSn(shippingInfo.getShippingOrderNo());
            afterSaleOrderRespDto.setShippingCode(shippingInfo.getShippingCompanyCode());
            afterSaleOrderRespDto.setShippingName(shippingInfo.getShippingCompanyName());
        }
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        DgInOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        log.info("{}_send2wms reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        RestResponse response = this.inOutNoticeOrderApi.generateInNoticeOrder(reqDto);
        log.info("{}_send2wms response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if ("0".equals(response.getResultCode())) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseOrderNo((String)response.getData());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            modifyReqDto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            modifyReqDto.setShippingName(afterSaleOrderRespDto.getShippingName());
            this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        log.warn("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> send2wmsOutReturn(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelFromWms(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_cancelFromWms afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_cancelFromWms respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (!StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRespDto.getStatus(), (CharSequence)DgAfterSaleOrderStatusEnum.WAIT_CHECK_GOODS.getCode()) && !StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRespDto.getStatus(), (CharSequence)DgAfterSaleOrderStatusEnum.WAIT_IN_WAREHOUSE.getCode())) {
            throw new BizException("\u53ea\u6709\u5f85\u9a8c\u8d27\u72b6\u6001\u7684\u552e\u540e\u5355\u53ef\u4ee5\u4eceWMS\u64a4\u56de");
        }
        RestResponse<Boolean> response = this.cancelFromWmsApi(afterSaleOrderRespDto);
        log.info("{}_cancelFromWms response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(response));
        if ("0".equals(response.getResultCode()) && ((Boolean)response.getData()).booleanValue()) {
            return RestResponse.VOID;
        }
        log.warn("WMS\u64a4\u56de\u5931\u6557: {}", (Object)JacksonUtil.toJson(response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> finishFromWms(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_cancelFromWms afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_cancelFromWms respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (!StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRespDto.getStatus(), (CharSequence)DgAfterSaleOrderStatusEnum.PART_IN_WAREHOUSE.getCode())) {
            throw new BizException("\u53ea\u6709\u90e8\u5206\u5165\u5e93\u72b6\u6001\u7684\u552e\u540e\u5355\u53ef\u4ee5\u6267\u884c\u5b8c\u7ed3\u64cd\u4f5c");
        }
        RestResponse<String> response = this.finishFromWmsApi(afterSaleOrderRespDto);
        log.info("{}_finishFromWms response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(response));
        return RestResponse.VOID;
    }

    private RestResponse<String> finishFromWmsApi(DgAfterSaleOrderRespDto respDto) {
        AssertUtils.notBlank((String)respDto.getInputWarehouseOrderNo(), (String)"\u5165\u5e93\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.inOutNoticeOrderApi.receiveNoticeOrderFinish(respDto.getInputWarehouseOrderNo());
    }

    @Override
    public RestResponse<String> confirm(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_confirm afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_confirm respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        DgInOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        RestResponse response = this.inOutNoticeOrderApi.generateInResultOrder(reqDto);
        log.info("{}_confirm response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if ("0".equals(response.getResultCode())) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseResultOrderNo((String)response.getData());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setLastChanged(new Date());
            this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        log.warn("\u9a8c\u8d27\u5931\u8d25: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> cancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderRefundStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderRefundStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderRefundStatus afterSaleOrderNo: {}, afterSaleOrderRefundStatus: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderRefundStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setRefundStatus(afterSaleOrderRefundStatus);
        if (StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRefundStatus, (CharSequence)DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode()) && afterSaleOrderRespDto.getLastChanged() == null) {
            afterSaleOrderReqDto.setLastChanged(new Date());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRefundStatus, (CharSequence)DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode()) && afterSaleOrderRespDto.getLastChanged() != null) {
            afterSaleOrderReqDto.setLastChanged(afterSaleOrderRespDto.getLastChanged());
        }
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderAbolishFlag(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderAbolishFlag) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderAbolishFlag afterSaleOrderNo: {}, afterSaleOrderAbolishFlag: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderAbolishFlag});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setAbolishFlag(afterSaleOrderAbolishFlag);
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderDeliveryStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderDeliveryStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderDeliveryStatus afterSaleOrderRespDto: {}, afterSaleOrderDeliveryStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), afterSaleOrderDeliveryStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setDeliveryStatus(afterSaleOrderDeliveryStatus);
        afterSaleOrderReqDto.setLastChanged(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderLastPlatformSyncStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String lastPlatformSyncStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderLastPlatformSyncStatus afterSaleOrderRespDto: {}, lastPlatformSyncStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), lastPlatformSyncStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setLastPlatformRefundSyncStatus(lastPlatformSyncStatus);
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderInWarehouseDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderInWarehouseDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setInWarehouseDate(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderCompleteDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCompleteDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setCompleteDate(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderActuallyAmount(Long afterSaleId) {
        this.dgAfterSaleOrderService.updateAfterSaleOrderActuallyAmount(afterSaleId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfsOrderDeliverySatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, Integer deliveryStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{},\u66f4\u65b0\u552e\u540e\u5355:{},\u53d1\u8d27\u72b6\u6001\u4e3a:{}", new Object[]{log_prefix, afterSaleOrderRespDto.getId(), deliveryStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setCancelStatus(deliveryStatus);
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderExchangeShippingInfo(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCancelStatus afterSaleOrderRespDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setExchangeExpressCode(afterSaleOrderRespDto.getExchangeExpressCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyCode(afterSaleOrderRespDto.getExchangeExpressCompanyCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyName(afterSaleOrderRespDto.getExchangeExpressCompanyName());
        afterSaleOrderReqDto.setExchangeSaleOrderId(afterSaleOrderRespDto.getExchangeSaleOrderId());
        afterSaleOrderReqDto.setExchangeSaleOrderNo(afterSaleOrderRespDto.getExchangeSaleOrderNo());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    private DgInOutOrderGenerateReqDto convert(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderItemRespDto> itemRespDtoList) {
        DgPerformOrderRespDto dgPerformOrderRespDto;
        List detailReqDtoList = itemRespDtoList.stream().map(itemRespDto -> {
            InOutOrderGenerateDetailReqDto detailReqDto = new InOutOrderGenerateDetailReqDto();
            detailReqDto.setItemPrice(itemRespDto.getItemPrice());
            detailReqDto.setSkuCode(itemRespDto.getSkuCode());
            detailReqDto.setQuantity(itemRespDto.getItemNum() == null ? BigDecimal.ZERO : BigDecimal.valueOf(itemRespDto.getItemNum().intValue()));
            detailReqDto.setSkuName(itemRespDto.getSkuName());
            detailReqDto.setTradeOrderItemId(itemRespDto.getId());
            detailReqDto.setTotalRefundAmount(itemRespDto.getRefundAmount());
            return detailReqDto;
        }).collect(Collectors.toList());
        DgBaseOrderAddressAddReqDto dgBaseOrderAddressAddReqDto = new DgBaseOrderAddressAddReqDto();
        if (respDto.getReturnRecipient() != null) {
            if (respDto.getReturnRecipient().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptContacts(respDto.getReturnRecipient());
            } else {
                dgBaseOrderAddressAddReqDto.setContacts(respDto.getReturnRecipient());
            }
        }
        if (respDto.getReturnRecipientPhone() != null) {
            if (respDto.getReturnRecipientPhone().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptPhone(respDto.getReturnRecipientPhone());
            } else {
                dgBaseOrderAddressAddReqDto.setPhone(respDto.getReturnRecipientPhone());
            }
        }
        if (respDto.getReturnAddress() != null) {
            if (respDto.getReturnAddress().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptDetailAddress(respDto.getReturnAddress());
            } else {
                dgBaseOrderAddressAddReqDto.setDetailAddress(respDto.getReturnAddress());
            }
        }
        dgBaseOrderAddressAddReqDto.setContactsType("consignee");
        dgBaseOrderAddressAddReqDto.setRemark(respDto.getInnerRemark());
        DgInOutOrderGenerateReqDto reqDto = new DgInOutOrderGenerateReqDto();
        if (StringUtils.isNotBlank((CharSequence)respDto.getSaleOrderNo()) && Objects.nonNull(dgPerformOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoByOrderNo(respDto.getSaleOrderNo())) && Objects.nonNull(dgPerformOrderRespDto.getLogicalWarehouseCode())) {
            reqDto.setOutLogicWarehouseCode(dgPerformOrderRespDto.getLogicalWarehouseCode());
        }
        reqDto.setSendPersonAddressInfo(dgBaseOrderAddressAddReqDto);
        reqDto.setDetailReqDtoList(detailReqDtoList);
        reqDto.setLogicWarehouseCode(respDto.getReturnWarehouseCode());
        reqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        reqDto.setPlatformOrderNo(respDto.getPlatformRefundOrderSn());
        reqDto.setShippingCode(respDto.getReturnShippingSn());
        reqDto.setShipmentEnterpriseCode(respDto.getShippingCode());
        reqDto.setShipmentEnterpriseName(respDto.getShippingName());
        reqDto.setBasicDataBusinessType(respDto.getBizType());
        reqDto.setShopCode(respDto.getShopCode());
        reqDto.setShopName(respDto.getShopName());
        reqDto.setOaidOrderSourceCode(respDto.getPlatformOrderNo());
        return reqDto;
    }

    private RestResponse<Boolean> cancelFromWmsApi(DgAfterSaleOrderRespDto respDto) {
        InOutOrderTriggerReqExtDto triggerReqDto = new InOutOrderTriggerReqExtDto();
        triggerReqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        triggerReqDto.setDocumentNo(respDto.getInputWarehouseOrderNo());
        triggerReqDto.setTriggerType("cancel");
        triggerReqDto.setDocumentType("in");
        triggerReqDto.setReleasePreempt(Boolean.valueOf(true));
        log.info("inOutNoticeOrderApi.triggerInOutOrder:{}", (Object)JSON.toJSONString((Object)triggerReqDto));
        return this.inOutNoticeOrderApi.triggerInOutOrder(triggerReqDto);
    }

    @Override
    public RestResponse<Void> updateSaleOrderItemStatusByAfterSaleOrderItem(Long afterSaleId, String refundStatus, List<String> statusSet) {
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        DgSaleOrderItemRefundStatusEnum saleOrderItemRefundStatusEnum = DgSaleOrderItemRefundStatusEnum.forCode((String)refundStatus);
        List<DgAfterSaleOrderItemRespDto> orderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        AssertUtils.notEmpty(orderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        DgPerformOrderRespDto saleOrderRespDto = this.commonOrderQueryService.querySaleOrderById(afterSaleOrderRespDto.getSaleOrderId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        DgBizPerformOrderItemReqDto bizSaleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
        bizSaleOrderItemReqDto.setRefundStatus(saleOrderItemRefundStatusEnum.getCode());
        bizSaleOrderItemReqDto.setQueryUpdateRefundStatusList(statusSet);
        bizSaleOrderItemReqDto.setQueryUpdateStatusList(Collections.singletonList(DgSaleOrderItemStatusEnum.NORMAL.getCode()));
        bizSaleOrderItemReqDto.setUpdateOrderItemList(new ArrayList());
        orderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(dto -> {
            DgBizPerformOrderItemReqDto saleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
            saleOrderItemReqDto.setId(dto.getSaleOrderItemId());
            saleOrderItemReqDto.setItemNum(new BigDecimal(dto.getItemNum()));
            bizSaleOrderItemReqDto.getUpdateOrderItemList().add(saleOrderItemReqDto);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateRefundInterceptStatus2SuccessByOrderItem(Long saleOrder, String refundInterceptStatus) {
        return null;
    }

    @Override
    public RestResponse<Void> subSaleOrderItemNumAndAmount(Long afterSaleId, int calcType) {
        Consumer<DgAfterSaleOrderItemRespDto> consumer;
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        AssertUtils.notEmpty(afterSaleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        switch (calcType) {
            case 1: {
                consumer = this.calculateNumConsumer;
                break;
            }
            case 2: {
                consumer = this.calculateAmountConsumer;
                break;
            }
            default: {
                consumer = this.calculateNumAndAmountConsumer;
            }
        }
        afterSaleOrderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(consumer);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> subSaleOrderItemInvoiceNumAndAmount(Long afterSaleId, int calcType, DgAfterSaleOrderStatusEnum afterSaleOrderStatus) {
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        bizAfterSaleOrderReqDto.setSaleOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
        bizAfterSaleOrderReqDto.setStatus(afterSaleOrderStatus.getCode());
        List<DgAfterSaleOrderRespDto> afterSaleOrderRespDtoList = this.dgAfterSaleOrderService.queryByBizAfterSaleOrderReqDto(bizAfterSaleOrderReqDto);
        AssertUtils.notEmpty(afterSaleOrderRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        List idList = afterSaleOrderRespDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        DgBizAfterSaleOrderItemReqDto bizAfterSaleOrderItemReqDto = new DgBizAfterSaleOrderItemReqDto();
        bizAfterSaleOrderItemReqDto.setAfterSaleOrderIds(idList);
        bizAfterSaleOrderItemReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
        List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(bizAfterSaleOrderItemReqDto);
        AssertUtils.notEmpty(afterSaleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        Map<Long, List<DgAfterSaleOrderItemRespDto>> afterSaleOrderItemMaps = afterSaleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getSaleOrderItemId));
        log.info("\u5546\u54c1\u884c\u5f00\u7968\u8ba1\u7b97\u76f8\u5173\u552e\u540e\u5355:{}", (Object)JSON.toJSONString(afterSaleOrderItemMaps));
        afterSaleOrderItemMaps.entrySet().stream().forEach(e -> {
            DgPerformOrderItemExtensionEo updateEo = new DgPerformOrderItemExtensionEo();
            if (calcType == 1) {
                Integer itemNum = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getItemNum).reduce(Integer::sum).orElse(0);
                if (itemNum != null && itemNum > 0) {
                    updateEo.setInvoiceRefundedItemNum(new BigDecimal(itemNum));
                }
                updateEo.setInvoiceRefundedPayAmount(BigDecimal.ZERO);
            } else if (calcType == 2) {
                BigDecimal refundAmount = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (refundAmount != null && refundAmount.compareTo(BigDecimal.ZERO) > 0) {
                    updateEo.setInvoiceRefundedPayAmount(refundAmount);
                }
                updateEo.setInvoiceRefundedItemNum(BigDecimal.ZERO);
            } else if (calcType == 3) {
                BigDecimal refundAmount;
                updateEo.setInvoiceRefundedPayAmount(BigDecimal.ZERO);
                updateEo.setInvoiceRefundedItemNum(BigDecimal.ZERO);
                Integer itemNum = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getItemNum).reduce(Integer::sum).orElse(0);
                if (itemNum != null && itemNum > 0) {
                    updateEo.setInvoiceRefundedItemNum(new BigDecimal(itemNum));
                }
                if ((refundAmount = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add)) != null && refundAmount.compareTo(BigDecimal.ZERO) > 0) {
                    updateEo.setInvoiceRefundedPayAmount(refundAmount);
                }
            }
            log.info("\u5546\u54c1\u884c\u5f00\u7968\u76f8\u5173\u91d1\u989d\u6216\u6570\u91cf-orderId:{},orderItemId:{},updateEo:{}", new Object[]{((DgAfterSaleOrderItemRespDto)((List)e.getValue()).get(0)).getSaleOrderId(), e.getKey(), JSON.toJSONString((Object)updateEo)});
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyShipping(Long afterSaleId, DgAfterSaleOrderDto request) {
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u9000\u8d27\u7269\u6d41-afterSaleId:{},request{}", (Object)afterSaleId, (Object)JSON.toJSONString((Object)request));
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleId);
        modifyReqDto.setShippingCode(request.getShippingCode());
        modifyReqDto.setReturnShippingSn(request.getReturnShippingSn());
        modifyReqDto.setShippingName(request.getShippingName());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(modifyReqDto);
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyAfterSaleFlag(Long afterSaleId, DgAfterSaleFlagEnum afterSaleFlag) {
        log.info("\u66f4\u65b0\u552e\u540e\u6807\u8bc6\u7c7b\u578b-afterSaleId:{},afterSaleFlag:{}", (Object)afterSaleFlag, (Object)JSON.toJSONString((Object)afterSaleFlag));
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleId);
        modifyReqDto.setAfterSaleFlag(afterSaleFlag.getCode());
        if (DgAfterSaleFlagEnum.HH_TO_THTK.equals((Object)afterSaleFlag) || DgAfterSaleFlagEnum.THTK_TO_JTK.equals((Object)afterSaleFlag)) {
            modifyReqDto.setBizType(DgSaleOrderBizTypeEnum.PTDT.getCode());
        }
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptChannelInventory(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderService.preemptChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> translateChannelInventory(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderService.translateChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgBizAfterSaleOrderReqDto> convertAfterSaleOrderType(DgAfterSaleOrderRespDto respDto, AfterSaleOrderTypeEnum orderType) {
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(respDto.getId());
        AssertUtils.notNull((Object)dgAfterSaleOrderRespDto, (String)"\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        dgAfterSaleOrderRespDto.setStatus(DgAfterSaleOrderStatusEnum.ABOLISH.getCode());
        this.updateAfterSaleOrderLastPlatformSyncStatus(dgAfterSaleOrderRespDto, dgAfterSaleOrderRespDto.getLastPlatformRefundSyncStatus());
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        if (Objects.isNull(respDto)) {
            throw new BizException("\u8f6c\u6362\u552e\u540e\u5355\u4e8b\u4ef6\u5931\u8d25:{}", JSON.toJSONString((Object)respDto));
        }
        CubeBeanUtils.copyProperties((Object)bizAfterSaleOrderReqDto, (Object)respDto, (String[])new String[]{"id", "afterSaleOrderNo", "updateTime", "createTime", "createPerson"});
        bizAfterSaleOrderReqDto.setPaymentName(respDto.getReturnRecipient());
        bizAfterSaleOrderReqDto.setPaymentPhone(respDto.getReturnRecipientPhone());
        bizAfterSaleOrderReqDto.setAfterSaleOrderType(orderType.getCode());
        bizAfterSaleOrderReqDto.setStatus(DgAfterSaleOrderStatusEnum.WAIT_AUDIT.getCode());
        List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSale(respDto.getAfterSaleOrderNo(), "0");
        ArrayList dgAfterSaleOrderItemModifyReqDtos = new ArrayList();
        dgAfterSaleOrderItemRespDtos.forEach(dgAfterSaleOrderItemRespDto -> {
            dgAfterSaleOrderItemRespDto.setAfterSaleOrderId(null);
            dgAfterSaleOrderItemRespDto.setId(null);
        });
        CubeBeanUtils.copyCollection(dgAfterSaleOrderItemModifyReqDtos, dgAfterSaleOrderItemRespDtos, DgAfterSaleOrderItemModifyReqDto.class);
        log.info("\u8f6c\u6362\u540e\u552e\u540e\u5355\u5546\u54c1\u884c\u8bf7\u6c42 dgAfterSaleOrderItemModifyReqDtos:{}", (Object)JSON.toJSONString(dgAfterSaleOrderItemModifyReqDtos));
        bizAfterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(dgAfterSaleOrderItemModifyReqDtos);
        if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(orderType.getCode())) {
            this.dgAfterSaleOrderLableAction.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_THTK_TO_FHHTK);
        } else if (AfterSaleOrderTypeEnum.THTK.getCode().equals(orderType.getCode())) {
            this.dgAfterSaleOrderLableAction.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_HH_TO_THTK);
            if (bizAfterSaleOrderReqDto.getRelateToPlatformOrder() != null && bizAfterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
                bizAfterSaleOrderReqDto.setReturnRecipient(respDto.getExchangeRecipient());
                bizAfterSaleOrderReqDto.setReturnRecipientPhone(respDto.getExchangeRecipientPhone());
                bizAfterSaleOrderReqDto.setReturnCityCode(respDto.getExchangeCityCode());
                bizAfterSaleOrderReqDto.setReturnCityName(respDto.getExchangeCityName());
                bizAfterSaleOrderReqDto.setReturnProvinceCode(respDto.getExchangeProvinceCode());
                bizAfterSaleOrderReqDto.setReturnProvinceName(respDto.getExchangeProvinceName());
                bizAfterSaleOrderReqDto.setReturnCountyCode(respDto.getExchangeCountyCode());
                bizAfterSaleOrderReqDto.setReturnCountyName(respDto.getExchangeCountyName());
                bizAfterSaleOrderReqDto.setReturnAddress(respDto.getExchangeAddress());
            }
        }
        log.info("\u8f6c\u6362\u540e\u552e\u540e\u5355\u8bf7\u6c42 bizAfterSaleOrderReqDto:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        return new RestResponse((Object)bizAfterSaleOrderReqDto);
    }

    @Override
    public RestResponse<Void> updateRefundInterceptStatusByAfterSaleOrderItem(Long afterSaleId, String refundInterceptStatus) {
        return null;
    }

    @Override
    public RestResponse<Void> reCalculateSaleOrderNumAndAmount(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.dgPerformOrderInfoDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List orderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(saleOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderLineDtos), (String)"\u672a\u627e\u5230\u8ba2\u5355\u884c\u4fe1\u606f");
        List orderLineIds = orderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List orderItemLineDtos = this.orderLineReleationItemLineDomain.queryItemLineDtosByOrderLineIds(orderLineIds);
        List itemLineDtos = orderItemLineDtos.stream().filter(dto -> ItemLineCancelStatusEnum.NO.getType().equals(dto.getCancelStatus())).collect(Collectors.toList());
        Map<Long, List<DgPerformOrderItemLineDto>> itemLineMap = itemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal realPayAmount = BigDecimal.ZERO;
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(itemLineDtos)) {
            goodsTotalNum = itemLineDtos.stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            List orderItemLineIds = itemLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            List orderItemLineAmountEos = this.dgPerformOrderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountTypes(orderItemLineIds, Collections.singletonList(DgOmsOrderAmountTypeEnum.ITEM_ACTUAL_PRICE.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)orderItemLineAmountEos)) {
                payAmount = orderItemLineAmountEos.stream().map(DgPerformOrderItemLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            realPayAmount = payAmount;
            for (Map.Entry<Long, List<DgPerformOrderItemLineDto>> map : itemLineMap.entrySet()) {
                List<DgPerformOrderItemLineDto> value = map.getValue();
                for (DgPerformOrderItemLineDto dto2 : value) {
                    goodsTotalAmount = goodsTotalAmount.add(dto2.getSalePrice().multiply(dto2.getItemNum()));
                }
            }
            List discountOrderItemLineAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineAmountDomain.filter().eq((Object)"account_type", (Object)"TOTAL_DISCOUNT_AMOUNT")).in((Object)"order_item_line_id", orderItemLineIds)).list();
            if (CollectionUtils.isNotEmpty((Collection)discountOrderItemLineAmountEos)) {
                discountAmount = discountOrderItemLineAmountEos.stream().map(DgPerformOrderItemLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setGoodsTotalNum(goodsTotalNum);
        saleOrderReqDto.setMerchantReceivableAmount(BigDecimal.ZERO);
        saleOrderReqDto.setGoodsTotalAmount(goodsTotalAmount);
        saleOrderReqDto.setDiscountAmount(discountAmount == null ? BigDecimal.ZERO : discountAmount);
        saleOrderReqDto.setPayAmount(payAmount);
        saleOrderReqDto.setRealPayAmount(realPayAmount);
        log.info("\u91cd\u7b97\u4e4b\u540e\u8ba2\u5355\u5e94\u6536\u91d1\u989d\u4e3a:{}", (Object)payAmount);
        saleOrderReqDto.setMerchantReceivableAmount(saleOrderReqDto.getGoodsTotalAmount().add(saleOrderRespDto.getFreightCost()).subtract(saleOrderReqDto.getDiscountAmount()));
        if (!DgSaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            saleOrderReqDto.setMerchantOriginReceivableAmount(saleOrderReqDto.getMerchantReceivableAmount());
        }
        saleOrderReqDto.setId(saleOrderRespDto.getId());
        this.dgOmsOrderInfoDomain.update(saleOrderReqDto);
        DgPerformOrderPaymentEo dgPerformOrderPaymentEo = this.dgPerformOrderPaymentDomain.selectByOrderId(saleOrderRespDto.getId());
        dgPerformOrderPaymentEo.setRemainingPayAmount(payAmount);
        this.dgPerformOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> relateSaleOrderItemInventory(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List orderItemLineDtos = this.orderLineReleationItemLineDomain.queryItemLineDtoBySaleOrderId(saleOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderItemLineDtos), (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5173\u8054\u7684\u5546\u54c1\u884c\u4fe1\u606f");
        List itemLineDtos = orderItemLineDtos.stream().filter(dto -> dto.getCancelStatus().equals(ItemLineCancelStatusEnum.NO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemLineDtos)) {
            return RestResponse.VOID;
        }
        Map<Long, List<DgPerformOrderItemLineDto>> orderLineIdMap = itemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        ArrayList orderLineDtoList = Lists.newArrayList();
        for (Map.Entry<Long, List<DgPerformOrderItemLineDto>> map : orderLineIdMap.entrySet()) {
            DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
            BigDecimal itemNum = map.getValue().stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLineDto.setSkuCode(map.getValue().get(0).getSkuCode());
            orderLineDto.setItemNum(itemNum);
            orderLineDtoList.add(orderLineDto);
        }
        Boolean relateResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!relateResult.booleanValue()) {
            throw new BizException("-1", "\u5e93\u5b58\u91ca\u653e/\u91cd\u65b0\u9884\u5360\u5931\u8d25");
        }
        return RestResponse.VOID;
    }

    private boolean isJTKCancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgSaleOrderItemRefundInterceptStatusEnum saleOrderItemRefundInterceptStatusEnum) {
        return AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) && DgSaleOrderItemRefundInterceptStatusEnum.SUCCESS.getCode().equals(saleOrderItemRefundInterceptStatusEnum.getCode());
    }
}

