/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.aftersale.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.api.baseorder.IInOutNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DgBaseOrderAddressAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.DgInOutOrderGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderTriggerReqExtDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgOutResultOrderDetailApiProxy;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.IDgB2CAfterSaleOrderSaveAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.IDgAfterSaleOrderLableAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.common.IDgAfterSaleOrderOptAction;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundInterceptStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderGoodsItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemSnRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineReturnStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderGoodsItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderGoodsItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderOptAction
implements IDgAfterSaleOrderOptAction {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderOptAction.class);
    private static final String log_prefix = "afterSaleOrderAction";
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private IDgAfterSaleOrderLableAction dgAfterSaleOrderLableAction;
    @Resource
    private IDgAfterSaleOrderService dgAfterSaleOrderService;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterSaleOrderGoodsItemService dgAfterSaleOrderGoodsItemService;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain dgOmsOrderInfoDomain;
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private IInOutNoticeOrderApi inOutNoticeOrderApi;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgB2CAfterSaleOrderSaveAction dgB2CAfterSaleOrderSaveAction;
    @Resource
    private DgAfterSaleOrderOptAction dgAfterSaleOrderOptAction;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgOutResultOrderDetailApiProxy dgOutResultOrderDetailApiProxy;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumAndAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        updateEo.setRefundedPayAmount(BigDecimal.ZERO);
        updateEo.setSurplusCanRefundPayAmount(BigDecimal.ZERO);
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        updateEo.setRefundedItemNum(BigDecimal.ZERO);
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
    };

    @Override
    @Transactional
    public RestResponse<Long> create(DgAfterSaleOrderDto addDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        List shItemList = itemReqDtoList.stream().filter(i -> i.getAfterSaleOrderItemType().equals(AfterSaleOrderItemTypeEnum.SH.getType())).collect(Collectors.toList());
        for (DgAfterSaleOrderItemModifyReqDto shItem : shItemList) {
            if (shItem.getOrigPayAmount() != null) continue;
            shItem.setOrigPayAmount(BigDecimal.ZERO);
        }
        if (DgSaleOrderSourceEnum.PLATFORM.getType().equals(addDto.getOrderSource())) {
            this.fillSnCode(itemReqDtoList);
        }
        this.initTransferField(addDto);
        BigDecimal origPayAmount = shItemList.stream().map(DgAfterSaleOrderItemReqDto::getOrigPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        addDto.setOrigPayAmount(origPayAmount);
        if (addDto.getRelateToPlatformOrder() != null && addDto.getRelateToPlatformOrder() == 0) {
            return this.dgB2CAfterSaleOrderSaveAction.create(addDto, itemReqDtoList, null);
        }
        return this.dgB2CAfterSaleOrderSaveAction.noOrigOrderCreate(addDto, itemReqDtoList);
    }

    private void initTransferField(DgAfterSaleOrderDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getShopCode())) {
            DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
            reqDto.setUseSettlementWarehouse(Integer.valueOf(1));
            reqDto.setStoreCode(addReqDto.getShopCode());
            reqDto.setStatusList(Collections.singletonList(1));
            List list = (List)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.queryListShop(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                addReqDto.setIsSettledTransfer(YesOrNoEnum.NO.getType());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> update(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        if (afterSaleOrderRespDto.getId() == null || StringUtils.isEmpty((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            log.warn("\u552e\u540e\u5355\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f: {}", (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
            throw new BizException("\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f");
        }
        this.dgB2CAfterSaleOrderSaveAction.update(afterSaleOrderRespDto, itemReqDtoList, goodsItemReqDtoList);
        return RestResponse.VOID;
    }

    public void batchInsertAfterSaleOrderItem(Long afterSaleId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        if (CollectionUtils.isNotEmpty(itemReqDtoList)) {
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (DgAfterSaleOrderItemModifyReqDto dgAfterSaleOrderItemModifyReqDto : itemReqDtoList) {
                dgAfterSaleOrderItemModifyReqDto.setAfterSaleOrderId(afterSaleId);
                dgAfterSaleOrderItemModifyReqDto.setId(null);
                Long itemId = this.dgAfterSaleOrderItemService.addAfterSaleOrderItem((DgAfterSaleOrderItemReqDto)dgAfterSaleOrderItemModifyReqDto);
                idMap.put(dgAfterSaleOrderItemModifyReqDto.getSaleOrderItemId(), itemId);
            }
            if (CollectionUtils.isNotEmpty(goodsItemReqDtoList)) {
                ArrayList batchInsertDtoList = Lists.newArrayList();
                for (DgAfterSaleOrderGoodsItemReqDto goodsItemReqDto : goodsItemReqDtoList) {
                    goodsItemReqDto.setAfterSaleOrderId(afterSaleId);
                    goodsItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    goodsItemReqDto.setAfterSaleOrderItemId((Long)idMap.get(goodsItemReqDto.getLinkSaleOrderItemId()));
                    batchInsertDtoList.add(goodsItemReqDto);
                    if (batchInsertDtoList.size() < BATCH_INSERT_THRESHOLD) continue;
                    ArrayList<DgAfterSaleOrderGoodsItemEo> dgAfterSaleOrderGoodsItemEoList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, dgAfterSaleOrderGoodsItemEoList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(dgAfterSaleOrderGoodsItemEoList);
                    batchInsertDtoList = Lists.newArrayList();
                }
                if (CollectionUtils.isNotEmpty((Collection)batchInsertDtoList)) {
                    ArrayList<DgAfterSaleOrderGoodsItemEo> arrayList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, arrayList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(arrayList);
                }
            }
        }
    }

    @Override
    public RestResponse<String> confirm(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_confirm afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_confirm respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        DgInOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        RestResponse response = this.inOutNoticeOrderApi.generateInResultOrder(reqDto);
        log.info("{}_confirm response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if ("0".equals(response.getResultCode())) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseResultOrderNo((String)response.getData());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setLastChanged(new Date());
            this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        log.warn("\u9a8c\u8d27\u5931\u8d25: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> cancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderRefundStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderRefundStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderRefundStatus afterSaleOrderNo: {}, afterSaleOrderRefundStatus: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderRefundStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setRefundStatus(afterSaleOrderRefundStatus);
        afterSaleOrderReqDto.setLastChanged(afterSaleOrderRespDto.getLastChanged());
        if (StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRefundStatus, (CharSequence)DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode()) && afterSaleOrderReqDto.getLastChanged() == null) {
            afterSaleOrderReqDto.setLastChanged(new Date());
        }
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderAbolishFlag(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderAbolishFlag) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderAbolishFlag afterSaleOrderNo: {}, afterSaleOrderAbolishFlag: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderAbolishFlag});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setAbolishFlag(afterSaleOrderAbolishFlag);
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderDeliveryStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderDeliveryStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderDeliveryStatus afterSaleOrderRespDto: {}, afterSaleOrderDeliveryStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), afterSaleOrderDeliveryStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setDeliveryStatus(afterSaleOrderDeliveryStatus);
        afterSaleOrderReqDto.setLastChanged(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderLastPlatformSyncStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String lastPlatformSyncStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderLastPlatformSyncStatus afterSaleOrderRespDto: {}, lastPlatformSyncStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), lastPlatformSyncStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setLastPlatformRefundSyncStatus(lastPlatformSyncStatus);
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderDomain.queryById(afterSaleOrderRespDto.getId());
        if ((Objects.equals(dgAfterSaleOrderRespDto.getStatus(), AfterSaleOrderStatusEnum.WAIT_AUDIT.getCode()) || Objects.equals(dgAfterSaleOrderRespDto.getStatus(), AfterSaleOrderStatusEnum.WAIT_RETURN.getCode()) || Objects.equals(dgAfterSaleOrderRespDto.getStatus(), AfterSaleOrderStatusEnum.WAIT_CHECK_GOODS.getCode())) && StringUtils.isNotBlank((CharSequence)afterSaleOrderRespDto.getReturnShippingSn()) && !Objects.equals(dgAfterSaleOrderRespDto.getReturnShippingSn(), afterSaleOrderRespDto.getReturnShippingSn())) {
            DgAfterSaleOrderDto dto = new DgAfterSaleOrderDto();
            dto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            dto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            dto.setShippingName(afterSaleOrderRespDto.getShippingName());
            dto.setLogisticsStatus(afterSaleOrderRespDto.getLogisticsStatus());
            this.dgAfterSaleOrderOptAction.modifyShipping(afterSaleOrderRespDto.getId(), dto);
        }
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderInWarehouseDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderInWarehouseDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setInWarehouseDate(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderInWarehouseDate(Long afterSaleId, Date inWarehouseDate) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderInWarehouseDate afterSaleId: {},inWarehouseDate:{}", new Object[]{log_prefix, afterSaleId, inWarehouseDate});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setInWarehouseDate(inWarehouseDate);
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderCompleteDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCompleteDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setCompleteDate(new Date());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateSaleOrderItemLineComplete(Long afterSaleId) {
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderDomain.queryById(afterSaleId);
        List dgAfterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAfterSaleOrderItemEo.class).eq(DgAfterSaleOrderItemEo::getAfterSaleOrderId, (Object)afterSaleId)).eq(DgAfterSaleOrderItemEo::getAfterSaleOrderItemType, (Object)AfterSaleOrderItemTypeEnum.SH.getType())).eq(BaseEo::getDr, (Object)0));
        Long saleOrderId = dgAfterSaleOrderRespDto.getSaleOrderId();
        if (Objects.isNull(saleOrderId)) {
            return RestResponse.VOID;
        }
        List dgPerformOrderItemLineEos = this.dgPerformOrderItemLineDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgPerformOrderItemLineEo.class).eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemLineEo::getAfterSaleOrderItemId, (Collection)dgAfterSaleOrderItemEos.stream().map(BaseEo::getId).collect(Collectors.toList()))).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.YES.getType())).eq(DgPerformOrderItemLineEo::getRefundStatus, (Object)DgSaleOrderItemRefundStatusEnum.NORMAL.getCode())).eq(DgPerformOrderItemLineEo::getReturnStatus, (Object)ItemLineReturnStatusEnum.NO.getType()));
        dgPerformOrderItemLineEos.forEach(eo -> {
            eo.setRefundStatus(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode());
            eo.setReturnStatus(ItemLineReturnStatusEnum.YES.getType());
            this.dgPerformOrderItemLineDomain.updateSelective((BaseEo)eo);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfsOrderDeliverySatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, Integer deliveryStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{},\u66f4\u65b0\u552e\u540e\u5355:{},\u53d1\u8d27\u72b6\u6001\u4e3a:{}", new Object[]{log_prefix, afterSaleOrderRespDto.getId(), deliveryStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setCancelStatus(deliveryStatus);
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderExchangeShippingInfo(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCancelStatus afterSaleOrderRespDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setExchangeExpressCode(afterSaleOrderRespDto.getExchangeExpressCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyCode(afterSaleOrderRespDto.getExchangeExpressCompanyCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyName(afterSaleOrderRespDto.getExchangeExpressCompanyName());
        afterSaleOrderReqDto.setExchangeSaleOrderId(afterSaleOrderRespDto.getExchangeSaleOrderId());
        afterSaleOrderReqDto.setExchangeSaleOrderNo(afterSaleOrderRespDto.getExchangeSaleOrderNo());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    private DgInOutOrderGenerateReqDto convert(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderItemRespDto> itemRespDtoList) {
        DgPerformOrderRespDto dgPerformOrderRespDto;
        List detailReqDtoList = itemRespDtoList.stream().map(itemRespDto -> {
            InOutOrderGenerateDetailReqDto detailReqDto = new InOutOrderGenerateDetailReqDto();
            detailReqDto.setItemPrice(itemRespDto.getItemPrice());
            detailReqDto.setSkuCode(itemRespDto.getSkuCode());
            detailReqDto.setQuantity(itemRespDto.getItemNum() == null ? BigDecimal.ZERO : BigDecimal.valueOf(itemRespDto.getItemNum().intValue()));
            detailReqDto.setSkuName(itemRespDto.getSkuName());
            detailReqDto.setTradeOrderItemId(itemRespDto.getId());
            detailReqDto.setTotalRefundAmount(itemRespDto.getRefundAmount());
            return detailReqDto;
        }).collect(Collectors.toList());
        DgBaseOrderAddressAddReqDto dgBaseOrderAddressAddReqDto = new DgBaseOrderAddressAddReqDto();
        if (respDto.getReturnRecipient() != null) {
            if (respDto.getReturnRecipient().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptContacts(respDto.getReturnRecipient());
            } else {
                dgBaseOrderAddressAddReqDto.setContacts(respDto.getReturnRecipient());
            }
        }
        if (respDto.getReturnRecipientPhone() != null) {
            if (respDto.getReturnRecipientPhone().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptPhone(respDto.getReturnRecipientPhone());
            } else {
                dgBaseOrderAddressAddReqDto.setPhone(respDto.getReturnRecipientPhone());
            }
        }
        if (respDto.getReturnAddress() != null) {
            if (respDto.getReturnAddress().contains("*")) {
                dgBaseOrderAddressAddReqDto.setEncryptDetailAddress(respDto.getReturnAddress());
            } else {
                dgBaseOrderAddressAddReqDto.setDetailAddress(respDto.getReturnAddress());
            }
        }
        dgBaseOrderAddressAddReqDto.setContactsType("consignee");
        dgBaseOrderAddressAddReqDto.setRemark(respDto.getInnerRemark());
        DgInOutOrderGenerateReqDto reqDto = new DgInOutOrderGenerateReqDto();
        if (StringUtils.isNotBlank((CharSequence)respDto.getSaleOrderNo()) && Objects.nonNull(dgPerformOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoByOrderNo(respDto.getSaleOrderNo())) && Objects.nonNull(dgPerformOrderRespDto.getLogicalWarehouseCode())) {
            reqDto.setOutLogicWarehouseCode(dgPerformOrderRespDto.getLogicalWarehouseCode());
        }
        reqDto.setSendPersonAddressInfo(dgBaseOrderAddressAddReqDto);
        reqDto.setDetailReqDtoList(detailReqDtoList);
        reqDto.setLogicWarehouseCode(respDto.getReturnWarehouseCode());
        reqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        reqDto.setPlatformOrderNo(respDto.getPlatformRefundOrderSn());
        reqDto.setShippingCode(respDto.getReturnShippingSn());
        reqDto.setShipmentEnterpriseCode(respDto.getShippingCode());
        reqDto.setShipmentEnterpriseName(respDto.getShippingName());
        reqDto.setBasicDataBusinessType(respDto.getBizType());
        reqDto.setShopCode(respDto.getShopCode());
        reqDto.setShopName(respDto.getShopName());
        reqDto.setOaidOrderSourceCode(respDto.getPlatformOrderNo());
        return reqDto;
    }

    private RestResponse<Boolean> cancelFromWmsApi(DgAfterSaleOrderRespDto respDto) {
        InOutOrderTriggerReqExtDto triggerReqDto = new InOutOrderTriggerReqExtDto();
        triggerReqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        triggerReqDto.setDocumentNo(respDto.getInputWarehouseOrderNo());
        triggerReqDto.setTriggerType("cancel");
        triggerReqDto.setDocumentType("in");
        triggerReqDto.setReleasePreempt(Boolean.valueOf(true));
        log.info("inOutNoticeOrderApi.triggerInOutOrder:{}", (Object)JSON.toJSONString((Object)triggerReqDto));
        return this.inOutNoticeOrderApi.triggerInOutOrder(triggerReqDto);
    }

    @Override
    public RestResponse<Void> updateSaleOrderItemStatusByAfterSaleOrderItem(Long afterSaleId, String refundStatus, List<String> statusSet) {
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        DgSaleOrderItemRefundStatusEnum saleOrderItemRefundStatusEnum = DgSaleOrderItemRefundStatusEnum.forCode((String)refundStatus);
        List<DgAfterSaleOrderItemRespDto> orderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        AssertUtils.notEmpty(orderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        DgPerformOrderRespDto saleOrderRespDto = this.commonOrderQueryService.querySaleOrderById(afterSaleOrderRespDto.getSaleOrderId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        DgBizPerformOrderItemReqDto bizSaleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
        bizSaleOrderItemReqDto.setRefundStatus(saleOrderItemRefundStatusEnum.getCode());
        bizSaleOrderItemReqDto.setQueryUpdateRefundStatusList(statusSet);
        bizSaleOrderItemReqDto.setQueryUpdateStatusList(Collections.singletonList(DgSaleOrderItemStatusEnum.NORMAL.getCode()));
        bizSaleOrderItemReqDto.setUpdateOrderItemList(new ArrayList());
        orderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(dto -> {
            DgBizPerformOrderItemReqDto saleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
            saleOrderItemReqDto.setId(dto.getSaleOrderItemId());
            saleOrderItemReqDto.setItemNum(new BigDecimal(dto.getItemNum()));
            bizSaleOrderItemReqDto.getUpdateOrderItemList().add(saleOrderItemReqDto);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyShipping(Long afterSaleId, DgAfterSaleOrderDto request) {
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u9000\u8d27\u7269\u6d41-afterSaleId:{},request{}", (Object)afterSaleId, (Object)JSON.toJSONString((Object)request));
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleId);
        modifyReqDto.setShippingCode(request.getShippingCode());
        modifyReqDto.setReturnShippingSn(request.getReturnShippingSn());
        modifyReqDto.setShippingName(request.getShippingName());
        modifyReqDto.setLogisticsStatus(request.getLogisticsStatus());
        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(modifyReqDto);
        this.dgAfterSaleOrderBasicOptAction.modifyLogiscticWarehouseInfo(modifyReqDto);
        this.dgAfterSaleOrderBasicOptAction.logicDeleteAndSaveReturnShippingSnList(afterSaleId, request.getReturnShippingSn());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptChannelInventory(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderService.preemptChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> translateChannelInventory(DgAfterSaleOrderRespDto respDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.dgAfterSaleOrderService.translateChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgBizAfterSaleOrderReqDto> convertAfterSaleOrderType(DgAfterSaleOrderRespDto respDto, AfterSaleOrderTypeEnum orderType) {
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderBasicQueryOptAction.queryById(respDto.getId());
        AssertUtils.notNull((Object)dgAfterSaleOrderRespDto, (String)"\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        dgAfterSaleOrderRespDto.setStatus(DgAfterSaleOrderStatusEnum.ABOLISH.getCode());
        this.updateAfterSaleOrderLastPlatformSyncStatus(dgAfterSaleOrderRespDto, dgAfterSaleOrderRespDto.getLastPlatformRefundSyncStatus());
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        if (Objects.isNull(respDto)) {
            throw new BizException("\u8f6c\u6362\u552e\u540e\u5355\u4e8b\u4ef6\u5931\u8d25:{}", JSON.toJSONString((Object)respDto));
        }
        CubeBeanUtils.copyProperties((Object)bizAfterSaleOrderReqDto, (Object)dgAfterSaleOrderRespDto, (String[])new String[]{"id", "afterSaleOrderNo", "updateTime", "createPerson"});
        bizAfterSaleOrderReqDto.setPaymentName(respDto.getReturnRecipient());
        bizAfterSaleOrderReqDto.setPaymentPhone(respDto.getReturnRecipientPhone());
        bizAfterSaleOrderReqDto.setAfterSaleOrderType(orderType.getCode());
        bizAfterSaleOrderReqDto.setStatus(DgAfterSaleOrderStatusEnum.WAIT_AUDIT.getCode());
        bizAfterSaleOrderReqDto.setLastChanged((Date)ObjectUtils.defaultIfNull((Object)dgAfterSaleOrderRespDto.getLastChanged(), (Object)respDto.getLastChanged()));
        List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSale(respDto.getAfterSaleOrderNo(), "0");
        ArrayList dgAfterSaleOrderItemModifyReqDtos = new ArrayList();
        dgAfterSaleOrderItemRespDtos.forEach(dgAfterSaleOrderItemRespDto -> {
            dgAfterSaleOrderItemRespDto.setAfterSaleOrderId(null);
            dgAfterSaleOrderItemRespDto.setId(null);
        });
        CubeBeanUtils.copyCollection(dgAfterSaleOrderItemModifyReqDtos, dgAfterSaleOrderItemRespDtos, DgAfterSaleOrderItemModifyReqDto.class);
        log.info("\u8f6c\u6362\u540e\u552e\u540e\u5355\u5546\u54c1\u884c\u8bf7\u6c42 dgAfterSaleOrderItemModifyReqDtos:{}", (Object)JSON.toJSONString(dgAfterSaleOrderItemModifyReqDtos));
        bizAfterSaleOrderReqDto.setAfterSaleOrderItemReqDtoList(dgAfterSaleOrderItemModifyReqDtos);
        if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(orderType.getCode())) {
            this.dgAfterSaleOrderLableAction.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_THTK_TO_FHHTK);
        } else if (AfterSaleOrderTypeEnum.THTK.getCode().equals(orderType.getCode())) {
            this.dgAfterSaleOrderLableAction.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_HH_TO_THTK);
            if (bizAfterSaleOrderReqDto.getRelateToPlatformOrder() != null && bizAfterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
                bizAfterSaleOrderReqDto.setReturnRecipient(respDto.getExchangeRecipient());
                bizAfterSaleOrderReqDto.setReturnRecipientPhone(respDto.getExchangeRecipientPhone());
                bizAfterSaleOrderReqDto.setReturnCityCode(respDto.getExchangeCityCode());
                bizAfterSaleOrderReqDto.setReturnCityName(respDto.getExchangeCityName());
                bizAfterSaleOrderReqDto.setReturnProvinceCode(respDto.getExchangeProvinceCode());
                bizAfterSaleOrderReqDto.setReturnProvinceName(respDto.getExchangeProvinceName());
                bizAfterSaleOrderReqDto.setReturnCountyCode(respDto.getExchangeCountyCode());
                bizAfterSaleOrderReqDto.setReturnCountyName(respDto.getExchangeCountyName());
                bizAfterSaleOrderReqDto.setReturnAddress(respDto.getExchangeAddress());
            }
        }
        log.info("\u8f6c\u6362\u540e\u552e\u540e\u5355\u8bf7\u6c42 bizAfterSaleOrderReqDto:{}", (Object)JSON.toJSONString((Object)bizAfterSaleOrderReqDto));
        return new RestResponse((Object)bizAfterSaleOrderReqDto);
    }

    @Override
    public RestResponse<Void> reCalculateSaleOrderNumAndAmount(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.dgPerformOrderInfoDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List orderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(saleOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderLineDtos), (String)"\u672a\u627e\u5230\u8ba2\u5355\u884c\u4fe1\u606f");
        List orderLineIds = orderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List orderItemLineDtos = this.orderLineReleationItemLineDomain.queryItemLineDtosByOrderLineIds(orderLineIds);
        List itemLineDtos = orderItemLineDtos.stream().filter(dto -> ItemLineCancelStatusEnum.NO.getType().equals(dto.getCancelStatus())).collect(Collectors.toList());
        Map<Long, List<DgPerformOrderItemLineDto>> itemLineMap = itemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal realPayAmount = BigDecimal.ZERO;
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(itemLineDtos)) {
            goodsTotalNum = itemLineDtos.stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            List orderItemLineIds = itemLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            List orderItemLineAmountEos = this.dgPerformOrderItemLineAmountDomain.queryByOrderItemLineIdsAndAmountTypes(orderItemLineIds, Collections.singletonList(DgOmsOrderAmountTypeEnum.ITEM_ACTUAL_PRICE.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)orderItemLineAmountEos)) {
                payAmount = orderItemLineAmountEos.stream().map(DgPerformOrderItemLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            realPayAmount = payAmount;
            for (Map.Entry<Long, List<DgPerformOrderItemLineDto>> map : itemLineMap.entrySet()) {
                List<DgPerformOrderItemLineDto> value = map.getValue();
                for (DgPerformOrderItemLineDto dto2 : value) {
                    goodsTotalAmount = goodsTotalAmount.add(dto2.getSalePrice().multiply(dto2.getItemNum()));
                }
            }
            List discountOrderItemLineAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineAmountDomain.filter().eq((Object)"account_type", (Object)"TOTAL_DISCOUNT_AMOUNT")).in((Object)"order_item_line_id", orderItemLineIds)).list();
            if (CollectionUtils.isNotEmpty((Collection)discountOrderItemLineAmountEos)) {
                discountAmount = discountOrderItemLineAmountEos.stream().map(DgPerformOrderItemLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setGoodsTotalNum(goodsTotalNum);
        saleOrderReqDto.setMerchantReceivableAmount(BigDecimal.ZERO);
        saleOrderReqDto.setGoodsTotalAmount(goodsTotalAmount);
        saleOrderReqDto.setDiscountAmount(discountAmount == null ? BigDecimal.ZERO : discountAmount);
        saleOrderReqDto.setPayAmount(payAmount);
        saleOrderReqDto.setRealPayAmount(realPayAmount);
        log.info("\u91cd\u7b97\u4e4b\u540e\u8ba2\u5355\u5e94\u6536\u91d1\u989d\u4e3a:{}", (Object)payAmount);
        saleOrderReqDto.setMerchantReceivableAmount(saleOrderReqDto.getGoodsTotalAmount().add(saleOrderRespDto.getFreightCost()).subtract(saleOrderReqDto.getDiscountAmount()));
        if (!DgSaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            saleOrderReqDto.setMerchantOriginReceivableAmount(saleOrderReqDto.getMerchantReceivableAmount());
        }
        saleOrderReqDto.setId(saleOrderRespDto.getId());
        this.dgOmsOrderInfoDomain.update(saleOrderReqDto);
        DgPerformOrderPaymentEo dgPerformOrderPaymentEo = this.dgPerformOrderPaymentDomain.selectByOrderId(saleOrderRespDto.getId());
        dgPerformOrderPaymentEo.setRemainingPayAmount(payAmount);
        this.dgPerformOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> relateSaleOrderItemInventory(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List orderItemLineDtos = this.orderLineReleationItemLineDomain.queryItemLineDtoBySaleOrderId(saleOrderId);
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderItemLineDtos), (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5173\u8054\u7684\u5546\u54c1\u884c\u4fe1\u606f");
        List itemLineDtos = orderItemLineDtos.stream().filter(dto -> dto.getCancelStatus().equals(ItemLineCancelStatusEnum.NO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemLineDtos)) {
            return RestResponse.VOID;
        }
        Map<Long, List<DgPerformOrderItemLineDto>> orderLineIdMap = itemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        ArrayList orderLineDtoList = Lists.newArrayList();
        for (Map.Entry<Long, List<DgPerformOrderItemLineDto>> map : orderLineIdMap.entrySet()) {
            DgPerformOrderLineDto orderLineDto = new DgPerformOrderLineDto();
            BigDecimal itemNum = map.getValue().stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderLineDto.setSkuCode(map.getValue().get(0).getSkuCode());
            orderLineDto.setItemNum(itemNum);
            orderLineDtoList.add(orderLineDto);
        }
        Boolean relateResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemLineChange(orderLineDtoList, saleOrderRespDto);
        if (!relateResult.booleanValue()) {
            throw new BizException("-1", "\u5e93\u5b58\u91ca\u653e/\u91cd\u65b0\u9884\u5360\u5931\u8d25");
        }
        return RestResponse.VOID;
    }

    private boolean isJTKCancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgSaleOrderItemRefundInterceptStatusEnum saleOrderItemRefundInterceptStatusEnum) {
        return AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) && DgSaleOrderItemRefundInterceptStatusEnum.SUCCESS.getCode().equals(saleOrderItemRefundInterceptStatusEnum.getCode());
    }

    private void fillSnCode(List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
        Set saleOrderItemIdList = itemReqDtoList.stream().map(DgAfterSaleOrderItemReqDto::getSaleOrderItemId).collect(Collectors.toSet());
        DgOutResultOrderDetailPageReqDto reqDto = new DgOutResultOrderDetailPageReqDto();
        reqDto.setPreOrderItemIdList((List)Lists.newArrayList(saleOrderItemIdList));
        List dgOutResultOrderDetailDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgOutResultOrderDetailApiProxy.queryList(reqDto));
        if (CollUtil.isNotEmpty((Collection)dgOutResultOrderDetailDtoList)) {
            Map listMap = dgOutResultOrderDetailDtoList.stream().collect(Collectors.groupingBy(DgOutResultOrderDetailDto::getPreOrderItemId, Collectors.toList()));
            for (DgAfterSaleOrderItemModifyReqDto dto : itemReqDtoList) {
                if (!listMap.containsKey(dto.getSaleOrderItemId())) continue;
                ArrayList snRecordDtoList = Lists.newArrayList();
                for (DgOutResultOrderDetailDto dgOutResultOrderDetailDto : listMap.get(dto.getSaleOrderItemId())) {
                    if (!StrUtil.isNotBlank((CharSequence)dgOutResultOrderDetailDto.getSnCode())) continue;
                    for (String s : dgOutResultOrderDetailDto.getSnCode().split(",")) {
                        DgAfterSaleOrderItemSnRecordDto snRecordDto = new DgAfterSaleOrderItemSnRecordDto();
                        snRecordDto.setSnCode(s);
                        snRecordDto.setSaleOrderItemId(dto.getSaleOrderItemId());
                        snRecordDtoList.add(snRecordDto);
                    }
                    dto.setSnRecordDtoList((List)snRecordDtoList);
                }
            }
        }
    }
}

