/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreate;
import com.yunxi.dg.base.center.trade.action.oms.channel.Impl.ChannelAbstractOrderCreate;
import com.yunxi.dg.base.center.trade.constants.DgGoodItemDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgReceiveOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgShopOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelActiveService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelBasicInfoService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCalculatorService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelCustomerService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelFeeControlService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelInventoryService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelItemService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelShopService;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="channelIntactOrderCreateImpl")
public class ChannelIntactOrderCreateImpl
extends ChannelAbstractOrderCreate
implements IChannelOrderCreate {
    private static final Logger log = LoggerFactory.getLogger(ChannelIntactOrderCreateImpl.class);
    @Resource
    private IChannelCustomerService channelCustomerService;
    @Resource
    private IChannelShopService channelShopService;
    @Resource
    private IChannelBasicInfoService channelBasicInfoService;
    @Resource
    private IChannelActiveService channelActiveService;
    @Resource
    private IChannelAccountService channelCostAccountService;
    @Resource(name="channelIntactItemServiceImpl")
    private IChannelItemService channelItemService;
    @Resource
    private IChannelCalculatorService channelCalculatorService;
    @Resource
    private IChannelFeeControlService channelFeeControlService;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IChannelInventoryService channelInventoryService;
    @Resource
    private NoGreateUtil noGreateUtil;

    @Override
    public DgF2BOrderPreviewContext execute(DgOrderPreviewReqDto previewReqDto) {
        return null;
    }

    @Override
    public DgOrderResultRespDto saveExecute(DgOrderReqDto dgOrderReqDto) {
        DgOrderPreviewReqDto previewReqDto = this.channelBasicInfoService.checkAndTransformIntactOrderData(dgOrderReqDto);
        DgF2BOrderContextVo f2BOrderContextVo = new DgF2BOrderContextVo();
        f2BOrderContextVo.setPreviewReqDto(previewReqDto);
        f2BOrderContextVo.setPerformOrderAddrItemDtos(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getAddrItemDtos());
        DgF2BOrderPreviewContext f2BOrderPreviewContext = new DgF2BOrderPreviewContext();
        f2BOrderPreviewContext.setOrderType(previewReqDto.getOrderType());
        f2BOrderPreviewContext.setBizModel(DgPerformOrderBizModelEnum.F2B_ORDER.getCode());
        this.channelCustomerService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        String saleOrderNo = Optional.ofNullable(dgShopOrderReqDto.getSaleOrderNo()).orElse(this.noGreateUtil.generateF2BNo(DgReceiveOrderTypeEnum.enumOf((String)dgShopOrderReqDto.getOrderType()).getOrderNoPrefix(), Integer.valueOf(5)));
        ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setSaleOrderNo(saleOrderNo);
        this.channelBasicInfoService.supplementIntactOrderSnapshotDtoInfo(f2BOrderContextVo, f2BOrderPreviewContext, dgOrderReqDto);
        this.channelItemService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelFeeControlService.supplementAndCheckInfo(f2BOrderContextVo, f2BOrderPreviewContext);
        this.channelCalculatorService.calcOrderBasicAmount(f2BOrderPreviewContext);
        this.channelCalculatorService.dealHandmadeDiscount(f2BOrderPreviewContext);
        this.channelBasicInfoService.supplementExtraIntactInfo(f2BOrderContextVo, f2BOrderPreviewContext, dgOrderReqDto);
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = this.buildDgBizPerformOrderReqDto(f2BOrderPreviewContext.getDgF2BPerformOrderReqDto(), (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0), f2BOrderPreviewContext);
        DgShopOrderResultRespDto resultRespDto = this.channelOrderService.saveOrder(dgBizPerformOrderReqDto);
        DgOrderResultRespDto dgOrderResultRespDto = new DgOrderResultRespDto();
        dgOrderResultRespDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderResultRespDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderResultRespDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        ArrayList<DgShopOrderResultRespDto> dgShopOrderResultRespDtos = new ArrayList<DgShopOrderResultRespDto>();
        dgShopOrderResultRespDtos.add(resultRespDto);
        dgOrderResultRespDto.setShopOrderResultRespDtos(dgShopOrderResultRespDtos);
        dgOrderResultRespDto.setDgBizPerformOrderReqDto(dgBizPerformOrderReqDto);
        return dgOrderResultRespDto;
    }

    @Override
    public DgOrderResultRespDto saveAfterExecute(DgOrderResultRespDto resultRespDto, DgOrderReqDto dgOrderReqDto) {
        return super.saveAfterExecute(resultRespDto, dgOrderReqDto);
    }

    private DgBizPerformOrderReqDto buildDgBizPerformOrderReqDto(DgF2BPerformOrderReqDto f2BPerformOrderReqDto, DgShopOrderReqDto dgShopOrderReqDto, DgF2BOrderPreviewContext dgF2BOrderPreviewContext) {
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        BeanUtil.copyProperties((Object)f2BPerformOrderReqDto, (Object)dgBizPerformOrderReqDto, (String[])new String[0]);
        dgBizPerformOrderReqDto.setId(dgShopOrderReqDto.getId());
        dgBizPerformOrderReqDto.setBizModel(dgF2BOrderPreviewContext.getBizModel());
        dgBizPerformOrderReqDto.setOrderType(dgF2BOrderPreviewContext.getOrderType());
        dgBizPerformOrderReqDto.setBizType(dgF2BOrderPreviewContext.getOrderType());
        dgBizPerformOrderReqDto.setRemark(dgShopOrderReqDto.getRemark());
        dgBizPerformOrderReqDto.setDeliveryDate(dgShopOrderReqDto.getDeliveryDate());
        dgBizPerformOrderReqDto.setSaleOrderNo(dgShopOrderReqDto.getSaleOrderNo());
        dgBizPerformOrderReqDto.setSubmitFlag(dgF2BOrderPreviewContext.getDefPreviewOpt() == 2);
        dgBizPerformOrderReqDto.setDeliveryStatus(DgGoodItemDeliveryStatusEnum.WAIT_DELIVERY.getCode());
        dgBizPerformOrderReqDto.setDgOrderAmountDtos(dgF2BOrderPreviewContext.getDgOrderAmountDtos());
        dgBizPerformOrderReqDto.setOrderItemPriceDtos(dgF2BOrderPreviewContext.getOrderItemPriceDtos());
        dgBizPerformOrderReqDto.setOrderStatus(dgShopOrderReqDto.getOrderStatus());
        dgBizPerformOrderReqDto.setCreditFileNo(f2BPerformOrderReqDto.getCreditFileNo());
        dgBizPerformOrderReqDto.setOrderAddrReqDto(dgShopOrderReqDto.getOrderAddrReqDto());
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        performOrderPaymentDto.setPayStatus(Integer.valueOf(1));
        List itemList = BeanUtil.copyToList((Collection)f2BPerformOrderReqDto.getItemList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setItemList(itemList);
        performOrderPaymentDto.setTotalUseCostAmount(BigDecimal.ZERO);
        performOrderPaymentDto.setRemainingPayAmount(BigDecimal.ZERO);
        dgBizPerformOrderReqDto.setPerformOrderPaymentDto(performOrderPaymentDto);
        dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().setKneadeFlag(f2BPerformOrderReqDto.getKneadeFlag());
        dgBizPerformOrderReqDto.setAttachmentFileList(dgShopOrderReqDto.getAttachmentFileList());
        dgBizPerformOrderReqDto.setOrderAddrReqDtos(dgShopOrderReqDto.getOrderAddrReqDto() != null ? Lists.newArrayList((Object[])new DgPerformOrderAddrReqDto[]{dgShopOrderReqDto.getOrderAddrReqDto()}) : dgShopOrderReqDto.getOrderAddrReqDtos());
        dgBizPerformOrderReqDto.setOrderAddrReqDtoWaitAudit(dgShopOrderReqDto.getOrderAddrReqDtoWaitAudit());
        return dgBizPerformOrderReqDto;
    }
}

