/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderPayStrategy;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.ApportionContext;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.ItemPayRecordEo;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelPayService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="channelOrderBasicPayImpl")
public class ChannelOrderBasicPayImpl
implements IChannelOrderPayStrategy {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderBasicPayImpl.class);
    @Resource
    private IChannelPayService channelPayService;
    @Resource
    private ICalculateAmountService channelCalculateAmountService;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;

    @Override
    public void costPayExecute(ApportionContext apportionContext) {
        log.info("==================\u57fa\u7840\uff1a\u8ba2\u5355\u884c\u3001\u5546\u54c1\u884c\u8d39\u7528\u7c7b\u8d26\u6237\u5206\u644a\u660e\u7ec6\u3001\u6c47\u603b\u5165\u5e93 begin=====================================");
        BigDecimal totalUseCostAmount = BigDecimal.ZERO;
        ArrayList<ItemPayRecordDto> itemCostRecordDtos = new ArrayList<ItemPayRecordDto>();
        List orderLineDtos = apportionContext.getOrderLineDtos();
        Map<Long, BigDecimal> itemPayAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
        HashMap<Long, BigDecimal> surplusAmountMap = new HashMap<Long, BigDecimal>(itemPayAmountMap);
        List payRecordDtos = apportionContext.getPayRecordDtos();
        for (PayRecordDto payRecordDto : payRecordDtos) {
            if (payRecordDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                List<Object> subOrderLineDtos = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)payRecordDto.getExtension()) && payRecordDto.getExtension().contains("orderItemId")) {
                    List matchesItems = JSON.parseArray((String)payRecordDto.getExtension(), AccountMatchesItemRespDto.class);
                    List matchesItemIds = matchesItems.stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    subOrderLineDtos = orderLineDtos.stream().filter(item -> matchesItemIds.contains(item.getId())).collect(Collectors.toList());
                } else {
                    subOrderLineDtos = orderLineDtos;
                }
                log.info("\u8d26\u6237\u3010{}\u3011\u8fc7\u6ee4\u5339\u914d\u5546\u54c1\u540e\uff1a{}", (Object)payRecordDto.getPayMethod(), subOrderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
                if (CollectionUtil.isEmpty(subOrderLineDtos)) {
                    log.info("\u8d26\u6237\u3010{}\u3011\u6ca1\u6709\u5339\u914d\u5546\u54c1", (Object)payRecordDto.getPayMethod());
                    continue;
                }
                BigDecimal goodsTotalAmount = BigDecimal.ZERO;
                BigDecimal allocateAmount = new BigDecimal(payRecordDto.getPayAmount().toString());
                BigDecimal canPayAmount = payRecordDto.getPayAmount();
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subOrderLineDtos) {
                    BigDecimal bigDecimal = Optional.ofNullable(itemPayAmountMap.get(dgPerformOrderLineDto.getId())).orElse(BigDecimal.ZERO);
                    goodsTotalAmount = goodsTotalAmount.add(bigDecimal);
                }
                if (goodsTotalAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    log.info("\u5546\u54c1\u603b\u91d1\u989d\u5c0f\u4e8e0\u65e0\u9700\u652f\u4ed8");
                    return;
                }
                goodsTotalAmount = goodsTotalAmount.setScale(2, 4);
                log.info("\u5f53\u524d\u8d26\u6237\uff1a{},\u4f7f\u7528\u91d1\u989d\uff1a{},\u5546\u54c1\u603b\u91d1\u989d\uff1a{}", new Object[]{payRecordDto.getPayMethod(), canPayAmount, goodsTotalAmount});
                AssertUtils.isTrue((canPayAmount.compareTo(goodsTotalAmount) <= 0 ? 1 : 0) != 0, (String)String.format("%s\u8d39\u7528\u62b5\u6263\u4e0d\u80fd\u5927\u4e8e\u62b5\u6263\u5546\u54c1\u5b9e\u4ed8", payRecordDto.getPayMethod()));
                int i = 0;
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subOrderLineDtos) {
                    ++i;
                    BigDecimal itemPayAmount = Optional.ofNullable(itemPayAmountMap.get(dgPerformOrderLineDto.getId())).orElse(BigDecimal.ZERO);
                    if (itemPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        log.info("\u8ba2\u5355\u884c:{} \u6210\u4ea4\u91d1\u989d\u5c0f\u4e8e0\u4e0d\u53c2\u4e0e\u8fd4\u5229\u8ba1\u7b97", (Object)dgPerformOrderLineDto.getId());
                        continue;
                    }
                    BigDecimal surplusAmount = Optional.ofNullable(surplusAmountMap.get(dgPerformOrderLineDto.getId())).orElse(BigDecimal.ZERO);
                    if (surplusAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        log.info("\u5546\u54c1:{} \u5f53\u524d\u5df2\u65e0\u5269\u4f59\u91d1\u989d\u53ef\u4f9b\u5206\u914d:{}", (Object)dgPerformOrderLineDto.getId(), (Object)surplusAmount);
                        continue;
                    }
                    log.info("\u8ba2\u5355\u884c\uff1a{} | \u6210\u4ea4\u91d1\u989d\uff1a{} || \u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff1a{} || \u5f53\u524d\u8d26\u6237\u5269\u4f59\u53ef\u5206\u914d\u7684\u91d1\u989d\uff1a{} || \u5f53\u524d\u7b2c{}\u4e2a\u5546\u54c1\u904d\u5386", new Object[]{dgPerformOrderLineDto.getId(), itemPayAmount, surplusAmount, allocateAmount, i});
                    BigDecimal amount = BigDecimal.ZERO;
                    if (i != subOrderLineDtos.size()) {
                        amount = canPayAmount.multiply(itemPayAmount.divide(goodsTotalAmount, 8, 4)).setScale(2, 4);
                        if (surplusAmount.compareTo(amount) < 0) {
                            log.info("\u8ba2\u5355\u884c\uff1a{} | \u5546\u54c1\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5c0f\u4e8e\u5206\u644a\u91d1\u989d\uff1a{} < {}", new Object[]{dgPerformOrderLineDto.getId(), surplusAmount, amount});
                            amount = surplusAmount;
                        }
                        allocateAmount = allocateAmount.subtract(amount);
                    } else if (surplusAmount.compareTo(allocateAmount) < 0) {
                        log.info("\u8ba2\u5355\u884c\uff1a{} | \u672b\u4f4d\u5546\u54c1\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5c0f\u4e8e\u8d26\u6237\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\uff1a{} < {}", new Object[]{dgPerformOrderLineDto.getId(), surplusAmount, allocateAmount});
                        amount = surplusAmount;
                        allocateAmount = allocateAmount.subtract(surplusAmount);
                    } else {
                        amount = allocateAmount;
                        allocateAmount = BigDecimal.ZERO;
                    }
                    log.info("\u5f53\u524d\u8d26\u6237" + payRecordDto.getPayMethod() + "\u7ed9\u8ba2\u5355\u884c\uff1a" + dgPerformOrderLineDto.getId() + "\u5206\u914d\u4e86" + amount);
                    ItemPayRecordDto dgItemCostRecordDto = new ItemPayRecordDto();
                    dgItemCostRecordDto.setPayRecordId(payRecordDto.getId());
                    dgItemCostRecordDto.setOrderItemId(dgPerformOrderLineDto.getId());
                    dgItemCostRecordDto.setSkuCode(dgPerformOrderLineDto.getSkuCode());
                    dgItemCostRecordDto.setItemNum(dgPerformOrderLineDto.getCalcItemNum());
                    dgItemCostRecordDto.setAccountType(payRecordDto.getPayMethod());
                    dgItemCostRecordDto.setAccountCategory(payRecordDto.getAccountCategory());
                    dgItemCostRecordDto.setSaleCompanyCode(payRecordDto.getSaleCompanyCode());
                    dgItemCostRecordDto.setAmount(amount);
                    itemCostRecordDtos.add(dgItemCostRecordDto);
                    totalUseCostAmount = totalUseCostAmount.add(amount);
                    surplusAmountMap.put(dgPerformOrderLineDto.getId(), surplusAmount.subtract(amount));
                }
                if (allocateAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                log.info("\u8d26\u6237\u3010{}\u3011\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5927\u4e8e0\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)allocateAmount);
                payRecordDto.setPayAmount(payRecordDto.getPayAmount().subtract(allocateAmount));
                log.info("\u8d26\u6237\u3010{}\u3011\u66f4\u65b0\u540e\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)payRecordDto.getPayAmount());
                continue;
            }
            log.info("\u8d26\u6237\u3010{}\u3011\u4e0d\u662f\u8fd4\u5229\u8d26\u6237\u8df3\u8fc7\u8ba1\u7b97", (Object)payRecordDto.getPayMethod());
        }
        apportionContext.setItemCostRecordDtos(itemCostRecordDtos);
        apportionContext.setTotalUseCostAmount(totalUseCostAmount);
        if (CollectionUtil.isNotEmpty(itemCostRecordDtos)) {
            this.buildAndUpdateCostAmountInfo(apportionContext);
        } else {
            log.info("\u65e0\u8fd4\u5229\u4fe1\u606f\u5165\u5e93");
        }
        log.info("=====================\u57fa\u7840\uff1a\u8ba2\u5355\u884c\u3001\u5546\u54c1\u884c\u8d39\u7528\u7c7b\u8d26\u6237\u5206\u644a\u660e\u7ec6\u3001\u6c47\u603b\u5165\u5e93 end=====================================");
    }

    @Override
    public BigDecimal payExecute(ApportionContext apportionContext) {
        log.info("=====================\u57fa\u7840\uff1a\u8ba2\u5355\u884c\u3001\u5546\u54c1\u884c\u8d44\u91d1\u7c7b\u8d26\u6237\u5206\u644a\u660e\u7ec6\u3001\u6c47\u603b\u5165\u5e93 begin=====================================");
        ArrayList itemCapitalRecordList = Lists.newArrayList();
        ArrayList payRecordIds = Lists.newArrayList();
        List orderLineDtos = apportionContext.getOrderLineDtos();
        Map orderLineAmountMap = apportionContext.getOrderLineAmountMap();
        Map<Long, List<ItemPayRecordDto>> allCostPayRecordDtoMap = new HashMap<Long, List<ItemPayRecordDto>>();
        if (CollectionUtil.isNotEmpty((Collection)apportionContext.getItemCostRecordDtos())) {
            allCostPayRecordDtoMap = apportionContext.getItemCostRecordDtos().stream().collect(Collectors.groupingBy(ItemPayRecordDto::getOrderItemId));
        }
        Map<Long, BigDecimal> orderLineNeedPayAmountMap = this.channelPayService.calculateNeedPayAmount(apportionContext.getOrderLineDtos(), allCostPayRecordDtoMap);
        orderLineDtos = orderLineDtos.stream().filter(e -> {
            BigDecimal surplusAmount = (BigDecimal)orderLineNeedPayAmountMap.get(e.getId());
            return surplusAmount != null && surplusAmount.compareTo(BigDecimal.ZERO) > 0;
        }).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u5df2\u7ecf\u4e0d\u9700\u8981\u652f\u4ed8\u7684\u5546\u54c1\u540e\uff1a{}", orderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
        List payRecordDtos = apportionContext.getPayRecordDtos();
        payRecordDtos = payRecordDtos.stream().sorted(Comparator.comparing(PayRecordDto::getPriority)).collect(Collectors.toList());
        for (PayRecordDto payRecordDto : payRecordDtos) {
            if (!AccountCategoryEnum.CAPITAL.getCode().equals(payRecordDto.getAccountCategory())) {
                log.info("\u8d26\u6237\u3010" + payRecordDto.getPayMethod() + "\u3011\u4e0d\u662f\u73b0\u91d1\u7c7b\u8d26\u6237");
                continue;
            }
            boolean isGroup = payRecordDto.isGroup();
            List<Object> subItems = new ArrayList();
            log.info("\u8d26\u6237\u3010{}\u3011\u9002\u7528\u7684\u5546\u54c1\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)payRecordDto.getExtension());
            if (StringUtils.isNotBlank((CharSequence)payRecordDto.getExtension()) && payRecordDto.getExtension().contains("orderItemId")) {
                List matchesItems = JSON.parseArray((String)payRecordDto.getExtension(), AccountMatchesItemRespDto.class);
                List matchesItemIds = matchesItems.stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                subItems = orderLineDtos.stream().filter(item -> matchesItemIds.contains(item.getId())).collect(Collectors.toList());
            } else {
                subItems = orderLineDtos;
            }
            log.info("\u8fc7\u6ee4\u540e\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", subItems.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList()));
            if (CollectionUtil.isEmpty(subItems)) {
                log.info("\u8d26\u6237\u3010{}\u3011\u6ca1\u6709\u5339\u914d\u5546\u54c1", (Object)payRecordDto.getPayMethod());
                continue;
            }
            BigDecimal allocateAmount = new BigDecimal(payRecordDto.getPayAmount().toString());
            BigDecimal canPayAmount = payRecordDto.getPayAmount();
            BigDecimal totalRealPayAmnount = BigDecimal.ZERO;
            for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                totalRealPayAmnount = totalRealPayAmnount.add(orderLineAmountMap.get(dgPerformOrderLineDto.getId()) != null ? (BigDecimal)orderLineAmountMap.get(dgPerformOrderLineDto.getId()) : BigDecimal.ZERO);
            }
            log.info("\u603b\u5b9e\u4ed8\u91d1\u989d\u662f\uff1a{}", (Object)totalRealPayAmnount);
            if (canPayAmount.compareTo(totalRealPayAmnount) > 0) {
                log.info("\u8d26\u6237\u3010{}\u3011\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u603b\u7ed3\u7b97\u91d1\u989d\uff0c\u652f\u4ed8\u91d1\u989d\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)canPayAmount);
                canPayAmount = totalRealPayAmnount;
            }
            int i = 0;
            ArrayList arrayList = Lists.newArrayList();
            BigDecimal payRecordAmount = BigDecimal.ZERO;
            for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                ++i;
                if (allocateAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    log.info("\u8d26\u6237\u5df2\u7ecf\u6ca1\u6709\u989d\u5ea6\u53ef\u4ee5\u5206\u914d\u7ed9\u5546\u54c1\uff1a{}", (Object)dgPerformOrderLineDto.getId());
                    break;
                }
                if (dgPerformOrderLineDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0 || dgPerformOrderLineDto.getGiftFlag().equals(DgGiftEnum.GIFT.getType())) {
                    log.info("\u8d60\u54c1\u4e0d\u53c2\u4e0e\u652f\u4ed8\u5206\u644a\uff1a{}", (Object)dgPerformOrderLineDto.getId());
                    continue;
                }
                BigDecimal bigDecimal = orderLineNeedPayAmountMap.get(dgPerformOrderLineDto.getId());
                BigDecimal realPayAmount = (BigDecimal)orderLineAmountMap.get(dgPerformOrderLineDto.getId());
                log.info("\u8ba2\u5355\u884c\uff1a{} | \u7ed3\u7b97\u91d1\u989d\uff1a{} | \u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff1a{}", new Object[]{dgPerformOrderLineDto.getId(), realPayAmount, bigDecimal});
                if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
                    log.info("\u5546\u54c1:{} \u5f53\u524d\u5df2\u65e0\u5269\u4f59\u91d1\u989d\u53ef\u4f9b\u5206\u914d:{}", (Object)dgPerformOrderLineDto.getId(), (Object)bigDecimal);
                    continue;
                }
                log.info("\u5f53\u524d\u8d26\u6237" + payRecordDto.getPayMethod() + "\u603b\u91d1\u989d\uff1a" + payRecordDto.getPayAmount() + " || \u5f53\u524d\u5df2\u5206\u914d\u91d1\u989d\uff1a" + allocateAmount);
                BigDecimal amount = BigDecimal.ZERO;
                if (i != subItems.size()) {
                    amount = canPayAmount.multiply(realPayAmount.divide(totalRealPayAmnount, 8, 4)).setScale(2, 4);
                    if (bigDecimal.compareTo(amount) < 0) {
                        log.info("\u8ba2\u5355\u884c\uff1a{} | \u5546\u54c1\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5c0f\u4e8e\u5206\u644a\u91d1\u989d\uff1a{} < {}", new Object[]{dgPerformOrderLineDto.getId(), bigDecimal, amount});
                        amount = bigDecimal;
                    }
                    allocateAmount = allocateAmount.subtract(amount);
                } else if (bigDecimal.compareTo(allocateAmount) < 0) {
                    log.info("\u8ba2\u5355\u884c\uff1a{} | \u672b\u4f4d\u5546\u54c1\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5c0f\u4e8e\u8d26\u6237\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\uff1a{} < {}", new Object[]{dgPerformOrderLineDto.getId(), bigDecimal, allocateAmount});
                    amount = bigDecimal;
                    allocateAmount = allocateAmount.subtract(bigDecimal);
                } else {
                    amount = allocateAmount;
                    allocateAmount = BigDecimal.ZERO;
                }
                log.info("\u5f53\u524d\u8d26\u6237" + payRecordDto.getPayMethod() + "\u7ed9\u8ba2\u5355\u884c\uff1a" + dgPerformOrderLineDto.getId() + "\u5206\u914d\u4e86" + amount);
                ItemPayRecordDto itemPayRecordDto = new ItemPayRecordDto();
                itemPayRecordDto.setPayRecordId(payRecordDto.getId());
                itemPayRecordDto.setOrderItemId(dgPerformOrderLineDto.getId());
                itemPayRecordDto.setItemCountsType(payRecordDto.getItemCountsType());
                itemPayRecordDto.setAccountType(payRecordDto.getPayMethod());
                itemPayRecordDto.setAccountCategory(payRecordDto.getAccountCategory());
                itemPayRecordDto.setSaleCompanyCode(payRecordDto.getSellerId());
                itemPayRecordDto.setCreditFileNo(payRecordDto.getCardNo());
                itemPayRecordDto.setAmount(amount);
                ItemPayRecordEo recordEo = new ItemPayRecordEo();
                CubeBeanUtils.copyProperties((Object)recordEo, (Object)itemPayRecordDto, (String[])new String[0]);
                arrayList.add(recordEo);
                orderLineNeedPayAmountMap.put(dgPerformOrderLineDto.getId(), bigDecimal.subtract(amount));
                payRecordAmount = payRecordAmount.add(amount);
            }
            if (allocateAmount.compareTo(BigDecimal.ZERO) > 0) {
                log.info("\u8d26\u6237\u3010{}\u3011\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d\u5927\u4e8e0\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)allocateAmount);
                log.info("\u8fdb\u5165\u5206\u914d\u4fee\u6b63\u8865\u507f\u6d41\u7a0b");
                Map subItemCapitalRecordMap = arrayList.stream().collect(Collectors.toMap(ItemPayRecordEo::getOrderItemId, Function.identity(), (a, b) -> a));
                for (DgPerformOrderLineDto dgPerformOrderLineDto : subItems) {
                    BigDecimal surplusAmount = orderLineNeedPayAmountMap.get(dgPerformOrderLineDto.getId());
                    ItemPayRecordEo recordEo = (ItemPayRecordEo)subItemCapitalRecordMap.get(dgPerformOrderLineDto.getId());
                    if (surplusAmount.compareTo(BigDecimal.ZERO) > 0 || null != recordEo) {
                        log.info("\u5546\u54c1:{} \u5269\u4f59\u5206\u914d\u91d1\u989d:{}", (Object)dgPerformOrderLineDto.getSkuCode(), (Object)surplusAmount);
                        BigDecimal newAmount = BigDecimal.ZERO;
                        if (surplusAmount.compareTo(allocateAmount) >= 0) {
                            newAmount = recordEo.getAmount().add(allocateAmount);
                            surplusAmount = surplusAmount.subtract(allocateAmount);
                            allocateAmount = BigDecimal.ZERO;
                        } else {
                            newAmount = recordEo.getAmount().add(surplusAmount);
                            allocateAmount = allocateAmount.subtract(surplusAmount);
                            surplusAmount = BigDecimal.ZERO;
                        }
                        recordEo.setAmount(newAmount);
                        orderLineNeedPayAmountMap.put(dgPerformOrderLineDto.getId(), surplusAmount);
                        log.info("\u5546\u54c1:{} \u65b0\u5206\u914d\u5230\u7684\u91d1\u989d\uff1a{}", (Object)dgPerformOrderLineDto.getSkuCode(), (Object)newAmount);
                        if (allocateAmount.compareTo(BigDecimal.ZERO) > 0) continue;
                        break;
                    }
                    log.info("\u5546\u54c1:{} \u6ca1\u6709\u5269\u4f59\u53ef\u5206\u914d\u91d1\u989d", (Object)dgPerformOrderLineDto.getSkuCode());
                }
                payRecordDto.setPayAmount(payRecordDto.getPayAmount().subtract(allocateAmount));
                log.info("\u8d26\u6237\u3010{}\u3011\u66f4\u65b0\u540e\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)payRecordDto.getPayMethod(), (Object)payRecordDto.getPayAmount());
            }
            itemCapitalRecordList.addAll(arrayList);
            payRecordIds.add(payRecordDto.getId());
            log.info("\u8d26\u6237\u3010" + payRecordDto.getPayMethod() + "\u3011\u5206\u644a\u7ed3\u675f===========================end");
        }
        BigDecimal totalCapitalAmount = payRecordDtos.stream().map(PayRecordDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u6240\u6709\u8d26\u6237\u603b\u652f\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)totalCapitalAmount);
        apportionContext.setItemCapitalRecordList((List)itemCapitalRecordList);
        apportionContext.setDelPayRecordIds((List)payRecordIds);
        apportionContext.setTotalPayAmount(totalCapitalAmount);
        log.info("=====================\u57fa\u7840\uff1a\u8ba2\u5355\u884c\u3001\u5546\u54c1\u884c\u8d44\u91d1\u7c7b\u8d26\u6237\u5206\u644a\u660e\u7ec6\u3001\u6c47\u603b\u5165\u5e93 end=====================================");
        return totalCapitalAmount;
    }

    private void buildAndUpdateCostAmountInfo(ApportionContext apportionContext) {
        Map orderLineAmountMap = apportionContext.getOrderLineAmountMap();
        Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineMap = apportionContext.getOrderItemLineDtoList().stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        Map payRecordDtoMap = apportionContext.getPayRecordDtos().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        ArrayList<DgPerformOrderLineAmountEo> costLineAmountEos = new ArrayList<DgPerformOrderLineAmountEo>();
        ArrayList costItemLineAmountEos = new ArrayList();
        DgPerformOrderRespDto performOrderRespDto = apportionContext.getPerformOrderRespDto();
        List allCostPayRecordDtoList = apportionContext.getItemCostRecordDtos();
        List performOrderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderId(performOrderRespDto.getId());
        Map<Long, List<DgPerformOrderLineAmountDto>> performOrderLineAmountMap = performOrderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        List performOrderItemLineDtos = this.performOrderItemLineAmountDomain.queryByOrderId(performOrderRespDto.getId());
        Map<Long, List<DgPerformOrderItemLineAmountDto>> performOrderItemLineAmountMap = performOrderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountDto::getOrderItemLineId));
        allCostPayRecordDtoList.forEach(itemPay -> {
            PayRecordDto recordDto = (PayRecordDto)payRecordDtoMap.get(itemPay.getPayRecordId());
            if (null == recordDto) {
                log.error("\u6ca1\u6709\u652f\u4ed8\u4e3b\u4f53\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)recordDto));
                return;
            }
            DgPerformOrderLineAmountEo lineAmountEo = new DgPerformOrderLineAmountEo();
            lineAmountEo.setOrderId(performOrderRespDto.getId());
            lineAmountEo.setOrderLineId(itemPay.getOrderItemId());
            lineAmountEo.setAmountSource(DgOrderAmountSourceEnum.COST.getCode());
            lineAmountEo.setAccountCategory(recordDto.getAccountCategory());
            lineAmountEo.setAccountType(itemPay.getAccountType());
            lineAmountEo.setAmount(itemPay.getAmount());
            lineAmountEo.setSellerId(recordDto.getSellerId());
            costLineAmountEos.add(lineAmountEo);
            List itemLineDtos = (List)orderItemLineMap.get(itemPay.getOrderItemId());
            if (CollectionUtil.isNotEmpty((Collection)itemLineDtos)) {
                itemLineDtos.forEach(itemLine -> {
                    DgPerformOrderItemLineAmountEo itemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                    itemLineAmountEo.setOrderId(performOrderRespDto.getId());
                    itemLineAmountEo.setOrderItemLineId(itemLine.getId());
                    itemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.COST.getCode());
                    itemLineAmountEo.setAccountCategory(recordDto.getAccountCategory());
                    itemLineAmountEo.setAccountType(itemPay.getAccountType());
                    itemLineAmountEo.setAmount(itemPay.getAmount());
                    itemLineAmountEo.setSellerId(recordDto.getSellerId());
                    costItemLineAmountEos.add(itemLineAmountEo);
                });
            } else {
                log.info("\u5546\u54c1\u6ca1\u6709\u5546\u54c1\u884c\uff1a\u3010{}\u3011", (Object)itemPay.getOrderItemId());
            }
        });
        if (CollectionUtil.isNotEmpty(costLineAmountEos)) {
            log.info("\u8ba1\u7b97\u8ba2\u5355\u884c\u8d39\u7528\u989d\u5ea6");
            Map<Long, List<DgPerformOrderLineAmountEo>> costLineAmountMap = costLineAmountEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
            for (Map.Entry<Long, List<DgPerformOrderLineAmountEo>> entry : costLineAmountMap.entrySet()) {
                List subList;
                DgPerformOrderLineAmountEo lineAmountEo = new DgPerformOrderLineAmountEo();
                lineAmountEo.setOrderId(entry.getValue().get(0).getOrderId());
                lineAmountEo.setOrderLineId(entry.getKey());
                lineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                lineAmountEo.setAccountCategory(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode());
                lineAmountEo.setAccountType(entry.getValue().get(0).getAccountType());
                lineAmountEo.setAmount(entry.getValue().stream().map(DgPerformOrderLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                costLineAmountEos.add(lineAmountEo);
                List<DgPerformOrderLineAmountDto> performOrderLineAmountDtoList = performOrderLineAmountMap.get(entry.getKey());
                if (!CollectionUtil.isNotEmpty(performOrderLineAmountDtoList) || !CollectionUtils.isNotEmpty(subList = performOrderLineAmountDtoList.stream().filter(e -> e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && (e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode()) || e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SETTLEMENT_AMOUNT.getCode()))).collect(Collectors.toList()))) continue;
                for (DgPerformOrderLineAmountDto lineAmountDto : subList) {
                    if (lineAmountDto.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    DgPerformOrderLineAmountEo lineAmount = new DgPerformOrderLineAmountEo();
                    lineAmount.setId(lineAmountDto.getId());
                    lineAmount.setAmount(lineAmountDto.getAmount().subtract(lineAmountEo.getAmount()));
                    log.info("\u8ba2\u5355\u884c[{}]\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\uff08\u5b9e\u4ed8\u91d1\u989d\uff09\uff1a{} ===>>>>{}", new Object[]{lineAmountDto.getOrderLineId(), lineAmountDto.getAccountType(), lineAmount.getAmount()});
                    this.performOrderLineAmountDomain.updateSelective((BaseEo)lineAmount);
                    if (!lineAmountDto.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())) continue;
                    orderLineAmountMap.put(entry.getKey(), lineAmount.getAmount());
                }
            }
        }
        if (CollectionUtil.isNotEmpty(costItemLineAmountEos)) {
            log.info("\u8ba1\u7b97\u5546\u54c1\u884c\u8d39\u7528\u989d\u5ea6");
            Map<Long, List<DgPerformOrderItemLineAmountEo>> costItemLineAmountMap = costItemLineAmountEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountEo::getOrderItemLineId));
            costItemLineAmountMap.forEach((id, list) -> {
                List subList;
                DgPerformOrderItemLineAmountEo itemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                itemLineAmountEo.setOrderId(((DgPerformOrderItemLineAmountEo)list.get(0)).getOrderId());
                itemLineAmountEo.setOrderItemLineId(id);
                itemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
                itemLineAmountEo.setAccountCategory(DgOmsOrderAmountTypeEnum.ITEM_LINE_COST_AMOUNT.getCode());
                itemLineAmountEo.setAccountType(((DgPerformOrderItemLineAmountEo)list.get(0)).getAccountType());
                itemLineAmountEo.setAmount(list.stream().map(DgPerformOrderItemLineAmountEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                costItemLineAmountEos.add(itemLineAmountEo);
                List performOrderItemLineAmountDtos = (List)performOrderItemLineAmountMap.get(id);
                if (CollectionUtil.isNotEmpty((Collection)performOrderItemLineAmountDtos) && CollectionUtil.isNotEmpty(subList = performOrderItemLineAmountDtos.stream().filter(e -> e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode()) && (e.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_LINE_ACTUAL_PRICE.getCode()) || e.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_LINE_SETTLEMENT_AMOUNT.getCode()))).collect(Collectors.toList()))) {
                    for (DgPerformOrderItemLineAmountDto itemLineAmountDto : subList) {
                        if (itemLineAmountDto.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                            return;
                        }
                        DgPerformOrderItemLineAmountEo itemLineAmount = new DgPerformOrderItemLineAmountEo();
                        itemLineAmount.setId(itemLineAmountDto.getId());
                        itemLineAmount.setAmount(itemLineAmountDto.getAmount().subtract(itemLineAmountEo.getAmount()));
                        log.info("\u5546\u54c1\u884c[{}]\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\uff08\u5b9e\u4ed8\u91d1\u989d\uff09\uff1a{} ===>>>>{}", new Object[]{itemLineAmountDto.getOrderItemLineId(), itemLineAmountDto.getAccountType(), itemLineAmount.getAmount()});
                        this.performOrderItemLineAmountDomain.updateSelective((BaseEo)itemLineAmount);
                    }
                }
            });
        }
        BigDecimal realPayAmount = orderLineAmountMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u8ba2\u5355\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a{}", (Object)realPayAmount);
        if (null != performOrderRespDto.getPerformOrderAmountDto() && null != performOrderRespDto.getPerformOrderAmountDto()) {
            DgPerformOrderAmountEo update = new DgPerformOrderAmountEo();
            update.setId(performOrderRespDto.getPerformOrderAmountDto().getId());
            update.setRealPayAmount(realPayAmount);
            this.performOrderAmountDomain.updateSelective((BaseEo)update);
        } else {
            log.error("\u7ed3\u7b97\u91d1\u989d\u66f4\u65b0\u9519\u8bef\uff1a{}==>>{}", (Object)JSON.toJSONString((Object)performOrderRespDto), (Object)realPayAmount);
        }
        apportionContext.setOrderLineAmountMap(orderLineAmountMap);
        apportionContext.setCostLineAmountEos(costLineAmountEos);
        apportionContext.setCostItemLineAmountEos(costItemLineAmountEos);
    }
}

