/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStayReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountQueryReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTypeBalanceRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountTypeDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTypeApiProxy;
import com.yunxi.dg.base.center.credit.dto.entity.CreditRepaymentSimpleDto;
import com.yunxi.dg.base.center.credit.dto.entity.RepaymentStrategiesSimpleDto;
import com.yunxi.dg.base.center.credit.proxy.entity.ICreditRepaymentDgApiProxy;
import com.yunxi.dg.base.center.credit.proxy.entity.IDemandRepaymentStrategiesDgApiProxy;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderPayAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IDgF2BMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.pay.SubmitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.ApportionContext;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.dto.pay.OnlinePayReqDto;
import com.yunxi.dg.base.center.trade.dto.pay.PaymentMqNotifyReqDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.DgSaleOrderTypeExtEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelPayService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.center.trade.utils.selector.ChannelOrderKneadPriceSelector;
import com.yunxi.dg.base.center.trade.utils.selector.ChannelOrderPaySelector;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelOrderPayActionImpl
implements IChannelOrderPayAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderPayActionImpl.class);
    @Resource
    private IAccountApiProxy accountApiProxy;
    @Resource
    private IDgCustomerQueryApiProxy customerQueryApiProxy;
    @Resource
    private IAccountTypeApiProxy accountTypeApiProxy;
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IChannelPayService channelPayService;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private ICreditRepaymentDgApiProxy creditRepaymentDgApiProxy;
    @Resource
    private IDemandRepaymentStrategiesDgApiProxy demandRepaymentStrategiesDgApiProxy;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IChannelAccountService channelAccountService;
    @Resource
    private ICalculateAmountService channelCalculateAmountService;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgF2BMqMessageAction dgF2BMqMessageAction;

    @Override
    public Boolean isUnPay(DgPerformOrderRespDto dto) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setOrderNo(dto.getSaleOrderNo());
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        List payRecordEos = this.payRecordDomain.selectList((BaseEo)payRecordEo);
        if (CollectionUtil.isNotEmpty((Collection)payRecordEos)) {
            payRecordEos = payRecordEos.stream().filter(e -> e.getPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        }
        return CollectionUtil.isEmpty((Collection)payRecordEos);
    }

    @Override
    public Boolean isAllPay(DgPerformOrderRespDto dto) {
        DgPerformOrderPaymentDto dgPerformOrderPaymentDto = this.dgPerformOrderPaymentDomain.selectDtoByOrderId(dto.getId());
        AssertUtils.notNull((Object)dgPerformOrderPaymentDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        return BigDecimal.ZERO.compareTo(dgPerformOrderPaymentDto.getRemainingPayAmount()) >= 0;
    }

    @Override
    public RestResponse<String> updatePayStatus(DgPerformOrderRespDto dto, Integer payStatus) {
        String payWayStr = null;
        List payRecordEos = this.payRecordDomain.selectListByOrderNoAndStatus(dto.getSaleOrderNo(), PayStatusEnum.SUCCESS.getName());
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            payWayStr = payRecordEos.stream().map(PayRecordEo::getPayMethodName).distinct().collect(Collectors.joining("\u3001"));
        }
        DgPerformOrderPaymentEo dgPerformOrderPaymentEo = new DgPerformOrderPaymentEo();
        dgPerformOrderPaymentEo.setId(dto.getPerformOrderPaymentDto().getId());
        dgPerformOrderPaymentEo.setPayStatus(payStatus);
        dgPerformOrderPaymentEo.setPayTime(new Date());
        dgPerformOrderPaymentEo.setPayWay(payWayStr);
        this.dgPerformOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setId(dto.getId());
        updateEo.setUpdateTime(new Date());
        this.dgPerformOrderInfoDomain.updateSelective((BaseEo)updateEo);
        this.sendOrderPaidActivityMsg(dto, payStatus);
        return new RestResponse();
    }

    private void sendOrderPaidActivityMsg(DgPerformOrderRespDto dto, Integer payStatus) {
        if (!Objects.equals(payStatus, 1)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dto.getSaleOrderNo())) {
            log.info("\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            return;
        }
        this.dgF2BMqMessageAction.dealWithActivityExpense(dto.getSaleOrderNo(), 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgPerformOrderRespDto wholePay(DgPerformOrderRespDto performOrderRespDto, DgPerformOrderPayReqDto req, Boolean creditFlag) {
        boolean result = this.refreshAccount(performOrderRespDto, req);
        if (result) {
            return null;
        }
        CreditRepaymentSimpleDto repaymentSimpleDto = null;
        if (creditFlag.booleanValue()) {
            repaymentSimpleDto = this.creditRepayment(req, performOrderRespDto);
            log.info("\u968f\u5355\u8fd8\u6b3e\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)repaymentSimpleDto));
            if (null != repaymentSimpleDto && null != repaymentSimpleDto.getIntercept() && repaymentSimpleDto.getIntercept().booleanValue()) {
                return null;
            }
        }
        ApportionContext apportionContext = this.pay(performOrderRespDto, req);
        this.channelPayService.calculateAmountGroup(apportionContext);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.channelPayService.buildAndSaveInfo(apportionContext);
        log.info("[\u9884\u5360\u8d26\u6237\u989d\u5ea6]\uff1a{}", JSON.toJSON((Object)accountTradeBatchReqDto));
        RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.preempt(accountTradeBatchReqDto));
        if (null != repaymentSimpleDto) {
            log.info("\u8fd8\u6b3e\u5165\u53c2\uff1a{}", JSON.toJSON((Object)repaymentSimpleDto));
            RestResponseHelper.checkOrThrow((RestResponse)this.creditRepaymentDgApiProxy.demandRepayment(repaymentSimpleDto));
        }
        return performOrderRespDto;
    }

    private boolean refreshAccount(DgPerformOrderRespDto performOrderRespDto, DgPerformOrderPayReqDto req) {
        log.info("\u3010\u6e20\u9053\u57fa\u7ebf\u8ba2\u5355\u652f\u4ed8\u5237\u65b0\u4fe1\u606f\uff1a{}\u3011", JSON.toJSON((Object)req));
        if (req == null || performOrderRespDto == null || CollectionUtils.isEmpty((Collection)req.getPayReqDtos()) || performOrderRespDto.getPerformOrderPaymentDto().getRemainingPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return true;
        }
        List accountTypeDtoList = (List)RestResponseHelper.extractData((RestResponse)this.accountTypeApiProxy.queryByCodes(req.getPayReqDtos().stream().map(DgBasePayReqDto::getPayMethod).collect(Collectors.toList())));
        Map<String, AccountTypeDto> accoungtTypeDtoMap = accountTypeDtoList.stream().collect(Collectors.toMap(AccountTypeDto::getAccountTypeCode, Function.identity()));
        List<AccountDto> accountDtos = this.channelAccountService.queryCapitalAccount(performOrderRespDto.getSaleOrderNo(), Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL, AccountCategoryEnum.COST, AccountCategoryEnum.EQUITY}));
        if (req.isRefreshAccountDto()) {
            this.autoRefreshAccount(accountDtos, req, accoungtTypeDtoMap);
        } else {
            this.refreshAccountInfo(accountDtos, req, accoungtTypeDtoMap);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApportionContext pay(DgPerformOrderRespDto performOrderRespDto, DgPerformOrderPayReqDto req) {
        log.info("\u3010\u6e20\u9053\u57fa\u7ebf\u8ba2\u5355\u652f\u4ed8\uff1a{}\u3011", JSON.toJSON((Object)req));
        if (req == null || performOrderRespDto == null || CollectionUtils.isEmpty((Collection)req.getPayReqDtos()) || performOrderRespDto.getPerformOrderPaymentDto().getRemainingPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        List origDgBasePayReqDtos = req.getPayReqDtos();
        log.info("\u5f00\u59cb\u5206\u644a\u524d\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)origDgBasePayReqDtos));
        if (CollectionUtils.isEmpty((Collection)origDgBasePayReqDtos)) {
            log.info("\u652f\u4ed8\u660e\u7ec6\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
            return null;
        }
        BigDecimal curTotalPayAmount = origDgBasePayReqDtos.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AssertUtils.isTrue((curTotalPayAmount.compareTo(performOrderRespDto.getPerformOrderPaymentDto().getRemainingPayAmount()) <= 0 ? 1 : 0) != 0, (String)"\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u5f85\u652f\u4ed8\u91d1\u989d");
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderRespDto.getId());
        List orderItemLineDtoList = this.performOrderItemLineDomain.queryInfoByOrderId(performOrderRespDto.getId());
        Map<Long, BigDecimal> orderLineAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        ArrayList accountTradeReqDtos = Lists.newArrayList();
        ArrayList payRecordDtos = Lists.newArrayList();
        for (DgBasePayReqDto payInfo : origDgBasePayReqDtos) {
            AccountTradeReqDto accountTradeReqDto = this.buildAccountTradeReqDto(payInfo, req);
            accountTradeReqDtos.add(accountTradeReqDto);
            PayRecordDto payRecordDto = this.buildPayRecordEo(performOrderRespDto, accountTradeReqDto, payInfo);
            payRecordDtos.add(payRecordDto);
        }
        ApportionContext apportionContext = new ApportionContext();
        apportionContext.setPerformOrderRespDto(performOrderRespDto);
        apportionContext.setPayReqDto(req);
        apportionContext.setOrderLineDtos(orderLineDtos);
        apportionContext.setOrderItemLineDtoList(orderItemLineDtoList);
        apportionContext.setOrderLineAmountMap(orderLineAmountMap);
        apportionContext.setAccountTradeReqDtos((List)accountTradeReqDtos);
        apportionContext.setPayRecordDtos((List)payRecordDtos);
        ChannelOrderPaySelector.newInstance(performOrderRespDto.getPerformOrderSnapshotDto().getPayCalculateMode().toString()).costPayExecute(apportionContext);
        ChannelOrderPaySelector.newInstance(performOrderRespDto.getPerformOrderSnapshotDto().getPayCalculateMode().toString()).payExecute(apportionContext);
        return apportionContext;
    }

    private AccountTradeReqDto buildAccountTradeReqDto(DgBasePayReqDto payInfo, DgPerformOrderPayReqDto req) {
        AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
        accountTradeReqDto.setAmount(payInfo.getPayAmount());
        accountTradeReqDto.setAccountType(payInfo.getPayMethod());
        accountTradeReqDto.setAccountTypeName(payInfo.getAccountCategoryName());
        accountTradeReqDto.setAccountCategory(payInfo.getAccountCategory());
        accountTradeReqDto.setCreditFileNo(payInfo.getCreditFileNo());
        accountTradeReqDto.setSaleCompanyCode(payInfo.getSaleCompanyCode());
        if (payInfo.getIsPaymentPeriod() != null && payInfo.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) || payInfo.isGroup() || req.getValidNegative() != null && !req.getValidNegative().booleanValue() && payInfo.getPayMethod().equals("YFK")) {
            accountTradeReqDto.setNegativePay(YesNoEnum.YES.getValue());
        } else {
            accountTradeReqDto.setNegativePay(YesNoEnum.NO.getValue());
        }
        return accountTradeReqDto;
    }

    @Override
    public DgPerformOrderPayReqDto buildOrderOverPayInfo(DgPerformOrderRespDto dto) {
        List lineIds;
        List amountDtoList;
        List<AccountTypeBalanceRespDto> balanceRespDtos = this.queryYFKAccount(dto);
        List<DgPjOrgCustomerRelationExtRespDto> customerRelationExtRespDtos = this.preInfoQueryAction.queryByShopIdsAndCustomerIds(Collections.singletonList(dto.getPerformOrderSnapshotDto().getCustomerId()), Lists.newArrayList((Object[])new Long[]{dto.getPerformOrderSnapshotDto().getShopId()}));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(customerRelationExtRespDtos), (String)"\u5ba2\u6237\u7b7e\u7ea6\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto = (DgPjOrgCustomerRelationExtRespDto)customerRelationExtRespDtos.stream().findFirst().get();
        BigDecimal costAmount = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty((Collection)dto.getOrderLineList()) && CollectionUtil.isNotEmpty((Collection)(amountDtoList = this.performOrderLineAmountDomain.queryByOrderLineIds(lineIds = dto.getOrderLineList().stream().map(BaseDto::getId).collect(Collectors.toList()))))) {
            costAmount = amountDtoList.stream().filter(e -> e.equals(DgOmsOrderAmountTypeEnum.LINE_COST_AMOUNT.getCode().equals(e.getAccountType()))).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
        demandRepaymentStrategiesReqDto.setBiNo(dto.getSaleOrderNo());
        demandRepaymentStrategiesReqDto.setShopId(dto.getPerformOrderSnapshotDto().getShopId());
        demandRepaymentStrategiesReqDto.setCustomerId(dto.getPerformOrderSnapshotDto().getCustomerId());
        demandRepaymentStrategiesReqDto.setPaidAmount(dto.getPerformOrderAmountDto().getPayAmount());
        demandRepaymentStrategiesReqDto.setRebateAmount(costAmount);
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)dto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
        RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)dto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
        BigDecimal allWaitDebtAmount = BigDecimal.ZERO;
        BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitDebtAmount = BigDecimal.ZERO;
        if (payableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidMultipleAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidMultipleAmount()).orElse(BigDecimal.ZERO);
            waitDebtAmount = payableAmount.subtract(repaidMultipleAmount);
            allWaitDebtAmount = waitDebtAmount.compareTo(BigDecimal.ZERO) >= 0 ? allWaitDebtAmount.add(waitDebtAmount) : allWaitDebtAmount.add(payableAmount);
        }
        BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitRebatePayableAmount = BigDecimal.ZERO;
        if (rebatePayableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidRebateAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidRebateAmount()).orElse(BigDecimal.ZERO);
            waitRebatePayableAmount = rebatePayableAmount.subtract(repaidRebateAmount);
            allWaitDebtAmount = waitRebatePayableAmount.compareTo(BigDecimal.ZERO) >= 0 ? allWaitDebtAmount.add(waitRebatePayableAmount) : allWaitDebtAmount.add(rebatePayableAmount);
        }
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u672c\u6b21\u652f\u4ed8\u500d\u6570\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{}\uff0c\u672c\u6b21\u652f\u4ed8\u8fd4\u5229\u62b5\u5145\u6b20\u6b3e\u968f\u5355\u8fd8\u6b3e\u91d1\u989d{}", (Object)payableAmount, (Object)rebatePayableAmount);
        ArrayList<DgBasePayReqDto> payReqDtos = new ArrayList<DgBasePayReqDto>();
        for (AccountTypeBalanceRespDto balanceRespDto : balanceRespDtos) {
            DgBasePayReqDto dgBasePayReqDto = new DgBasePayReqDto();
            dgBasePayReqDto.setPayAmount(dto.getPerformOrderPaymentDto().getRemainingPayAmount().add(allWaitDebtAmount));
            dgBasePayReqDto.setPayMethod(balanceRespDto.getAccountType());
            dgBasePayReqDto.setAccountCategory(balanceRespDto.getAccountCategory());
            dgBasePayReqDto.setAccountDtos(balanceRespDto.getBalances());
            dgBasePayReqDto.setMatchesItems(balanceRespDto.getItems());
            dgBasePayReqDto.setGroup(Objects.equals(dgPjOrgCustomerRelationExtRespDto.getAuthFee(), YesNoEnum.YES.getValue()));
            dgBasePayReqDto.setItemCountsType(balanceRespDto.getItemCountsType());
            payReqDtos.add(dgBasePayReqDto);
        }
        DgPerformOrderPayReqDto payReqDto = new DgPerformOrderPayReqDto();
        payReqDto.setOrderId(dto.getId());
        payReqDto.setPayReqDtos(payReqDtos);
        payReqDto.setValidNegative(Boolean.FALSE);
        return payReqDto;
    }

    @Override
    public Boolean paymentCallbackIsSuccess(PaymentMqNotifyReqDto req) {
        return "S".equals(req.getStatus());
    }

    @Override
    public Boolean paymentCallbackIsFail(PaymentMqNotifyReqDto req) {
        return "F".equals(req.getStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void paymentCallbackSuccess(PaymentMqNotifyReqDto request) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)request.getTradeId()), (String)"\u67e5\u8be2\u53c2\u6570tradeId\u4e0d\u80fd\u4e3a\u7a7a");
        PayRecordEo payRecordEo = this.payRecordDomain.selectByTradeNo(request.getTradeId());
        AssertUtils.isFalse((payRecordEo == null ? 1 : 0) != 0, (String)"\u652f\u4ed8\u6d41\u6c34\u672a\u67e5\u5230");
        PayRecordEo updateEo = new PayRecordEo();
        updateEo.setId(payRecordEo.getId());
        updateEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        updateEo.setPayFinishTime(request.getFinishTime());
        updateEo.setPayTime(request.getFinishTime());
        this.payRecordDomain.updateSelective((BaseEo)updateEo);
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(payRecordEo.getOrderNo());
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderPaymentEo paymentEo = this.dgPerformOrderPaymentDomain.selectByOrderId(dgPerformOrderInfoEo.getId());
        AssertUtils.isFalse((paymentEo == null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u8868\u6570\u636e");
        DgPerformOrderPaymentEo updatePaymentEo = new DgPerformOrderPaymentEo();
        updatePaymentEo.setId(paymentEo.getId());
        updatePaymentEo.setPayTime(request.getFinishTime());
        updatePaymentEo.setPayStatus(Integer.valueOf(1));
        updatePaymentEo.setPayWay(payRecordEo.getPayMethod());
        this.performOrderPaymentDomain.updateSelective((BaseEo)updatePaymentEo);
        List dgPerformOrderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderId(dgPerformOrderInfoEo.getId());
        List orderLineAmountDtos = dgPerformOrderLineAmountDtos.stream().filter(e -> e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && e.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).collect(Collectors.toList());
        ArrayList insertLineAmounts = Lists.newArrayList();
        for (DgPerformOrderLineAmountDto orderLineAmountDto : orderLineAmountDtos) {
            DgPerformOrderLineAmountEo amountDto = new DgPerformOrderLineAmountEo();
            CubeBeanUtils.copyProperties((Object)amountDto, (Object)orderLineAmountDto, (String[])new String[0]);
            amountDto.setId(null);
            amountDto.setAccountType(payRecordEo.getPayMethod());
            amountDto.setAccountCategory(payRecordEo.getAccountCategory());
            amountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode());
            insertLineAmounts.add(amountDto);
        }
        this.performOrderLineAmountDomain.insertBatch((List)insertLineAmounts);
    }

    @Override
    public void paymentCallbackFail(PaymentMqNotifyReqDto request) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)request.getTradeId()), (String)"\u67e5\u8be2\u53c2\u6570tradeId\u4e0d\u80fd\u4e3a\u7a7a");
        PayRecordEo payRecordEo = this.payRecordDomain.selectByTradeNo(request.getTradeId());
        AssertUtils.isFalse((payRecordEo == null ? 1 : 0) != 0, (String)"\u652f\u4ed8\u6d41\u6c34\u672a\u67e5\u5230");
        PayRecordEo updateEo = new PayRecordEo();
        updateEo.setId(payRecordEo.getId());
        updateEo.setPayStatus(PayStatusEnum.FAIL.getName());
        updateEo.setPayFinishTime(request.getFinishTime());
        updateEo.setPayTime(request.getFinishTime());
        this.payRecordDomain.updateSelective((BaseEo)updateEo);
    }

    private List<AccountTypeBalanceRespDto> queryYFKAccount(DgPerformOrderRespDto dto) {
        AccountQueryReqDto reqDto = new AccountQueryReqDto();
        DgCustomerRespDto dgCustomerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApiProxy.queryById(dto.getPerformOrderSnapshotDto().getCustomerId()));
        AssertUtils.notNull((Object)dgCustomerRespDto, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        String customerGroup = "";
        if (null != dgCustomerRespDto.getCustomerGroupId()) {
            customerGroup = dgCustomerRespDto.getCustomerGroupId().toString();
            reqDto.setCustomerGroup(customerGroup);
        }
        if (null != dgCustomerRespDto.getType()) {
            reqDto.setCustomerType(dgCustomerRespDto.getType().toString());
        }
        reqDto.setOrderTypeCode(Optional.ofNullable(dto.getOrderType()).orElse(DgSaleOrderTypeExtEnum.COMMON_ORDER.getType()));
        reqDto.setCustomerNo(dto.getPerformOrderSnapshotDto().getCustomerCode());
        reqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
        reqDto.setMatchesItems((List)Lists.newArrayList());
        reqDto.setCustomerType(Optional.ofNullable(dgCustomerRespDto.getCustomerTypeId()).map(String::valueOf).orElse(""));
        reqDto.setCustomerGroup(Optional.ofNullable(dgCustomerRespDto.getCustomerGroupId()).map(String::valueOf).orElse(""));
        reqDto.setCustomerAreas(Optional.ofNullable(dgCustomerRespDto.getAreaCode()).orElse(""));
        reqDto.setAccountTypes((List)Lists.newArrayList((Object[])new String[]{"YFK"}));
        List balanceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.orderMatching(reqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)balanceRespDtos), (String)"\u9884\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728");
        return balanceRespDtos.stream().filter(balanceRespDto -> Objects.equals("YFK", balanceRespDto.getAccountType())).collect(Collectors.toList());
    }

    private void autoRefreshAccount(List<AccountDto> accountDtos, DgPerformOrderPayReqDto req, Map<String, AccountTypeDto> accoungtTypeDtoMap) {
        Map accountDtoMap = accountDtos.stream().collect(Collectors.toMap(e -> e.getAccountType(), Function.identity(), (e1, e2) -> e1));
        for (DgBasePayReqDto payReqDto : req.getPayReqDtos()) {
            ArrayList newAccountDtos = Lists.newArrayList();
            AccountDto newAccountDto = (AccountDto)accountDtoMap.get(payReqDto.getPayMethod());
            if (null != newAccountDto.getIsPaymentPeriod() && newAccountDto.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue())) {
                req.setValidNegative(Boolean.FALSE);
                log.info("\u8d26\u671f\u5ba2\u6237\u4e0d\u6821\u9a8c\u6700\u5927\u53ef\u7528\u989d\u5ea6\uff0c\u53ea\u51c6\u4f7f\u7528\u9884\u4ed8\u6b3e\u4ed8\u6b3e");
            }
            if (CollectionUtils.isNotEmpty((Collection)payReqDto.getAccountDtos()) && payReqDto.getAccountDtos().size() > 1) {
                AssertUtils.isTrue((newAccountDto != null && CollectionUtils.isNotEmpty((Collection)newAccountDto.getAccountDtos()) ? 1 : 0) != 0, (String)"\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                Map dtoMap = newAccountDto.getAccountDtos().stream().collect(Collectors.toMap(AccountDto::getSaleCompanyCode, Function.identity(), (e1, e2) -> e1));
                for (AccountDto accountDto : payReqDto.getAccountDtos()) {
                    AccountDto dto1 = (AccountDto)dtoMap.get(accountDto.getSaleCompanyCode());
                    AssertUtils.notNull((Object)dto1, (String)String.format("\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s, %s", payReqDto.getPayMethod(), accountDto.getSaleCompanyCode()));
                    dto1.setAccountCategory((String)Optional.ofNullable(accoungtTypeDtoMap.get(payReqDto.getPayMethod())).map(AccountTypeDto::getCategory).orElse(null));
                    newAccountDtos.add(dto1);
                }
            } else {
                AssertUtils.notNull((Object)newAccountDto, (String)"\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                payReqDto.setMatchesItems(newAccountDto.getItems());
                payReqDto.setGroup(newAccountDto.isGroup());
                payReqDto.setItemCountsType(newAccountDto.getItemCountsType());
                payReqDto.setCreditFileNo(newAccountDto.getCreditFileNo());
                payReqDto.setSaleCompanyCode(newAccountDto.getSaleCompanyCode());
                newAccountDto.setAccountCategory((String)Optional.ofNullable(accoungtTypeDtoMap.get(payReqDto.getPayMethod())).map(AccountTypeDto::getCategory).orElse(null));
                newAccountDtos.add(newAccountDto);
            }
            payReqDto.setPriority(Integer.valueOf(null != newAccountDto.getPriority() ? newAccountDto.getPriority() : 999));
            payReqDto.setIsPaymentPeriod(newAccountDto.getIsPaymentPeriod());
            payReqDto.setAccountCategory((String)Optional.ofNullable(accoungtTypeDtoMap.get(payReqDto.getPayMethod())).map(AccountTypeDto::getCategory).orElse(null));
            payReqDto.setAccountCategoryName((String)Optional.ofNullable(accoungtTypeDtoMap.get(payReqDto.getPayMethod())).map(AccountTypeDto::getDefName).orElse(null));
            payReqDto.setAccountDtos((List)newAccountDtos);
        }
    }

    private void refreshAccountInfo(List<AccountDto> accountDtos, DgPerformOrderPayReqDto req, Map<String, AccountTypeDto> accoungtTypeDtoMap) {
        Map accountDtoMap = accountDtos.stream().collect(Collectors.toMap(e -> e.getAccountType(), Function.identity(), (e1, e2) -> e1));
        for (DgBasePayReqDto payReqDto : req.getPayReqDtos()) {
            AccountTypeDto accountTypeDto;
            AccountDto newAccountDto = (AccountDto)accountDtoMap.get(payReqDto.getPayMethod());
            payReqDto.setAccountCategory(newAccountDto.getAccountCategory());
            payReqDto.setPriority(Integer.valueOf(null != newAccountDto.getPriority() ? newAccountDto.getPriority() : 999));
            payReqDto.setIsPaymentPeriod(newAccountDto.getIsPaymentPeriod());
            payReqDto.setCreditFileNo(newAccountDto.getCreditFileNo());
            payReqDto.setSaleCompanyCode(newAccountDto.getSaleCompanyCode());
            if (null != newAccountDto.getIsPaymentPeriod() && newAccountDto.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue())) {
                req.setValidNegative(Boolean.FALSE);
            }
            if (null != (accountTypeDto = accoungtTypeDtoMap.get(payReqDto.getPayMethod()))) {
                payReqDto.setAccountCategory(accountTypeDto.getCategory());
                payReqDto.setAccountCategoryName(accountTypeDto.getDefName());
                continue;
            }
            log.info("\u8d26\u6237\u3010{}\u3011\u6ca1\u6709\u7c7b\u578b\u540d\u79f0", (Object)payReqDto.getPayMethod());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> executeKneadOrderLinePrice(DgPerformOrderRespDto dto) {
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(dto.getId());
        log.info("\u8ba2\u5355\u884c ===\u300b\u300b\u300b{}", (Object)JSON.toJSONString((Object)orderLineDtos));
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(dto.getSaleOrderNo());
        try {
            this.delAmountList(dto);
            ApportionContext apportionContext = new ApportionContext();
            apportionContext.setOrderLineDtos(orderLineDtos);
            apportionContext.setPayRecordDtos(payRecordDtos);
            apportionContext.setPerformOrderRespDto(dto);
            ChannelOrderKneadPriceSelector.newInstance(dto.getPerformOrderSnapshotDto().getPayCalculateMode()).execute(apportionContext);
        }
        catch (Exception e) {
            log.error("\u63c9\u4ef7\u8ba1\u7b97\u9519\u8bef\uff1a{}", (Throwable)e);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> onlinePay(OnlinePayReqDto onlinePayReqDto) {
        ApportionContext apportionContext = new ApportionContext();
        apportionContext.setOnlinePayReqDto(onlinePayReqDto);
        return RestResponse.VOID;
    }

    private void delAmountList(DgPerformOrderRespDto dto) {
        List lineAmountDtos = this.performOrderLineAmountDomain.queryByOrderId(dto.getId());
        lineAmountDtos.forEach(lineAmount -> {
            if (lineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode())) {
                this.performOrderLineAmountDomain.deleteById(lineAmount.getId());
            } else if (lineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && (lineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_PAY_AMOUNT.getCode()) || lineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode()))) {
                this.performOrderLineAmountDomain.deleteById(lineAmount.getId());
            } else if (lineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && (lineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_AMOUNT.getCode()) || lineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_PROMOTION_KNEAD_TOTAL.getCode()))) {
                this.performOrderLineAmountDomain.deleteById(lineAmount.getId());
            } else if (lineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode()) && lineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_COST_KNEAD_TOTAL.getCode())) {
                this.performOrderLineAmountDomain.deleteById(lineAmount.getId());
            }
        });
        List itemLineAmountDtos = this.performOrderItemLineAmountDomain.queryByOrderId(dto.getId());
        itemLineAmountDtos.forEach(itemLineAmount -> {
            if (itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode())) {
                this.performOrderItemLineAmountDomain.deleteById(itemLineAmount.getId());
            } else if (itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode()) && (itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_PAY_AMOUNT.getCode()) || itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode()))) {
                this.performOrderItemLineAmountDomain.deleteById(itemLineAmount.getId());
            } else if (itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode()) && (itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_PROMOTION_KNEAD_AMOUNT.getCode()) || itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_PROMOTION_KNEAD_TOTAL.getCode()))) {
                this.performOrderItemLineAmountDomain.deleteById(itemLineAmount.getId());
            } else if (itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode()) && itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_COST_KNEAD_TOTAL.getCode())) {
                this.performOrderItemLineAmountDomain.deleteById(itemLineAmount.getId());
            }
        });
    }

    private PayRecordDto buildPayRecordEo(DgPerformOrderRespDto dto, AccountTradeReqDto accountTradeReqDto, DgBasePayReqDto payInfo) {
        PayRecordDto payRecordEo = new PayRecordDto();
        payRecordEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        payRecordEo.setPayStartTime(new Date());
        payRecordEo.setPayTime(new Date());
        payRecordEo.setConfirmTime(new Date());
        payRecordEo.setAuditStatus("pass");
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        payRecordEo.setOrderNo(dto.getSaleOrderNo());
        payRecordEo.setPayMethod(accountTradeReqDto.getAccountType());
        payRecordEo.setPayMethodName(accountTradeReqDto.getAccountTypeName());
        payRecordEo.setAccountCategory(accountTradeReqDto.getAccountCategory());
        payRecordEo.setPayAmount(accountTradeReqDto.getAmount());
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserId(dto.getPerformOrderSnapshotDto().getCustomerId() + "");
        payRecordEo.setPayNo(TradeUtil.generateTradeNo());
        payRecordEo.setTradeNo(payRecordEo.getPayNo());
        payRecordEo.setSellerId(accountTradeReqDto.getSaleCompanyCode());
        payRecordEo.setCardNo(accountTradeReqDto.getCreditFileNo());
        if (CollectionUtil.isNotEmpty((Collection)payInfo.getMatchesItems())) {
            payRecordEo.setExtension(JSON.toJSONString((Object)payInfo.getMatchesItems()));
        }
        payRecordEo.setGroup(payInfo.isGroup());
        payRecordEo.setAccountDtos(payInfo.getAccountDtos());
        Integer priority = 999;
        if (CollectionUtil.isNotEmpty((Collection)payInfo.getAccountDtos()) && ((AccountDto)payInfo.getAccountDtos().get(0)).getPriority() != null) {
            priority = ((AccountDto)payInfo.getAccountDtos().get(0)).getPriority();
        } else if (payInfo.getPriority() != null) {
            priority = payInfo.getPriority();
        }
        payRecordEo.setPriority(priority);
        accountTradeReqDto.setPayRecordId(payRecordEo.getId());
        return payRecordEo;
    }

    @Override
    public CreditRepaymentSimpleDto creditRepayment(DgPerformOrderPayReqDto req, DgPerformOrderRespDto performOrderRespDto) {
        BigDecimal rebateAmount;
        BigDecimal paidAmount;
        CreditRepaymentSimpleDto repaymentSimpleDto = new CreditRepaymentSimpleDto();
        repaymentSimpleDto.setIntercept(Boolean.FALSE);
        DgPerformOrderSnapshotDto performOrderSnapshotDto = performOrderRespDto.getPerformOrderSnapshotDto();
        DgPerformOrderPaymentDto performOrderPaymentDto = performOrderRespDto.getPerformOrderPaymentDto();
        List payReqDtoList = req.getPayReqDtos();
        String saleOrderNo = performOrderRespDto.getSaleOrderNo();
        BigDecimal payAmount = performOrderRespDto.getPerformOrderAmountDto().getPayAmount();
        BigDecimal alreadyCostAmount = BigDecimal.ZERO;
        List payRecordDtos = this.payRecordService.selectListByOrderNo(performOrderRespDto.getSaleOrderNo()).stream().filter(e -> e.getPayStatus().equals(PayStatusEnum.SUCCESS.getName())).filter(o -> o.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(payRecordDtos)) {
            alreadyCostAmount = payRecordDtos.stream().map(PayRecordDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if ((paidAmount = payAmount.subtract(rebateAmount = payReqDtoList.stream().filter(o -> o.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).map(DgBasePayReqDto::getPayAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).subtract(alreadyCostAmount)).compareTo(BigDecimal.ZERO) < 0) {
            paidAmount = BigDecimal.ZERO;
        }
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\u8ba2\u5355\u603b\u91d1\u989d\uff1a{}\uff0c\u5df2\u7ecf\u652f\u4ed8\u8fc7\u7684\u8d39\u7528\u91d1\u989d\uff1a{}\uff0c\u8ba2\u5355\u8fd4\u5229\u652f\u4ed8\u91d1\u989d\uff1a{}\uff0c\u8ba2\u5355\u7ed3\u7b97\u91d1\u989d\uff1a{}", new Object[]{saleOrderNo, payAmount, alreadyCostAmount, rebateAmount, paidAmount});
        RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
        demandRepaymentStrategiesReqDto.setBiNo(saleOrderNo);
        demandRepaymentStrategiesReqDto.setShopId(performOrderSnapshotDto.getShopId());
        demandRepaymentStrategiesReqDto.setCustomerId(performOrderSnapshotDto.getCustomerId());
        demandRepaymentStrategiesReqDto.setPaidAmount(paidAmount);
        demandRepaymentStrategiesReqDto.setRebateAmount(rebateAmount);
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
        RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
        BigDecimal allWaitDebtAmount = BigDecimal.ZERO;
        BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitDebtAmount = BigDecimal.ZERO;
        if (payableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidMultipleAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidMultipleAmount()).orElse(BigDecimal.ZERO);
            waitDebtAmount = payableAmount.subtract(repaidMultipleAmount);
            if (waitDebtAmount.compareTo(BigDecimal.ZERO) >= 0) {
                allWaitDebtAmount = allWaitDebtAmount.add(waitDebtAmount);
            } else {
                waitDebtAmount = payableAmount;
                allWaitDebtAmount = allWaitDebtAmount.add(payableAmount);
            }
        }
        BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
        BigDecimal waitRebatePayableAmount = BigDecimal.ZERO;
        if (rebatePayableAmount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal repaidRebateAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidRebateAmount()).orElse(BigDecimal.ZERO);
            waitRebatePayableAmount = rebatePayableAmount.subtract(repaidRebateAmount);
            if (waitRebatePayableAmount.compareTo(BigDecimal.ZERO) >= 0) {
                allWaitDebtAmount = allWaitDebtAmount.add(waitRebatePayableAmount);
            } else {
                waitRebatePayableAmount = rebatePayableAmount;
                allWaitDebtAmount = allWaitDebtAmount.add(rebatePayableAmount);
            }
        }
        performOrderPaymentDto.setRepaymentAmount(payableAmount);
        performOrderPaymentDto.setRepaymentRebateAmount(waitRebatePayableAmount);
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u672c\u6b21\u652f\u4ed8\u500d\u6570\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{}\uff0c\u672c\u6b21\u652f\u4ed8\u8fd4\u5229\u62b5\u5145\u6b20\u6b3e\u968f\u5355\u8fd8\u6b3e\u91d1\u989d{}", (Object)performOrderPaymentDto.getRepaymentAmount(), (Object)performOrderPaymentDto.getRepaymentRebateAmount());
        if (allWaitDebtAmount.compareTo(BigDecimal.ZERO) > 0) {
            DgPerformOrderPaymentEo performOrderPaymentEo;
            log.info("\u8fdb\u5165\u968f\u5355\u8fd8\u6b3e\u6d41\u7a0b\uff1a{} || \u91d1\u989d\uff1a{}", (Object)performOrderRespDto.getId(), (Object)allWaitDebtAmount);
            BigDecimal accountAmount = BigDecimal.ZERO;
            List<AccountDto> accountDtoList = this.channelAccountService.queryCapitalAccount(saleOrderNo, Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL, AccountCategoryEnum.COST}));
            AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty(accountDtoList), (String)("\u8ba2\u5355\uff1a" + saleOrderNo + "\uff0c\u672a\u627e\u5230\u9884\u4ed8\u6b3e\u8d26\u6237"));
            for (AccountDto accountDto : accountDtoList) {
                if (!"YFK".equals(accountDto.getAccountType())) continue;
                accountAmount = accountAmount.add(accountDto.getDisposable());
            }
            log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\u672c\u6b21\u8fd8\u9700\u8fd8\u6b3e\u91d1\u989d\uff1a{} || \u9884\u4ed8\u6b3e\u8d26\u6237\u4f59\u989d\uff1a{}", new Object[]{saleOrderNo, allWaitDebtAmount, accountAmount});
            repaymentSimpleDto.setCustomerId(performOrderSnapshotDto.getCustomerId());
            repaymentSimpleDto.setCustomerCode(performOrderSnapshotDto.getCustomerCode());
            repaymentSimpleDto.setBizNo(saleOrderNo);
            repaymentSimpleDto.setBillType(Integer.valueOf(1));
            repaymentSimpleDto.setShopId(performOrderSnapshotDto.getShopId());
            repaymentSimpleDto.setReturnDate(new Date());
            repaymentSimpleDto.setValidNegative(Optional.ofNullable(req.getValidNegative()).orElse(Boolean.TRUE));
            repaymentSimpleDto.setAmount(waitDebtAmount);
            repaymentSimpleDto.setRebateAmount(waitRebatePayableAmount);
            List subPayReqDtoList = payReqDtoList.stream().filter(e -> null != e.getIsPaymentPeriod() && e.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) && e.getPayMethod().equals("YFK")).collect(Collectors.toList());
            log.info("\u500d\u6570\u91d1\u989d\uff1a{} || \u500d\u6570\u8fd4\u5229\uff1a{}", (Object)waitDebtAmount, (Object)waitRebatePayableAmount);
            if (CollectionUtil.isEmpty(subPayReqDtoList)) {
                if (accountAmount.compareTo(BigDecimal.ZERO) <= 0 && null != req.getSubmitType() && !req.getSubmitType().equals(SubmitTypeEnum.OVERORDER.getType())) {
                    log.info("\u9884\u4ed8\u6b3e\u8d26\u6237\u91d1\u989d\u5c0f\u4e8e0:{}", (Object)accountAmount);
                    repaymentSimpleDto.setIntercept(Boolean.TRUE);
                    return repaymentSimpleDto;
                }
                log.info("\u975e\u8d26\u671f\u5ba2\u6237\u6821\u9a8c\u91d1\u989d ,\u5f53\u524d\u63d0\u4ea4\u7c7b\u578b\uff1a{}", (Object)req.getSubmitType());
                if (null != req.getSubmitType() && req.getSubmitType().equals(SubmitTypeEnum.AUTO.getType())) {
                    if (allWaitDebtAmount.compareTo(accountAmount) > 0 && accountAmount.compareTo(BigDecimal.ZERO) > 0) {
                        if (waitDebtAmount.compareTo(accountAmount) > 0) {
                            waitDebtAmount = accountAmount;
                            waitRebatePayableAmount = BigDecimal.ZERO;
                            repaymentSimpleDto.setAmount(accountAmount);
                            repaymentSimpleDto.setRebateAmount(BigDecimal.ZERO);
                        }
                        if (accountAmount.compareTo(waitDebtAmount) > 0 && accountAmount.subtract(waitDebtAmount).compareTo(waitRebatePayableAmount) < 0) {
                            waitRebatePayableAmount = accountAmount.subtract(waitDebtAmount);
                            repaymentSimpleDto.setRebateAmount(accountAmount.subtract(waitDebtAmount));
                        }
                        performOrderPaymentEo = this.performOrderPaymentDomain.selectByOrderId(performOrderRespDto.getId());
                        log.info("1-\u539f\u500d\u6570\u91d1\u989d\uff1a{} || \u539f\u500d\u6570\u8fd4\u5229\uff1a{}", (Object)performOrderPaymentEo.getRepaymentAmount(), (Object)performOrderPaymentEo.getRepaymentRebateAmount());
                        log.info("2-\u539f\u500d\u6570\u91d1\u989d\uff1a{} || \u539f\u500d\u6570\u8fd4\u5229\uff1a{}", (Object)performOrderRespDto.getPerformOrderPaymentDto().getRepaymentAmount(), (Object)performOrderRespDto.getPerformOrderPaymentDto().getRepaymentRebateAmount());
                        DgPerformOrderPaymentEo orderPaymentEo = new DgPerformOrderPaymentEo();
                        orderPaymentEo.setId(performOrderPaymentEo.getId());
                        orderPaymentEo.setRepaymentAmount(performOrderPaymentEo.getRepaymentAmount().add(waitDebtAmount));
                        orderPaymentEo.setRepaymentRebateAmount(performOrderPaymentEo.getRepaymentRebateAmount().add(waitRebatePayableAmount));
                        this.performOrderPaymentDomain.updateSelective((BaseEo)orderPaymentEo);
                        log.info("\u8fd8\u6b3e\u5165\u53c2\uff1a{}", JSON.toJSON((Object)repaymentSimpleDto));
                        RestResponseHelper.checkOrThrow((RestResponse)this.creditRepaymentDgApiProxy.demandRepayment(repaymentSimpleDto));
                        repaymentSimpleDto.setIntercept(Boolean.TRUE);
                        return repaymentSimpleDto;
                    }
                } else if (null != req.getSubmitType() && req.getSubmitType().equals(SubmitTypeEnum.OVERORDER.getType())) {
                    repaymentSimpleDto.setValidNegative(Boolean.FALSE);
                } else {
                    AssertUtils.isFalse((allWaitDebtAmount.compareTo(accountAmount) > 0 ? 1 : 0) != 0, (String)("\u8ba2\u5355\uff1a" + saleOrderNo + "\uff0c\u9884\u4ed8\u6b3e\u8d26\u6237\u8fdb\u884c\u4fe1\u7528\u8fd8\u6b3e\u5931\u8d25\uff0c\u652f\u4ed8\u5931\u8d25\uff01\u672c\u6b21\u9700\u8fd8\u6b3e\u91d1\u989d\uff1a" + allWaitDebtAmount + "\uff0c\u8d26\u6237\u4f59\u989d\uff1a" + accountAmount));
                }
            } else {
                repaymentSimpleDto.setValidNegative(Boolean.FALSE);
            }
            payReqDtoList = payReqDtoList.stream().sorted(Comparator.comparing(DgBasePayReqDto::getPriority)).collect(Collectors.toList());
            for (DgBasePayReqDto payReqDto : payReqDtoList) {
                if (!payReqDto.getPayMethod().equals("YFK")) continue;
                if (payReqDto.getPayAmount().compareTo(allWaitDebtAmount) > 0) {
                    payReqDto.setPayAmount(payReqDto.getPayAmount().subtract(allWaitDebtAmount));
                    continue;
                }
                log.info("\u968f\u5355\u8fd8\u6b3e\u540e\u91d1\u989d\u7f6e\u4e3a0");
                payReqDto.setPayAmount(BigDecimal.ZERO);
            }
            payReqDtoList = payReqDtoList.stream().filter(e -> e.getPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            req.setPayReqDtos(payReqDtoList);
            log.info("\u6263\u9664\u968f\u5355\u8fd8\u6b3e\u4ee5\u540e\u652f\u4ed8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)req.getPayReqDtos()));
            performOrderPaymentEo = this.performOrderPaymentDomain.selectByOrderId(performOrderRespDto.getId());
            log.info("\u539f\u500d\u6570\u91d1\u989d\uff1a{} || \u539f\u500d\u6570\u8fd4\u5229\uff1a{}", (Object)performOrderPaymentEo.getRepaymentAmount(), (Object)performOrderPaymentEo.getRepaymentRebateAmount());
            DgPerformOrderPaymentEo orderPaymentEo = new DgPerformOrderPaymentEo();
            orderPaymentEo.setId(performOrderPaymentEo.getId());
            orderPaymentEo.setRepaymentAmount(performOrderPaymentEo.getRepaymentAmount().add(waitDebtAmount));
            orderPaymentEo.setRepaymentRebateAmount(performOrderPaymentEo.getRepaymentRebateAmount().add(waitRebatePayableAmount));
            this.performOrderPaymentDomain.updateSelective((BaseEo)orderPaymentEo);
            return repaymentSimpleDto;
        }
        return null;
    }

    @Override
    public List<DgOrderLabelEnum> modifyOrderStay(OrderStayReqDto req) {
        return this.channelOrderService.modifyOrderStay(req);
    }
}

