/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.oms.common.ICommonMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderInventoryHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisSaleOrderPushTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonMqMessageActionImpl
implements ICommonMqMessageAction {
    private static final Logger log = LoggerFactory.getLogger(CommonMqMessageActionImpl.class);
    @Resource
    private IOrderInventoryHandleAction orderInventoryHandleAction;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordService performNoticeSyncRecordService;

    @Override
    public RestResponse<Void> sendMsgForWaitDelivery(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        DgOutDeliveryResultReqDto outDeliveryResultReqDto = this.performNoticeSyncRecordService.queryOutDeliveryResult(respDto.getId());
        this.orderInventoryHandleAction.sendMsgForDeliveryResult(performOrderRespDto, DgOmsSaleOrderStatus.WAIT_DELIVERY, outDeliveryResultReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgSaleOrderPush(DgPerformOrderRespDto respDto, DgCisSaleOrderPushTypeEnum cisSaleOrderPushTypeEnum) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        switch (cisSaleOrderPushTypeEnum) {
            case CS_AUDIT_PUSH: {
                this.pushSaleOrderVo(saleOrderRespDto, null, "SALE_ORDER_CS_AUDIT_PUSH_TAG");
                break;
            }
            default: {
                throw new BizException("-1", "\u672a\u914d\u7f6e\u63a8\u9001\u7c7b\u578b");
            }
        }
        return RestResponse.VOID;
    }

    private void pushSaleOrderVo(DgPerformOrderRespDto saleOrderRespDto, String topic, String tag) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleOrderRespDto);
        log.info("[\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            this.commonsMqService.publishMessage(topic, tag, (Object)messageVo);
        } else {
            this.commonsMqService.publishMessage(tag, (Object)messageVo);
        }
    }

    @Override
    public RestResponse<Void> sendMsgForAllDelivery(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto request) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        if (request == null) {
            if (CollectionUtils.isNotEmpty((Collection)this.orderLabelRecordDomain.queryExistLabelCode(saleOrderRespDto.getId(), Arrays.asList(DgOrderLabelEnum.VIRTUAL_ORDER)))) {
                log.info("\u865a\u62df\u8ba2\u5355\u53d1\u8d27\u901a\u77e5,\u4e0d\u9700\u8981\u67e5\u8be2\u51fa\u5e93\u4fe1\u606f,\u7ed9\u9ed8\u8ba4\u51fa\u5e93\u4fe1\u606f");
                DgOutDeliveryResultReqDto reqDto = this.buildVirtualOutDeliveryResultReqDto(respDto.getPlatformOrderNo());
                this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, reqDto);
            } else {
                DgOutDeliveryResultReqDto outDeliveryResultReqDto = this.performNoticeSyncRecordService.queryOutDeliveryResult(respDto.getId());
                if (ObjectUtils.isNotEmpty((Object)outDeliveryResultReqDto) && ObjectUtils.isNotEmpty((Object)outDeliveryResultReqDto.getDeliveryTime())) {
                    this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, outDeliveryResultReqDto);
                }
            }
        } else {
            this.orderInventoryHandleAction.sendMsgForDeliveryResult(saleOrderRespDto, DgOmsSaleOrderStatus.DELIVERY_ALL, request);
        }
        return RestResponse.VOID;
    }

    private DgOutDeliveryResultReqDto buildVirtualOutDeliveryResultReqDto(String platformOrderNo) {
        DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
        outDeliveryResultReqDto.setShippingNo("xunifahuo");
        outDeliveryResultReqDto.setShipmentEnterpriseCode("OTHER");
        outDeliveryResultReqDto.setShipmentEnterpriseName("\u5176\u4ed6");
        ArrayList shippingInfoList = Lists.newArrayList();
        DgWmsShippingInfoReqDto shippingInfoReqDto = new DgWmsShippingInfoReqDto();
        shippingInfoReqDto.setShippingNo("xunifahuo");
        shippingInfoReqDto.setShippingCompanyCode("OTHER");
        shippingInfoReqDto.setShippingCompanyName("\u5176\u4ed6");
        shippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDto.setShippingType("ACTUAL_SHIPPING");
        shippingInfoReqDto.setStatus("NORMAL");
        shippingInfoReqDto.setOutNoticeOrderNo("PDON20240330001991");
        shippingInfoReqDto.setPlatformOrderNo(platformOrderNo);
        shippingInfoList.add(shippingInfoReqDto);
        outDeliveryResultReqDto.setShippingInfoList((List)shippingInfoList);
        return outDeliveryResultReqDto;
    }
}

