/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderApiProxy;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessRespDto;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgOmsOrderOptAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgDeliveryModelTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderBatchOptRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderHandleService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderOptService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.vo.ModifyOaidDateVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderCommonHandleActionImpl
implements IOrderCommonHandleAction {
    private static final Logger log = LoggerFactory.getLogger(OrderCommonHandleActionImpl.class);
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IDgOmsOrderHandleService omsOrderHandleService;
    @Resource
    private IOrderCommonHandleService orderCommonHandleService;
    @Resource
    private IDgOmsOrderOptService omsOrderOptService;
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;
    @Resource
    private IDgOmsLabelStrategyRuleService omsLabelStrategyRuleService;
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private IDgPerformOrderWarehouseInfoService dgPerformOrderWarehouseInfoService;
    @Resource
    private IDgOmsOrderOptAction omsOrderOptAction;
    @Resource
    private IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderCalculatorAmountModeDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IInOutNoticeOrderApiProxy inOutNoticeOrderApiProxy;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain dgPerformOrderWarehouseInfoDomain;
    @Resource
    private IDgCustomerStrategyRuleService dgCustomerStrategyRuleService;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Value(value="${yunxi.dg.base.logistics.code:76.0069}")
    private String depponLogisticsCode;
    @Value(value="${yunxi.dg.base.logistics.flag:false}")
    private boolean isDeppon;

    @Override
    public RestResponse<String> createSaleOrder(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto addReqDto) {
        String saleOrderNo = this.orderCommonHandleService.addCisSaleOrder(addReqDto);
        return new RestResponse((Object)saleOrderNo);
    }

    @Override
    public RestResponse<Boolean> doStatusLock(DgPerformOrderRespDto respDto, DgOrderLabelEnum dgOrderLabelEnum, String lockReason) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.omsOrderOptService.doStatusLock(respDto, dgOrderLabelEnum, lockReason));
    }

    @Override
    public RestResponse<Void> doStatusUnLock(DgPerformOrderRespDto respDto, DgOrderLabelEnum dgOrderLabelEnum) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.doStatusUnLock(respDto.getId(), dgOrderLabelEnum);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> doStatusUnAllLock(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.doStatusUnAllLock(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPerformOrder(DgPerformOrderRespDto respDto) {
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)updateReqDto, (Object)respDto, (String[])new String[0]);
        AssertUtils.notNull((Object)updateReqDto.getId(), (String)"\u66f4\u65b0id\u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderInfoDomain.update(updateReqDto);
        return RestResponse.VOID;
    }

    @Override
    public Boolean initOrderAndItemData(DgBizPerformOrderReqDto reqDto) {
        DgShopRespDto shopExtRespDto;
        reqDto.setId(null);
        reqDto.setOriginalOrderNo(null);
        reqDto.setOriginOrderId(null);
        reqDto.setMainOrderNo(null);
        if (StringUtils.isBlank((CharSequence)reqDto.getOrderStatus())) {
            reqDto.setOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getOmsSaleOrderStatus())) {
            reqDto.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        }
        if (StringUtils.equals((CharSequence)reqDto.getOrderType(), (CharSequence)DgSaleOrderTypeEnum.VIRTUAL_ORDER.getType())) {
            reqDto.setDeliveryCompleteDate(new Date());
        }
        reqDto.setOrderSourceModel(DgOrderSourceModelEnum.convertSource((String)reqDto.getOrderSourceModel()));
        Optional.ofNullable(reqDto.getGiftList()).ifPresent(saleOrderItemReqDtos -> saleOrderItemReqDtos.forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setId(null)));
        Optional.ofNullable(reqDto.getItemList()).ifPresent(saleOrderItemReqDtos -> saleOrderItemReqDtos.forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setId(null)));
        Optional.ofNullable(reqDto.getOrderAddrReqDto()).ifPresent(saleOrderAddr -> saleOrderAddr.setId(null));
        reqDto.setPayAmount(Optional.ofNullable(reqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        reqDto.setRealPayAmount(Optional.ofNullable(reqDto.getRealPayAmount()).orElse(BigDecimal.ZERO));
        reqDto.setDiscountAmount(Optional.ofNullable(reqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
        reqDto.setGoodsTotalAmount(Optional.ofNullable(reqDto.getGoodsTotalAmount()).orElse(BigDecimal.ZERO));
        reqDto.setOrderTotalAmount(Optional.ofNullable(reqDto.getOrderTotalAmount()).orElse(BigDecimal.ZERO));
        reqDto.setMerchantReceivableAmount(Optional.ofNullable(reqDto.getMerchantReceivableAmount()).orElse(BigDecimal.ZERO));
        reqDto.setFreightCost(Optional.ofNullable(reqDto.getFreightCost()).orElse(BigDecimal.ZERO));
        Optional.ofNullable(reqDto.getItemList()).ifPresent(itemList -> itemList.forEach(saleOrderItemReqDto -> {
            if (saleOrderItemReqDto.getGift() == null) {
                saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType());
            }
            this.initOrderItemDefaultData((DgPerformOrderItemReqDto)saleOrderItemReqDto);
        }));
        Optional.ofNullable(reqDto.getGiftList()).ifPresent(giftList -> giftList.forEach(saleOrderItemReqDto -> {
            saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
            if (saleOrderItemReqDto.getGiftType() == null) {
                if (reqDto.getManualCreate().booleanValue()) {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                } else {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.PLATFORM.getType());
                }
            }
            this.initOrderItemDefaultData((DgPerformOrderItemReqDto)saleOrderItemReqDto);
        }));
        if (reqDto.getManualCreate().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)reqDto.getDeliveryModelCode())) {
                reqDto.setDeliveryModelCode(DgDeliveryModelTypeEnum.BAN_MODEL.getCode());
            }
        } else {
            reqDto.setDeliveryModelCode(DgDeliveryModelTypeEnum.BAN_MODEL.getCode());
        }
        AssertUtils.notBlank((String)reqDto.getDeliveryModelCode(), (String)"\u53d1\u8d27\u6a21\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (DgDeliveryModelTypeEnum.CONSIGN_MODEL.getCode().equals(reqDto.getDeliveryModelCode())) {
            AssertUtils.notBlank((String)reqDto.getLogicalWarehouseCode(), (String)"\u5bc4\u552e\u53d1\u8d27\u4e0b\u5fc5\u987b\u6307\u5b9a\u53d1\u8d27\u4ed3");
        }
        AssertUtils.isFalse(((shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(reqDto.getPerformOrderSnapshotDto().getShopId()))) == null ? 1 : 0) != 0, (String)"\u672a\u67e5\u5230\u5e97\u94fa\u4fe1\u606f");
        log.info("shopExtRespDto.useSettlementWarehouse:{}", (Object)shopExtRespDto.getUseSettlementWarehouse());
        shopExtRespDto.setUseSettlementWarehouse(shopExtRespDto.getUseSettlementWarehouse() == null ? YesOrNoEnum.NO.getType() : shopExtRespDto.getUseSettlementWarehouse());
        reqDto.setBizType(this.getBizType(shopExtRespDto, reqDto));
        if (reqDto.getPerformOrderSnapshotDto() != null && StringUtils.isBlank((CharSequence)reqDto.getPerformOrderSnapshotDto().getEnterpriseCode())) {
            log.info("\u82e5\u5165\u53c2\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a,\u4ece\u5e97\u94fa\u4fe1\u606f\u83b7\u53d6");
            reqDto.getPerformOrderSnapshotDto().setEnterpriseId(shopExtRespDto.getSaleCompanyId());
            reqDto.getPerformOrderSnapshotDto().setEnterpriseCode(shopExtRespDto.getSaleCompanyCode());
            reqDto.getPerformOrderSnapshotDto().setEnterpriseName(shopExtRespDto.getSaleCompanyName());
        }
        this.verifyHomeInstallation(reqDto);
        this.verifyExpressReachable(reqDto);
        this.initTransferField(reqDto);
        return Boolean.TRUE;
    }

    private String getBizType(DgShopRespDto shopExtRespDto, DgBizPerformOrderReqDto reqDto) {
        if (Objects.equals(shopExtRespDto.getUseSettlementWarehouse(), YesOrNoEnum.YES.getType()) && Objects.equals(shopExtRespDto.getStoreType(), 4)) {
            return DgSaleOrderBizTypeEnum.CONSIGNMENT_BUSINESS.getCode();
        }
        if (Objects.equals(shopExtRespDto.getStoreType(), 2) || Objects.equals(shopExtRespDto.getStoreType(), 3)) {
            return DgSaleOrderBizTypeEnum.DROP_SHIPPING.getCode();
        }
        String consignType = reqDto.getConsignType();
        HashSet cainiaoDeliveryWarehouse = Sets.newHashSet((Object[])new String[]{"taobao", "taobaofenxiao"});
        if (Objects.equals(consignType, DgConsignTypeEnum.THIRD.getType()) && cainiaoDeliveryWarehouse.contains(shopExtRespDto.getChannelCode())) {
            return DgSaleOrderBizTypeEnum.CAINIAO_DELIVERY_WAREHOUSE.getCode();
        }
        HashSet jdDeliveryWarehouse = Sets.newHashSet((Object[])new String[]{"jdfenxiaov2", "jingdong"});
        if (Objects.equals(consignType, DgConsignTypeEnum.THIRD.getType()) && jdDeliveryWarehouse.contains(shopExtRespDto.getChannelCode())) {
            return DgSaleOrderBizTypeEnum.JD_DELIVERY_WAREHOUSE.getCode();
        }
        return DgSaleOrderBizTypeEnum.PTDT.getCode();
    }

    private void initTransferField(DgBizPerformOrderReqDto addReqDto) {
        if (addReqDto.getPerformOrderSnapshotDto() != null && StringUtils.isNotBlank((CharSequence)addReqDto.getPerformOrderSnapshotDto().getShopCode())) {
            DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
            reqDto.setUseSettlementWarehouse(Integer.valueOf(1));
            reqDto.setStoreCode(addReqDto.getPerformOrderSnapshotDto().getShopCode());
            reqDto.setStatusList(Collections.singletonList(1));
            List list = (List)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.queryListShop(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                addReqDto.setIsSettledTransfer(YesOrNoEnum.NO.getType());
            }
        }
    }

    private void verifyExpressReachable(DgBizPerformOrderReqDto addReqDto) {
        log.info("verifyExpressReachable:{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        try {
            if (null != addReqDto.getShipmentEnterpriseCode()) {
                DgPerformOrderAddrReqDto orderAddrReqDto = addReqDto.getOrderAddrReqDto();
                String addrdetail = addReqDto.getAddress();
                String shipmentEnterpriseCode = addReqDto.getShipmentEnterpriseCode();
                String addr = orderAddrReqDto.getProvince() + orderAddrReqDto.getCity() + orderAddrReqDto.getCounty() + addrdetail;
                String receiveName = orderAddrReqDto.getReceiveName();
                String receivePhone = orderAddrReqDto.getReceivePhone();
                VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto = new VerificationDeliveryAccessReqDto();
                verificationDeliveryAccessReqDto.setRecManName(receiveName);
                verificationDeliveryAccessReqDto.setRecManMobile(receivePhone);
                verificationDeliveryAccessReqDto.setRecManPrintAddr(addr);
                verificationDeliveryAccessReqDto.setKuaidicom(shipmentEnterpriseCode);
                if (StringUtils.isNotEmpty((CharSequence)shipmentEnterpriseCode) && this.depponLogisticsCode.equals(shipmentEnterpriseCode) && this.isDeppon) {
                    VerificationDeliveryAccessRespDto depponDeliveryAccessRespDto = this.dgPerformOrderWarehouseInfoService.verificationDepponDeliveryAccess(addReqDto, verificationDeliveryAccessReqDto, orderAddrReqDto);
                    String reachable = depponDeliveryAccessRespDto.getReachable();
                    if (reachable.equals("0")) {
                        addReqDto.setWhetherToFlow("no");
                        addReqDto.setUnreachableCause(depponDeliveryAccessRespDto.getReason());
                    }
                } else {
                    VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = this.dgPerformOrderWarehouseInfoService.verifyDeliveryAccessibility(null, verificationDeliveryAccessReqDto, "3");
                    String reachable = verificationDeliveryAccessRespDto.getReachable();
                    if (reachable.equals("0")) {
                        addReqDto.setWhetherToFlow("no");
                        addReqDto.setUnreachableCause(verificationDeliveryAccessRespDto.getReason());
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("\u521b\u5efa\u8ba2\u5355\u6821\u9a8c\u53ef\u8fbe\u6027\u62a5\u9519", (Throwable)e);
        }
    }

    private void verifyHomeInstallation(DgBizPerformOrderReqDto addReqDto) {
        try {
            if (null == addReqDto.getHomeInstallation() && (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList()) || CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList()))) {
                DgCustomerAuditStrategyRuleRespDto dgCustomerAuditStrategyRuleRespDto = this.dgCustomerStrategyRuleService.queryByRuleCode(DgCisStrategyOrderTypeEnum.ORDER_INSTALL_STRATEGY.getCode());
                log.info("\u5f00\u542f\u81ea\u52a8\u7b56\u7565\u903b\u8f91\u5224\u65ad\uff1a{}", (Object)JSON.toJSONString((Object)dgCustomerAuditStrategyRuleRespDto));
                if (null != dgCustomerAuditStrategyRuleRespDto.getInstallationVerificationStrategy()) {
                    DgPerformOrderSnapshotDto performOrderSnapshotDto = addReqDto.getPerformOrderSnapshotDto();
                    String shopCode = performOrderSnapshotDto.getShopCode();
                    boolean action = this.dgCustomerStrategyRuleService.verifyOrderInstallStrategy(dgCustomerAuditStrategyRuleRespDto, shopCode);
                    Integer installationVerificationStrategy = dgCustomerAuditStrategyRuleRespDto.getInstallationVerificationStrategy();
                    ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
                    List itemList = addReqDto.getItemList();
                    if (CollectionUtils.isEmpty((Collection)itemList)) {
                        itemList = addReqDto.getGiftList();
                    }
                    List skuCodes = itemList.stream().map(DgPerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
                    itemQueryDgReqDto.setSkuCodes(skuCodes);
                    RestResponse pageInfoRestResponse = this.iItemSkuDgQueryApiProxy.queryItemListByPage(itemQueryDgReqDto);
                    PageInfo dgItemSkuPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                    boolean itemAction = false;
                    if (null != dgItemSkuPageRespDtoPageInfo && CollectionUtils.isNotEmpty((Collection)dgItemSkuPageRespDtoPageInfo.getList())) {
                        List pageRespDtos = dgItemSkuPageRespDtoPageInfo.getList();
                        for (DgItemSkuPageRespDto pageRespDto : pageRespDtos) {
                            if (1 != pageRespDto.getHomeInstall()) continue;
                            itemAction = true;
                            break;
                        }
                    }
                    if (1 == installationVerificationStrategy && action && itemAction) {
                        addReqDto.setHomeInstallation("1");
                    } else {
                        addReqDto.setHomeInstallation("0");
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("\u7ef4\u62a4\u4e0a\u95e8\u5b89\u88c5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void initOrderItemDefaultData(DgPerformOrderItemReqDto saleOrderItemReqDto) {
        saleOrderItemReqDto.setCalcItemNum(Optional.ofNullable(saleOrderItemReqDto.getItemNum()).orElse(BigDecimal.ONE));
        saleOrderItemReqDto.setPrice(Optional.ofNullable(saleOrderItemReqDto.getPrice()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setPayAmount(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setRealPayAmount(Optional.ofNullable(saleOrderItemReqDto.getRealPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setDiscountAmount(Optional.ofNullable(saleOrderItemReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setGroupItemPayAmount(Optional.ofNullable(saleOrderItemReqDto.getGroupItemPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setGroupItemDiscountAmount(Optional.ofNullable(saleOrderItemReqDto.getGroupItemDiscountAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setSurplusCanRefundPayAmount(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
        saleOrderItemReqDto.setSurplusCanReturnItemNum(Optional.ofNullable(saleOrderItemReqDto.getItemNum()).orElse(BigDecimal.ZERO));
    }

    @Override
    public RestResponse<Void> modifyOrderInternalRemark(Long id, String remark) {
        this.orderCommonHandleService.modifyOrderInternalRemark(id, remark);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> arrangeWarehouse(DgPerformOrderRespDto respDto, DgArrangeWarehouseReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderCommonHandleService.arrangeWarehouse(respDto.getId(), reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> assignPlanShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto req) {
        this.orderCommonHandleService.assignPlanShipmentEnterprise(req);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> assignShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto req) {
        this.orderCommonHandleService.assignShipmentEnterprise(req);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeLogicalWarehouseCode(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderCommonHandleService.removeLogicalWarehouseCode(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> autoPreemptChannelInventory(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderHandleService.autoPreemptChannelInventory(respDto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> markTagByExtendsParentOrder(DgPerformOrderRespDto performOrderInfoDto) {
        List tagExtendRecordRespDtos;
        AssertUtils.notNull((Object)performOrderInfoDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderTagRecordReqDto tagRecordReqDto = new DgOrderTagRecordReqDto();
        tagRecordReqDto.setOrderId(performOrderInfoDto.getId());
        List tagRecordRespDtos = this.orderTagRecordDomain.queryByParam(tagRecordReqDto);
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(performOrderInfoDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)tagRecordRespDtos) && CollectionUtils.isNotEmpty((Collection)releationEos) && CollectionUtils.isNotEmpty(tagExtendRecordRespDtos = tagRecordRespDtos.stream().filter(dto -> dto.getTagExtend() == 1).collect(Collectors.toList()))) {
            List tagCodes = tagExtendRecordRespDtos.stream().map(DgOrderTagRecordDto::getTagCode).collect(Collectors.toList());
            List orderIds = releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            log.info("[\u6839\u636e\u7236\u5355\u7ee7\u627f\u6807\u7b7e]tagCodes:{},orderIds:{}", (Object)JSON.toJSONString(tagCodes), (Object)JSON.toJSONString(orderIds));
            this.orderTagRecordDomain.batchInsert(tagCodes, orderIds);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> calculatorOrderAmountBySplit(DgPerformOrderRespDto throughSaleOrderDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.omsOrderCalculatorAmountModeDomain.calculatorOrderAmountBySplit(orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelOrder(DgPerformOrderRespDto respDto, String cancelReason) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderCommonHandleService.cancelSaleOrder(respDto.getId(), cancelReason);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> reAppoint(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean deliver = this.omsOrderOptService.continueDeliver(respDto.getId());
        return new RestResponse((Object)deliver);
    }

    @Override
    public RestResponse<Boolean> cancelAppoint(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean deliver = this.omsOrderOptService.cancelDeliver(respDto.getId());
        return new RestResponse((Object)deliver);
    }

    @Override
    public RestResponse<Void> confirmReceiveGoods(DgPerformOrderRespDto respDto, DgConfirmReceiveOrderReqDto request) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsOrderOptService.confirmSignGoods(respDto.getId(), request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgMatchStrategyResultDto> matchAutoStrategy(DgPerformOrderRespDto respDto, DgStrategyPoolRespDto dgStrategyPoolRespDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        DgMatchStrategyResultDto resultDto = this.dgOrderAutoStrategyRuleService.matchOrderStrategy(respDto.getId(), dgCisStrategyOrderTypeEnum);
        resultDto.setDgStrategyPoolRespDto(dgStrategyPoolRespDto);
        return new RestResponse((Object)resultDto);
    }

    @Override
    public RestResponse<DgStrategyPoolRespDto> loadStrategyPoolDto(DgPerformOrderRespDto respDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        return new RestResponse((Object)this.dgStrategyPoolService.queryWaitHitByOrderId(respDto.getId(), dgCisStrategyOrderTypeEnum.getCode()));
    }

    @Override
    public RestResponse<Void> hitStrategyPoolAndRemove(DgPerformOrderRespDto respDto, DgMatchStrategyResultDto dgMatchStrategyResultDto) {
        this.dgOrderAutoStrategyRuleService.modifyAndRemoveStrategyPool(dgMatchStrategyResultDto.getDgStrategyPoolRespDto());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> matchAutoTagStrategy(DgPerformOrderRespDto reqDto) {
        try {
            this.omsLabelStrategyRuleService.queryByParam(reqDto);
        }
        catch (Exception e) {
            log.info("\u81ea\u52a8\u6807\u7b7e\u6253\u6807\u5931\u8d25");
            e.printStackTrace();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> matchAutoTagStrategyByChild(List<DgPerformOrderRespDto> childOrderList) {
        childOrderList.forEach(reqDto -> this.matchAutoTagStrategy((DgPerformOrderRespDto)reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyInterceptReason(DgPerformOrderRespDto respDto, String interceptReason) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        log.info(respDto.getId() + "\u66f4\u65b0\u62e6\u622a\u539f\u56e0\uff1a" + interceptReason);
        DgBizPerformOrderReqDto dgPerformOrderReqDto = new DgBizPerformOrderReqDto();
        dgPerformOrderReqDto.setId(respDto.getId());
        dgPerformOrderReqDto.setInterceptReason(interceptReason);
        this.omsOrderInfoDomain.update((DgPerformOrderReqDto)dgPerformOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(OrderRemarkReqDto req) {
        this.orderCommonHandleService.modifyOrderRemark(req);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgPerformOrderBatchOptRespDto> batchModifyOrderRemark(OrderRemarkReqDto req) {
        return new RestResponse((Object)this.orderCommonHandleService.batchModifyOrderRemark(req));
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(DgPerformOrderRespDto respDto, DgPerformOrderReqDto orderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)orderReqDto.getRemark(), (String)"\u8ba2\u5355\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        OrderRemarkReqDto req = new OrderRemarkReqDto();
        req.setId(respDto.getId());
        req.setRemark(orderReqDto.getRemark());
        this.orderCommonHandleService.modifyOrderRemark(req);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyAddress(DgPerformOrderRespDto respDto, DgPerformOrderAddrReqDto addrReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        addrReqDto.setOrderId(respDto.getId());
        VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto = new VerificationDeliveryAccessReqDto();
        verificationDeliveryAccessReqDto.setRecManName(addrReqDto.getReceiveName());
        verificationDeliveryAccessReqDto.setRecManMobile(addrReqDto.getReceivePhone());
        String province = addrReqDto.getProvince();
        String city = addrReqDto.getCity();
        String county = addrReqDto.getCounty();
        String receiveAddress = addrReqDto.getReceiveAddress();
        verificationDeliveryAccessReqDto.setRecManPrintAddr(province + city + county + receiveAddress);
        verificationDeliveryAccessReqDto.setAction(Boolean.valueOf(true));
        this.dgPerformOrderWarehouseInfoService.verifyDeliveryAccessibility(respDto.getId(), verificationDeliveryAccessReqDto, "1");
        this.orderCommonHandleService.modifyAddress(addrReqDto);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyAddressRevocationBusinessAudit(DgPerformOrderRespDto respDto, DgPerformOrderAddrReqDto addrReqDto) {
        log.info("\u4fee\u6539\u5730\u5740\u64a4\u56de\u5546\u5ba1 -- action");
        respDto.setRevokeReason("\u4fee\u6539\u5730\u5740\u7cfb\u7edf\u81ea\u52a8\u64a4\u56de\u5546\u5ba1");
        this.dgOrderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.SG_MODIFY_ADDRESS);
        this.modifyAddress(respDto, addrReqDto);
        this.omsOrderOptAction.revocationAudit(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderOaid(DgPerformOrderRespDto respDto, String oaid) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        ModifyOaidDateVo modifyOaidDateVo = new ModifyOaidDateVo();
        modifyOaidDateVo.setSaleOrderId(respDto.getId());
        modifyOaidDateVo.setOaid(oaid);
        this.orderCommonHandleService.modifyOaid(modifyOaidDateVo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPlanDeliveryDate(DgPerformOrderRespDto respDto, String newDate) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderCommonHandleService.modifyPlanDeliveryDate(respDto.getId(), newDate);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyDeliveryDate(DgPerformOrderRespDto respDto, String newDate) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.orderCommonHandleService.modifyDeliveryDate(respDto.getId(), newDate);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> logicDeleteOrder(DgPerformOrderRespDto dto) {
        this.orderCommonHandleService.logicDeleteOrder(dto.getId());
        return RestResponse.VOID;
    }
}

