/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedQueryApi;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentParamQueryDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IRelWarehouseShipmentQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.OrderSkuPriceControlCheckDetailReqDto;
import com.yunxi.dg.base.center.price.dto.request.OrderSkuPriceControlCheckReqDto;
import com.yunxi.dg.base.center.price.dto.response.OrderSkuPriceControlCheckRespDto;
import com.yunxi.dg.base.center.price.proxy.api.IDgPriceControlApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgDeliveryModelTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.guard.b2c.IDgOmsOrderGuard;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.transform.dto.request.TrLogisticsMappingRelationReqDto;
import com.yunxi.dg.base.center.transform.dto.response.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.center.transform.proxy.query.ITrLogisticsMappingRelationQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgOmsOrderGuardImpl
implements IDgOmsOrderGuard {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderGuardImpl.class);
    @Value(value="${oms.sale.order.ship.logistics.relation.enable:false}")
    private Boolean shipLogisticsRelationEnable;
    @Resource
    private IRelWarehouseShipmentQueryApiProxy relWarehouseShipmentQueryApiProxy;
    @Resource
    private ITrLogisticsMappingRelationQueryApiProxy trLogisticsMappingRelationQueryApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IDgPriceControlApiProxy priceControlApiProxy;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private ILogicInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    private IDgStrategyOrderService strategyOrderService;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private ICalculateAmountService channelCalculateAmountService;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain dgPerformOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoService dgPerformOrderWarehouseInfoService;

    @Override
    public Boolean checkWarehouseCodeAndShippRela(String logicalWarehouseCode, String shippCode) {
        if (logicalWarehouseCode == null || shippCode == null) {
            return Boolean.FALSE;
        }
        log.info("[\u5224\u65ad\u4ed3\u5e93\u548c\u7269\u6d41\u5173\u7cfb]\u8c03\u7528\u5e93\u5b58\u5165\u53c2\uff1alogicalWarehouseCode={},shippCode={}", (Object)logicalWarehouseCode, (Object)shippCode);
        RelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto = new RelWarehouseShipmentParamQueryDto();
        relWarehouseShipmentParamQueryDto.setWarehouseCode(logicalWarehouseCode);
        relWarehouseShipmentParamQueryDto.setShipmentEnterpriseCode(shippCode);
        List csRelWarehouseShipmentRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.relWarehouseShipmentQueryApiProxy.queryByParam(relWarehouseShipmentParamQueryDto));
        log.info("[\u5224\u65ad\u4ed3\u5e93\u548c\u7269\u6d41\u5173\u7cfb]\u8c03\u7528\u5e93\u5b58\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)csRelWarehouseShipmentRespDtos));
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentRespDtos)) {
            return Boolean.FALSE;
        }
        return csRelWarehouseShipmentRespDtos.stream().anyMatch(dto -> shippCode.equals(dto.getShipmentEnterpriseCode()));
    }

    @Override
    public Boolean checkOrderContainsGift(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        return orderItemLineDtos.stream().filter(saleOrderItemRespDto -> DgGiftEnum.GIFT.getType().equals(saleOrderItemRespDto.getGiftFlag())).count() > 0L;
    }

    @Override
    public Boolean validationCreateOrder(DgBizPerformOrderReqDto reqDto) {
        log.info("\u8ba2\u5355\u5165\u53c2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.validationOrder(reqDto);
        this.validationOrderItem(reqDto);
        return Boolean.TRUE;
    }

    private void validationOrder(DgBizPerformOrderReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrderType(), (String)"orderType\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getPerformOrderSnapshotDto().getShopCode(), (String)"shopCode\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validationOrderItem(DgBizPerformOrderReqDto reqDto) {
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemList())) {
            mergeList.addAll(reqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getGiftList())) {
            mergeList.addAll(reqDto.getGiftList());
        }
        AssertUtils.notEmpty((Collection)mergeList, (String)"\u5546\u54c1/\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        for (DgPerformOrderItemReqDto saleOrderItemReqDto : mergeList) {
            AssertUtils.notBlank((String)saleOrderItemReqDto.getSkuCode(), (String)"\u5546\u54c1skucode\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderItemReqDto.getItemNum(), (String)"itemNum=%s\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{saleOrderItemReqDto.getItemNum()});
        }
    }

    @Override
    public Boolean checkOrderOfVirtual(DgPerformOrderRespDto request) {
        if (StringUtils.equals((CharSequence)request.getOrderType(), (CharSequence)DgSaleOrderTypeEnum.VIRTUAL_ORDER.getType()) && !DgOrderSourceModelEnum.THIRDPARTY.getCode().equals(request.getOrderSourceModel())) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u865a\u62df\u8ba2\u5355]\u5f53\u524d\u8ba2\u5355\u5c5e\u4e8e\u5185\u90e8\u8ba2\u5355\u3001\u865a\u62df\u8ba2\u5355\uff0c\u5e73\u53f0\u5355\u53f7\u4e3a\uff1a{}", (Object)request.getPlatformOrderNo());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkGiftOrderGuard(DgPerformOrderRespDto through) {
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)orderItemLineDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = orderItemLineDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(DgGiftEnum.GIFT.getType(), saleOrderItemRespDto.getGiftFlag())).count();
        if (giftCount == (long)orderItemLineDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkVirtualOrderGuard(DgPerformOrderRespDto through) {
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)orderItemLineDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = orderItemLineDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(saleOrderItemRespDto.getItemType(), DgSaleOrderItemTypeEnum.VIRTUAL.getType())).count();
        if (giftCount == (long)orderItemLineDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkServiceOrderGuard(DgPerformOrderRespDto through) {
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)orderItemLineDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = orderItemLineDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(saleOrderItemRespDto.getItemType(), DgSaleOrderItemTypeEnum.SERVICE.getType())).count();
        if (giftCount == (long)orderItemLineDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkAllOfExchangeFix(DgPerformOrderRespDto respDto) {
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)orderItemLineDtos)) {
            for (DgPerformOrderLineDto orderItemLineDto : orderItemLineDtos) {
                if (DgSaleOrderBizTypeEnum.YHDX.getCode().equals(orderItemLineDto.getItemAttr())) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkOrderCanSplit(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355ID\u4e3a\u7a7a");
        List orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        if (CollectionUtils.isEmpty((Collection)orderItemLineDtos)) {
            int retryCount = 0;
            while (CollectionUtils.isEmpty((Collection)orderItemLineDtos) && retryCount <= 10) {
                try {
                    orderItemLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
                    log.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u7b2c{}\u6b21\u91cd\u8bd5", (Object)retryCount);
                    if (!CollectionUtils.isEmpty((Collection)orderItemLineDtos)) continue;
                    ++retryCount;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
        }
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderItemLineDtos), (String)"\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
        if (orderItemLineDtos.size() == 1) {
            return Boolean.FALSE;
        }
        if (this.checkSplitOrderByMultiWarehouse(bizSaleOrderReqDto).booleanValue()) {
            return Boolean.TRUE;
        }
        List splitSaleOrderItemRespDtos = orderItemLineDtos.stream().filter(saleOrderItemRespDto -> DgSaleOrderBizTypeEnum.YHDX.getCode().equals(saleOrderItemRespDto.getItemAttr())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(splitSaleOrderItemRespDtos) && splitSaleOrderItemRespDtos.size() == orderItemLineDtos.size()) {
            return Boolean.FALSE;
        }
        List performOrderServiceItemDtos = orderItemLineDtos.stream().filter(e -> DgSaleOrderItemTypeEnum.SERVICE.getType().equals(e.getItemType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderServiceItemDtos) && performOrderServiceItemDtos.size() == orderItemLineDtos.size()) {
            return Boolean.FALSE;
        }
        List performOrderVirtualItemDtos = orderItemLineDtos.stream().filter(e -> DgSaleOrderItemTypeEnum.VIRTUAL.getType().equals(e.getItemType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderVirtualItemDtos) && performOrderVirtualItemDtos.size() == orderItemLineDtos.size()) {
            return Boolean.FALSE;
        }
        List performOrderDefaultItemDtos = orderItemLineDtos.stream().filter(e -> !DgSaleOrderItemTypeEnum.VIRTUAL.getType().equals(e.getItemType()) && !DgSaleOrderItemTypeEnum.SERVICE.getType().equals(e.getItemType()) && !DgSaleOrderBizTypeEnum.YHDX.getCode().equals(respDto.getBizType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderDefaultItemDtos) && performOrderDefaultItemDtos.size() == orderItemLineDtos.size()) {
            return Boolean.FALSE;
        }
        ArrayList allItems = Lists.newArrayList((Object[])new List[]{performOrderServiceItemDtos, performOrderVirtualItemDtos, performOrderDefaultItemDtos});
        Integer splitSize = allItems.stream().filter(list -> CollectionUtils.isNotEmpty((Collection)list)).collect(Collectors.toList()).size();
        if (splitSize == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkSplitOrderByMultiWarehouse(DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        Map<String, List<DgPerformOrderItemReqDto>> orderItemResultMap;
        AssertUtils.notNull((Object)bizSaleOrderReqDto, (String)"\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getItemList())) {
            mergeList.addAll(bizSaleOrderReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getGiftList())) {
            mergeList.addAll(bizSaleOrderReqDto.getGiftList());
        }
        if ((orderItemResultMap = mergeList.stream().filter(saleOrderItemReqDto -> StringUtils.isNotBlank((CharSequence)saleOrderItemReqDto.getLogicalWarehouseCode())).collect(Collectors.groupingBy(DgPerformOrderItemDto::getLogicalWarehouseCode))).size() > 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkAutoAuditGuard(DgPerformOrderRespDto through, String strategyType) {
        List<DgStrategyOrderRespDto> orderRespDtoList = this.strategyOrderService.queryValidStrategyOrderList(through.getId(), strategyType);
        if (CollectionUtils.isNotEmpty(orderRespDtoList)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkAndSaveSkuPriceResultByOrder(DgPerformOrderRespDto through) {
        ArrayList skuDtoList = new ArrayList();
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(through.getId());
        Map<Long, BigDecimal> orderLineAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
        through.getOrderLineList().forEach(orderLine -> {
            if (orderLine.getGiftFlag().equals(DgGiftEnum.GIFT.getType())) {
                return;
            }
            OrderSkuPriceControlCheckDetailReqDto item = new OrderSkuPriceControlCheckDetailReqDto();
            item.setSpuId(Long.valueOf(-1L));
            item.setSpuCode("");
            item.setSpuName("");
            item.setSkuId(orderLine.getSkuId());
            item.setSkuCode(orderLine.getSkuCode());
            item.setSkuName(orderLine.getSkuName());
            item.setRowId(orderLine.getId());
            item.setPurchaseQuantity(Integer.valueOf(orderLine.getItemNum().intValue()));
            item.setRetailPrice(orderLineAmountMap.get(orderLine.getId()) != null ? ((BigDecimal)orderLineAmountMap.get(orderLine.getId())).divide(orderLine.getItemNum(), 2, 4) : BigDecimal.ZERO);
            skuDtoList.add(item);
        });
        OrderSkuPriceControlCheckReqDto reqDto = new OrderSkuPriceControlCheckReqDto();
        reqDto.setShopCode(through.getPerformOrderSnapshotDto().getShopCode());
        reqDto.setPlatformOrderNo(through.getPlatformOrderNo());
        reqDto.setCustomerId(through.getPerformOrderSnapshotDto().getCustomerId());
        reqDto.setShopName(through.getPerformOrderSnapshotDto().getShopName());
        reqDto.setOrderStatus(through.getOrderStatus());
        reqDto.setShopId(through.getPerformOrderSnapshotDto().getShopId());
        reqDto.setSalesOrderNo(through.getSaleOrderNo());
        reqDto.setSkuDtoList(skuDtoList);
        log.info("\u7ba1\u63a7\u4ef7\u683c\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponse restResponse = this.priceControlApiProxy.checkAndSaveSkuPriceResultByOrder(reqDto);
        log.info("\u7ba1\u63a7\u4ef7\u683c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        if (restResponse.getData() != null) {
            if (((OrderSkuPriceControlCheckRespDto)restResponse.getData()).getOrderCheckResult().equals("pass")) {
                return true;
            }
            DgPerformOrderInfoEo orderInfoEo = new DgPerformOrderInfoEo();
            orderInfoEo.setId(through.getId());
            orderInfoEo.setInterceptReason("\u7ba1\u63a7\u4ef7\u6821\u9a8c\u4e0d\u901a\u8fc7");
            this.performOrderInfoDomain.updateSelective((BaseEo)orderInfoEo);
            return false;
        }
        return false;
    }

    @Override
    public Boolean checkCsAuditGuard(DgPerformOrderRespDto through) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(through.getId());
        if (performOrderRespDto.getPlanDeliveryTime() != null && performOrderRespDto.getPlanDeliveryTime().compareTo(new Date()) > 0) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u5ba2\u5ba1]\u9884\u8ba1\u53d1\u8d27\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba2\u5ba1");
            throw DgPcpTradeExceptionCode.BUSINESS_AUDIT_BY_PLAN_TIME.builderException();
        }
        List existLabelCode = this.orderLabelRecordDomain.queryExistLabelCode(through.getId(), Arrays.asList(DgOrderLabelEnum.LOCK, DgOrderLabelEnum.REFUND_INTERCEPT, DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT));
        if (CollectionUtils.isNotEmpty((Collection)existLabelCode)) {
            throw DgPcpTradeExceptionCode.CS_AUDIT_EXCEPTION_BY_REFUND_INTERCEPT.builderException();
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkResetCsGuard(DgPerformOrderRespDto through) {
        if (DgOrderSourceModelEnum.THIRDPARTY.getCode().equals(through.getOrderSourceModel())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkBalanceControlGuard(DgPerformOrderRespDto through) {
        if (StringUtils.isNotBlank((CharSequence)through.getDeliveryModelCode()) && DgDeliveryModelTypeEnum.CONSIGN_MODEL.getCode().equals(through.getDeliveryModelCode())) {
            log.info("\u5bc4\u552e\u53d1\u8d27\u4e0d\u505a\u4f59\u989d\u7ba1\u63a7");
            return Boolean.TRUE;
        }
        List payRecordEos = this.payRecordDomain.selectListByOrderNoAndStatus(through.getSaleOrderNo(), PayStatusEnum.SUCCESS.getName());
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            log.info("\u5df2\u7ecf\u6263\u6b3e\u8fc7\u8bf4\u660e\u8fd9\u5f20\u5355\u5b50\u662f\u5546\u5ba1\u540e\u64a4\u56de\u5546\u5ba1\u7684\uff0c\u4e0d\u8bfb\u53d6\u662f\u5426\u5f00\u542f\u4f59\u989d\u7ba1\u63a7\uff0c\u9ed8\u8ba4\u91cd\u65b0\u5546\u5ba1\u90fd\u9700\u8981\u9884\u5360\u989d\u5ea6");
            return Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((CharSequence)through.getExchangeOrderNo())) {
            DgAfterSaleOrderEo afterSaleOrderEo = this.dgAfterSaleOrderDomain.queryEoByNo(through.getExchangeOrderNo());
            if (Objects.nonNull(afterSaleOrderEo) && Objects.nonNull(afterSaleOrderEo.getSaleOrderId())) {
                DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(afterSaleOrderEo.getSaleOrderId());
                List orignalOrderPayRecordEos = this.payRecordDomain.selectListByOrderNoAndStatus(dgPerformOrderInfoEo.getSaleOrderNo(), PayStatusEnum.SUCCESS.getName());
                if (CollectionUtils.isNotEmpty((Collection)orignalOrderPayRecordEos)) {
                    log.info("\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u5355\uff0c\u539f\u5355\u6263\u8fc7\u6b3e\uff0c\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u5355\u4e5f\u9700\u8981\u6263\u6b3e");
                    return Boolean.FALSE;
                }
                log.info("\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u5355\uff0c\u539f\u5355\u672a\u6263\u8fc7\u6b3e\uff0c\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u5355\u4e0d\u9700\u8981\u6263\u6b3e");
                return Boolean.TRUE;
            }
            log.info("\u65e0\u539f\u5355\u6362\u8d27\u751f\u6210\u7684\u9500\u552e\u5355\uff0c\u4e0d\u9700\u8981\u6263\u6b3e");
            return Boolean.TRUE;
        }
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(through.getPerformOrderSnapshotDto().getShopId()));
        log.info("checkBalanceControlGuard - \u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shopExtRespDto));
        AssertUtils.notNull((Object)shopExtRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        if (YesOrNoEnum.NO.getType().equals(shopExtRespDto.getIsBalanceControl())) {
            log.info("\u5e97\u94fa\u672a\u5f00\u542f\u4f59\u989d\u7ba1\u63a7,\u5219\u4e0d\u9700\u8981\u6821\u9a8c\u4f59\u989d");
            return Boolean.TRUE;
        }
        if (shopExtRespDto.getStoreType().equals(2) || shopExtRespDto.getStoreType().equals(3) || shopExtRespDto.getStoreType().equals(4)) {
            log.info("\u5206\u9500\u3001\u7ecf\u9500\u3001\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u7c7b\u578b\u5b58\u5728\u9700\u8981\u505a\u4f59\u989d\u7ba1\u63a7\u7684\u573a\u666f");
            return Boolean.FALSE;
        }
        log.info("\u975e\u5206\u9500\u3001\u7ecf\u9500\u3001\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u7c7b\u578b\u4e0d\u9700\u8981\u505a\u4f59\u989d\u7ba1\u63a7");
        return Boolean.TRUE;
    }

    @Override
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u9700\u8981\u4fdd\u5b58\u4f9b\u8d27\u4ef7", notes="\u5224\u65ad\u662f\u5426\u9700\u8981\u4fdd\u5b58\u4f9b\u8d27\u4ef7")
    public Boolean checkOrderSupplyPriceSaveGuard(DgPerformOrderRespDto through) {
        if (StringUtils.isNotBlank((CharSequence)through.getDeliveryModelCode()) && DgDeliveryModelTypeEnum.CONSIGN_MODEL.getCode().equals(through.getDeliveryModelCode())) {
            log.info("\u5bc4\u552e\u53d1\u8d27\u4e0d\u4fdd\u5b58\u4f9b\u8d27\u4ef7");
            return Boolean.FALSE;
        }
        log.info("\u5224\u65ad\u662f\u5426\u9700\u8981\u4fdd\u5b58\u4f9b\u8d27\u4ef7");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(through.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        AssertUtils.isFalse((shopExtRespDto == null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5e97\u94fa\u4fe1\u606f");
        if (2 == shopExtRespDto.getStoreType() || 3 == shopExtRespDto.getStoreType() || 4 == shopExtRespDto.getStoreType()) {
            log.info("\u7ecf\u9500\uff0c\u5206\u9500\uff0c\u5382\u9001\u5e97\u94fa\u7c7b\u578b\u5b58\u5728\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7\u7684\u573a\u666f");
            return Boolean.TRUE;
        }
        log.info("\u76f4\u8425\u4e0d\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7");
        return Boolean.FALSE;
    }

    @Override
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u9700\u8981\u505a\u4f59\u989d\u7ba1\u63a7", notes="\u5224\u65ad\u662f\u5426\u9700\u8981\u505a\u4f59\u989d\u7ba1\u63a7")
    public Boolean checkOrderSourceGuard(DgPerformOrderRespDto through) {
        log.info("\u5224\u65ad\u662f\u5426\u9700\u8981\u4fdd\u5b58\u4f9b\u8d27\u4ef7");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(through.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        AssertUtils.isFalse((shopExtRespDto == null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5e97\u94fa\u4fe1\u606f");
        if (2 == shopExtRespDto.getStoreType() || 3 == shopExtRespDto.getStoreType() || 4 == shopExtRespDto.getStoreType()) {
            log.info("\u7ecf\u9500\uff0c\u5206\u9500\uff0c\u5382\u9001\u5e97\u94fa\u7c7b\u578b\u5b58\u5728\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7\u7684\u573a\u666f");
            return Boolean.TRUE;
        }
        log.info("\u76f4\u8425\u4e0d\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7");
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkBusinessAudit(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        if (saleOrderRespDto.getPlanDeliveryTime() != null && saleOrderRespDto.getPlanDeliveryTime().compareTo(new Date()) > 0) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u5546\u5ba1]\u9884\u8ba1\u53d1\u8d27\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u8fdb\u884c\u5546\u5ba1");
            throw DgPcpTradeExceptionCode.BUSINESS_AUDIT_BY_PLAN_TIME.builderException();
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean orderShipmentCheck(DgPerformOrderRespDto respDto) {
        return this.inventoryApiServcie.orderShipmentCheck(respDto);
    }

    @Override
    public Boolean deliveryInaccessibilityCheckGuard(DgPerformOrderRespDto respDto) {
        Long id = respDto.getId();
        this.dgPerformOrderWarehouseInfoService.verifyDeliveryAccessibilityAction(id);
        return true;
    }

    @Override
    public RestResponse<Boolean> checkShipLogisticsRelationInfo(DgPerformOrderRespDto saleOrderRespDto) {
        if (!this.shipLogisticsRelationEnable.booleanValue()) {
            return new RestResponse((Object)Boolean.TRUE);
        }
        AssertUtils.notBlank((String)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseCode(), (String)"\u8ba2\u5355\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode(), (String)"\u8ba2\u5355\u53d1\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List physicsWarehouseDtos = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryByLogicWarehouseCodeList(Arrays.asList(saleOrderRespDto.getDeliveryLogicalWarehouseCode())));
        log.info("[\u6821\u9a8c\u7269\u6d41\u5546\u6620\u5c04\u5173\u7cfb]\u83b7\u53d6\u5230wms\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)physicsWarehouseDtos));
        DgPhysicsWarehouseDto warehouseRespDto = (DgPhysicsWarehouseDto)physicsWarehouseDtos.stream().findFirst().orElseGet(null);
        if (warehouseRespDto != null && StringUtils.isNotBlank((CharSequence)warehouseRespDto.getEntitySystemCode())) {
            TrLogisticsMappingRelationReqDto reqDto = new TrLogisticsMappingRelationReqDto();
            reqDto.setOrderType(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode());
            reqDto.setMappingType("WMS");
            reqDto.setLogisticsCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseCode());
            reqDto.setSiteCode(saleOrderRespDto.getPerformOrderSnapshotDto().getSiteCode());
            reqDto.setSystematicCode(warehouseRespDto.getEntitySystemCode());
            RestResponse queryResult = this.trLogisticsMappingRelationQueryApiProxy.queryByRelationReqDtoSiteMatching(reqDto);
            log.info("[\u6821\u9a8c\u7269\u6d41\u5546\u6620\u5c04\u5173\u7cfb]\u83b7\u53d6\u5230\u6620\u5c04\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString((Object)queryResult));
            TrLogisticsMappingRelationRespDto respDto = (TrLogisticsMappingRelationRespDto)RestResponseHelper.extractData((RestResponse)queryResult);
            return new RestResponse((Object)(respDto != null ? 1 : 0));
        }
        return new RestResponse((Object)Boolean.TRUE);
    }

    @Override
    public Boolean checkOrderCanCancelSplitOrder(DgPerformOrderRespDto dto) {
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)orderLineDtoList)) {
            throw new BizException("-1", "\u5386\u53f2\u5355\u636e\u6682\u65e0\u6cd5\u53d6\u6d88\u62c6\u5355");
        }
        return StringUtils.isBlank((CharSequence)dto.getMainOrderNo()) && StringUtils.isBlank((CharSequence)dto.getOriginalOrderNo()) && dto.getOriginOrderId() == null;
    }

    @Override
    public List<Long> checkChildOrderCancelSplitOrderAndReturn(DgPerformOrderRespDto dto) {
        List sonOrderList = this.omsOrderInfoQueryDomain.queryAllChildByOrderNo(dto.getSaleOrderNo());
        AssertUtils.notEmpty((Collection)sonOrderList, (String)"\u67e5\u627e\u4e0d\u5230\u5b50\u5355\u5217\u8868");
        ArrayList orderIdList = Lists.newArrayList();
        List<DgOmsSaleOrderStatus> excludeOrderStatusSet = Arrays.asList(DgOmsSaleOrderStatus.PICKED, DgOmsSaleOrderStatus.WAIT_DELIVERY, DgOmsSaleOrderStatus.DELIVERY_ALL);
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(sonOrderList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderLineDto>> orderLineMap = orderLineDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
        List itemLineEoList = this.orderItemLineDomain.queryItemLineByOrderLineIds(orderLineDtoList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderItemLineEo>> itemMap = itemLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        sonOrderList.forEach(orderRespDto -> {
            DgOmsSaleOrderStatus omsSaleOrderStatus = DgOmsSaleOrderStatus.forCode((String)orderRespDto.getOrderStatus());
            AssertUtils.notNull((Object)omsSaleOrderStatus, (String)String.format("'%s'OMS\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", orderRespDto.getSaleOrderNo()));
            if (excludeOrderStatusSet.contains(omsSaleOrderStatus)) {
                throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u5b50\u8ba2\u5355\u4e3a\u5df2\u914d\u8d27\u3001\u5f85\u53d1\u8d27\u3001\u5df2\u53d1\u8d27\u4e0d\u5141\u8bb8\u53d6\u6d88\u62c6\u5355");
            }
            List orderLineDtos = (List)orderLineMap.get(orderRespDto.getId());
            AssertUtils.notEmpty((Collection)orderLineDtos, (String)(orderRespDto.getSaleOrderNo() + "\u67e5\u627e\u4e0d\u5230\u8ba2\u5355\u884c\u4fe1\u606f"));
            orderLineDtos.forEach(orderLine -> {
                List items = (List)itemMap.get(orderLine.getId());
                if (CollectionUtil.isEmpty((Collection)items)) {
                    throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u67e5\u627e\u4e0d\u5230\u5546\u54c1\u884c\u4fe1\u606f");
                }
                if (CollectionUtil.isNotEmpty(items = items.stream().filter(item -> !DgSaleOrderItemRefundStatusEnum.NORMAL.getCode().equals(item.getRefundStatus()) && !DgSaleOrderItemRefundStatusEnum.CLOSED.getCode().equals(item.getRefundStatus())).collect(Collectors.toList()))) {
                    throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u5b50\u8ba2\u5355\u5b58\u5728\u9000\u6b3e\u5546\u54c1\u4e0d\u5141\u8bb8\u53d6\u6d88\u62c6\u5355");
                }
            });
            DgOrderLabelRecordReqDto orderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
            orderLabelRecordReqDto.setOrderId(orderRespDto.getId());
            orderLabelRecordReqDto.setLabelCodes(Arrays.asList(DgOrderLabelEnum.LOCK.getCode(), DgOrderLabelEnum.REFUND_INTERCEPT.getCode(), DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT.getCode()));
            List labelRecordRespDtos = this.orderLabelRecordDomain.queryByParam(orderLabelRecordReqDto);
            boolean isIntercept = CollectionUtils.isNotEmpty((Collection)labelRecordRespDtos);
            if (isIntercept) {
                throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u5b50\u8ba2\u5355\u5df2\u62e6\u622a\u4e0d\u5141\u8bb8\u53d6\u6d88\u62c6\u5355");
            }
            orderLabelRecordReqDto.setLabelCodes(Arrays.asList(DgOrderLabelEnum.LOCK.getCode()));
            labelRecordRespDtos = this.orderLabelRecordDomain.queryByParam(orderLabelRecordReqDto);
            boolean isLock = CollectionUtils.isNotEmpty((Collection)labelRecordRespDtos);
            if (isLock) {
                throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u5b50\u8ba2\u5355\u5df2\u6302\u8d77\u4e0d\u5141\u8bb8\u53d6\u6d88\u62c6\u5355");
            }
            orderIdList.add(orderRespDto.getId());
        });
        AssertUtils.notEmpty((Collection)orderIdList, (String)"\u83b7\u53d6\u4e0d\u5230\u5141\u8bb8\u53d6\u6d88\u62c6\u5355\u7684\u5b50\u8ba2\u5355id");
        return orderIdList;
    }

    @Override
    public Boolean checkChildOrderCancelSplitOrder(DgPerformOrderRespDto dto) {
        List sonOrderList = this.omsOrderInfoQueryDomain.queryAllChildByOrderNo(dto.getSaleOrderNo());
        AssertUtils.notEmpty((Collection)sonOrderList, (String)"\u67e5\u627e\u4e0d\u5230\u5b50\u5355\u5217\u8868");
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(sonOrderList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderLineDto>> orderLineMap = orderLineDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
        List itemLineEoList = this.orderItemLineDomain.queryItemLineByOrderLineIds(orderLineDtoList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        Map<Long, List<DgPerformOrderItemLineEo>> itemMap = itemLineEoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId));
        List<DgPerformOrderRespDto> saleOrderRespDtoList = sonOrderList.stream().filter(orderRespDto -> !DgOmsSaleOrderStatus.SPLIT.getCode().equals(orderRespDto.getOmsSaleOrderStatus())).collect(Collectors.toList());
        saleOrderRespDtoList.forEach(orderRespDto -> {
            List orderLineDtos = (List)orderLineMap.get(orderRespDto.getId());
            AssertUtils.notEmpty((Collection)orderLineDtos, (String)(orderRespDto.getSaleOrderNo() + "\u67e5\u627e\u4e0d\u5230\u8ba2\u5355\u884c\u4fe1\u606f"));
            orderLineDtos.forEach(orderLine -> {
                List items = (List)itemMap.get(orderLine.getId());
                if (CollectionUtil.isEmpty((Collection)items)) {
                    throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u67e5\u627e\u4e0d\u5230\u5546\u54c1\u884c\u4fe1\u606f");
                }
                if (CollectionUtil.isNotEmpty(items = items.stream().filter(item -> !DgSaleOrderItemRefundStatusEnum.NORMAL.getCode().equals(item.getRefundStatus()) && !DgSaleOrderItemRefundStatusEnum.CLOSED.getCode().equals(item.getRefundStatus())).collect(Collectors.toList()))) {
                    throw new BizException("-1", orderRespDto.getSaleOrderNo() + "\u5b50\u8ba2\u5355\u5b58\u5728\u9000\u6b3e\u5546\u54c1\u4e0d\u5141\u8bb8\u53d6\u6d88\u62c6\u5355");
                }
            });
        });
        return saleOrderRespDtoList.stream().allMatch(order -> DgOmsSaleOrderStatus.CANCEL.getCode().equals(order.getOmsSaleOrderStatus()) || DgOmsSaleOrderStatus.OBSOLETE.getCode().equals(order.getOmsSaleOrderStatus()));
    }

    @Override
    public Boolean chekAllItemIsRefund(DgPerformOrderRespDto respDto) {
        List<String> reufndStatusList;
        List saleOrderItemLineEos = this.orderItemLineDomain.queryItemLineEosByOrderId(respDto.getId());
        List itemLineIds = saleOrderItemLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List afsOrderItemLineDtos = this.orderItemLineDomain.queryAfsItemLineDtosBySaleItemLineIds(itemLineIds, reufndStatusList = Arrays.asList(DgSaleOrderItemRefundStatusEnum.CLOSED.getCode(), DgSaleOrderItemRefundStatusEnum.NORMAL.getCode(), DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode()));
        if (CollectionUtils.isEmpty((Collection)afsOrderItemLineDtos)) {
            return false;
        }
        BigDecimal number = saleOrderItemLineEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundNumber = afsOrderItemLineDtos.stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u9500\u552e\u6570\u91cf:{},\u5df2\u9000\u6b3e\u6570\u91cf:{}", (Object)number, (Object)refundNumber);
        return number.compareTo(refundNumber.negate()) <= 0;
    }

    @Override
    public Boolean chekAllItemIsCancel(DgPerformOrderRespDto respDto) {
        List orderLineEos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        List refundStatus = orderLineEos.stream().map(DgPerformOrderLineDto::getStatus).distinct().collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        return refundStatus.contains(DgOmsSaleOrderStatus.CANCEL.getCode()) && refundStatus.size() == 1;
    }

    @Override
    public Boolean checkThirdWarehouseOrderStock(DgPerformOrderRespDto respDto) {
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(respDto.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e97\u94fa\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c{},{}", (Object)respDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)shopExtRespDto));
        List logicWarehouseCodes = shopExtRespDto.getLogicWarehouseCodes();
        if (CollectionUtil.isEmpty((Collection)logicWarehouseCodes)) {
            log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u6ca1\u914d\u7f6e\u903b\u8f91\u4ed3{}", (Object)respDto.getSaleOrderNo());
            return false;
        }
        List dgPerformOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
        List longCodeList = dgPerformOrderLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList(logicWarehouseCodes);
        inventoryBasicsQueryReqDto.setLongCodeList(longCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List inventoryList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c{},{}", (Object)respDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)inventoryList));
        if (CollectionUtils.isEmpty((Collection)inventoryList)) {
            log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7a7a{}", (Object)respDto.getSaleOrderNo());
            return false;
        }
        Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapByWarehouseCode = inventoryList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getWarehouseCode));
        HashSet<String> unAvailableWarehouseCodes = new HashSet<String>();
        block0: for (Map.Entry<String, List<InventoryBasicsQueryRespDto>> entry : inventoryMapByWarehouseCode.entrySet()) {
            String warehouseCode = entry.getKey();
            List<InventoryBasicsQueryRespDto> inventoryDtoList = entry.getValue();
            Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapBySkuCode = inventoryDtoList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getCargoCode));
            for (DgPerformOrderLineDto orderLine : dgPerformOrderLineDtoList) {
                BigDecimal itemNum = orderLine.getItemNum();
                List inventoryDtos = inventoryMapBySkuCode.getOrDefault(orderLine.getSkuCode(), new ArrayList());
                if (!inventoryDtos.stream().map(inventory -> Optional.ofNullable(inventory).map(InventoryBasicsQueryRespDto::getAvailable).orElse(BigDecimal.ZERO)).noneMatch(available -> available.compareTo(itemNum) >= 0)) continue;
                unAvailableWarehouseCodes.add(warehouseCode);
                continue block0;
            }
        }
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u6821\u9a8c\u7ed3\u679c{},unAvailableWarehouseCodes{},inventoryWarehouseCodes{}", new Object[]{respDto.getSaleOrderNo(), JSON.toJSONString(unAvailableWarehouseCodes), JSON.toJSONString(inventoryMapByWarehouseCode.keySet())});
        return unAvailableWarehouseCodes.size() < inventoryMapByWarehouseCode.size();
    }
}

