/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordDelReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordReqDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderTagRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordRespDto;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderTagRecordServiceImpl
implements IDgAfterSaleOrderTagRecordService {
    @Resource
    private IDgAfterSaleOrderTagRecordDas afterSaleOrderTagRecordDas;
    @Resource
    private IDgAfterSaleOrderTagRecordDomain afterSaleOrderTagRecordDomain;
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;

    @Override
    public void addAfterSaleOrderTagRecord(DgAfterSaleOrderTagRecordReqDto addReqDto) {
        ReBizTagRecordReqDto reqDto = new ReBizTagRecordReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)addReqDto, (String[])new String[0]);
        TagRecordLinkReqDto orderTagRecordEo = new TagRecordLinkReqDto();
        orderTagRecordEo.setRecordLinkId(addReqDto.getOrderId());
        reqDto.setRecordLinkList((List)Lists.newArrayList((Object[])new TagRecordLinkReqDto[]{orderTagRecordEo}));
        reqDto.setRecordLinkOptType("MANUAL");
        reqDto.setRecordSourceModel("AFTER_ORDER_SALE");
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.batchInsert((List)Lists.newArrayList((Object[])new ReBizTagRecordReqDto[]{reqDto})));
    }

    @Override
    public void removeAfterSaleOrderTagRecord(DgAfterSaleOrderTagRecordRespDto tag) {
        ReBizTagRecordDelReqDto reqDto = new ReBizTagRecordDelReqDto();
        reqDto.setIdList((List)Lists.newArrayList((Object[])new Long[]{tag.getId()}));
        reqDto.setRecordLinkIdList((List)Lists.newArrayList((Object[])new Long[]{tag.getOrderId()}));
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.logicDel(reqDto));
    }

    @Override
    public List<DgAfterSaleOrderTagRecordRespDto> queryByParam(DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto) {
        AssertUtils.notNull((Object)orderTagRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReBizTagRecordPageReqDto reqDto = new ReBizTagRecordPageReqDto();
        if (Objects.nonNull(orderTagRecordReqDto.getTagCode())) {
            reqDto.setTagCode(orderTagRecordReqDto.getTagCode());
        }
        if (Objects.nonNull(orderTagRecordReqDto.getOrderId())) {
            reqDto.setRecordLinkId(orderTagRecordReqDto.getOrderId());
        }
        reqDto.setTagStatus(Integer.valueOf(1));
        List reBizTagRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagRecordApiProxy.findAll(reqDto));
        if (CollectionUtils.isEmpty((Collection)reBizTagRecordRespDtos)) {
            return null;
        }
        return reBizTagRecordRespDtos.stream().map(dto -> {
            DgAfterSaleOrderTagRecordRespDto orderTagRecordRespDto = new DgAfterSaleOrderTagRecordRespDto();
            orderTagRecordRespDto.setId(dto.getId());
            orderTagRecordRespDto.setTagCode(dto.getTagCode());
            orderTagRecordRespDto.setOrderId(dto.getRecordLinkId());
            return orderTagRecordRespDto;
        }).collect(Collectors.toList());
    }
}

