/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAdvanceOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.dto.AccountBalanceChangeReqDto;
import com.yunxi.dg.base.center.account.dto.AccountPosReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeRespDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgOrgCustomerRelationExtReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgTobCustomerAreaQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobCustomerAreaQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobOrgCustomerRelationQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryV2ReqDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.request.DgEsCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgCustomerBuyScopeItemQueryApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderCustomerDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderCustomerDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderCustomerNumDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceOrderPayRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderExtDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderItemLineReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.advance.DgAdvanceOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRelevanceDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderItemLineRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderPageRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AdvanceOrderItemLineStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderCustomerEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderPayRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceRelevanceOrderService;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAdvanceOrderServiceImpl
implements IDgAdvanceOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgAdvanceOrderServiceImpl.class);
    @Resource
    private IDgCustomerBuyScopeItemQueryApiProxy dgCustomerBuyScopeItemQueryApiProxy;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDgPriceQueryV2ApiProxy dgPriceQueryV2ApiProxy;
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;
    @Resource
    private IDgAdvanceOrderCustomerDomain dgAdvanceOrderCustomerDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IDgAdvanceOrderPayRecordService dgAdvanceOrderPayRecordService;
    @Resource
    private IContext context;
    @Resource
    private IDgTobOrgCustomerRelationQueryApiProxy dgTobOrgCustomerRelationQueryApiProxy;
    @Resource
    private IDgAdvanceRelevanceOrderService dgAdvanceRelevanceOrderService;
    @Resource
    private IDgTobCustomerAreaQueryApiProxy dgTobCustomerAreaQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    private static final int priceScale = 4;
    private static final int amountScale = 2;

    @Override
    public DgAdvanceOrderRespDto previewOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        this.verifySubmitParams(dgOrderReqDto);
        this.fillItemListData(dgOrderReqDto);
        DgAdvanceOrderRespDto respDto = (DgAdvanceOrderRespDto)BeanUtil.toBean((Object)dgOrderReqDto, DgAdvanceOrderRespDto.class);
        respDto.setItemLineDtoList(BeanUtil.copyToList((Collection)dgOrderReqDto.getItemLineDtoList(), DgAdvanceOrderItemLineRespDto.class));
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submitOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        this.verifySubmitParams(dgOrderReqDto);
        this.fillItemListData(dgOrderReqDto);
        DgAdvanceOrderEo orderEo = this.createOrder(dgOrderReqDto);
        return orderEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long editOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        this.verifyEditOrder(dgOrderReqDto);
        this.fillItemListData(dgOrderReqDto);
        this.updateOrder(dgOrderReqDto);
        return dgOrderReqDto.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long cancelOrder(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderEo orderEo = (DgAdvanceOrderEo)this.dgAdvanceOrderDomain.selectByPrimaryKey(orderId);
        AssertUtils.notNull((Object)orderEo, (String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a" + orderId));
        AssertUtils.isTrue((boolean)Objects.equals(DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode(), orderEo.getOrderStatus()), (String)"\u8ba2\u5355\u975e'\u5f85\u786e\u8ba4'\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88");
        orderEo.setOrderStatus(DgF2BAdvanceOrderStatus.CANCEL.getCode());
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)orderEo);
        return orderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long checkOrder(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderId(orderId);
        AssertUtils.isTrue((boolean)Objects.equals(DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode(), orderDto.getOrderStatus()), (String)"\u8ba2\u5355\u975e'\u5f85\u786e\u8ba4'\u72b6\u6001\u4e0d\u80fd\u786e\u8ba4");
        List itemLineList = orderDto.getItemLineDtoList().stream().filter(line -> Objects.equals(line.getStatus(), YesNoEnum.NO.getValue())).collect(Collectors.toList());
        AssertUtils.notEmpty(itemLineList, (String)"\u5546\u54c1\u5df2\u5168\u90e8\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4");
        DgAdvanceOrderEo orderEo = new DgAdvanceOrderEo();
        orderEo.setId(orderId);
        orderEo.setOrderStatus(DgF2BAdvanceOrderStatus.CHECKED.getCode());
        orderEo.setCheckPerson(this.context.userName());
        orderEo.setCheckTime(new Date());
        orderEo.setPayStatus(YesNoEnum.YES.getValue());
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)orderEo);
        Date inputTime = new Date();
        List itemLineDtoList = orderDto.getItemLineDtoList();
        for (DgAdvanceOrderItemLineRespDto itemLineDto : itemLineDtoList) {
            DgAdvanceOrderItemLineEo orderItemLineEo = new DgAdvanceOrderItemLineEo();
            orderItemLineEo.setId(itemLineDto.getId());
            orderItemLineEo.setInputTime(inputTime);
            this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)orderItemLineEo);
        }
        AccountBalanceChangeReqDto reqDto = new AccountBalanceChangeReqDto();
        reqDto.setOrderNo(orderDto.getOrderNo());
        reqDto.setAmount(orderDto.getAdvanceAmount());
        reqDto.setTradeType("57");
        AccountPosReqDto payerAccount = new AccountPosReqDto();
        payerAccount.setAccountType("YFK");
        payerAccount.setCustomerNo(orderDto.getCustomerCode());
        payerAccount.setShopCode(orderDto.getShopCode());
        payerAccount.setSaleCompanyCode(orderDto.getEnterpriseCode());
        reqDto.setPayerAccount(payerAccount);
        AccountPosReqDto payeeAccount = new AccountPosReqDto();
        payeeAccount.setAccountType("YDJ");
        payeeAccount.setCustomerNo(orderDto.getCustomerCode());
        payeeAccount.setShopCode(orderDto.getShopCode());
        payeeAccount.setSaleCompanyCode(orderDto.getEnterpriseCode());
        reqDto.setPayeeAccount(payeeAccount);
        AccountTradeRespDto accountTradeRespDto = (AccountTradeRespDto)RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.advanceDepositRepay(reqDto));
        DgAdvanceOrderPayRecordDto payRecordDto = new DgAdvanceOrderPayRecordDto();
        payRecordDto.setOrderId(orderDto.getId());
        payRecordDto.setOrderNo(orderDto.getOrderNo());
        payRecordDto.setPayNo(accountTradeRespDto.getFlowNo());
        payRecordDto.setPayType("preempt");
        payRecordDto.setPayMethod("YFK");
        payRecordDto.setPayStatus(Integer.valueOf(1));
        payRecordDto.setPayAmount(accountTradeRespDto.getAmount());
        payRecordDto.setPayTime(accountTradeRespDto.getTradeTime());
        this.dgAdvanceOrderPayRecordService.addPayRecord(payRecordDto);
        return orderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void completedOrder(Long orderId, Boolean isHandmade) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderId(orderId);
        AssertUtils.isTrue((boolean)Objects.equals(DgF2BAdvanceOrderStatus.CHECKED.getCode(), orderDto.getOrderStatus()), (String)"\u8ba2\u5355\u975e'\u5df2\u786e\u8ba4'\u72b6\u6001\u4e0d\u80fd\u5b8c\u7ed3");
        DgAdvanceOrderEo orderEo = new DgAdvanceOrderEo();
        orderEo.setId(orderDto.getId());
        List itemLineDtoList = orderDto.getItemLineDtoList();
        BigDecimal remainNum = itemLineDtoList.stream().map(DgAdvanceOrderItemLineDto::getRemainNum).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal advanceAmount = orderDto.getAdvanceAmount();
        BigDecimal releaseAdvanceAmount = itemLineDtoList.stream().map(DgAdvanceOrderItemLineDto::getReleaseAdvanceAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal noReleaseAdvanceAmount = advanceAmount.subtract(releaseAdvanceAmount);
        AssertUtils.isFalse((remainNum.compareTo(BigDecimal.ZERO) > 0 && isHandmade == false ? 1 : 0) != 0, (String)("\u8ba2\u5355\u5b8c\u7ed3\u5931\u8d25\uff0c\u672c\u5355\u5269\u4f59\u672a\u4e0b\u5355\u6570\u91cf\uff1a" + remainNum));
        if (noReleaseAdvanceAmount.compareTo(BigDecimal.ZERO) > 0) {
            AssertUtils.isTrue((boolean)isHandmade, (String)("\u8ba2\u5355\u5b8c\u7ed3\u5931\u8d25\uff0c\u9884\u5b9a\u91d1\u672a\u91ca\u653e\u91d1\u989d\uff1a" + noReleaseAdvanceAmount));
            AccountBalanceChangeReqDto reqDto = new AccountBalanceChangeReqDto();
            reqDto.setOrderNo(orderDto.getOrderNo());
            reqDto.setAmount(noReleaseAdvanceAmount);
            reqDto.setTradeType("59");
            AccountPosReqDto payerAccount = new AccountPosReqDto();
            payerAccount.setAccountType("YDJ");
            payerAccount.setCustomerNo(orderDto.getCustomerCode());
            payerAccount.setShopCode(orderDto.getShopCode());
            payerAccount.setSaleCompanyCode(orderDto.getEnterpriseCode());
            reqDto.setPayerAccount(payerAccount);
            AccountPosReqDto payeeAccount = new AccountPosReqDto();
            payeeAccount.setAccountType("YFk");
            payeeAccount.setCustomerNo(orderDto.getCustomerCode());
            payeeAccount.setShopCode(orderDto.getShopCode());
            payeeAccount.setSaleCompanyCode(orderDto.getEnterpriseCode());
            reqDto.setPayeeAccount(payeeAccount);
            AccountTradeRespDto accountTradeRespDto = (AccountTradeRespDto)RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.advanceDepositRepay(reqDto));
            orderEo.setReleaseAdvanceAmount(BigDecimal.ZERO);
            for (DgAdvanceOrderItemLineRespDto itemLineDto : itemLineDtoList) {
                DgAdvanceOrderItemLineEo itemLineEo = new DgAdvanceOrderItemLineEo();
                itemLineEo.setId(itemLineDto.getId());
                itemLineEo.setReleaseAdvanceAmount(itemLineEo.getAdvanceAmount());
                this.dgAdvanceOrderItemLineDomain.updateSelective((BaseEo)itemLineEo);
            }
            DgAdvanceOrderPayRecordDto payRecordDto = new DgAdvanceOrderPayRecordDto();
            payRecordDto.setOrderId(orderDto.getId());
            payRecordDto.setOrderNo(orderDto.getOrderNo());
            payRecordDto.setPayNo(accountTradeRespDto.getFlowNo());
            payRecordDto.setPayType("release");
            payRecordDto.setPayMethod("YDJ");
            payRecordDto.setPayStatus(Integer.valueOf(1));
            payRecordDto.setPayAmount(accountTradeRespDto.getAmount());
            payRecordDto.setPayTime(accountTradeRespDto.getTradeTime());
            this.dgAdvanceOrderPayRecordService.addPayRecord(payRecordDto);
        }
        orderEo.setOrderStatus(DgF2BAdvanceOrderStatus.CLOSE.getCode());
        orderEo.setReleaseAdvanceAmount(orderDto.getReleaseAdvanceAmount().add(noReleaseAdvanceAmount));
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)orderEo);
    }

    @Override
    public PageInfo<DgAdvanceOrderPageRespDto> queryByPage(DgAdvanceOrderPageReqDto reqDto) {
        PageInfo page = this.dgAdvanceOrderDomain.queryByPage(reqDto);
        if (CollectionUtils.isEmpty((Collection)page.getList())) {
            return page;
        }
        List orderIds = page.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
        Set areaCodesSet = page.getList().stream().filter(l -> StringUtils.isNotEmpty((CharSequence)l.getBusinessAreaCode())).map(DgAdvanceOrderDto::getBusinessAreaCode).collect(Collectors.toSet());
        List orderCustomerNumDtoList = this.dgAdvanceOrderCustomerDomain.countCustomerByOrderId(orderIds);
        Map<Long, DgAdvanceOrderCustomerNumDto> numDtoMap = ((List)Optional.ofNullable(orderCustomerNumDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgAdvanceOrderCustomerNumDto::getOrderId, o -> o));
        Map<Object, Object> itemLineMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getQueryList()) && reqDto.getQueryList().contains("item")) {
            LambdaQueryWrapper itemLineEoQuery = new LambdaQueryWrapper();
            List dgAdvanceOrderItemLineEos = this.dgAdvanceOrderItemLineDomain.getMapper().selectList((Wrapper)itemLineEoQuery);
            ArrayList itemLineDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)dgAdvanceOrderItemLineEos, (Collection)itemLineDtoList, DgAdvanceOrderItemLineRespDto.class);
            itemLineMap = ((List)Optional.ofNullable(itemLineDtoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgAdvanceOrderItemLineDto::getOrderId));
        }
        Map areaMap = new HashMap();
        if (CollectionUtils.isNotEmpty(areaCodesSet)) {
            DgTobCustomerAreaQueryReqDto tobCustomerAreaQueryReqDto = new DgTobCustomerAreaQueryReqDto();
            tobCustomerAreaQueryReqDto.setCodes(new ArrayList(areaCodesSet));
            areaMap = (Map)RestResponseHelper.extractData((RestResponse)this.dgTobCustomerAreaQueryApiProxy.mapAreaLevel(tobCustomerAreaQueryReqDto));
        }
        for (DgAdvanceOrderPageRespDto respDto : page.getList()) {
            DgAdvanceOrderCustomerNumDto numDto = numDtoMap.get(respDto.getId());
            if (Objects.nonNull(numDto)) {
                respDto.setCustomerCount(numDto.getCustomerNum());
            }
            if (itemLineMap.containsKey(respDto.getId())) {
                respDto.setItemLineDtoList((List)itemLineMap.get(respDto.getId()));
            }
            if (!areaMap.containsKey(respDto.getBusinessAreaCode())) continue;
            respDto.setBusinessAreaList((List)areaMap.get(respDto.getBusinessAreaCode()));
        }
        return page;
    }

    @Override
    public List<DgAdvanceOrderPageRespDto> queryByList(DgAdvanceOrderPageReqDto reqDto) {
        return this.dgAdvanceOrderDomain.queryByList(reqDto);
    }

    @Override
    public DgAdvanceOrderDetailRespDto queryByOrderId(Long orderId) {
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderId(orderId);
        DgAdvanceOrderDetailRespDto detailRespDto = (DgAdvanceOrderDetailRespDto)BeanUtil.toBean((Object)orderDto, DgAdvanceOrderDetailRespDto.class);
        this.fillOrderDetail(detailRespDto);
        return detailRespDto;
    }

    @Override
    public DgAdvanceOrderDetailRespDto queryByOrderNo(String orderNo) {
        DgAdvanceOrderRespDto orderDto = this.dgAdvanceOrderDomain.queryByOrderNo(orderNo);
        DgAdvanceOrderDetailRespDto detailRespDto = (DgAdvanceOrderDetailRespDto)BeanUtil.toBean((Object)orderDto, DgAdvanceOrderDetailRespDto.class);
        this.fillOrderDetail(detailRespDto);
        return detailRespDto;
    }

    private void fillOrderDetail(DgAdvanceOrderDetailRespDto detailRespDto) {
        List performOrderIdlist;
        List dgPerformOrderInfoEos;
        List<DgAdvanceOrderPayRecordRespDto> payRecordList = this.dgAdvanceOrderPayRecordService.listPayRecord(detailRespDto.getId(), detailRespDto.getOrderNo());
        detailRespDto.setPayRecordList(payRecordList.stream().filter(o -> "preempt".equals(o.getPayType())).collect(Collectors.toList()));
        detailRespDto.setRefundRecordList(payRecordList.stream().filter(o -> "release".equals(o.getPayType())).collect(Collectors.toList()));
        List extensionEoList = this.dgPerformOrderExtensionDomain.selectListByBeforeOrderNo(detailRespDto.getOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)extensionEoList) && CollectionUtils.isNotEmpty((Collection)(dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryListByOrderIds(performOrderIdlist = extensionEoList.stream().map(DgPerformOrderExtensionEo::getOrderId).collect(Collectors.toList()))))) {
            ArrayList<DgPerformOrderRelevanceDetailRespDto> relevanceOrderList = new ArrayList<DgPerformOrderRelevanceDetailRespDto>();
            for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
                DgPerformOrderRelevanceDetailRespDto relevanceDetailRespDto = new DgPerformOrderRelevanceDetailRespDto();
                relevanceDetailRespDto.setOrderType("delivery");
                relevanceDetailRespDto.setRelevanceId(dgPerformOrderInfoEo.getId());
                relevanceDetailRespDto.setRelevanceNo(dgPerformOrderInfoEo.getSaleOrderNo());
                relevanceDetailRespDto.setOrderStatus(dgPerformOrderInfoEo.getOrderStatus());
                relevanceDetailRespDto.setCreateTime(dgPerformOrderInfoEo.getCreateTime());
                relevanceOrderList.add(relevanceDetailRespDto);
            }
            detailRespDto.setRelevanceOrderList(relevanceOrderList);
        }
        DgAdvanceOrderCustomerEo customerEo = new DgAdvanceOrderCustomerEo();
        customerEo.setOrderId(detailRespDto.getId());
        customerEo.setMainCustomer(com.yunxi.dg.base.commons.enums.YesNoEnum.NO.getValue());
        List customerDtoList = BeanUtil.copyToList((Collection)this.dgAdvanceOrderCustomerDomain.selectList((BaseEo)customerEo), DgAdvanceOrderCustomerDto.class);
        detailRespDto.setCustomerList(customerDtoList);
        detailRespDto.setCustomerListSize(Integer.valueOf(((List)Optional.ofNullable(customerDtoList).orElse(new ArrayList())).size()));
        detailRespDto.setTotalItemNumCount(BigDecimal.ZERO);
        detailRespDto.setTotalVolume(BigDecimal.ZERO);
        detailRespDto.setTotalWeight(BigDecimal.ZERO);
        HashSet skuCodeSet = new HashSet();
        ((List)Optional.ofNullable(detailRespDto.getItemLineDtoList()).orElse(new ArrayList())).stream().forEach(item -> {
            detailRespDto.setTotalItemNumCount(detailRespDto.getTotalItemNumCount().add(Optional.ofNullable(item.getItemNum()).orElse(BigDecimal.ZERO)));
            detailRespDto.setTotalVolume(detailRespDto.getTotalVolume().add(Optional.ofNullable(item.getVolume()).orElse(BigDecimal.ZERO)));
            detailRespDto.setTotalWeight(detailRespDto.getTotalWeight().add(Optional.ofNullable(item.getWeight()).orElse(BigDecimal.ZERO)));
            item.setSalePrice(item.getSalePrice().setScale(4, RoundingMode.HALF_UP));
            item.setSupplyPrice(item.getSupplyPrice());
            item.setAdditivePrice(item.getAdditivePrice().setScale(4, RoundingMode.HALF_UP));
            skuCodeSet.add(item.getSkuCode());
        });
        detailRespDto.setSkuCount(Integer.valueOf(skuCodeSet.size()));
        if (StringUtils.isNotEmpty((CharSequence)detailRespDto.getBusinessAreaCode())) {
            DgTobCustomerAreaQueryReqDto tobCustomerAreaQueryReqDto = new DgTobCustomerAreaQueryReqDto();
            tobCustomerAreaQueryReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{detailRespDto.getBusinessAreaCode()}));
            Map areaMap = (Map)RestResponseHelper.extractData((RestResponse)this.dgTobCustomerAreaQueryApiProxy.mapAreaLevel(tobCustomerAreaQueryReqDto));
            if (areaMap.containsKey(detailRespDto.getBusinessAreaCode())) {
                detailRespDto.setBusinessAreaList((List)areaMap.get(detailRespDto.getBusinessAreaCode()));
            }
        }
    }

    private void updateOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        DgAdvanceOrderEo updateOrderEo = (DgAdvanceOrderEo)BeanUtil.toBean((Object)dgOrderReqDto, DgAdvanceOrderEo.class);
        updateOrderEo.setId(dgOrderReqDto.getId());
        updateOrderEo.setOrderNo(dgOrderReqDto.getOrderNo());
        this.dgAdvanceOrderDomain.updateSelective((BaseEo)updateOrderEo);
        DgAdvanceOrderItemLineEo deleteLineEo = new DgAdvanceOrderItemLineEo();
        deleteLineEo.setOrderId(dgOrderReqDto.getId());
        deleteLineEo.setOrderNo(dgOrderReqDto.getOrderNo());
        this.dgAdvanceOrderItemLineDomain.logicDelete((BaseEo)deleteLineEo);
        ArrayList<DgAdvanceOrderItemLineEo> itemLineEoList = new ArrayList<DgAdvanceOrderItemLineEo>();
        for (DgAdvanceOrderItemLineDto itemLineDto : dgOrderReqDto.getItemLineDtoList()) {
            DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)BeanUtil.toBean((Object)itemLineDto, DgAdvanceOrderItemLineEo.class);
            itemLineEo.setOrderId(dgOrderReqDto.getId());
            itemLineEo.setOrderNo(dgOrderReqDto.getOrderNo());
            itemLineEoList.add(itemLineEo);
        }
        this.dgAdvanceOrderItemLineDomain.insertBatch(itemLineEoList);
    }

    private void verifyEditOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        AssertUtils.notNull((Object)dgOrderReqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DgAdvanceOrderEo orderEo = (DgAdvanceOrderEo)this.dgAdvanceOrderDomain.selectByPrimaryKey(dgOrderReqDto.getId());
        AssertUtils.notNull((Object)orderEo, (String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a" + dgOrderReqDto.getId()));
        AssertUtils.isTrue((boolean)Objects.equals(DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode(), orderEo.getOrderStatus()), (String)"\u8ba2\u5355\u975e'\u5f85\u786e\u8ba4'\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91");
        dgOrderReqDto.setOrderNo(orderEo.getOrderNo());
        this.verifySubmitParams(dgOrderReqDto);
    }

    private DgAdvanceOrderEo createOrder(DgAdvanceOrderReqDto dgOrderReqDto) {
        DgAdvanceOrderEo orderEo = (DgAdvanceOrderEo)BeanUtil.toBean((Object)dgOrderReqDto, DgAdvanceOrderEo.class);
        orderEo.setOrderStatus(DgF2BAdvanceOrderStatus.WAIT_CHECK.getCode());
        orderEo.setOrderNo(this.noGreateUtil.generateYdOrderNo(orderEo.getShopCode()));
        this.dgAdvanceOrderDomain.insert((BaseEo)orderEo);
        ArrayList<DgAdvanceOrderItemLineEo> itemLineEoList = new ArrayList<DgAdvanceOrderItemLineEo>();
        for (DgAdvanceOrderItemLineDto itemLineDto : dgOrderReqDto.getItemLineDtoList()) {
            DgAdvanceOrderItemLineEo itemLineEo = (DgAdvanceOrderItemLineEo)BeanUtil.toBean((Object)itemLineDto, DgAdvanceOrderItemLineEo.class);
            itemLineEo.setOrderId(orderEo.getId());
            itemLineEo.setOrderNo(orderEo.getOrderNo());
            itemLineEo.setStatus(Integer.valueOf(0));
            itemLineEoList.add(itemLineEo);
        }
        this.dgAdvanceOrderItemLineDomain.insertBatch(itemLineEoList);
        DgAdvanceOrderCustomerEo customerEo = (DgAdvanceOrderCustomerEo)BeanUtil.toBean((Object)orderEo, DgAdvanceOrderCustomerEo.class);
        customerEo.setOrderId(orderEo.getId());
        customerEo.setOrderNo(orderEo.getOrderNo());
        customerEo.setMainCustomer(YesNoEnum.YES.getValue());
        this.dgAdvanceOrderCustomerDomain.insert((BaseEo)customerEo);
        return orderEo;
    }

    private void fillItemListData(DgAdvanceOrderReqDto dgOrderReqDto) {
        List<DgShopRespDto> dgShopRespDtoList = this.preInfoQueryAction.queryListShop(Collections.singletonList(dgOrderReqDto.getShopId()));
        Map shopSaleOrgMap = dgShopRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1));
        DgShopRespDto shopRespDto = (DgShopRespDto)shopSaleOrgMap.get(dgOrderReqDto.getShopId());
        AssertUtils.notNull((Object)shopRespDto, (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgOrgCustomerRelationExtReqDto relationExtReqDto = new DgOrgCustomerRelationExtReqDto();
        relationExtReqDto.setCustomerIdList(Collections.singletonList(dgOrderReqDto.getCustomerId()));
        relationExtReqDto.setShopIdList(Collections.singletonList(dgOrderReqDto.getShopId()));
        List relationRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgTobOrgCustomerRelationQueryApiProxy.queryByShopIdsAndCustomerIds(relationExtReqDto));
        DgPjOrgCustomerRelationExtRespDto relationRespDto = ((List)Optional.ofNullable(relationRespDtoList).orElse(new ArrayList())).stream().filter(o -> Objects.equals(dgOrderReqDto.getShopId(), o.getShopId()) && Objects.equals(dgOrderReqDto.getCustomerId(), o.getCustomerId())).findFirst().orElse(null);
        AssertUtils.notNull((Object)relationRespDto, (String)"\u627e\u4e0d\u5230\u8be5\u5ba2\u6237\u4e0e\u5e97\u94fa\u5bf9\u5e94\u4ea4\u6613\u5173\u7cfb\u7684\u7b7e\u7ea6\u516c\u53f8");
        List orderItemLineList = dgOrderReqDto.getItemLineDtoList().stream().filter(line -> !Objects.equals(line.getVirtualItem(), YesNoEnum.YES.getValue())).collect(Collectors.toList());
        Map<Object, Object> skuIdDtoMap = new HashMap();
        Map<Object, Object> skuIdPolicyPriceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(orderItemLineList)) {
            List<Long> skuIds = orderItemLineList.stream().map(DgAdvanceOrderItemLineReqDto::getSkuId).collect(Collectors.toList());
            List<Long> itemIdList = orderItemLineList.stream().map(DgAdvanceOrderItemLineReqDto::getItemId).collect(Collectors.toList());
            PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryItemShopListByPage(Collections.singletonList(dgOrderReqDto.getShopId()), skuIds, itemIdList, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
            skuIdDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
            ArrayList<SkuSupplyPriceQueryV2ReqDto> priceQueryV2ReqDtoList = new ArrayList<SkuSupplyPriceQueryV2ReqDto>();
            for (DgAdvanceOrderItemLineReqDto itemLineDto : orderItemLineList) {
                SkuSupplyPriceQueryV2ReqDto reqDto = new SkuSupplyPriceQueryV2ReqDto();
                reqDto.setSkuId(itemLineDto.getSkuId());
                reqDto.setShopId(dgOrderReqDto.getShopId());
                reqDto.setSaleCompanyId(shopRespDto.getSaleOrganizationId());
                priceQueryV2ReqDtoList.add(reqDto);
            }
            List priceRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(dgOrderReqDto.getCustomerId(), priceQueryV2ReqDtoList));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)priceRespDtoList), (String)"\u6240\u9009\u5546\u54c1\u5168\u90e8\u6682\u65e0\u62a5\u4ef7");
            skuIdPolicyPriceMap = priceRespDtoList.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        }
        for (DgAdvanceOrderItemLineReqDto itemLineDto : dgOrderReqDto.getItemLineDtoList()) {
            itemLineDto.setStatus(AdvanceOrderItemLineStatusEnum.NORMAL.getStatus());
            itemLineDto.setStatus(AdvanceOrderItemLineStatusEnum.NORMAL.getStatus());
            itemLineDto.setEntryStatus(AdvanceOrderItemLineStatusEnum.NOT_ENTRY.getStatus());
            itemLineDto.setDeliveryPlan(AdvanceOrderItemLineStatusEnum.NOT_DELIVERY.getStatus());
            itemLineDto.setWeightUnit(StringUtils.isBlank((CharSequence)itemLineDto.getWeightUnit()) ? "kg" : itemLineDto.getWeightUnit());
            itemLineDto.setDeliveryNum(BigDecimal.ZERO);
            itemLineDto.setReleaseAdvanceAmount(BigDecimal.ZERO);
            itemLineDto.setRemainNum(itemLineDto.getItemNum());
            itemLineDto.setAdditivePrice(this.numScale(itemLineDto.getSalePrice(), 4));
            if (!Objects.equals(itemLineDto.getVirtualItem(), YesNoEnum.YES.getValue())) {
                DgItemSkuPageRespDto skuPageRespDto = (DgItemSkuPageRespDto)skuIdDtoMap.get(itemLineDto.getSkuId());
                AssertUtils.notNull((Object)skuPageRespDto, (String)("\u8d27\u54c1" + itemLineDto.getSkuId() + "\u672a\u627e\u5230"));
                BigDecimal supplyPrice = ((SkuPolicyPriceRespDto)skuIdPolicyPriceMap.get(itemLineDto.getSkuId())).getSupplyPrice();
                AssertUtils.notNull((Object)supplyPrice, (String)("\u8d27\u54c1" + itemLineDto.getSkuId() + "\u672a\u627e\u5230\u4f9b\u8d27\u4ef7"));
                if (supplyPrice.compareTo(itemLineDto.getSalePrice()) < 0) {
                    throw new BizException("\u8d27\u54c1" + skuPageRespDto.getSkuName() + "\u7684\u7533\u8bf7\u5355\u4ef7\u5927\u4e8e\u4f9b\u8d27\u4ef7\uff01");
                }
                itemLineDto.setSkuCode(skuPageRespDto.getSkuCode());
                itemLineDto.setSkuName(skuPageRespDto.getSkuName());
                itemLineDto.setItemName(skuPageRespDto.getItemName());
                itemLineDto.setUnitCode(skuPageRespDto.getUnit());
                itemLineDto.setUnitName(skuPageRespDto.getUnitName());
                itemLineDto.setPackageNum(skuPageRespDto.getPackageNum());
                itemLineDto.setPurchaseChannel(skuPageRespDto.getPurchaseChannel());
                itemLineDto.setSupplyPrice(supplyPrice);
                itemLineDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)skuPageRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)skuPageRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)skuPageRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)skuPageRespDto.getMediaMainList().get(0)).getPath1() : null));
                itemLineDto.setWeightUnit(StringUtils.isBlank((CharSequence)skuPageRespDto.getWeightUnit()) ? "kg" : skuPageRespDto.getWeightUnit());
                BigDecimal weight = UnitConverUtil.toKg(Optional.ofNullable(skuPageRespDto.getGrossWeight()).orElse(BigDecimal.ZERO), itemLineDto.getWeightUnit());
                itemLineDto.setWeight(weight.multiply(itemLineDto.getItemNum()));
                BigDecimal volume = UnitConverUtil.convertToCubicMeter(Optional.ofNullable(skuPageRespDto.getVolume()).orElse(BigDecimal.ZERO), skuPageRespDto.getVolumeUnit());
                itemLineDto.setVolume(volume.multiply(itemLineDto.getItemNum()));
            }
            BigDecimal salePrice = this.numScale(itemLineDto.getSalePrice(), 4);
            BigDecimal oneHundred = this.numScale(new BigDecimal("100"), 4);
            itemLineDto.setHandmadeDiscount(salePrice.multiply(oneHundred).divide(itemLineDto.getSupplyPrice(), 2, RoundingMode.HALF_UP));
            BigDecimal itemNum = this.numScale(itemLineDto.getItemNum(), 4);
            BigDecimal totalAmount = itemNum.multiply(salePrice).setScale(2, RoundingMode.HALF_UP);
            itemLineDto.setTotalAmount(totalAmount);
            BigDecimal depositRatioAmount = totalAmount.multiply(dgOrderReqDto.getDepositRatio()).setScale(4, RoundingMode.HALF_UP);
            itemLineDto.setAdvanceAmount(depositRatioAmount.divide(oneHundred, 2, RoundingMode.HALF_UP));
        }
        dgOrderReqDto.setOrganizationId(shopRespDto.getSaleOrganizationId());
        dgOrderReqDto.setOrganizationCode(shopRespDto.getSaleOrganizationCode());
        dgOrderReqDto.setEnterpriseId(relationRespDto.getEnterpriseId());
        dgOrderReqDto.setEnterpriseCode(relationRespDto.getEnterpriseCode());
        dgOrderReqDto.setBusinessAreaId(relationRespDto.getAreaId());
        dgOrderReqDto.setBusinessAreaCode(relationRespDto.getAreaCode());
        dgOrderReqDto.setPayStatus(Integer.valueOf(0));
        dgOrderReqDto.setTotalAmount(dgOrderReqDto.getItemLineDtoList().stream().map(DgAdvanceOrderItemLineDto::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        dgOrderReqDto.setAdvanceAmount(dgOrderReqDto.getItemLineDtoList().stream().map(DgAdvanceOrderItemLineDto::getAdvanceAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    private BigDecimal numScale(BigDecimal value, int scale) {
        if (Objects.isNull(value)) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    private void verifySubmitParams(DgAdvanceOrderReqDto dgOrderReqDto) {
        AssertUtils.notNull((Object)dgOrderReqDto, (String)"\u5165\u53c2\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getShopCode(), (String)"\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getShopName(), (String)"\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getDepositRatio(), (String)"\u8ba2\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getOrderType(), (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgOrderReqDto.getOrderSource(), (String)"\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgOrderReqDto.getItemLineDtoList()), (String)"\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList skuIdList = Lists.newArrayList();
        ArrayList skuCodeList = Lists.newArrayList();
        for (DgAdvanceOrderItemLineReqDto itemLineDto : dgOrderReqDto.getItemLineDtoList()) {
            AssertUtils.notNull((Object)itemLineDto.getItemNum(), (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)itemLineDto.getSalePrice(), (String)"\u7533\u8bf7\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            if (Objects.equals(itemLineDto.getVirtualItem(), YesNoEnum.YES.getValue())) {
                AssertUtils.notEmpty((String)itemLineDto.getSkuCode(), (String)"sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notEmpty((String)itemLineDto.getSkuName(), (String)"sku\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)itemLineDto.getSupplyPrice(), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                skuCodeList.add(itemLineDto.getSkuCode());
                continue;
            }
            AssertUtils.notNull((Object)itemLineDto.getSkuId(), (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)itemLineDto.getItemId(), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            skuIdList.add(itemLineDto.getSkuId());
        }
        if (CollectionUtils.isNotEmpty((Collection)skuCodeList)) {
            ItemQueryDgReqDto baseItemQueryDto = new ItemQueryDgReqDto();
            baseItemQueryDto.setSkuCodes((List)skuCodeList);
            baseItemQueryDto.setPageNum(Integer.valueOf(1));
            baseItemQueryDto.setPageSize(Integer.valueOf(skuCodeList.size() * 2));
            baseItemQueryDto.setSubStatus(Integer.valueOf(1));
            PageInfo dgItemSkuPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(baseItemQueryDto));
            if (CollectionUtils.isNotEmpty((Collection)dgItemSkuPageRespDtoPageInfo.getList())) {
                String skuCodes = dgItemSkuPageRespDtoPageInfo.getList().stream().map(DgItemSkuRespDto::getSkuCode).collect(Collectors.joining(","));
                throw new BizException("SKU[" + skuCodes + "]\u4e0d\u662f\u5141\u8d2d\u5546\u54c1\uff0c\u4e0d\u53ef\u4ee5\u6dfb\u52a0");
            }
        }
        if (CollectionUtils.isEmpty((Collection)skuIdList)) {
            log.info("\u8ba2\u5355\u5546\u54c1\u672a\u6709\u4e0a\u67b6\u5141\u8d2d\u5546\u54c1");
            return;
        }
        DgEsCustomerBuyScopeItemQueryDto queryDto = new DgEsCustomerBuyScopeItemQueryDto();
        queryDto.setShopId(dgOrderReqDto.getShopId());
        queryDto.setCustomerId(dgOrderReqDto.getCustomerId());
        queryDto.setShelfStatus(YesNoEnum.YES.getValue());
        queryDto.setSkuIdList((List)skuIdList);
        queryDto.setStatus(YesNoEnum.NO.getValue());
        queryDto.setPageSize(Integer.valueOf(1000));
        PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCustomerBuyScopeItemQueryApiProxy.queryTobEsBuyScopeItemPage(queryDto));
        AssertUtils.isTrue((itemRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)itemRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u6240\u6709\u4e0b\u5355\u5546\u54c1\u67e5\u8be2\u4e0d\u5230\u4e0a\u67b6\u5141\u8d2d\u4fe1\u606f");
        Map skuDgDtoMap = itemRespDtoPageInfo.getList().stream().map(ShopItemEsRespDto::getItemSkuList).flatMap(Collection::stream).collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        for (DgAdvanceOrderItemLineReqDto itemLineReqDto : dgOrderReqDto.getItemLineDtoList()) {
            if (Objects.equals(itemLineReqDto.getVirtualItem(), YesNoEnum.YES.getValue())) continue;
            AssertUtils.isTrue((boolean)skuDgDtoMap.containsKey(itemLineReqDto.getSkuId()), (String)String.format("\u5546\u54c1\u4e0a\u67b6\u5141\u8d2d\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s", itemLineReqDto.getItemId()));
        }
    }

    @Override
    public BigDecimal updateItemLineByRelevanceOrder(DgAdvanceRelevanceOrderExtDto reqDto) {
        return this.dgAdvanceRelevanceOrderService.updateItemLineByRelevanceOrder(reqDto);
    }
}

