/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.query.AfterSaleRuleQueryDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.api.query.IDgTobOrgCustomerRelationQueryApi;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobCustomerAreaQueryApiProxy;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleRuleConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleRulesItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleRulesSuitDomain;
import com.yunxi.dg.base.center.trade.dto.SimpleDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleAfterSaleRuleDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleCustomerDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleItemDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleOrderRuleDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleItemRuleShopDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.MatchItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.OrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleRuleDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleRulesItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgAfterSaleRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgAfterSaleRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleRulesItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleRulesSuitEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleRuleService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleRulesItemService;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleRuleServiceImpl
extends BaseServiceImpl<DgAfterSaleRuleDto, DgAfterSaleRuleEo, IDgAfterSaleRuleDomain>
implements IDgAfterSaleRuleService {
    private static final Logger logger = LoggerFactory.getLogger(DgAfterSaleRuleServiceImpl.class);
    @Resource
    protected IDgAfterSaleRulesSuitDomain dgAfterSaleRulesSuitDomain;
    @Resource
    protected IDgAfterSaleRulesItemDomain dgAfterSaleRulesItemDomain;
    @Resource
    protected IDgAfterSaleRulesItemService afterSaleRulesItemService;
    @Resource
    protected DgNoGreateUtil dgNoGreateUtil;
    @Resource
    protected IDgAfterSaleRulesItemDomain rulesItemDomain;
    @Resource
    protected IDgTobCustomerAreaQueryApiProxy customerAreaQueryApiProxy;
    @Resource
    protected IDgCustomerQueryApiProxy customerQueryApiProxy;
    @Resource
    protected IDgTobOrgCustomerRelationQueryApi customerRelationQueryApi;

    public DgAfterSaleRuleServiceImpl(IDgAfterSaleRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public DgAfterSaleRuleEo converter(AfterSaleItemRuleReqDto reqDto) {
        DgAfterSaleRuleEo ruleEo = new DgAfterSaleRuleEo();
        ruleEo.setRuleName(reqDto.getName());
        ruleEo.setRuleStatus(Integer.valueOf(reqDto.getStatus()));
        ruleEo.setRemark(reqDto.getRemark());
        ruleEo.setShopId(reqDto.getShopId());
        ruleEo.setShopCode(reqDto.getShopCode());
        ruleEo.setShopName(reqDto.getShopName());
        ruleEo.setType("ITEM");
        return ruleEo;
    }

    @Override
    public void deleteById(Long id) {
        ((IDgAfterSaleRuleDomain)this.domain).deleteById(id);
        DgAfterSaleRulesSuitEo update = new DgAfterSaleRulesSuitEo();
        update.setRuleId(id);
        this.dgAfterSaleRulesSuitDomain.delete((BaseEo)update);
    }

    @Override
    public AfterSaleItemRuleReqDto detailItemRule(long id) {
        DgAfterSaleRuleEo dgAfterSaleRuleEo = (DgAfterSaleRuleEo)((IDgAfterSaleRuleDomain)this.domain).selectByPrimaryKey(Long.valueOf(id));
        DgAfterSaleRulesSuitEo query = new DgAfterSaleRulesSuitEo();
        query.setRuleId(Long.valueOf(id));
        List dgAfterSaleRulesSuitEos = this.dgAfterSaleRulesSuitDomain.selectList((BaseEo)query);
        AfterSaleItemRuleReqDto afterSaleItemRuleReqDto = (AfterSaleItemRuleReqDto)BeanUtil.copyProperties((Object)dgAfterSaleRuleEo, AfterSaleItemRuleReqDto.class, (String[])new String[0]);
        afterSaleItemRuleReqDto.setName(dgAfterSaleRuleEo.getRuleName());
        afterSaleItemRuleReqDto.setCode(dgAfterSaleRuleEo.getRuleCode());
        afterSaleItemRuleReqDto.setStatus(dgAfterSaleRuleEo.getRuleStatus().intValue());
        Map<String, List<DgAfterSaleRulesSuitEo>> collect = dgAfterSaleRulesSuitEos.stream().collect(Collectors.groupingBy(DgAfterSaleRulesSuitEo::getSuitType));
        afterSaleItemRuleReqDto.setAfterSaleItemRuleItemDto(this.convertItemRule(collect));
        afterSaleItemRuleReqDto.setAfterSaleItemRuleCustomerDto(this.convertCustomerRule(collect));
        afterSaleItemRuleReqDto.setAfterSaleItemRuleOrderRuleDto(this.convertOrderRule(collect));
        afterSaleItemRuleReqDto.setAfterSaleItemRuleAfterSaleRuleDto(this.convertAfterOrderRule(collect));
        return afterSaleItemRuleReqDto;
    }

    private AfterSaleItemRuleAfterSaleRuleDto convertAfterOrderRule(Map<String, List<DgAfterSaleRulesSuitEo>> collect) {
        AfterSaleItemRuleAfterSaleRuleDto result = new AfterSaleItemRuleAfterSaleRuleDto();
        LinkedList<SimpleDto> dtos = new LinkedList<SimpleDto>();
        List<DgAfterSaleRulesSuitEo> dgAfterSaleRulesSuitEos = collect.get("AFTER_RULE_RETURN_BIZ_TYPE");
        if (ObjectUtil.isEmpty(dgAfterSaleRulesSuitEos)) {
            return result;
        }
        for (DgAfterSaleRulesSuitEo dgAfterSaleRulesSuitEo : dgAfterSaleRulesSuitEos) {
            SimpleDto dto = new SimpleDto();
            result.setOrderRule(dgAfterSaleRulesSuitEo.getSuitSelectType());
            if (dgAfterSaleRulesSuitEo.getSuitKey().equals("ALL")) continue;
            dto.setId(dgAfterSaleRulesSuitEo.getSuitKey());
            dto.setName(dgAfterSaleRulesSuitEo.getSuitName());
            dtos.add(dto);
        }
        result.setReturnBizTypeInclude(dtos);
        return result;
    }

    private AfterSaleItemRuleOrderRuleDto convertOrderRule(Map<String, List<DgAfterSaleRulesSuitEo>> collect) {
        AfterSaleItemRuleOrderRuleDto result = new AfterSaleItemRuleOrderRuleDto();
        LinkedList<SimpleDto> dtos = new LinkedList<SimpleDto>();
        List<DgAfterSaleRulesSuitEo> dgAfterSaleRulesSuitEos = collect.get("ORDER_RULE_TYPE");
        if (ObjectUtil.isEmpty(dgAfterSaleRulesSuitEos)) {
            return result;
        }
        for (DgAfterSaleRulesSuitEo dgAfterSaleRulesSuitEo : dgAfterSaleRulesSuitEos) {
            SimpleDto dto = new SimpleDto();
            result.setOrderRule(dgAfterSaleRulesSuitEo.getSuitSelectType());
            if (dgAfterSaleRulesSuitEo.getSuitKey().equals("ALL")) continue;
            dto.setId(dgAfterSaleRulesSuitEo.getSuitKey());
            dto.setName(dgAfterSaleRulesSuitEo.getSuitName());
            dtos.add(dto);
        }
        result.setOrderInclude(dtos);
        return result;
    }

    private AfterSaleItemRuleCustomerDto convertCustomerRule(Map<String, List<DgAfterSaleRulesSuitEo>> collect) {
        AfterSaleItemRuleCustomerDto result = new AfterSaleItemRuleCustomerDto();
        result.setCustomerRule("ALL");
        for (String s : collect.keySet()) {
            LinkedList<SimpleDto> dtos = new LinkedList<SimpleDto>();
            for (DgAfterSaleRulesSuitEo dgAfterSaleRulesSuitEo : collect.get(s)) {
                SimpleDto dto = new SimpleDto();
                if (dgAfterSaleRulesSuitEo.getSuitKey().equals("ALL")) continue;
                dto.setId(dgAfterSaleRulesSuitEo.getSuitKey());
                dto.setName(dgAfterSaleRulesSuitEo.getSuitName());
                dtos.add(dto);
            }
            switch (s) {
                case "CUSTOMER_RULE_EXCLUDE": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setCustomerRule("RANGE");
                    }
                    result.setCustomerExclude(dtos);
                    break;
                }
                case "CUSTOMER_RULE_INCLUDE": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setCustomerRule("SELECT");
                    }
                    result.setCustomerInclude(dtos);
                    break;
                }
                case "CUSTOMER_RULE_REGION": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setCustomerRule("RANGE");
                    }
                    result.setCustomerRegion(dtos);
                    break;
                }
                case "CUSTOMER_RULE_GROUP": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setCustomerRule("RANGE");
                    }
                    result.setCustomerGroup(dtos);
                    break;
                }
                case "CUSTOMER_RULE_TYPE": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setCustomerRule("RANGE");
                    }
                    result.setCustomerType(dtos);
                }
            }
        }
        return result;
    }

    private AfterSaleItemRuleItemDto convertItemRule(Map<String, List<DgAfterSaleRulesSuitEo>> collect) {
        AfterSaleItemRuleItemDto result = new AfterSaleItemRuleItemDto();
        for (String s : collect.keySet()) {
            LinkedList<SimpleDto> dtos = new LinkedList<SimpleDto>();
            for (DgAfterSaleRulesSuitEo dgAfterSaleRulesSuitEo : collect.get(s)) {
                SimpleDto dto = new SimpleDto();
                if (dgAfterSaleRulesSuitEo.getSuitKey().equals("ALL")) continue;
                dto.setId(dgAfterSaleRulesSuitEo.getSuitKey());
                dto.setName(dgAfterSaleRulesSuitEo.getSuitName());
                dtos.add(dto);
            }
            switch (s) {
                case "ITEM_RULE": {
                    result.setItemRule("ALL");
                    break;
                }
                case "ITEM_RULE_BRAND": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setItemRule("RANGE");
                    }
                    result.setItemBrands(dtos);
                    break;
                }
                case "ITEM_RULE_CATEGORY": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setItemRule("RANGE");
                    }
                    result.setItemCategories(dtos);
                    break;
                }
                case "ITEM_RULE_EXCLUDE": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setItemRule("RANGE");
                    }
                    result.setExcludeItemIds(dtos);
                    break;
                }
                case "ITEM_RULE_INCLUDE": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setItemRule("SELECT");
                    }
                    result.setItemIds(dtos);
                    break;
                }
                case "ITEM_RULE_TAG": {
                    if (ObjectUtil.isNotEmpty(dtos)) {
                        result.setItemRule("RANGE");
                    }
                    result.setItemTags(dtos);
                }
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void modify(Long id, AfterSaleItemRuleReqDto reqDto) {
        DgAfterSaleRuleEo ruleEo = this.converter(reqDto);
        ruleEo.setId(id);
        if (ObjectUtil.isNotEmpty((Object)reqDto.getShopId())) {
            DgAfterSaleRuleEo update = new DgAfterSaleRuleEo();
            update.setId(id);
            update.setShopId(reqDto.getShopId());
            update.setShopName(reqDto.getShopName());
            update.setShopCode(reqDto.getShopCode());
            update.setRuleStatus(Integer.valueOf(reqDto.getStatus()));
            ((IDgAfterSaleRuleDomain)this.domain).updateSelective((BaseEo)update);
        }
        DgAfterSaleRulesSuitEo delete = new DgAfterSaleRulesSuitEo();
        delete.setRuleId(id);
        this.dgAfterSaleRulesSuitDomain.delete((BaseEo)delete);
        LinkedList<Object> result = new LinkedList<Object>();
        if (ObjectUtil.isNotEmpty((Object)reqDto.getAfterSaleItemRuleItemDto())) {
            result.addAll(this.createItemRule(reqDto.getAfterSaleItemRuleItemDto(), ruleEo.getId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getAfterSaleItemRuleCustomerDto())) {
            result.addAll(this.createCustomerRule(reqDto.getAfterSaleItemRuleCustomerDto(), ruleEo.getId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getAfterSaleItemRuleOrderRuleDto())) {
            result.addAll(this.createOrderRule(reqDto.getAfterSaleItemRuleOrderRuleDto(), ruleEo.getId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getAfterSaleItemRuleAfterSaleRuleDto())) {
            result.addAll(this.createAfterSaleTypeRule(reqDto.getAfterSaleItemRuleAfterSaleRuleDto(), ruleEo.getId()));
        }
        if (ObjectUtil.isNotEmpty(result)) {
            this.dgAfterSaleRulesSuitDomain.insertBatch(result);
        }
    }

    @Override
    @Transactional
    public Long add(AfterSaleItemRuleReqDto reqDto) {
        List exists = ((ExtQueryChainWrapper)((IDgAfterSaleRuleDomain)this.domain).filter().eq((Object)"rule_name", (Object)reqDto.getName())).list();
        if (ObjectUtil.isNotEmpty((Object)exists)) {
            for (DgAfterSaleRuleEo exist : exists) {
                if (!Objects.equals(0, exist.getDr())) continue;
                logger.info("\u9000\u8d27\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e2d\u65ad\u5904\u7406");
                throw new BizException("500", "\u9000\u8d27\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        DgAfterSaleRuleEo ruleEo = this.converter(reqDto);
        ruleEo.setRuleCode(this.dgNoGreateUtil.generateAfterSaleRuleItem());
        ((IDgAfterSaleRuleDomain)this.domain).insert((BaseEo)ruleEo);
        LinkedList<Object> result = new LinkedList<Object>();
        result.addAll(this.createItemRule(reqDto.getAfterSaleItemRuleItemDto(), ruleEo.getId()));
        result.addAll(this.createCustomerRule(reqDto.getAfterSaleItemRuleCustomerDto(), ruleEo.getId()));
        result.addAll(this.createOrderRule(reqDto.getAfterSaleItemRuleOrderRuleDto(), ruleEo.getId()));
        result.addAll(this.createAfterSaleTypeRule(reqDto.getAfterSaleItemRuleAfterSaleRuleDto(), ruleEo.getId()));
        this.dgAfterSaleRulesSuitDomain.insertBatch(result);
        return ruleEo.getId();
    }

    private List<DgAfterSaleRulesSuitEo> createOrderRule(AfterSaleItemRuleOrderRuleDto reqDto, Long id) {
        List<DgAfterSaleRulesSuitEo> suit = this.createSuit(reqDto.getOrderInclude(), "ORDER_RULE_TYPE", reqDto.getOrderRule(), id);
        if (ObjectUtil.isEmpty(suit)) {
            SimpleDto dto = new SimpleDto();
            dto.setId("ALL");
            dto.setName("ALL");
            suit.addAll(this.createSuit(Lists.newArrayList((Object[])new SimpleDto[]{dto}), "ORDER_RULE_TYPE", "ALL", id));
        }
        return suit;
    }

    private List<DgAfterSaleRulesSuitEo> createAfterSaleTypeRule(AfterSaleItemRuleAfterSaleRuleDto reqDto, Long id) {
        List<DgAfterSaleRulesSuitEo> suit = this.createSuit(reqDto.getReturnBizTypeInclude(), "AFTER_RULE_RETURN_BIZ_TYPE", reqDto.getOrderRule(), id);
        if (ObjectUtil.isEmpty(suit)) {
            SimpleDto dto = new SimpleDto();
            dto.setId("ALL");
            dto.setName("ALL");
            suit.addAll(this.createSuit(Lists.newArrayList((Object[])new SimpleDto[]{dto}), "AFTER_RULE_RETURN_BIZ_TYPE", "ALL", id));
        }
        return suit;
    }

    private Collection<? extends DgAfterSaleRulesSuitEo> createCustomerRule(AfterSaleItemRuleCustomerDto reqDto, Long id) {
        LinkedList<DgAfterSaleRulesSuitEo> customer = new LinkedList<DgAfterSaleRulesSuitEo>();
        SimpleDto dto = new SimpleDto();
        dto.setId("ALL");
        dto.setName("ALL");
        ArrayList defaultDto = Lists.newArrayList((Object[])new SimpleDto[]{dto});
        if ("ALL".equals(reqDto.getCustomerRule())) {
            customer.addAll(this.createSuit(defaultDto, "CUSTOMER_RULE", reqDto.getCustomerRule(), id));
        } else {
            customer.addAll(this.createSuit(reqDto.getCustomerInclude(), "CUSTOMER_RULE_INCLUDE", reqDto.getCustomerRule(), id));
            customer.addAll(this.createSuit(reqDto.getCustomerExclude(), "CUSTOMER_RULE_EXCLUDE", reqDto.getCustomerRule(), id));
            if (ObjectUtil.isEmpty((Object)reqDto.getCustomerGroup()) && ObjectUtil.isEmpty((Object)reqDto.getCustomerInclude())) {
                reqDto.setCustomerGroup((List)defaultDto);
            }
            if (ObjectUtil.isEmpty((Object)reqDto.getCustomerType()) && ObjectUtil.isEmpty((Object)reqDto.getCustomerInclude())) {
                reqDto.setCustomerType((List)defaultDto);
            }
            if (ObjectUtil.isEmpty((Object)reqDto.getCustomerRegion()) && ObjectUtil.isEmpty((Object)reqDto.getCustomerInclude())) {
                reqDto.setCustomerRegion((List)defaultDto);
            }
            customer.addAll(this.createSuit(reqDto.getCustomerGroup(), "CUSTOMER_RULE_GROUP", reqDto.getCustomerRule(), id));
            customer.addAll(this.createSuit(reqDto.getCustomerRegion(), "CUSTOMER_RULE_REGION", reqDto.getCustomerRule(), id));
            customer.addAll(this.createSuit(reqDto.getCustomerType(), "CUSTOMER_RULE_TYPE", reqDto.getCustomerRule(), id));
        }
        return customer;
    }

    private Collection<? extends DgAfterSaleRulesSuitEo> createShopRule(AfterSaleItemRuleShopDto reqDto, Long id) {
        LinkedList<DgAfterSaleRulesSuitEo> customer = new LinkedList<DgAfterSaleRulesSuitEo>(this.createSuit(reqDto.getShopInclude(), "SHOP_RULE_INCLUDE", reqDto.getShopRule(), id));
        if (ObjectUtil.isEmpty(customer)) {
            SimpleDto dto = new SimpleDto();
            dto.setId("ALL");
            dto.setName("ALL");
            customer.addAll(this.createSuit(Lists.newArrayList((Object[])new SimpleDto[]{dto}), "SHOP_RULE", reqDto.getShopRule(), id));
        }
        return customer;
    }

    private List<DgAfterSaleRulesSuitEo> createItemRule(AfterSaleItemRuleItemDto reqDto, Long id) {
        LinkedList<DgAfterSaleRulesSuitEo> items = new LinkedList<DgAfterSaleRulesSuitEo>();
        items.addAll(this.createSuit(reqDto.getExcludeItemIds(), "ITEM_RULE_EXCLUDE", reqDto.getItemRule(), id));
        items.addAll(this.createSuit(reqDto.getItemBrands(), "ITEM_RULE_BRAND", reqDto.getItemRule(), id));
        items.addAll(this.createSuit(reqDto.getItemCategories(), "ITEM_RULE_CATEGORY", reqDto.getItemRule(), id));
        items.addAll(this.createSuit(reqDto.getItemTags(), "ITEM_RULE_TAG", reqDto.getItemRule(), id));
        items.addAll(this.createSuit(reqDto.getItemIds(), "ITEM_RULE_INCLUDE", reqDto.getItemRule(), id));
        if (ObjectUtil.isEmpty(items)) {
            SimpleDto dto = new SimpleDto();
            dto.setId("ALL");
            dto.setName("ALL");
            items.addAll(this.createSuit(Lists.newArrayList((Object[])new SimpleDto[]{dto}), "ITEM_RULE", reqDto.getItemRule(), id));
        }
        return items;
    }

    private List<DgAfterSaleRulesSuitEo> createSuit(List<SimpleDto> data, String type, String selectType, Long ruleId) {
        LinkedList<DgAfterSaleRulesSuitEo> result = new LinkedList<DgAfterSaleRulesSuitEo>();
        if (ObjectUtil.isEmpty(data)) {
            return result;
        }
        for (SimpleDto datum : data) {
            DgAfterSaleRulesSuitEo eo = new DgAfterSaleRulesSuitEo();
            eo.setSuitMatchCode(type + "_" + datum.getId());
            eo.setSuitName(datum.getName());
            eo.setSuitKey(datum.getId());
            eo.setSuitType(type);
            eo.setSuitSelectType(selectType);
            eo.setRuleId(ruleId);
            result.add(eo);
        }
        return result;
    }

    public IConverter<DgAfterSaleRuleDto, DgAfterSaleRuleEo> converter() {
        return DgAfterSaleRuleConverter.INSTANCE;
    }

    @Override
    public PageInfo<DgAfterSaleRuleDto> page(AfterSaleRuleQueryDto dto, int pageNum, int pageSize) {
        ExtQueryChainWrapper filter = ((IDgAfterSaleRuleDomain)this.domain).filter();
        filter.eq((Object)"type", (Object)dto.getType());
        if (ObjectUtil.isNotEmpty((Object)dto.getRemark())) {
            filter.like((Object)"remark", (Object)dto.getRemark());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getRuleName())) {
            filter.like((Object)"rule_name", (Object)dto.getRuleName());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getRuleCode())) {
            filter.like((Object)"rule_code", (Object)dto.getRuleCode());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getStartCreateTime())) {
            filter.ge((Object)"create_time", (Object)dto.getStartCreateTime());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getEndCreateTime())) {
            filter.le((Object)"create_time", (Object)dto.getEndCreateTime());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getStartUpdateTime())) {
            filter.ge((Object)"update_time", (Object)dto.getStartUpdateTime());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getEndUpdateTime())) {
            filter.le((Object)"update_time", (Object)dto.getEndUpdateTime());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)dto.getShopId());
        }
        PageInfo page = filter.page(Integer.valueOf(pageNum), Integer.valueOf(pageSize));
        PageInfo returnPageInfo = new PageInfo();
        BeanCopyUtil.copyProperties((Object)page, (Object)returnPageInfo);
        if (ObjectUtil.isNotEmpty((Object)page.getList())) {
            returnPageInfo.setList(this.converter().toDtoList(page.getList()));
        }
        return returnPageInfo;
    }

    @Override
    public DgAfterSaleRuleRespDto getDetail(long id) {
        DgAfterSaleRuleDto afterSaleRuleDto = (DgAfterSaleRuleDto)this.get(id).getData();
        DgAfterSaleRuleRespDto dgAfterSaleRuleRespDto = (DgAfterSaleRuleRespDto)BeanUtil.copyProperties((Object)afterSaleRuleDto, DgAfterSaleRuleRespDto.class, (String[])new String[0]);
        List<DgAfterSaleRulesItemDto> afterSaleRulesItemDtos = this.afterSaleRulesItemService.getList(id);
        dgAfterSaleRuleRespDto.setAfterSaleRulesItemDtos(afterSaleRulesItemDtos);
        DgAfterSaleRulesSuitEo query = new DgAfterSaleRulesSuitEo();
        query.setRuleId(Long.valueOf(id));
        List dgAfterSaleRulesSuitEos = this.dgAfterSaleRulesSuitDomain.selectList((BaseEo)query);
        Map<String, List<DgAfterSaleRulesSuitEo>> collect = dgAfterSaleRulesSuitEos.stream().collect(Collectors.groupingBy(DgAfterSaleRulesSuitEo::getSuitType));
        dgAfterSaleRuleRespDto.setAfterSaleItemRuleCustomerDto(this.convertCustomerRule(collect));
        dgAfterSaleRuleRespDto.setAfterSaleItemRuleShopDto(this.convertShopRule(collect));
        return dgAfterSaleRuleRespDto;
    }

    private AfterSaleItemRuleShopDto convertShopRule(Map<String, List<DgAfterSaleRulesSuitEo>> collect) {
        AfterSaleItemRuleShopDto result = new AfterSaleItemRuleShopDto();
        result.setShopRule("ALL");
        List<DgAfterSaleRulesSuitEo> dgAfterSaleRulesSuitEos = collect.get("SHOP_RULE_INCLUDE");
        if (ObjectUtil.isNotEmpty(dgAfterSaleRulesSuitEos)) {
            LinkedList<SimpleDto> dtos = new LinkedList<SimpleDto>();
            for (DgAfterSaleRulesSuitEo dgAfterSaleRulesSuitEo : dgAfterSaleRulesSuitEos) {
                SimpleDto dto = new SimpleDto();
                dto.setId(dgAfterSaleRulesSuitEo.getSuitKey());
                dto.setName(dgAfterSaleRulesSuitEo.getSuitName());
                dtos.add(dto);
            }
            result.setShopRule("SELECT");
            result.setShopInclude(dtos);
        }
        return result;
    }

    @Override
    @Transactional
    public Long createAfterSaleRule(DgAfterSaleRuleReqDto dto) {
        this.checkAfterSaleRule(dto);
        List exists = ((ExtQueryChainWrapper)((IDgAfterSaleRuleDomain)this.domain).filter().eq((Object)"rule_name", (Object)dto.getRuleName())).list();
        if (ObjectUtil.isNotEmpty((Object)exists)) {
            for (DgAfterSaleRuleEo exist : exists) {
                if (!Objects.equals(0, exist.getDr())) continue;
                logger.info("\u9000\u8d27\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e2d\u65ad\u5904\u7406");
                throw new BizException("500", "\u9000\u8d27\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        DgAfterSaleRuleEo afterSaleRuleEo = (DgAfterSaleRuleEo)BeanUtil.copyProperties((Object)dto, DgAfterSaleRuleEo.class, (String[])new String[0]);
        afterSaleRuleEo.setType("QUOTA");
        afterSaleRuleEo.setRuleCode(this.dgNoGreateUtil.generateAfterSaleRuleQuota());
        ((IDgAfterSaleRuleDomain)this.domain).insert((BaseEo)afterSaleRuleEo);
        ArrayList ruleItemEoList = Lists.newArrayList();
        dto.getAfterSaleRulesItemDtos().forEach(dgAfterSaleRulesItemDto -> {
            DgAfterSaleRulesItemEo dgAfterSaleRulesItemEo = new DgAfterSaleRulesItemEo();
            dgAfterSaleRulesItemDto.setRuleId(afterSaleRuleEo.getId());
            BeanUtil.copyProperties((Object)dgAfterSaleRulesItemDto, (Object)dgAfterSaleRulesItemEo, (String[])new String[0]);
            ruleItemEoList.add(dgAfterSaleRulesItemEo);
        });
        this.rulesItemDomain.insertBatch((List)ruleItemEoList);
        LinkedList<Object> suitResult = new LinkedList<Object>();
        suitResult.addAll(this.createCustomerRule(dto.getAfterSaleItemRuleCustomerDto(), afterSaleRuleEo.getId()));
        suitResult.addAll(this.createShopRule(dto.getAfterSaleItemRuleShopDto(), afterSaleRuleEo.getId()));
        this.dgAfterSaleRulesSuitDomain.insertBatch(suitResult);
        return afterSaleRuleEo.getId();
    }

    @Override
    @Transactional
    public void updateAfterSaleRule(DgAfterSaleRuleReqDto dto) {
        this.checkAfterSaleRule(dto);
        ((IDgAfterSaleRuleDomain)this.domain).updateAfterSaleRule(dto);
        LinkedList<Object> suitResult = new LinkedList<Object>();
        suitResult.addAll(this.createCustomerRule(dto.getAfterSaleItemRuleCustomerDto(), dto.getId()));
        suitResult.addAll(this.createShopRule(dto.getAfterSaleItemRuleShopDto(), dto.getId()));
        DgAfterSaleRulesSuitEo delete = new DgAfterSaleRulesSuitEo();
        delete.setRuleId(dto.getId());
        this.dgAfterSaleRulesSuitDomain.delete((BaseEo)delete);
        DgAfterSaleRulesItemEo deleteItem = new DgAfterSaleRulesItemEo();
        deleteItem.setRuleId(dto.getId());
        this.dgAfterSaleRulesItemDomain.delete((BaseEo)deleteItem);
        ArrayList ruleItemEoList = Lists.newArrayList();
        for (DgAfterSaleRulesItemDto dgAfterSaleRulesItemDto : dto.getAfterSaleRulesItemDtos()) {
            DgAfterSaleRulesItemEo dgAfterSaleRulesItemEo = new DgAfterSaleRulesItemEo();
            dgAfterSaleRulesItemDto.setRuleId(dto.getId());
            BeanUtil.copyProperties((Object)dgAfterSaleRulesItemDto, (Object)dgAfterSaleRulesItemEo, (String[])new String[0]);
            ruleItemEoList.add(dgAfterSaleRulesItemEo);
        }
        this.dgAfterSaleRulesItemDomain.insertBatch((List)ruleItemEoList);
        this.dgAfterSaleRulesSuitDomain.insertBatch(suitResult);
    }

    @Override
    public void modifyAfterSaleRuleStatus(Long ruleId, Integer status) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)status, (String)"status\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgAfterSaleRuleEo updateEo = new DgAfterSaleRuleEo();
        updateEo.setId(ruleId);
        updateEo.setRuleStatus(status);
        ((IDgAfterSaleRuleDomain)this.domain).updateSelective((BaseEo)updateEo);
    }

    @Override
    public void logicDeleteAfterSaleRule(Long ruleId) {
        this.logicDelete(ruleId);
        DgAfterSaleRulesItemEo rulesUpdate = new DgAfterSaleRulesItemEo();
        rulesUpdate.setRuleId(ruleId);
        this.dgAfterSaleRulesItemDomain.logicDelete((BaseEo)rulesUpdate);
        DgAfterSaleRulesSuitEo suitUpdate = new DgAfterSaleRulesSuitEo();
        suitUpdate.setRuleId(ruleId);
        this.dgAfterSaleRulesSuitDomain.delete((BaseEo)suitUpdate);
    }

    @Override
    public DgAfterSaleRuleRespDto queryRuleByCustomerAndShop(String customerCode, String customerType, String customerGroup, List<String> customerRegion, String shopCode) {
        Set<Long> ruleIds = this.matchCustomerRule(customerCode, customerType, customerGroup, customerRegion);
        List list2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)("SHOP_RULE_INCLUDE_" + shopCode))).or()).eq((Object)"suit_match_code", (Object)"SHOP_RULE_ALL")).select(new String[]{"rule_id"}).list();
        List matchRuleIds = ListUtils.intersection(new ArrayList<Long>(ruleIds), list2.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList()));
        if (ObjectUtil.isEmpty((Object)matchRuleIds)) {
            return null;
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleRuleDomain)this.domain).filter().in((Object)"id", (Collection)matchRuleIds)).eq((Object)"type", (Object)"QUOTA")).eq((Object)"rule_status", (Object)1)).orderByDesc((Object)"create_time")).list();
        if (ObjectUtil.isNotEmpty((Object)list)) {
            return this.getDetail(((DgAfterSaleRuleEo)list.get(0)).getId());
        }
        return null;
    }

    @Override
    public MatchItemReqDto getMatchItemReqDto(Long customerId, String customerCode, Long shopId, String shopCode) {
        CsOrgCustomerRelationPageReqDto queryDto = new CsOrgCustomerRelationPageReqDto();
        queryDto.setCustomerId(customerId);
        queryDto.setShopIdList((List)com.google.common.collect.Lists.newArrayList((Object[])new Long[]{shopId}));
        List csOrgCustomerRelationDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryTobCustomerRelationList(queryDto));
        DgCustomerRespDto dgCustomerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApiProxy.queryById(customerId));
        String customerGroup = "";
        if (null != dgCustomerRespDto) {
            customerGroup = dgCustomerRespDto.getCustomerGroupId() == null ? "" : String.valueOf(dgCustomerRespDto.getCustomerGroupId());
        }
        String customerType = "";
        LinkedList<String> customerRegions = new LinkedList<String>();
        if (ObjectUtil.isEmpty((Object)csOrgCustomerRelationDtos)) {
            logger.info("\u5ba2\u6237\uff1a{}\u4e0e\u5e97\u94fa\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u4ea4\u6613\u5173\u7cfb\u3002\u6240\u4ee5\u9000\u8d27\u989d\u5ea6\u89c4\u5219\u53ea\u4f1a\u547d\u4e2d\u6307\u5b9a\u5ba2\u6237\u7684", (Object)customerCode, (Object)shopId);
        } else {
            customerType = ((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getCustomerTypeId() == null ? "" : String.valueOf(((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getCustomerTypeId());
            String areaCode = ((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getAreaCode() == null ? "" : ((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getAreaCode();
            customerRegions.addAll(this.customerAreaQueryApiProxy.queryAllParentList(areaCode));
            if (((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getAreaId() != null) {
                customerRegions.add(String.valueOf(((CsOrgCustomerRelationDto)csOrgCustomerRelationDtos.get(0)).getAreaId()));
            }
        }
        MatchItemReqDto reqDto = new MatchItemReqDto();
        reqDto.setCustomerCode(customerCode);
        reqDto.setCustomerGroup(customerGroup);
        reqDto.setCustomerType(customerType);
        reqDto.setCustomerRegion(customerRegions);
        reqDto.setShopId(shopCode);
        return reqDto;
    }

    @Override
    public MatchItemReqDto matchItem(MatchItemReqDto reqDto) {
        block25: {
            AfterSaleItemRuleItemDto afterSaleItemRuleItemDto;
            block26: {
                Set<Long> ruleIds;
                if (logger.isInfoEnabled()) {
                    logger.info("\u5339\u914d\u552e\u540e\u5546\u54c1\u89c4\u5219\uff0c\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)reqDto));
                }
                if (ObjectUtil.isEmpty(ruleIds = this.matchCustomerRule(reqDto.getCustomerCode(), reqDto.getCustomerType(), reqDto.getCustomerGroup(), reqDto.getCustomerRegion()))) {
                    return reqDto;
                }
                List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterSaleRuleDomain)this.domain).filter().eq((Object)"shop_code", (Object)reqDto.getShopId())).in((Object)"id", ruleIds)).eq((Object)"rule_status", (Object)1)).orderByDesc((Object)"create_time")).list();
                if (ObjectUtil.isEmpty((Object)list)) {
                    return reqDto;
                }
                DgAfterSaleRuleEo dgAfterSaleRuleEo = (DgAfterSaleRuleEo)list.get(0);
                logger.debug("\u5339\u914d\u5230\u7684\u89c4\u5219\u662f\uff1a{}", (Object)dgAfterSaleRuleEo.getId());
                logger.info("\u5339\u914d\u5230\u7684\u89c4\u5219\u662f\uff1a{}", (Object)dgAfterSaleRuleEo.getId());
                AfterSaleItemRuleReqDto afterSaleItemRuleReqDto = this.detailItemRule(dgAfterSaleRuleEo.getId());
                afterSaleItemRuleItemDto = afterSaleItemRuleReqDto.getAfterSaleItemRuleItemDto();
                boolean matchOrderType = false;
                reqDto.setOrderReturnableFlag(Boolean.valueOf(true));
                AfterSaleItemRuleOrderRuleDto afterSaleItemRuleOrderRuleDto = afterSaleItemRuleReqDto.getAfterSaleItemRuleOrderRuleDto();
                if ("ALL".equals(afterSaleItemRuleOrderRuleDto.getOrderRule())) {
                    matchOrderType = true;
                } else {
                    for (SimpleDto simpleDto : afterSaleItemRuleOrderRuleDto.getOrderInclude()) {
                        if (!simpleDto.getId().equals(reqDto.getOrderType())) continue;
                        matchOrderType = false;
                        reqDto.setOrderReturnableFlag(Boolean.valueOf(false));
                        break;
                    }
                }
                if (!matchOrderType) {
                    return reqDto;
                }
                AfterSaleItemRuleAfterSaleRuleDto afterSaleItemRuleAfterSaleTypeRuleDto = afterSaleItemRuleReqDto.getAfterSaleItemRuleAfterSaleRuleDto();
                boolean matchAfterOrderReturnBizType = false;
                if (ObjectUtil.isNotEmpty((Object)afterSaleItemRuleAfterSaleTypeRuleDto.getOrderRule())) {
                    for (SimpleDto simpleDto : afterSaleItemRuleAfterSaleTypeRuleDto.getReturnBizTypeInclude()) {
                        if (!simpleDto.getId().equals(String.valueOf(reqDto.getReturnBizType()))) continue;
                        matchAfterOrderReturnBizType = true;
                        break;
                    }
                }
                if (!matchAfterOrderReturnBizType) {
                    return reqDto;
                }
                if (!CollectionUtils.isNotEmpty((Collection)reqDto.getItems())) break block25;
                if (!"SELECT".equals(afterSaleItemRuleItemDto.getItemRule())) break block26;
                for (SimpleDto itemId : afterSaleItemRuleItemDto.getItemIds()) {
                    for (OrderItemDto item : reqDto.getItems()) {
                        if (!item.getSkuCode().equals(itemId.getId())) continue;
                        item.setNonRefundable(true);
                        item.setMessage("\u5df2\u914d\u7f6e\u4e3a\u4e0d\u53ef\u9000\u5546\u54c1");
                    }
                }
                break block25;
            }
            if (!"RANGE".equals(afterSaleItemRuleItemDto.getItemRule())) break block25;
            for (OrderItemDto item : reqDto.getItems()) {
                boolean matchBrand = false;
                boolean matchCategory = false;
                boolean matchTag = false;
                if (!ObjectUtil.isEmpty((Object)afterSaleItemRuleItemDto.getExcludeItemIds())) {
                    boolean breakE = false;
                    for (SimpleDto excludeItemId : afterSaleItemRuleItemDto.getExcludeItemIds()) {
                        if (!excludeItemId.getId().equals(item.getSkuCode())) continue;
                        breakE = true;
                        break;
                    }
                    if (breakE) continue;
                }
                if (ObjectUtil.isEmpty((Object)afterSaleItemRuleItemDto.getItemBrands())) {
                    matchBrand = true;
                } else {
                    for (SimpleDto itemBrand : afterSaleItemRuleItemDto.getItemBrands()) {
                        if (!itemBrand.getId().equals(item.getBrand())) continue;
                        matchBrand = true;
                        break;
                    }
                }
                if (ObjectUtil.isEmpty((Object)afterSaleItemRuleItemDto.getItemCategories())) {
                    matchCategory = true;
                } else {
                    block7: for (SimpleDto itemCategory : afterSaleItemRuleItemDto.getItemCategories()) {
                        for (String s : item.getCategoryId()) {
                            if (!itemCategory.getId().equals(s)) continue;
                            matchCategory = true;
                            continue block7;
                        }
                    }
                }
                if (ObjectUtil.isEmpty((Object)afterSaleItemRuleItemDto.getItemTags())) {
                    matchTag = true;
                } else {
                    for (SimpleDto itemBrand : afterSaleItemRuleItemDto.getItemTags()) {
                        if (!ObjectUtil.isNotEmpty((Object)item.getTags()) || !item.getTags().contains(itemBrand.getId())) continue;
                        matchTag = true;
                        break;
                    }
                }
                if (!matchBrand || !matchCategory || !matchTag) continue;
                item.setNonRefundable(true);
                item.setMessage("\u5df2\u914d\u7f6e\u4e3a\u4e0d\u53ef\u9000\u5546\u54c1");
            }
        }
        return reqDto;
    }

    protected Set<Long> matchCustomerRule(String customerCode, String customerType, String customerGroup, List<String> customerRegion) {
        List list = ((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)"CUSTOMER_RULE_ALL")).select(new String[]{"rule_id"}).list();
        List list1 = ((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)("CUSTOMER_RULE_INCLUDE_" + customerCode))).select(new String[]{"rule_id"}).list();
        List list2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)("CUSTOMER_RULE_TYPE_" + customerType))).or()).eq((Object)"suit_match_code", (Object)"CUSTOMER_RULE_TYPE_ALL")).select(new String[]{"rule_id"}).list();
        ExtQueryChainWrapper filter = this.dgAfterSaleRulesSuitDomain.filter();
        boolean matchRegion = false;
        if (ObjectUtil.isNotEmpty(customerRegion)) {
            LinkedList<String> match = new LinkedList<String>();
            for (String s : customerRegion) {
                match.add("CUSTOMER_RULE_REGION_" + s);
            }
            filter.in((Object)"suit_match_code", match);
            matchRegion = true;
        }
        if (matchRegion) {
            ((ExtQueryChainWrapper)filter.or()).eq((Object)"suit_match_code", (Object)"CUSTOMER_RULE_REGION_ALL");
        } else {
            filter.eq((Object)"suit_match_code", (Object)"CUSTOMER_RULE_REGION_ALL");
        }
        List list3 = filter.select(new String[]{"rule_id"}).list();
        List list4 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)("CUSTOMER_RULE_GROUP_" + customerGroup))).or()).eq((Object)"suit_match_code", (Object)"CUSTOMER_RULE_GROUP_ALL")).select(new String[]{"rule_id"}).list();
        List list5 = ((ExtQueryChainWrapper)this.dgAfterSaleRulesSuitDomain.filter().eq((Object)"suit_match_code", (Object)("CUSTOMER_RULE_EXCLUDE_" + customerCode))).select(new String[]{"rule_id"}).list();
        List range = ListUtils.intersection((List)ListUtils.intersection(list2.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList()), list3.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList())), list4.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList()));
        List exclude = list5.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList());
        range.removeAll(exclude);
        list.addAll(list1);
        List result = list.stream().map(DgAfterSaleRulesSuitEo::getRuleId).collect(Collectors.toList());
        result.addAll(range);
        return new HashSet<Long>(result);
    }

    private void checkAfterSaleRule(DgAfterSaleRuleReqDto dto) {
        AssertUtils.notEmpty((String)dto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getAfterSaleRulesItemDtos(), (String)"\u9000\u8d27\u89c4\u5219\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
        this.afterSaleRulesItemService.checkAfterSaleRulesItem(dto.getAfterSaleRulesItemDtos());
    }
}

