/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.constants.AdjustmentBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.SameModelSkuRespDto;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.WmsReturnWarehouseTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterNoSourceReturnFailReasonEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterNoSourceReturnMatchSourceEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterNoSourceReturnMatchStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgNoSourceReturnRecordConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemSnRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnShippingSnDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgNoSourceReturnRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgNoSourceReturnRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordMatchDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgNoSourceReturnRecordRemarkModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyReturnNoSourceMatchRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemSnRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderReturnShippingSnEo;
import com.yunxi.dg.base.center.trade.eo.DgNoSourceReturnRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgNoSourceReturnRecordService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyReturnNoSourceMatchRuleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.vo.NoSourceReturnRecordMatchSuccessDto;
import com.yunxi.dg.base.center.user.dto.dto.UserReqDto;
import com.yunxi.dg.base.center.user.proxy.query.IBocUserQueryApiProxy;
import com.yunxi.dg.base.center.wh.wms.api.IWmsReturnApi;
import com.yunxi.dg.base.center.wh.wms.dto.WmsCancelReturnApplyRequestDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import springfox.documentation.oas.mappers.SecuritySchemeMapper;

@Service
public class DgNoSourceReturnRecordServiceImpl
extends BaseServiceImpl<DgNoSourceReturnRecordDto, DgNoSourceReturnRecordEo, IDgNoSourceReturnRecordDomain>
implements IDgNoSourceReturnRecordService {
    private static final Logger log = LoggerFactory.getLogger(DgNoSourceReturnRecordServiceImpl.class);
    private final SecuritySchemeMapper securitySchemeMapper;
    private static final List<String> afsOrderStatus = Arrays.asList(DgAfterSaleOrderStatusEnum.CANCEL.getCode(), DgAfterSaleOrderStatusEnum.CLOSE.getCode(), DgAfterSaleOrderStatusEnum.ABOLISH.getCode(), DgAfterSaleOrderStatusEnum.FINISH.getCode(), DgAfterSaleOrderStatusEnum.IN_WAREHOUSE.getCode());
    private static final List<String> afsOrderType = Arrays.asList(DgCisAfterSaleBizModelEnum.THTK.getCode(), DgCisAfterSaleBizModelEnum.HH.getCode());
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgAfterSaleOrderItemSnRecordDomain afterSaleOrderItemSnRecordDomain;
    @Resource
    private IDgAfterSaleOrderReturnShippingSnDomain dgAfterSaleOrderReturnShippingSnDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain afterSaleOrderLogisticsWarehouseDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IDgStrategyReturnNoSourceMatchRuleService strategyReturnNoSourceMatchRuleService;
    @Resource
    private IInOtherStorageOrderApiProxy inOtherStorageOrderApiProxy;
    @Resource
    private DgNoSourceReturnRecordServiceImpl xthis;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;
    @Resource
    private ILockService lockService;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IBocUserQueryApiProxy bocUserQueryApiProxy;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IWmsReturnApi wmsReturnApi;
    public static final List<String> FAILED_MATCH_STATUS = Lists.newArrayList((Object[])new String[]{DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode(), DgAfterNoSourceReturnMatchStatusEnum.WAIT_MATCH.getCode()});

    public DgNoSourceReturnRecordServiceImpl(IDgNoSourceReturnRecordDomain domain, SecuritySchemeMapper securitySchemeMapper) {
        super((IBaseDomain)domain);
        this.securitySchemeMapper = securitySchemeMapper;
    }

    public IConverter<DgNoSourceReturnRecordDto, DgNoSourceReturnRecordEo> converter() {
        return DgNoSourceReturnRecordConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(DgNoSourceReturnRecordReqDto dto) {
        AssertUtils.isTrue((dto.getItemNum().compareTo(BigDecimal.ONE) == 0 ? 1 : 0) != 0, (String)"\u6570\u91cf\u5fc5\u987b\u62c6\u62101");
        DgNoSourceReturnRecordEo queryEo = new DgNoSourceReturnRecordEo();
        queryEo.setShippingNo(dto.getShippingNo());
        queryEo.setSkuCode(dto.getSkuCode());
        if (StringUtils.isNotBlank((CharSequence)dto.getSnCode())) {
            queryEo.setSnCode(dto.getSnCode());
        }
        List records = ((IDgNoSourceReturnRecordDomain)this.domain).selectList((BaseEo)queryEo);
        List abolishedRecords = records.stream().filter(s -> DgAfterNoSourceReturnMatchStatusEnum.ABOLISH.getCode().equals(s.getMatchStatus())).collect(Collectors.toList());
        if (records.size() != abolishedRecords.size()) {
            throw new BizException(String.format("\u8be5\u8fd0\u5355\u53f7\uff1a%s,skuCode\uff1a%s,snCode\uff1a%s,\u5df2\u5b58\u5728", dto.getShippingNo(), dto.getSkuCode(), dto.getSnCode()));
        }
        if (!abolishedRecords.isEmpty()) {
            List ids = abolishedRecords.stream().map(BaseEo::getId).collect(Collectors.toList());
            log.info("\u51c6\u5907\u903b\u8f91\u5220\u9664\u4ee5\u4e0b\u5df2\u4f5c\u5e9f\u7684\u9000\u8d27\u5339\u914d\u8bb0\u5f55\uff1a{}", ids);
            ((IDgNoSourceReturnRecordDomain)this.domain).logicDeleteByIds(ids);
        }
        int count = 0;
        if (StringUtils.isNotBlank((CharSequence)dto.getAfterOrderNo())) {
            DgNoSourceReturnRecordEo queryAfterOrderNoEo = new DgNoSourceReturnRecordEo();
            queryAfterOrderNoEo.setExternalAfterOrderNo(dto.getAfterOrderNo());
            count = ((IDgNoSourceReturnRecordDomain)this.domain).count((BaseEo)queryEo);
            AssertUtils.isFalse((count > 0 ? 1 : 0) != 0, (String)String.format("\u8be5wms\u552e\u540e\u5355\u53f7\uff1a%s,\u5df2\u5b58\u5728", dto.getAfterOrderNo()));
            dto.setExternalAfterOrderNo(dto.getAfterOrderNo());
            dto.setAfterOrderNo(null);
        }
        DgNoSourceReturnRecordEo eo = new DgNoSourceReturnRecordEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        if (StringUtils.isNotBlank((CharSequence)dto.getExternalAfterOrderNo())) {
            eo.setWmsReturnOrderNo(dto.getExternalAfterOrderNo());
        }
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        ArrayList<String> physicsWarehouseCodes = new ArrayList<String>();
        physicsWarehouseCodes.add(eo.getPhysicsSigningWarehouseCode());
        logicWarehousePageReqDto.setPhysicsWarehouseCodeList(physicsWarehouseCodes);
        log.info("\u67e5\u8be2\u7269\u7406\u4ed3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(physicsWarehouseCodes));
        List physicsWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryList(logicWarehousePageReqDto));
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)physicsWarehouseRespDtos), (String)"\u5e93\u5b58\u4e2d\u5fc3\u7269\u7406\u4ed3\u4fe1\u606f\u672a\u67e5\u5230");
        eo.setPhysicsSigningWarehouseCode(((LogicalWarehouseRespDto)physicsWarehouseRespDtos.get(0)).getPhysicsWarehouseCode());
        eo.setPhysicsSigningWarehouseName(((LogicalWarehouseRespDto)physicsWarehouseRespDtos.get(0)).getPhysicsWarehouseName());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes((List)ListUtil.toList((Object[])new String[]{dto.getSkuCode()}));
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)itemRespDtos)) {
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)itemRespDtos.get(0);
            eo.setSpecification(dgItemSkuDetailRespDto.getItemName());
            eo.setSkuId(dgItemSkuDetailRespDto.getId());
            if (StrUtil.isBlank((CharSequence)dto.getSkuName())) {
                eo.setSkuName(dgItemSkuDetailRespDto.getSkuName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProvinceName())) {
            eo.setReturnProvince(dto.getProvinceName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getShopCode())) {
            DgShopQueryReqDto dgShopQueryReqDto = new DgShopQueryReqDto();
            dgShopQueryReqDto.setPageSize(Integer.valueOf(1));
            dgShopQueryReqDto.setStoreCode(dto.getShopCode());
            PageInfo dgShopRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.queryPageShop(dgShopQueryReqDto));
            List list = dgShopRespDtoPageInfo.getList();
            log.info("\u67e5\u8be2\u5e97\u94fa\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)list));
            if (CollUtil.isNotEmpty((Collection)list)) {
                DgShopRespDto dgShopRespDto = (DgShopRespDto)list.get(0);
                eo.setShopName(dgShopRespDto.getStoreName());
                eo.setBusinessPlatformName(dgShopRespDto.getBusinessPlatformName());
                eo.setBusinessPlatformId(dgShopRespDto.getBusinessPlatformId());
                eo.setSaleAreaName(dgShopRespDto.getSaleAreaName());
                eo.setSaleAreaCode(dgShopRespDto.getSaleAreaCode());
                eo.setCustomerName(dgShopRespDto.getCustomerName());
                eo.setCustomerCode(dgShopRespDto.getCustomerCode());
            }
        }
        eo.setReturnRecordSerialNo(this.noGreateUtil.generateNoSourceReturnRecordNo());
        eo.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.WAIT_MATCH.getCode());
        eo.setMatchRecordSource(DgAfterNoSourceReturnMatchSourceEnum.WAREHOUSE_SCAN_RECORD.getCode());
        ((IDgNoSourceReturnRecordDomain)this.domain).insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void batchUpdate(DgNoSourceReturnRecordDto dto) {
        if (CollectionUtil.isNotEmpty((Collection)dto.getIds())) {
            List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).selectByIds(dto.getIds());
            if (CollectionUtil.isEmpty((Collection)dgNoSourceReturnRecordEos)) {
                return;
            }
            for (DgNoSourceReturnRecordEo dgNoSourceReturnRecordEo : dgNoSourceReturnRecordEos) {
                AssertUtils.isFalse((boolean)dgNoSourceReturnRecordEo.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode()), (String)("\u9000\u8d27\u5355\u53f7" + dgNoSourceReturnRecordEo.getExternalAfterOrderNo() + "\u5df2\u5339\u914d\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91"));
            }
            dto.getIds().forEach(id -> {
                DgNoSourceReturnRecordEo eo = new DgNoSourceReturnRecordEo();
                eo.setId(id);
                if (StringUtils.isNotBlank((CharSequence)dto.getSigningWarehouseCode())) {
                    eo.setSigningWarehouseCode(dto.getSigningWarehouseCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getSigningWarehouseName())) {
                    eo.setSigningWarehouseName(dto.getSigningWarehouseName());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getZszfLogicWarehouseCode())) {
                    eo.setZszfLogicWarehouseCode(dto.getZszfLogicWarehouseCode());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getZszfLogicWarehouseName())) {
                    eo.setZszfLogicWarehouseName(dto.getZszfLogicWarehouseName());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getPlatformOrderNo())) {
                    eo.setPlatformOrderNo(dto.getPlatformOrderNo());
                }
                ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)eo);
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Boolean match(DgNoSourceReturnRecordDto noSourceReturnRecordDto) {
        DgAfterSaleOrderRespDto afterSaleOrderRespDto;
        block17: {
            block15: {
                block14: {
                    block16: {
                        log.info("\u5f53\u524d\u8bb0\u5f55id\uff1a{} ======>>>>>sn\u7801\uff1a{}", (Object)noSourceReturnRecordDto.getId(), (Object)noSourceReturnRecordDto.getSnCode());
                        afterSaleOrderRespDto = null;
                        if (!StringUtils.isNotBlank((CharSequence)noSourceReturnRecordDto.getSnCode())) break block15;
                        List<DgAfterSaleOrderItemSnRecordEo> afterSaleOrderSnRecordEos = this.getAfterSaleOrderItemSnRecordEos(noSourceReturnRecordDto.getSnCode());
                        if (!CollectionUtils.isNotEmpty(afterSaleOrderSnRecordEos)) break block14;
                        List<Long> afsOrderIdList = afterSaleOrderSnRecordEos.stream().map(DgAfterSaleOrderItemSnRecordEo::getAfterSaleOrderId).collect(Collectors.toList());
                        log.info("sn\u7801\u5bf9\u5e94\u7684\u552e\u540e\u5355id\u96c6\u5408\uff1a{}", afsOrderIdList);
                        List<DgAfterSaleOrderEo> dgEffectAfsOrderEoList = this.getEffectAfsOrderEoList(afsOrderIdList);
                        if (!CollectionUtil.isNotEmpty(dgEffectAfsOrderEoList)) break block16;
                        List afIds = dgEffectAfsOrderEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
                        List afsOrderItemIdList = afterSaleOrderSnRecordEos.stream().filter(a -> afIds.contains(a.getAfterSaleOrderId())).map(DgAfterSaleOrderItemSnRecordEo::getAfterSaleOrderItemId).collect(Collectors.toList());
                        List effectAfsOrderItemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemDomain.filter().select(new String[]{"id", "after_sale_order_id"}).in((Object)"id", afsOrderItemIdList)).in((Object)"after_sale_order_id", afIds)).eq((Object)"dr", (Object)0)).list();
                        if (CollUtil.isEmpty((Collection)effectAfsOrderItemEoList)) {
                            this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                            break block14;
                        } else {
                            Map<Long, List<DgAfterSaleOrderItemEo>> afsIdListMap = effectAfsOrderItemEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
                            if (afsIdListMap.size() > 1) {
                                this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_NUMBER_EXCEPTION, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_NUMBER_EXCEPTION);
                                break block14;
                            } else {
                                List finalAfsOrderEos = dgEffectAfsOrderEoList.stream().filter(a -> afsIdListMap.containsKey(a.getId())).collect(Collectors.toList());
                                afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
                                CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, finalAfsOrderEos.get(0), (String[])new String[0]);
                            }
                        }
                        break block14;
                    }
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                }
                if (afterSaleOrderRespDto == null) {
                    afterSaleOrderRespDto = this.getDgAfterSaleOrderRespDto(noSourceReturnRecordDto);
                }
                noSourceReturnRecordDto.setScanCodeCheckoutStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)noSourceReturnRecordDto.getSnCode()) ? 1 : 0));
                break block17;
            }
            afterSaleOrderRespDto = this.getDgAfterSaleOrderRespDto(noSourceReturnRecordDto);
        }
        if (afterSaleOrderRespDto == null) {
            if (noSourceReturnRecordDto.getDistributionFailType() != null) return false;
            this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
            return false;
        }
        noSourceReturnRecordDto.setAfterOrderId(afterSaleOrderRespDto.getId());
        noSourceReturnRecordDto.setAfterOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        noSourceReturnRecordDto.setOrigAfterOrderFlag(afterSaleOrderRespDto.getSaleOrderId() == null ? YesOrNoEnum.NO.getType() : YesOrNoEnum.YES.getType());
        if (!afsOrderStatus.contains(afterSaleOrderRespDto.getStatus())) {
            noSourceReturnRecordDto.setPlatformOrderNo(afterSaleOrderRespDto.getPlatformOrderNo());
            noSourceReturnRecordDto.setShopCode(afterSaleOrderRespDto.getShopCode());
            noSourceReturnRecordDto.setShopName(afterSaleOrderRespDto.getShopName());
            noSourceReturnRecordDto.setAfterSaleOrderType(afterSaleOrderRespDto.getAfterSaleOrderType());
            noSourceReturnRecordDto.setReturnAttribute(Objects.isNull(afterSaleOrderRespDto.getReturnType()) ? "" : String.valueOf(afterSaleOrderRespDto.getReturnType()));
            DgShopRespDto dgShopRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.getShopDetailById(afterSaleOrderRespDto.getShopId()));
            noSourceReturnRecordDto.setSaleCompanyName(dgShopRespDto.getSaleCompanyName());
            noSourceReturnRecordDto.setBusinessPlatformName(dgShopRespDto.getBusinessPlatformName());
            noSourceReturnRecordDto.setSaleAreaName(dgShopRespDto.getSaleAreaName());
            noSourceReturnRecordDto.setCustomerCode(afterSaleOrderRespDto.getCustomerCode());
            noSourceReturnRecordDto.setCustomerName(afterSaleOrderRespDto.getCustomerName());
            noSourceReturnRecordDto.setShopName(dgShopRespDto.getStoreName());
            noSourceReturnRecordDto.setBusinessPlatformName(dgShopRespDto.getBusinessPlatformName());
            noSourceReturnRecordDto.setBusinessPlatformId(dgShopRespDto.getBusinessPlatformId());
            noSourceReturnRecordDto.setSaleAreaCode(dgShopRespDto.getSaleAreaCode());
            DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule = this.strategyReturnNoSourceMatchRuleService.get();
            if (null != noSourceMatchRule.getWmsReturnWarehouseType() && noSourceMatchRule.getWmsReturnWarehouseType().equals(WmsReturnWarehouseTypeEnum.PHYSICS.getType())) {
                String physicsWarehouseCode = noSourceReturnRecordDto.getPhysicsSigningWarehouseCode();
                log.info("\u83b7\u53d6\u7b7e\u6536\u7269\u7406\u4ed3:{}", (Object)physicsWarehouseCode);
                log.info("\u83b7\u53d6\u552e\u540e\u5355\u7684\u9000\u8d27\u903b\u8f91\u4ed3");
                DgAfterSaleOrderLogisticsWarehouseEo afterSaleOrderLogisticsWarehouseEo = this.afterSaleOrderLogisticsWarehouseDomain.selectByAfterSaleOrderId(afterSaleOrderRespDto.getId());
                if (null == afterSaleOrderLogisticsWarehouseEo) {
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.RETURN_LOGICWAREHOUSE_NOT_EXIST, DgAfterNoSourceReturnFailReasonEnum.RETURN_LOGICWAREHOUSE_NOT_EXIST);
                    log.info("\u552e\u540e\u5355\u6536\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
                    return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                }
                log.info("\u6839\u636e\u903b\u8f91\u4ed3\u67e5\u8be2\u7269\u7406\u4ed3");
                noSourceReturnRecordDto.setAfterWarehouseCode(afterSaleOrderLogisticsWarehouseEo.getReturnWarehouseCode());
                noSourceReturnRecordDto.setAfterWarehouseName(afterSaleOrderLogisticsWarehouseEo.getReturnWarehouseName());
                LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
                ArrayList<String> logicWarehouseCode = new ArrayList<String>();
                logicWarehouseCode.add(afterSaleOrderLogisticsWarehouseEo.getReturnWarehouseCode());
                logicWarehousePageReqDto.setWarehouseCodeList(logicWarehouseCode);
                log.info("\u903b\u8f91\u4ed3\u67e5\u8be2\u7269\u7406\u4ed3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehousePageReqDto));
                List physicsWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryList(logicWarehousePageReqDto));
                log.info("\u903b\u8f91\u4ed3\u67e5\u8be2\u7269\u7406\u4ed3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)physicsWarehouseRespDtos));
                if (!CollectionUtil.isNotEmpty((Collection)physicsWarehouseRespDtos)) {
                    log.info("\u6839\u636e\u903b\u8f91\u4ed3\u67e5\u8be2\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.PHYSICSWAREHOUSE_NOT_EXIST, DgAfterNoSourceReturnFailReasonEnum.PHYSICSWAREHOUSE_NOT_EXIST);
                    return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                }
                List physicsWarehouseCodes = physicsWarehouseRespDtos.stream().map(LogicalWarehouseRespDto::getPhysicsWarehouseCode).collect(Collectors.toList());
                if (physicsWarehouseCodes.contains(physicsWarehouseCode)) {
                    noSourceReturnRecordDto.setSigningWarehouseCode(afterSaleOrderLogisticsWarehouseEo.getReturnWarehouseCode());
                    noSourceReturnRecordDto.setSigningWarehouseName(afterSaleOrderLogisticsWarehouseEo.getReturnWarehouseName());
                    noSourceReturnRecordDto.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                    noSourceReturnRecordDto.setDistributionFailType("");
                    noSourceReturnRecordDto.setDistributionFailReason("");
                    return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                }
                this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.NOT_WAREHOUSE_MATCHED, DgAfterNoSourceReturnFailReasonEnum.NOT_WAREHOUSE_MATCHED);
                return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
            }
            this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.NOT_WAREHOUSE_MATCHED, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_STATUS_EXCEPTION);
            return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
        }
        if (afsOrderStatus.contains(afterSaleOrderRespDto.getStatus())) {
            this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_STATUS_EXCEPTION, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_STATUS_EXCEPTION);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)noSourceReturnRecordDto.getSnCode()) && noSourceReturnRecordDto.getScanCodeCheckoutStatus() == 0) {
            DgPerformOrderItemLineEo queryItemLineEo = new DgPerformOrderItemLineEo();
            queryItemLineEo.setSnCode(noSourceReturnRecordDto.getSnCode());
            List performOrderItemLineEos = this.performOrderItemLineDomain.selectList((BaseEo)queryItemLineEo);
            if (CollUtil.isNotEmpty((Collection)performOrderItemLineEos)) {
                DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(((DgPerformOrderItemLineEo)performOrderItemLineEos.get(0)).getOrderId());
                noSourceReturnRecordDto.setScanCodeCheckoutStatus(Integer.valueOf(1));
                noSourceReturnRecordDto.setShopCode(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
                noSourceReturnRecordDto.setShopName(performOrderRespDto.getPerformOrderSnapshotDto().getShopName());
                noSourceReturnRecordDto.setCustomerCode(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
                noSourceReturnRecordDto.setCustomerName(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
                noSourceReturnRecordDto.setPlatformOrderNo(performOrderRespDto.getPlatformOrderNo());
                return noSourceReturnRecordDto.getMatchStatus().equals(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
            }
            log.info("sn\u7801\u5173\u8054\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6d41\u7a0b\u7ed3\u675f");
            return false;
        }
        log.info("\u6d41\u7a0b\u7ed3\u675f");
        return false;
    }

    private List<DgAfterSaleOrderEo> getEffectAfsOrderEoList(List<Long> afsOrderIdList) {
        List dgAfterSaleOrderEoList = ((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().in((Object)"id", afsOrderIdList)).list();
        List<DgAfterSaleOrderEo> dgEffectAfsOrderEoList = dgAfterSaleOrderEoList.stream().filter(a -> !afsOrderStatus.contains(a.getStatus()) && afsOrderType.contains(a.getAfterSaleOrderType())).collect(Collectors.toList());
        return dgEffectAfsOrderEoList;
    }

    private DgAfterSaleOrderRespDto getDgAfterSaleOrderRespDto(DgNoSourceReturnRecordDto noSourceReturnRecordDto) {
        DgAfterSaleOrderRespDto afterSaleOrderRespDto;
        if (StringUtils.isBlank((CharSequence)noSourceReturnRecordDto.getShippingNo())) {
            log.error("\u8fd0\u5355\u53f7\u4e0d\u5b58\u5728");
            return null;
        }
        List<DgAfterSaleOrderLogisticsWarehouseEo> afterSaleOrderLogisticsWarehouseEos = this.getAfterSaleOrderLogisticsWarehouseEos(noSourceReturnRecordDto.getShippingNo());
        if (CollUtil.isNotEmpty(afterSaleOrderLogisticsWarehouseEos)) {
            List<Long> afsOrderIds = afterSaleOrderLogisticsWarehouseEos.stream().map(DgAfterSaleOrderLogisticsWarehouseEo::getAfterSaleOrderId).collect(Collectors.toList());
            afterSaleOrderRespDto = this.getDgAfterSaleOrderRespDto(noSourceReturnRecordDto, afsOrderIds);
        } else {
            DgAfterSaleOrderReturnShippingSnEo shippingSnEo = new DgAfterSaleOrderReturnShippingSnEo();
            shippingSnEo.setReturnShippingSn(noSourceReturnRecordDto.getShippingNo());
            List shippingSnEos = this.dgAfterSaleOrderReturnShippingSnDomain.selectList((BaseEo)shippingSnEo);
            if (CollectionUtil.isEmpty((Collection)shippingSnEos)) {
                this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                return null;
            }
            List<Long> afsOrderIds = shippingSnEos.stream().map(DgAfterSaleOrderReturnShippingSnEo::getAfterSaleOrderId).collect(Collectors.toList());
            afterSaleOrderRespDto = this.getDgAfterSaleOrderRespDto(noSourceReturnRecordDto, afsOrderIds);
        }
        return afterSaleOrderRespDto;
    }

    private DgAfterSaleOrderRespDto getDgAfterSaleOrderRespDto(DgNoSourceReturnRecordDto noSourceReturnRecordDto, List<Long> afsOrderIds) {
        List effectAfsOrderItemEoList;
        log.info("\u8fd0\u5355\u53f7\uff1a{} ===>>\u5bf9\u5e94\u7684\u552e\u540e\u5355id\u96c6\u5408\uff1a{}", (Object)noSourceReturnRecordDto.getShippingNo(), afsOrderIds);
        List<DgAfterSaleOrderEo> effectAfsOrderEos = this.getEffectAfsOrderEoList(afsOrderIds);
        if (CollectionUtil.isNotEmpty(effectAfsOrderEos)) {
            List afIds = effectAfsOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            effectAfsOrderItemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemDomain.filter().select(new String[]{"id", "after_sale_order_id"}).eq((Object)"sku_code", (Object)noSourceReturnRecordDto.getSkuCode())).in((Object)"after_sale_order_id", afIds)).list();
            if (CollUtil.isEmpty((Collection)effectAfsOrderItemEoList)) {
                List orderIds = effectAfsOrderEos.stream().filter(p -> Objects.equals(p.getRelateToPlatformOrder(), 0)).map(DgAfterSaleOrderEo::getSaleOrderId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orderIds)) {
                    log.info("\u552e\u540e\u8ba2\u5355\u4e0d\u662f\u6709\u539f\u5355\u4e0d\u9700\u5339\u914d");
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                    return null;
                }
                List performOrderRespDtos = this.omsOrderInfoQueryDomain.queryDtoByIdsNoReleationInfo(orderIds);
                if (CollectionUtils.isEmpty((Collection)performOrderRespDtos)) {
                    log.info("\u65e0\u6cd5\u5173\u8054\u9500\u552e\u8ba2\u5355\u5339\u914d\u5931\u8d25,orderIds:{}", orderIds);
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                    return null;
                }
                List bizTypes = performOrderRespDtos.stream().map(DgPerformOrderInfoDto::getBizType).collect(Collectors.toList());
                if (!bizTypes.contains("jd_delivery_warehouse") && !bizTypes.contains("cainiao_delivery_warehouse")) {
                    log.info("\u9500\u552e\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b\u4e0d\u662f\u4eac\u4e1c\u4ed3\u6216\u83dc\u9e1f\u4ed3\u5339\u914d\u5931\u8d25,bizTypes:{}", bizTypes);
                    this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                    return null;
                }
                List afterSaleOrderItemEos = ((ExtQueryChainWrapper)this.afterSaleOrderItemDomain.filter().select(new String[]{"id", "after_sale_order_id", "sku_code"}).in((Object)"after_sale_order_id", afIds)).list();
                if (CollUtil.isNotEmpty((Collection)afterSaleOrderItemEos)) {
                    List skuCodes = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getSkuCode).collect(Collectors.toList());
                    RestResponse response = this.itemSkuDgQueryApi.querySameSpecModelSkus(skuCodes);
                    List sameModelSkus = (List)RestResponseHelper.extractData((RestResponse)response);
                    Map<String, SameModelSkuRespDto> sameModelSkuMap = Optional.ofNullable(sameModelSkus).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(SameModelSkuRespDto::getSkuCode, v -> v));
                    log.info("\u5904\u7406\u540c\u578b\u53f7\u4e0d\u540csku\u5339\u914d,skuCode:{},afterSkuCodes:{},afIds:{}", new Object[]{noSourceReturnRecordDto.getSkuCode(), skuCodes, afIds});
                    SameModelSkuRespDto sameModelSku = CollUtil.emptyIfNull((List)sameModelSkus).stream().filter(k -> k.getSkuCodes() != null && k.getSkuCodes().contains(noSourceReturnRecordDto.getSkuCode())).findFirst().orElse(null);
                    if (sameModelSku != null) {
                        log.info("\u627e\u5230\u540c\u578b\u53f7\u4e0d\u540csku\u4fe1\u606f,skuCode:{}, sameModel:{}, skuCodes:{}", new Object[]{noSourceReturnRecordDto.getSkuCode(), sameModelSku.getSameModel(), sameModelSku.getSkuCodes()});
                        noSourceReturnRecordDto.setSpecModelMatch(true);
                        noSourceReturnRecordDto.setAfterOrderItemSkuSpecification(sameModelSku.getSameModel());
                        noSourceReturnRecordDto.setSameModelSkuCodes(sameModelSku.getSkuCodes());
                        Map<Long, List<DgAfterSaleOrderItemEo>> afsIdListMap = afterSaleOrderItemEos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
                        DgAfterSaleOrderEo afterSaleOrderEo = effectAfsOrderEos.stream().filter(a -> afsIdListMap.containsKey(a.getId())).max(Comparator.comparing(BaseEo::getCreateTime)).get();
                        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
                        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)afterSaleOrderEo, (String[])new String[0]);
                        return afterSaleOrderRespDto;
                    }
                    return null;
                }
                this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER);
                return null;
            }
        } else {
            this.matchFailMsg(noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_STATUS_EXCEPTION, DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_STATUS_EXCEPTION);
            return null;
        }
        Map<Long, List<DgAfterSaleOrderItemEo>> afsIdListMap = effectAfsOrderItemEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
        DgAfterSaleOrderEo afterSaleOrderEo = effectAfsOrderEos.stream().filter(a -> afsIdListMap.containsKey(a.getId())).max(Comparator.comparing(BaseEo::getCreateTime)).get();
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)afterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    private void matchFailMsg(DgNoSourceReturnRecordDto noSourceReturnRecordDto, DgAfterNoSourceReturnFailReasonEnum afterOrderNotExist, DgAfterNoSourceReturnFailReasonEnum afterOrderNotExist2) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 2) {
            StackTraceElement caller = stackTrace[2];
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u5931\u8d25\u5165\u53e3 {}.{}:L{}", new Object[]{noSourceReturnRecordDto.getId(), afterOrderNotExist.getDesc(), caller.getClassName(), caller.getMethodName(), caller.getLineNumber()});
        } else if (stackTrace.length > 1) {
            StackTraceElement caller = stackTrace[1];
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u5931\u8d25\u5165\u53e3 {}.{}:L{}", new Object[]{noSourceReturnRecordDto.getId(), afterOrderNotExist.getDesc(), caller.getClassName(), caller.getMethodName(), caller.getLineNumber()});
        } else {
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u65e0\u5165\u53e3", (Object)noSourceReturnRecordDto.getId(), (Object)afterOrderNotExist.getDesc());
        }
        noSourceReturnRecordDto.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
        noSourceReturnRecordDto.setDistributionFailType(afterOrderNotExist.getCode());
        noSourceReturnRecordDto.setDistributionFailReason(afterOrderNotExist2.getDesc());
    }

    private void matchFailMsg(DgNoSourceReturnRecordEo noSourceReturnRecordEo, DgAfterNoSourceReturnFailReasonEnum afterOrderNotExist, DgAfterNoSourceReturnFailReasonEnum afterOrderNotExist2) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 2) {
            StackTraceElement caller = stackTrace[2];
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u5931\u8d25\u5165\u53e3 {}.{}:L{}", new Object[]{noSourceReturnRecordEo.getId(), afterOrderNotExist.getDesc(), caller.getClassName(), caller.getMethodName(), caller.getLineNumber()});
        } else if (stackTrace.length > 1) {
            StackTraceElement caller = stackTrace[1];
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u5931\u8d25\u5165\u53e3 {}.{}:L{}", new Object[]{noSourceReturnRecordEo.getId(), afterOrderNotExist.getDesc(), caller.getClassName(), caller.getMethodName(), caller.getLineNumber()});
        } else {
            log.info("{} \u5339\u914d\u5931\u8d25 \u539f\u56e0 {} \u65e0\u5165\u53e3", (Object)noSourceReturnRecordEo.getId(), (Object)afterOrderNotExist.getDesc());
        }
        noSourceReturnRecordEo.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
        noSourceReturnRecordEo.setDistributionFailType(afterOrderNotExist.getCode());
        noSourceReturnRecordEo.setDistributionFailReason(afterOrderNotExist2.getDesc());
    }

    private List<DgAfterSaleOrderItemSnRecordEo> getAfterSaleOrderItemSnRecordEos(String snCode) {
        List afterSaleOrderSnRecordEos = this.afterSaleOrderItemSnRecordDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAfterSaleOrderItemSnRecordEo.class).eq(BaseEo::getDr, (Object)0)).apply("FIND_IN_SET({0}, sn_code)", new Object[]{snCode}));
        return afterSaleOrderSnRecordEos;
    }

    private List<DgAfterSaleOrderLogisticsWarehouseEo> getAfterSaleOrderLogisticsWarehouseEos(String shippingNo) {
        List afterSaleOrderLogisticsWarehouseEos = this.afterSaleOrderLogisticsWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAfterSaleOrderLogisticsWarehouseEo.class).eq(BaseEo::getDr, (Object)0)).apply("FIND_IN_SET({0}, return_shipping_sn)", new Object[]{shippingNo}));
        return afterSaleOrderLogisticsWarehouseEos;
    }

    @Override
    public PageInfo<DgNoSourceReturnRecordDto> queryPage(DgNoSourceReturnRecordPageReqDto dto) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (StrUtil.isNotBlank((CharSequence)dto.getOrderNoKeyword())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(DgNoSourceReturnRecordEo::getReturnRecordSerialNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getClutteredOrderInNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getClutteredOrderOutNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getPlatformOrderNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getShippingNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getOrderNo, (Object)dto.getOrderNoKeyword())).or()).like(DgNoSourceReturnRecordEo::getAfterOrderNo, (Object)dto.getOrderNoKeyword()));
        }
        if (CollUtil.isNotEmpty((Collection)dto.getOrderNos())) {
            if (dto.getOrderNos().size() > 1) {
                queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(DgNoSourceReturnRecordEo::getReturnRecordSerialNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getClutteredOrderInNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getClutteredOrderOutNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getPlatformOrderNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getShippingNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getOrderNo, (Collection)dto.getOrderNos())).or()).in(DgNoSourceReturnRecordEo::getAfterOrderNo, (Collection)dto.getOrderNos()));
            } else {
                queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(DgNoSourceReturnRecordEo::getReturnRecordSerialNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getClutteredOrderInNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getClutteredOrderOutNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getPlatformOrderNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getShippingNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getOrderNo, dto.getOrderNos().get(0))).or()).like(DgNoSourceReturnRecordEo::getAfterOrderNo, dto.getOrderNos().get(0)));
            }
        }
        if (CollUtil.isNotEmpty((Collection)dto.getShopCodeList())) {
            if (dto.getShopCodeList().size() > 1) {
                queryWrapper.and(wrapper -> wrapper.in(DgNoSourceReturnRecordEo::getShopCode, (Collection)dto.getShopCodeList()));
            } else {
                queryWrapper.and(wrapper -> wrapper.like(DgNoSourceReturnRecordEo::getShopCode, dto.getShopCodeList().get(0)));
            }
        }
        if (CollUtil.isNotEmpty((Collection)dto.getMatchRecordSourceList())) {
            if (dto.getMatchRecordSourceList().size() > 1) {
                queryWrapper.and(wrapper -> wrapper.in(DgNoSourceReturnRecordEo::getMatchRecordSource, (Collection)dto.getMatchRecordSourceList()));
            } else {
                queryWrapper.and(wrapper -> wrapper.eq(DgNoSourceReturnRecordEo::getMatchRecordSource, dto.getMatchRecordSourceList().get(0)));
            }
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrUtil.isNotBlank((CharSequence)dto.getMatchStatus()), DgNoSourceReturnRecordEo::getMatchStatus, (Object)dto.getMatchStatus())).ge(dto.getMatchTimeStart() != null, DgNoSourceReturnRecordEo::getMatchTime, (Object)dto.getMatchTimeStart())).le(dto.getMatchTimeEnd() != null, DgNoSourceReturnRecordEo::getMatchTime, (Object)dto.getMatchTimeEnd())).ge(dto.getSigningTimeStart() != null, DgNoSourceReturnRecordEo::getSigningTime, (Object)dto.getSigningTimeStart())).le(dto.getSigningTimeEnd() != null, DgNoSourceReturnRecordEo::getSigningTime, (Object)dto.getSigningTimeEnd())).like(StrUtil.isNotBlank((CharSequence)dto.getSkuCode()), DgNoSourceReturnRecordEo::getSkuCode, (Object)dto.getSkuCode())).like(StrUtil.isNotBlank((CharSequence)dto.getSkuName()), DgNoSourceReturnRecordEo::getSkuName, (Object)dto.getSkuName())).like(StrUtil.isNotBlank((CharSequence)dto.getSnCode()), DgNoSourceReturnRecordEo::getSnCode, (Object)dto.getSnCode())).like(StrUtil.isNotBlank((CharSequence)dto.getShopName()), DgNoSourceReturnRecordEo::getShopName, (Object)dto.getShopName())).like(StrUtil.isNotBlank((CharSequence)dto.getRemark()), DgNoSourceReturnRecordEo::getRemark, (Object)dto.getRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getChargeOrderRemark()), DgNoSourceReturnRecordEo::getChargeOrderRemark, (Object)dto.getChargeOrderRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getReturnAndRepairRemark()), DgNoSourceReturnRecordEo::getReturnAndRepairRemark, (Object)dto.getReturnAndRepairRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getCustomerRemark()), DgNoSourceReturnRecordEo::getCustomerRemark, (Object)dto.getCustomerRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getScanRemark()), DgNoSourceReturnRecordEo::getScanRemark, (Object)dto.getScanRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getSpecification()), DgNoSourceReturnRecordEo::getSpecification, (Object)dto.getSpecification())).like(StrUtil.isNotBlank((CharSequence)dto.getPlatformRefundOrderSn()), DgNoSourceReturnRecordEo::getPlatformRefundOrderSn, (Object)dto.getPlatformRefundOrderSn())).eq(StrUtil.isNotBlank((CharSequence)dto.getShopCode()), DgNoSourceReturnRecordEo::getShopCode, (Object)dto.getShopCode())).in(CollectionUtils.isNotEmpty((Collection)dto.getShopCodeList()), DgNoSourceReturnRecordEo::getShopCode, (Collection)dto.getShopCodeList())).eq(StrUtil.isNotBlank((CharSequence)dto.getDistributionFailType()), DgNoSourceReturnRecordEo::getDistributionFailType, (Object)dto.getDistributionFailType())).eq(StrUtil.isNotBlank((CharSequence)dto.getSigningWarehouseCode()), DgNoSourceReturnRecordEo::getSigningWarehouseCode, (Object)dto.getSigningWarehouseCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getExternalAfterOrderNo()), DgNoSourceReturnRecordEo::getExternalAfterOrderNo, (Object)dto.getExternalAfterOrderNo())).like(StrUtil.isNotBlank((CharSequence)dto.getU9ReturnOrderNo()), DgNoSourceReturnRecordEo::getU9ReturnOrderNo, (Object)dto.getU9ReturnOrderNo())).eq(dto.getGenerateClutteredOrderInStatus() != null, DgNoSourceReturnRecordEo::getGenerateClutteredOrderInStatus, (Object)dto.getGenerateClutteredOrderInStatus())).eq(dto.getGenerateClutteredOrderOutStatus() != null, DgNoSourceReturnRecordEo::getGenerateClutteredOrderOutStatus, (Object)dto.getGenerateClutteredOrderOutStatus())).eq(dto.getOrigAfterOrderFlag() != null, DgNoSourceReturnRecordEo::getOrigAfterOrderFlag, (Object)dto.getOrigAfterOrderFlag())).eq(dto.getAccountingResult() != null, DgNoSourceReturnRecordEo::getAccountingResult, (Object)dto.getAccountingResult())).eq(StrUtil.isNotBlank((CharSequence)dto.getCustomerName()), DgNoSourceReturnRecordEo::getCustomerName, (Object)dto.getCustomerName())).eq(StrUtil.isNotBlank((CharSequence)dto.getAfterSaleOrderType()), DgNoSourceReturnRecordEo::getAfterSaleOrderType, (Object)dto.getAfterSaleOrderType())).eq(StrUtil.isNotBlank((CharSequence)dto.getReturnType()), DgNoSourceReturnRecordEo::getReturnType, (Object)dto.getReturnType())).in(CollUtil.isNotEmpty((Collection)dto.getSkuCodeList()), DgNoSourceReturnRecordEo::getSkuCode, (Collection)dto.getSkuCodeList())).in(CollUtil.isNotEmpty((Collection)dto.getSigningWarehouseCodeList()), DgNoSourceReturnRecordEo::getSigningWarehouseCode, (Collection)dto.getSigningWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)dto.getPhysicsSigningWarehouseCodeList()), DgNoSourceReturnRecordEo::getPhysicsSigningWarehouseCode, (Collection)dto.getPhysicsSigningWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)dto.getAfterWarehouseCodeList()), DgNoSourceReturnRecordEo::getAfterWarehouseCode, (Collection)dto.getAfterWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)dto.getMatchStatusList()), DgNoSourceReturnRecordEo::getMatchStatus, (Collection)dto.getMatchStatusList())).in(CollUtil.isNotEmpty((Collection)dto.getSaleCompanyNameList()), DgNoSourceReturnRecordEo::getSaleCompanyName, (Collection)dto.getSaleCompanyNameList())).in(CollUtil.isNotEmpty((Collection)dto.getBusinessPlatformNameList()), DgNoSourceReturnRecordEo::getBusinessPlatformName, (Collection)dto.getBusinessPlatformNameList())).in(CollUtil.isNotEmpty((Collection)dto.getSaleAreaNameList()), DgNoSourceReturnRecordEo::getSaleAreaName, (Collection)dto.getSaleAreaNameList())).in(CollUtil.isNotEmpty((Collection)dto.getReturnProvinceList()), DgNoSourceReturnRecordEo::getReturnProvince, (Collection)dto.getReturnProvinceList())).in(CollUtil.isNotEmpty((Collection)dto.getReturnAttributeList()), DgNoSourceReturnRecordEo::getReturnAttribute, (Collection)dto.getReturnAttributeList())).in(CollUtil.isNotEmpty((Collection)dto.getReturnTypeList()), DgNoSourceReturnRecordEo::getReturnType, (Collection)dto.getReturnTypeList())).in(CollUtil.isNotEmpty((Collection)dto.getAfterSaleOrderTypeList()), DgNoSourceReturnRecordEo::getAfterSaleOrderType, (Collection)dto.getAfterSaleOrderTypeList())).in(CollUtil.isNotEmpty((Collection)dto.getReturnRecordSerialNos()), DgNoSourceReturnRecordEo::getReturnRecordSerialNo, (Collection)dto.getReturnRecordSerialNos())).like(StrUtil.isNotBlank((CharSequence)dto.getProvinceName()), DgNoSourceReturnRecordEo::getProvinceName, (Object)dto.getProvinceName())).like(StrUtil.isNotBlank((CharSequence)dto.getCityName()), DgNoSourceReturnRecordEo::getCityName, (Object)dto.getCityName())).like(StrUtil.isNotBlank((CharSequence)dto.getDistrictName()), DgNoSourceReturnRecordEo::getDistrictName, (Object)dto.getDistrictName())).like(StrUtil.isNotBlank((CharSequence)dto.getSigningPerson()), DgNoSourceReturnRecordEo::getSigningPerson, (Object)dto.getSigningPerson())).like(StrUtil.isNotBlank((CharSequence)dto.getAuditPerson()), DgNoSourceReturnRecordEo::getAuditPerson, (Object)dto.getAuditPerson())).eq(StrUtil.isNotBlank((CharSequence)dto.getAfterOrderItemSkuCode()), DgNoSourceReturnRecordEo::getAfterOrderItemSkuCode, (Object)dto.getAfterOrderItemSkuCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getAfterOrderItemSkuSpecification()), DgNoSourceReturnRecordEo::getAfterOrderItemSkuSpecification, (Object)dto.getAfterOrderItemSkuSpecification())).eq(StrUtil.isNotBlank((CharSequence)dto.getAdjustmentNo()), DgNoSourceReturnRecordEo::getAdjustmentNo, (Object)dto.getAdjustmentNo())).eq(StrUtil.isNotBlank((CharSequence)dto.getMatchRecordSource()), DgNoSourceReturnRecordEo::getMatchRecordSource, (Object)dto.getMatchRecordSource())).like(StrUtil.isNotBlank((CharSequence)dto.getDistributionFailReason()), DgNoSourceReturnRecordEo::getDistributionFailReason, (Object)dto.getDistributionFailReason())).orderByDesc(BaseEo::getCreateTime);
        Page page = (Page)((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectPage((IPage)new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)queryWrapper);
        List records = page.getRecords();
        ArrayList list = new ArrayList(records.size());
        DtoHelper.eoList2DtoList((Collection)records, list, DgNoSourceReturnRecordDto.class);
        for (DgNoSourceReturnRecordDto sourceReturnRecordDto : list) {
            if (StringUtils.isNotBlank((CharSequence)sourceReturnRecordDto.getDistributionFailType())) {
                sourceReturnRecordDto.setDistributionFailType(DgAfterNoSourceReturnFailReasonEnum.getType((String)sourceReturnRecordDto.getDistributionFailType()));
            }
            if (StringUtils.isNotBlank((CharSequence)sourceReturnRecordDto.getDistributionFailReason())) {
                switch (sourceReturnRecordDto.getDistributionFailReason()) {
                    case "NOT_MATCHED": {
                        sourceReturnRecordDto.setDistributionFailType(DgAfterNoSourceReturnFailReasonEnum.NOT_MATCHED.getDesc());
                        break;
                    }
                    case "NOT_WAREHOUSE_MATCHED": {
                        sourceReturnRecordDto.setDistributionFailType(DgAfterNoSourceReturnFailReasonEnum.NOT_WAREHOUSE_MATCHED.getDesc());
                        break;
                    }
                    case "MISMATCHED": {
                        sourceReturnRecordDto.setDistributionFailType(DgAfterNoSourceReturnFailReasonEnum.MISMATCHED.getDesc());
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)sourceReturnRecordDto.getMatchPerson()) || Objects.equals(sourceReturnRecordDto.getMatchPerson(), "system")) continue;
            String usName = (String)this.cacheService.getCache("usName:" + sourceReturnRecordDto.getMatchPerson(), String.class);
            if (StringUtils.isBlank((CharSequence)usName)) {
                UserReqDto userReqDto = null;
                try {
                    userReqDto = (UserReqDto)RestResponseHelper.extractData((RestResponse)this.bocUserQueryApiProxy.queryUniqueUserByUserName(sourceReturnRecordDto.getMatchPerson()));
                    if (userReqDto != null) {
                        usName = userReqDto.getUsName();
                        this.cacheService.setCache("usName:" + sourceReturnRecordDto.getMatchPerson(), (Object)userReqDto.getUsName(), 86400);
                    }
                }
                catch (Exception e) {
                    log.error("\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u9519\u8bef userName\uff1a{}", (Object)sourceReturnRecordDto.getMatchPerson());
                }
            }
            sourceReturnRecordDto.setMatchPerson(usName);
        }
        PageInfo pageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        return pageInfo;
    }

    @Override
    public void batchAddOtherStorageOrder(List<Long> ids) {
        List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).selectByIds(ids);
        AssertUtils.notEmpty((Collection)dgNoSourceReturnRecordEos, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<DgNoSourceReturnRecordEo> unCreatedEos = dgNoSourceReturnRecordEos.stream().filter(a -> Objects.equals(a.getDr(), 0) && Objects.equals(a.getGenerateClutteredOrderInStatus(), 0) && Objects.equals(a.getMatchStatus(), DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(unCreatedEos)) {
            return;
        }
        this.addOtherStorageOrderByMatchRule(unCreatedEos, "in", 1);
    }

    @Override
    public void batchAddOtherStorageOrderOut(List<Long> ids) {
        List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).selectByIds(ids);
        AssertUtils.notEmpty((Collection)dgNoSourceReturnRecordEos, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<DgNoSourceReturnRecordEo> unCreatedEos = dgNoSourceReturnRecordEos.stream().filter(a -> Objects.equals(a.getDr(), 0) && Objects.equals(a.getGenerateClutteredOrderOutStatus(), 0) && Objects.equals(a.getMatchStatus(), DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode()) && Objects.equals(a.getGenerateClutteredOrderInStatus(), 1)).collect(Collectors.toList());
        if (CollUtil.isEmpty(unCreatedEos)) {
            return;
        }
        this.addOtherStorageOrderByMatchRule(unCreatedEos, "out", 1);
    }

    @Override
    public void addOtherStorageOrderByMatchRule(List<DgNoSourceReturnRecordEo> unCreatedEos, String type, Integer matchUnsucessWorkMode) {
        log.info("\u6279\u91cf\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u5165\u53c2\uff1a{}, {}", (Object)JSON.toJSONString(unCreatedEos), (Object)type);
        if (CollUtil.isEmpty(unCreatedEos)) {
            return;
        }
        List<Object> createdEos = null;
        createdEos = (type = StringUtil.isBlank((CharSequence)type) ? "in" : type).equals("in") ? unCreatedEos.stream().filter(e -> e.getGenerateClutteredOrderInStatus() == null || e.getGenerateClutteredOrderInStatus().equals(0)).collect(Collectors.toList()) : unCreatedEos.stream().filter(e -> e.getGenerateClutteredOrderOutStatus() == null || e.getGenerateClutteredOrderOutStatus().equals(0)).collect(Collectors.toList());
        if (CollUtil.isEmpty(createdEos)) {
            unCreatedEos.forEach(e -> {
                e.setScanCodeCheckoutStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)e.getSnCode()) ? 1 : 0));
                e.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                e.setMatchTime(new Date());
                ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)e);
            });
            return;
        }
        DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule = this.strategyReturnNoSourceMatchRuleService.get();
        log.info("\u6279\u91cf\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)noSourceMatchRule));
        if (!Objects.equals(matchUnsucessWorkMode, 1) && !Objects.equals(noSourceMatchRule.getMatchUnsucessWorkMode(), 0)) {
            log.info("\u6279\u91cf\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355,\u4e0d\u751f\u6210\u6742\u6536/\u6742\u53d1");
            createdEos.forEach(e -> {
                e.setScanCodeCheckoutStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)e.getSnCode()) ? 1 : 0));
                e.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                e.setMatchTime(new Date());
                ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)e);
            });
            return;
        }
        Date bizDate = new Date();
        if (Objects.equals(noSourceMatchRule.getSummaryMethod(), 0)) {
            Map<String, List<DgNoSourceReturnRecordEo>> keyRecordEosMap = createdEos.stream().collect(Collectors.groupingBy(DgNoSourceReturnRecordEo::getShippingNo));
            ArrayList<Mutex> locks = new ArrayList<Mutex>();
            try {
                for (DgNoSourceReturnRecordEo eo2 : createdEos) {
                    locks.add(this.lockService.lock("batchCreateReceipts", eo2.getId().toString(), 0));
                }
                String finalType = type;
                for (Map.Entry<String, List<DgNoSourceReturnRecordEo>> entry : keyRecordEosMap.entrySet()) {
                    InOtherStorageOrderDto inOtherStorageOrderDto = this.xthis.addOtherStorageOrder(entry.getValue(), bizDate, finalType);
                }
            }
            catch (Exception e2) {
                log.error("\u6279\u91cf\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u9519\u8bef\uff1a" + e2.getMessage(), (Throwable)e2);
                if (!e2.getMessage().contains("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25")) {
                    throw new BizException(e2.getMessage());
                }
                throw new BizException("\u6570\u636e\u5904\u7406\u4e2d...");
            }
            finally {
                this.releaseLocks(locks);
            }
        }
        HashMap<String, DgNoSourceReturnRecordEo> keyRecordEoMap = new HashMap<String, DgNoSourceReturnRecordEo>();
        ArrayList<Mutex> locks = new ArrayList<Mutex>();
        try {
            unCreatedEos.forEach(eo -> {
                locks.add(this.lockService.lock("batchCreateReceipts", eo.getId().toString(), 0));
                String key = eo.getShippingNo() + "-" + eo.getSkuCode() + "-" + eo.getSnCode();
                if (keyRecordEoMap.containsKey(key)) {
                    throw new BizException("\u8fd0\u5355\u53f7:" + eo.getShippingNo() + " | sku\u7f16\u7801: " + eo.getSkuCode() + "sn\u7801:" + eo.getSnCode() + "\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d");
                }
                keyRecordEoMap.put(key, (DgNoSourceReturnRecordEo)eo);
            });
            String finalType1 = type;
            keyRecordEoMap.forEach((key, eo) -> {
                InOtherStorageOrderDto storageOrderDto = this.xthis.addOtherStorageOrder(ListUtil.toList((Object[])new DgNoSourceReturnRecordEo[]{eo}), bizDate, finalType1);
            });
        }
        catch (Exception e3) {
            log.error("\u6279\u91cf\u65b0\u589e\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u9519\u8bef\uff1a" + e3.getMessage(), (Throwable)e3);
            if (!e3.getMessage().contains("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25")) {
                throw new BizException(e3.getMessage());
            }
            throw new BizException("\u6570\u636e\u5904\u7406\u4e2d...");
        }
        finally {
            this.releaseLocks(locks);
        }
    }

    private static String getMatchPerson() {
        String requestUserCode = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isBlank((CharSequence)requestUserCode)) {
            requestUserCode = "system";
            ServiceContext.getContext().setAttachment(ServiceContext.getContext().getRequestUserCode(), requestUserCode);
        }
        return requestUserCode;
    }

    @Override
    public List<NoSourceReturnRecordMatchSuccessDto> matchResultAndHandlerV2(List<DgNoSourceReturnRecordEo> successList, List<DgNoSourceReturnRecordEo> failList) {
        log.info("v2\u5f53\u524d\u5339\u914d\u6210\u529f\u8bb0\u5f55\u6761\u6570\uff1a{}\uff0c\u5339\u914d\u5931\u8d25\u8bb0\u5f55\u6761\u6570:{}", (Object)successList.size(), (Object)failList.size());
        ArrayList<NoSourceReturnRecordMatchSuccessDto> resultList = new ArrayList<NoSourceReturnRecordMatchSuccessDto>(successList.size());
        Map<String, List<DgNoSourceReturnRecordEo>> successMap = successList.stream().collect(Collectors.groupingBy(DgNoSourceReturnRecordEo::getAfterOrderNo));
        for (Map.Entry<String, List<DgNoSourceReturnRecordEo>> entry : successMap.entrySet()) {
            List<DgNoSourceReturnRecordEo> list = entry.getValue();
            String afterOrderNo = entry.getKey();
            String shippingNos = list.stream().map(DgNoSourceReturnRecordEo::getShippingNo).distinct().collect(Collectors.joining(","));
            List noSourceList = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).eq(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode())).eq(DgNoSourceReturnRecordEo::getShippingNo, (Object)shippingNos));
            List<Object> afterNoSourceList = new ArrayList(list.size());
            if (CollectionUtil.isNotEmpty((Collection)noSourceList)) {
                Map<Long, Long> successIdMap = noSourceList.stream().collect(Collectors.toMap(BaseEo::getId, BaseEo::getId));
                afterNoSourceList = list.stream().filter(a -> !successIdMap.containsKey(a.getId())).collect(Collectors.toList());
            } else {
                afterNoSourceList = list;
            }
            log.info("\u8fc7\u6ee4\u540e\u7684\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString(afterNoSourceList));
            if (afterNoSourceList.isEmpty()) continue;
            List<DgAfterSaleOrderItemEo> afterSaleOrderItemEos = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(list.get(0).getAfterOrderId());
            if (CollUtil.isNotEmpty(afterSaleOrderItemEos = afterSaleOrderItemEos.stream().filter(item -> item.getAfterSaleOrderItemType().equals(YesOrNoEnum.NO.getType())).collect(Collectors.toList()))) {
                List<String> skuCodes = afterNoSourceList.stream().map(DgNoSourceReturnRecordEo::getSkuCode).collect(Collectors.toList());
                List afterSaleOrderItemSkuCodes = afterSaleOrderItemEos.stream().map(k -> k.getSkuCode()).filter(Objects::nonNull).collect(Collectors.toList());
                skuCodes.addAll(afterSaleOrderItemSkuCodes);
                Map<String, ItemSkuDgRespDto> itemSkuDtoMap = this.getItemSkuDtoMap(skuCodes);
                Integer returnNum = afterSaleOrderItemEos.stream().filter(item -> item.getItemNum() != null).mapToInt(DgAfterSaleOrderItemEo::getItemNum).sum();
                Integer acturalReturnNum = afterSaleOrderItemEos.stream().filter(item -> item.getActualReturnNum() != null).mapToInt(DgAfterSaleOrderItemEo::getActualReturnNum).sum();
                log.info("\u7533\u8bf7\u9000\u8d27\u6570\u91cf\uff1a{} | \u5b9e\u9645\u9000\u8d27\u6570\u91cf\uff1a{} | \u65e0\u5934\u4ef6\u8bb0\u5f55\u6570\uff1a{}", new Object[]{returnNum, acturalReturnNum, afterNoSourceList.size()});
                if (returnNum <= acturalReturnNum + afterNoSourceList.size()) {
                    InOtherStorageOrderDto storageOrderDto;
                    List<DgNoSourceReturnRecordEo> inList;
                    DgNoSourceReturnRecordEo eo = list.get(0);
                    log.info("\u89c4\u683c\u578b\u53f7\u5339\u914d\u6210\u529f\u6807\u793a,isSpecModelMatch:{}", (Object)eo.isSpecModelMatch());
                    List<DgNoSourceReturnRecordEo> matchedRecords = list.stream().filter(DgNoSourceReturnRecordEo::isSpecModelMatch).collect(Collectors.toList());
                    ArrayList<AdjustmentOrderDto> adjustmentOrderDtoList = new ArrayList();
                    if (!matchedRecords.isEmpty()) {
                        String str = matchedRecords.stream().map(DgNoSourceReturnRecordEo::getReturnRecordSerialNo).collect(Collectors.joining(","));
                        log.info("\u89c4\u683c\u578b\u53f7\u5339\u914d\u6210\u529f\u7684\u9700\u8981\u751f\u6210\u5b58\u5728\u8c03\u6574\u5355,returnRecordSerialNo:{},afterOrderNo:{}", (Object)str, (Object)eo.getAfterOrderNo());
                        adjustmentOrderDtoList = this.buildAdjustmentOrderReqDto(matchedRecords, afterSaleOrderItemEos, itemSkuDtoMap);
                    }
                    if (CollUtil.isNotEmpty(inList = afterNoSourceList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getClutteredOrderInNo())).collect(Collectors.toList())) && null == (storageOrderDto = this.xthis.addOtherStorageOrder(inList, new Date(), "out"))) {
                        log.error("\u51fa\u5e93\u5355\u751f\u6210\u5931\u8d25");
                    }
                    Map afterSaleOrderItemMap = afterSaleOrderItemEos.stream().collect(Collectors.toMap(DgAfterSaleOrderItemEo::getAfterSaleOrderId, Function.identity(), (k1, k2) -> k2));
                    ArrayList<Long> afterNoSourceIds = new ArrayList<Long>(afterNoSourceList.size());
                    afterNoSourceList.forEach(noSourceReturnRecord -> {
                        noSourceReturnRecord.setGenerateClutteredOrderInStatus(null);
                        noSourceReturnRecord.setGenerateClutteredOrderOutStatus(null);
                        noSourceReturnRecord.setClutteredOrderInNo(null);
                        noSourceReturnRecord.setClutteredOrderOutNo(null);
                        noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                        noSourceReturnRecord.setDistributionFailReason("-");
                        noSourceReturnRecord.setMatchTime(new Date());
                        noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                        ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)noSourceReturnRecord);
                        afterNoSourceIds.add(noSourceReturnRecord.getId());
                    });
                    afterSaleOrderItemEos.forEach(item -> {
                        item.setActualReturnNum(item.getItemNum());
                        this.afterSaleOrderItemDomain.updateSelective((BaseEo)item);
                    });
                    DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
                    afterSaleOrderEo.setId(afterSaleOrderItemEos.get(0).getAfterSaleOrderId());
                    afterSaleOrderEo.setReturnShippingSn(shippingNos);
                    this.afterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
                    NoSourceReturnRecordMatchSuccessDto dto = new NoSourceReturnRecordMatchSuccessDto();
                    dto.setAfterNoSourceIds(afterNoSourceIds);
                    dto.setAfterOrderId(afterSaleOrderItemEos.get(0).getAfterSaleOrderId());
                    dto.setAdjustmentOrderDtoList(adjustmentOrderDtoList);
                    resultList.add(dto);
                    continue;
                }
                list.forEach(noSourceReturnRecord -> {
                    noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
                    noSourceReturnRecord.setDistributionFailType(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailType()) ? noSourceReturnRecord.getDistributionFailType() : DgAfterNoSourceReturnFailReasonEnum.MISMATCHED.getCode());
                    noSourceReturnRecord.setDistributionFailReason(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailReason()) ? noSourceReturnRecord.getDistributionFailReason() : DgAfterNoSourceReturnFailReasonEnum.MISMATCHED.getDesc());
                    noSourceReturnRecord.setMatchTime(new Date());
                    noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                });
                this.addOtherStorageOrderByMatchRule(list, "in", null);
                continue;
            }
            log.error("\u552e\u540e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728 {}", (Object)list.get(0).getAfterOrderId());
        }
        failList.forEach(noSourceReturnRecord -> {
            noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
            noSourceReturnRecord.setDistributionFailType(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailType()) ? noSourceReturnRecord.getDistributionFailType() : DgAfterNoSourceReturnFailReasonEnum.NOT_MATCHED.getCode());
            noSourceReturnRecord.setDistributionFailReason(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailReason()) ? noSourceReturnRecord.getDistributionFailReason() : DgAfterNoSourceReturnFailReasonEnum.NOT_MATCHED.getDesc());
            noSourceReturnRecord.setMatchTime(new Date());
            noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
        });
        this.addOtherStorageOrderByMatchRule(failList, "in", null);
        return resultList.isEmpty() ? ListUtil.empty() : resultList;
    }

    private Map<String, ItemSkuDgRespDto> getItemSkuDtoMap(List<String> skuCodes) {
        List list = (List)this.itemSkuDgQueryApi.queryBySkuCode(skuCodes).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMatchFailByIds(List<NoSourceReturnRecordMatchSuccessDto> matchSuccessDtos) {
        List<Long> allAfterNoSourceIds = matchSuccessDtos.stream().flatMap(dto -> dto.getAfterNoSourceIds().stream()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(allAfterNoSourceIds) && allAfterNoSourceIds.size() > 4000) {
            List partitionList = Lists.partition(allAfterNoSourceIds, (int)2000);
            for (List ids : partitionList) {
                this.updateByIds(ids);
            }
        } else {
            this.updateByIds(allAfterNoSourceIds);
        }
    }

    private void updateByIds(List<Long> allAfterNoSourceIds) {
        ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgNoSourceReturnRecordEo.class).in(BaseEo::getId, allAfterNoSourceIds)).set(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode())).set(DgNoSourceReturnRecordEo::getDistributionFailType, (Object)DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_UPDATE_EXCEPTION.getCode())).set(DgNoSourceReturnRecordEo::getDistributionFailReason, (Object)DgAfterNoSourceReturnFailReasonEnum.AFTER_ORDER_UPDATE_EXCEPTION.getDesc()));
    }

    @Override
    public RestResponse<Void> batchNoMatch(List<Long> ids) {
        List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).isNull(DgNoSourceReturnRecordEo::getClutteredOrderInNo)).in(BaseEo::getId, ids)).in(DgNoSourceReturnRecordEo::getMatchStatus, new Object[]{DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode(), DgAfterNoSourceReturnMatchStatusEnum.WAIT_MATCH.getCode()}));
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)dgNoSourceReturnRecordEos), (String)"\u6ca1\u6709\u627e\u5230\u5339\u914d\u8bb0\u5f55\u4fe1\u606f");
        AssertUtils.isFalse((dgNoSourceReturnRecordEos.size() != ids.size() ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u64cd\u4f5c\u5339\u914d\u5931\u8d25\u3001\u5f85\u5339\u914d\u4e14\u672a\u751f\u6210\u6742\u6536\u5355\u7684\u6570\u636e");
        DgNoSourceReturnRecordEo updateEo = new DgNoSourceReturnRecordEo();
        updateEo.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.NO_MATCH.getCode());
        updateEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", ids)));
        ((IDgNoSourceReturnRecordDomain)this.domain).updateSelectiveSqlFilter((BaseEo)updateEo);
        return RestResponse.VOID;
    }

    @Override
    public void updateAdjustmentNo(List<Long> noSourceReturnRecordIds, String adjustmentNo) {
        ((IDgNoSourceReturnRecordDomain)this.domain).updateAdjustmentNo(noSourceReturnRecordIds, adjustmentNo);
    }

    @Override
    public void updateByAfterSaleOrderNos(List<String> afterSaleOrderNos) {
        ((IDgNoSourceReturnRecordDomain)this.domain).updateByAfterSaleOrderNos(afterSaleOrderNos);
    }

    @Override
    @Deprecated
    public List<Long> matchResultAndHandler(List<DgNoSourceReturnRecordEo> successList, List<DgNoSourceReturnRecordEo> failList, DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule, Integer matchUnsucessWorkMode) {
        log.info("\u5f53\u524d\u5339\u914d\u6210\u529f\u8bb0\u5f55\u6761\u6570\uff1a{}\uff0c\u5339\u914d\u5931\u8d25\u8bb0\u5f55\u6761\u6570:{}", (Object)successList.size(), (Object)failList.size());
        ArrayList<Long> afterIds = new ArrayList<Long>();
        Map<String, List<DgNoSourceReturnRecordEo>> successMap = successList.stream().collect(Collectors.groupingBy(DgNoSourceReturnRecordEo::getShippingNo));
        HashMap map = new HashMap();
        for (Map.Entry<String, List<DgNoSourceReturnRecordEo>> entry : successMap.entrySet()) {
            List<DgNoSourceReturnRecordEo> list = entry.getValue();
            String shippingNo = entry.getKey();
            List noSourceList = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(DgNoSourceReturnRecordEo::getShippingNo, (Object)shippingNo)).or()).eq(DgNoSourceReturnRecordEo::getAfterOrderNo, (Object)((DgNoSourceReturnRecordEo)list.get(0)).getAfterOrderNo());
            }));
            Long afterOrderId = list.get(0).getAfterOrderId();
            String afterOrderNo = list.get(0).getAfterOrderNo();
            List<DgNoSourceReturnRecordEo> afterNoSourceList = noSourceList.stream().filter(a -> !map.containsKey(a.getId())).map(record -> {
                if (StringUtils.isBlank((CharSequence)record.getAfterOrderNo())) {
                    record.setAfterOrderNo(afterOrderNo);
                    record.setAfterOrderId(afterOrderId);
                }
                return record;
            }).collect(Collectors.toList());
            log.info("\u8fc7\u6ee4\u540e\u7684\u8bb0\u5f55\uff1a{}, {}", (Object)JSON.toJSONString(afterNoSourceList), (Object)JSON.toJSONString(map));
            if (afterNoSourceList.isEmpty()) continue;
            afterNoSourceList.forEach(a -> map.put(a.getId(), a.getId()));
            List<DgAfterSaleOrderItemEo> afterSaleOrderItemEos = this.afterSaleOrderItemDomain.queryEosByAfterSaleOrderId(list.get(0).getAfterOrderId());
            afterSaleOrderItemEos = afterSaleOrderItemEos.stream().filter(item -> item.getAfterSaleOrderItemType().equals(YesOrNoEnum.NO.getType())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(afterSaleOrderItemEos)) {
                Integer returnNum = afterSaleOrderItemEos.stream().filter(item -> item.getItemNum() != null).mapToInt(DgAfterSaleOrderItemEo::getItemNum).sum();
                Integer acturalReturnNum = afterSaleOrderItemEos.stream().filter(item -> item.getActualReturnNum() != null).mapToInt(DgAfterSaleOrderItemEo::getActualReturnNum).sum();
                log.info("\u7533\u8bf7\u9000\u8d27\u6570\u91cf\uff1a{} | \u5b9e\u9645\u9000\u8d27\u6570\u91cf\uff1a{} | \u65e0\u5934\u4ef6\u8bb0\u5f55\u6570\uff1a{}", new Object[]{returnNum, acturalReturnNum, afterNoSourceList.size()});
                if (returnNum <= acturalReturnNum + afterNoSourceList.size()) {
                    InOtherStorageOrderDto storageOrderDto;
                    List<DgNoSourceReturnRecordEo> inList = afterNoSourceList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getClutteredOrderInNo())).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(inList) && null == (storageOrderDto = this.xthis.addOtherStorageOrder(inList, new Date(), "out"))) {
                        log.error("\u51fa\u5e93\u5355\u751f\u6210\u5931\u8d25");
                    }
                    ArrayList afterNoSourceIds = new ArrayList(afterNoSourceList.size());
                    afterNoSourceList.forEach(noSourceReturnRecord -> {
                        noSourceReturnRecord.setGenerateClutteredOrderInStatus(null);
                        noSourceReturnRecord.setGenerateClutteredOrderOutStatus(null);
                        noSourceReturnRecord.setClutteredOrderInNo(null);
                        noSourceReturnRecord.setClutteredOrderOutNo(null);
                        noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode());
                        noSourceReturnRecord.setDistributionFailReason("-");
                        noSourceReturnRecord.setMatchTime(new Date());
                        noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                        ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)noSourceReturnRecord);
                        afterNoSourceIds.add(noSourceReturnRecord.getId());
                    });
                    afterSaleOrderItemEos.forEach(item -> {
                        item.setActualReturnNum(item.getItemNum());
                        this.afterSaleOrderItemDomain.updateSelective((BaseEo)item);
                    });
                    DgAfterSaleOrderEo afterSaleOrderEo = new DgAfterSaleOrderEo();
                    afterSaleOrderEo.setId(((DgAfterSaleOrderItemEo)afterSaleOrderItemEos.get(0)).getAfterSaleOrderId());
                    afterSaleOrderEo.setReturnShippingSn(shippingNo);
                    this.afterSaleOrderDomain.updateSelective((BaseEo)afterSaleOrderEo);
                    afterIds.add(((DgAfterSaleOrderItemEo)afterSaleOrderItemEos.get(0)).getAfterSaleOrderId());
                    continue;
                }
                list.forEach(noSourceReturnRecord -> {
                    noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
                    noSourceReturnRecord.setDistributionFailType(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailType()) ? noSourceReturnRecord.getDistributionFailType() : DgAfterNoSourceReturnFailReasonEnum.MISMATCHED.getCode());
                    noSourceReturnRecord.setDistributionFailReason(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailReason()) ? noSourceReturnRecord.getDistributionFailReason() : DgAfterNoSourceReturnFailReasonEnum.MISMATCHED.getDesc());
                    noSourceReturnRecord.setMatchTime(new Date());
                    noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
                });
                this.addOtherStorageOrderByMatchRule(list, "in", matchUnsucessWorkMode);
                continue;
            }
            log.info("\u552e\u540e\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728-1");
        }
        failList.forEach(noSourceReturnRecord -> {
            noSourceReturnRecord.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode());
            noSourceReturnRecord.setDistributionFailType(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailType()) ? noSourceReturnRecord.getDistributionFailType() : DgAfterNoSourceReturnFailReasonEnum.NOT_MATCHED.getCode());
            noSourceReturnRecord.setDistributionFailReason(StringUtils.isNotBlank((CharSequence)noSourceReturnRecord.getDistributionFailReason()) ? noSourceReturnRecord.getDistributionFailReason() : DgAfterNoSourceReturnFailReasonEnum.NOT_MATCHED.getDesc());
            noSourceReturnRecord.setMatchTime(new Date());
            noSourceReturnRecord.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
        });
        this.addOtherStorageOrderByMatchRule(failList, "in", matchUnsucessWorkMode);
        return afterIds;
    }

    @Override
    public RestResponse<Void> batchModifyRemark(DgNoSourceReturnRecordRemarkModifyReqDto reqDto) {
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)reqDto.getIds()), (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        List recordEos = ((IDgNoSourceReturnRecordDomain)this.domain).selectByIds(reqDto.getIds());
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)recordEos), (String)"\u672a\u67e5\u5230\u6570\u636e");
        ((IDgNoSourceReturnRecordDomain)this.domain).batchModifyRemark(recordEos.stream().map(BaseEo::getId).collect(Collectors.toList()), reqDto.getRemark(), reqDto.getChargeOrderRemark(), reqDto.getReturnAndRepairRemark(), reqDto.getCustomerRemark(), reqDto.getScanRemark());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> logicDeleteById(Long id) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgNoSourceReturnRecordEo dgNoSourceReturnRecordEo = (DgNoSourceReturnRecordEo)((IDgNoSourceReturnRecordDomain)this.domain).selectByPrimaryKey(id);
        if (dgNoSourceReturnRecordEo != null) {
            AssertUtils.isFalse((boolean)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode().equals(dgNoSourceReturnRecordEo.getMatchStatus()), (String)"\u5339\u914d\u6210\u529f\u7684\u4e0d\u5141\u8bb8\u5220\u9664");
            ((IDgNoSourceReturnRecordDomain)this.domain).logicDeleteById(id);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> abolish(Long id) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgNoSourceReturnRecordEo dgNoSourceReturnRecordEo = (DgNoSourceReturnRecordEo)((IDgNoSourceReturnRecordDomain)this.domain).selectByPrimaryKey(id);
        if (dgNoSourceReturnRecordEo != null) {
            AssertUtils.isFalse((boolean)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode().equals(dgNoSourceReturnRecordEo.getMatchStatus()), (String)"\u5339\u914d\u6210\u529f\u7684\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            DgNoSourceReturnRecordEo updateEo = new DgNoSourceReturnRecordEo();
            updateEo.setId(dgNoSourceReturnRecordEo.getId());
            updateEo.setMatchStatus(DgAfterNoSourceReturnMatchStatusEnum.ABOLISH.getCode());
            updateEo.setDistributionFailType("");
            updateEo.setDistributionFailReason("");
            ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)updateEo);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchAbololish(DgNoSourceReturnRecordDto dto) {
        if (CollectionUtil.isNotEmpty((Collection)dto.getIds())) {
            List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).selectByIds(dto.getIds());
            dgNoSourceReturnRecordEos.removeIf(eo -> {
                boolean isAbolish = DgAfterNoSourceReturnMatchStatusEnum.ABOLISH.getCode().equals(eo.getMatchStatus());
                if (isAbolish) {
                    log.info("\u9000\u8d27\u5355\u53f7{}\u5df2\u4f5c\u5e9f\uff0c\u672c\u6b21\u4f5c\u5e9f\u5ffd\u7565\u8be5\u5355\u53f7", (Object)eo.getExternalAfterOrderNo());
                }
                return isAbolish;
            });
            if (CollectionUtil.isEmpty((Collection)dgNoSourceReturnRecordEos)) {
                return RestResponse.VOID;
            }
            this.validateNoSourceReturnRecords(dgNoSourceReturnRecordEos);
            List ids = dgNoSourceReturnRecordEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgNoSourceReturnRecordEo.class).set(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.ABOLISH.getCode())).set(DgNoSourceReturnRecordEo::getDistributionFailType, (Object)"")).set(DgNoSourceReturnRecordEo::getDistributionFailReason, (Object)"")).set(ServiceContext.getContext().getRequestUserCode() != null, BaseEo::getUpdatePerson, (Object)ServiceContext.getContext().getRequestUserCode()).set(BaseEo::getUpdateTime, (Object)new Date())).in(BaseEo::getId, ids)).eq(BaseEo::getDr, (Object)0));
            dgNoSourceReturnRecordEos.forEach(eo -> CompletableFuture.supplyAsync(() -> {
                WmsCancelReturnApplyRequestDto req = new WmsCancelReturnApplyRequestDto();
                req.setWhseId(eo.getPhysicsSigningWarehouseCode());
                req.setReturnKey(eo.getWmsReturnOrderNo());
                log.info("\u9000\u8d27\u5339\u914d\u8bb0\u5f55\u4f5c\u5e9f\u901a\u77e5WMS\u5f00\u59cb\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)eo.getExternalAfterOrderNo(), (Object)JacksonUtil.toJson((Object)req));
                RestResponse resp = this.wmsReturnApi.sendCancelReturnApply(req);
                log.info("\u9000\u8d27\u5339\u914d\u8bb0\u5f55\u4f5c\u5e9f\u901a\u77e5WMS\u5b8c\u6210\uff1a{} - {}", (Object)eo.getExternalAfterOrderNo(), (Object)JacksonUtil.toJson((Object)resp));
                return null;
            }));
        }
        return RestResponse.VOID;
    }

    private void validateNoSourceReturnRecords(List<DgNoSourceReturnRecordEo> eoList) {
        ArrayList errors = new ArrayList();
        ArrayList allowStatus = Lists.newArrayList((Object[])new String[]{DgAfterNoSourceReturnMatchStatusEnum.WAIT_MATCH.getCode(), DgAfterNoSourceReturnMatchStatusEnum.MATCH_FAIL.getCode()});
        eoList.forEach(eo -> {
            if (!allowStatus.contains(eo.getMatchStatus())) {
                errors.add(String.format("\u9000\u8d27\u8bb0\u5f55\u6d41\u6c34\u53f7%s\u5339\u914d\u72b6\u6001\u4e0d\u662f[\u5f85\u5339\u914d/\u5339\u914d\u5931\u8d25]\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f", eo.getReturnRecordSerialNo()));
                return;
            }
            if (Objects.equals(eo.getGenerateClutteredOrderInStatus(), YesOrNoEnum.YES.getType())) {
                errors.add(String.format("\u9000\u8d27\u8bb0\u5f55\u6d41\u6c34\u53f7%s\u5df2\u751f\u6210\u6742\u6536\u5355\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f", eo.getReturnRecordSerialNo()));
            }
        });
        if (!errors.isEmpty()) {
            throw new BizException(String.join((CharSequence)";\r\n", errors));
        }
    }

    @Override
    public RestResponse<Void> modifyRemarkOrU9No(DgNoSourceReturnRecordDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getReturnRecordSerialNo()), (String)"\u53c2\u6570\u9000\u8d27\u4e0d\u80fd\u4e3a\u7a7a");
        DgNoSourceReturnRecordEo recordEo = (DgNoSourceReturnRecordEo)((ExtQueryChainWrapper)((IDgNoSourceReturnRecordDomain)this.domain).filter().eq((Object)"return_record_serial_no", (Object)reqDto.getReturnRecordSerialNo())).one();
        AssertUtils.isFalse((boolean)Objects.isNull(recordEo), (String)"\u672a\u67e5\u5230\u6570\u636e");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChargeOrderRemark())) {
            String chargeOrderRemark = reqDto.getChargeOrderRemark();
            if (StringUtils.isNotBlank((CharSequence)recordEo.getChargeOrderRemark())) {
                chargeOrderRemark = String.join((CharSequence)",", recordEo.getChargeOrderRemark(), reqDto.getChargeOrderRemark());
            }
            recordEo.setChargeOrderRemark(chargeOrderRemark);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getScanRemark())) {
            String scanRemark = reqDto.getScanRemark();
            if (StringUtils.isNotBlank((CharSequence)recordEo.getScanRemark())) {
                scanRemark = String.join((CharSequence)",", recordEo.getScanRemark(), reqDto.getScanRemark());
            }
            recordEo.setScanRemark(scanRemark);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getU9ReturnOrderNo())) {
            String u9ReturnOrderNo = reqDto.getU9ReturnOrderNo();
            if (StringUtils.isNotBlank((CharSequence)recordEo.getU9ReturnOrderNo())) {
                u9ReturnOrderNo = String.join((CharSequence)",", recordEo.getU9ReturnOrderNo(), reqDto.getU9ReturnOrderNo());
            }
            recordEo.setU9ReturnOrderNo(u9ReturnOrderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getReturnAndRepairRemark())) {
            String returnAndRepairRemark = reqDto.getReturnAndRepairRemark();
            if (StringUtils.isNotBlank((CharSequence)recordEo.getReturnAndRepairRemark())) {
                returnAndRepairRemark = String.join((CharSequence)",", recordEo.getReturnAndRepairRemark(), reqDto.getReturnAndRepairRemark());
            }
            recordEo.setReturnAndRepairRemark(returnAndRepairRemark);
        }
        ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)recordEo);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateShippingNo(Long id, String shippingNo) {
        AssertUtils.notBlank((String)shippingNo, (String)"\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DgNoSourceReturnRecordEo eo = (DgNoSourceReturnRecordEo)((IDgNoSourceReturnRecordDomain)this.domain).selectByPrimaryKey(id);
        if (Objects.nonNull(eo)) {
            AssertUtils.isTrue((boolean)FAILED_MATCH_STATUS.contains(eo.getMatchStatus()), (String)"\u6b64\u72b6\u6001\u4e0b\u4e0d\u80fd\u4fee\u6539\u8fd0\u5355\u53f7");
            eo.setShippingNo(shippingNo);
            ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)eo);
        }
    }

    @Override
    public List<NoSourceReturnRecordMatchSuccessDto> batchMatch(List<Long> ids) {
        List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, ids)).notIn(DgNoSourceReturnRecordEo::getMatchStatus, new Object[]{DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode(), DgAfterNoSourceReturnMatchStatusEnum.NO_MATCH.getCode()}));
        if (CollUtil.isEmpty((Collection)dgNoSourceReturnRecordEos)) {
            return new ArrayList<NoSourceReturnRecordMatchSuccessDto>();
        }
        DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule = this.strategyReturnNoSourceMatchRuleService.get();
        ArrayList<DgNoSourceReturnRecordEo> successList = new ArrayList<DgNoSourceReturnRecordEo>();
        ArrayList<DgNoSourceReturnRecordEo> failList = new ArrayList<DgNoSourceReturnRecordEo>();
        this.match(dgNoSourceReturnRecordEos, successList, noSourceMatchRule, failList);
        return this.matchResultAndHandlerV2(successList, failList);
    }

    @Override
    public void match(List<DgNoSourceReturnRecordEo> dgNoSourceReturnRecordEos, List<DgNoSourceReturnRecordEo> successList, DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule, List<DgNoSourceReturnRecordEo> failList) {
        this.matchRecord(dgNoSourceReturnRecordEos, successList, noSourceMatchRule, failList);
        if (CollectionUtil.isNotEmpty(successList)) {
            List afterOrderIds = successList.stream().map(DgNoSourceReturnRecordEo::getAfterOrderId).distinct().collect(Collectors.toList());
            Map idMap = successList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
            List snCodeEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderItemSnRecordDomain.filter().select(new String[]{"sn_code"}).in((Object)"after_sale_order_id", afterOrderIds)).eq((Object)"dr", (Object)0)).list();
            log.info("\u6839\u636e\u552e\u540e\u5355id\u67e5\u8be2snCode\u8bb0\u5f55\uff0c\u552e\u540e\u5355ids\uff1a{}\uff0c snCodeEos\uff1a{}", afterOrderIds, (Object)JSON.toJSONString((Object)snCodeEos));
            if (CollectionUtil.isNotEmpty((Collection)snCodeEos)) {
                ArrayList snCodes = new ArrayList();
                snCodeEos.stream().filter(a -> a != null && StringUtils.isNotBlank((CharSequence)a.getSnCode())).flatMap(a -> Arrays.stream(a.getSnCode().split(","))).forEach(snCodes::add);
                if (!snCodes.isEmpty()) {
                    List noSourceList = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).in(DgNoSourceReturnRecordEo::getSnCode, snCodes)).ne(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode()));
                    ArrayList<DgNoSourceReturnRecordEo> filterNoSourceList = new ArrayList();
                    if (CollectionUtil.isNotEmpty((Collection)noSourceList)) {
                        filterNoSourceList = noSourceList.stream().filter(a -> !idMap.containsKey(a.getId())).collect(Collectors.toList());
                    }
                    log.info("\u6839\u636esnCode\u67e5\u8be2\u5176\u4ed6\u8bb0\u5f55\uff0csnCodes\uff1a{}\uff0c filterNoSourceList\uff1a{}", snCodes, (Object)JSON.toJSONString(filterNoSourceList));
                    if (CollectionUtil.isNotEmpty(filterNoSourceList)) {
                        this.matchRecord(filterNoSourceList, successList, noSourceMatchRule, failList);
                    }
                }
            } else {
                List returnShippingNoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderLogisticsWarehouseDomain.filter().select(new String[]{"return_shipping_sn"}).in((Object)"after_sale_order_id", afterOrderIds)).eq((Object)"dr", (Object)0)).list();
                log.info("\u6839\u636e\u552e\u540e\u5355id\u67e5\u8be2\u8fd0\u5355\u53f7\u8bb0\u5f55\uff0c\u552e\u540e\u5355ids\uff1a{}\uff0c returnShippingNoEos\uff1a{}", afterOrderIds, (Object)JSON.toJSONString((Object)returnShippingNoEos));
                ArrayList returnShippingNos = new ArrayList();
                returnShippingNoEos.stream().filter(a -> a != null && StringUtils.isNotBlank((CharSequence)a.getReturnShippingSn())).flatMap(a -> Arrays.stream(a.getReturnShippingSn().split(","))).forEach(returnShippingNos::add);
                if (!returnShippingNos.isEmpty()) {
                    List noSourceList = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).in(DgNoSourceReturnRecordEo::getShippingNo, returnShippingNos)).ne(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode()));
                    ArrayList<DgNoSourceReturnRecordEo> filterNoSourceList = new ArrayList();
                    if (CollectionUtil.isNotEmpty((Collection)noSourceList)) {
                        filterNoSourceList = noSourceList.stream().filter(a -> !idMap.containsKey(a.getId())).collect(Collectors.toList());
                    }
                    log.info("\u6839\u636e\u8fd0\u5355\u53f7\u67e5\u8be2\u5176\u4ed6\u8bb0\u5f55\uff0c\u8fd0\u5355\u53f7\uff1a{}\uff0c filterNoSourceList\uff1a{}", returnShippingNos, (Object)JSON.toJSONString(filterNoSourceList));
                    if (CollectionUtil.isNotEmpty(filterNoSourceList)) {
                        this.matchRecord(filterNoSourceList, successList, noSourceMatchRule, failList);
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty(successList)) {
            this.matchAndFilterRepeatRecord(successList, failList);
        }
    }

    private void matchAndFilterRepeatRecord(List<DgNoSourceReturnRecordEo> successList, List<DgNoSourceReturnRecordEo> failList) {
        log.info("\u5f00\u59cb\u5339\u914d\u662f\u5426\u8d85\u8fc7\u552e\u540e\u6570\u91cf");
        ArrayList<DgNoSourceReturnRecordEo> waitMatchList = new ArrayList<DgNoSourceReturnRecordEo>();
        waitMatchList.addAll(successList);
        List afterOrderIds = successList.stream().map(DgNoSourceReturnRecordEo::getAfterOrderId).distinct().collect(Collectors.toList());
        List matchSuccessList = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).in(DgNoSourceReturnRecordEo::getAfterOrderId, afterOrderIds)).eq(DgNoSourceReturnRecordEo::getMatchStatus, (Object)DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)matchSuccessList)) {
            matchSuccessList.stream().forEach(ld -> ld.setDbSaveFlag(Boolean.valueOf(true)));
            waitMatchList.addAll(matchSuccessList);
        }
        Map<Long, List<DgNoSourceReturnRecordEo>> afterOrderIdMap = waitMatchList.stream().collect(Collectors.groupingBy(DgNoSourceReturnRecordEo::getAfterOrderId));
        afterOrderIdMap.forEach((afterOrderId, recordList) -> {
            DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.afterSaleOrderDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAfterSaleOrderEo.class).eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, afterOrderId));
            AssertUtils.notNull((Object)afterSaleOrderEo, (String)("\u83b7\u53d6\u4e0d\u5230\u539f\u552e\u540e\u5355\u6570\u636e" + afterOrderId));
            List afterSaleOrderItemEos = this.afterSaleOrderItemDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgAfterSaleOrderItemEo.class).eq(BaseEo::getDr, (Object)0)).eq(DgAfterSaleOrderItemEo::getAfterSaleOrderId, afterOrderId));
            AssertUtils.notNull((Object)afterSaleOrderEo, (String)("\u83b7\u53d6\u4e0d\u5230\u539f\u552e\u540e\u5355\u5546\u54c1\u6570\u636e" + afterOrderId));
            List skuCodes = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getSkuCode).collect(Collectors.toList());
            RestResponse response = this.itemSkuDgQueryApi.querySameSpecModelSkus(skuCodes);
            List sameModelSkus = (List)RestResponseHelper.extractData((RestResponse)response);
            boolean matchForSpec = Optional.ofNullable(afterSaleOrderEo.getSaleOrderId()).map(ld -> {
                DgPerformOrderReqDto queryDto = new DgPerformOrderReqDto();
                queryDto.setId(ld);
                DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryByDtoNoReleationInfo(queryDto);
                AssertUtils.notNull((Object)orderRespDto, (String)(afterSaleOrderEo.getSaleOrderId() + "\u83b7\u53d6\u4e0d\u5230\u539f\u5355\u9500\u552e\u5355\u4fe1\u606f"));
                return orderRespDto.getBizType().equals("jd_delivery_warehouse") || orderRespDto.getBizType().equals("cainiao_delivery_warehouse");
            }).orElse(false);
            HashMap<Long, Set> matchNumMap = new HashMap<Long, Set>();
            recordList.forEach(ld -> {
                for (DgAfterSaleOrderItemEo lld : afterSaleOrderItemEos) {
                    if (!this.matchAfterOrderItem(lld, (DgNoSourceReturnRecordEo)ld, matchForSpec, sameModelSkus)) continue;
                    matchNumMap.computeIfAbsent(lld.getId(), k -> new HashSet()).add(ld.getId());
                    break;
                }
            });
            log.info("\u5339\u914d\u5904\u7406\u7ed3\u679c {}", (Object)JSON.toJSONString(matchNumMap));
            Map<Long, DgAfterSaleOrderItemEo> afterSaleOrderItemEoMap = afterSaleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
            Map<Long, DgNoSourceReturnRecordEo> recordMap = recordList.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
            matchNumMap.forEach((key, setValue) -> {
                DgAfterSaleOrderItemEo saleOrderItemEo = (DgAfterSaleOrderItemEo)afterSaleOrderItemEoMap.get(key);
                AssertUtils.notNull((Object)saleOrderItemEo, (String)("\u65e0\u6548\u5339\u914d\u7ed3\u679c\uff0c\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5355\u5546\u54c1\u6570\u636e" + key));
                BigDecimal matchNum = BigDecimal.ZERO;
                BigDecimal saveMatchNum = BigDecimal.ZERO;
                ArrayList<DgNoSourceReturnRecordEo> waitFailList = new ArrayList<DgNoSourceReturnRecordEo>();
                for (Long ld2 : setValue) {
                    DgNoSourceReturnRecordEo recordEo = (DgNoSourceReturnRecordEo)recordMap.get(ld2);
                    AssertUtils.notNull((Object)recordEo, (String)("\u65e0\u6548\u5339\u914d\u7ed3\u679c\uff0c\u83b7\u53d6\u4e0d\u5230\u65e0\u5934\u5355\u6570\u636e" + ld2));
                    matchNum = matchNum.add(recordEo.getItemNum());
                    if (recordEo.getDbSaveFlag() == null || !recordEo.getDbSaveFlag().booleanValue()) {
                        waitFailList.add(recordEo);
                        continue;
                    }
                    saveMatchNum = saveMatchNum.add(recordEo.getItemNum());
                }
                if (matchNum.compareTo(BigDecimal.valueOf(saleOrderItemEo.getItemNum().intValue())) > 0) {
                    log.info("\u8d85\u8fc7\u552e\u540e\u7533\u8bf7\u6570\u91cf {} matchNum={} saveMatchNum={} itemNum={}", new Object[]{saleOrderItemEo.getId(), matchNum, saveMatchNum, saleOrderItemEo.getItemNum()});
                    BigDecimal leftNum = matchNum.subtract(BigDecimal.valueOf(saleOrderItemEo.getItemNum().intValue())).subtract(saveMatchNum);
                    for (DgNoSourceReturnRecordEo it : waitFailList) {
                        if (leftNum.compareTo(BigDecimal.ZERO) <= 0) continue;
                        this.matchFailMsg(it, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER_OR_HAD_MATCH, DgAfterNoSourceReturnFailReasonEnum.UNABLE_MATCH_VALID_AFTER_SALE_ORDER_OR_HAD_MATCH);
                        it.setDistributionFailReason(afterSaleOrderEo.getAfterSaleOrderNo() + it.getDistributionFailReason());
                        leftNum = leftNum.subtract(it.getItemNum());
                        successList.removeIf(ld -> ld.getId().equals(it.getId()));
                        failList.add(it);
                    }
                }
            });
        });
    }

    private boolean matchAfterOrderItem(DgAfterSaleOrderItemEo dgAfterSaleOrderItemEo, DgNoSourceReturnRecordEo dgNoSourceReturnRecordEo, boolean matchForSpec, List<SameModelSkuRespDto> sameModelSkus) {
        if (Objects.equals(dgNoSourceReturnRecordEo.getSkuCode(), dgAfterSaleOrderItemEo.getSkuCode())) {
            log.info("{} \u884c\u5339\u914d {} sku\u7f16\u7801\u5339\u914d {}", new Object[]{dgAfterSaleOrderItemEo.getId(), dgNoSourceReturnRecordEo.getId(), dgNoSourceReturnRecordEo.getSkuCode()});
            return true;
        }
        if (matchForSpec) {
            SameModelSkuRespDto sameModelSku = CollUtil.emptyIfNull(sameModelSkus).stream().filter(k -> Objects.equals(k.getSkuCode(), dgAfterSaleOrderItemEo.getSkuCode()) && k.getSkuCodes() != null && k.getSkuCodes().contains(dgNoSourceReturnRecordEo.getSkuCode())).findFirst().orElse(null);
            log.info("{} \u884c\u5339\u914d {} \u5904\u7406\u540c\u578b\u53f7\u4e0d\u540csku\u5339\u914d {} \u5339\u914d\u5230 {}", new Object[]{dgAfterSaleOrderItemEo.getId(), dgNoSourceReturnRecordEo.getId(), dgNoSourceReturnRecordEo.getSkuCode(), JSON.toJSONString((Object)sameModelSku)});
            return sameModelSku != null;
        }
        log.info("{} \u884c\u5339\u914d {} \u4e0d\u5339\u914d {}", new Object[]{dgAfterSaleOrderItemEo.getId(), dgNoSourceReturnRecordEo.getId(), dgNoSourceReturnRecordEo.getSkuCode()});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchRecord(List<DgNoSourceReturnRecordEo> list, List<DgNoSourceReturnRecordEo> successList, DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule, List<DgNoSourceReturnRecordEo> failList) {
        for (DgNoSourceReturnRecordEo eo : list) {
            Mutex lock;
            block9: {
                block8: {
                    lock = null;
                    lock = this.lockService.lock("batchCreateReceipts", eo.getReturnRecordSerialNo(), 30, 60, TimeUnit.SECONDS);
                    DgNoSourceReturnRecordEo returnRecordEo = (DgNoSourceReturnRecordEo)((IDgNoSourceReturnRecordDomain)this.domain).selectByPrimaryKey(eo.getId());
                    if (!Objects.equals(returnRecordEo.getMatchStatus(), DgAfterNoSourceReturnMatchStatusEnum.MATCH_SUCCESS.getCode())) break block8;
                    if (!Objects.nonNull(lock)) continue;
                    this.lockService.unlock(lock);
                    continue;
                }
                try {
                    DgNoSourceReturnRecordDto noSourceReturnRecordDto = new DgNoSourceReturnRecordDto();
                    CubeBeanUtils.copyProperties((Object)noSourceReturnRecordDto, (Object)eo, (String[])new String[0]);
                    boolean result = this.match(noSourceReturnRecordDto);
                    CubeBeanUtils.copyProperties((Object)eo, (Object)noSourceReturnRecordDto, (String[])new String[0]);
                    if (result) {
                        successList.add(eo);
                        break block9;
                    }
                    failList.add(eo);
                }
                catch (Exception e) {
                    try {
                        log.error("matchRecord\u5f02\u5e38", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (Objects.nonNull(lock)) {
                            this.lockService.unlock(lock);
                        }
                        throw throwable;
                    }
                    if (!Objects.nonNull(lock)) continue;
                    this.lockService.unlock(lock);
                    continue;
                }
            }
            if (!Objects.nonNull(lock)) continue;
            this.lockService.unlock(lock);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public InOtherStorageOrderDto addOtherStorageOrder(List<DgNoSourceReturnRecordEo> list, Date bizDate, String type) {
        DgNoSourceReturnRecordEo eo = list.get(0);
        if (StringUtils.isBlank((CharSequence)eo.getZszfLogicWarehouseCode())) {
            log.info("\u6ca1\u6709\u6742\u6536\u6742\u53d1\u903b\u8f91\u4ed3\u7f16\u7801\u6216\u8005\u65e0\u5e97\u94fa\u4fe1\u606f,\u65e0\u6cd5\u751f\u6210\u6742\u6536\u6742\u53d1\u5e93\u5b58\u5355\u636e");
            this.update(list, type, null);
            return null;
        }
        DgShopRespDto shopRespDto = new DgShopRespDto();
        shopRespDto.setSaleDeptCode("810411");
        shopRespDto.setSaleDeptName("\u7535\u5b50\u5546\u52a1\u8ba2\u5355\u7ec4\uff08\u7535\u5546\uff09\u9500\u552e\u533a\u57df\uff08\u56fd\u5185\u8425\u9500\uff09");
        shopRespDto.setOrderOrgCode("281");
        shopRespDto.setOrderOrgName("\u56fd\u5185\u8425\u9500\u4e2d\u5fc3");
        shopRespDto.setBusinessPlatformName("\u7ebf\u4e0a\u8425\u9500\u4e2d\u5fc3");
        List ids = list.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgNoSourceReturnRecordEo.class).eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, ids);
        if (Objects.equals(type, "in")) {
            queryWrapper.isNull(DgNoSourceReturnRecordEo::getClutteredOrderInNo);
        } else {
            queryWrapper.isNull(DgNoSourceReturnRecordEo::getClutteredOrderOutNo);
        }
        List dgNoSourceReturnRecordEos = ((IDgNoSourceReturnRecordDomain)this.domain).getMapper().selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dgNoSourceReturnRecordEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u4fe1\u606f,returnRecordSerialNo:{},afterOrderNo:{}", (Object)eo.getReturnRecordSerialNo(), (Object)eo.getAfterOrderNo());
            this.update(list, type, null);
            return null;
        }
        InOtherStorageOrderDto reqDto = new InOtherStorageOrderDto();
        String clutteredOrderInNo = this.noGreateUtil.generateOtherStorageOrderNo(type);
        reqDto.setStorageOrderNo(clutteredOrderInNo);
        reqDto.setBizDate(bizDate);
        reqDto.setCommitType("autoComplete");
        reqDto.setType(Objects.equals(type, "in") ? "other_in" : "other_out");
        reqDto.setBusinessType(Objects.equals(type, "in") ? "WUTOUJIANTUIHUORUKU" : "WUTOUJIANTUIHUOCHUKU");
        reqDto.setBusinessTypeName(Objects.equals(type, "in") ? "\u65e0\u5934\u4ef6\u9000\u8d27\u5165\u5e93" : "\u65e0\u5934\u4ef6\u9000\u8d27\u51fa\u5e93");
        reqDto.setPreOrderNo(eo.getAfterOrderNo());
        reqDto.setExternalOrderNo(eo.getPlatformOrderNo());
        reqDto.setWarehouseCode(eo.getZszfLogicWarehouseCode());
        reqDto.setWarehouseName(eo.getZszfLogicWarehouseName());
        reqDto.setBusinessTypeGroup(Objects.equals(type, "in") ? "WANHEZASHOU" : "WANHEZAFA");
        reqDto.setBusinessTypeGroupName(Objects.equals(type, "in") ? "\u4e07\u548c\u6742\u6536" : "\u4e07\u548c\u6742\u53d1");
        reqDto.setCustomerCode(eo.getCustomerCode());
        reqDto.setCustomerName(eo.getCustomerName());
        reqDto.setPlatformId(eo.getBusinessPlatformId());
        reqDto.setPlatformName(eo.getBusinessPlatformName());
        reqDto.setProvinceName(eo.getProvinceName());
        reqDto.setCityName(eo.getCityName());
        reqDto.setAreaName(eo.getDistrictName());
        reqDto.setOperatorTeamCode(eo.getSaleAreaCode());
        reqDto.setOperatorTeamName(eo.getSaleAreaName());
        reqDto.setRemark(Objects.equals(type, "in") ? StringUtils.join((Iterable)list.stream().map(DgNoSourceReturnRecordEo::getReturnRecordSerialNo).collect(Collectors.toList()), (String)",") : list.stream().map(DgNoSourceReturnRecordEo::getClutteredOrderInNo).distinct().collect(Collectors.joining(",")));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("platformName", (Object)shopRespDto.getBusinessPlatformName());
        jsonObject.put("whDepartmentCode", (Object)shopRespDto.getSaleDeptCode());
        jsonObject.put("whDepartmentName", (Object)shopRespDto.getSaleDeptName());
        jsonObject.put("u9OrgCode", (Object)shopRespDto.getOrderOrgCode());
        jsonObject.put("u9OrgName", (Object)shopRespDto.getOrderOrgName());
        jsonObject.put("deptOrgCode", (Object)shopRespDto.getOrderOrgCode());
        jsonObject.put("deptOrgName", (Object)shopRespDto.getOrderOrgName());
        reqDto.setExtension(jsonObject.toJSONString());
        ArrayList updateIds = new ArrayList(list.size());
        ArrayList inOtherStorageOrderDetailDtos = new ArrayList(list.size());
        BigDecimal total = BigDecimal.ZERO;
        dgNoSourceReturnRecordEos.forEach(eo1 -> {
            updateIds.add(eo1.getId());
            InOtherStorageOrderDetailDto detailDto = new InOtherStorageOrderDetailDto();
            detailDto.setSkuCode(eo1.getSkuCode());
            detailDto.setSkuName(eo1.getSkuName());
            detailDto.setStorageOrderNo(clutteredOrderInNo);
            detailDto.setQuantity(eo1.getItemNum());
            inOtherStorageOrderDetailDtos.add(detailDto);
            total.add(eo1.getItemNum());
        });
        reqDto.setTotalQuantity(total);
        reqDto.setInOtherStorageOrderDetailDtos(inOtherStorageOrderDetailDtos);
        log.info("\u751f\u6210\u6742\u6536\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Long invId = null;
        try {
            invId = (Long)RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.addOtherStorageOrder(reqDto));
            log.info("\u6279\u91cf\u751f\u6210\u6742\u6536\u5355,\u5e93\u5b58\u5355\u53f7\uff1a{}, \u5e93\u5b58\u4e2d\u5fc3\u8fd4\u56deid\uff1a{}, ids\uff1a{}", new Object[]{clutteredOrderInNo, invId, updateIds});
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u751f\u6210\u6742\u6536/\u6742\u53d1\u5355\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            reqDto = null;
        }
        this.update(dgNoSourceReturnRecordEos, type, reqDto != null ? clutteredOrderInNo : null);
        return reqDto;
    }

    public void update(List<DgNoSourceReturnRecordEo> list, String type, String clutteredOrderInNo) {
        log.info("\u66f4\u65b0\u552e\u540e\u9000\u8d27\u5339\u914d\u4fe1\u606fsize={},type={},orderNo={}", new Object[]{list.size(), type, clutteredOrderInNo});
        list.forEach(a -> {
            if (clutteredOrderInNo != null) {
                if (Objects.equals(type, "in")) {
                    a.setClutteredOrderInNo(clutteredOrderInNo);
                    a.setGenerateClutteredOrderInStatus(YesOrNoEnum.YES.getType());
                } else {
                    a.setClutteredOrderOutNo(clutteredOrderInNo);
                    a.setGenerateClutteredOrderOutStatus(YesOrNoEnum.YES.getType());
                }
            }
            a.setScanCodeCheckoutStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)a.getSnCode()) ? 1 : 0));
            a.setMatchPerson(DgNoSourceReturnRecordServiceImpl.getMatchPerson());
            a.setMatchTime(new Date());
            ((IDgNoSourceReturnRecordDomain)this.domain).updateSelective((BaseEo)a);
        });
    }

    private void releaseLocks(List<Mutex> locks) {
        locks.forEach(lock -> {
            if (Objects.nonNull(lock)) {
                this.lockService.unlock(lock);
            }
        });
    }

    private List<AdjustmentOrderDto> buildAdjustmentOrderReqDto(List<DgNoSourceReturnRecordEo> matchedRecords, List<DgAfterSaleOrderItemEo> afterSaleOrderItemEos, Map<String, ItemSkuDgRespDto> itemSkuDtoMap) {
        ArrayList<AdjustmentOrderDto> adjumentOrderDtoList = new ArrayList<AdjustmentOrderDto>();
        HashMap usedNumMap = new HashMap();
        Map<String, List<DgAfterSaleOrderItemEo>> itemGroup = afterSaleOrderItemEos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getSkuCode));
        HashMap<DgAfterSaleOrderItemEo, List> matchedMap = new HashMap<DgAfterSaleOrderItemEo, List>();
        matchedRecords = new ArrayList<DgNoSourceReturnRecordEo>(matchedRecords);
        matchedRecords.sort(Comparator.comparing(DgNoSourceReturnRecordEo::getItemNum).reversed());
        matchedRecords.forEach(mr -> {
            int mrItemNum = Optional.ofNullable(mr.getItemNum()).map(BigDecimal::intValue).orElse(0);
            HashMap<DgAfterSaleOrderItemEo, Integer> matchItemMap = new HashMap<DgAfterSaleOrderItemEo, Integer>();
            List sameModelSkuCodes = Optional.ofNullable(mr.getSameModelSkuCodes()).orElse(Collections.emptyList());
            List items = sameModelSkuCodes.stream().map(itemGroup::get).filter(Objects::nonNull).flatMap(Collection::stream).sorted(Comparator.comparing(item -> {
                Integer usedNum = usedNumMap.getOrDefault(item.getId(), 0);
                Integer itemNum = Optional.ofNullable(item.getItemNum()).orElse(0);
                int canMathNum = itemNum - usedNum;
                if (Objects.equals(item.getSkuCode(), mr.getSkuCode()) && Objects.equals(itemNum, canMathNum)) {
                    return -10;
                }
                if (Objects.equals(itemNum, canMathNum)) {
                    return -5;
                }
                return 0;
            })).collect(Collectors.toList());
            for (DgAfterSaleOrderItemEo item2 : items) {
                if (mrItemNum <= 0) continue;
                Integer usedNum = usedNumMap.getOrDefault(item2.getId(), 0);
                Integer itemNum = Optional.ofNullable(item2.getItemNum()).orElse(0);
                int canMathNum = itemNum - usedNum;
                if (canMathNum <= 0) continue;
                int matchNum = Math.min(canMathNum, mrItemNum);
                usedNum = usedNum + matchNum;
                usedNumMap.put(item2.getId(), usedNum);
                matchItemMap.put(item2, matchNum);
            }
            matchItemMap.forEach((it, matchedNum) -> {
                log.info("\u5339\u914d\u8bb0\u5f55 {}: skuCode={} \u5339\u914d\u7ed3\u679c\uff1a{} - {}", new Object[]{mr.getId(), mr.getSkuCode(), it.getSkuCode(), matchedNum});
                List list = matchedMap.computeIfAbsent((DgAfterSaleOrderItemEo)it, aLong -> new ArrayList());
                list.add(new DgNoSourceReturnRecordMatchDto(it, mr, matchedNum));
            });
        });
        matchedMap.forEach((afterSaleOrderItemEo, rs) -> {
            String afterOrderItemSkuSpecification;
            DgNoSourceReturnRecordEo tmpRecord = ((DgNoSourceReturnRecordMatchDto)rs.get(0)).getNoSourceReturnRecord();
            AdjustmentOrderDto adjumentOrderDto = new AdjustmentOrderDto();
            adjumentOrderDto.setAdjustmentOrderDetailDtos(new ArrayList());
            adjumentOrderDto.setExternalOrderNo(tmpRecord.getAfterOrderNo());
            adjumentOrderDto.setEvent("audit_success");
            adjumentOrderDto.setOrderType("INVENTORY_ADJUSTMENT");
            adjumentOrderDto.setInventoryProperty("qualified");
            adjumentOrderDto.setPushSap(Integer.valueOf(0));
            adjumentOrderDto.setPushWms(Integer.valueOf(0));
            adjumentOrderDto.setBusinessType(AdjustmentBusinessTypeEnum.INVENTORY_TRANSFORM.getType());
            adjumentOrderDto.setBizDate(new Date());
            adjumentOrderDto.setWarehouseCode(tmpRecord.getSigningWarehouseCode());
            adjumentOrderDto.setWarehouseName(tmpRecord.getSigningWarehouseName());
            LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(tmpRecord.getSigningWarehouseCode()).getData();
            if (logicalWarehouseRespDto != null) {
                adjumentOrderDto.setOrganizationCode(logicalWarehouseRespDto.getOrganizationCode());
                adjumentOrderDto.setOrganizationName(logicalWarehouseRespDto.getOrganizationName());
            }
            adjumentOrderDto.setPhysicsWarehouseCode(tmpRecord.getPhysicsSigningWarehouseCode());
            adjumentOrderDto.setPhysicsWarehouseName(tmpRecord.getPhysicsSigningWarehouseName());
            adjumentOrderDto.setAfterSaleOrderItemId(afterSaleOrderItemEo.getId());
            ArrayList detailDtos = Lists.newArrayList();
            AdjustmentOrderDetailDto decrease = new AdjustmentOrderDetailDto();
            decrease.setSkuCode(afterSaleOrderItemEo.getSkuCode());
            decrease.setSkuName(afterSaleOrderItemEo.getSkuName());
            decrease.setSpuCode(afterSaleOrderItemEo.getItemCode());
            decrease.setSpuName(afterSaleOrderItemEo.getItemName());
            decrease.setChangeType("decrease");
            decrease.setInventoryProperty("qualified");
            Integer itemNum = rs.stream().map(DgNoSourceReturnRecordMatchDto::getMatchedNum).reduce(0, Integer::sum);
            decrease.setChangeQuantity(new BigDecimal(itemNum));
            ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)itemSkuDtoMap.get(afterSaleOrderItemEo.getSkuCode());
            String string = afterOrderItemSkuSpecification = itemSkuDgRespDto == null ? "" : itemSkuDgRespDto.getSpuName();
            if (itemSkuDgRespDto != null) {
                decrease.setUnit(itemSkuDgRespDto.getUnit());
            }
            detailDtos.add(decrease);
            HashMap<String, List> group = new HashMap<String, List>();
            rs.forEach(r -> {
                List list = group.computeIfAbsent(r.getNoSourceReturnRecord().getSkuCode(), v -> new ArrayList());
                list.add(r);
                DgNoSourceReturnRecordEo vo = r.getNoSourceReturnRecord();
                adjumentOrderDto.getNoSourceReturnRecordIds().add(vo.getId());
                vo.setAfterOrderItemSkuCode(afterSaleOrderItemEo.getSkuCode());
                vo.setAfterOrderItemSkuSpecification(afterOrderItemSkuSpecification);
            });
            group.forEach((skuCode, vs) -> {
                DgNoSourceReturnRecordMatchDto r = (DgNoSourceReturnRecordMatchDto)vs.get(0);
                DgNoSourceReturnRecordEo vo = r.getNoSourceReturnRecord();
                AdjustmentOrderDetailDto increase = new AdjustmentOrderDetailDto();
                increase.setSkuCode(vo.getSkuCode());
                increase.setSkuName(vo.getSkuName());
                increase.setChangeType("increase");
                increase.setInventoryProperty("qualified");
                Integer matchedNum = vs.stream().map(DgNoSourceReturnRecordMatchDto::getMatchedNum).reduce(0, Integer::sum);
                increase.setChangeQuantity(new BigDecimal(matchedNum));
                ItemSkuDgRespDto skuInfo = (ItemSkuDgRespDto)itemSkuDtoMap.get(vo.getSkuCode());
                if (skuInfo != null) {
                    increase.setUnit(skuInfo.getUnit());
                    increase.setSpuCode(skuInfo.getSpuCode());
                    increase.setSpuName(skuInfo.getSpuName());
                }
                detailDtos.add(increase);
            });
            adjumentOrderDto.setAdjustmentOrderDetailDtos((List)detailDtos);
            adjumentOrderDtoList.add(adjumentOrderDto);
        });
        return adjumentOrderDtoList;
    }
}

