/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.convert.entity.DgPaymentRateConfigConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPaymentRateConfigDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPaymentRateConfigDto;
import com.yunxi.dg.base.center.trade.eo.DgPaymentRateConfigEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPaymentRateConfigService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DgPaymentRateConfigServiceImpl
extends BaseServiceImpl<DgPaymentRateConfigDto, DgPaymentRateConfigEo, IDgPaymentRateConfigDomain>
implements IDgPaymentRateConfigService {
    public DgPaymentRateConfigServiceImpl(IDgPaymentRateConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPaymentRateConfigDto, DgPaymentRateConfigEo> converter() {
        return DgPaymentRateConfigConverter.INSTANCE;
    }

    @Override
    public DgPaymentRateConfigDto selectByEnterpriseCode(String enterpriseCode) {
        DgPaymentRateConfigDto dgPaymentRateConfigDto = null;
        if (enterpriseCode == null) {
            return dgPaymentRateConfigDto;
        }
        DgPaymentRateConfigEo dgPaymentRateConfigEo = new DgPaymentRateConfigEo();
        dgPaymentRateConfigEo.setEnterpriseCode(enterpriseCode);
        dgPaymentRateConfigEo = (DgPaymentRateConfigEo)((IDgPaymentRateConfigDomain)this.domain).selectOne((BaseEo)dgPaymentRateConfigEo);
        if (dgPaymentRateConfigEo != null) {
            dgPaymentRateConfigDto = new DgPaymentRateConfigDto();
            BeanUtil.copyProperties((Object)dgPaymentRateConfigEo, (Object)dgPaymentRateConfigDto, (String[])new String[0]);
        }
        return dgPaymentRateConfigDto;
    }

    @Override
    public List<DgPaymentRateConfigDto> selectByEnterpriseCodes(List<String> enterpriseCodes) {
        AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty(enterpriseCodes), (String)"\u9500\u552e\u516c\u53f8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (enterpriseCodes == null) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.in(DgPaymentRateConfigEo::getEnterpriseCode, enterpriseCodes)).eq(BaseEo::getDr, (Object)0);
        List dgPaymentRateConfigEos = ((IDgPaymentRateConfigDomain)this.domain).getMapper().selectList((Wrapper)wrapper);
        List paymentRateConfigDtos = BeanUtil.copyToList((Collection)dgPaymentRateConfigEos, DgPaymentRateConfigDto.class);
        return paymentRateConfigDtos;
    }

    @Override
    public DgPaymentRateConfigDto selectOne(DgPaymentRateConfigDto dgPaymentRateConfigDto) {
        DgPaymentRateConfigEo dgPaymentRateConfigEo = (DgPaymentRateConfigEo)((IDgPaymentRateConfigDomain)this.domain).selectOne(this.converter().toEo((BaseDto)dgPaymentRateConfigDto));
        return (DgPaymentRateConfigDto)this.converter().toDto((BaseEo)dgPaymentRateConfigEo);
    }
}

