/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.ObjectConvertor;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.enums.OrderAddrApplyAuditStatusEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgAddressRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerInfoRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgAddressQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.tob.IDgTobAddressApiProxy;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2BSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgF2BOrderStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformOrderAddrApplyConverter;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformOrderAddrApplyLineConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAddrApplyLineDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAddrDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrApplyDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderAddrApplyService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderAddrApplyServiceImpl
extends BaseServiceImpl<DgPerformOrderAddrApplyDto, DgPerformOrderAddrApplyEo, IDgPerformOrderAddrApplyDomain>
implements IDgPerformOrderAddrApplyService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderAddrApplyServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgB2BSaleStatemachineApi dgB2BSaleStatemachineApi;
    @Resource
    private IDgF2BOrderStatemachineApi dgF2BOrderStatemachineApi;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgPerformOrderAddrDas dgPerformOrderAddrDas;
    @Resource
    private IDgAddressQueryApiProxy dgAddressQueryApiProxy;
    @Resource
    private IDgTobAddressApiProxy dgTobAddressApiProxy;
    @Resource
    private IDgPerformOrderAddrApplyLineDas dgPerformOrderAddrApplyLineDas;
    @Resource
    private IContext context;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private ITransactionCustomerQueryApiProxy transactionCustomerQueryApiProxy;
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;

    public DgPerformOrderAddrApplyServiceImpl(IDgPerformOrderAddrApplyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformOrderAddrApplyDto, DgPerformOrderAddrApplyEo> converter() {
        return DgPerformOrderAddrApplyConverter.INSTANCE;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> insert(DgPerformOrderAddrApplyDto dto) {
        log.info("\u65b0\u589e\u5730\u5740\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        long count = 0L;
        HashMap customerCompMap = Maps.newHashMap();
        DgPerformOrderAddrApplyDto applyDto = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrApplyDto.class, (String[])new String[0]);
        for (DgPerformOrderAddrApplyLineDto applyLineDto : dto.getApplyLineDtos()) {
            AssertUtils.isTrue((applyLineDto.getOrderAddrId() != null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5730\u5740ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((applyLineDto.getOrderId() != null ? 1 : 0) != 0, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            DgPerformOrderRespDto orderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoById(applyLineDto.getOrderId());
            DgOrderConfigurationRespDto dgOrderConfigurationRespDto = this.dgOrderConfigurationService.queryDetailByShopCode(orderRespDto.getPerformOrderSnapshotDto().getShopCode());
            AssertUtils.notNull((Object)dgOrderConfigurationRespDto, (String)"\u8ba2\u5355\u914d\u7f6e\u4e0d\u5b58\u5728");
            if (!customerCompMap.containsKey(orderRespDto.getPerformOrderSnapshotDto().getCustomerId())) {
                List customerInfoRespDtos = (List)this.transactionCustomerQueryApiProxy.queryIds((List)Lists.newArrayList((Object[])new Long[]{orderRespDto.getPerformOrderSnapshotDto().getCustomerId()})).getData();
                customerCompMap.put(orderRespDto.getPerformOrderSnapshotDto().getCustomerId(), ((DgCustomerInfoRespDto)customerInfoRespDtos.get(0)).getCompanyId());
            }
            if (Objects.equals(dgOrderConfigurationRespDto.getEnableAddressPushExternal(), EnableEnum.ENABLE.getCode())) {
                applyDto.setApplyLineDtos((List)Lists.newArrayList((Object[])new DgPerformOrderAddrApplyLineDto[]{applyLineDto}));
                Map<Integer, List<DgPerformOrderAddrApplyLineDto>> result = this.dealWithWaitCommitAddr(applyDto);
                if (!CollectionUtils.isNotEmpty((Collection)result.get(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode()))) continue;
                List<DgPerformOrderAddrApplyLineDto> lineDtos = result.get(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode());
                DgPerformOrderAddrApplyDto applyDto2 = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)applyDto, DgPerformOrderAddrApplyDto.class, (String[])new String[]{"applyLineDtos"});
                applyDto2.setApplyLineDtos(lineDtos);
                count = this.saveAndSyncOa(Lists.newArrayList((Object[])new DgPerformOrderAddrApplyDto[]{applyDto2}));
                continue;
            }
            DgPerformOrderAddrEo updateEo = (DgPerformOrderAddrEo)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrEo.class, (String[])new String[0]);
            AssertUtils.isTrue((applyLineDto.getOrderAddrId() != null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5730\u5740ID\u4e0d\u80fd\u4e3a\u7a7a");
            updateEo.setId(applyLineDto.getOrderAddrId());
            this.dgPerformOrderAddrDomain.updateSelective((BaseEo)updateEo);
            List orderRespDtoList = this.dgOmsOrderInfoQueryDomain.queryDtoByPlatformId(applyLineDto.getOrderId());
            for (DgPerformOrderRespDto dgPerformOrderRespDto : orderRespDtoList) {
                DgPerformOrderAddrEo b2bOrderAddrEo = (DgPerformOrderAddrEo)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrEo.class, (String[])new String[0]);
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"order_id", (Object)dgPerformOrderRespDto.getId());
                this.dgPerformOrderAddrDomain.getMapper().update((Object)b2bOrderAddrEo, (Wrapper)updateWrapper);
            }
            if (Objects.equals(applyDto.getChangeType(), 1)) {
                if (applyLineDto.getOrderAddrId() == null) {
                    DgPerformOrderRespDto dgPerformOrderRespDto;
                    DgAddressAddReqDto addressAddReqDto = new DgAddressAddReqDto();
                    addressAddReqDto.setProvince(dto.getProvince());
                    addressAddReqDto.setProvinceCode(dto.getProvinceCode());
                    addressAddReqDto.setCity(dto.getCity());
                    addressAddReqDto.setCityCode(dto.getCityCode());
                    addressAddReqDto.setDistrict(dto.getCounty());
                    addressAddReqDto.setDistrictCode(dto.getCountyCode());
                    addressAddReqDto.setDetailAddr(dto.getReceiveAddress());
                    addressAddReqDto.setContact(dto.getReceiveName());
                    addressAddReqDto.setPhone(dto.getReceivePhone());
                    addressAddReqDto.setCustomerId(orderRespDto.getPerformOrderSnapshotDto().getCustomerId());
                    addressAddReqDto.setCustomerCode(orderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
                    addressAddReqDto.setOrgInfoId((Long)customerCompMap.get(orderRespDto.getPerformOrderSnapshotDto().getCustomerId()));
                    addressAddReqDto.setIsDefault(Optional.ofNullable(applyDto.getIsDefault()).orElse(0));
                    addressAddReqDto.setAddressType("1");
                    log.info("\u65b0\u589e\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)addressAddReqDto));
                    dgPerformOrderRespDto = this.dgTobAddressApiProxy.addCustomerAddress(addressAddReqDto);
                } else {
                    DgAddressRespDto addressRespDto = (DgAddressRespDto)this.dgAddressQueryApiProxy.queryAddressById(applyLineDto.getAddressId()).getData();
                    DgAddressModifyReqDto modifyReqDto = (DgAddressModifyReqDto)ObjectConvertor.convert((Object)addressRespDto, DgAddressModifyReqDto.class);
                    modifyReqDto.setProvince(dto.getProvince());
                    modifyReqDto.setProvinceCode(dto.getProvinceCode());
                    modifyReqDto.setCity(dto.getCity());
                    modifyReqDto.setCityCode(dto.getCityCode());
                    modifyReqDto.setDistrict(dto.getCounty());
                    modifyReqDto.setDistrictCode(dto.getCountyCode());
                    modifyReqDto.setDetailAddr(dto.getReceiveAddress());
                    modifyReqDto.setContact(dto.getReceiveName());
                    modifyReqDto.setPhone(dto.getReceivePhone());
                    modifyReqDto.setIsDefault(Optional.ofNullable(applyDto.getIsDefault()).orElse(0));
                    log.info("\u4fee\u6539\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
                    RestResponse restResponse = this.dgTobAddressApiProxy.updateCustomerAddress(modifyReqDto);
                }
            }
            ++count;
        }
        return new RestResponse((Object)count);
    }

    private Long saveAndSyncOa(List<DgPerformOrderAddrApplyDto> dtos) {
        long count = 0L;
        for (DgPerformOrderAddrApplyDto dto : dtos) {
            dto.setAuditStatus(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode());
            dto.setUserId(this.context.userId());
            dto.setUpdatePerson(this.context.userName());
            ArrayList saveList = Lists.newArrayList();
            StringBuilder sb = new StringBuilder();
            for (DgPerformOrderAddrApplyLineDto lineDto : dto.getApplyLineDtos()) {
                String result;
                ArrayList addressIds = null;
                if (Objects.equals(dto.getChangeType(), 1) && lineDto.getAddressId() != null) {
                    addressIds = Lists.newArrayList((Object[])new Long[]{lineDto.getAddressId()});
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result = this.lockOrder(lineDto.getOrderId(), addressIds)})) {
                    sb.append(result);
                    continue;
                }
                DgPerformOrderAddrApplyLineEo lineEo = (DgPerformOrderAddrApplyLineEo)DgPerformOrderAddrApplyLineConverter.INSTANCE.toEo((BaseDto)lineDto);
                saveList.add(lineEo);
            }
            if (dtos.size() == 1 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sb.toString()})) {
                throw new BizException(sb.toString());
            }
            if (!CollectionUtils.isNotEmpty((Collection)saveList)) continue;
            if (dto.getIsDefault() == null) {
                dto.setIsDefault(Integer.valueOf(0));
            }
            RestResponse res = super.insert((BaseDto)dto);
            for (DgPerformOrderAddrApplyLineEo eo : saveList) {
                eo.setApplyId((Long)res.getData());
                this.dgPerformOrderAddrApplyLineDas.insert((BaseEo)eo);
            }
            dto.setId((Long)res.getData());
            ++count;
        }
        if (count > 0L) {
            this.sendPushOaMsg(dtos);
        }
        return count;
    }

    @Override
    public void lockPMSOrder(Long orderId, boolean isLock) {
        DgPerformOrderInfoEo orderInfoEo;
        if (isLock && !Objects.equals((orderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId)).getOrderStatus(), DgF2BOrderStatus.WAIT_PICK.getCode()) && !Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_OUT_STORAGE.getCode())) {
            log.info("\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u914d\u8d27\u3001\u5f85\u53d1\u8d27\uff0c\u4e0d\u7528\u6302\u8d77\u4f9b\u5e94\u94fe\u8ba2\u5355\uff1a{}", (Object)orderId);
            return;
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(DgPerformOrderInfoEo::getBizModel, (Object)DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode());
        lqw.eq(DgPerformOrderInfoEo::getPlatformOrderId, (Object)orderId);
        List infoEos = this.dgPerformOrderInfoDomain.getMapper().selectList((Wrapper)lqw);
        if (CollectionUtils.isEmpty((Collection)infoEos)) {
            log.info("PMS\u9500\u552e\u8ba2\u5355\u8fd8\u672a\u751f\u6210\uff0c\u8df3\u8fc7\u6302\u8d77\u3001\u89e3\u6302\u64cd\u4f5c");
            return;
        }
        ArrayList lockList = Lists.newArrayList();
        for (DgPerformOrderInfoEo eo : infoEos) {
            lockList.add(eo.getId());
        }
        for (Long oid : lockList) {
            if (isLock) {
                log.info("\u5f00\u59cb\u6302\u8d77\u4f9b\u5e94\u94fe\u8ba2\u5355:{}", (Object)oid);
                this.dgB2BSaleStatemachineApi.statusLock(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), oid, "StatusLock");
                continue;
            }
            log.info("\u5f00\u59cb\u89e3\u6302\u4f9b\u5e94\u94fe\u8ba2\u5355:{}", (Object)oid);
            this.dgB2BSaleStatemachineApi.statusUnLock(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), oid, "StatusUnLock");
        }
    }

    public RestResponse<Integer> update(DgPerformOrderAddrApplyDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u4fee\u6539ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(dto, dto.getApplyLineDtos());
        return new RestResponse();
    }

    private Map<Integer, List<DgPerformOrderAddrApplyLineDto>> checkParam(DgPerformOrderAddrApplyDto dto, List<DgPerformOrderAddrApplyLineDto> lineDtos) {
        dto.setUpdateTime(new Date());
        dto.setUpdatePerson(this.context.userName());
        AssertUtils.notEmpty(lineDtos, (String)"\u4fee\u6539\u5730\u5740\u5173\u8054\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList orderIds = Lists.newArrayList();
        ArrayList orderAddrIds = Lists.newArrayList();
        for (DgPerformOrderAddrApplyLineDto line : lineDtos) {
            AssertUtils.notNull((Object)line.getOrderId(), (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            orderIds.add(line.getOrderId());
            orderAddrIds.add(line.getOrderAddrId());
        }
        AssertUtils.notNull((Object)dto.getChangeType(), (String)"\u4fee\u6539\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((Objects.equals(dto.getChangeType(), 0) || Objects.equals(dto.getChangeType(), 1) ? 1 : 0) != 0, (String)"\u4fee\u6539\u7c7b\u578b\u4ec5\u652f\u6301\uff1a0\u62161");
        AssertUtils.notBlank((String)dto.getReceiveName(), (String)"\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getReceiveAddress(), (String)"\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getProvince(), (String)"\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getProvinceCode(), (String)"\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCity(), (String)"\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCityCode(), (String)"\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCounty(), (String)"\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getCountyCode(), (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List orderInfoEos = this.dgPerformOrderInfoDomain.queryListByOrderIds((List)orderIds);
        AssertUtils.notEmpty((Collection)orderInfoEos, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List existOrderNos = this.dgPerformOrderAddrApplyLineDas.queryWaitAuditSaleOrderNo((List)orderIds);
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)existOrderNos), (String)StringUtils.join((Object[])new String[]{"\u8ba2\u5355\u53f7\uff1a", JSON.toJSONString((Object)existOrderNos), ", \u5df2\u5b58\u5728\u5f85\u5ba1\u6838\u8bb0\u5f55\uff0c\u8bf7\u5148\u5728OA\u5ba1\u6838\u4e4b\u540e\u518d\u63d0\u4ea4"}));
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(DgPerformOrderAddrEo::getOrderId, (Collection)orderIds);
        lqw.in(BaseEo::getId, (Collection)orderAddrIds);
        List addrEos = this.dgPerformOrderAddrDomain.getMapper().selectList((Wrapper)lqw);
        Map oMap = orderInfoEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map lineDtoMap = lineDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrApplyLineDto::getOrderId, Function.identity()));
        Map addrEoMap = addrEos.stream().collect(Collectors.toMap(DgPerformOrderAddrEo::getOrderId, Function.identity()));
        HashMap result = Maps.newHashMap();
        for (Long oid : orderIds) {
            DgPerformOrderInfoEo orderInfoEo = (DgPerformOrderInfoEo)oMap.get(oid);
            AssertUtils.notNull((Object)orderInfoEo, (String)"\u8ba2\u5355ID\u4e0d\u5b58\u5728");
            boolean changeable = Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_CHECK.getCode()) || Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_CS_AUDIT.getCode()) || Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_FINANCE_AUDIT.getCode()) || Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_PAY.getCode()) || Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_PICK.getCode()) || Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_OUT_STORAGE.getCode());
            AssertUtils.isTrue((boolean)changeable, (String)StringUtils.join((Object[])new String[]{"\u8ba2\u5355:", orderInfoEo.getSaleOrderNo(), ",\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u5730\u5740"}));
            DgPerformOrderAddrApplyLineDto alDto = (DgPerformOrderAddrApplyLineDto)lineDtoMap.get(oid);
            alDto.setSaleOrderNo(orderInfoEo.getSaleOrderNo());
            alDto.setOrderStatus(DgF2BOrderStatus.forCode((String)orderInfoEo.getOrderStatus()).getDesc());
            DgPerformOrderAddrEo orderAddrEo = (DgPerformOrderAddrEo)addrEoMap.get(oid);
            alDto.setPhoneNumber(orderAddrEo.getReceivePhone());
            alDto.setRecipientName(orderAddrEo.getReceiveName());
            alDto.setProvinceCityDistrict(StringUtils.join((Object[])new String[]{orderAddrEo.getProvince(), orderAddrEo.getCity(), orderAddrEo.getCounty()}));
            alDto.setDetailedAddress(orderAddrEo.getReceiveAddress());
            if (dto.getChanged() != null && !dto.getChanged().booleanValue() && Objects.equals(dto.getChangeType(), 1)) {
                if (!result.containsKey(OrderAddrApplyAuditStatusEnum.PASS.getCode())) {
                    result.put(OrderAddrApplyAuditStatusEnum.PASS.getCode(), Lists.newArrayList());
                }
                ((List)result.get(OrderAddrApplyAuditStatusEnum.PASS.getCode())).add(alDto);
                continue;
            }
            if (Objects.equals(orderInfoEo.getOrderStatus(), DgF2BOrderStatus.WAIT_CHECK.getCode())) {
                if (!result.containsKey(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode())) {
                    result.put(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode(), Lists.newArrayList());
                }
                ((List)result.get(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode())).add(alDto);
                continue;
            }
            if (!result.containsKey(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode())) {
                result.put(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode(), Lists.newArrayList());
            }
            ((List)result.get(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode())).add(alDto);
        }
        return result;
    }

    @Override
    public Integer updateRequestId(DgPerformOrderAddrApplyDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u66f4\u65b0ID\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderAddrApplyEo applyEo = new DgPerformOrderAddrApplyEo();
        applyEo.setId(dto.getId());
        applyEo.setRequestId(dto.getRequestId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getEmployeeNo()})) {
            applyEo.setEmployeeNo(dto.getEmployeeNo());
        }
        return ((IDgPerformOrderAddrApplyDomain)this.domain).updateSelective((BaseEo)applyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer audit(DgPerformOrderAddrApplyDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5730\u5740\u4fee\u6539\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)dto.getEmployeeNo(), (String)"OA\u5ba1\u6279\u8bf7\u6c42\u5458\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getAuditStatus(), (String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((Objects.equals(dto.getAuditStatus(), 1) || Objects.equals(dto.getAuditStatus(), 2) ? 1 : 0) != 0, (String)"\u5ba1\u6838\u72b6\u6001\u53c2\u6570\u5f02\u5e38");
        AssertUtils.notBlank((String)dto.getEmployeeNo(), (String)"OA\u5ba1\u6279\u8bf7\u6c42\u5458\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BaseEo::getId, (Object)dto.getId());
        lqw.eq(DgPerformOrderAddrApplyEo::getAuditStatus, (Object)0);
        List addrApplyEos = ((IDgPerformOrderAddrApplyDomain)this.domain).getMapper().selectList((Wrapper)lqw);
        AssertUtils.notEmpty((Collection)addrApplyEos, (String)"\u672a\u627e\u5230\u5f85\u5ba1\u6838\u8bb0\u5f55");
        HashMap customerCompMap = Maps.newHashMap();
        HashMap companyAddressMap = Maps.newHashMap();
        HashSet savedAddressIds = Sets.newHashSet();
        for (DgPerformOrderAddrApplyEo addrApplyEo : addrApplyEos) {
            DgPerformOrderAddrApplyEo applyEo = new DgPerformOrderAddrApplyEo();
            applyEo.setId(addrApplyEo.getId());
            applyEo.setAuditStatus(dto.getAuditStatus());
            applyEo.setAuditTime(dto.getAuditTime());
            applyEo.setAuditRemark(dto.getAuditRemark());
            LambdaQueryWrapper lqwLine = Wrappers.lambdaQuery();
            lqwLine.eq(DgPerformOrderAddrApplyLineEo::getApplyId, (Object)addrApplyEo.getId());
            List applyEos = this.dgPerformOrderAddrApplyLineDas.getMapper().selectList((Wrapper)lqwLine);
            for (DgPerformOrderAddrApplyLineEo applyLineEo : applyEos) {
                HashSet orderIds = Sets.newHashSet();
                orderIds.add(applyLineEo.getOrderId());
                if (Objects.equals(addrApplyEo.getChangeType(), 1) && applyLineEo.getAddressId() != null) {
                    List dgPerformOrderAddrEos = this.dgPerformOrderAddrDomain.queryCustomerOrderAddressById(applyLineEo.getOrderId(), applyLineEo.getAddressId());
                    for (DgPerformOrderAddrEo dgPerformOrderAddrEo : dgPerformOrderAddrEos) {
                        if (Objects.equals(applyEo.getAuditStatus(), 1)) {
                            log.info("\u66f4\u65b0\u540c\u5ba2\u6237\u4e0b\u7684\u540c\u5730\u5740id\u7684\u8ba2\u5355\u5730\u5740={}", (Object)dgPerformOrderAddrEo.getOrderId());
                            this.updateOrderAddrInfo(addrApplyEo, dgPerformOrderAddrEo.getId());
                        }
                        orderIds.add(dgPerformOrderAddrEo.getOrderId());
                    }
                }
                if (Objects.equals(applyEo.getAuditStatus(), 2)) {
                    this.dgOrderLabelRecordDomain.addOrderLabelRecord(applyLineEo.getOrderId(), DgOrderLabelEnum.ORDER_ADDRESS_REJECT);
                } else {
                    this.updateOrderAddrInfo(addrApplyEo, applyLineEo.getOrderAddrId());
                    List addrEos = this.dgPerformOrderAddrDomain.queryAddressByPlatformOrderId(applyLineEo.getOrderId(), DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)addrEos)) {
                        Iterator iterator = addrEos.iterator();
                        while (iterator.hasNext()) {
                            DgPerformOrderAddrEo eo = (DgPerformOrderAddrEo)iterator.next();
                            this.updateOrderAddrInfo(addrApplyEo, eo.getId());
                        }
                    }
                    this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(applyLineEo.getOrderId(), DgOrderLabelEnum.ORDER_ADDRESS_REJECT);
                    if (Objects.equals(addrApplyEo.getChangeType(), 1)) {
                        if (applyLineEo.getAddressId() != null) {
                            if (!savedAddressIds.contains(applyLineEo.getAddressId())) {
                                DgAddressRespDto addressRespDto = (DgAddressRespDto)this.dgAddressQueryApiProxy.queryAddressById(applyLineEo.getAddressId()).getData();
                                if (addressRespDto != null) {
                                    DgAddressModifyReqDto modifyReqDto = (DgAddressModifyReqDto)ObjectConvertor.convert((Object)addressRespDto, DgAddressModifyReqDto.class);
                                    modifyReqDto.setProvince(addrApplyEo.getProvince());
                                    modifyReqDto.setProvinceCode(addrApplyEo.getProvinceCode());
                                    modifyReqDto.setCity(addrApplyEo.getCity());
                                    modifyReqDto.setCityCode(addrApplyEo.getCityCode());
                                    modifyReqDto.setDistrict(addrApplyEo.getCounty());
                                    modifyReqDto.setDistrictCode(addrApplyEo.getCountyCode());
                                    modifyReqDto.setDetailAddr(addrApplyEo.getReceiveAddress());
                                    modifyReqDto.setContact(addrApplyEo.getReceiveName());
                                    modifyReqDto.setPhone(addrApplyEo.getReceivePhone());
                                    modifyReqDto.setIsDefault(Integer.valueOf(0));
                                    if (addrApplyEo.getIsDefault() != null) {
                                        modifyReqDto.setIsDefault(addrApplyEo.getIsDefault());
                                    }
                                    log.info("\u4fee\u6539\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
                                    RestResponse rr = this.dgTobAddressApiProxy.updateCustomerAddress(modifyReqDto);
                                    savedAddressIds.add(applyLineEo.getAddressId());
                                    log.info("\u4fee\u6539\u5ba2\u6237\u5730\u5740\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)rr));
                                } else {
                                    log.error("\u5730\u5740ID\u4e0d\u5b58\u5728\uff1a{}", (Object)applyLineEo.getAddressId());
                                }
                            }
                        } else {
                            Long companyId;
                            DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(applyLineEo.getOrderId());
                            if (!customerCompMap.containsKey(dgPerformOrderSnapshotEo.getCustomerId())) {
                                List customerInfoRespDtos = (List)this.transactionCustomerQueryApiProxy.queryIds((List)Lists.newArrayList((Object[])new Long[]{dgPerformOrderSnapshotEo.getCustomerId()})).getData();
                                customerCompMap.put(dgPerformOrderSnapshotEo.getCustomerId(), ((DgCustomerInfoRespDto)customerInfoRespDtos.get(0)).getCompanyId());
                            }
                            if (!companyAddressMap.containsKey(companyId = (Long)customerCompMap.get(dgPerformOrderSnapshotEo.getCustomerId()))) {
                                DgAddressAddReqDto addressAddReqDto = new DgAddressAddReqDto();
                                addressAddReqDto.setProvince(addrApplyEo.getProvince());
                                addressAddReqDto.setProvinceCode(addrApplyEo.getProvinceCode());
                                addressAddReqDto.setCity(addrApplyEo.getCity());
                                addressAddReqDto.setCityCode(addrApplyEo.getCityCode());
                                addressAddReqDto.setDistrict(addrApplyEo.getCounty());
                                addressAddReqDto.setDistrictCode(addrApplyEo.getCountyCode());
                                addressAddReqDto.setDetailAddr(addrApplyEo.getReceiveAddress());
                                addressAddReqDto.setContact(addrApplyEo.getReceiveName());
                                addressAddReqDto.setPhone(addrApplyEo.getReceivePhone());
                                addressAddReqDto.setCustomerId(dgPerformOrderSnapshotEo.getCustomerId());
                                addressAddReqDto.setCustomerCode(dgPerformOrderSnapshotEo.getCustomerCode());
                                addressAddReqDto.setOrgInfoId((Long)customerCompMap.get(dgPerformOrderSnapshotEo.getCustomerId()));
                                addressAddReqDto.setIsDefault(Integer.valueOf(0));
                                addressAddReqDto.setAddressType("1");
                                if (addrApplyEo.getIsDefault() != null) {
                                    addressAddReqDto.setIsDefault(addrApplyEo.getIsDefault());
                                }
                                log.info("\u65b0\u589e\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)addressAddReqDto));
                                RestResponse rr = this.dgTobAddressApiProxy.addCustomerAddress(addressAddReqDto);
                                companyAddressMap.put(companyId, rr.getData());
                                log.info("\u65b0\u589e\u5ba2\u6237\u5730\u5740\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)rr));
                            }
                            DgPerformOrderAddrEo addrEo = new DgPerformOrderAddrEo();
                            addrEo.setId(applyLineEo.getOrderAddrId());
                            addrEo.setAddressId((Long)companyAddressMap.get(companyId));
                            this.dgPerformOrderAddrDomain.updateSelective((BaseEo)addrEo);
                        }
                    }
                }
                for (Long orderId : orderIds) {
                    this.unlockOrder(orderId);
                }
                DgPerformOrderExtensionEo extensionEo = new DgPerformOrderExtensionEo();
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"order_id", (Object)applyLineEo.getOrderId());
                extensionEo.setOaAuditTime(dto.getAuditTime());
                extensionEo.setOaAuditReason(dto.getAuditRemark());
                extensionEo.setOaAuditResult(dto.getAuditStatus());
                this.dgPerformOrderExtensionDomain.getMapper().update((Object)extensionEo, (Wrapper)updateWrapper);
            }
            ((IDgPerformOrderAddrApplyDomain)this.domain).updateSelective((BaseEo)applyEo);
        }
        return 1;
    }

    private void unlockOrder(Long orderId) {
        try {
            this.lockPMSOrder(orderId, false);
            log.info("\u5f00\u59cb\u89e3\u6302\u6e20\u9053\u8ba2\u5355:{}", (Object)orderId);
            this.dgF2BOrderStatemachineApi.statusUnLock(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId, "StatusUnLock");
        }
        catch (Exception e) {
            log.error("\u89e3\u6302\u5f02\u5e38:", (Throwable)e);
        }
    }

    private String lockOrder(Long orderId, List<Long> addressIds) {
        boolean lockCurrentOrder = true;
        StringBuilder errorMsg = new StringBuilder();
        boolean lockSuccess = false;
        if (CollectionUtils.isNotEmpty(addressIds)) {
            List orderRespDtos = this.dgPerformOrderInfoDomain.queryOrderByAddressIds(addressIds);
            for (DgPerformOrderRespDto respDto : orderRespDtos) {
                boolean nodeStat = false;
                try {
                    this.lockPMSOrder(respDto.getId(), true);
                    nodeStat = true;
                    log.info("\u5f00\u59cb\u6302\u8d77\u6e20\u9053\u8ba2\u5355:{}", (Object)respDto.getId());
                    this.dgF2BOrderStatemachineApi.statusLock(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), respDto.getId(), "StatusLock");
                    lockSuccess = true;
                }
                catch (Exception e) {
                    String msg = !nodeStat ? StringUtils.join((Object[])new Serializable[]{"\u6302\u8d77\u4f9b\u5e94\u94fe\u5173\u8054\u8ba2\u5355\u5931\u8d25:", respDto.getId()}) : StringUtils.join((Object[])new Serializable[]{"\u6302\u8d77\u6e20\u9053\u8ba2\u5355\u5931\u8d25:", respDto.getId()});
                    log.error(msg, (Throwable)e);
                    errorMsg.append(msg).append(";");
                }
                if (!Objects.equals(orderId, respDto.getId())) continue;
                lockCurrentOrder = false;
            }
        }
        if (lockCurrentOrder || CollectionUtils.isEmpty(addressIds)) {
            boolean nodeStat = false;
            try {
                this.lockPMSOrder(orderId, true);
                nodeStat = true;
                log.info("\u5f00\u59cb\u6302\u8d77\u6e20\u9053\u8ba2\u5355:{}", (Object)orderId);
                this.dgF2BOrderStatemachineApi.statusLock(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId, "StatusLock");
                lockSuccess = true;
            }
            catch (Exception e) {
                String msg = !nodeStat ? StringUtils.join((Object[])new Serializable[]{"\u6302\u8d77\u4f9b\u5e94\u94fe\u5173\u8054\u8ba2\u5355\u5931\u8d25:", orderId}) : StringUtils.join((Object[])new Serializable[]{"\u6302\u8d77\u6e20\u9053\u8ba2\u5355\u5931\u8d25:", orderId});
                errorMsg.append(msg).append(";");
                log.error(msg, (Throwable)e);
            }
        }
        return lockSuccess ? "" : errorMsg.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void commitAudit(Long orderId) {
        log.info("\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u5730\u5740\u540c\u6b65\u903b\u8f91\uff1a{}", (Object)orderId);
        ArrayList orderIds = Lists.newArrayList((Object[])new Long[]{orderId});
        List addrApplyEos = ((IDgPerformOrderAddrApplyDomain)this.domain).queryWaitAuditAddrInfo((List)orderIds);
        if (CollectionUtils.isNotEmpty((Collection)addrApplyEos)) {
            List lineEos;
            DgPerformOrderAddrApplyEo applyEo = (DgPerformOrderAddrApplyEo)addrApplyEos.get(0);
            ArrayList addressIds = null;
            if (Objects.equals(applyEo.getChangeType(), 1) && applyEo.getAddressId() != null && CollectionUtils.isNotEmpty((Collection)(lineEos = this.dgPerformOrderAddrApplyLineDas.queryWaitAuditOrderId((List)(addressIds = Lists.newArrayList((Object[])new Long[]{applyEo.getAddressId()})), (List)orderIds)))) {
                throw new BizException("\u5df2\u5b58\u5728\u5f85OA\u5ba1\u6279\u7684\u5730\u5740\u4fee\u6539\u4fe1\u606f\uff0c\u5f53\u524d\u4fee\u6539\u7684\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u63d0\u4ea4");
            }
            this.lockOrder(orderId, addressIds);
            if (applyEo.getAuditStatus().equals(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode())) {
                ArrayList dtos = Lists.newArrayList();
                DgPerformOrderAddrApplyDto applyDto = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)applyEo, DgPerformOrderAddrApplyDto.class, (String[])new String[0]);
                dtos.add(applyDto);
                DgPerformOrderAddrApplyLineDto alDto = new DgPerformOrderAddrApplyLineDto();
                if (Objects.equals(applyEo.getChangeType(), 1) && applyEo.getAddressId() != null) {
                    LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
                    lqw.eq(DgPerformOrderAddrEo::getOrderId, (Object)orderId);
                    lqw.eq(DgPerformOrderAddrEo::getAddressId, (Object)applyEo.getAddressId());
                    lqw.eq(BaseEo::getDr, (Object)0);
                    DgPerformOrderAddrEo orderAddrEo = (DgPerformOrderAddrEo)this.dgPerformOrderAddrDomain.getMapper().selectOne((Wrapper)lqw);
                    AssertUtils.notNull((Object)orderAddrEo, (String)"\u8ba2\u5355\u5730\u5740\u672a\u627e\u5230");
                    alDto.setPhoneNumber(orderAddrEo.getReceivePhone());
                    alDto.setRecipientName(orderAddrEo.getReceiveName());
                    alDto.setProvinceCityDistrict(StringUtils.join((Object[])new String[]{orderAddrEo.getProvince(), orderAddrEo.getCity(), orderAddrEo.getCounty()}));
                    alDto.setDetailedAddress(orderAddrEo.getReceiveAddress());
                    alDto.setOrderAddrId(orderAddrEo.getId());
                    alDto.setAddressId(applyEo.getAddressId());
                }
                alDto.setOrderId(orderId);
                alDto.setApplyId(applyEo.getId());
                DgPerformOrderInfoEo orderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
                alDto.setOrderStatus(DgF2BOrderStatus.forCode((String)orderInfoEo.getOrderStatus()).getDesc());
                alDto.setSaleOrderNo(orderInfoEo.getSaleOrderNo());
                applyDto.setApplyLineDtos((List)Lists.newArrayList((Object[])new DgPerformOrderAddrApplyLineDto[]{alDto}));
                applyDto.setUserId(this.context.userId());
                applyDto.setUpdatePerson(this.context.userName());
                applyEo.setAuditStatus(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode());
                ((IDgPerformOrderAddrApplyDomain)this.domain).updateSelective((BaseEo)applyEo);
                this.sendPushOaMsg(dtos);
            } else {
                log.error("\u8ba2\u5355\u5730\u5740\u5df2\u7ecf\u63d0\u4ea4OA\u5ba1\u6279\uff1a{}", (Object)orderId);
            }
        } else {
            List lineEos;
            List addrDtos = this.performOrderAddrDomain.queryByOrderId(orderId);
            List addressIds = addrDtos.stream().filter(o -> o.getAddressId() != null).map(DgPerformOrderAddrDto::getAddressId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(addressIds) && CollectionUtils.isNotEmpty((Collection)(lineEos = this.dgPerformOrderAddrApplyLineDas.queryWaitAuditOrderId((List)Lists.newArrayList(addressIds), (List)orderIds)))) {
                log.info("\u8ba2\u5355\u5730\u5740\u88ab\u4fee\u6539\uff0c\u5f53\u524d\u8ba2\u5355\u6267\u884c\u6302\u8d77\u903b\u8f91\uff1a{}", (Object)orderId);
                this.lockOrder(orderId, null);
            }
        }
    }

    private DgPerformOrderAddrEo updateOrderAddrInfo(DgPerformOrderAddrApplyEo addrApplyEo, Long orderAddrId) {
        DgPerformOrderAddrEo addrEo = new DgPerformOrderAddrEo();
        addrEo.setId(orderAddrId);
        addrEo.setProvince(addrApplyEo.getProvince());
        addrEo.setProvinceCode(addrApplyEo.getProvinceCode());
        addrEo.setCity(addrApplyEo.getCity());
        addrEo.setCityCode(addrApplyEo.getCityCode());
        addrEo.setCounty(addrApplyEo.getCounty());
        addrEo.setCountyCode(addrApplyEo.getCountyCode());
        addrEo.setReceiveAddress(addrApplyEo.getReceiveAddress());
        addrEo.setReceiveName(addrApplyEo.getReceiveName());
        addrEo.setReceivePhone(addrApplyEo.getReceivePhone());
        addrEo.setAddressType(addrApplyEo.getChangeType());
        addrEo.setAddressId(addrApplyEo.getAddressId());
        this.dgPerformOrderAddrDomain.updateAddrById(addrEo);
        return addrEo;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> insertBatch(List<DgPerformOrderAddrApplyDto> dtos) {
        AssertUtils.notEmpty(dtos, (String)"\u6279\u91cf\u4fee\u6539\u7684\u5740\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        int count = 0;
        ArrayList newDtos = Lists.newArrayList();
        for (DgPerformOrderAddrApplyDto dto : dtos) {
            Map<Integer, List<DgPerformOrderAddrApplyLineDto>> result = this.dealWithWaitCommitAddr(dto);
            if (!CollectionUtils.isNotEmpty((Collection)result.get(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode()))) continue;
            List<DgPerformOrderAddrApplyLineDto> lineDtos = result.get(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode());
            DgPerformOrderAddrApplyDto applyDto = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrApplyDto.class, (String[])new String[]{"applyLineDtos"});
            applyDto.setApplyLineDtos(lineDtos);
            newDtos.add(applyDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)newDtos)) {
            this.saveAndSyncOa(newDtos);
        }
        return new RestResponse((Object)count);
    }

    private Map<Integer, List<DgPerformOrderAddrApplyLineDto>> dealWithWaitCommitAddr(DgPerformOrderAddrApplyDto dto) {
        List<DgPerformOrderAddrApplyLineDto> lineDtos;
        Map<Integer, List<DgPerformOrderAddrApplyLineDto>> result = this.checkParam(dto, dto.getApplyLineDtos());
        if (CollectionUtils.isNotEmpty((Collection)result.get(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode()))) {
            lineDtos = result.get(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode());
            DgPerformOrderAddrApplyDto applyDto = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)dto, DgPerformOrderAddrApplyDto.class, (String[])new String[]{"applyLineDtos"});
            applyDto.setApplyLineDtos(lineDtos);
            ((IDgPerformOrderAddrApplyDomain)this.domain).save(applyDto, Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty((Collection)result.get(OrderAddrApplyAuditStatusEnum.PASS.getCode()))) {
            lineDtos = result.get(OrderAddrApplyAuditStatusEnum.PASS.getCode());
            for (DgPerformOrderAddrApplyLineDto lineDto : lineDtos) {
                this.performOrderAddrDomain.deleteByOrderId(lineDto.getOrderId());
                DgPerformOrderAddrEo performOrderAddrEo = new DgPerformOrderAddrEo();
                CubeBeanUtils.copyProperties((Object)performOrderAddrEo, (Object)dto, (String[])new String[0]);
                performOrderAddrEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                performOrderAddrEo.setOrderId(lineDto.getOrderId());
                performOrderAddrEo.setAddressType(dto.getChangeType());
                performOrderAddrEo.setAddressId(lineDto.getAddressId());
                this.performOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
            }
        }
        return result;
    }

    @Override
    public void sendPushOaMsg(List<DgPerformOrderAddrApplyDto> dtos) {
        this.commonsMqService.sendSingleMessageAsync("OA_COMMIT_FORM_TOPIC", "OA_COMMIT_FORM_ORDER_ADDRESS_TAG", (Object)JSON.toJSONString(dtos));
    }
}

