/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.convert.entity.DgRefundConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundItemDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRefundDetailExtReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRefundExtReqDto;
import com.yunxi.dg.base.center.trade.eo.DgRefundDetailEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundItemEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgRefundService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgRefundServiceImpl
extends BaseServiceImpl<DgRefundDto, DgRefundEo, IDgRefundDomain>
implements IDgRefundService {
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgRefundItemDomain dgRefundItemDomain;

    public DgRefundServiceImpl(IDgRefundDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgRefundDto, DgRefundEo> converter() {
        return DgRefundConverter.INSTANCE;
    }

    @Override
    public void addRefund(DgRefundExtReqDto dgRefundDto) {
        DgRefundEo dgRefundEo = (DgRefundEo)this.converter().toEo((BaseDto)dgRefundDto);
        ((IDgRefundDomain)this.domain).insert((BaseEo)dgRefundEo);
        if (CollectionUtil.isNotEmpty((Collection)dgRefundDto.getDgRefundDetailExtReqDtos())) {
            ArrayList dgRefundDetailEos = Lists.newArrayList();
            ArrayList refundItemEos = Lists.newArrayList();
            for (DgRefundDetailExtReqDto dgRefundDetailDto : dgRefundDto.getDgRefundDetailExtReqDtos()) {
                DgRefundDetailEo dgRefundDetailEo = (DgRefundDetailEo)BeanUtil.copyProperties((Object)dgRefundDetailDto, DgRefundDetailEo.class, (String[])new String[0]);
                dgRefundDetailEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                dgRefundDetailEo.setRefundId(dgRefundEo.getId());
                dgRefundDetailEos.add(dgRefundDetailEo);
                refundItemEos.addAll(dgRefundDetailDto.getDgRefundItemDtos().stream().peek(itemDto -> {
                    itemDto.setRefundId(dgRefundEo.getId());
                    itemDto.setRefundOrderNo(dgRefundEo.getRefundNo());
                    itemDto.setRefundDetailId(dgRefundDetailEo.getId());
                }).map(itemDto -> (DgRefundItemEo)BeanUtil.copyProperties((Object)itemDto, DgRefundItemEo.class, (String[])new String[0])).collect(Collectors.toList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)dgRefundDetailEos)) {
                this.dgRefundDetailDomain.insertBatch((List)dgRefundDetailEos);
            }
            if (CollectionUtil.isNotEmpty((Collection)refundItemEos)) {
                this.dgRefundItemDomain.insertBatch((List)refundItemEos);
            }
        }
    }
}

