/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.help;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPaymentRateConfigDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.enums.GiftEnum;
import com.yunxi.dg.base.center.trade.service.entity.IDgPaymentRateConfigService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="costHelper")
public class CostHelper {
    private static final Logger log = LoggerFactory.getLogger(CostHelper.class);
    @Resource
    private IDgPaymentRateConfigService dgPaymentRateConfigService;
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;

    public static void main(String[] args) {
        String orderItemString = "[{\"allocatedAmount\":0,\"allowModifyPrice\":false,\"costAmountProportion\":0,\"costKneadeAmount\":0,\"extFields\":{},\"extensionJSON\":{},\"giftSortNoList\":[],\"isChoose\":0,\"itemPayRecordDtos\":[],\"kneadeAmount\":0,\"lackRemainingStockMap\":{},\"payAmount\":7282.570000,\"promotionKneadeAmount\":0,\"settleAmount\":0,\"sortNo\":1376164128394372731,\"totalUseCostAmount\":0},{\"allocatedAmount\":0,\"allowModifyPrice\":false,\"costAmountProportion\":0,\"costKneadeAmount\":0,\"extFields\":{},\"extensionJSON\":{},\"giftSortNoList\":[],\"isChoose\":0,\"itemPayRecordDtos\":[],\"kneadeAmount\":0,\"lackRemainingStockMap\":{},\"payAmount\":3234.920000,\"promotionKneadeAmount\":0,\"settleAmount\":0,\"sortNo\":1376164128393324154,\"totalUseCostAmount\":0},{\"allocatedAmount\":0,\"allowModifyPrice\":false,\"costAmountProportion\":0,\"costKneadeAmount\":0,\"extFields\":{},\"extensionJSON\":{},\"giftSortNoList\":[],\"isChoose\":0,\"itemPayRecordDtos\":[],\"kneadeAmount\":0,\"lackRemainingStockMap\":{},\"payAmount\":166098.940000,\"promotionKneadeAmount\":0,\"settleAmount\":0,\"sortNo\":1376164128391227000,\"totalUseCostAmount\":0},{\"allocatedAmount\":0,\"allowModifyPrice\":false,\"costAmountProportion\":0,\"costKneadeAmount\":0,\"extFields\":{},\"extensionJSON\":{},\"giftSortNoList\":[],\"isChoose\":0,\"itemPayRecordDtos\":[],\"kneadeAmount\":0,\"lackRemainingStockMap\":{},\"payAmount\":4558.900000,\"promotionKneadeAmount\":0,\"settleAmount\":0,\"sortNo\":1376164128392275577,\"totalUseCostAmount\":0}]";
        String feeControlRespDtoString = "[{\"accountCategory\":\"cost\",\"accountType\":\"REBATE_SP\",\"allocatedAmount\":0,\"currDeductionAmount\":0,\"currUseBalance\":0,\"extFields\":{},\"group\":false,\"items\":[{\"itemCode\":\"052901\",\"orderItemId\":1376164128394372731,\"skuCode\":\"052901\"},{\"itemCode\":\"052903\",\"orderItemId\":1376164128393324154,\"skuCode\":\"052903\"},{\"itemCode\":\"060102\",\"orderItemId\":1376164128391227000,\"skuCode\":\"060102\"},{\"itemCode\":\"060301\",\"orderItemId\":1376164128392275577,\"skuCode\":\"060301\"}],\"orderAvaBalance\":51896.400000,\"orderSuggestBalance\":0,\"payCalculateMode\":2,\"payableAmount\":0,\"proportional\":0.10},{\"accountCategory\":\"cost\",\"accountType\":\"REBATE_003\",\"allocatedAmount\":0,\"currDeductionAmount\":0,\"currUseBalance\":0,\"extFields\":{},\"group\":false,\"items\":[{\"itemCode\":\"052901\",\"orderItemId\":1376164128394372731,\"skuCode\":\"052901\"},{\"itemCode\":\"052903\",\"orderItemId\":1376164128393324154,\"skuCode\":\"052903\"},{\"itemCode\":\"060102\",\"orderItemId\":1376164128391227000,\"skuCode\":\"060102\"},{\"itemCode\":\"060301\",\"orderItemId\":1376164128392275577,\"skuCode\":\"060301\"}],\"orderAvaBalance\":29456.400000,\"orderSuggestBalance\":0,\"payCalculateMode\":2,\"payableAmount\":0,\"proportional\":0.10}]";
        List orderItems = JSON.parseArray((String)orderItemString, DgPreviewPerformOrderItemReqDto.class);
        List accountPayDtos = JSON.parseArray((String)feeControlRespDtoString, AccountPreviewDto.class);
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal suggestAccount(List<AccountPreviewDto> accountPayDtos, List<DgPreviewPerformOrderItemReqDto> orderItems) {
        log.info("\u5206\u644a\u8ba1\u7b97\u8d26\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountPayDtos));
        log.info("\u5206\u644a\u8ba1\u7b97\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderItems));
        Map orderItemMap = orderItems.stream().collect(Collectors.toMap(DgPreviewPerformOrderItemReqDto::getSortNo, Function.identity(), (a, b) -> a));
        BigDecimal rebateAmount = BigDecimal.ZERO;
        for (AccountPreviewDto accountPreviewDto : accountPayDtos) {
            if (accountPreviewDto.getOrderAvaBalance().compareTo(BigDecimal.ZERO) <= 0) {
                log.info("\u8d26\u6237\u3010{}\u3011\u672c\u5355\u6700\u5927\u53ef\u7528\u91d1\u989d\u989d\u5c0f\u4e8e0,\u6682\u65f6\u8df3\u8fc7\u5206\u644a", (Object)accountPreviewDto.getAccountType());
                continue;
            }
            BigDecimal totalPayAmnount = BigDecimal.ZERO;
            BigDecimal totalRemainingPayAmnount = BigDecimal.ZERO;
            BigDecimal suggestAmount = BigDecimal.ZERO;
            List<Object> subItems = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto.getItems())) {
                List ids = accountPreviewDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                subItems = orderItems.stream().filter(e -> e.getPayAmount().compareTo(e.getAllocatedAmount()) > 0).filter(e -> null != e.getSortNo()).filter(e -> ids.contains(e.getSortNo())).collect(Collectors.toList());
            } else {
                subItems = orderItems.stream().filter(e -> e.getPayAmount().compareTo(e.getAllocatedAmount()) > 0).collect(Collectors.toList());
            }
            log.info("\u8fc7\u6ee4\u540e\u7684\u5546\u54c1\u4fe1\u606f\uff1a{}", subItems.stream().map(DgPreviewPerformOrderItemReqDto::getSortNo).collect(Collectors.toList()));
            totalPayAmnount = subItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalRemainingPayAmnount = subItems.stream().map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u8d26\u6237\u3010{}\u3011\u672c\u5355\u6700\u5927\u53ef\u7528\u91d1\u989d\u989d\uff1a{}  || \u8d26\u6237\u4f59\u989d\uff1a{} || \u9002\u7528\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\uff1a{}  ||  \u5269\u4f59\u5f85\u5206\u914d\u603b\u91d1\u989d\uff1a{}", new Object[]{accountPreviewDto.getAccountType(), accountPreviewDto.getOrderAvaBalance(), accountPreviewDto.getAvaBalance(), totalPayAmnount, totalRemainingPayAmnount});
            if (totalRemainingPayAmnount.compareTo(BigDecimal.ZERO) <= 0) {
                log.info("\u6ca1\u6709\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff0c\u8d26\u6237\u3010{}\u3011\u8df3\u8fc7\u5206\u914d", (Object)accountPreviewDto.getAccountType());
                continue;
            }
            if (accountPreviewDto.getOrderAvaBalance().compareTo(totalRemainingPayAmnount) >= 0) {
                suggestAmount = totalRemainingPayAmnount;
                for (DgPreviewPerformOrderItemReqDto dgPreviewPerformOrderItemReqDto : subItems) {
                    BigDecimal itemAmount = BigDecimal.ZERO;
                    DgPreviewPerformOrderItemReqDto dgPreviewPerformOrderItemReqDto2 = (DgPreviewPerformOrderItemReqDto)orderItemMap.get(dgPreviewPerformOrderItemReqDto.getSortNo());
                    itemAmount = dgPreviewPerformOrderItemReqDto2.getPayAmount().subtract(dgPreviewPerformOrderItemReqDto2.getAllocatedAmount());
                    if (accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) && null != accountPreviewDto.getPayCalculateMode() && accountPreviewDto.getPayCalculateMode() == 2) {
                        itemAmount = itemAmount.multiply(accountPreviewDto.getProportional()).setScale(2, 4);
                    }
                    dgPreviewPerformOrderItemReqDto2.setAllocatedAmount(dgPreviewPerformOrderItemReqDto2.getAllocatedAmount().add(itemAmount));
                    if (accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                        dgPreviewPerformOrderItemReqDto2.setSettleAmount(itemAmount);
                    }
                    log.info("\u8d26\u6237\u3010{}\u3011\u7ed9\u5546\u54c1\u3010{}\u3011\u5206\u914d\u4e86\uff1a{} || \u5546\u54c1\u6210\u4ea4\u91d1\u989d\uff1a{}|| \u5f53\u524d\u5df2\u5206\u914d\u91d1\u989d\uff1a{} || \u5546\u54c1\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff1a{}", new Object[]{accountPreviewDto.getAccountType(), dgPreviewPerformOrderItemReqDto2.getSortNo(), itemAmount, dgPreviewPerformOrderItemReqDto2.getPayAmount(), dgPreviewPerformOrderItemReqDto2.getAllocatedAmount(), dgPreviewPerformOrderItemReqDto2.getPayAmount().subtract(dgPreviewPerformOrderItemReqDto2.getAllocatedAmount())});
                }
            } else {
                BigDecimal allocateAmount = BigDecimal.ZERO;
                boolean bl = false;
                for (DgPreviewPerformOrderItemReqDto dgPreviewPerformOrderItemReqDto : subItems) {
                    void var12_14;
                    ++var12_14;
                    DgPreviewPerformOrderItemReqDto itemReqDto = (DgPreviewPerformOrderItemReqDto)orderItemMap.get(dgPreviewPerformOrderItemReqDto.getSortNo());
                    BigDecimal itemAmount = BigDecimal.ZERO;
                    if (allocateAmount.compareTo(accountPreviewDto.getOrderAvaBalance()) > 0) {
                        log.info("\u8d26\u6237\uff1a{} \u5df2\u7ecf\u6ca1\u6709\u4f59\u989d\u53ef\u4ee5\u5206\u644a\u4e86", (Object)accountPreviewDto.getAccountType());
                        itemReqDto.setAllocatedAmount(itemAmount);
                        continue;
                    }
                    if (var12_14 != subItems.size()) {
                        itemAmount = accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) && null != accountPreviewDto.getPayCalculateMode() && accountPreviewDto.getPayCalculateMode() == 2 ? itemReqDto.getPayAmount().multiply(accountPreviewDto.getProportional()).setScale(2, 4) : accountPreviewDto.getOrderAvaBalance().multiply(itemReqDto.getPayAmount().divide(totalPayAmnount, 8, 4)).setScale(2, 4);
                    } else if (accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) && null != accountPreviewDto.getPayCalculateMode() && accountPreviewDto.getPayCalculateMode() == 2) {
                        itemAmount = itemReqDto.getPayAmount().multiply(accountPreviewDto.getProportional()).setScale(2, 4);
                        if (itemAmount.compareTo(accountPreviewDto.getOrderAvaBalance().subtract(allocateAmount)) > 0) {
                            itemAmount = accountPreviewDto.getOrderAvaBalance().subtract(allocateAmount);
                        }
                    } else {
                        itemAmount = accountPreviewDto.getOrderAvaBalance().subtract(allocateAmount);
                    }
                    if (itemAmount.compareTo(itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount())) > 0) {
                        log.info("\u5546\u54c1\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", (Object)itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount()));
                        itemAmount = itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount());
                    }
                    if (itemAmount.compareTo(accountPreviewDto.getOrderAvaBalance().subtract(allocateAmount)) > 0) {
                        log.info("\u8d26\u6237\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", (Object)itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount()));
                        itemAmount = accountPreviewDto.getOrderAvaBalance().subtract(allocateAmount);
                    }
                    itemReqDto.setAllocatedAmount(itemReqDto.getAllocatedAmount().add(itemAmount));
                    log.info("\u8d26\u6237\u3010{}\u3011\u7ed9\u5546\u54c1\u3010{}\u3011\u5206\u914d\u4e86\uff1a{} || \u5546\u54c1\u6210\u4ea4\u91d1\u989d\uff1a{}|| \u5f53\u524d\u5df2\u5206\u914d\u91d1\u989d\uff1a{} || \u5546\u54c1\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff1a{}", new Object[]{accountPreviewDto.getAccountType(), itemReqDto.getSortNo(), itemAmount, itemReqDto.getPayAmount(), itemReqDto.getAllocatedAmount(), itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount())});
                    allocateAmount = allocateAmount.add(itemAmount);
                    if (accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                        itemReqDto.setSettleAmount(itemReqDto.getSettleAmount().add(itemAmount));
                    }
                    suggestAmount = suggestAmount.add(itemAmount);
                }
            }
            log.info("\u8d26\u6237:{},\u63a8\u8350\u4f7f\u7528\u989d\u5ea6:{}", (Object)accountPreviewDto.getAccountType(), (Object)suggestAmount);
            accountPreviewDto.setOrderSuggestBalance(suggestAmount);
            accountPreviewDto.setCurrDeductionAmount(suggestAmount);
            accountPreviewDto.setCurrUseBalance(suggestAmount);
            accountPreviewDto.setAllocatedAmount(BigDecimal.ZERO);
            if (!accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) continue;
            rebateAmount = rebateAmount.add(suggestAmount);
        }
        for (DgPreviewPerformOrderItemReqDto item4 : orderItems) {
            if (item4.getSettleAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            item4.setTotalUseCostAmount(item4.getSettleAmount());
            BigDecimal proportion = item4.getSettleAmount().divide(item4.getPayAmount(), 4, 4);
            if (proportion.compareTo(BigDecimal.ONE) > 0) {
                log.error("\u5360\u6bd4\u5206\u644a\u9519\u8bef");
                proportion = BigDecimal.ONE;
            }
            proportion = BigDecimal.ONE.subtract(proportion);
            item4.setCostAmountProportion(proportion.multiply(new BigDecimal(100)).setScale(2, 4));
        }
        return rebateAmount;
    }

    /*
     * WARNING - void declaration
     */
    public void reSuggestAccount(List<AccountPreviewDto> accountPayDtos, DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto) {
        log.info("\u8fdb\u5165\u968f\u5355\u8fd8\u6b3e\u91cd\u7b97\u6d41\u7a0b=====================\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300bbegin");
        List orderItems = dgF2BPerformOrderReqDto.getItemList();
        BigDecimal totalDebtAmount = dgF2BPerformOrderReqDto.getPayableAmount().add(dgF2BPerformOrderReqDto.getRebatePayableAmount());
        log.info("\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{}", (Object)totalDebtAmount);
        for (AccountPreviewDto accountPreviewDto2 : accountPayDtos) {
            if (accountPreviewDto2.getAccountType().equals("YFK")) {
                if (null != accountPreviewDto2.getIsPaymentPeriod() && accountPreviewDto2.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) && accountPreviewDto2.getAccountType().equals("YFK")) {
                    log.info("\u8d26\u671f\u5ba2\u6237");
                    accountPreviewDto2.setPayableAmount(totalDebtAmount);
                } else if (accountPreviewDto2.getAvaBalance().subtract(accountPreviewDto2.getCurrDeductionAmount()).compareTo(totalDebtAmount) >= 0) {
                    log.info("\u4f59\u989d\u8db3\u591f");
                    accountPreviewDto2.setPayableAmount(totalDebtAmount);
                } else if (accountPreviewDto2.getAvaBalance().compareTo(totalDebtAmount) > 0) {
                    BigDecimal amount = accountPreviewDto2.getAvaBalance().subtract(totalDebtAmount);
                    log.info("\u6709\u591a\u4f59\u7684\u4f59\u989d:{} || \u62b5\u6263\u968f\u5355\u5b8c\u968f\u5355\u8fd8\u6b3e\u540e\uff1a{} || \u672c\u5355\u53ef\u7528\uff1a{}", new Object[]{accountPreviewDto2.getAvaBalance(), amount, accountPreviewDto2.getOrderAvaBalance()});
                    if (amount.compareTo(accountPreviewDto2.getOrderAvaBalance()) <= 0) {
                        accountPreviewDto2.setOrderAvaBalance(amount);
                    }
                    accountPreviewDto2.setPayableAmount(totalDebtAmount);
                } else {
                    log.info("\u4f18\u5148\u968f\u5355\u8fd8\u6b3e:{}", (Object)accountPreviewDto2.getOrderAvaBalance());
                    if (accountPreviewDto2.getOrderAvaBalance().compareTo(totalDebtAmount) > 0) {
                        accountPreviewDto2.setOrderAvaBalance(accountPreviewDto2.getOrderAvaBalance().subtract(totalDebtAmount));
                    } else {
                        accountPreviewDto2.setPayableAmount(accountPreviewDto2.getOrderAvaBalance());
                        accountPreviewDto2.setOrderAvaBalance(BigDecimal.ZERO);
                    }
                }
            }
            accountPreviewDto2.setOrderSuggestBalance(BigDecimal.ZERO);
            accountPreviewDto2.setCurrUseBalance(BigDecimal.ZERO);
            accountPreviewDto2.setCurrDeductionAmount(BigDecimal.ZERO);
            accountPreviewDto2.setAllocatedAmount(BigDecimal.ZERO);
            log.info("\u91cd\u65b0\u8bbe\u7f6e\u540e\u8d26\u6237\u3010{}\u3011\u672c\u5355\u6700\u5927\u53ef\u7528\u91d1\u989d\u989d\uff1a{}", (Object)accountPreviewDto2.getAccountType(), (Object)accountPreviewDto2.getOrderAvaBalance());
        }
        for (Object item2 : orderItems) {
            item2.setAllocatedAmount(BigDecimal.ZERO);
            item2.setSettleAmount(BigDecimal.ZERO);
        }
        Map orderItemMap = orderItems.stream().collect(Collectors.toMap(DgPreviewPerformOrderItemReqDto::getSortNo, Function.identity(), (a, b) -> a));
        for (AccountPreviewDto accountPreviewDto3 : accountPayDtos) {
            if (accountPreviewDto3.getOrderAvaBalance().compareTo(BigDecimal.ZERO) <= 0) {
                log.info("\u8d26\u6237\u3010{}\u3011\u672c\u5355\u6700\u5927\u53ef\u7528\u91d1\u989d\u989d\u5c0f\u4e8e0,\u6682\u65f6\u8df3\u8fc7\u5206\u644a", (Object)accountPreviewDto3.getAccountType());
                continue;
            }
            BigDecimal totalPayAmnount = BigDecimal.ZERO;
            BigDecimal totalRemainingPayAmnount = BigDecimal.ZERO;
            Object suggestAmount = BigDecimal.ZERO;
            List<Object> subItems = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto3.getItems())) {
                List ids = accountPreviewDto3.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                subItems = orderItems.stream().filter(e -> e.getPayAmount().compareTo(e.getAllocatedAmount()) > 0).filter(e -> null != e.getSortNo()).filter(e -> ids.contains(e.getSortNo())).collect(Collectors.toList());
            } else {
                subItems = orderItems.stream().filter(e -> e.getPayAmount().compareTo(e.getAllocatedAmount()) > 0).collect(Collectors.toList());
            }
            log.info("\u8fc7\u6ee4\u540e\u7684\u5546\u54c1\u4fe1\u606f\uff1a{}", subItems.stream().map(DgPreviewPerformOrderItemReqDto::getSortNo).collect(Collectors.toList()));
            totalPayAmnount = subItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalRemainingPayAmnount = subItems.stream().map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u8d26\u6237\u3010{}\u3011\u672c\u5355\u6700\u5927\u53ef\u7528\u91d1\u989d\u989d\uff1a{}  || \u8d26\u6237\u4f59\u989d\uff1a{} || \u9002\u7528\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\uff1a{}  ||  \u5269\u4f59\u5f85\u5206\u914d\u603b\u91d1\u989d\uff1a{}", new Object[]{accountPreviewDto3.getAccountType(), accountPreviewDto3.getOrderAvaBalance(), accountPreviewDto3.getAvaBalance(), totalPayAmnount, totalRemainingPayAmnount});
            if (totalRemainingPayAmnount.compareTo(BigDecimal.ZERO) <= 0) {
                log.info("\u6ca1\u6709\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff0c\u8d26\u6237\u3010{}\u3011\u8df3\u8fc7\u5206\u914d", (Object)accountPreviewDto3.getAccountType());
                continue;
            }
            if (accountPreviewDto3.getOrderAvaBalance().compareTo(totalRemainingPayAmnount) >= 0) {
                suggestAmount = totalRemainingPayAmnount;
                for (DgPreviewPerformOrderItemReqDto dgPreviewPerformOrderItemReqDto : subItems) {
                    DgPreviewPerformOrderItemReqDto itemReqDto = (DgPreviewPerformOrderItemReqDto)orderItemMap.get(dgPreviewPerformOrderItemReqDto.getSortNo());
                    itemReqDto.setAllocatedAmount(itemReqDto.getPayAmount());
                    if (!accountPreviewDto3.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) continue;
                    itemReqDto.setSettleAmount(itemReqDto.getPayAmount());
                }
            } else {
                BigDecimal allocateAmount = BigDecimal.ZERO;
                boolean bl = false;
                for (DgPreviewPerformOrderItemReqDto dgPreviewPerformOrderItemReqDto : subItems) {
                    void var13_17;
                    ++var13_17;
                    DgPreviewPerformOrderItemReqDto itemReqDto = (DgPreviewPerformOrderItemReqDto)orderItemMap.get(dgPreviewPerformOrderItemReqDto.getSortNo());
                    BigDecimal itemAmount = BigDecimal.ZERO;
                    if (allocateAmount.compareTo(accountPreviewDto3.getOrderAvaBalance()) > 0) {
                        log.info("\u8d26\u6237\uff1a{} \u5df2\u7ecf\u6ca1\u6709\u4f59\u989d\u53ef\u4ee5\u5206\u644a\u4e86", (Object)accountPreviewDto3.getAccountType());
                        itemReqDto.setAllocatedAmount(itemAmount);
                        continue;
                    }
                    itemAmount = var13_17 != subItems.size() ? (accountPreviewDto3.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) && null != accountPreviewDto3.getPayCalculateMode() && accountPreviewDto3.getPayCalculateMode() == 2 ? itemReqDto.getPayAmount().multiply(accountPreviewDto3.getProportional()).setScale(2, 4) : accountPreviewDto3.getOrderAvaBalance().multiply(itemReqDto.getPayAmount().divide(totalPayAmnount, 8, 4)).setScale(2, 4)) : accountPreviewDto3.getOrderAvaBalance().subtract(allocateAmount);
                    if (itemAmount.compareTo(itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount())) > 0) {
                        log.info("\u5546\u54c1\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", (Object)itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount()));
                        itemAmount = itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount());
                    }
                    if (itemAmount.compareTo(accountPreviewDto3.getOrderAvaBalance().subtract(allocateAmount)) > 0) {
                        log.info("\u8d26\u6237\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\u4e3a\uff1a{}", (Object)itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount()));
                        itemAmount = accountPreviewDto3.getOrderAvaBalance().subtract(allocateAmount);
                    }
                    itemReqDto.setAllocatedAmount(itemReqDto.getAllocatedAmount().add(itemAmount));
                    log.info("\u8d26\u6237\u3010{}\u3011\u7ed9\u5546\u54c1\u5206\u914d\u4e86\uff1a{} || \u5f53\u524d\u5df2\u5206\u914d\u91d1\u989d\uff1a{} || \u5546\u54c1\u5269\u4f59\u5f85\u5206\u914d\u91d1\u989d\uff1a{}", new Object[]{accountPreviewDto3.getAccountType(), itemAmount, itemReqDto.getAllocatedAmount(), itemReqDto.getPayAmount().subtract(itemReqDto.getAllocatedAmount())});
                    allocateAmount = allocateAmount.add(itemAmount);
                    log.info("\u8d26\u6237\u5df2\u5206\u914d\u989d\u5ea6\uff1a{}", (Object)allocateAmount);
                    if (!accountPreviewDto3.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) continue;
                    itemReqDto.setSettleAmount(itemReqDto.getSettleAmount().add(itemAmount));
                }
                suggestAmount = accountPreviewDto3.getOrderAvaBalance();
            }
            accountPreviewDto3.setOrderSuggestBalance((BigDecimal)suggestAmount);
            accountPreviewDto3.setCurrDeductionAmount((BigDecimal)suggestAmount);
            accountPreviewDto3.setCurrUseBalance((BigDecimal)suggestAmount);
            accountPreviewDto3.setAllocatedAmount(BigDecimal.ZERO);
            log.info("\u8d26\u6237:{},\u53ef\u7528\u989d\u5ea6:{} || \u63a8\u8350\u4f7f\u7528\u989d\u5ea6\uff1a{}", new Object[]{accountPreviewDto3.getAccountType(), accountPreviewDto3.getOrderAvaBalance(), accountPreviewDto3.getCurrDeductionAmount()});
        }
        for (DgPreviewPerformOrderItemReqDto item5 : orderItems) {
            if (item5.getSettleAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            item5.setTotalUseCostAmount(item5.getSettleAmount());
            Object proportion = item5.getSettleAmount().divide(item5.getPayAmount(), 4, 4);
            if (((BigDecimal)proportion).compareTo(BigDecimal.ONE) > 0) {
                log.error("\u5360\u6bd4\u5206\u644a\u9519\u8bef");
                proportion = BigDecimal.ONE;
            }
            proportion = BigDecimal.ONE.subtract((BigDecimal)proportion);
            item5.setCostAmountProportion(((BigDecimal)proportion).multiply(new BigDecimal(100)).setScale(2, 4));
        }
        List subAccountPayDtos = accountPayDtos.stream().filter(e -> null != e.getIsPaymentPeriod() && e.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) && e.getAccountType().equals("YFK")).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(subAccountPayDtos)) {
            log.info("\u8d26\u671f\u5ba2\u6237\u6d41\u7a0b------------>>>>>>>>>>>>>begin");
            BigDecimal orderTotalAmount = BigDecimal.ZERO;
            for (DgPreviewPerformOrderItemReqDto orderItem : orderItems) {
                if (!GiftEnum.NOT_GIFT.getType().equals(orderItem.getGift())) continue;
                orderTotalAmount = orderTotalAmount.add(orderItem.getPayAmount());
            }
            BigDecimal totalOrderAvaBalance = accountPayDtos.stream().map(accountPreviewDto -> {
                if (accountPreviewDto.getOrderAvaBalance().compareTo(BigDecimal.ZERO) > 0) {
                    return accountPreviewDto.getCurrDeductionAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\uff1a{} || \u968f\u5355\u8fd8\u6b3e\u91d1\u989d\uff1a{} || \u8d26\u6237\u603b\u5269\u4f59\u91d1\u989d\uff1a{}", new Object[]{orderTotalAmount, totalDebtAmount, totalOrderAvaBalance});
            if (orderTotalAmount.add(totalDebtAmount).compareTo(totalOrderAvaBalance) > 0) {
                BigDecimal surplusAmnount = orderTotalAmount.add(totalDebtAmount).subtract(totalOrderAvaBalance);
                for (AccountPreviewDto accountPreviewDto4 : accountPayDtos) {
                    if (null == accountPreviewDto4.getIsPaymentPeriod() || !accountPreviewDto4.getIsPaymentPeriod().equals(YesNoEnum.YES.getValue()) || !accountPreviewDto4.getAccountType().equals("YFK")) continue;
                    BigDecimal totalAmount = surplusAmnount;
                    if (accountPreviewDto4.getCurrDeductionAmount().compareTo(BigDecimal.ZERO) >= 0) {
                        totalAmount = totalAmount.add(accountPreviewDto4.getCurrDeductionAmount());
                    }
                    log.info("\u8d26\u671f\u5ba2\u6237\u52a0\u4e0a\u968f\u5355\u8fd8\u6b3e\u540e:{}, \u5269\u4f59\u91d1\u989d\uff1a{} || \u63a8\u8350\u4f7f\u7528\u989d\u5ea6\uff1a{}", new Object[]{accountPreviewDto4.getAccountType(), surplusAmnount, totalAmount});
                    accountPreviewDto4.setOrderSuggestBalance(totalAmount);
                    accountPreviewDto4.setCurrDeductionAmount(totalAmount);
                    accountPreviewDto4.setCurrUseBalance(totalAmount);
                }
            }
            log.info("\u8d26\u671f\u5ba2\u6237\u6d41\u7a0b------------>>>>>>>>>>>>>end");
        } else {
            for (AccountPreviewDto accountPreviewDto5 : accountPayDtos) {
                log.info("\u975e\u8d26\u671f\u5ba2\u6237\u52a0\u4e0a\u968f\u5355\u8fd8\u6b3e\u524d\u8d26\u6237:{},\u53ef\u7528\u989d\u5ea6:{} || \u63a8\u8350\u4f7f\u7528\u989d\u5ea6\uff1a{}", new Object[]{accountPreviewDto5.getAccountType(), accountPreviewDto5.getOrderAvaBalance(), accountPreviewDto5.getCurrDeductionAmount()});
                if (accountPreviewDto5.getPayableAmount().compareTo(BigDecimal.ZERO) <= 0 || !accountPreviewDto5.getAccountType().equals("YFK") || accountPreviewDto5.getCurrDeductionAmount().compareTo(BigDecimal.ZERO) < 0) continue;
                accountPreviewDto5.setCurrDeductionAmount(accountPreviewDto5.getCurrDeductionAmount().add(accountPreviewDto5.getPayableAmount()));
                accountPreviewDto5.setOrderSuggestBalance(accountPreviewDto5.getOrderSuggestBalance().add(accountPreviewDto5.getPayableAmount()));
                accountPreviewDto5.setCurrUseBalance(accountPreviewDto5.getCurrUseBalance().add(accountPreviewDto5.getPayableAmount()));
                if (accountPreviewDto5.getOrderAvaBalance().compareTo(BigDecimal.ZERO) >= 0) {
                    accountPreviewDto5.setOrderAvaBalance(accountPreviewDto5.getOrderAvaBalance().add(accountPreviewDto5.getPayableAmount()));
                } else if (accountPreviewDto5.getOrderAvaBalance().compareTo(BigDecimal.ZERO) < 0) {
                    accountPreviewDto5.setOrderAvaBalance(accountPreviewDto5.getOrderAvaBalance().subtract(accountPreviewDto5.getPayableAmount()));
                }
                log.info("\u975e\u8d26\u671f\u5ba2\u6237\u52a0\u4e0a\u968f\u5355\u8fd8\u6b3e\u540e\u8d26\u6237:{},\u53ef\u7528\u989d\u5ea6:{} || \u63a8\u8350\u4f7f\u7528\u989d\u5ea6\uff1a{}", new Object[]{accountPreviewDto5.getAccountType(), accountPreviewDto5.getOrderAvaBalance(), accountPreviewDto5.getCurrDeductionAmount()});
            }
        }
        for (AccountPreviewDto accountPreviewDto2 : accountPayDtos) {
            List accountDtos = accountPreviewDto2.getAccountDtos();
            if (!accountPreviewDto2.isGroup() || !CollectionUtils.isNotEmpty((Collection)accountDtos)) continue;
            BigDecimal copySuggestAmount = accountPreviewDto2.getCurrDeductionAmount();
            for (int i = 0; i < accountDtos.size(); ++i) {
                void var15_25;
                AccountDto dto = (AccountDto)accountDtos.get(i);
                DgPaymentRateConfigDto dgPaymentRateConfigDto = new DgPaymentRateConfigDto();
                DgPaymentRateConfigDto dgPaymentRateConfigDto2 = this.dgPaymentRateConfigService.selectOne(dgPaymentRateConfigDto);
                AssertUtils.notNull((Object)dgPaymentRateConfigDto2, (String)"\u7b7e\u7ea6\u516c\u53f8\u6263\u6b3e\u6bd4\u4f8b\u672a\u521d\u59cb\u5316");
                BigDecimal bigDecimal = BigDecimal.ZERO;
                if (i == accountDtos.size() - 1) {
                    BigDecimal bigDecimal2 = copySuggestAmount;
                } else {
                    BigDecimal rate = Objects.equals(dto.getSaleCompanyCode(), dgPaymentRateConfigDto2.getEnterpriseCode()) ? dgPaymentRateConfigDto2.getRate() : new BigDecimal("100").subtract(dgPaymentRateConfigDto2.getRate());
                    BigDecimal bigDecimal3 = copySuggestAmount.multiply(rate.divide(new BigDecimal("100"))).setScale(2, 4);
                }
                dto.setCurrDeductionAmount((BigDecimal)var15_25);
                dto.setCurrUseBalance((BigDecimal)var15_25);
                log.info("\u5b50\u8d26\u6237\u4ed8\u6b3e\u989d\u5ea6:{}", (Object)var15_25);
                copySuggestAmount = copySuggestAmount.subtract((BigDecimal)var15_25);
            }
        }
        log.info("\u8fdb\u5165\u968f\u5355\u8fd8\u6b3e\u91cd\u7b97\u6d41\u7a0b=====================\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300bend");
    }
}

