/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.help;

import com.yunxi.dg.base.center.price.dto.item.PriceItemSkuSectionRespDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class PriceHelp {
    public static BigDecimal getDgPolicyPrice(SkuPolicyPriceRespDto priceRespDto, Integer num) {
        AssertUtils.notNull((Object)num, (String)"\u83b7\u53d6\u4ef7\u683c\uff0c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        if (priceRespDto == null) {
            return null;
        }
        BigDecimal acutualPrice = null;
        if (CollectionUtils.isNotEmpty((Collection)priceRespDto.getSkuPriceLimitList())) {
            for (PriceItemSkuSectionRespDto skuSectionRespDto : priceRespDto.getSkuPriceLimitList()) {
                Integer lower = skuSectionRespDto.getLowerLimit() == null ? -1 : skuSectionRespDto.getLowerLimit();
                Integer upper = skuSectionRespDto.getUpperLimit() == null ? Integer.MAX_VALUE : skuSectionRespDto.getUpperLimit();
                if (num.compareTo(lower) < 0 || num.compareTo(upper) > 0) continue;
                acutualPrice = skuSectionRespDto.getItemPrice();
                break;
            }
        }
        if (acutualPrice == null) {
            acutualPrice = priceRespDto.getSupplyPrice();
        }
        return acutualPrice;
    }
}

