/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.mark.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderLabelDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderErrorDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelCollectionRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRelationRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRelationsItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRelationsRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderErrorRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelEo;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderLabelService;
import com.yunxi.dg.base.center.trade.service.mark.IDgResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderLabelServiceImpl
implements IDgOrderLabelService,
IDgResetRedisNoIndexCommon {
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderLabelDas dgOrderLabelDas;
    @Resource
    private IDgOrderLabelDomain dgOrderLabelDomain;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordService;
    @Resource
    private IDgPerformOrderErrorDomain performOrderErrorDomain;

    @Override
    public Long addOrderLabel(DgOrderLabelReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getLabelName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderLabelEo);
        orderLabelEo.setLabelCode(this.dgNoGreateUtil.generateLabelNo());
        this.dgOrderLabelDomain.insert((BaseEo)orderLabelEo);
        return orderLabelEo.getId();
    }

    @Override
    public void modifyOrderLabel(DgOrderLabelReqDto modifyReqDto) {
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderLabelEo);
        this.dgOrderLabelDomain.updateSelective((BaseEo)orderLabelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderLabel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgOrderLabelDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DgOrderLabelRespDto queryById(Long id) {
        DgOrderLabelEo orderLabelEo = (DgOrderLabelEo)this.dgOrderLabelDomain.selectByPrimaryKey(id);
        DgOrderLabelRespDto orderLabelRespDto = new DgOrderLabelRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelEo, (BaseVo)orderLabelRespDto);
        return orderLabelRespDto;
    }

    @Override
    public PageInfo<DgOrderLabelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgOrderLabelReqDto orderLabelReqDto = (DgOrderLabelReqDto)JSON.parseObject((String)filter, DgOrderLabelReqDto.class);
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)orderLabelReqDto, (BaseEo)orderLabelEo);
        orderLabelEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.dgOrderLabelDomain.selectPage((BaseEo)orderLabelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgOrderLabelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgOrderLabelRespDto> queryByList(DgOrderLabelReqDto orderLabelReqDto) {
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)orderLabelReqDto, (BaseEo)orderLabelEo);
        orderLabelEo.setOrderByDesc("update_time");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.setEntity((Object)orderLabelEo);
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            queryWrapper.in(DgOrderLabelEo::getLabelCode, (Collection)orderLabelReqDto.getLabelCodes());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List orderLabelEos = this.dgOrderLabelDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<DgOrderLabelRespDto> dtoList = new ArrayList<DgOrderLabelRespDto>();
        DtoHelper.eoList2DtoList((Collection)orderLabelEos, dtoList, DgOrderLabelRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<DgOrderLabelRespDto> queryByPage(DgOrderLabelReqDto orderTagReqDto, Integer pageNum, Integer pageSize) {
        DgOrderLabelEo orderTagEo = new DgOrderLabelEo();
        this.param(orderTagEo, orderTagReqDto);
        PageInfo eoPageInfo = this.dgOrderLabelDas.selectPage((BaseEo)orderTagEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgOrderLabelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DgOrderLabelCollectionRespDto queryRelationByOrderId(Long orderId) {
        DgOrderLabelItemReqDto dgOrderLabelItemReqDto = new DgOrderLabelItemReqDto();
        dgOrderLabelItemReqDto.setOrderId(orderId);
        List dgOrderLabelItemRespDtos = this.orderLabelItemService.queryByParam(dgOrderLabelItemReqDto);
        List dgOrderLabelRecordDtos = this.orderLabelRecordService.queryByOrderId(orderId);
        List orderLabelEos = this.dgOrderLabelDomain.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)orderLabelEos)) {
            Map orderLabelMap = orderLabelEos.stream().collect(Collectors.toMap(DgOrderLabelEo::getLabelCode, Function.identity()));
            Optional.ofNullable(dgOrderLabelItemRespDtos).ifPresent(dto -> dto.forEach(item -> {
                DgOrderLabelEo orderLabelEo = (DgOrderLabelEo)orderLabelMap.get(item.getLabelCode());
                if (Objects.nonNull(orderLabelEo)) {
                    item.setLabelName(orderLabelEo.getLabelName());
                    item.setLabelAbbr(orderLabelEo.getLabelAbbr());
                    item.setLabelDisplay(orderLabelEo.getLabelDisplay());
                    item.setLabelTip(orderLabelEo.getLabelTip());
                }
            }));
            Optional.ofNullable(dgOrderLabelRecordDtos).ifPresent(dto -> dto.forEach(item -> {
                DgOrderLabelEo orderLabelEo = (DgOrderLabelEo)orderLabelMap.get(item.getLabelCode());
                if (Objects.nonNull(orderLabelEo)) {
                    item.setLabelName(orderLabelEo.getLabelName());
                    item.setLabelAbbr(orderLabelEo.getLabelAbbr());
                    item.setLabelDisplay(orderLabelEo.getLabelDisplay());
                    item.setLabelTip(orderLabelEo.getLabelTip());
                    if ("\u5f02".equals(orderLabelEo.getLabelAbbr())) {
                        DgPerformOrderErrorRespDto errorRespDto = this.performOrderErrorDomain.queryByOrderId(orderId);
                        Optional.ofNullable(errorRespDto).ifPresent(reason -> {
                            item.setLabelName(reason.getErrorReason());
                            item.setLabelTip(reason.getErrorReason());
                        });
                    }
                }
            }));
        }
        DgOrderLabelCollectionRespDto collectionRespDto = new DgOrderLabelCollectionRespDto();
        collectionRespDto.setOrderLabelItems(dgOrderLabelItemRespDtos);
        collectionRespDto.setOrderLabelRecords(dgOrderLabelRecordDtos);
        return collectionRespDto;
    }

    @Override
    public DgOrderLabelRelationRespDto queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderLabelReqDto orderLabelReqDto = new DgOrderLabelReqDto();
        orderLabelReqDto.setOrderIds(Arrays.asList(orderId));
        DgOrderLabelRelationsRespDto relationsRespDto = this.queryOrderLabelRelations(orderLabelReqDto);
        if (Objects.isNull(relationsRespDto.getOrderLabelRecordMaps()) && Objects.isNull(relationsRespDto.getOrderLabelItemMaps())) {
            return null;
        }
        DgOrderLabelRelationRespDto relationRespDto = new DgOrderLabelRelationRespDto();
        if (Objects.nonNull(relationsRespDto.getOrderLabelRecordMaps())) {
            relationRespDto.setOrderLabelRecords((List)relationsRespDto.getOrderLabelRecordMaps().get(orderId.toString()));
        }
        if (Objects.nonNull(relationsRespDto.getOrderLabelItemMaps())) {
            relationRespDto.setOrderLabelItems((List)relationsRespDto.getOrderLabelItemMaps().get(orderId.toString()));
        }
        return relationRespDto;
    }

    @Override
    public DgOrderLabelRelationsRespDto queryOrderLabelRelations(DgOrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Map<String, List<DgOrderLabelRespDto>> orderLabelRecordMaps = this.queryOrderLabelRecord(orderLabelReqDto);
        Map<String, List<DgOrderLabelRespDto>> orderLabelItemMaps = this.queryOrderLabelItem(orderLabelReqDto);
        DgOrderLabelRelationsRespDto relationRespDto = new DgOrderLabelRelationsRespDto();
        relationRespDto.setOrderLabelRecordMaps(orderLabelRecordMaps);
        relationRespDto.setOrderLabelItemMaps(orderLabelItemMaps);
        return relationRespDto;
    }

    @Override
    public DgOrderLabelRelationsItemRespDto queryOrderLabelRecordExt(DgOrderLabelReqDto orderLabelReqDto) {
        DgOrderLabelRelationsItemRespDto relationsItemRespDto = new DgOrderLabelRelationsItemRespDto();
        Map<String, List<DgOrderLabelRespDto>> recordMaps = this.queryOrderLabelRecord(orderLabelReqDto);
        if (recordMaps.isEmpty()) {
            return null;
        }
        relationsItemRespDto.setOrderLabelItemMaps(recordMaps);
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            HashMap codeExistMaps = Maps.newHashMap();
            ArrayList orderLabelRespDtos = Lists.newArrayList();
            recordMaps.entrySet().stream().forEach(e -> orderLabelRespDtos.addAll((Collection)e.getValue()));
            List labelCodes = orderLabelRespDtos.stream().map(DgOrderLabelRespDto::getLabelCode).distinct().collect(Collectors.toList());
            orderLabelReqDto.getLabelCodes().forEach(e -> {
                boolean codeExist = false;
                if (labelCodes.contains(e)) {
                    codeExist = true;
                }
                codeExistMaps.put(e, codeExist);
            });
            relationsItemRespDto.setCodeExistMaps((Map)codeExistMaps);
        }
        return relationsItemRespDto;
    }

    @Override
    public Map<String, List<DgOrderLabelRespDto>> queryOrderLabelRecord(DgOrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderLabelRecordReqDto orderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
        CubeBeanUtils.copyProperties((Object)orderLabelRecordReqDto, (Object)orderLabelReqDto, (String[])new String[0]);
        List orderLabelRecordList = this.orderLabelRecordService.queryByParam(orderLabelRecordReqDto);
        List<String> labelCodes = this.getLabelCodes(orderLabelRecordList);
        if (CollectionUtils.isEmpty(labelCodes)) {
            return null;
        }
        DgOrderLabelReqDto reqDto = new DgOrderLabelReqDto();
        reqDto.setLabelCodes(labelCodes);
        List<DgOrderLabelRespDto> orderLabelRespDtos = this.queryByParam(reqDto);
        if (CollectionUtils.isEmpty(orderLabelRespDtos)) {
            return null;
        }
        Map prototypeMaps = orderLabelRespDtos.stream().collect(Collectors.toMap(DgOrderLabelRespDto::getLabelCode, Function.identity()));
        Map<Long, List<DgOrderLabelRecordRespDto>> recordMaps = Optional.ofNullable(orderLabelRecordList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DgOrderLabelBaseRespDto::getOrderId));
        Map<String, List<DgOrderLabelRespDto>> orderLabelRecordMaps = recordMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertLabel((List)map.getValue(), prototypeMaps)));
        return orderLabelRecordMaps;
    }

    @Override
    public DgOrderLabelRelationsItemRespDto queryOrderLabelItemExt(DgOrderLabelReqDto orderLabelReqDto) {
        DgOrderLabelRelationsItemRespDto relationsItemRespDto = new DgOrderLabelRelationsItemRespDto();
        Map<String, List<DgOrderLabelRespDto>> recordMaps = this.queryOrderLabelItem(orderLabelReqDto);
        if (recordMaps.isEmpty()) {
            return null;
        }
        relationsItemRespDto.setOrderLabelItemMaps(recordMaps);
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            HashMap codeExistMaps = Maps.newHashMap();
            ArrayList orderLabelRespDtos = Lists.newArrayList();
            recordMaps.entrySet().stream().forEach(e -> orderLabelRespDtos.addAll((Collection)e.getValue()));
            List labelCodes = orderLabelRespDtos.stream().map(DgOrderLabelRespDto::getLabelCode).distinct().collect(Collectors.toList());
            orderLabelReqDto.getLabelCodes().forEach(e -> {
                boolean codeExist = false;
                if (labelCodes.contains(e)) {
                    codeExist = true;
                }
                codeExistMaps.put(e, codeExist);
            });
            relationsItemRespDto.setCodeExistMaps((Map)codeExistMaps);
        }
        return relationsItemRespDto;
    }

    @Override
    public Map<String, List<DgOrderLabelRespDto>> queryOrderLabelItem(DgOrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderLabelItemReqDto orderLabelItemReqDto = new DgOrderLabelItemReqDto();
        CubeBeanUtils.copyProperties((Object)orderLabelItemReqDto, (Object)orderLabelReqDto, (String[])new String[0]);
        List orderLabelItemList = this.orderLabelItemService.queryByParam(orderLabelItemReqDto);
        List<String> labelCodes = this.getLabelCodes(orderLabelItemList);
        if (CollectionUtils.isEmpty(labelCodes)) {
            return null;
        }
        DgOrderLabelReqDto reqDto = new DgOrderLabelReqDto();
        reqDto.setLabelCodes(labelCodes);
        List<DgOrderLabelRespDto> orderLabelRespDtos = this.queryByParam(reqDto);
        if (CollectionUtils.isEmpty(orderLabelRespDtos)) {
            return null;
        }
        Map prototypeMaps = orderLabelRespDtos.stream().collect(Collectors.toMap(DgOrderLabelRespDto::getLabelCode, Function.identity()));
        Map<Long, List<DgOrderLabelItemRespDto>> itemMaps = Optional.ofNullable(orderLabelItemList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DgOrderLabelBaseRespDto::getOrderId));
        Map<String, List<DgOrderLabelRespDto>> orderLabelItemMaps = itemMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertLabel((List)map.getValue(), prototypeMaps)));
        return orderLabelItemMaps;
    }

    public DgOrderLabelRespDto queryByOrderLabel(DgOrderLabelReqDto orderLabelReqDto) {
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        orderLabelEo.setDr(0);
        this.param(orderLabelEo, orderLabelReqDto);
        DgOrderLabelEo eo = (DgOrderLabelEo)this.dgOrderLabelDomain.selectOne((BaseEo)orderLabelEo);
        if (Objects.isNull(eo)) {
            return null;
        }
        DgOrderLabelRespDto orderLabelRespDto = new DgOrderLabelRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)orderLabelRespDto);
        return orderLabelRespDto;
    }

    public List<DgOrderLabelRespDto> queryByParam(DgOrderLabelReqDto orderLabelReqDto) {
        DgOrderLabelEo orderLabelEo = new DgOrderLabelEo();
        orderLabelEo.setDr(0);
        this.param(orderLabelEo, orderLabelReqDto);
        List orderLabelEos = this.dgOrderLabelDomain.selectList((BaseEo)orderLabelEo);
        if (CollectionUtils.isEmpty((Collection)orderLabelEos)) {
            return null;
        }
        ArrayList<DgOrderLabelRespDto> dtoList = new ArrayList<DgOrderLabelRespDto>();
        DtoHelper.eoList2DtoList((Collection)orderLabelEos, dtoList, DgOrderLabelRespDto.class);
        return dtoList;
    }

    private void param(DgOrderLabelEo orderLabelEo, DgOrderLabelReqDto orderLabelReqDto) {
        ArrayList orderSqlFilter = Lists.newArrayList();
        if (Objects.nonNull(orderLabelReqDto.getId())) {
            orderLabelEo.setId(orderLabelReqDto.getId());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelStatus())) {
            orderLabelEo.setLabelStatus(orderLabelReqDto.getLabelStatus());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelType())) {
            orderLabelEo.setLabelType(orderLabelReqDto.getLabelType());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelCode())) {
            orderSqlFilter.add(SqlFilter.like((String)"label_code", (Object)orderLabelReqDto.getLabelCode()));
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelName())) {
            orderSqlFilter.add(SqlFilter.like((String)"label_name", (Object)orderLabelReqDto.getLabelName()));
        }
        if (Objects.nonNull(orderLabelReqDto.getUpdateStartTime()) && Objects.nonNull(orderLabelReqDto.getUpdateEndTime())) {
            orderSqlFilter.add(SqlFilter.ge((String)"updateTime", (Object)orderLabelReqDto.getUpdateStartTime()));
            orderSqlFilter.add(SqlFilter.le((String)"updateTime", (Object)orderLabelReqDto.getUpdateEndTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            orderSqlFilter.add(SqlFilter.in((String)"label_code", (Object)orderLabelReqDto.getLabelCodes()));
        }
        orderLabelEo.setSqlFilters((List)orderSqlFilter);
    }

    private List<String> getLabelCodes(List<? extends DgOrderLabelBaseRespDto> ... orderLabelRecordList) {
        ArrayList labelCodes = Lists.newArrayList();
        for (List<? extends DgOrderLabelBaseRespDto> orderLabelBaseResp : orderLabelRecordList) {
            List labelCodeList = Optional.ofNullable(orderLabelBaseResp).orElse(Lists.newArrayList()).stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
            labelCodes.addAll(labelCodeList);
        }
        return labelCodes;
    }

    private List<DgOrderLabelRespDto> convertLabel(List<? extends DgOrderLabelBaseRespDto> orderLabelBaseRespDtos, Map<String, DgOrderLabelRespDto> orderLabelRespDtoMaps) {
        return orderLabelBaseRespDtos.stream().map(e -> {
            if (orderLabelRespDtoMaps.containsKey(e.getLabelCode())) {
                DgOrderLabelRespDto orderLabelRespDto = (DgOrderLabelRespDto)orderLabelRespDtoMaps.get(e.getLabelCode());
                DgOrderLabelRespDto newOrderLabel = new DgOrderLabelRespDto();
                CubeBeanUtils.copyProperties((Object)newOrderLabel, (Object)orderLabelRespDto, (String[])new String[0]);
                newOrderLabel.setOrderId(e.getOrderId());
                if (e instanceof DgOrderLabelItemRespDto) {
                    newOrderLabel.setSkuCode(((DgOrderLabelItemRespDto)e).getSkuCode());
                }
                return newOrderLabel;
            }
            return null;
        }).collect(Collectors.toList());
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgOrderLabelEo orderLabelEo = (DgOrderLabelEo)this.dgOrderLabelDomain.getMapper().selectOne((Wrapper)queryOrderWrapper);
        if (orderLabelEo == null) {
            return "";
        }
        return orderLabelEo.getLabelCode();
    }
}

