/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelRecordDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderMergeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderMergeServiceImpl
implements IB2BOrderMergeService {
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;

    @Override
    public void mergeOrder(List<String> relevanceOrderNos, String mergeOrderNo) {
        if (CollectionUtils.isEmpty(relevanceOrderNos)) {
            return;
        }
        List list = ((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().select(new String[]{"id"}).in((Object)"sale_order_no", relevanceOrderNos)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            updateEo.setMergeOrderNo(mergeOrderNo);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"dr", (Object)0)).in((Object)"sale_order_no", relevanceOrderNos);
            this.performOrderInfoDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
            List orderIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            List dgOrderLabelRecordDtos = this.dgOrderLabelRecordDomain.queryByOrderIdsAndLabelCodes(orderIds, DgOrderLabelEnum.MERGE.getCode());
            List labelOrderIds = Optional.ofNullable(dgOrderLabelRecordDtos).orElse(Lists.newArrayList()).stream().map(DgOrderLabelRecordDto::getOrderId).collect(Collectors.toList());
            ArrayList addEos = Lists.newArrayList();
            for (Long orderId : orderIds) {
                if (labelOrderIds.contains(orderId)) continue;
                DgOrderLabelRecordEo labelRecordEo = new DgOrderLabelRecordEo();
                labelRecordEo.setLabelCode(DgOrderLabelEnum.MERGE.getCode());
                labelRecordEo.setOrderId(orderId);
                labelRecordEo.setDisplay(Integer.valueOf(0));
                addEos.add(labelRecordEo);
            }
            if (CollectionUtils.isNotEmpty((Collection)addEos)) {
                this.dgOrderLabelRecordDomain.insertBatch((List)addEos);
            }
        }
    }

    @Override
    public void cancelMerge(String mergeOrderNo) {
        if (StringUtils.isBlank((CharSequence)mergeOrderNo)) {
            return;
        }
        List list = ((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().select(new String[]{"id"}).eq((Object)"merge_order_no", (Object)mergeOrderNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List orderIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            updateEo.setMergeOrderNo("");
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"dr", (Object)0)).in((Object)"id", orderIds);
            this.performOrderInfoDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
            for (Long orderId : orderIds) {
                this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(orderId, DgOrderLabelEnum.MERGE);
            }
        }
    }
}

