/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirRespDto;
import com.yunxi.dg.base.center.promotion.dto.TradeTypeEnum;
import com.yunxi.dg.base.center.promotion.dto.req.ActivityOrderReqDto;
import com.yunxi.dg.base.center.promotion.dto.req.TradeTypeReqDto;
import com.yunxi.dg.base.center.promotion.dto.resp.ActivityOrderGiveInfoRespDto;
import com.yunxi.dg.base.center.promotion.dto.resp.ActivityOrderGiveItemRespDto;
import com.yunxi.dg.base.center.promotion.dto.resp.ActivityOrderItemDto;
import com.yunxi.dg.base.center.promotion.proxy.IPsActivityApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsActivityService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOmsActivityServiceImpl
implements IDgOmsActivityService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsActivityServiceImpl.class);
    @Resource
    private IPsActivityApiProxy psActivityApiProxy;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain dgOmsOrderLineBizQueryDomain;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private ICalculateAmountService calculateAmountService;

    @Override
    public List<DgPerformOrderItemReqDto> joinActivityByOrderNo(DgPerformOrderRespDto dto, Integer orderNode) {
        String saleOrderNo = dto.getSaleOrderNo();
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgPerformOrderAddrDomain.queryAddressByOrderNo(saleOrderNo);
        List orderLineDtos = this.dgOmsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(dto.getId());
        Map<Long, BigDecimal> map = this.calculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        ActivityOrderReqDto activityOrderReqDto = new ActivityOrderReqDto();
        activityOrderReqDto.setOrderNo(dto.getPlatformOrderNo());
        activityOrderReqDto.setStoreCode(dto.getPerformOrderSnapshotDto().getShopCode());
        activityOrderReqDto.setMarketingType(dto.getOrderType());
        activityOrderReqDto.setBuyerRemark(dto.getBuyerRemark());
        activityOrderReqDto.setSellerRemark(dto.getSellerRemark());
        activityOrderReqDto.setCustomerCode(dto.getPerformOrderSnapshotDto().getCustomerCode());
        activityOrderReqDto.setActivityNode(orderNode);
        activityOrderReqDto.setProvinceCode(dgPerformOrderAddrDto.getProvinceCode());
        activityOrderReqDto.setCityCode(dgPerformOrderAddrDto.getCityCode());
        activityOrderReqDto.setDistrictCode(dgPerformOrderAddrDto.getCountyCode());
        TradeTypeReqDto createTimeDto = new TradeTypeReqDto();
        createTimeDto.setTypeEnum(TradeTypeEnum.ORDER_TIME);
        createTimeDto.setTradeTime(Optional.ofNullable(dto.getPlatformCreateTime()).orElse(dto.getCreateTime()));
        TradeTypeReqDto payTimeDto = new TradeTypeReqDto();
        payTimeDto.setTypeEnum(TradeTypeEnum.PAY_TIME);
        payTimeDto.setTradeTime(dto.getPerformOrderPaymentDto().getPayTime());
        List activityOrderItemDtos = orderLineDtos.stream().filter(orderLineDto -> Objects.equals(orderLineDto.getGiftFlag(), YesNoEnum.NO.getValue())).map(orderLineDto -> {
            ActivityOrderItemDto activityOrderItemDto = new ActivityOrderItemDto();
            activityOrderItemDto.setSkuId(orderLineDto.getSkuId());
            activityOrderItemDto.setSkuCode(orderLineDto.getSkuCode());
            activityOrderItemDto.setItemId(orderLineDto.getItemId());
            activityOrderItemDto.setBuyNum(orderLineDto.getItemNum());
            activityOrderItemDto.setTotalPrice(null != map.get(orderLineDto.getId()) ? (BigDecimal)map.get(orderLineDto.getId()) : BigDecimal.ZERO);
            activityOrderItemDto.setItemType(Integer.valueOf(1));
            activityOrderItemDto.setRowId(orderLineDto.getId());
            return activityOrderItemDto;
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(activityOrderItemDtos)) {
            activityOrderReqDto.setTradeTimeType((List)Lists.newArrayList((Object[])new TradeTypeReqDto[]{createTimeDto, payTimeDto}));
            activityOrderReqDto.setOrderItems(activityOrderItemDtos);
            log.info("oms\u53c2\u4e0e\u6ee1\u8d60\u6d3b\u52a8\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)activityOrderReqDto));
            ActivityOrderGiveInfoRespDto activityOrderGiveInfoRespDto = (ActivityOrderGiveInfoRespDto)RestResponseHelper.extractData((RestResponse)this.psActivityApiProxy.handlePromotionGiveItem(activityOrderReqDto));
            log.info("oms\u53c2\u4e0e\u6ee1\u8d60\u6d3b\u52a8\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)activityOrderGiveInfoRespDto));
            return this.converGiftActivityResult(activityOrderGiveInfoRespDto);
        }
        return Lists.newArrayList();
    }

    @Override
    public void createOrderJoinActivity(DgBizPerformOrderReqDto dto) {
        DgPerformOrderAddrReqDto orderAddrReqDto = dto.getOrderAddrReqDto();
        ActivityOrderReqDto activityOrderReqDto = new ActivityOrderReqDto();
        activityOrderReqDto.setOrderNo(dto.getSaleOrderNo());
        activityOrderReqDto.setStoreCode(dto.getPerformOrderSnapshotDto().getShopCode());
        activityOrderReqDto.setMarketingType(dto.getOrderType());
        activityOrderReqDto.setBuyerRemark(dto.getBuyerRemark());
        activityOrderReqDto.setSellerRemark(dto.getSellerRemark());
        activityOrderReqDto.setCustomerCode(dto.getPerformOrderSnapshotDto().getCustomerCode());
        activityOrderReqDto.setActivityNode(Integer.valueOf(1));
        activityOrderReqDto.setProvinceCode(orderAddrReqDto.getProvinceCode());
        activityOrderReqDto.setCityCode(orderAddrReqDto.getCityCode());
        activityOrderReqDto.setDistrictCode(orderAddrReqDto.getCountyCode());
        TradeTypeReqDto createTimeDto = new TradeTypeReqDto();
        createTimeDto.setTypeEnum(TradeTypeEnum.ORDER_TIME);
        createTimeDto.setTradeTime(Optional.ofNullable(dto.getPlatformCreateTime()).orElse(new Date()));
        TradeTypeReqDto payTimeDto = new TradeTypeReqDto();
        payTimeDto.setTypeEnum(TradeTypeEnum.PAY_TIME);
        payTimeDto.setTradeTime(dto.getPerformOrderPaymentDto().getPayTime());
        List activityOrderItemDtos = dto.getItemList().stream().map(itemReqDto -> {
            ActivityOrderItemDto activityOrderItemDto = new ActivityOrderItemDto();
            activityOrderItemDto.setSkuId(itemReqDto.getSkuId());
            activityOrderItemDto.setSkuCode(itemReqDto.getSkuCode());
            activityOrderItemDto.setItemId(itemReqDto.getItemId());
            activityOrderItemDto.setBuyNum(itemReqDto.getItemNum());
            activityOrderItemDto.setTotalPrice(itemReqDto.getRealPayAmount());
            activityOrderItemDto.setItemType(Integer.valueOf(1));
            activityOrderItemDto.setRowId(itemReqDto.getId());
            return activityOrderItemDto;
        }).collect(Collectors.toList());
        activityOrderReqDto.setTradeTimeType((List)Lists.newArrayList((Object[])new TradeTypeReqDto[]{createTimeDto, payTimeDto}));
        activityOrderReqDto.setOrderItems(activityOrderItemDtos);
        log.info("oms\u53c2\u4e0e\u6ee1\u8d60\u6d3b\u52a8\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)activityOrderReqDto));
        if (CollectionUtil.isNotEmpty((Collection)activityOrderReqDto.getOrderItems())) {
            ActivityOrderGiveInfoRespDto activityOrderGiveInfoRespDto = (ActivityOrderGiveInfoRespDto)RestResponseHelper.extractData((RestResponse)this.psActivityApiProxy.handlePromotionGiveItem(activityOrderReqDto));
            log.info("oms\u53c2\u4e0e\u6ee1\u8d60\u6d3b\u52a8\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)activityOrderGiveInfoRespDto));
            List giftList = Optional.ofNullable(dto.getGiftList()).orElse(Lists.newArrayList());
            List<DgPerformOrderItemReqDto> giftItemReqDtos = this.converGiftActivityResult(activityOrderGiveInfoRespDto);
            if (CollectionUtil.isNotEmpty(giftItemReqDtos)) {
                giftList.addAll(giftItemReqDtos);
            }
            dto.setGiftList(giftList);
        }
    }

    private List<DgPerformOrderItemReqDto> converGiftActivityResult(ActivityOrderGiveInfoRespDto activityOrderGiveInfoRespDto) {
        try {
            List<Object> giftItemDtos = Lists.newArrayList();
            if (activityOrderGiveInfoRespDto != null && CollectionUtil.isNotEmpty((Collection)activityOrderGiveInfoRespDto.getGiveItems())) {
                List itemSkuCode = activityOrderGiveInfoRespDto.getGiveItems().stream().map(ActivityOrderGiveItemRespDto::getSkuCode).collect(Collectors.toList());
                ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
                reqDto.setSkuCodes(itemSkuCode);
                log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
                List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
                log.info("[\u8865\u5145\u5165\u53c2\u5546\u54c1\u4fe1\u606f]\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemRespDtos));
                Map itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (v1, v2) -> v1));
                giftItemDtos = activityOrderGiveInfoRespDto.getGiveItems().stream().map(giftItem -> {
                    DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)itemRespDtoMap.get(giftItem.getSkuCode());
                    AssertUtils.notNull((Object)dgItemSkuDetailRespDto, (String)"\u8d60\u54c1\u67e5\u4e0d\u5230\u5546\u54c1\u6863\u6848\u4fe1\u606f");
                    DgPerformOrderItemReqDto dgPerformOrderItemReqDto = new DgPerformOrderItemReqDto();
                    dgPerformOrderItemReqDto.setPromotionActivityCode(giftItem.getActivityCode());
                    dgPerformOrderItemReqDto.setItemName(dgItemSkuDetailRespDto.getItemName());
                    dgPerformOrderItemReqDto.setItemId(giftItem.getItemId());
                    dgPerformOrderItemReqDto.setItemCode(dgItemSkuDetailRespDto.getItemCode());
                    dgPerformOrderItemReqDto.setItemNum(giftItem.getNum());
                    dgPerformOrderItemReqDto.setPrice(BigDecimal.ZERO);
                    dgPerformOrderItemReqDto.setSkuId(giftItem.getSkuId());
                    dgPerformOrderItemReqDto.setSkuCode(giftItem.getSkuCode());
                    dgPerformOrderItemReqDto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
                    dgPerformOrderItemReqDto.setGift(YesNoEnum.YES.getValue());
                    dgPerformOrderItemReqDto.setDiscountAmount(BigDecimal.ZERO);
                    dgPerformOrderItemReqDto.setPayAmount(BigDecimal.ZERO);
                    dgPerformOrderItemReqDto.setRealPayAmount(BigDecimal.ZERO);
                    dgPerformOrderItemReqDto.setGiftType(DgGiftTypeEnum.AUTO.getType());
                    dgPerformOrderItemReqDto.setType((String)Optional.ofNullable(dgItemSkuDetailRespDto.getItemType()).map(String::valueOf).orElse(null));
                    if (CollectionUtil.isNotEmpty((Collection)dgItemSkuDetailRespDto.getDirList())) {
                        List dirList = BeanUtil.copyToList((Collection)dgItemSkuDetailRespDto.getDirList(), DirRespDto.class);
                        List dirRespDtoList = CollectionUtil.reverse((List)dirList);
                        for (int i = 0; i < dirRespDtoList.size(); ++i) {
                            DirRespDto dirRespDto = (DirRespDto)dirRespDtoList.get(i);
                            String code = dirRespDto.getCode();
                            String name = dirRespDto.getName();
                            if (i == 0) {
                                dgPerformOrderItemReqDto.setItemBackCategoryOneCode(code);
                                dgPerformOrderItemReqDto.setItemBackCategoryOneName(name);
                                continue;
                            }
                            if (i == 1) {
                                dgPerformOrderItemReqDto.setItemBackCategoryTwoCode(code);
                                dgPerformOrderItemReqDto.setItemBackCategoryTwoName(name);
                                continue;
                            }
                            if (i == 2) {
                                dgPerformOrderItemReqDto.setItemBackCategoryThirdCode(code);
                                dgPerformOrderItemReqDto.setItemBackCategoryThirdName(name);
                                continue;
                            }
                            if (i != 3) continue;
                            dgPerformOrderItemReqDto.setItemBackCategoryFourthCode(code);
                            dgPerformOrderItemReqDto.setItemBackCategoryFourthName(name);
                        }
                    }
                    return dgPerformOrderItemReqDto;
                }).collect(Collectors.toList());
            }
            return giftItemDtos;
        }
        catch (Exception e) {
            log.error("converGiftActivityResult", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }
}

