/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.item.api.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.enums.InstallationPushStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOmsOrderItemServiceImpl
implements IDgOmsOrderItemService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderItemServiceImpl.class);
    private static final String REPLACE_DIFFERENT_FLAG = "1";
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IDgCustomerStrategyRuleService customerStrategyRuleService;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizOptDomain omsOrderLineBizOptDomain;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain orderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderAmountCalculatorModeDomain;

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public void manualModifyOrderItem(DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOriginalOrderGoodsId(), (String)"originalOrderGoodsId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderLineDto oriOrderItemRespDto = this.omsOrderLineBizQueryDomain.queryInfoById(modifyOrderItemReqDto.getOriginalOrderGoodsId());
        AssertUtils.notNull((Object)oriOrderItemRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        log.info("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u539f\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)oriOrderItemRespDto));
        modifyOrderItemReqDto.setGift(oriOrderItemRespDto.getGiftFlag());
        ArrayList bundleItemList = com.google.common.collect.Lists.newArrayList();
        bundleItemList.add(modifyOrderItemReqDto);
        this.setSubItemList(bundleItemList);
        if (CollectionUtil.isNotEmpty((Collection)modifyOrderItemReqDto.getSubItemList())) {
            List amountDtoList = oriOrderItemRespDto.getAmountDtoList();
            Map amountDtoMap = amountDtoList.stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity(), (a, b) -> a));
            DgPerformOrderLineAmountDto saleDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            modifyOrderItemReqDto.setPrice(saleDto.getAmount().divide(oriOrderItemRespDto.getItemNum()));
            modifyOrderItemReqDto.setSalePrice(saleDto.getAmount().divide(oriOrderItemRespDto.getItemNum()));
            modifyOrderItemReqDto.setSaleAmount(saleDto.getAmount());
            DgPerformOrderLineAmountDto realAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            modifyOrderItemReqDto.setRealPayAmount(realAmountDto.getAmount());
            modifyOrderItemReqDto.setSurplusCanRefundPayAmount(realAmountDto.getAmount());
            modifyOrderItemReqDto.setPayAmount(((DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).getAmount());
            modifyOrderItemReqDto.setDiscountAmount(((DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).getAmount());
            modifyOrderItemReqDto.setItemNum(oriOrderItemRespDto.getItemNum());
            modifyOrderItemReqDto.setCalcItemNum(oriOrderItemRespDto.getCalcItemNum());
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(modifyOrderItemReqDto.getOrderId());
            List<DgPerformOrderLineDetailDto> subItemEos = this.bundleItemDivide((DgPerformOrderItemReqDto)modifyOrderItemReqDto, performOrderRespDto);
            this.omsOrderLineBizOptDomain.batchSaveOrderItemByNum(subItemEos, performOrderRespDto);
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(performOrderRespDto.getId());
            BigDecimal totalItemCount = orderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!totalItemCount.equals(performOrderRespDto.getGoodsTotalNum())) {
                DgPerformOrderInfoEo updateCountEo = new DgPerformOrderInfoEo();
                updateCountEo.setId(performOrderRespDto.getId());
                updateCountEo.setGoodsTotalNum(totalItemCount);
                this.performOrderInfoDomain.updateSelective((BaseEo)updateCountEo);
            }
            this.orderLineDomain.logicDeleteById(oriOrderItemRespDto.getId());
        } else {
            CubeBeanUtils.copyProperties((Object)oriOrderItemRespDto, (Object)modifyOrderItemReqDto, (String[])new String[]{"id", "salePrice", "saleAmount", "payAmount", "itemNum", "calcItemNum"});
            oriOrderItemRespDto.setGiftFlag(modifyOrderItemReqDto.getIfGift() != false ? DgGiftEnum.GIFT.getType() : DgGiftEnum.NOT_GIFT.getType());
            oriOrderItemRespDto.setItemType(modifyOrderItemReqDto.getType());
            DgPerformOrderLineEo update = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)update, (Object)oriOrderItemRespDto, (String[])new String[0]);
            log.info("\u4fee\u6539\u540e\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)update));
            this.orderLineDomain.updateSelective((BaseEo)update);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public void manualModifyOrderItem2(DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOriginalOrderGoodsId(), (String)"originalOrderGoodsId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderLineDto oriOrderItemRespDto = this.omsOrderLineBizQueryDomain.queryInfoById(modifyOrderItemReqDto.getOriginalOrderGoodsId());
        AssertUtils.notNull((Object)oriOrderItemRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        modifyOrderItemReqDto.setGift(oriOrderItemRespDto.getGiftFlag());
        ArrayList bundleItemList = com.google.common.collect.Lists.newArrayList();
        bundleItemList.add(modifyOrderItemReqDto);
        this.setSubItemList(bundleItemList);
        if (CollectionUtil.isNotEmpty((Collection)modifyOrderItemReqDto.getSubItemList())) {
            List amountDtoList = oriOrderItemRespDto.getAmountDtoList();
            Map amountDtoMap = amountDtoList.stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity(), (a, b) -> a));
            DgPerformOrderLineAmountDto saleDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            modifyOrderItemReqDto.setPrice(saleDto.getAmount().divide(oriOrderItemRespDto.getItemNum()));
            modifyOrderItemReqDto.setSalePrice(saleDto.getAmount().divide(oriOrderItemRespDto.getItemNum()));
            modifyOrderItemReqDto.setSaleAmount(saleDto.getAmount());
            DgPerformOrderLineAmountDto realAmountDto = (DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            modifyOrderItemReqDto.setRealPayAmount(realAmountDto.getAmount());
            modifyOrderItemReqDto.setSurplusCanRefundPayAmount(realAmountDto.getAmount());
            modifyOrderItemReqDto.setPayAmount(((DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).getAmount());
            modifyOrderItemReqDto.setDiscountAmount(((DgPerformOrderLineAmountDto)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).getAmount());
            modifyOrderItemReqDto.setItemNum(oriOrderItemRespDto.getItemNum());
            modifyOrderItemReqDto.setCalcItemNum(oriOrderItemRespDto.getCalcItemNum());
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(modifyOrderItemReqDto.getOrderId());
            List<DgPerformOrderLineDetailDto> subItemEos = this.bundleItemDivide((DgPerformOrderItemReqDto)modifyOrderItemReqDto, performOrderRespDto);
            this.omsOrderLineBizOptDomain.batchSaveOrderItemByNum(subItemEos, performOrderRespDto);
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(performOrderRespDto.getId());
            BigDecimal totalItemCount = orderLineDtos.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!totalItemCount.equals(performOrderRespDto.getGoodsTotalNum())) {
                DgPerformOrderInfoEo updateCountEo = new DgPerformOrderInfoEo();
                updateCountEo.setId(performOrderRespDto.getId());
                updateCountEo.setGoodsTotalNum(totalItemCount);
                this.performOrderInfoDomain.updateSelective((BaseEo)updateCountEo);
            }
            this.orderLineDomain.logicDeleteById(oriOrderItemRespDto.getId());
        } else {
            CubeBeanUtils.copyProperties((Object)oriOrderItemRespDto, (Object)modifyOrderItemReqDto, (String[])new String[]{"id", "salePrice", "saleAmount", "payAmount", "itemNum", "calcItemNum"});
            oriOrderItemRespDto.setGiftFlag(modifyOrderItemReqDto.getIfGift() != false ? DgGiftEnum.GIFT.getType() : DgGiftEnum.NOT_GIFT.getType());
            oriOrderItemRespDto.setItemType(modifyOrderItemReqDto.getType());
            DgPerformOrderLineEo update = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)update, (Object)oriOrderItemRespDto, (String[])new String[0]);
            log.info("\u8ba2\u5355\u884c:{},sku\u7f16\u7801:{},\u5355\u4f4d\u91cd\u91cf:{},\u5355\u4f4d\u4f53\u79ef:{}", new Object[]{oriOrderItemRespDto.getId(), oriOrderItemRespDto.getSkuCode(), modifyOrderItemReqDto.getWeight(), modifyOrderItemReqDto.getVolume()});
            update.setWeight((modifyOrderItemReqDto.getWeight() == null ? BigDecimal.ZERO : modifyOrderItemReqDto.getWeight()).multiply(oriOrderItemRespDto.getItemNum()));
            update.setVolume((modifyOrderItemReqDto.getVolume() == null ? BigDecimal.ZERO : modifyOrderItemReqDto.getVolume()).multiply(oriOrderItemRespDto.getItemNum()));
            this.orderLineDomain.updateSelective((BaseEo)update);
        }
    }

    public void removeOrderItemAndGoodsItem(Long orderLineId) {
        DgPerformOrderLineEo removeEo = new DgPerformOrderLineEo();
        removeEo.setId(orderLineId);
        this.orderLineDomain.logicDeleteById(orderLineId);
        List orderLineAmountDtos = this.orderLineAmountDomain.queryByOrderLineId(orderLineId);
        orderLineAmountDtos.forEach(amount -> this.orderLineAmountDomain.logicDeleteById(amount.getId()));
        DgPerformOrderItemLineDto modifyOrderLineRowDto = new DgPerformOrderItemLineDto();
        modifyOrderLineRowDto.setOrderLineId(orderLineId);
        this.performOrderItemLineDomain.removeOrderItem(modifyOrderLineRowDto);
    }

    @Override
    public void removeSaleOrderItemBySku(DgRemoveGiftBySkuReqDto reqDto) {
        DgPerformOrderItemReqDto queryDto = new DgPerformOrderItemReqDto();
        queryDto.setOrderId(reqDto.getSaleOrderId());
        queryDto.setSkuCodeList(reqDto.getSkuCodeList());
        List oriOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(queryDto);
        AssertUtils.notEmpty((Collection)oriOrderItemRespDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        if (CollectionUtils.isNotEmpty((Collection)oriOrderItemRespDtos)) {
            List orderLineDtoList = oriOrderItemRespDtos.stream().filter(saleOrderItemEo -> DgGiftTypeEnum.MANUAL.getType().equals(saleOrderItemEo.getGiftType())).collect(Collectors.toList());
            log.info("[\u6307\u5b9asku\u5220\u9664\u8d60\u54c1]\u6ee1\u8db3\u5220\u9664\u8d60\u54c1\u7684sku\u6709\uff1a{}", (Object)JSON.toJSONString(orderLineDtoList));
            AssertUtils.notEmpty(orderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            Collections.sort(orderLineDtoList, Comparator.comparing(BaseDto::getId));
            for (DgPerformOrderLineDto orderLineDto : orderLineDtoList) {
                this.removeOrderItemAndGoodsItem(orderLineDto.getId());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualAddSaleOrderItems(DgBizPerformOrderReqDto saleOrderReqDto) {
        AssertUtils.notNull((Object)saleOrderReqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList mergeList = com.google.common.collect.Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getItemList())) {
            saleOrderReqDto.getItemList().stream().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType()));
            mergeList.addAll(saleOrderReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getGiftList())) {
            saleOrderReqDto.getGiftList().stream().forEach(saleOrderItemReqDto -> {
                this.checkOrderItem((DgPerformOrderItemReqDto)saleOrderItemReqDto);
                saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                if (saleOrderItemReqDto.getGiftType() == null) {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                }
                saleOrderItemReqDto.setDiscountAmount(saleOrderItemReqDto.getItemNum().multiply(saleOrderItemReqDto.getSalePrice()));
                saleOrderItemReqDto.setPayAmount(BigDecimal.ZERO);
            });
            mergeList.addAll(saleOrderReqDto.getGiftList());
        }
        if (CollectionUtils.isNotEmpty((Collection)mergeList)) {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(saleOrderReqDto.getId());
            LinkedList dgPerformOrderLineDtos = new LinkedList();
            mergeList.forEach(itemReqDto -> {
                this.checkOrderItem((DgPerformOrderItemReqDto)itemReqDto);
                if (StringUtils.equals((CharSequence)itemReqDto.getType(), (CharSequence)DgSaleOrderItemTypeEnum.COMBINATION.getType())) {
                    log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)itemReqDto));
                    itemReqDto.getSubItemList().forEach(saleOrderItemReqDto -> {
                        if (!DgGiftEnum.GIFT.getType().equals(saleOrderItemReqDto.getGiftType()) && NumberUtil.equals((BigDecimal)saleOrderItemReqDto.getSalePrice(), (BigDecimal)BigDecimal.ZERO)) {
                            saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                            saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                        } else {
                            saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType());
                        }
                    });
                    List<DgPerformOrderLineDetailDto> subItemEos = this.bundleItemDivide((DgPerformOrderItemReqDto)itemReqDto, performOrderRespDto);
                    dgPerformOrderLineDtos.addAll(subItemEos);
                } else {
                    DgPerformOrderLineDetailDto orderLineDetailDto = new DgPerformOrderLineDetailDto();
                    CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)itemReqDto, (String[])new String[0]);
                    orderLineDetailDto.setOrderId(performOrderRespDto.getId());
                    orderLineDetailDto.setOrderNo(performOrderRespDto.getSaleOrderNo());
                    orderLineDetailDto.setItemType(itemReqDto.getType());
                    orderLineDetailDto.setGiftFlag(itemReqDto.getGift());
                    orderLineDetailDto.setCalcItemNum(itemReqDto.getItemNum());
                    orderLineDetailDto.setSaleAmount(itemReqDto.getSalePrice().multiply(itemReqDto.getItemNum()));
                    dgPerformOrderLineDtos.add(orderLineDetailDto);
                }
            });
            this.omsOrderLineBizOptDomain.batchSaveOrderItemByNum(dgPerformOrderLineDtos, performOrderRespDto);
        }
    }

    private void checkOrderItem(DgPerformOrderItemReqDto saleOrderItemReqDto) {
        AssertUtils.notNull((Object)saleOrderItemReqDto.getItemNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderItemReqDto.getSalePrice(), (String)"\u5546\u54c1\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderItemReqDto.getSkuCode(), (String)"skucode\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public void setSubItemList(List<DgPerformOrderItemReqDto> baseOrderItemDtoList) {
        Set skuCodeSet = baseOrderItemDtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toSet());
        ItemQueryDgReqDto reqDto = new ItemQueryDgReqDto();
        reqDto.setSkuCodes((List)com.google.common.collect.Lists.newArrayList(skuCodeSet));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List itemBundleList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.querySkuList(reqDto));
        log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)itemBundleList));
        if (CollUtil.isEmpty((Collection)itemBundleList)) {
            log.info("\u5546\u54c1\u884c\uff1a{} \u5339\u914d\u65e0\u7ec4\u5408\u5546\u54c1", (Object)JSON.toJSONString(skuCodeSet));
            return;
        }
        Map<String, List<DgItemSkuDetailRespDto>> skuCodeMap = itemBundleList.stream().collect(Collectors.groupingBy(DgItemSkuRespDto::getSkuCode));
        for (DgPerformOrderItemReqDto performOrderItemDto : baseOrderItemDtoList) {
            String skuCode = performOrderItemDto.getSkuCode();
            List<DgItemSkuDetailRespDto> rItemBundleRespDtos = skuCodeMap.get(skuCode);
            DgItemSkuDetailRespDto detailRespDto = rItemBundleRespDtos.get(0);
            if (!skuCodeMap.containsKey(skuCode) || Objects.isNull(detailRespDto.getBundleSkus())) continue;
            Optional.ofNullable(detailRespDto.getBundleSkus()).ifPresent(bundle -> {
                performOrderItemDto.setType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
                performOrderItemDto.setGroupGift(performOrderItemDto.getGift());
                List subItemList = bundle.stream().map(r -> {
                    AssertUtils.notNull((Object)r.getPriceAllocationRatio(), (String)"\u7ec4\u5408\u5546\u54c1\u4e3b\u6570\u636e\u672a\u914d\u7f6e\u4ef7\u683c\u5206\u644a\u6bd4\u4f8b");
                    DgPerformOrderItemReqDto subItem = new DgPerformOrderItemReqDto();
                    BeanUtil.copyProperties((Object)performOrderItemDto, (Object)subItem, (String[])new String[0]);
                    BeanUtil.copyProperties((Object)r, (Object)subItem, (String[])new String[0]);
                    subItem.setItemNum(new BigDecimal(r.getNum()));
                    subItem.setSkuId(r.getSubSkuId());
                    subItem.setSkuCode(r.getSubSkuCode());
                    subItem.setSkuName(r.getSubSkuName());
                    subItem.setItemId(r.getSubItemId());
                    subItem.setItemCode(r.getSubItemCode());
                    subItem.setItemName(r.getSubItemName());
                    BigDecimal unitPrice = Convert.toBigDecimal((Object)r.getRetailPrice(), (BigDecimal)BigDecimal.ZERO);
                    subItem.setSalePrice(unitPrice);
                    subItem.setPrice(unitPrice);
                    subItem.setTransactionPrice(unitPrice);
                    BigDecimal priceAllocationRatio = r.getPriceAllocationRatio().divide(new BigDecimal(100));
                    subItem.setPriceAllocationRatio(priceAllocationRatio);
                    Integer gift = performOrderItemDto.getGift();
                    if (!DgGiftEnum.GIFT.getType().equals(gift) && NumberUtil.equals((BigDecimal)unitPrice, (BigDecimal)BigDecimal.ZERO)) {
                        subItem.setGift(DgGiftEnum.GIFT.getType());
                    }
                    return subItem;
                }).collect(Collectors.toList());
                performOrderItemDto.setSubItemList(subItemList);
                log.info("[\u7ec4\u5408\u5546\u54c1\u67e5\u8be2]\u7ec4\u5408\u5546\u54c1:{},\u7ec4\u88c5\u540e\u5b50\u5546\u54c1\u7ed3\u679c:{}", (Object)performOrderItemDto.getSkuCode(), (Object)JSON.toJSONString(subItemList));
            });
        }
    }

    @Override
    public List<DgPerformOrderLineDetailDto> bundleItemDivide(DgPerformOrderItemReqDto itemReqDto, DgPerformOrderRespDto performOrderRespDto) {
        List subItemList = itemReqDto.getSubItemList();
        subItemList.sort(Comparator.comparing(DgPerformOrderItemDto::getGift).reversed());
        ArrayList subItemEos = Lists.newArrayList();
        for (int i = 0; i < subItemList.size(); ++i) {
            DgPerformOrderItemDto subItemReqDto = (DgPerformOrderItemDto)subItemList.get(i);
            if (null == itemReqDto.getCalcItemNum()) {
                itemReqDto.setCalcItemNum(itemReqDto.getItemNum());
            }
            if (null == subItemReqDto.getCalcItemNum()) {
                subItemReqDto.setCalcItemNum(subItemReqDto.getItemNum());
            }
            DgPerformOrderLineDetailDto orderLineDetailDto = new DgPerformOrderLineDetailDto();
            if (null != performOrderRespDto) {
                CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)performOrderRespDto, (String[])new String[0]);
            }
            CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)subItemReqDto, (String[])new String[0]);
            orderLineDetailDto.setItemType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
            orderLineDetailDto.setGiftFlag(subItemReqDto.getGift());
            orderLineDetailDto.setGroupItemId(itemReqDto.getItemId());
            orderLineDetailDto.setGroupSkuCode(itemReqDto.getSkuCode());
            orderLineDetailDto.setGroupItemName(itemReqDto.getItemName());
            orderLineDetailDto.setGroupItemNum(itemReqDto.getCalcItemNum());
            orderLineDetailDto.setGroupItemPrice(itemReqDto.getPrice());
            orderLineDetailDto.setGroupItemPayAmount(itemReqDto.getPayAmount());
            orderLineDetailDto.setGroupItemDiscountAmount(itemReqDto.getDiscountAmount());
            orderLineDetailDto.setGroupItemSaleAmount(itemReqDto.getSalePrice().multiply(itemReqDto.getCalcItemNum()));
            orderLineDetailDto.setItemNum(itemReqDto.getItemNum().multiply(subItemReqDto.getItemNum()));
            orderLineDetailDto.setCalcItemNum(itemReqDto.getItemNum().multiply(subItemReqDto.getItemNum()));
            if (DgGiftEnum.NOT_GIFT.getType().equals(itemReqDto.getGift())) {
                this.omsOrderAmountCalculatorModeDomain.calculatorGroupItemAmount(itemReqDto, orderLineDetailDto, i);
            } else {
                orderLineDetailDto.setPayAmount(BigDecimal.ZERO);
                orderLineDetailDto.setDiscountAmount(BigDecimal.ZERO);
                orderLineDetailDto.setRealPayAmount(BigDecimal.ZERO);
                orderLineDetailDto.setSalePrice(BigDecimal.ZERO);
                orderLineDetailDto.setPrice(BigDecimal.ZERO);
            }
            orderLineDetailDto.setFxOrderNo(itemReqDto.getFxOrderNo());
            log.info("\u8ba2\u5355\u884c:{},sku\u7f16\u7801:{},\u5355\u4f4d\u91cd\u91cf:{},\u5355\u4f4d\u4f53\u79ef:{}", new Object[]{orderLineDetailDto.getId(), orderLineDetailDto.getSkuCode(), itemReqDto.getWeight(), itemReqDto.getVolume()});
            orderLineDetailDto.setWeight((itemReqDto.getWeight() == null ? BigDecimal.ZERO : itemReqDto.getWeight()).multiply(orderLineDetailDto.getItemNum()));
            orderLineDetailDto.setWeight((itemReqDto.getVolume() == null ? BigDecimal.ZERO : itemReqDto.getVolume()).multiply(orderLineDetailDto.getItemNum()));
            subItemEos.add(orderLineDetailDto);
        }
        return subItemEos;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderId")
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderItem(Long saleOrderId, Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderLineDto orderLineDto = this.omsOrderLineBizQueryDomain.queryById(id);
        AssertUtils.notNull((Object)orderLineDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        if (!DgGiftTypeEnum.AUTO.getType().equals(orderLineDto.getGiftFlag()) && !DgGiftTypeEnum.MANUAL.getType().equals(orderLineDto.getGiftType())) {
            log.warn("[\u5220\u9664\u5546\u54c1]\u5f53\u524d\u8ba2\u5355\u5546\u54c1\u5c5e\u4e8e\u539f\u5355\u5546\u54c1\u6216\u8005\u975e\u8d60\u54c1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u5546\u54c1\u884cid={}", (Object)id);
            throw DgPcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        this.removeOrderItemAndGoodsItem(id);
    }

    @Override
    public void manualModifyOrderItemForDifference(DgPerformOrderRespDto saleOrderRespDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId(), (String)"originalOrderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderRespDto.getId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderLineDto oriOrderItemRespDto = this.omsOrderLineBizQueryDomain.queryInfoById(modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId());
        AssertUtils.notNull((Object)oriOrderItemRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        log.info("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u539f\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)oriOrderItemRespDto));
        this.checkOrderItemForDifference(oriOrderItemRespDto, modifyOrderItemForDifferenceReqDto);
        ArrayList newOrderItemDtoList = com.google.common.collect.Lists.newArrayList();
        AssertUtils.notEmpty((Collection)modifyOrderItemForDifferenceReqDto.getNewOrderItemList(), (String)"\u66ff\u6362\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < modifyOrderItemForDifferenceReqDto.getNewOrderItemList().size(); ++i) {
            DgPerformOrderItemReqDto modifyOrderItemReqDto = (DgPerformOrderItemReqDto)modifyOrderItemForDifferenceReqDto.getNewOrderItemList().get(i);
            modifyOrderItemReqDto.setGift(oriOrderItemRespDto.getGiftFlag());
            modifyOrderItemReqDto.setCalcItemNum(modifyOrderItemReqDto.getItemNum());
            if (oriOrderItemRespDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                this.omsOrderAmountCalculatorModeDomain.calculatorOrderItemAmountForDifference(modifyOrderItemReqDto, oriOrderItemRespDto, i, modifyOrderItemForDifferenceReqDto.getNewOrderItemList().size() - 1);
            } else {
                modifyOrderItemReqDto.setSalePrice(BigDecimal.ZERO);
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyOrderItemReqDto.getSubItemList())) {
                modifyOrderItemReqDto.getSubItemList().forEach(saleOrderItemReqDto -> {
                    if (!DgGiftEnum.GIFT.getType().equals(oriOrderItemRespDto.getGiftType()) && NumberUtil.equals((BigDecimal)saleOrderItemReqDto.getSalePrice(), (BigDecimal)BigDecimal.ZERO)) {
                        saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                        saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                    } else {
                        saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType());
                    }
                });
                List<DgPerformOrderLineDetailDto> saleOrderItemEos = this.bundleItemDivide(modifyOrderItemReqDto, saleOrderRespDto);
                newOrderItemDtoList.addAll(saleOrderItemEos);
                continue;
            }
            DgPerformOrderLineDetailDto orderLineDetailDto = new DgPerformOrderLineDetailDto();
            CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)oriOrderItemRespDto, (String[])new String[]{"createTime", "updateTime"});
            CubeBeanUtils.copyProperties((Object)orderLineDetailDto, (Object)modifyOrderItemReqDto, (String[])new String[]{"createTime", "updateTime"});
            if (NumberUtil.equals((BigDecimal)modifyOrderItemReqDto.getPayAmount(), (BigDecimal)BigDecimal.ZERO)) {
                orderLineDetailDto.setGiftFlag(DgGiftEnum.GIFT.getType());
                orderLineDetailDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
            }
            orderLineDetailDto.setItemType(modifyOrderItemReqDto.getType());
            orderLineDetailDto.setItemNum(modifyOrderItemReqDto.getItemNum());
            orderLineDetailDto.setCalcItemNum(modifyOrderItemReqDto.getItemNum());
            orderLineDetailDto.setSaleAmount(modifyOrderItemReqDto.getPayAmount().add(modifyOrderItemReqDto.getDiscountAmount()));
            newOrderItemDtoList.add(orderLineDetailDto);
        }
        newOrderItemDtoList.stream().forEach(saleOrderItemEo -> saleOrderItemEo.setReplaceDifferentFlag(REPLACE_DIFFERENT_FLAG));
        this.omsOrderLineBizOptDomain.batchSaveOrderItemByNum((List)newOrderItemDtoList, saleOrderRespDto);
        this.removeOrderItemAndGoodsItem(modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId());
    }

    private void checkOrderItemForDifference(DgPerformOrderLineDto oriOrderItemDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        if (Objects.equals(oriOrderItemDto.getGiftFlag(), DgGiftEnum.GIFT.getType())) {
            throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_NOT_PERMISSIONS.builderException();
        }
        if (CollectionUtils.isNotEmpty((Collection)oriOrderItemDto.getAmountDtoList())) {
            BigDecimal discountAmountOfNewItems;
            BigDecimal payAmount;
            Map orderLineAmountDtoMap = oriOrderItemDto.getAmountDtoList().stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, Function.identity(), (a, b) -> a));
            BigDecimal payAmountOfNewItems = modifyOrderItemForDifferenceReqDto.getNewOrderItemList().stream().map(DgPerformOrderItemDto::getPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal bigDecimal = payAmount = orderLineAmountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode()) != null ? ((DgPerformOrderLineAmountDto)orderLineAmountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).getAmount() : BigDecimal.ZERO;
            if (payAmount.compareTo(payAmountOfNewItems) != 0) {
                throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_EXCEPTION.buildBizException(new Object[]{"\u66ff\u6362\u7684\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\u4e0e\u539f\u5546\u54c1\u4e0d\u4e00\u81f4"});
            }
            BigDecimal discountAmount = orderLineAmountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode()) != null ? ((DgPerformOrderLineAmountDto)orderLineAmountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode())).getAmount() : BigDecimal.ZERO;
            if (discountAmount.compareTo(discountAmountOfNewItems = modifyOrderItemForDifferenceReqDto.getNewOrderItemList().stream().map(DgPerformOrderItemDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_EXCEPTION.buildBizException(new Object[]{"\u66ff\u6362\u7684\u5546\u54c1\u603b\u4f18\u60e0\u4e0e\u539f\u5546\u54c1\u4e0d\u4e00\u81f4"});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)oriOrderItemDto.getGroupSkuCode())) {
            for (DgPerformOrderItemReqDto subOrderItemReqDto : modifyOrderItemForDifferenceReqDto.getNewOrderItemList()) {
                if (!CollectionUtils.isNotEmpty((Collection)subOrderItemReqDto.getSubItemList())) continue;
                throw DgPcpTradeExceptionCode.EXCHANGE_EXCEPTION_BY_COMBINATION.builderException();
            }
        }
    }

    @Override
    public void updateOrderItemCountAndAmount(DgPerformOrderRespDto performOrderRespDto) {
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(performOrderRespDto.getId());
        BigDecimal goodsTotalNum = orderLineDtoList.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = Optional.ofNullable(orderLineDtoList.stream().map(saleOrderItemReqDto -> {
            if (saleOrderItemReqDto.getSalePrice() != null) {
                return saleOrderItemReqDto.getSalePrice().multiply(saleOrderItemReqDto.getItemNum());
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal discountAmount = Optional.ofNullable(orderLineDtoList.stream().map(DgPerformOrderLineDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        BigDecimal freightCost = Optional.ofNullable(performOrderRespDto.getFreightCost()).orElse(BigDecimal.ZERO);
        BigDecimal payAmount = orderLineDtoList.stream().map(DgPerformOrderLineDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal merchantReceivableAmount = goodsTotalAmount.add(freightCost).subtract(discountAmount);
        log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{}, \u5546\u5bb6\u5e94\u6536\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, discountAmount, merchantReceivableAmount});
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(performOrderRespDto.getId());
        updateReqDto.setGoodsTotalNum(goodsTotalNum);
        updateReqDto.setGoodsTotalAmount(goodsTotalAmount);
        updateReqDto.setPayAmount(payAmount);
        updateReqDto.setRealPayAmount(payAmount);
        updateReqDto.setDiscountAmount(discountAmount);
        updateReqDto.setMerchantReceivableAmount(merchantReceivableAmount);
        this.performOrderInfoDomain.modifySaleOrder((DgPerformOrderInfoDto)updateReqDto);
        DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
        amountEo.setId(performOrderRespDto.getPerformOrderAmountDto().getId());
        amountEo.setGoodsTotalNum(goodsTotalNum);
        amountEo.setGoodsTotalAmount(goodsTotalAmount);
        amountEo.setPayAmount(payAmount);
        amountEo.setRealPayAmount(payAmount);
        amountEo.setDiscountAmount(discountAmount);
        amountEo.setMerchantReceivableAmount(merchantReceivableAmount);
        this.performOrderAmountDomain.updateSelective((BaseEo)amountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderItemSupplyPrice(List<DgPerformOrderLineDto> orderLineDtoList, Map<String, BigDecimal> skuSupplyPriceMap) {
        if (MapUtils.isEmpty(skuSupplyPriceMap)) {
            return;
        }
        ArrayList addAmountList = new ArrayList();
        ArrayList upAmountList = new ArrayList();
        orderLineDtoList.stream().filter(dto -> {
            List amountDtoList = dto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(amountDtoList)) {
                return false;
            }
            DgPerformOrderLineAmountDto amountDto = (DgPerformOrderLineAmountDto)dto.getAmountDtoList().get(0);
            return amountDto.getAmount() != null && amountDto.getAmount().compareTo(BigDecimal.ZERO) > 0;
        }).forEach(orderLineDto -> {
            List amountDtoList = orderLineDto.getAmountDtoList().stream().filter(amount -> amount.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode())).collect(Collectors.toList());
            DgPerformOrderLineAmountEo amountEo = new DgPerformOrderLineAmountEo();
            if (CollectionUtils.isNotEmpty(amountDtoList)) {
                CubeBeanUtils.copyProperties((Object)amountEo, amountDtoList.get(0), (String[])new String[0]);
                amountEo.setAmount((BigDecimal)skuSupplyPriceMap.get(orderLineDto.getSkuCode()));
                upAmountList.add(amountEo);
            } else {
                amountEo.setOrderLineId(orderLineDto.getId());
                amountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                amountEo.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                amountEo.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                amountEo.setAmount((BigDecimal)skuSupplyPriceMap.get(orderLineDto.getSkuCode()));
                addAmountList.add(amountEo);
            }
        });
        if (CollectionUtils.isNotEmpty(addAmountList)) {
            this.orderLineAmountDomain.insertBatch(addAmountList);
        }
        if (CollectionUtils.isNotEmpty(upAmountList)) {
            upAmountList.forEach(upAmount -> this.orderLineAmountDomain.updateSelective((BaseEo)upAmount));
        }
    }

    @Override
    public void modifyHomeInstallation(DgPerformOrderReqDto orderReqDto) {
        log.info("\u5f00\u59cb\u4fee\u6539\u5546\u54c1\u660e\u7ec6-\u4e0a\u95e8\u5b89\u88c5\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)orderReqDto));
        Long id = orderReqDto.getId();
        DgPerformOrderExtensionEo queryByOrderId = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)id)).one();
        if (null != queryByOrderId && queryByOrderId.getInstallationPushStatus().equals(InstallationPushStatusEnum.PUSHED_SUCCESS)) {
            throw new BizException("\u5f53\u524d\u72b6\u6001\u5df2\u7ecf\u662f\u63a8\u9001\u6210\u529f\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539\u4e0a\u95e8\u5b89\u88c5");
        }
        List updateOrderLine = ((ExtQueryChainWrapper)this.performOrderItemLineDomain.filter().eq((Object)"order_id", (Object)orderReqDto.getId())).list();
        if (CollectionUtils.isNotEmpty((Collection)updateOrderLine)) {
            for (DgPerformOrderItemLineEo dgPerformOrderItemLineEo : updateOrderLine) {
                dgPerformOrderItemLineEo.setHomeInstallation(orderReqDto.getHomeInstallation());
                this.performOrderItemLineDomain.updateSelective((BaseEo)dgPerformOrderItemLineEo);
            }
        }
    }

    @Override
    public void installationPush(DgPerformOrderReqDto orderReqDto) {
        log.info("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230\u5916\u90e8\u7cfb\u7edf:{}", (Object)JSON.toJSONString((Object)orderReqDto));
        String autoInstallationPushAction = orderReqDto.getAutoInstallationPushAction();
        Long id = orderReqDto.getId();
        DgPerformOrderRespDto dgPerformOrderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoById(id);
        DgPerformOrderExtensionEo queryByOrderId = (DgPerformOrderExtensionEo)((ExtQueryChainWrapper)this.dgPerformOrderExtensionDomain.filter().eq((Object)"order_id", (Object)id)).one();
        List dgPerformOrderItemLineEos = ((ExtQueryChainWrapper)this.performOrderItemLineDomain.filter().eq((Object)"order_id", (Object)id)).list();
        DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = (DgPerformOrderSnapshotEo)((ExtQueryChainWrapper)this.dgPerformOrderSnapshotDomain.filter().eq((Object)"order_id", (Object)id)).one();
        if (null != autoInstallationPushAction && autoInstallationPushAction.equals(REPLACE_DIFFERENT_FLAG) && dgPerformOrderRespDto.getOrderStatus().equals(DgOmsSaleOrderStatus.DELIVERED.getCode())) {
            DgCustomerAuditStrategyRuleRespDto dgCustomerAuditStrategyRuleRespDto = this.customerStrategyRuleService.queryByRuleCode("ORDER_INSTALL_STRATEGY");
            if (null != dgCustomerAuditStrategyRuleRespDto.getAutomaticPushInstallation()) {
                Integer automaticPushInstallation = dgCustomerAuditStrategyRuleRespDto.getAutomaticPushInstallation();
                String shopCode = dgPerformOrderSnapshotEo.getShopCode();
                boolean action = this.customerStrategyRuleService.verifyOrderInstallStrategy(dgCustomerAuditStrategyRuleRespDto, shopCode);
                String homeInstallation = "0";
                if (CollectionUtils.isNotEmpty((Collection)dgPerformOrderItemLineEos)) {
                    DgPerformOrderItemLineEo dgPerformOrderItemLineEo = (DgPerformOrderItemLineEo)dgPerformOrderItemLineEos.get(0);
                    homeInstallation = dgPerformOrderItemLineEo.getHomeInstallation();
                }
                if (automaticPushInstallation.equals(REPLACE_DIFFERENT_FLAG) && action && homeInstallation.equals(REPLACE_DIFFERENT_FLAG)) {
                    String result = "PUSHED_SUCCESS";
                    queryByOrderId.setInstallationPushStatus(result);
                } else {
                    log.info("\u81ea\u52a8\u63a8\u9001\u5b89\u88c5\u5931\u8d25");
                }
            }
        } else if (dgPerformOrderRespDto.getOrderStatus().equals(DgOmsSaleOrderStatus.DELIVERED.getCode()) || dgPerformOrderRespDto.getOrderStatus().equals(DgOmsSaleOrderStatus.COMPLETE.getCode())) {
            log.info("\u6267\u884c\u624b\u52a8\u63a8\u9001");
            String result = "PUSHED_SUCCESS";
            queryByOrderId.setInstallationPushStatus(result);
        }
        this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)queryByOrderId);
    }
}

