/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.credit.api.ICreditRecordApi;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRecordPageReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.query.ICreditRecordQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.query.IStandardPriceConfigQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.mj.center.shop.api.dto.response.ShopExtRespDto;
import com.mj.center.shop.api.query.IShopExtQueryApi;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountQueryReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTypeBalanceRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.customer.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.AccountBalanceOrderLineReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.AccountBalanceReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.SkuSupplyPriceQueryReqDto;
import com.yunxi.dg.base.center.openapi.dto.response.ExternalAccountBalanceRespDto;
import com.yunxi.dg.base.center.openapi.proxy.account.IAccountBalanceApiProxy;
import com.yunxi.dg.base.center.openapi.proxy.price.IPlaceOrderGoodsApiProxy;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryV2ReqDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountCategoryEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.tradeflow.DgTradeItemFlowStatusEnum;
import com.yunxi.dg.base.center.trade.constants.tradeflow.DgTradeItemFlowTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderBusinessAccountConfigDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ITradeItemFlowRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizOptDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgTradeItemFlowRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderCheckPaymentAccountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgTradeItemFlowRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.B2COrderPayWayEnum;
import com.yunxi.dg.base.center.trade.enums.ChannelRelationBusinessModelEnum;
import com.yunxi.dg.base.center.trade.enums.SaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderBusinessAccountConfigEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsPaymentAccountService;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.center.trade.utils.selector.B2COrderPaySelector;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgOmsPaymentAccountServiceImpl
implements IDgOmsPaymentAccountService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsPaymentAccountServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DgOmsPaymentAccountServiceImpl.class);
    private static final String YES = "1";
    private static final String NO = "0";
    private static final String REAL_PAYMENT_PRICE = "2";
    private static final String PAYMENT_PRICE = "1";
    private static final String SUPPLY_PRICE = "0";
    @Value(value="${oms.shop.supply.price.check.enable:false}")
    private Boolean shopSupplyPriceCheckEnable;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICreditRecordQueryApi iCreditRecordQueryApi;
    @Resource
    private IStandardPriceConfigQueryApi standardPriceConfigQueryApi;
    @Resource
    private ICreditRecordApi creditRecordApi;
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IAccountApiProxy accountApiProxy;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDgPriceQueryV2ApiProxy priceQueryV2ApiProxy;
    @Resource
    private IAccountBalanceApiProxy accountBalanceApiProxy;
    @Resource
    private IDgOmsOrderItemService omsOrderItemService;
    @Resource
    private ITradeItemFlowRecordDomain pyTradeItemFlowRecordService;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderLineBizOptDomain omsOrderLineBizOptDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgCsChannelQueryApiProxy dgCsChannelQueryApiProxy;
    @Resource
    private IDgOrderBusinessAccountConfigDomain dgOrderBusinessAccountConfigDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IPlaceOrderGoodsApiProxy placeOrderGoodsApiProxy;

    @Override
    public void preemptCreditAccount(DgPerformOrderRespDto respDto) {
        ShopExtRespDto shopExtRespDto = (ShopExtRespDto)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryByCode(respDto.getPerformOrderSnapshotDto().getShopCode()));
        if ((shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) && StringUtils.equals((CharSequence)shopExtRespDto.getSupplyPriceCheck(), (CharSequence)"0")) {
            LOGGER.info("{} \u8be5\u95e8\u5e97\u4e0d\u9700\u8981\u8fdb\u884c\u4f59\u989d\u6263\u6b3e\uff0c\u65e0\u9700\u6821\u9a8c\u4f9b\u8d27\u4ef7", (Object)respDto.getPerformOrderSnapshotDto().getShopCode());
            return;
        }
        DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = this.checkPaymentAccount(respDto);
        if (!bizSaleOrderCheckPaymentAccountRespDto.isCheckResult()) {
            throw DgPcpTradeExceptionCode.ACCOUNT_SUB_CHECK_FAIL.buildBizException(new Object[]{bizSaleOrderCheckPaymentAccountRespDto.getCheckResultErrorMsg()});
        }
        if (CollectionUtils.isEmpty((Collection)bizSaleOrderCheckPaymentAccountRespDto.getOrderLineDtoList())) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5339\u914d\u7684\u5546\u54c1\u884c \u65e0\u9700\u6267\u884c\u4fc3\u9500");
            return;
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setBusinessOrderNo(respDto.getSaleOrderNo());
        creditRecordReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        creditRecordReqDto.setReason(Integer.valueOf(5));
        creditRecordReqDto.setOrderQuota(bizSaleOrderCheckPaymentAccountRespDto.getCheckAmount());
        this.omsOrderItemService.updateOrderItemSupplyPrice(bizSaleOrderCheckPaymentAccountRespDto.getOrderLineDtoList(), bizSaleOrderCheckPaymentAccountRespDto.getMatchItemSupplyPriceMap());
        if (shopExtRespDto.getIsCutPayment() == 0 || shopExtRespDto.getIsCutPayment() == null) {
            LOGGER.info("{} \u8be5\u95e8\u5e97\u65e0\u9700\u8fdb\u884c\u4f59\u989d\u6263\u6b3e", (Object)respDto.getPerformOrderSnapshotDto().getShopCode());
            return;
        }
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = this.addPayRecord(respDto, creditRecordReqDto, shopExtRespDto);
        creditRecordReqDto.setOrderNo(pyTradeItemFlowRecordReqDto.getPayFlowNo());
        LOGGER.info("\u8c03\u7528\u4f59\u989d\u8d26\u6237\u9884\u5360 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)creditRecordReqDto));
        try {
            RestResponse restResponse = this.creditRecordApi.addCreditRecord(creditRecordReqDto);
            Long outNo = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
            pyTradeItemFlowRecordReqDto.setPayFlowLinkOutNo(String.valueOf(outNo));
            this.updatePayRecordStatus(pyTradeItemFlowRecordReqDto, DgTradeItemFlowStatusEnum.LOCKED.getCode());
        }
        catch (BizException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.updatePayRecordStatus(pyTradeItemFlowRecordReqDto, DgTradeItemFlowStatusEnum.FAIL.getCode());
            throw DgPcpTradeExceptionCode.ACCOUNT_SUB_CHECK_FAIL.buildBizException(new Object[]{"\u9884\u5360\u989d\u5ea6\u5931\u8d25:" + e.getMessage()});
        }
    }

    private DgTradeItemFlowRecordReqDto addPayRecord(DgPerformOrderRespDto saleOrderRespDto, CreditRecordReqDto creditRecordReqDto, ShopExtRespDto shopExtRespDto) {
        DgTradeItemFlowRecordReqDto queryDto = new DgTradeItemFlowRecordReqDto();
        queryDto.setBizOrderNo(saleOrderRespDto.getSaleOrderNo());
        ArrayList payFlowStatusList = Lists.newArrayList();
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.CREATED.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.LOCKED.getCode());
        payFlowStatusList.add(DgTradeItemFlowStatusEnum.SUCCESS.getCode());
        List recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(queryDto, (List)payFlowStatusList);
        if (CollectionUtils.isNotEmpty((Collection)recordRespDtoList)) {
            LOGGER.info("\u83b7\u53d6\u5230\u65e7\u6d41\u6c34\uff0c\u65e0\u9700\u518d\u521b\u5efa\u6d41\u6c34");
            if (recordRespDtoList.size() > 1) {
                throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u591a\u6761accept\u6d41\u6c34");
            }
            List lockedFlowRecords = recordRespDtoList.stream().filter(pyTradeItemFlowRecordRespDto -> pyTradeItemFlowRecordRespDto.getPayFlowStatus().equalsIgnoreCase(DgTradeItemFlowStatusEnum.LOCKED.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lockedFlowRecords)) {
                throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u5df2\u5b58\u5728\u6210\u529f\u9501\u5b9a\u7684\u6d41\u6c34");
            }
            DgTradeItemFlowRecordReqDto resultReqDto = new DgTradeItemFlowRecordReqDto();
            CubeBeanUtils.copyProperties((Object)resultReqDto, recordRespDtoList.get(0), (String[])new String[0]);
            return resultReqDto;
        }
        DgTradeItemFlowTypeEnum tradeItemFlowTypeEnum = DgTradeItemFlowTypeEnum.enumOf((String)shopExtRespDto.getCutPaymentType());
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = new DgTradeItemFlowRecordReqDto();
        pyTradeItemFlowRecordReqDto.setBizOrderNo(saleOrderRespDto.getSaleOrderNo());
        pyTradeItemFlowRecordReqDto.setPayFlowAmount(creditRecordReqDto.getOrderQuota());
        pyTradeItemFlowRecordReqDto.setPayFlowNo(String.valueOf(IdGenrator.getDistributedId()));
        pyTradeItemFlowRecordReqDto.setPayItemName(tradeItemFlowTypeEnum.getPayItemName());
        pyTradeItemFlowRecordReqDto.setPayFlowType("PAY");
        pyTradeItemFlowRecordReqDto.setBizOrderType("SALEORDER");
        pyTradeItemFlowRecordReqDto.setPayItemType(tradeItemFlowTypeEnum.getPayItemType());
        pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
        AssertUtils.notBlank((String)pyTradeItemFlowRecordReqDto.getBizOrderNo(), (String)"\u5173\u8054\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Long pyId = this.pyTradeItemFlowRecordService.addPyTradeItemFlowRecord(pyTradeItemFlowRecordReqDto);
        pyTradeItemFlowRecordReqDto.setId(pyId);
        return pyTradeItemFlowRecordReqDto;
    }

    private void updatePayRecordStatus(DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto, String status) {
        AssertUtils.notNull((Object)pyTradeItemFlowRecordReqDto.getId(), (String)"\u5173\u8054\u6d41\u6c34id\u4e0d\u80fd\u4e3a\u7a7a");
        DgTradeItemFlowRecordReqDto updateReqDto = new DgTradeItemFlowRecordReqDto();
        updateReqDto.setId(pyTradeItemFlowRecordReqDto.getId());
        updateReqDto.setPayFlowLinkOutNo(pyTradeItemFlowRecordReqDto.getPayFlowLinkOutNo());
        updateReqDto.setPayFlowStatus(status);
        this.pyTradeItemFlowRecordService.modifyPyTradeItemFlowRecord(updateReqDto);
    }

    @Override
    public DgBizPerformOrderCheckPaymentAccountRespDto checkPaymentAccount(DgPerformOrderRespDto respDto) {
        return this.checkPaymentAccountResult(respDto);
    }

    private DgBizPerformOrderCheckPaymentAccountRespDto checkPaymentAccountResult(DgPerformOrderRespDto respDto) {
        AssertUtils.isFalse((respDto.getPerformOrderSnapshotDto() == null || respDto.getPerformOrderSnapshotDto().getShopId() == null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u5ba2\u6237\u4fe1\u606f");
        boolean result = false;
        boolean orignalPayRecord = false;
        String checkResultErrorMsg = "";
        DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto = new DgBizPerformOrderCheckPaymentAccountRespDto();
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(respDto.getPerformOrderSnapshotDto().getShopId()));
        log.info("\u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shopExtRespDto));
        AssertUtils.notNull((Object)shopExtRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        bizSaleOrderCheckPaymentAccountRespDto.setShopExtRespDto(shopExtRespDto);
        if (shopExtRespDto.getStoreType() == 2 || shopExtRespDto.getStoreType() == 3) {
            AssertUtils.isFalse((shopExtRespDto.getSettlementAmount() == null ? 1 : 0) != 0, (String)("\u5e97\u94fa\u3010" + shopExtRespDto.getStoreName() + "\u3011\uff1a\u6ca1\u6709\u914d\u7f6e\u7ed3\u7b97\u91d1\u989d"));
        }
        BigDecimal orderTotalSupplyAmount = BigDecimal.ZERO;
        List orderLineDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)respDto.getExchangeOrderNo())) {
            log.info("\u7279\u6b8a\u5904\u7406:\u5982\u679c\u662f\u6362\u8d27\u5355\u751f\u6210\u7684\u6362\u8d27\u53d1\u51fa\u9500\u552e\u5355\uff0c\u9700\u8981\u53d6\u6362\u8d27\u552e\u540e\u5355\u5173\u8054\u7684\u9500\u552e\u5355\u7684\u5546\u54c1\u7684\u4f9b\u8d27\u4ef7\u8fdb\u884c\u9884\u5360");
            DgAfterSaleOrderEo afterSaleOrderEo = this.dgAfterSaleOrderDomain.queryByExchangeSaleOrderNo(respDto.getSaleOrderNo());
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(afterSaleOrderEo.getSaleOrderId());
            List payRecordEos = this.payRecordDomain.selectListByOrderNoAndStatus(dgPerformOrderInfoEo.getSaleOrderNo(), PayStatusEnum.SUCCESS.getName());
            if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
                orignalPayRecord = true;
                orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderIdAndCancelStatus(respDto.getId(), SaleOrderItemStatusEnum.NORMAL.getCode());
                log.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderLineDtos));
                orderTotalSupplyAmount = this.getOrderItemsQuota(respDto, shopExtRespDto, orderLineDtos, bizSaleOrderCheckPaymentAccountRespDto);
            }
        } else {
            orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderIdAndCancelStatus(respDto.getId(), SaleOrderItemStatusEnum.NORMAL.getCode());
            log.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderLineDtos));
            orderTotalSupplyAmount = this.getOrderItemsQuota(respDto, shopExtRespDto, orderLineDtos, bizSaleOrderCheckPaymentAccountRespDto);
        }
        if (shopExtRespDto.getIsBalanceControl() == 1 || orignalPayRecord) {
            ArrayList<AccountTypeBalanceRespDto> accountTypeBalanceRespDtos = new ArrayList();
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", "B2C_PAY_WAY"));
            String way = Optional.ofNullable(dictDto).map(m -> dictDto.getValue()).orElse(B2COrderPayWayEnum.DEF_WAY.getWay());
            log.info("\u8bfb\u53d6\u8d26\u6237\u914d\u7f6eway\uff1a{}", (Object)way);
            if (way.contains(B2COrderPayWayEnum.DEF_WAY.getWay())) {
                ArrayList<AccountMatchesItemReqDto> items = new ArrayList<AccountMatchesItemReqDto>();
                for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                    AccountMatchesItemReqDto item = new AccountMatchesItemReqDto();
                    item.setItemCode(orderLineDto.getItemCode());
                    item.setSkuCode(orderLineDto.getSkuCode());
                    item.setCategorys("");
                    item.setOrderItemId(orderLineDto.getId());
                    item.setCustomerNo(respDto.getPerformOrderSnapshotDto().getCustomerCode());
                    item.setShopCode(respDto.getPerformOrderSnapshotDto().getShopCode());
                    items.add(item);
                }
                AccountQueryReqDto accountQueryReqDto = new AccountQueryReqDto();
                accountQueryReqDto.setSaleCompanyCode(shopExtRespDto.getSaleCompanyCode());
                accountQueryReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getCustomerCode());
                accountQueryReqDto.setShopCode(respDto.getPerformOrderSnapshotDto().getShopCode());
                accountQueryReqDto.setMatchesItems(items);
                log.info("\u53ef\u7528\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)accountQueryReqDto));
                accountTypeBalanceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.orderMatching(accountQueryReqDto));
            } else {
                AccountBalanceReqDto reqDto = new AccountBalanceReqDto();
                reqDto.setCustomerId(respDto.getPerformOrderSnapshotDto().getCustomerId());
                reqDto.setCustomerCode(respDto.getPerformOrderSnapshotDto().getCustomerCode());
                reqDto.setShopCode(respDto.getPerformOrderSnapshotDto().getShopCode());
                log.info("\u5916\u90e8\u53ef\u7528\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
                ExternalAccountBalanceRespDto externalAccountBalanceRespDto = (ExternalAccountBalanceRespDto)RestResponseHelper.extractData((RestResponse)this.accountBalanceApiProxy.queryAmountEnterprise(reqDto));
                if (null != externalAccountBalanceRespDto) {
                    ArrayList<AccountDto> balances = new ArrayList<AccountDto>();
                    AccountDto accountDto = new AccountDto();
                    accountDto.setMinimumPaymentLimit(BigDecimal.ZERO);
                    accountDto.setDisposable(externalAccountBalanceRespDto.getCreditAmount());
                    balances.add(accountDto);
                    AccountTypeBalanceRespDto accountTypeBalanceRespDto = new AccountTypeBalanceRespDto();
                    accountTypeBalanceRespDto.setPriority(Integer.valueOf(1));
                    accountTypeBalanceRespDto.setAccountTypeId(Long.valueOf(1L));
                    accountTypeBalanceRespDto.setAccountType("");
                    accountTypeBalanceRespDto.setAccountCategory("");
                    accountTypeBalanceRespDto.setBalances(balances);
                    accountTypeBalanceRespDtos.add(accountTypeBalanceRespDto);
                }
            }
            log.info("\u53ef\u7528\u8d26\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountTypeBalanceRespDtos));
            if (CollectionUtils.isNotEmpty(accountTypeBalanceRespDtos)) {
                this.queryLimitPayAmount(shopExtRespDto.getChannelId(), accountTypeBalanceRespDtos);
                BigDecimal accountTypeLimit = this.getOrderAccountLimit(respDto, accountTypeBalanceRespDtos, bizSaleOrderCheckPaymentAccountRespDto);
                BigDecimal accountTypeBalance = this.getOrderAccountQuota(respDto, accountTypeBalanceRespDtos, bizSaleOrderCheckPaymentAccountRespDto);
                if (orderTotalSupplyAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    if (accountTypeLimit.compareTo(orderTotalSupplyAmount) > 0) {
                        bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u6700\u4f4e\u8d26\u6237\u9884\u5360\u989d\u5ea6\uff1a" + accountTypeLimit);
                    }
                    if (accountTypeBalance.compareTo(orderTotalSupplyAmount) >= 0) {
                        result = true;
                    } else {
                        bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u5ba2\u6237\u4f59\u989d\u4e0d\u8db3");
                    }
                }
            } else {
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u5ba2\u6237\u65e0\u53ef\u7528\u8d26\u6237");
            }
        }
        bizSaleOrderCheckPaymentAccountRespDto.setOrderLineDtoList(orderLineDtos);
        bizSaleOrderCheckPaymentAccountRespDto.setCheckAmount(orderTotalSupplyAmount);
        bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(result);
        respDto.setBizPerformOrderCheckPaymentAccountRespDto(bizSaleOrderCheckPaymentAccountRespDto);
        log.info("\u4f59\u989d\u7ba1\u63a7\u68c0\u67e5\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)bizSaleOrderCheckPaymentAccountRespDto));
        return bizSaleOrderCheckPaymentAccountRespDto;
    }

    private BigDecimal getOrderItemsQuotaByExchangeSaleOrder(DgPerformOrderRespDto respDto, DgPerformOrderLineDto orignalOrderLineDto, DgPerformOrderLineDto orderLineDto, DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto) {
        BigDecimal orderTotalSupplyAmount = BigDecimal.ZERO;
        ArrayList<DgPerformOrderLineAmountDto> orderLineAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        DgPerformOrderLineAmountDto lineAmountDto = (DgPerformOrderLineAmountDto)this.performOrderLineAmountDomain.queryByOrderLineIdsAndAccountType(Collections.singletonList(orignalOrderLineDto.getId()), DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode()).get(0);
        DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
        BigDecimal itemPrice = BigDecimal.ZERO;
        log.info("\u5546\u54c1\u3010{}\u3011\u7ed3\u7b97\u4ef7\u4e3a\uff1a{}", (Object)orderLineDto.getSkuCode(), (Object)lineAmountDto.getAmount());
        orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
        orderLineAmountDto.setOrderLineId(orderLineDto.getId());
        orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
        orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
        orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
        orderLineAmountDto.setAmount(lineAmountDto.getAmount());
        HashMap<Long, BigDecimal> matchOrderLineSettlementPriceMap = new HashMap<Long, BigDecimal>();
        matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), lineAmountDto.getAmount());
        orderLineAmountDtoList.add(orderLineAmountDto);
        bizSaleOrderCheckPaymentAccountRespDto.setOrderLineAmountDtoList(orderLineAmountDtoList);
        bizSaleOrderCheckPaymentAccountRespDto.setMatchOrderLineSettlementPriceMap(matchOrderLineSettlementPriceMap);
        return orderTotalSupplyAmount;
    }

    private void queryLimitPayAmount(Long channelId, List<AccountTypeBalanceRespDto> accountTypeBalanceRespDtos) {
        DgCsChannelRespDto channelRespDto = (DgCsChannelRespDto)this.dgCsChannelQueryApiProxy.getChannelDetailById(channelId).getData();
        AssertUtils.isFalse((channelRespDto == null ? 1 : 0) != 0, (String)"\u5e97\u94fa\u7684\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
        String businessModel = ChannelRelationBusinessModelEnum.enumOf((Integer)channelRespDto.getCategory()).getBusinessModel();
        List configEos = ((ExtQueryChainWrapper)this.dgOrderBusinessAccountConfigDomain.filter().eq((Object)"business_code", (Object)businessModel)).list();
        if (CollectionUtils.isEmpty((Collection)configEos)) {
            for (AccountTypeBalanceRespDto accountTypeBalanceRespDto : accountTypeBalanceRespDtos) {
                accountTypeBalanceRespDto.getBalances().forEach(e -> e.setMinimumPaymentLimit(BigDecimal.ZERO));
            }
        } else {
            Map accountConfigEoMap = configEos.stream().collect(Collectors.toMap(DgOrderBusinessAccountConfigEo::getAccountType, Function.identity()));
            for (AccountTypeBalanceRespDto accountTypeBalanceRespDto : accountTypeBalanceRespDtos) {
                DgOrderBusinessAccountConfigEo accountConfigEo = (DgOrderBusinessAccountConfigEo)accountConfigEoMap.get(accountTypeBalanceRespDto.getAccountType());
                if (accountConfigEo == null) {
                    accountTypeBalanceRespDto.getBalances().forEach(e -> e.setMinimumPaymentLimit(BigDecimal.ZERO));
                    continue;
                }
                accountTypeBalanceRespDto.getBalances().forEach(e -> e.setMinimumPaymentLimit(accountConfigEo.getLimitAmount()));
                log.info("\u8d26\u6237\u7c7b\u578b:{},\u6700\u4f4e\u4ed8\u6b3e\u9650\u989d\u4e3a:{}", (Object)accountConfigEo.getAccountType(), (Object)((AccountDto)accountTypeBalanceRespDto.getBalances().get(0)).getMinimumPaymentLimit());
            }
        }
    }

    private BigDecimal getOrderItemsQuota(DgPerformOrderRespDto respDto, DgShopRespDto shopExtRespDto, List<DgPerformOrderLineDto> orderLineDtos, DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto) {
        BigDecimal orderTotalSupplyAmount = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> matchOrderLineSettlementPriceMap = new HashMap<Long, BigDecimal>();
        ArrayList<DgPerformOrderLineAmountDto> orderLineAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
        if (shopExtRespDto.getStoreType().equals(1)) {
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
                BigDecimal itemPrice = BigDecimal.ZERO;
                List orderLineAmountDtos = orderLineDto.getAmountDtoList().stream().filter(itemAmount -> DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode().equals(itemAmount.getAccountType())).collect(Collectors.toList());
                itemPrice = ((DgPerformOrderLineAmountDto)orderLineAmountDtos.get(0)).getAmount();
                orderTotalSupplyAmount = orderTotalSupplyAmount.add(itemPrice);
                matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), itemPrice);
                orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                orderLineAmountDto.setAmount(itemPrice);
                orderLineAmountDtoList.add(orderLineAmountDto);
            }
        } else if (shopExtRespDto.getIsSpecialModel() != null && YesOrNoEnum.YES.getType().equals(shopExtRespDto.getIsSpecialModel()) && (SaleOrderTypeEnum.REPLENISH_ORDER.getType().equals(respDto.getOrderType()) || SaleOrderTypeEnum.SPECIAL_ORDER.getType().equals(respDto.getOrderType()))) {
            log.info("\u5e97\u94fa\u5f00\u542f\u4e86\u7279\u4ef7/\u8d60\u54c1\u53d1\u8d27\u6a21\u5f0f\uff0c\u5e76\u4e14\u8ba2\u5355\u7c7b\u578b\u4e3a\u8865\u53d1/\u7279\u4ef7,\u9700\u8981\u53d6\u5b9e\u4ed8\u91d1\u989d\u4f5c\u4e3a\u4f9b\u8d27\u4ef7");
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
                BigDecimal itemPrice = BigDecimal.ZERO;
                List orderLineAmountDtos = orderLineDto.getAmountDtoList().stream().filter(itemAmount -> DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode().equals(itemAmount.getAccountType())).collect(Collectors.toList());
                itemPrice = ((DgPerformOrderLineAmountDto)orderLineAmountDtos.get(0)).getAmount();
                orderTotalSupplyAmount = orderTotalSupplyAmount.add(itemPrice);
                matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), itemPrice);
                orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                orderLineAmountDto.setAmount(itemPrice);
                orderLineAmountDtoList.add(orderLineAmountDto);
            }
        } else if (shopExtRespDto.getSettlementAmount() == 1) {
            orderTotalSupplyAmount = this.querySupplyPrice(respDto, orderLineDtos, orderLineAmountDtoList, matchOrderLineSettlementPriceMap, bizSaleOrderCheckPaymentAccountRespDto);
        } else if (shopExtRespDto.getSettlementAmount() == 2) {
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
                BigDecimal itemPrice = BigDecimal.ZERO;
                List orderLineAmountDtos = orderLineDto.getAmountDtoList().stream().filter(itemAmount -> DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode().equals(itemAmount.getAccountType())).collect(Collectors.toList());
                itemPrice = ((DgPerformOrderLineAmountDto)orderLineAmountDtos.get(0)).getAmount();
                orderTotalSupplyAmount = orderTotalSupplyAmount.add(itemPrice);
                matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), itemPrice);
                orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                orderLineAmountDto.setAmount(itemPrice);
                orderLineAmountDtoList.add(orderLineAmountDto);
            }
        } else if (shopExtRespDto.getSettlementAmount() == 3) {
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
                BigDecimal itemPrice = BigDecimal.ZERO;
                List orderLineAmountDtos = orderLineDto.getAmountDtoList().stream().filter(itemAmount -> DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode().equals(itemAmount.getAccountType())).collect(Collectors.toList());
                itemPrice = ((DgPerformOrderLineAmountDto)orderLineAmountDtos.get(0)).getAmount();
                orderTotalSupplyAmount = orderTotalSupplyAmount.add(itemPrice);
                matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), itemPrice);
                orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                orderLineAmountDto.setAmount(itemPrice);
                orderLineAmountDtoList.add(orderLineAmountDto);
            }
        } else {
            bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u5e97\u94fa\u3010" + shopExtRespDto.getStoreName() + "\u3011\uff1a\u7ed3\u7b97\u91d1\u989d\u914d\u7f6e\u4e0d\u6b63\u786e,\u5f53\u524d\u914d\u7f6e:" + shopExtRespDto.getSettlementAmount());
        }
        log.info("\u5546\u54c1\u603b\u7ed3\u7b97\u91d1\u989d\uff1a{}", (Object)orderTotalSupplyAmount);
        bizSaleOrderCheckPaymentAccountRespDto.setMatchOrderLineSettlementPriceMap(matchOrderLineSettlementPriceMap);
        bizSaleOrderCheckPaymentAccountRespDto.setOrderLineAmountDtoList(orderLineAmountDtoList);
        return orderTotalSupplyAmount;
    }

    private BigDecimal querySupplyPrice(DgPerformOrderRespDto respDto, List<DgPerformOrderLineDto> orderLineDtos, List<DgPerformOrderLineAmountDto> orderLineAmountDtoList, Map<Long, BigDecimal> matchOrderLineSettlementPriceMap, DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto) {
        BigDecimal orderTotalSupplyAmount = BigDecimal.ZERO;
        ArrayList reqDtos = Lists.newArrayList();
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", "B2C_SUPPLY_PRICE_WAY"));
        HashMap itemSupplyPriceMapBySkuId = new HashMap();
        if (null == dictDto || dictDto.getValue().equals("1")) {
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                SkuSupplyPriceQueryV2ReqDto skuSupplyPriceQueryV2ReqDto = new SkuSupplyPriceQueryV2ReqDto();
                skuSupplyPriceQueryV2ReqDto.setSkuId(orderLineDto.getSkuId());
                skuSupplyPriceQueryV2ReqDto.setSaleCompanyId(Long.valueOf(-1L));
                skuSupplyPriceQueryV2ReqDto.setShopId(respDto.getPerformOrderSnapshotDto().getShopId());
                reqDtos.add(skuSupplyPriceQueryV2ReqDto);
            }
            log.info("\u67e5\u8be2\u5185\u90e8\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u53c2\u6570,customerId:{},reqDtso:{}", (Object)respDto.getPerformOrderSnapshotDto().getCustomerId(), (Object)JSON.toJSONString((Object)reqDtos));
            List priceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.priceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(respDto.getPerformOrderSnapshotDto().getCustomerId(), (List)reqDtos));
            log.info("\u67e5\u8be2\u5185\u90e8\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,reqDtso:{}", (Object)JSON.toJSONString((Object)priceRespDtos));
            ((List)Optional.ofNullable(priceRespDtos).orElse(new ArrayList())).stream().filter(Objects::nonNull).forEach(price -> itemSupplyPriceMapBySkuId.put(price.getSkuId(), price.getSupplyPrice()));
        } else {
            SkuSupplyPriceQueryReqDto reqDto = new SkuSupplyPriceQueryReqDto();
            reqDto.setCustomerCode(respDto.getPerformOrderSnapshotDto().getCustomerCode());
            reqDto.setShopCode(respDto.getPerformOrderSnapshotDto().getShopCode());
            ArrayList orderLineList = new ArrayList();
            reqDto.setOrderLineList(orderLineList);
            orderLineDtos.forEach(line -> {
                AccountBalanceOrderLineReqDto dto = new AccountBalanceOrderLineReqDto();
                dto.setSkuId(line.getSkuId());
                dto.setSkuCode(line.getSkuCode());
                dto.setGiftFlag(line.getGiftFlag());
                dto.setSettlementPrice(line.getPayAmount());
                orderLineList.add(dto);
            });
            RestResponse skuSupplyPriceResp = this.placeOrderGoodsApiProxy.getSkuSupplyPrice(reqDto);
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,reqDtso:{}", (Object)JSON.toJSONString((Object)skuSupplyPriceResp));
            List skuSupplyPriceRespDtos = (List)skuSupplyPriceResp.getData();
            Optional.ofNullable(skuSupplyPriceRespDtos).ifPresent(dtoList -> dtoList.stream().filter(Objects::nonNull).forEach(price -> itemSupplyPriceMapBySkuId.put(price.getSkuId(), price.getSupplyPrice())));
        }
        if (MapUtils.isNotEmpty(itemSupplyPriceMapBySkuId)) {
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                DgPerformOrderLineAmountDto orderLineAmountDto = new DgPerformOrderLineAmountDto();
                BigDecimal itemPrice = itemSupplyPriceMapBySkuId.getOrDefault(orderLineDto.getSkuId(), BigDecimal.ZERO);
                log.info("\u5546\u54c1\u3010{}\u3011\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)orderLineDto.getSkuCode(), (Object)itemPrice);
                if (Objects.nonNull(itemSupplyPriceMapBySkuId.get(orderLineDto.getSkuId()))) {
                    orderTotalSupplyAmount = orderTotalSupplyAmount.add(itemPrice);
                    matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), itemPrice);
                    orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                    orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                    orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode());
                    orderLineAmountDto.setAccountCategory(DgOrderAmountCategoryEnum.OMS_B2C.getCode());
                    orderLineAmountDto.setAccountType(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
                    orderLineAmountDto.setAmount(itemPrice);
                    orderLineAmountDtoList.add(orderLineAmountDto);
                    continue;
                }
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResult(false);
                bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u5f53\u524d\u5546\u54c1 [" + orderLineDto.getSkuCode() + "]\u4ef7\u683c\u653f\u7b56\u672a\u8bbe\u7f6e");
            }
        } else {
            orderTotalSupplyAmount = new BigDecimal(-1);
            bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u5f53\u524d\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u672a\u8bbe\u7f6e");
        }
        return orderTotalSupplyAmount;
    }

    private BigDecimal getOrderAccountLimit(DgPerformOrderRespDto respDto, List<AccountTypeBalanceRespDto> accountTypeBalanceRespDtos, DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto) {
        BigDecimal accountTypeLimit = BigDecimal.ZERO;
        log.info("\u83b7\u53d6\u53ef\u7528\u8d26\u6237\u7c7b\u578b\u4ee5\u53ca\u8d26\u6237\u6700\u4f4e\u9650\u989d\u4fe1\u606f:{}", (Object)JSON.toJSONString(accountTypeBalanceRespDtos));
        if (CollectionUtils.isNotEmpty(accountTypeBalanceRespDtos)) {
            accountTypeLimit = accountTypeBalanceRespDtos.stream().filter(balance -> CollectionUtil.isNotEmpty((Collection)balance.getBalances()) && null != ((AccountDto)balance.getBalances().get(0)).getMinimumPaymentLimit()).sorted(Comparator.comparing(AccountTypeBalanceRespDto::getPriority)).peek(amount -> log.info("\u5f53\u524d\u8d26\u6237:{} ==>>\u6700\u4f4e\u9650\u989d:{}", (Object)amount.getAccountTypeId(), (Object)((AccountDto)amount.getBalances().get(0)).getMinimumPaymentLimit())).map(e -> {
                if (((AccountDto)e.getBalances().get(0)).getDisposable().compareTo(BigDecimal.ZERO) > 0) {
                    return ((AccountDto)e.getBalances().get(0)).getMinimumPaymentLimit();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return accountTypeLimit;
    }

    private BigDecimal getOrderAccountQuota(DgPerformOrderRespDto respDto, List<AccountTypeBalanceRespDto> accountTypeBalanceRespDtos, DgBizPerformOrderCheckPaymentAccountRespDto bizSaleOrderCheckPaymentAccountRespDto) {
        BigDecimal accountTypeBalance = BigDecimal.ZERO;
        log.info("\u83b7\u53d6\u53ef\u7528\u8d26\u6237\u7c7b\u578b\u4ee5\u53ca\u8d26\u6237\u4f59\u989d\u4fe1\u606f:{}", (Object)JSON.toJSONString(accountTypeBalanceRespDtos));
        if (CollectionUtils.isNotEmpty(accountTypeBalanceRespDtos)) {
            accountTypeBalanceRespDtos = accountTypeBalanceRespDtos.stream().filter(balance -> CollectionUtil.isNotEmpty((Collection)balance.getBalances())).map(accountTypeBalanceRespDto -> {
                boolean checkRatio;
                boolean checkPriority = CollectionUtils.isNotEmpty((Collection)accountTypeBalanceRespDto.getBalances()) && null != ((AccountDto)accountTypeBalanceRespDto.getBalances().get(0)).getPriority();
                accountTypeBalanceRespDto.setPriority(Integer.valueOf(checkPriority ? ((AccountDto)accountTypeBalanceRespDto.getBalances().get(0)).getPriority() : 999));
                boolean bl = checkRatio = ((AccountDto)accountTypeBalanceRespDto.getBalances().get(0)).getRatio() == null;
                if (checkRatio) {
                    ((AccountDto)accountTypeBalanceRespDto.getBalances().get(0)).setRatio(BigDecimal.ONE);
                }
                return accountTypeBalanceRespDto;
            }).sorted(Comparator.comparing(AccountTypeBalanceRespDto::getPriority)).collect(Collectors.toList());
            accountTypeBalance = accountTypeBalanceRespDtos.stream().peek(amount -> log.info("\u5f53\u524d\u8d26\u6237:{} ==>>\u4f18\u5148\u7ea7:{} ==>>\u4f59\u989d:{}", new Object[]{amount.getAccountTypeId(), amount.getPriority(), ((AccountDto)amount.getBalances().get(0)).getDisposable()})).map(e -> ((AccountDto)e.getBalances().get(0)).getDisposable().multiply(((AccountDto)e.getBalances().get(0)).getRatio())).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            bizSaleOrderCheckPaymentAccountRespDto.setCheckResultErrorMsg("\u6ca1\u6709\u53ef\u7528\u8d26\u6237");
        }
        bizSaleOrderCheckPaymentAccountRespDto.setAccountTypeBalanceRespDtos(accountTypeBalanceRespDtos);
        log.info("\u8d26\u6237\u5269\u4f59\u603b\u91d1\u989d\uff1a{}", (Object)accountTypeBalance);
        return accountTypeBalance;
    }

    @Override
    public DgBizPerformOrderCheckPaymentAccountRespDto preemptAccount(DgPerformOrderRespDto respDto) {
        DgBizPerformOrderCheckPaymentAccountRespDto result = new DgBizPerformOrderCheckPaymentAccountRespDto();
        result = this.checkPaymentAccountResult(respDto);
        respDto.setBizPerformOrderCheckPaymentAccountRespDto(result);
        if (result.isCheckResult()) {
            PayRecordDto payRecordDto;
            DgBasePayReqDto basePayReqDto;
            DgPerformOrderLineAmountDto orderLineAmountDto;
            BigDecimal orderLinePrice;
            BigDecimal totalPayAmount;
            if (result.getShopExtRespDto().getIsBalanceControl() == 0) {
                respDto.setBizPerformOrderCheckPaymentAccountRespDto(result);
                return result;
            }
            Map matchOrderLineSettlementPriceMap = result.getMatchOrderLineSettlementPriceMap();
            ArrayList<Long> addOrderLineIds = new ArrayList<Long>();
            ArrayList<DgPerformOrderLineAmountDto> orderLineAmountDtoList = new ArrayList<DgPerformOrderLineAmountDto>();
            ArrayList<DgBasePayReqDto> payReqDtoList = new ArrayList<DgBasePayReqDto>();
            ArrayList<PayRecordDto> payRecordDtos = new ArrayList<PayRecordDto>();
            List accountTypeBalanceRespDtos = result.getAccountTypeBalanceRespDtos();
            List accountTypelimitRespDtos = accountTypeBalanceRespDtos.stream().filter(e -> ((AccountDto)e.getBalances().get(0)).getMinimumPaymentLimit() != null).collect(Collectors.toList());
            for (AccountTypeBalanceRespDto account : accountTypelimitRespDtos) {
                BigDecimal limit = ((AccountDto)account.getBalances().get(0)).getDisposable().compareTo(((AccountDto)account.getBalances().get(0)).getMinimumPaymentLimit()) > 0 ? ((AccountDto)account.getBalances().get(0)).getMinimumPaymentLimit() : BigDecimal.ZERO;
                totalPayAmount = BigDecimal.ZERO;
                for (DgPerformOrderLineDto orderLineDto : respDto.getOrderLineList()) {
                    if (addOrderLineIds.contains(orderLineDto.getId())) {
                        log.info("\u8ba2\u5355\u884c\uff1a{} \u5df2\u7ecf\u5206\u914d\u8fc7\u8d26\u6237\u989d\u5ea6", (Object)orderLineDto.getId());
                        continue;
                    }
                    orderLinePrice = matchOrderLineSettlementPriceMap.get(orderLineDto.getId()) != null ? (BigDecimal)matchOrderLineSettlementPriceMap.get(orderLineDto.getId()) : BigDecimal.ZERO;
                    log.info("\u8ba2\u5355\u884c\u5269\u4f59\u5f85\u5206\u914d\u5546\u54c1\u91d1\u989d\uff1a{}", (Object)orderLinePrice);
                    orderLineAmountDto = new DgPerformOrderLineAmountDto();
                    orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                    orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                    orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode());
                    orderLineAmountDto.setAccountCategory(account.getAccountCategory());
                    orderLineAmountDto.setAccountType(account.getAccountType());
                    if (limit.compareTo(orderLinePrice) >= 0) {
                        orderLineAmountDto.setAmount(orderLinePrice);
                        orderLineAmountDtoList.add(orderLineAmountDto);
                        matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), BigDecimal.ZERO);
                        totalPayAmount = totalPayAmount.add(orderLinePrice.multiply(orderLineDto.getItemNum()));
                        limit = limit.subtract(orderLinePrice);
                        addOrderLineIds.add(orderLineDto.getId());
                        continue;
                    }
                    orderLineAmountDto.setAmount(limit.subtract(totalPayAmount));
                    orderLineAmountDtoList.add(orderLineAmountDto);
                    matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), orderLinePrice.subtract(limit.subtract(totalPayAmount)));
                    totalPayAmount = totalPayAmount.add(limit);
                    limit = BigDecimal.ZERO;
                    break;
                }
                log.info("\u5f53\u524d\u8d26\u6237{} ==>>>\u4f59\u989d\uff1a{}", (Object)account.getAccountType(), (Object)limit);
                basePayReqDto = this.buildPayRecordDto(respDto, account, totalPayAmount, result.getShopExtRespDto());
                payReqDtoList.add(basePayReqDto);
                payRecordDto = this.buildPayRecordEo(respDto, account, totalPayAmount, result.getShopExtRespDto());
                payRecordDtos.add(payRecordDto);
                if (addOrderLineIds.size() != respDto.getOrderLineList().size()) continue;
                break;
            }
            accountTypeBalanceRespDtos = accountTypeBalanceRespDtos.stream().sorted(Comparator.comparing(AccountTypeBalanceRespDto::getPriority)).collect(Collectors.toList());
            for (AccountTypeBalanceRespDto account : accountTypeBalanceRespDtos) {
                BigDecimal balance = ((AccountDto)account.getBalances().get(0)).getDisposable().compareTo(BigDecimal.ZERO) > 0 ? ((AccountDto)account.getBalances().get(0)).getDisposable() : BigDecimal.ZERO;
                totalPayAmount = BigDecimal.ZERO;
                for (DgPerformOrderLineDto orderLineDto : respDto.getOrderLineList()) {
                    if (addOrderLineIds.contains(orderLineDto.getId())) {
                        log.info("\u8ba2\u5355\u884c\uff1a{} \u5df2\u7ecf\u5206\u914d\u8fc7\u8d26\u6237\u989d\u5ea6", (Object)orderLineDto.getId());
                        continue;
                    }
                    orderLinePrice = matchOrderLineSettlementPriceMap.get(orderLineDto.getId()) != null ? (BigDecimal)matchOrderLineSettlementPriceMap.get(orderLineDto.getId()) : BigDecimal.ZERO;
                    log.info("\u8ba2\u5355\u884c\u5269\u4f59\u5f85\u5206\u914d\u5546\u54c1\u91d1\u989d\uff1a{}", (Object)orderLinePrice);
                    orderLineAmountDto = new DgPerformOrderLineAmountDto();
                    orderLineAmountDto.setOrderId(orderLineDto.getOrderId());
                    orderLineAmountDto.setOrderLineId(orderLineDto.getId());
                    orderLineAmountDto.setAmountSource(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode());
                    orderLineAmountDto.setAccountCategory(account.getAccountCategory());
                    orderLineAmountDto.setAccountType(account.getAccountType());
                    if (balance.compareTo(orderLinePrice) >= 0) {
                        orderLineAmountDto.setAmount(orderLinePrice);
                        orderLineAmountDtoList.add(orderLineAmountDto);
                        matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), BigDecimal.ZERO);
                        totalPayAmount = totalPayAmount.add(orderLinePrice.multiply(orderLineDto.getItemNum()));
                        balance = balance.subtract(orderLinePrice);
                        addOrderLineIds.add(orderLineDto.getId());
                        continue;
                    }
                    orderLineAmountDto.setAmount(balance.subtract(totalPayAmount));
                    orderLineAmountDtoList.add(orderLineAmountDto);
                    matchOrderLineSettlementPriceMap.put(orderLineDto.getId(), orderLinePrice.subtract(balance.subtract(totalPayAmount)));
                    totalPayAmount = totalPayAmount.add(balance);
                    balance = BigDecimal.ZERO;
                    break;
                }
                log.info("\u5f53\u524d\u8d26\u6237{} ==>>>\u4f59\u989d\uff1a{}", (Object)account.getAccountType(), (Object)balance);
                basePayReqDto = this.buildPayRecordDto(respDto, account, totalPayAmount, result.getShopExtRespDto());
                payReqDtoList.add(basePayReqDto);
                payRecordDto = this.buildPayRecordEo(respDto, account, totalPayAmount, result.getShopExtRespDto());
                payRecordDtos.add(payRecordDto);
                if (addOrderLineIds.size() != respDto.getOrderLineList().size()) continue;
                break;
            }
            ArrayList orderLineAmountList = new ArrayList();
            Map<Long, List<DgPerformOrderLineAmountDto>> map = orderLineAmountDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
            map.forEach((orderLineId, list) -> {
                if (list.size() == 1) {
                    orderLineAmountList.addAll(list);
                } else {
                    Map<String, List<DgPerformOrderLineAmountDto>> typeMap = list.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getAccountType));
                    typeMap.forEach((t, l) -> {
                        if (l.size() == 1) {
                            orderLineAmountList.addAll(l);
                        } else {
                            BigDecimal total = l.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            DgPerformOrderLineAmountDto orderLineAmountDto = (DgPerformOrderLineAmountDto)l.get(0);
                            orderLineAmountDto.setAmount(total);
                            orderLineAmountList.add(orderLineAmountDto);
                        }
                    });
                }
            });
            ArrayList<PayRecordDto> payRecords = new ArrayList<PayRecordDto>();
            Map<String, List<PayRecordDto>> payRecordMap = payRecordDtos.stream().collect(Collectors.groupingBy(PayRecordDto::getPayMethod));
            payRecordMap.forEach((type, list) -> {
                if (list.size() == 1) {
                    payRecords.addAll((Collection<PayRecordDto>)list);
                } else {
                    PayRecordDto payRecordDto = (PayRecordDto)list.get(0);
                    BigDecimal total = list.stream().map(PayRecordDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    payRecordDto.setPayAmount(total);
                    payRecords.add(payRecordDto);
                }
            });
            ArrayList<DgBasePayReqDto> payReqList = new ArrayList<DgBasePayReqDto>();
            Map<String, List<DgBasePayReqDto>> basePayReqMap = payReqDtoList.stream().collect(Collectors.groupingBy(DgBasePayReqDto::getPayMethod));
            basePayReqMap.forEach((type, list) -> {
                if (list.size() == 1) {
                    payReqList.addAll((Collection<DgBasePayReqDto>)list);
                } else {
                    DgBasePayReqDto basePayReqDto = (DgBasePayReqDto)list.get(0);
                    BigDecimal total = list.stream().map(DgBasePayReqDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    basePayReqDto.setPayAmount(total);
                    payReqList.add(basePayReqDto);
                }
            });
            this.omsOrderLineBizOptDomain.saveOrderLineAmountInfo(orderLineAmountList, respDto);
            DgPerformOrderPaymentEo dgPerformOrderPaymentEo = this.buildOrderPayEo(respDto);
            this.performOrderPaymentDomain.updateSelective((BaseEo)dgPerformOrderPaymentEo);
            this.payRecordService.saveBatch(payRecords);
            log.info("\u53d1\u8d77\u652f\u4ed8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(payReqList));
            try {
                B2COrderPaySelector.newInstance().pay(respDto.getId(), result.getOrderLineDtoList(), payReqList);
            }
            catch (Exception e2) {
                log.info("\u53d1\u8d77\u9884\u5360\u5931\u8d25\uff1a{}", (Throwable)e2);
                result.setCheckResult(false);
                result.setCheckResultErrorMsg(e2.getMessage());
            }
        }
        respDto.setBizPerformOrderCheckPaymentAccountRespDto(result);
        return result;
    }

    private DgBasePayReqDto buildPayRecordDto(DgPerformOrderRespDto respDto, AccountTypeBalanceRespDto account, BigDecimal totalPayAmount, DgShopRespDto shopExtRespDto) {
        DgBasePayReqDto basePayReqDto = new DgBasePayReqDto();
        basePayReqDto.setAccountCode("");
        basePayReqDto.setAccountCategory(account.getAccountCategory());
        basePayReqDto.setPayMethod(account.getAccountType());
        basePayReqDto.setPayAmount(totalPayAmount);
        basePayReqDto.setCreditFileNo(respDto.getPerformOrderSnapshotDto().getCreditFileNo());
        basePayReqDto.setSaleCompanyCode(shopExtRespDto.getSaleCompanyCode());
        return basePayReqDto;
    }

    private PayRecordDto buildPayRecordEo(DgPerformOrderRespDto dto, AccountTypeBalanceRespDto account, BigDecimal totalPayAmount, DgShopRespDto shopExtRespDto) {
        PayRecordDto payRecordEo = new PayRecordDto();
        payRecordEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        payRecordEo.setPayStartTime(new Date());
        payRecordEo.setPayTime(new Date());
        payRecordEo.setConfirmTime(new Date());
        payRecordEo.setAuditStatus("pass");
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        payRecordEo.setOrderNo(dto.getSaleOrderNo());
        payRecordEo.setAccountCategory(account.getAccountCategory());
        payRecordEo.setPayMethod(account.getAccountType());
        payRecordEo.setPayMethodName(account.getAccountTypeName());
        payRecordEo.setPayAmount(totalPayAmount);
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserId(dto.getPerformOrderSnapshotDto().getCustomerId() + "");
        payRecordEo.setPayNo(TradeUtil.generateTradeNo());
        payRecordEo.setTradeNo(payRecordEo.getPayNo());
        payRecordEo.setSellerId(shopExtRespDto.getSaleCompanyCode());
        payRecordEo.setCardNo(dto.getPerformOrderSnapshotDto().getCreditFileNo());
        return payRecordEo;
    }

    private DgPerformOrderPaymentEo buildOrderPayEo(DgPerformOrderRespDto respDto) {
        DgPerformOrderPaymentEo dgPerformOrderPaymentEo = new DgPerformOrderPaymentEo();
        dgPerformOrderPaymentEo.setId(respDto.getPerformOrderPaymentDto().getId());
        dgPerformOrderPaymentEo.setRemainingPayAmount(BigDecimal.ZERO);
        dgPerformOrderPaymentEo.setTotalUseCostAmount(BigDecimal.ZERO);
        dgPerformOrderPaymentEo.setRepaymentAmount(BigDecimal.ZERO);
        dgPerformOrderPaymentEo.setRepaymentRebateAmount(BigDecimal.ZERO);
        return dgPerformOrderPaymentEo;
    }

    @Override
    public void preemptionToActualPayment(DgPerformOrderRespDto respDto) {
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(respDto.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty(payRecordDtos)) {
            ArrayList<DgBasePayReqDto> payReqDtoList = new ArrayList<DgBasePayReqDto>();
            payRecordDtos.forEach(payRecordDto -> {
                DgBasePayReqDto basePayReqDto = new DgBasePayReqDto();
                basePayReqDto.setAccountCode("");
                basePayReqDto.setAccountCategory(payRecordDto.getAccountCategory());
                basePayReqDto.setPayMethod(payRecordDto.getPayMethod());
                basePayReqDto.setPayAmount(payRecordDto.getPayAmount());
                basePayReqDto.setCreditFileNo(respDto.getPerformOrderSnapshotDto().getCreditFileNo());
                basePayReqDto.setSaleCompanyCode(respDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                payReqDtoList.add(basePayReqDto);
            });
            B2COrderPaySelector.newInstance().preemptionToActualPayment(respDto.getId(), payReqDtoList);
        }
    }

    @Override
    public void cancelPreemptAccount(DgPerformOrderRespDto respDto) {
    }

    @Override
    public void cancelPreemptCreditAccount(DgPerformOrderRespDto respDto) {
        DgTradeItemFlowRecordReqDto pyTradeItemFlowRecordReqDto = new DgTradeItemFlowRecordReqDto();
        pyTradeItemFlowRecordReqDto.setBizOrderNo(respDto.getSaleOrderNo());
        pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.LOCKED.getCode());
        List recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(pyTradeItemFlowRecordReqDto, null);
        if (CollectionUtils.isEmpty((Collection)recordRespDtoList)) {
            pyTradeItemFlowRecordReqDto.setPayFlowStatus(DgTradeItemFlowStatusEnum.ACCEPT.getCode());
            recordRespDtoList = this.pyTradeItemFlowRecordService.queryByBizOrderNoAndReqDto(pyTradeItemFlowRecordReqDto, null);
            if (CollectionUtils.isEmpty((Collection)recordRespDtoList)) {
                LOGGER.info("\u6ca1\u6709\u627e\u5230lock\u548caccept\u4e2d\u7684\u6d41\u6c34\uff0c\u65e0\u9700\u53d6\u6d88");
                return;
            }
        }
        if (recordRespDtoList.size() > 1) {
            throw new BizException("-1", "\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u591a\u6761lock\u6d41\u6c34");
        }
        CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
        creditRecordReqDto.setBusinessOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getBizOrderNo());
        creditRecordReqDto.setCustomerNo(respDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        creditRecordReqDto.setOrderQuota(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowAmount());
        creditRecordReqDto.setReason(Integer.valueOf(6));
        creditRecordReqDto.setOrderNo(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getPayFlowNo());
        if (this.isReleaseCreditAmount(creditRecordReqDto)) {
            LOGGER.info("\u5df2\u7ecf\u91ca\u653e\u8fc7\u4e86\u989d\u5ea6\uff0c\u6240\u4ee5\u4e0d\u518d\u91cd\u65b0\u91ca\u653e\u989d\u5ea6-\u4e1a\u52a1\u8ba2\u5355\u53f7={}\uff0c\u4ea4\u6613\u6d41\u6c34\u53f7={}", (Object)creditRecordReqDto.getBusinessOrderNo(), (Object)creditRecordReqDto.getOrderNo());
            return;
        }
        LOGGER.info("\u8c03\u7528\u4f59\u989d\u8d26\u6237\u53d6\u6d88\u8ba2\u5355 \u5165\u53c2={}", (Object)JSON.toJSONString((Object)creditRecordReqDto));
        RestResponseHelper.extractData((RestResponse)this.creditRecordApi.addCreditRecord(creditRecordReqDto));
        DgTradeItemFlowRecordReqDto updateDto = new DgTradeItemFlowRecordReqDto();
        updateDto.setId(((DgTradeItemFlowRecordRespDto)recordRespDtoList.get(0)).getId());
        this.updatePayRecordStatus(updateDto, DgTradeItemFlowStatusEnum.RELAX.getCode());
    }

    private boolean isReleaseCreditAmount(CreditRecordReqDto creditRecordReqDto) {
        CreditRecordPageReqDto reqDto = new CreditRecordPageReqDto();
        reqDto.setReasons((List)Lists.newArrayList((Object[])new Integer[]{6}));
        reqDto.setOrderNo(creditRecordReqDto.getOrderNo());
        reqDto.setBusinessOrderNo(creditRecordReqDto.getBusinessOrderNo());
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCreditRecordQueryApi.queryByPage(reqDto, Integer.valueOf(1), Integer.valueOf(1)));
        return Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }
}

