/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ItemPromotionDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.constants.ItemCountsTypeEnum;
import com.yunxi.dg.base.center.account.dto.AccountBalanceChangeReqDto;
import com.yunxi.dg.base.center.account.dto.AccountPosReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountQueryReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeItemDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTypeBalanceRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.response.ItemAllSuperiorRespDto;
import com.yunxi.dg.base.center.item.proxy.item.IItemDgQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.enums.DgSaleOrderTypeExtEnum;
import com.yunxi.dg.base.center.trade.service.entity.IDgAccountProportionalControlService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceRelevanceOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.help.CostHelper;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DocumentTypeConvert;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelAccountServiceImpl
implements IChannelAccountService {
    private static final Logger log = LoggerFactory.getLogger(ChannelAccountServiceImpl.class);
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IItemDgQueryApiProxy itemDgQueryApiProxy;
    @Resource
    private IAccountApiProxy accountApiProxy;
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IDgCustomerQueryApiProxy customerQueryApiProxy;
    @Resource
    private IDgAdvanceRelevanceOrderService dgAdvanceRelevanceOrderService;
    @Resource
    private IDgAccountProportionalControlService dgAccountProportionalControlService;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource(name="costHelper")
    private CostHelper costHelper;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        Map shopAccountDtoMap = Optional.ofNullable(dgF2BOrderContextVo.getPreviewReqDto().getCostAccountRespDtos()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(CostAccountDto::getShopId, Function.identity(), (e1, e2) -> e1));
        dgF2BOrderContextVo.setShopAccountDtoMap(shopAccountDtoMap);
        if (CollectionUtil.isNotEmpty((Collection)dgF2BOrderContextVo.getPreviewReqDto().getCostAccountRespDtos())) {
            DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
            f2BPerformOrderReqDto.setCostAccountRespDto((CostAccountDto)dgF2BOrderContextVo.getPreviewReqDto().getCostAccountRespDtos().get(0));
        }
    }

    @Override
    public CostAccountDto queryAccountDto(DgF2BOrderPreviewContext orderViewParam) {
        AccountMatchesItemReqDto item;
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = orderViewParam.getDgF2BPerformOrderReqDto();
        DgPerformOrderSnapshotDto performOrderSnapshotDto = dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto();
        CostAccountDto costAccountRespDto = dgF2BPerformOrderReqDto.getCostAccountRespDto();
        Map<Object, Object> accountPreviewDtoMap = Maps.newHashMap();
        if (costAccountRespDto != null && CollectionUtils.isNotEmpty((Collection)costAccountRespDto.getAccountPreviewDtos())) {
            accountPreviewDtoMap = costAccountRespDto.getAccountPreviewDtos().stream().collect(Collectors.toMap(AccountPreviewDto::getAccountType, Function.identity(), (e1, e2) -> e1));
        }
        CostAccountDto costAccountDto = new CostAccountDto();
        List itemCodes = dgF2BPerformOrderReqDto.getItemList().stream().map(DgPerformOrderItemDto::getItemCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)orderViewParam.getGiftItemList())) {
            List giftItemCodes = orderViewParam.getGiftItemList().stream().map(DgPerformOrderItemDto::getItemCode).collect(Collectors.toList());
            itemCodes.addAll(giftItemCodes);
        }
        long startTime2 = System.currentTimeMillis();
        List itemAllSuperiorRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemDgQueryApiProxy.allSuperiorNodesByItemIds(itemCodes));
        log.info("\u83b7\u53d6\u5546\u54c1\u7684\u6240\u6709\u4e0a\u7ea7\u76f8\u5173\u7c7b\u76eeID\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)itemAllSuperiorRespDtos));
        long endTime2 = System.currentTimeMillis();
        log.info("\u8c03\u7528\u63a5\u53e3:{},\u8017\u65f6:{}", (Object)"itemDgQueryApiProxy.allSuperiorNodesByItemIds", (Object)(endTime2 - startTime2));
        Map itemCategroryMap = itemAllSuperiorRespDtos.stream().collect(Collectors.toMap(ItemAllSuperiorRespDto::getCode, Function.identity(), (v1, v2) -> v2));
        AccountQueryReqDto reqDto = new AccountQueryReqDto();
        reqDto.setOrderTypeCode(StringUtils.isNotBlank((CharSequence)orderViewParam.getOrderType()) ? orderViewParam.getOrderType() : DgSaleOrderTypeEnum.STANDARD_ORDER.getType());
        ArrayList items = Lists.newArrayList();
        DgCustomerRespDto dgCustomerRespDto = orderViewParam.getDgCustomerRespDto();
        DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto = orderViewParam.getDgPjOrgCustomerRelationExtRespDto();
        BigDecimal paymentPeriodLimit = Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto.getPaymentPeriodLimit()).orElse(BigDecimal.ZERO);
        String customerGroup = "";
        if (dgCustomerRespDto != null) {
            if (null != dgCustomerRespDto.getCustomerGroupId()) {
                customerGroup = dgCustomerRespDto.getCustomerGroupId().toString();
                reqDto.setCustomerGroup(customerGroup);
            }
            if (null != dgCustomerRespDto.getType()) {
                reqDto.setCustomerType(dgCustomerRespDto.getType().toString());
            }
        }
        for (Object itemReqDto : dgF2BPerformOrderReqDto.getItemList()) {
            item = new AccountMatchesItemReqDto();
            item.setItemCode(itemReqDto.getItemCode());
            item.setSkuCode(itemReqDto.getSkuCode());
            item.setCategorys(Optional.ofNullable(itemCategroryMap.get(itemReqDto.getItemCode())).map(ItemAllSuperiorRespDto::getNodeIds).orElse(""));
            item.setOrderItemId(itemReqDto.getSortNo());
            item.setCustomerNo(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
            item.setShopCode(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            item.setBrand(itemReqDto.getBrandSerial());
            items.add(item);
        }
        if (CollectionUtil.isNotEmpty((Collection)orderViewParam.getGiftItemList())) {
            for (Object itemReqDto : orderViewParam.getGiftItemList()) {
                item = new AccountMatchesItemReqDto();
                item.setItemCode(itemReqDto.getItemCode());
                item.setSkuCode(itemReqDto.getSkuCode());
                item.setCategorys(Optional.ofNullable(itemCategroryMap.get(itemReqDto.getItemCode())).map(ItemAllSuperiorRespDto::getNodeIds).orElse(""));
                item.setOrderItemId(itemReqDto.getSortNo());
                item.setCustomerNo(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                item.setShopCode(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                item.setBrand(itemReqDto.getBrandSerial());
                items.add(item);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)dgF2BPerformOrderReqDto.getMaterialList())) {
            ArrayList materialSkuCodes = Lists.newArrayList();
            for (DgPreviewPerformOrderItemReqDto material : dgF2BPerformOrderReqDto.getMaterialList()) {
                AccountMatchesItemReqDto item2 = new AccountMatchesItemReqDto();
                item2.setItemCode(material.getItemCode());
                item2.setSkuCode(material.getSkuCode());
                item2.setCategorys(Optional.ofNullable(itemCategroryMap.get(material.getItemCode())).map(ItemAllSuperiorRespDto::getNodeIds).orElse(""));
                item2.setOrderItemId(material.getSortNo());
                item2.setCustomerNo(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                item2.setShopCode(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                item2.setBrand(material.getBrandSerial());
                items.add(item2);
                materialSkuCodes.add(material.getSkuCode());
            }
            reqDto.setSkuCodeList((List)materialSkuCodes);
        }
        reqDto.setCustomerNo(performOrderSnapshotDto.getCustomerCode());
        reqDto.setShopCode(performOrderSnapshotDto.getShopCode());
        reqDto.setMatchesItems((List)items);
        reqDto.setCustomerType(dgCustomerRespDto.getCustomerTypeId() == null ? "" : dgCustomerRespDto.getCustomerTypeId().toString());
        reqDto.setCustomerGroup(dgCustomerRespDto.getCustomerGroupId() == null ? "" : dgCustomerRespDto.getCustomerGroupId().toString());
        reqDto.setCustomerAreas(dgCustomerRespDto.getAreaCode() == null ? "" : dgCustomerRespDto.getAreaCode().toString());
        log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List balanceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.orderMatching(reqDto));
        log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u8bf7\u6c42\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)balanceRespDtos));
        if (CollectionUtils.isNotEmpty((Collection)balanceRespDtos)) {
            costAccountDto.setShopId(performOrderSnapshotDto.getShopId());
            ArrayList accountPreviewDtos = Lists.newArrayList();
            ArrayList accountTypeList = Lists.newArrayList();
            for (AccountTypeBalanceRespDto balanceRespDto : balanceRespDtos) {
                if (Objects.equals("YFK", balanceRespDto.getAccountType()) && dgPjOrgCustomerRelationExtRespDto != null) {
                    if (Objects.equals(dgPjOrgCustomerRelationExtRespDto.getAuthFee(), YesNoEnum.YES.getValue())) {
                        if (YesNoEnum.YES.getValue().equals(dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod())) {
                            balanceRespDto.getBalances().stream().peek(accountDto -> {
                                accountDto.setIsPaymentPeriod(dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod());
                                accountDto.setPaymentPeriodLimit(paymentPeriodLimit);
                            });
                        }
                        AccountPreviewDto accountPreviewDto = this.converAccountPreviewDto(dgF2BPerformOrderReqDto, accountPreviewDtoMap, balanceRespDto, dgPjOrgCustomerRelationExtRespDto);
                        accountPreviewDto.setGroup(Boolean.TRUE.booleanValue());
                        accountPreviewDto.setOrderAvaBalance(accountPreviewDto.getAccountDtos().stream().map(AccountDto::getDisposable).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                        accountPreviewDtos.add(accountPreviewDto);
                    } else {
                        for (AccountDto balance : balanceRespDto.getBalances()) {
                            balance.setIsPaymentPeriod(dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod());
                            balance.setPaymentPeriodLimit(paymentPeriodLimit);
                            AccountTypeBalanceRespDto accountTypeBalanceRespDto = new AccountTypeBalanceRespDto();
                            BeanUtil.copyProperties((Object)balanceRespDto, (Object)accountTypeBalanceRespDto, (String[])new String[0]);
                            accountTypeBalanceRespDto.setBalances((List)Lists.newArrayList((Object[])new AccountDto[]{balance}));
                            accountPreviewDtos.add(this.converAccountPreviewDto(dgF2BPerformOrderReqDto, accountPreviewDtoMap, accountTypeBalanceRespDto, dgPjOrgCustomerRelationExtRespDto));
                        }
                    }
                } else {
                    accountPreviewDtos.add(this.converAccountPreviewDto(dgF2BPerformOrderReqDto, accountPreviewDtoMap, balanceRespDto, dgPjOrgCustomerRelationExtRespDto));
                }
                accountTypeList.add(balanceRespDto.getAccountType());
            }
            costAccountDto.setAccountPreviewDtos((List)accountPreviewDtos);
        } else {
            costAccountDto.setAccountPreviewDtos(new ArrayList());
        }
        dgF2BPerformOrderReqDto.setCostAccountRespDto(costAccountDto);
        return costAccountDto;
    }

    @Override
    public void batchPreempt(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        ArrayList accountTradeReqDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dgBizPerformOrderReqDto.getPayRecordDtoList())) {
            Map materialMap = dgBizPerformOrderReqDto.getMaterialList().stream().collect(Collectors.toMap(DgPerformOrderItemDto::getSkuCode, Function.identity(), (e1, e2) -> e1));
            ArrayList accountTradeReqDtos = Lists.newArrayList();
            dgBizPerformOrderReqDto.getPayRecordDtoList().stream().forEach(payRecordDto -> {
                if (Objects.equals(YesNoEnum.YES.getValue(), payRecordDto.getItemCountsType())) {
                    List materialTradeItemDto = payRecordDto.getItemPayRecordDtos().stream().map(itemPayRecordDto -> {
                        AccountTradeItemDto accountTradeItemDto = new AccountTradeItemDto();
                        accountTradeItemDto.setItemCode(Optional.ofNullable(materialMap.get(itemPayRecordDto.getSkuCode())).map(DgPerformOrderItemDto::getItemCode).orElse(""));
                        accountTradeItemDto.setSkuCode(itemPayRecordDto.getSkuCode());
                        accountTradeItemDto.setAmount(itemPayRecordDto.getItemNum());
                        return accountTradeItemDto;
                    }).collect(Collectors.toList());
                    AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
                    accountTradeReqDto.setItems(materialTradeItemDto);
                    accountTradeReqDto.setAmount(BigDecimal.ZERO);
                    accountTradeReqDto.setAccountType(payRecordDto.getPayMethod());
                    accountTradeReqDto.setShopCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                    accountTradeReqDto.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                    accountTradeReqDto.setCustomerNo(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                    accountTradeReqDto.setSaleCompanyCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                    accountTradeReqDto.setCreditFileNo(dgBizPerformOrderReqDto.getCreditFileNo());
                    accountTradeReqDtos.add(accountTradeReqDto);
                } else {
                    AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
                    accountTradeReqDto.setAmount(payRecordDto.getPayAmount());
                    accountTradeReqDto.setAccountType(payRecordDto.getPayMethod());
                    accountTradeReqDto.setShopCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                    accountTradeReqDto.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                    accountTradeReqDto.setCustomerNo(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                    accountTradeReqDto.setSaleCompanyCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                    accountTradeReqDto.setCreditFileNo(dgBizPerformOrderReqDto.getCreditFileNo());
                    accountTradeReqDtos.add(accountTradeReqDto);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)accountTradeReqDtos)) {
                AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
                accountTradeBatchReqDto.setTradeReqDtos((List)accountTradeReqDtos);
                accountTradeBatchReqDto.setShopCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                accountTradeBatchReqDto.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                accountTradeBatchReqDto.setCustomerNo(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                accountTradeBatchReqDto.setSaleCompanyCode(dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getEnterpriseCode());
                accountTradeBatchReqDto.setCreditFileNo(dgBizPerformOrderReqDto.getCreditFileNo());
                accountTradeBatchReqDto.setBusinessOrderNo(accountTradeBatchReqDto.getOrderNo());
                accountTradeBatchReqDto.setDocumentType(DocumentTypeConvert.orderTypeToDocumentType(dgBizPerformOrderReqDto.getOrderType()));
                accountTradeReqDtoList.add(accountTradeBatchReqDto);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)accountTradeReqDtoList)) {
            log.info("\u53d1\u8d77\u8d39\u7528\u9884\u5360\u8bf7\u6c42\uff1a{}", JSON.toJSON((Object)accountTradeReqDtoList));
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.batchPreempt((List)accountTradeReqDtoList));
        }
        ArrayList payRecordDtos = Lists.newArrayList();
        List itemList = dgBizPerformOrderReqDto.getItemList();
        List giftItemList = Optional.ofNullable(dgBizPerformOrderReqDto.getGiftList()).orElse(Lists.newArrayList());
        List materialList = Optional.ofNullable(dgBizPerformOrderReqDto.getMaterialList()).orElse(Lists.newArrayList());
        List allOrderItemList = Stream.of(itemList, giftItemList, materialList).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)dgBizPerformOrderReqDto.getPayRecordDtoList())) {
            Map itemReqDtoMap = allOrderItemList.stream().collect(Collectors.toMap(DgPerformOrderItemReqDto::getSortNo, Function.identity(), (e1, e2) -> e1));
            for (PayRecordDto payRecordDto2 : dgBizPerformOrderReqDto.getPayRecordDtoList()) {
                payRecordDto2.setTradeNo(TradeUtil.generateTradeNo());
                payRecordDto2.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
                payRecordDto2.getItemPayRecordDtos().stream().forEach(itemPayRecordDto -> {
                    DgPerformOrderItemReqDto dgPerformOrderItemReqDto = (DgPerformOrderItemReqDto)itemReqDtoMap.get(itemPayRecordDto.getOrderItemId());
                    itemPayRecordDto.setOrderItemId(dgPerformOrderItemReqDto.getId());
                });
                payRecordDtos.add(payRecordDto2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)payRecordDtos)) {
            this.payRecordService.saveBatch(payRecordDtos);
        }
    }

    @Override
    public void setYdjAmount(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        CostAccountDto costAccountDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getCostAccountRespDto();
        if (Objects.equals(f2BOrderPreviewContext.getOrderType(), DgSaleOrderTypeEnum.CUSTOM_ORDER.getType())) {
            for (AccountPreviewDto accountPreviewDto : costAccountDto.getAccountPreviewDtos()) {
                if (!Objects.equals("YDJ", accountPreviewDto.getAccountType())) continue;
                if (Objects.isNull(f2BOrderPreviewContext.getAdvanceOrderDto())) {
                    log.info("\u9884\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\u4e0d\u8ba1\u7b97\u9884\u5b9a\u91d1\u8d26\u6237");
                    continue;
                }
                DgAdvanceRelevanceOrderExtDto advanceRelevanceOrderExtDto = new DgAdvanceRelevanceOrderExtDto();
                advanceRelevanceOrderExtDto.setAdvanceOrderNo(f2BOrderPreviewContext.getAdvanceOrderDto().getOrderNo());
                advanceRelevanceOrderExtDto.setRelevanceOrderNo(f2BOrderPreviewContext.getSaleOrderNo());
                advanceRelevanceOrderExtDto.setType(Integer.valueOf(f2BOrderPreviewContext.getDefPreviewOpt()));
                List itemList = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getItemList();
                ArrayList relevanceOrderDtoList = Lists.newArrayList();
                for (DgPreviewPerformOrderItemReqDto orderItemReqDto : itemList) {
                    DgAdvanceRelevanceOrderDto advanceRelevanceOrderDto = new DgAdvanceRelevanceOrderDto();
                    advanceRelevanceOrderDto.setRelevanceOrderNo(f2BOrderPreviewContext.getSaleOrderNo());
                    advanceRelevanceOrderDto.setAdvanceOrderNo(f2BOrderPreviewContext.getAdvanceOrderDto().getOrderNo());
                    advanceRelevanceOrderDto.setSkuCode(orderItemReqDto.getSkuCode());
                    advanceRelevanceOrderDto.setSkuId(orderItemReqDto.getSkuId());
                    advanceRelevanceOrderDto.setDeliveryNum(orderItemReqDto.getItemNum());
                    advanceRelevanceOrderDto.setAdvanceItemLineId(orderItemReqDto.getBeforeOrderItemId());
                    advanceRelevanceOrderDto.setRelevanceItemLineId(orderItemReqDto.getId());
                    relevanceOrderDtoList.add(advanceRelevanceOrderDto);
                }
                advanceRelevanceOrderExtDto.setRelevanceOrderDtoList((List)relevanceOrderDtoList);
                log.info("\u8ba2\u8d27\u5355\u9884\u89c8\u6216\u4fdd\u5b58\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u5165\u53c2={}", JSON.toJSON((Object)advanceRelevanceOrderExtDto));
                BigDecimal advanceAmount = this.dgAdvanceRelevanceOrderService.updateItemLineByRelevanceOrder(advanceRelevanceOrderExtDto);
                log.info("\u8ba2\u8d27\u5355\u9884\u89c8\u6216\u4fdd\u5b58\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u7ed3\u679c={}", (Object)advanceAmount);
                f2BOrderPreviewContext.setAdvanceTotalAmount(advanceAmount);
                String customerCode = f2BOrderPreviewContext.getAdvanceOrderDto().getCustomerCode();
                if (!dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode().equals(customerCode)) {
                    accountPreviewDto.setOrderAvaBalance(BigDecimal.ZERO);
                    continue;
                }
                accountPreviewDto.setOrderAvaBalance(advanceAmount);
            }
        }
    }

    @Override
    public void setAccountMaxPayAmount(DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        DgPerformOrderSnapshotDto performOrderSnapshotDto = f2BPerformOrderReqDto.getPerformOrderSnapshotDto();
        log.info("\u9884\u89c8\u8ba2\u5355\u8ba2\u5355\u603b\u91d1\u989d={}", (Object)f2BPerformOrderReqDto.getRealPayAmount());
        List<String> accountTypeList = f2BPerformOrderReqDto.getCostAccountRespDto().getAccountPreviewDtos().stream().map(AccountPreviewDto::getAccountType).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(accountTypeList)) {
            return;
        }
        Map<String, String> accountProportionalMap = this.dgAccountProportionalControlService.matchCustomerAccount(performOrderSnapshotDto.getCustomerCode(), accountTypeList);
        log.info("\u9884\u89c8\u8ba2\u5355[\u8d26\u6237\u6bd4\u4f8b\u914d\u7f6e]\u5ba2\u6237={},\u6bd4\u4f8b\u914d\u7f6e={}", (Object)performOrderSnapshotDto.getCustomerCode(), JSONObject.toJSON(accountProportionalMap));
        ArrayList<DgPreviewPerformOrderItemReqDto> orderItems = new ArrayList<DgPreviewPerformOrderItemReqDto>();
        f2BPerformOrderReqDto.getItemList().forEach(item -> {
            DgPreviewPerformOrderItemReqDto itemReqDto = new DgPreviewPerformOrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)itemReqDto, (Object)item, (String[])new String[0]);
            orderItems.add(itemReqDto);
        });
        ArrayList<AccountPreviewDto> accountPreviewDtos = new ArrayList<AccountPreviewDto>();
        f2BPerformOrderReqDto.getCostAccountRespDto().getAccountPreviewDtos().forEach(accountPreviewDto -> {
            if (accountPreviewDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                BigDecimal proportional = new BigDecimal((String)accountProportionalMap.get(accountPreviewDto.getAccountType())).divide(new BigDecimal(100), 2, 4);
                AccountPreviewDto accountPreview = new AccountPreviewDto();
                CubeBeanUtils.copyProperties((Object)accountPreview, (Object)accountPreviewDto, (String[])new String[0]);
                accountPreview.setProportional(proportional);
                accountPreview.setPayCalculateMode(performOrderSnapshotDto.getPayCalculateMode());
                BigDecimal amount = f2BPerformOrderReqDto.getPayAmount();
                if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto.getItems())) {
                    List ids = accountPreviewDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                } else {
                    amount = orderItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                amount = amount.multiply(proportional).setScale(2, 4);
                if (amount.compareTo(accountPreview.getOrderAvaBalance()) > 0) {
                    amount = accountPreview.getOrderAvaBalance();
                }
                accountPreview.setOrderAvaBalance(amount);
                accountPreviewDtos.add(accountPreview);
            }
        });
        if (CollectionUtil.isNotEmpty(accountPreviewDtos)) {
            log.info("\u8ba1\u7b97\u6700\u5927\u652f\u4ed8\u91d1\u989d--\u63d0\u524d\u5206\u644a\u91d1\u989d");
            this.costHelper.suggestAccount(accountPreviewDtos, orderItems);
        }
        for (AccountPreviewDto accountPreviewDto2 : f2BPerformOrderReqDto.getCostAccountRespDto().getAccountPreviewDtos()) {
            List ids;
            if (!accountProportionalMap.containsKey(accountPreviewDto2.getAccountType())) continue;
            BigDecimal proportional = new BigDecimal(accountProportionalMap.get(accountPreviewDto2.getAccountType())).divide(new BigDecimal(100), 2, 4);
            accountPreviewDto2.setProportional(proportional);
            BigDecimal amount = BigDecimal.ZERO;
            if (accountPreviewDto2.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                amount = f2BPerformOrderReqDto.getPayAmount();
                if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto2.getItems())) {
                    ids = accountPreviewDto2.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                } else {
                    amount = orderItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            } else {
                amount = f2BPerformOrderReqDto.getRealPayAmount();
                if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto2.getItems())) {
                    ids = accountPreviewDto2.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                } else {
                    amount = orderItems.stream().map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
            amount = amount.multiply(proportional).setScale(2, 4);
            if (amount.compareTo(accountPreviewDto2.getOrderAvaBalance()) > 0) {
                amount = accountPreviewDto2.getOrderAvaBalance();
            }
            accountPreviewDto2.setOrderAvaBalance(amount);
            log.info("\u8d26\u6237{},\u5269\u4f59\u989d\u5ea6{},\u8d26\u6237\u5360\u6bd4{},\u6700\u5927\u4f7f\u7528\u989d\u5ea6\uff1a{},\u9002\u914d\u5546\u54c1\u4fe1\u606f\uff1a{}", new Object[]{accountPreviewDto2.getAccountType(), accountPreviewDto2.getOrderAvaBalance(), proportional, amount, JSON.toJSONString((Object)accountPreviewDto2.getItems())});
        }
    }

    @Override
    public void advanceDepositRepay(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        if (!dgBizPerformOrderReqDto.isSubmitFlag()) {
            log.info("\u975e\u63d0\u4ea4\u64cd\u4f5c\u4e0d\u6263\u51cf\u8d26\u6237\u91d1\u989d");
            return;
        }
        if (!Objects.equals(dgBizPerformOrderReqDto.getOrderType(), DgSaleOrderTypeEnum.CUSTOM_ORDER.getType())) {
            log.info("\u975e\u5b9a\u5236\u54c1\u8ba2\u5355\u7c7b\u578b");
            return;
        }
        if (Objects.isNull(dgBizPerformOrderReqDto.getAdvanceOrderDto())) {
            log.info("\u9884\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)dgBizPerformOrderReqDto.getItemList())) {
            log.info("\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        BigDecimal advanceTotalAmount = Optional.ofNullable(dgBizPerformOrderReqDto.getAdvanceTotalAmount()).orElse(BigDecimal.ZERO);
        if (advanceTotalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u4e3a0\u4e0d\u6263\u51cf\u8d26\u6237\u91d1\u989d");
            return;
        }
        DgAdvanceOrderRespDto advanceOrderDto = dgBizPerformOrderReqDto.getAdvanceOrderDto();
        AccountBalanceChangeReqDto accountBalanceChangeReqDto = new AccountBalanceChangeReqDto();
        accountBalanceChangeReqDto.setTradeType("59");
        accountBalanceChangeReqDto.setOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
        AccountPosReqDto payerAccount = new AccountPosReqDto();
        payerAccount.setAccountType("YDJ");
        payerAccount.setShopCode(advanceOrderDto.getShopCode());
        payerAccount.setCustomerNo(advanceOrderDto.getCustomerCode());
        payerAccount.setSaleCompanyCode(advanceOrderDto.getEnterpriseCode());
        AccountPosReqDto payeeAccount = new AccountPosReqDto();
        payeeAccount.setAccountType("YFK");
        payeeAccount.setShopCode(advanceOrderDto.getShopCode());
        payeeAccount.setCustomerNo(advanceOrderDto.getCustomerCode());
        payeeAccount.setSaleCompanyCode(advanceOrderDto.getEnterpriseCode());
        boolean flag = false;
        if (dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode().equals(advanceOrderDto.getCustomerCode())) {
            dgBizPerformOrderReqDto.getItemList().stream().peek(e -> log.info("\u5546\u54c1\u3010{}\u3011\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)e.getSkuCode(), (Object)e.getRealPayAmount())).collect(Collectors.toList());
            BigDecimal payTotalAmount = dgBizPerformOrderReqDto.getItemList().stream().map(DgPerformOrderItemDto::getRealPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payTotalAmount.compareTo(advanceTotalAmount) < 0) {
                advanceTotalAmount = advanceTotalAmount.subtract(payTotalAmount);
            } else {
                log.info("\u5b9e\u9645\u652f\u4ed8\u91d1\u989d \u5927\u4e8e\u7b49\u4e8e\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\uff0c\u5219\u4e0d\u6263\u51cf\u9884\u4ed8\u6b3e\u8d26\u6237");
                flag = true;
            }
        }
        if (flag) {
            log.info("\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\uff0c\u4e0d\u6263\u51cf\u9884\u5b9a\u91d1\u8d26\u6237");
            return;
        }
        accountBalanceChangeReqDto.setAmount(advanceTotalAmount);
        accountBalanceChangeReqDto.setPayerAccount(payerAccount);
        accountBalanceChangeReqDto.setPayeeAccount(payeeAccount);
        log.info("\u63d0\u4ea4\u8ba2\u8d27\u5355\u9884\u5b9a\u91d1\u4f59\u989d\u53d8\u52a8\u5165\u53c2={}", JSON.toJSON((Object)accountBalanceChangeReqDto));
        RestResponse voidRestResponse = this.accountTradeApiProxy.advanceDepositRepay(accountBalanceChangeReqDto);
        log.info("\u63d0\u4ea4\u8ba2\u8d27\u5355\u9884\u5b9a\u91d1\u4f59\u989d\u53d8\u52a8\u7ed3\u679c={}", JSON.toJSON((Object)voidRestResponse));
    }

    private AccountPreviewDto converAccountPreviewDto(DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto, Map<String, AccountPreviewDto> accountPreviewDtoMap, AccountTypeBalanceRespDto balanceRespDto, DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto) {
        AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
        accountPreviewDto.setAccountCategory(balanceRespDto.getAccountCategory());
        accountPreviewDto.setItemCountsType(balanceRespDto.getItemCountsType());
        accountPreviewDto.setAccountType(balanceRespDto.getAccountType());
        accountPreviewDto.setAccountTypeId(balanceRespDto.getAccountTypeId());
        accountPreviewDto.setAccountTypeName(balanceRespDto.getAccountTypeName());
        accountPreviewDto.setParentCode(balanceRespDto.getParentCode());
        accountPreviewDto.setParentName(balanceRespDto.getParentName());
        accountPreviewDto.setBalance(balanceRespDto.getBalances().stream().map(AccountDto::getBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        accountPreviewDto.setAccountDtos(balanceRespDto.getBalances());
        accountPreviewDto.setAvaBalance(balanceRespDto.getBalances().stream().map(AccountDto::getDisposable).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        accountPreviewDto.setItems(balanceRespDto.getItems());
        if (null != dgPjOrgCustomerRelationExtRespDto && null != dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod()) {
            accountPreviewDto.setIsPaymentPeriod(dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod());
        } else {
            accountPreviewDto.setIsPaymentPeriod(YesNoEnum.NO.getValue());
        }
        this.buildOrderAvaBalance(accountPreviewDto, dgF2BPerformOrderReqDto);
        AccountPreviewDto accountReqDto = accountPreviewDtoMap.get(balanceRespDto.getAccountType());
        if (accountReqDto != null) {
            if (Objects.equals(YesNoEnum.YES.getValue(), accountPreviewDto.getItemCountsType())) {
                Map accountMap = accountReqDto.getAccountDtos().stream().collect(Collectors.toMap(AccountDto::getSkuCode, Function.identity(), (e1, e2) -> e1));
                BigDecimal totalCurrentAmount = BigDecimal.ZERO;
                for (AccountDto accountDto : accountPreviewDto.getAccountDtos()) {
                    accountDto.setCurrUseBalance(Optional.ofNullable(accountMap.get(accountDto.getSkuCode())).map(AccountDto::getCurrUseBalance).orElse(BigDecimal.ZERO));
                    AssertUtils.isTrue((accountDto.getCurrUseBalance().compareTo(accountDto.getDisposable()) <= 0 ? 1 : 0) != 0, (String)String.format("\u4fc3\u9500\u7269\u6599\u5546\u54c1\u7f16\u53f7%s\u8d85\u8fc7\u53ef\u7528\u989d\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0b\u5355", accountDto.getSkuCode()));
                    totalCurrentAmount = totalCurrentAmount.add(accountDto.getCurrUseBalance());
                }
                accountPreviewDto.setCurrUseBalance(totalCurrentAmount);
                accountPreviewDto.setCurrDeductionAmount(totalCurrentAmount);
                accountPreviewDto.setOrderAvaBalance(accountReqDto.getAccountDtos().stream().map(AccountDto::getDisposable).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            } else {
                accountPreviewDto.setCurrUseBalance(accountReqDto.getCurrUseBalance());
                accountPreviewDto.setCurrDeductionAmount(accountReqDto.getCurrUseBalance());
                AssertUtils.isTrue((accountPreviewDto.getCurrUseBalance().compareTo(accountPreviewDto.getOrderAvaBalance()) <= 0 ? 1 : 0) != 0, (String)String.format("%s\u672c\u5355\u53ef\u4ee5\u989d\u5ea6\u4e0d\u8db3,\u672c\u5355\u6700\u5927\u53ef\u7528\uff1a%s", accountPreviewDto.getAccountTypeName(), accountPreviewDto.getOrderAvaBalance()));
            }
        }
        return accountPreviewDto;
    }

    private void buildOrderAvaBalance(AccountPreviewDto accountPreviewDto, DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)accountPreviewDto.getItems()) && ItemCountsTypeEnum.NO.getCode().equals(accountPreviewDto.getItemCountsType())) {
            accountPreviewDto.getAccountDtos().forEach(e -> {
                e.setRatio(e.getRatio() == null ? BigDecimal.ONE : e.getRatio());
                e.setRatioDisposable(e.getRatioDisposable() == null ? e.getDisposable().multiply(e.getRatio()).setScale(2, 4) : e.getRatioDisposable());
                e.setPriority(Integer.valueOf(e.getPriority() == null ? 999 : e.getPriority()));
            });
            accountPreviewDto.setRatioDisposable(((AccountDto)accountPreviewDto.getAccountDtos().get(0)).getRatioDisposable());
            accountPreviewDto.setPriority(((AccountDto)accountPreviewDto.getAccountDtos().get(0)).getPriority());
            BigDecimal orderAvaBalance = BigDecimal.ZERO;
            for (AccountMatchesItemRespDto item : accountPreviewDto.getItems()) {
                orderAvaBalance = dgF2BPerformOrderReqDto.getItemList().stream().filter(itemReqDto -> Objects.equals(itemReqDto.getSortNo(), item.getOrderItemId())).map(DgPerformOrderItemDto::getPayAmount).reduce(orderAvaBalance, BigDecimal::add);
            }
            BigDecimal excludePromotionAmount = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)accountPreviewDto.getUnStackableActivityTemplateCodes())) {
                List stackableActivityTemplateCodes = accountPreviewDto.getStackableActivityTemplateCodes();
                log.info("\u8d26\u6237\u7c7b\u578b:{},\u53ef\u53e0\u52a0\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801:{}", (Object)accountPreviewDto.getAccountType(), (Object)JSON.toJSONString((Object)stackableActivityTemplateCodes));
                for (DgPreviewPerformOrderItemReqDto itemReqDto2 : dgF2BPerformOrderReqDto.getItemList()) {
                    if (!CollectionUtils.isNotEmpty((Collection)itemReqDto2.getItemPromotionDtos())) continue;
                    for (ItemPromotionDto itemPromotionDto : itemReqDto2.getItemPromotionDtos()) {
                        if (stackableActivityTemplateCodes.contains(itemPromotionDto.getPromotionType())) continue;
                        excludePromotionAmount = excludePromotionAmount.add(itemReqDto2.getPayAmount());
                    }
                }
            }
            log.info("\u4e0d\u5728\u53ef\u53e0\u52a0\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u7684\u91d1\u989d:{}", (Object)excludePromotionAmount);
            orderAvaBalance = orderAvaBalance.subtract(excludePromotionAmount);
            BigDecimal excludePromotionAmount2 = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)accountPreviewDto.getUnStackableActivityTemplateCodes())) {
                List unStackableActivityTemplateCodes = accountPreviewDto.getUnStackableActivityTemplateCodes();
                log.info("\u8d26\u6237\u7c7b\u578b:{},\u4e0d\u53ef\u53e0\u52a0\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801:{}", (Object)accountPreviewDto.getAccountType(), (Object)JSON.toJSONString((Object)unStackableActivityTemplateCodes));
                for (DgPreviewPerformOrderItemReqDto itemReqDto3 : dgF2BPerformOrderReqDto.getItemList()) {
                    if (!CollectionUtils.isNotEmpty((Collection)itemReqDto3.getItemPromotionDtos())) continue;
                    for (ItemPromotionDto itemPromotionDto : itemReqDto3.getItemPromotionDtos()) {
                        if (!unStackableActivityTemplateCodes.contains(itemPromotionDto.getPromotionType())) continue;
                        excludePromotionAmount2 = excludePromotionAmount2.add(itemReqDto3.getPayAmount());
                    }
                }
            }
            log.info("\u4e0d\u53ef\u53e0\u52a0\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u7684\u91d1\u989d:{}", (Object)excludePromotionAmount2);
            orderAvaBalance = orderAvaBalance.subtract(excludePromotionAmount2);
            BigDecimal ratioDisposable = accountPreviewDto.getAccountDtos().stream().map(AccountDto::getRatioDisposable).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (orderAvaBalance.compareTo(ratioDisposable) > 0) {
                accountPreviewDto.setOrderAvaBalance(ratioDisposable);
            } else {
                accountPreviewDto.setOrderAvaBalance(orderAvaBalance);
            }
        }
        log.info("\u8d26\u6237:{},\u53ef\u7528\u4f59\u989d:{},\u672c\u5355\u6700\u5927\u53ef\u7528\u989d\u5ea6\u4e3a:{},\u652f\u4ed8\u987a\u5e8f:{},\u8d26\u6237\u6bd4\u4f8b\u652f\u6301\u6700\u5927\u4ed8\u6b3e\u989d\u5ea6:{}", new Object[]{accountPreviewDto.getAccountTypeName(), accountPreviewDto.getAvaBalance(), accountPreviewDto.getOrderAvaBalance(), accountPreviewDto.getPriority(), accountPreviewDto.getRatioDisposable()});
    }

    @Override
    public List<AccountDto> queryCapitalAccount(String orderNo, List<AccountCategoryEnum> accountCategoryEnums) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(orderNo);
        Long customerId = performOrderRespDto.getPerformOrderSnapshotDto().getCustomerId();
        String customerCode = performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        Long shopId = performOrderRespDto.getPerformOrderSnapshotDto().getShopId();
        String shopCode = performOrderRespDto.getPerformOrderSnapshotDto().getShopCode();
        DgCustomerRespDto dgCustomerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApiProxy.queryById(customerId));
        AssertUtils.notNull((Object)dgCustomerRespDto, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        AccountQueryReqDto reqDto = new AccountQueryReqDto();
        String customerGroup = "";
        if (null != dgCustomerRespDto.getCustomerGroupId()) {
            customerGroup = dgCustomerRespDto.getCustomerGroupId().toString();
            reqDto.setCustomerGroup(customerGroup);
        }
        if (null != dgCustomerRespDto.getType()) {
            reqDto.setCustomerType(dgCustomerRespDto.getType().toString());
        }
        List performOrderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderRespDto.getId());
        List itemCodes = performOrderLineDtos.stream().map(DgPerformOrderLineDto::getItemCode).collect(Collectors.toList());
        List itemAllSuperiorRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemDgQueryApiProxy.allSuperiorNodesByItemIds(itemCodes));
        log.info("\u83b7\u53d6\u5546\u54c1\u7684\u6240\u6709\u4e0a\u7ea7\u76f8\u5173\u7c7b\u76eeID\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)itemAllSuperiorRespDtos));
        Map itemCategroryMap = itemAllSuperiorRespDtos.stream().collect(Collectors.toMap(ItemAllSuperiorRespDto::getCode, Function.identity(), (v1, v2) -> v2));
        Map<Long, List<DgPerformOrderLineDto>> orderLineGroup = performOrderLineDtos.stream().collect(Collectors.groupingBy(BaseDto::getId));
        ArrayList items = Lists.newArrayList();
        reqDto.setOrderTypeCode(StringUtils.isNotBlank((CharSequence)performOrderRespDto.getOrderType()) ? performOrderRespDto.getOrderType() : DgSaleOrderTypeExtEnum.COMMON_ORDER.getType());
        for (DgPerformOrderLineDto orderLineDto : performOrderLineDtos) {
            AccountMatchesItemReqDto item = new AccountMatchesItemReqDto();
            item.setOrderItemId(orderLineDto.getId());
            item.setBrand(orderLineDto.getBrandSerial());
            item.setCategorys(Optional.ofNullable(itemCategroryMap.get(orderLineDto.getItemCode())).map(ItemAllSuperiorRespDto::getNodeIds).orElse(""));
            item.setItemCode(orderLineDto.getItemCode());
            item.setSkuCode(orderLineDto.getSkuCode());
            item.setCustomerNo(customerCode);
            item.setShopCode(shopCode);
            items.add(item);
        }
        reqDto.setCustomerNo(customerCode);
        reqDto.setShopCode(shopCode);
        reqDto.setMatchesItems((List)items);
        reqDto.setCustomerType(dgCustomerRespDto.getCustomerTypeId() == null ? "" : dgCustomerRespDto.getCustomerTypeId().toString());
        reqDto.setCustomerGroup(dgCustomerRespDto.getCustomerGroupId() == null ? "" : dgCustomerRespDto.getCustomerGroupId().toString());
        reqDto.setCustomerAreas(dgCustomerRespDto.getAreaCode() == null ? "" : dgCustomerRespDto.getAreaCode().toString());
        log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        List balanceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.orderMatching(reqDto));
        log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u8bf7\u6c42\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)balanceRespDtos));
        List<DgPjOrgCustomerRelationExtRespDto> customerRelationExtRespDtos = this.preInfoQueryAction.queryByShopIdsAndCustomerIds(Collections.singletonList(customerId), Lists.newArrayList((Object[])new Long[]{shopId}));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(customerRelationExtRespDtos), (String)"\u5ba2\u6237\u7b7e\u7ea6\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto = (DgPjOrgCustomerRelationExtRespDto)customerRelationExtRespDtos.stream().findFirst().get();
        HashMap accountTypeMap = balanceRespDtos.stream().filter(accountType -> accountCategoryEnums.stream().anyMatch(accountCategoryEnum -> accountCategoryEnum.getCode().equals(accountType.getAccountCategory()))).map(e -> e.getBalances().stream().peek(accountDto -> {
            accountDto.setPriority(Optional.ofNullable(accountDto.getPriority()).orElse(999));
            accountDto.setItems(e.getItems());
            accountDto.setItemCountsType(e.getItemCountsType());
            if (Objects.equals("YFK", e.getAccountType())) {
                accountDto.setIsPaymentPeriod(dgPjOrgCustomerRelationExtRespDto.getIsPaymentPeriod());
            }
            if (AccountCategoryEnum.COST.getCode().equals(accountDto.getAccountCategory())) {
                BigDecimal disposable = accountDto.getDisposable();
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (AccountMatchesItemRespDto item : accountDto.getItems()) {
                    List orderLineSummaryDtos = (List)orderLineGroup.get(item.getOrderItemId());
                    totalAmount = totalAmount.add(Optional.ofNullable(orderLineSummaryDtos).orElse(Lists.newArrayList()).stream().map(DgPerformOrderLineDto::getPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                accountDto.setDisposable(disposable.min(totalAmount));
            }
        }).collect(Collectors.toList())).flatMap(Collection::stream).sorted((e1, e2) -> e1.getPriority().compareTo(e2.getPriority())).collect(Collectors.groupingBy(AccountDto::getAccountType, LinkedHashMap::new, Collectors.toList()));
        ArrayList accountDtos = Lists.newArrayList();
        for (Map.Entry entry : accountTypeMap.entrySet()) {
            String accountType2 = (String)entry.getKey();
            List accountDtoList = (List)entry.getValue();
            if ("YFK".equals(accountType2)) {
                BigDecimal paymentPeriodLimit = dgPjOrgCustomerRelationExtRespDto.getPaymentPeriodLimit();
                if (Objects.equals(dgPjOrgCustomerRelationExtRespDto.getAuthFee(), 1)) {
                    AccountDto accountDto2 = null;
                    BigDecimal totalDisable = BigDecimal.ZERO;
                    BigDecimal totalBalance = BigDecimal.ZERO;
                    BigDecimal totalPreempt = BigDecimal.ZERO;
                    BigDecimal totalFrozen = BigDecimal.ZERO;
                    for (AccountDto dto : accountDtoList) {
                        totalDisable = totalDisable.add(Optional.ofNullable(dto.getDisposable()).orElse(BigDecimal.ZERO));
                        totalBalance = totalBalance.add(Optional.ofNullable(dto.getBalance()).orElse(BigDecimal.ZERO));
                        totalPreempt = totalPreempt.add(Optional.ofNullable(dto.getPreempt()).orElse(BigDecimal.ZERO));
                        totalFrozen = totalFrozen.add(Optional.ofNullable(dto.getFrozen()).orElse(BigDecimal.ZERO));
                        accountDto2 = dto;
                    }
                    if (accountDto2.getIsPaymentPeriod() != null && YesNoEnum.YES.getValue().equals(accountDto2.getIsPaymentPeriod())) {
                        accountDto2.setPaymentPeriodLimit(paymentPeriodLimit);
                        accountDto2.setIsPaymentPeriod(YesNoEnum.YES.getValue());
                    }
                    AccountDto accountGroup = (AccountDto)BeanUtil.copyProperties(accountDto2, AccountDto.class, (String[])new String[0]);
                    accountGroup.setDisposable(totalDisable);
                    accountGroup.setBalance(totalBalance);
                    accountGroup.setPreempt(totalPreempt);
                    accountGroup.setFrozen(totalFrozen);
                    accountGroup.setGroup(Boolean.TRUE.booleanValue());
                    accountGroup.setAccountDtos(accountDtoList);
                    accountDtos.add(accountGroup);
                    continue;
                }
                accountDtoList.stream().filter(accountDto -> YesNoEnum.YES.getValue().equals(accountDto.getIsPaymentPeriod())).forEach(accountDto -> {
                    accountDto.setPaymentPeriodLimit(paymentPeriodLimit);
                    accountDto.setIsPaymentPeriod(YesNoEnum.YES.getValue());
                });
                accountDtos.addAll(accountDtoList);
                continue;
            }
            accountDtos.addAll(accountDtoList);
        }
        return accountDtos;
    }
}

