/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.credit.proxy.entity.IOverduePolicyDgApiProxy;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgPjOrgCustomerRelationExtRespDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.request.DgEsCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgCustomerBuyScopeItemQueryApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceRelevanceOrderDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.BeforeOrderItemNumDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderItemLineRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.advance.DgAdvanceOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.DgOrderItemLimitModelEnum;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceRelevanceOrderEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelBasicInfoService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.OrderExpiredUtil;
import com.yunxi.dg.base.center.trade.vo.OrderItemLimitRespVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelBasicInfoServiceImpl
implements IChannelBasicInfoService {
    private static final Logger log = LoggerFactory.getLogger(ChannelBasicInfoServiceImpl.class);
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IDgCustomerBuyScopeItemQueryApiProxy dgCustomerBuyScopeItemQueryApiProxy;
    @Resource
    private IDgAdvanceOrderDomain dgAdvanceOrderDomain;
    @Resource
    private IDgAdvanceRelevanceOrderDomain dgAdvanceRelevanceOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgAfterSaleOrderService dgAfterSaleOrderService;
    @Resource
    private IOverduePolicyDgApiProxy overduePolicyDgApiProxy;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;

    @Override
    public void supplementSnapshotDtoInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgCustomerRespDto dgCustomerRespDto = dgF2BOrderContextVo.getDgCustomerRespDto();
        DgShopRespDto shopRespDto = dgF2BOrderContextVo.getShopRespDto();
        DgPjOrgCustomerRelationExtRespDto pjOrgCustomerRelationExtRespDto = f2BOrderPreviewContext.getDgPjOrgCustomerRelationExtRespDto();
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = new DgF2BPerformOrderReqDto();
        DgPerformOrderSnapshotDto snapshotDto = this.buildOrderSnapshot(dgCustomerRespDto, shopRespDto, pjOrgCustomerRelationExtRespDto);
        DgOrderConfigurationRespDto config = this.dgOrderConfigurationService.queryDetailByShopCode(shopRespDto.getStoreCode());
        AssertUtils.notNull((Object)config, (String)"\u8ba2\u5355\u914d\u7f6e\u4e0d\u5b58\u5728");
        snapshotDto.setKneadeFlag(config.getComputeKneadPrice());
        snapshotDto.setPayCalculateMode(config.getPayCalculateMode());
        if (null != dgOrderReqDto) {
            DgShopOrderReqDto shopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
            snapshotDto.setChannelWarehouseId(shopOrderReqDto.getChannelWarehouseId());
            snapshotDto.setChannelWarehouseCode(shopOrderReqDto.getChannelWarehouseCode());
            snapshotDto.setChannelWarehouseName(shopOrderReqDto.getChannelWarehouseName());
            DgPerformOrderAddrReqDto orderAddrReqDtoWaitAudit = ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderAddrReqDtoWaitAudit();
            if (!Objects.equals(config.getEnableAddressPushExternal(), EnableEnum.ENABLE.getCode()) && orderAddrReqDtoWaitAudit != null) {
                DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
                dgShopOrderReqDto.setOrderAddrReqDto(orderAddrReqDtoWaitAudit);
            }
        }
        f2BPerformOrderReqDto.setCloseTime(OrderExpiredUtil.calcOrderCancleTime(config));
        f2BPerformOrderReqDto.setPerformOrderSnapshotDto(snapshotDto);
        f2BPerformOrderReqDto.setKneadeFlag(config.getComputeKneadPrice());
        f2BOrderPreviewContext.setDgF2BPerformOrderReqDto(f2BPerformOrderReqDto);
        dgF2BOrderContextVo.setDgOrderConfigurationRespDto(config);
    }

    @Override
    public void supplementIntactOrderSnapshotDtoInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgCustomerRespDto dgCustomerRespDto = dgF2BOrderContextVo.getDgCustomerRespDto();
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = new DgF2BPerformOrderReqDto();
        DgPerformOrderSnapshotDto snapshotDto = this.buildOrderSnapshot(dgCustomerRespDto, new DgShopRespDto(), new DgPjOrgCustomerRelationExtRespDto());
        snapshotDto.setHsEnterpriseId(dgShopOrderReqDto.getHsEnterpriseId());
        snapshotDto.setHsEnterpriseCode(dgShopOrderReqDto.getHsEnterpriseCode());
        snapshotDto.setHsEnterpriseName(dgShopOrderReqDto.getHsEnterpriseName());
        if (null != dgOrderReqDto) {
            DgShopOrderReqDto shopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
            snapshotDto.setChannelWarehouseId(shopOrderReqDto.getChannelWarehouseId());
            snapshotDto.setChannelWarehouseCode(shopOrderReqDto.getChannelWarehouseCode());
            snapshotDto.setChannelWarehouseName(shopOrderReqDto.getChannelWarehouseName());
        }
        f2BPerformOrderReqDto.setPerformOrderSnapshotDto(snapshotDto);
        f2BOrderPreviewContext.setDgF2BPerformOrderReqDto(f2BPerformOrderReqDto);
    }

    private DgPerformOrderSnapshotDto buildOrderSnapshot(DgCustomerRespDto dgCustomerRespDto, DgShopRespDto dgShopRespDto, DgPjOrgCustomerRelationExtRespDto pjOrgCustomerRelationExtRespDto) {
        AssertUtils.notNull((Object)pjOrgCustomerRelationExtRespDto, (String)"\u7b7e\u7ea6\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPerformOrderSnapshotDto snapshotDto = new DgPerformOrderSnapshotDto();
        snapshotDto.setCustomerId(dgCustomerRespDto.getId());
        snapshotDto.setCustomerCode(dgCustomerRespDto.getCode());
        snapshotDto.setCustomerName(dgCustomerRespDto.getName());
        snapshotDto.setShopId(dgShopRespDto.getId());
        snapshotDto.setShopCode(dgShopRespDto.getStoreCode());
        snapshotDto.setShopName(dgShopRespDto.getStoreName());
        snapshotDto.setEnterpriseId(pjOrgCustomerRelationExtRespDto.getOrganizationIdEnterpriseId());
        snapshotDto.setEnterpriseCode(pjOrgCustomerRelationExtRespDto.getEnterpriseCode());
        snapshotDto.setEnterpriseName(pjOrgCustomerRelationExtRespDto.getEnterpriseName());
        snapshotDto.setHsEnterpriseId(pjOrgCustomerRelationExtRespDto.getOrganizationIdEnterpriseId());
        snapshotDto.setHsEnterpriseCode(pjOrgCustomerRelationExtRespDto.getEnterpriseCode());
        snapshotDto.setHsEnterpriseName(pjOrgCustomerRelationExtRespDto.getEnterpriseName());
        snapshotDto.setOrganizationId(dgShopRespDto.getSaleCompanyId());
        snapshotDto.setOrganizationCode(dgShopRespDto.getSaleCompanyCode());
        snapshotDto.setOrganizationName(dgShopRespDto.getSaleCompanyName());
        snapshotDto.setMainSalesperson("");
        snapshotDto.setMainSalespersonCode(pjOrgCustomerRelationExtRespDto.getMainSalesmanCode());
        if (pjOrgCustomerRelationExtRespDto.getMainSalesmanId() != null) {
            snapshotDto.setMainSalespersonId(pjOrgCustomerRelationExtRespDto.getMainSalesmanId().toString());
        }
        return snapshotDto;
    }

    @Override
    public void setAdvanceOrderInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        DgAdvanceOrderRespDto dgAdvanceOrderRespDto = dgF2BOrderContextVo.getAdvanceOrderDto();
        List itemLineDtoList = dgAdvanceOrderRespDto.getItemLineDtoList().stream().filter(i -> i.getStatus().equals(0)).collect(Collectors.toList());
        AssertUtils.notEmpty(itemLineDtoList, (String)"\u9884\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u5df2\u4f7f\u7528\u5b8c");
        dgAdvanceOrderRespDto.setItemLineDtoList(itemLineDtoList);
        f2BOrderPreviewContext.setAdvanceOrderDto(dgAdvanceOrderRespDto);
        if (StringUtils.isNotEmpty((CharSequence)f2BOrderPreviewContext.getSaleOrderNo())) {
            LambdaQueryWrapper advanceRelevanceQuery = new LambdaQueryWrapper();
            advanceRelevanceQuery.eq(DgAdvanceRelevanceOrderEo::getAdvanceOrderNo, (Object)previewReqDto.getBeforeOrderNo());
            advanceRelevanceQuery.eq(DgAdvanceRelevanceOrderEo::getRelevanceOrderNo, (Object)f2BOrderPreviewContext.getSaleOrderNo());
            List dgAdvanceRelevanceOrderEos = this.dgAdvanceRelevanceOrderDomain.getMapper().selectList((Wrapper)advanceRelevanceQuery);
            if (CollectionUtils.isNotEmpty((Collection)dgAdvanceRelevanceOrderEos)) {
                Map<Long, BigDecimal> advanceRelevanceMap = dgAdvanceRelevanceOrderEos.stream().collect(Collectors.toMap(DgAdvanceRelevanceOrderEo::getSkuId, DgAdvanceRelevanceOrderEo::getDeliveryNum, (k1, k2) -> k1));
                dgF2BOrderContextVo.setAdvanceRelevanceMap(advanceRelevanceMap);
            }
        }
        Map<Object, Object> advanceOrderItemMap = new HashMap();
        if (Objects.nonNull(dgF2BOrderContextVo.getAdvanceOrderDto())) {
            advanceOrderItemMap = dgF2BOrderContextVo.getAdvanceOrderDto().getItemLineDtoList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        List itemList = previewReqDto.getItemList();
        Map itemReqDtoMap = itemList.stream().collect(Collectors.toMap(OrderPreviewItemReqDto::getSkuId, Function.identity(), (k1, k2) -> k1));
        for (int i2 = 0; i2 < f2BPerformOrderReqDto.getItemList().size(); ++i2) {
            OrderPreviewItemReqDto itemReqDto;
            DgPreviewPerformOrderItemReqDto previewItemReqDto = (DgPreviewPerformOrderItemReqDto)f2BPerformOrderReqDto.getItemList().get(i2);
            if (!itemReqDtoMap.containsKey(previewItemReqDto.getSkuId()) || !advanceOrderItemMap.containsKey((itemReqDto = (OrderPreviewItemReqDto)itemReqDtoMap.get(previewItemReqDto.getSkuId())).getBeforeOrderItemId())) continue;
            BigDecimal advanceDeliveryNum = BigDecimal.ZERO;
            if (null != dgF2BOrderContextVo.getAdvanceRelevanceMap() && dgF2BOrderContextVo.getAdvanceRelevanceMap().containsKey(itemReqDto.getSkuId())) {
                advanceDeliveryNum = (BigDecimal)dgF2BOrderContextVo.getAdvanceRelevanceMap().get(itemReqDto.getSkuId());
            }
            BigDecimal remainNum = ((DgAdvanceOrderItemLineRespDto)advanceOrderItemMap.get(itemReqDto.getBeforeOrderItemId())).getItemNum().subtract(((DgAdvanceOrderItemLineRespDto)advanceOrderItemMap.get(itemReqDto.getBeforeOrderItemId())).getDeliveryNum()).add(advanceDeliveryNum);
            AssertUtils.isFalse((itemReqDto.getItemNum().compareTo(remainNum) > 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u884c\u5546\u54c1\u8d85\u8fc7\u9884\u8ba2\u5355\u5546\u54c1\u5269\u4f59\u6570\u91cf", i2 + 1));
            BigDecimal advanceItemPrice = ((DgAdvanceOrderItemLineRespDto)advanceOrderItemMap.get(itemReqDto.getBeforeOrderItemId())).getAdditivePrice();
            previewItemReqDto.setAdvanceItemPrice(advanceItemPrice);
            previewItemReqDto.setBeforeOrderItemId(itemReqDto.getBeforeOrderItemId());
            previewItemReqDto.setBeforeOrderItemNum(remainNum);
            previewItemReqDto.setOrderItemUnit(((DgAdvanceOrderItemLineRespDto)advanceOrderItemMap.get(itemReqDto.getBeforeOrderItemId())).getUnitCode());
            previewItemReqDto.setOrderItemUnitName(((DgAdvanceOrderItemLineRespDto)advanceOrderItemMap.get(itemReqDto.getBeforeOrderItemId())).getUnitName());
            BigDecimal dgPolicyPrice = previewItemReqDto.getPrice();
            BigDecimal handmadeDiscount = previewItemReqDto.getAdvanceItemPrice().setScale(6, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).divide(dgPolicyPrice, 2, RoundingMode.HALF_UP);
            log.info("\u9884\u8ba2\u5355\u5546\u54c1skuCode={},\u52a0\u4ef7\u5355\u4ef7={},\u4f9b\u8d27\u4ef7={},\u7279\u4ef7\u6298\u6263={}", new Object[]{previewItemReqDto.getSkuCode(), previewItemReqDto.getAdvanceItemPrice(), dgPolicyPrice, handmadeDiscount});
            previewItemReqDto.setHandmadeDiscount(handmadeDiscount);
            BigDecimal originalAmount = dgPolicyPrice.multiply(itemReqDto.getItemNum());
            BigDecimal advanceItemAmount = previewItemReqDto.getAdvanceItemPrice().multiply(itemReqDto.getItemNum());
            previewItemReqDto.setHandmadeDiscountAmount(originalAmount.subtract(advanceItemAmount));
        }
    }

    @Override
    public DgOrderPreviewReqDto checkAndTransformOrderData(DgOrderReqDto dgOrderReqDto) {
        ArrayList activityBizReqDtos = Lists.newArrayList();
        ArrayList allItemList = Lists.newArrayList();
        ArrayList materialList = Lists.newArrayList();
        ArrayList allGiftList = Lists.newArrayList();
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(shopOrderReqDto -> {
            ArrayList skuIds = Lists.newArrayList();
            AssertUtils.notNull((Object)shopOrderReqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((shopOrderReqDto.getOrderAddrReqDto() != null || CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getOrderAddrReqDtos()) ? 1 : 0) != 0, (String)String.format("\u6536\u83b7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a:%s", shopOrderReqDto.getShopId()));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getItemList()), (String)String.format("\u4e0b\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", shopOrderReqDto.getShopId()));
            shopOrderReqDto.setOrderStatus(dgOrderReqDto.getOrderStatus());
            List itemList = shopOrderReqDto.getItemList();
            for (int i = 0; i < itemList.size(); ++i) {
                OrderPreviewItemReqDto item = (OrderPreviewItemReqDto)itemList.get(i);
                AssertUtils.notNull((Object)item.getItemId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1ID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getSkuId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1SKUID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getItemNum(), (String)String.format("\u7b2c%s\u884c\u4e0b\u5355\u6570\u91cf\u4e3a\u7a7a", i));
                skuIds.add(item.getSkuId());
            }
            if (CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getAttachmentFileList())) {
                HashSet fileNameSet = Sets.newHashSet();
                AssertUtils.isTrue((boolean)shopOrderReqDto.getAttachmentFileList().stream().allMatch(attachment -> fileNameSet.add(attachment.getName())), (String)"\u9001\u8d27\u9644\u4ef6,\u540c\u540d\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20");
            }
            if (!DgSaleOrderTypeEnum.B_GOODS_ORDER.getType().equals(shopOrderReqDto.getOrderType()) && !DgSaleOrderTypeEnum.C_GOODS_ORDER.getType().equals(shopOrderReqDto.getOrderType())) {
                DgEsCustomerBuyScopeItemQueryDto queryDto = new DgEsCustomerBuyScopeItemQueryDto();
                queryDto.setShopId(shopOrderReqDto.getShopId());
                queryDto.setCustomerId(dgOrderReqDto.getCustomerId());
                queryDto.setShelfStatus(YesNoEnum.YES.getValue());
                queryDto.setSkuIdList((List)skuIds);
                queryDto.setStatus(YesNoEnum.NO.getValue());
                queryDto.setPageSize(Integer.valueOf(1000));
                log.info("\u8bf7\u6c42ES\u5165\u53c2=\u300b\u300b{}", (Object)JSON.toJSONString((Object)queryDto));
                PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCustomerBuyScopeItemQueryApiProxy.queryTobEsBuyScopeItemPage(queryDto));
                log.info("\u8bf7\u6c42ES\u51fa\u53c2=\u300b\u300b{}", (Object)JSON.toJSONString((Object)itemRespDtoPageInfo));
                AssertUtils.isTrue((itemRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)itemRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u6240\u6709\u4e0b\u5355\u5546\u54c1\u67e5\u8be2\u4e0d\u5230\u4e0a\u67b6\u5141\u8d2d\u4fe1\u606f");
                Map skuDgDtoMap = itemRespDtoPageInfo.getList().stream().map(ShopItemEsRespDto::getItemSkuList).flatMap(Collection::stream).collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
                for (OrderPreviewItemReqDto orderPreviewItemReqDto : shopOrderReqDto.getItemList()) {
                    AssertUtils.isTrue((boolean)skuDgDtoMap.containsKey(orderPreviewItemReqDto.getSkuId()), (String)String.format("\u5546\u54c1\u4e0a\u67b6\u5141\u8d2d\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a%s", orderPreviewItemReqDto.getSkuCode()));
                }
            }
            Optional.ofNullable(shopOrderReqDto.getActivityList()).ifPresent(activityBizReqDtos::addAll);
            allItemList.addAll(shopOrderReqDto.getItemList());
            if (CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getMaterialList())) {
                materialList.addAll(shopOrderReqDto.getMaterialList());
            }
            if (CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getGiftList())) {
                allGiftList.addAll(shopOrderReqDto.getGiftList());
            }
            if (shopOrderReqDto.getDgPerformOrderPayReqDto() != null) {
                shopOrderReqDto.getDgPerformOrderPayReqDto().setRefreshAccountDto(Boolean.TRUE.booleanValue());
            }
        });
        DgOrderPreviewReqDto dgOrderPreviewReqDto = new DgOrderPreviewReqDto();
        dgOrderPreviewReqDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderPreviewReqDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        dgOrderPreviewReqDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderPreviewReqDto.setMatchActivity(Boolean.valueOf(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getMatchActivity() != null ? ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getMatchActivity() : false));
        dgOrderPreviewReqDto.setNeedFeeThrow(dgOrderReqDto.isNeedFeeThrow());
        dgOrderPreviewReqDto.setActivityList((List)activityBizReqDtos);
        dgOrderPreviewReqDto.setItemList((List)allItemList);
        dgOrderPreviewReqDto.setMaterialList((List)materialList);
        dgOrderPreviewReqDto.setGiftItemList((List)allGiftList);
        dgOrderPreviewReqDto.setCostAccountRespDtos((List)Lists.newArrayList());
        dgOrderPreviewReqDto.setImportOrderMatchActivity(dgOrderReqDto.isImportOrderMatchActivity());
        dgOrderPreviewReqDto.setBeforeOrderNo(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getBeforeOrderNo());
        dgOrderPreviewReqDto.setOrderType(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType());
        dgOrderPreviewReqDto.setSaleOrderNo(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getSaleOrderNo());
        if (!dgOrderReqDto.getCostAccountControl().booleanValue()) {
            dgOrderPreviewReqDto.setCostAccountRespDtos(null);
        } else if (((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getDgPerformOrderPayReqDto() != null && CollectionUtil.isNotEmpty((Collection)((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getDgPerformOrderPayReqDto().getPayReqDtos())) {
            ArrayList<AccountPreviewDto> accountPreviewDtos = new ArrayList<AccountPreviewDto>();
            for (DgBasePayReqDto payReqDto : ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getDgPerformOrderPayReqDto().getPayReqDtos()) {
                if (!CollectionUtil.isNotEmpty((Collection)payReqDto.getAccountDtos())) continue;
                for (AccountDto accountDto : payReqDto.getAccountDtos()) {
                    AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
                    accountPreviewDto.setAccountCategory(accountDto.getAccountCategory());
                    accountPreviewDto.setAccountType(accountDto.getAccountType());
                    accountPreviewDto.setPriority(accountDto.getPriority());
                    accountPreviewDto.setAvaBalance(accountDto.getDisposable());
                    accountPreviewDto.setOrderAvaBalance(payReqDto.getPayAmount());
                    accountPreviewDtos.add(accountPreviewDto);
                }
            }
            CostAccountDto costAccountDto = new CostAccountDto();
            costAccountDto.setAccountPreviewDtos(accountPreviewDtos);
            ArrayList<CostAccountDto> costAccountRespDtos = new ArrayList<CostAccountDto>();
            costAccountRespDtos.add(costAccountDto);
            dgOrderPreviewReqDto.setCostAccountRespDtos(costAccountRespDtos);
        }
        return dgOrderPreviewReqDto;
    }

    @Override
    public DgOrderPreviewReqDto checkAndTransformIntactOrderData(DgOrderReqDto dgOrderReqDto) {
        dgOrderReqDto.setPreemptType("CHANNEL");
        dgOrderReqDto.setIsShoutVirtualWarehouse(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getShoutVirtualWarehouseList())));
        ArrayList activityBizReqDtos = Lists.newArrayList();
        ArrayList allItemList = Lists.newArrayList();
        ArrayList materialList = Lists.newArrayList();
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(shopOrderReqDto -> {
            AssertUtils.notNull((Object)shopOrderReqDto.getChannelWarehouseCode(), (String)"\u6210\u54c1\u9886\u7528\u5355\u6e20\u9053\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
            ArrayList skuIds = Lists.newArrayList();
            AssertUtils.isTrue((shopOrderReqDto.getOrderAddrReqDto() != null || CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getOrderAddrReqDtos()) ? 1 : 0) != 0, (String)String.format("\u6536\u83b7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a:%s", shopOrderReqDto.getShopId()));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getItemList()), (String)String.format("\u4e0b\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", shopOrderReqDto.getShopId()));
            shopOrderReqDto.setOrderStatus(dgOrderReqDto.getOrderStatus());
            List itemList = shopOrderReqDto.getItemList();
            for (int i = 0; i < itemList.size(); ++i) {
                OrderPreviewItemReqDto item = (OrderPreviewItemReqDto)itemList.get(i);
                AssertUtils.notNull((Object)item.getItemId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1ID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getSkuId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1SKUID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getItemNum(), (String)String.format("\u7b2c%s\u884c\u4e0b\u5355\u6570\u91cf\u4e3a\u7a7a", i));
                skuIds.add(item.getSkuId());
            }
            if (CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getAttachmentFileList())) {
                HashSet fileNameSet = Sets.newHashSet();
                AssertUtils.isTrue((boolean)shopOrderReqDto.getAttachmentFileList().stream().allMatch(attachment -> fileNameSet.add(attachment.getName())), (String)"\u9001\u8d27\u9644\u4ef6,\u540c\u540d\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20");
            }
            Optional.ofNullable(shopOrderReqDto.getActivityList()).ifPresent(activityBizReqDtos::addAll);
            allItemList.addAll(shopOrderReqDto.getItemList());
            if (shopOrderReqDto.getDgPerformOrderPayReqDto() != null) {
                shopOrderReqDto.getDgPerformOrderPayReqDto().setRefreshAccountDto(Boolean.TRUE.booleanValue());
            }
        });
        DgOrderPreviewReqDto dgOrderPreviewReqDto = new DgOrderPreviewReqDto();
        dgOrderPreviewReqDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderPreviewReqDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        dgOrderPreviewReqDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderPreviewReqDto.setMatchActivity(Boolean.valueOf(false));
        dgOrderPreviewReqDto.setNeedFeeThrow(dgOrderReqDto.isNeedFeeThrow());
        dgOrderPreviewReqDto.setActivityList((List)activityBizReqDtos);
        dgOrderPreviewReqDto.setItemList((List)allItemList);
        dgOrderPreviewReqDto.setMaterialList((List)materialList);
        dgOrderPreviewReqDto.setCostAccountRespDtos((List)Lists.newArrayList());
        dgOrderPreviewReqDto.setImportOrderMatchActivity(dgOrderReqDto.isImportOrderMatchActivity());
        dgOrderPreviewReqDto.setBeforeOrderNo(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getBeforeOrderNo());
        dgOrderPreviewReqDto.setOrderType(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType());
        dgOrderPreviewReqDto.setSaleOrderNo(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getSaleOrderNo());
        if (!dgOrderReqDto.getCostAccountControl().booleanValue()) {
            dgOrderPreviewReqDto.setCostAccountRespDtos(null);
        }
        return dgOrderPreviewReqDto;
    }

    @Override
    public DgOrderPreviewReqDto checkAndTransform2cIntactOrderData(DgOrderReqDto dgOrderReqDto) {
        dgOrderReqDto.setIsShoutVirtualWarehouse(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getShoutVirtualWarehouseList())));
        ArrayList activityBizReqDtos = Lists.newArrayList();
        ArrayList allItemList = Lists.newArrayList();
        ArrayList materialList = Lists.newArrayList();
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(shopOrderReqDto -> {
            ArrayList skuIds = Lists.newArrayList();
            AssertUtils.isTrue((shopOrderReqDto.getOrderAddrReqDto() != null || CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getOrderAddrReqDtos()) ? 1 : 0) != 0, (String)String.format("\u6536\u83b7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a:%s", shopOrderReqDto.getShopId()));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getItemList()), (String)String.format("\u4e0b\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", shopOrderReqDto.getShopId()));
            shopOrderReqDto.setOrderStatus(dgOrderReqDto.getOrderStatus());
            List itemList = shopOrderReqDto.getItemList();
            for (int i = 0; i < itemList.size(); ++i) {
                OrderPreviewItemReqDto item = (OrderPreviewItemReqDto)itemList.get(i);
                AssertUtils.notNull((Object)item.getItemId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1ID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getSkuId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1SKUID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getItemNum(), (String)String.format("\u7b2c%s\u884c\u4e0b\u5355\u6570\u91cf\u4e3a\u7a7a", i));
                skuIds.add(item.getSkuId());
            }
            if (CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getAttachmentFileList())) {
                HashSet fileNameSet = Sets.newHashSet();
                AssertUtils.isTrue((boolean)shopOrderReqDto.getAttachmentFileList().stream().allMatch(attachment -> fileNameSet.add(attachment.getName())), (String)"\u9001\u8d27\u9644\u4ef6,\u540c\u540d\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20");
            }
            Optional.ofNullable(shopOrderReqDto.getActivityList()).ifPresent(activityBizReqDtos::addAll);
            allItemList.addAll(shopOrderReqDto.getItemList());
            if (shopOrderReqDto.getDgPerformOrderPayReqDto() != null) {
                shopOrderReqDto.getDgPerformOrderPayReqDto().setRefreshAccountDto(Boolean.TRUE.booleanValue());
            }
        });
        DgOrderPreviewReqDto dgOrderPreviewReqDto = new DgOrderPreviewReqDto();
        dgOrderPreviewReqDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderPreviewReqDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        dgOrderPreviewReqDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderPreviewReqDto.setMatchActivity(Boolean.valueOf(false));
        dgOrderPreviewReqDto.setNeedFeeThrow(dgOrderReqDto.isNeedFeeThrow());
        dgOrderPreviewReqDto.setActivityList((List)activityBizReqDtos);
        dgOrderPreviewReqDto.setItemList((List)allItemList);
        dgOrderPreviewReqDto.setMaterialList((List)materialList);
        dgOrderPreviewReqDto.setCostAccountRespDtos((List)Lists.newArrayList());
        dgOrderPreviewReqDto.setImportOrderMatchActivity(dgOrderReqDto.isImportOrderMatchActivity());
        dgOrderPreviewReqDto.setOrderType(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType());
        dgOrderPreviewReqDto.setSaleOrderNo(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getSaleOrderNo());
        if (!dgOrderReqDto.getCostAccountControl().booleanValue()) {
            dgOrderPreviewReqDto.setCostAccountRespDtos(null);
        }
        return dgOrderPreviewReqDto;
    }

    @Override
    public void supplementExtraInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto = f2BOrderPreviewContext.getDgPjOrgCustomerRelationExtRespDto();
        DgShopOrderReqDto shopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setSaleOrderNo(shopOrderReqDto.getSaleOrderNo());
        f2BPerformOrderReqDto.setOrderType(shopOrderReqDto.getOrderType());
        f2BPerformOrderReqDto.setOrderSource(shopOrderReqDto.getOrderSource());
        f2BPerformOrderReqDto.setDirectOrder(shopOrderReqDto.getDirectOrder());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseId(shopOrderReqDto.getPlanShipmentEnterpriseId());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseCode(shopOrderReqDto.getPlanShipmentEnterpriseCode());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseName(shopOrderReqDto.getPlanShipmentEnterpriseName());
        f2BPerformOrderReqDto.setSellerRemark(shopOrderReqDto.getSellerRemark());
        f2BPerformOrderReqDto.setMatchActivity(Boolean.FALSE.booleanValue());
        log.info("\u8ba2\u5355\u9644\u4ef6\u4fe1\u606fdgShopOrderReqDto.getAttachmentFileList():" + JSON.toJSONString((Object)shopOrderReqDto.getAttachmentFileList()));
        f2BPerformOrderReqDto.setAttachmentFileList(shopOrderReqDto.getAttachmentFileList());
        DgPerformOrderExtensionDto dgPerformOrderExtensionDto = new DgPerformOrderExtensionDto();
        dgPerformOrderExtensionDto.setCustomerBatch(shopOrderReqDto.getCustomerBatch());
        dgPerformOrderExtensionDto.setProductionLotNumber(shopOrderReqDto.getProductionLotNumber());
        dgPerformOrderExtensionDto.setBeforeOrderNo(shopOrderReqDto.getBeforeOrderNo());
        dgPerformOrderExtensionDto.setReceivingStoreId(shopOrderReqDto.getReceivingStoreId());
        dgPerformOrderExtensionDto.setReceivingStoreCode(shopOrderReqDto.getReceivingStoreCode());
        dgPerformOrderExtensionDto.setReceivingStoreName(shopOrderReqDto.getReceivingStoreName());
        dgPerformOrderExtensionDto.setFreightReissueOrderNo(shopOrderReqDto.getFreightReissueOrderNo());
        HashMap map = Maps.newHashMap();
        map.put("businessAreaId", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaId).orElse(null));
        map.put("businessAreaCode", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaCode).orElse(null));
        map.put("businessAreaName", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaName).orElse(null));
        dgPerformOrderExtensionDto.setExtension(JacksonUtil.toJson((Object)map));
        f2BPerformOrderReqDto.setPerformOrderExtensionDto(dgPerformOrderExtensionDto);
        if (StringUtils.isNotBlank((CharSequence)f2BPerformOrderReqDto.getOrderStatus())) {
            ArrayList orderStatusLogRespDtos = Lists.newArrayList();
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(f2BPerformOrderReqDto.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            f2BPerformOrderReqDto.setOrderSteps(JSON.toJSONString((Object)orderStatusLogRespDtos));
        }
    }

    @Override
    public void supplementExtraIntactInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgPjOrgCustomerRelationExtRespDto dgPjOrgCustomerRelationExtRespDto = f2BOrderPreviewContext.getDgPjOrgCustomerRelationExtRespDto();
        DgShopOrderReqDto shopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setSaleOrderNo(shopOrderReqDto.getSaleOrderNo());
        f2BPerformOrderReqDto.setOrderType(shopOrderReqDto.getOrderType());
        f2BPerformOrderReqDto.setOrderSource(shopOrderReqDto.getOrderSource());
        f2BPerformOrderReqDto.setDirectOrder(shopOrderReqDto.getDirectOrder());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseId(shopOrderReqDto.getPlanShipmentEnterpriseId());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseCode(shopOrderReqDto.getPlanShipmentEnterpriseCode());
        f2BPerformOrderReqDto.setPlanShipmentEnterpriseName(shopOrderReqDto.getPlanShipmentEnterpriseName());
        f2BPerformOrderReqDto.setSellerRemark(shopOrderReqDto.getSellerRemark());
        f2BPerformOrderReqDto.setMatchActivity(Boolean.FALSE.booleanValue());
        f2BPerformOrderReqDto.setBizDate(shopOrderReqDto.getBizDate());
        f2BPerformOrderReqDto.setShippingType(shopOrderReqDto.getShippingType());
        log.info("\u8ba2\u5355\u9644\u4ef6\u4fe1\u606fdgShopOrderReqDto.getAttachmentFileList():" + JSON.toJSONString((Object)shopOrderReqDto.getAttachmentFileList()));
        f2BPerformOrderReqDto.setAttachmentFileList(shopOrderReqDto.getAttachmentFileList());
        f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().setKneadeFlag(YesOrNoEnum.NO.getType());
        DgPerformOrderExtensionDto dgPerformOrderExtensionDto = new DgPerformOrderExtensionDto();
        dgPerformOrderExtensionDto.setCustomerBatch(shopOrderReqDto.getCustomerBatch());
        dgPerformOrderExtensionDto.setProductionLotNumber(shopOrderReqDto.getProductionLotNumber());
        dgPerformOrderExtensionDto.setBeforeOrderNo(shopOrderReqDto.getBeforeOrderNo());
        dgPerformOrderExtensionDto.setReceiveSceneCode(shopOrderReqDto.getReceiveSceneCode());
        dgPerformOrderExtensionDto.setReceiveSceneName(shopOrderReqDto.getReceiveSceneName());
        dgPerformOrderExtensionDto.setCostCenterId(shopOrderReqDto.getCostCenterId());
        dgPerformOrderExtensionDto.setCostCenter(shopOrderReqDto.getCostCenter());
        dgPerformOrderExtensionDto.setCostCenterName(shopOrderReqDto.getCostCenterName());
        dgPerformOrderExtensionDto.setEmployeeId(shopOrderReqDto.getEmployeeId());
        dgPerformOrderExtensionDto.setEmployeeNo(shopOrderReqDto.getEmployeeNo());
        dgPerformOrderExtensionDto.setEmployeeName(shopOrderReqDto.getEmployeeName());
        HashMap map = Maps.newHashMap();
        map.put("businessAreaId", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaId).orElse(null));
        map.put("businessAreaCode", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaCode).orElse(null));
        map.put("businessAreaName", Optional.ofNullable(dgPjOrgCustomerRelationExtRespDto).map(DgPjOrgCustomerRelationExtRespDto::getAreaName).orElse(null));
        map.put("shoutVirtualWarehouseList", Optional.ofNullable(shopOrderReqDto.getShoutVirtualWarehouseList()).orElse(Lists.newArrayList()));
        String extension = shopOrderReqDto.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            JSONObject obj = JSON.parseObject((String)extension);
            map.put("receiveDepartmentId", Optional.ofNullable(obj.get((Object)"receiveDepartmentId")).orElse(null));
            map.put("receiveDepartmentCode", Optional.ofNullable(obj.get((Object)"receiveDepartmentCode")).orElse(null));
            map.put("receiveDepartmentName", Optional.ofNullable(obj.get((Object)"receiveDepartmentName")).orElse(null));
            map.put("costBelongDepartmentId", Optional.ofNullable(obj.get((Object)"costBelongDepartmentId")).orElse(null));
            map.put("costBelongDepartmentCode", Optional.ofNullable(obj.get((Object)"costBelongDepartmentCode")).orElse(null));
            map.put("costBelongDepartmentName", Optional.ofNullable(obj.get((Object)"costBelongDepartmentName")).orElse(null));
            map.put("receiveType", Optional.ofNullable(obj.get((Object)"receiveType")).orElse(null));
            map.put("receiveTypeName", Optional.ofNullable(obj.get((Object)"receiveTypeName")).orElse(null));
            map.put("operatingOrganizationId", Optional.ofNullable(obj.get((Object)"operatingOrganizationId")).orElse(null));
            map.put("operatingOrganizationCode", Optional.ofNullable(obj.get((Object)"operatingOrganizationCode")).orElse(null));
            map.put("operatingOrganizationName", Optional.ofNullable(obj.get((Object)"operatingOrganizationName")).orElse(null));
        }
        dgPerformOrderExtensionDto.setExtension(JacksonUtil.toJson((Object)map));
        f2BPerformOrderReqDto.setPerformOrderExtensionDto(dgPerformOrderExtensionDto);
        if (StringUtils.isNotBlank((CharSequence)f2BPerformOrderReqDto.getOrderStatus())) {
            ArrayList orderStatusLogRespDtos = Lists.newArrayList();
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(f2BPerformOrderReqDto.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            f2BPerformOrderReqDto.setOrderSteps(JSON.toJSONString((Object)orderStatusLogRespDtos));
        }
    }

    @Override
    public void supplementCustomizationInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgShopOrderReqDto shopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setPackageRemark(shopOrderReqDto.getPackageRemark());
        f2BPerformOrderReqDto.setCustomerDiscountId(shopOrderReqDto.getCustomerDiscountId());
        f2BPerformOrderReqDto.setHandmadeDiscount(shopOrderReqDto.getHandmadeDiscount());
    }

    private String generateF2BNo(String prefix, Integer footLength) {
        return this.noGreateUtil.generateF2BNo(prefix, footLength);
    }

    @Override
    public void setOrderReturnItemNumMap(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        DgCustomerRespDto dgCustomerRespDto = dgF2BOrderContextVo.getDgCustomerRespDto();
        List shopIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getShopId).distinct().collect(Collectors.toList());
        if (Objects.equals(previewReqDto.getOrderType(), DgSaleOrderTypeEnum.ACCOUNT_REGULATION_ORDER.getType()) && StringUtils.isNotEmpty((CharSequence)previewReqDto.getBeforeOrderNo())) {
            DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.dgAfterSaleOrderService.queryReturnOrderByNo(previewReqDto.getBeforeOrderNo());
            AssertUtils.isTrue((boolean)Objects.equals(dgAfterSaleOrderRespDto.getCustomerCode(), dgCustomerRespDto.getCode()), (String)"\u9000\u8d27\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5339\u914d");
            AssertUtils.isTrue((boolean)shopIds.contains(dgAfterSaleOrderRespDto.getShopId()), (String)"\u9000\u8d27\u5355\u5e97\u94fa\u4fe1\u606f\u4e0d\u5339\u914d");
            List<DgAfterSaleOrderItemRespDto> dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemService.queryByAfterSale(previewReqDto.getBeforeOrderNo(), "0");
            AssertUtils.notEmpty(dgAfterSaleOrderItemRespDtos, (String)"\u9000\u8d27\u5355\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            Map<Object, Object> beforeItemNumMap = new HashMap();
            List<Object> beforeOrderItemNumDtoList = this.commonOrderQueryService.queryRelBeforeItemNum(previewReqDto.getBeforeOrderNo());
            if (CollectionUtils.isNotEmpty(beforeOrderItemNumDtoList)) {
                if (StringUtils.isNotEmpty((CharSequence)previewReqDto.getSaleOrderNo())) {
                    beforeOrderItemNumDtoList = beforeOrderItemNumDtoList.stream().filter(b -> !Objects.equals(b.getSaleOrderNo(), previewReqDto.getSaleOrderNo())).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty(beforeOrderItemNumDtoList)) {
                    beforeItemNumMap = beforeOrderItemNumDtoList.stream().collect(Collectors.toMap(BeforeOrderItemNumDto::getBeforeOrderItemId, BeforeOrderItemNumDto::getItemNum, (k1, k2) -> {
                        k1 = k1.add((BigDecimal)k2);
                        return k1;
                    }));
                }
            }
            HashMap<Long, BigDecimal> orderReturnItemNumMap = new HashMap<Long, BigDecimal>();
            for (DgAfterSaleOrderItemRespDto itemRespDto : dgAfterSaleOrderItemRespDtos) {
                if (ObjectUtil.isEmpty((Object)itemRespDto.getActualReturnNum())) {
                    itemRespDto.setActualReturnNum(itemRespDto.getReturnNum());
                }
                if (beforeItemNumMap.containsKey(itemRespDto.getId())) {
                    Integer orderItemNum = ((BigDecimal)beforeItemNumMap.get(itemRespDto.getId())).intValue();
                    itemRespDto.setActualReturnNum(Integer.valueOf(itemRespDto.getActualReturnNum() - orderItemNum));
                }
                orderReturnItemNumMap.put(itemRespDto.getSkuId(), new BigDecimal(itemRespDto.getActualReturnNum()));
            }
            dgF2BOrderContextVo.setOrderReturnItemNumMap(orderReturnItemNumMap);
        }
        Map orderReturnItemNumMap = dgF2BOrderContextVo.getOrderReturnItemNumMap();
        List itemList = previewReqDto.getItemList();
        Map itemReqDtoMap = itemList.stream().collect(Collectors.toMap(OrderPreviewItemReqDto::getSkuId, Function.identity(), (k1, k2) -> k1));
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        for (int i = 0; i < f2BPerformOrderReqDto.getItemList().size(); ++i) {
            DgPreviewPerformOrderItemReqDto previewItemReqDto = (DgPreviewPerformOrderItemReqDto)f2BPerformOrderReqDto.getItemList().get(i);
            if (!itemReqDtoMap.containsKey(previewItemReqDto.getSkuId())) continue;
            OrderPreviewItemReqDto itemReqDto = (OrderPreviewItemReqDto)itemReqDtoMap.get(previewItemReqDto.getSkuId());
            if (Objects.equals(dgF2BOrderContextVo.getPreviewReqDto().getOrderType(), DgSaleOrderTypeEnum.ACCOUNT_REGULATION_ORDER.getType())) {
                previewItemReqDto.setSupplyPrice(itemReqDto.getSupplyPrice());
                previewItemReqDto.setOriginSupplyPrice(itemReqDto.getOriginSupplyPrice());
            }
            if (orderReturnItemNumMap == null || orderReturnItemNumMap.isEmpty() || !orderReturnItemNumMap.containsKey(previewItemReqDto.getSkuId())) continue;
            BigDecimal dgPolicyPrice = Objects.nonNull(itemReqDto.getSupplyPrice()) ? itemReqDto.getSupplyPrice() : previewItemReqDto.getSalePrice();
            BigDecimal remainNum = (BigDecimal)orderReturnItemNumMap.get(itemReqDto.getSkuId());
            AssertUtils.isFalse((itemReqDto.getItemNum().compareTo(remainNum) > 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u884c\u5546\u54c1\u8d85\u8fc7\u9000\u8d27\u5355\u5546\u54c1\u5269\u4f59\u5b9e\u9000\u6570\u91cf", i + 1));
            previewItemReqDto.setSupplyPrice(dgPolicyPrice);
            previewItemReqDto.setOriginSupplyPrice(itemReqDto.getOriginSupplyPrice());
            previewItemReqDto.setBeforeOrderItemId(itemReqDto.getBeforeOrderItemId());
            previewItemReqDto.setBeforeOrderItemNum(remainNum);
        }
    }

    @Override
    public void checkIsOverdue(DgOrderReqDto dgOrderReqDto) {
        Boolean isOverdue = (Boolean)RestResponseHelper.extractData((RestResponse)this.overduePolicyDgApiProxy.checkIsOverdue(dgOrderReqDto.getCustomerId(), ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getShopId()));
        AssertUtils.isTrue((boolean)isOverdue, (String)"\u8be5\u5ba2\u6237\u6709\u4fe1\u7528\u903e\u671f\uff0c\u4e0d\u53ef\u63d0\u4ea4\u8ba2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
    }

    @Override
    public void supplementAndCheckAdvanceOrderInfo(DgF2BOrderContextVo f2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = f2BOrderContextVo.getPreviewReqDto();
        DgAdvanceOrderRespDto dgAdvanceOrderRespDto = this.dgAdvanceOrderDomain.queryByOrderNo(previewReqDto.getBeforeOrderNo());
        AssertUtils.notNull((Object)dgAdvanceOrderRespDto, (String)"\u9884\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        f2BOrderContextVo.setAdvanceOrderDto(dgAdvanceOrderRespDto);
    }

    @Override
    public void supplement2cIntactOrderInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        f2BPerformOrderReqDto.setOrderStatus(dgOrderReqDto.getOrderStatus());
        f2BOrderPreviewContext.setDgF2BPerformOrderReqDto(f2BPerformOrderReqDto);
    }

    @Override
    public void checkLimit(DgF2BOrderContextVo f2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderReqDto dgOrderReqDto) {
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        DgOrderConfigurationRespDto orderCfgDto = f2BOrderContextVo.getDgOrderConfigurationRespDto();
        if (Objects.equals(orderCfgDto.getEnableLimit(), EnableEnum.ENABLE.getCode()) && Objects.equals(dgShopOrderReqDto.getOrderType(), orderCfgDto.getOrderType())) {
            List itemList = dgF2BPerformOrderReqDto.getItemList();
            List skuIds = itemList.stream().map(DgPerformOrderItemDto::getSkuId).collect(Collectors.toList());
            Long receivingStoreId = Objects.equals(orderCfgDto.getLimitModel(), DgOrderItemLimitModelEnum.RECEIVE_STORE.getCode()) ? dgShopOrderReqDto.getReceivingStoreId() : null;
            Long customerId = Objects.equals(orderCfgDto.getLimitModel(), DgOrderItemLimitModelEnum.CUSTOMER.getCode()) ? dgOrderReqDto.getCustomerId() : null;
            AssertUtils.isTrue((receivingStoreId != null || customerId != null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u9650\u8d2d\u914d\u7f6e\u9519\u8bef");
            List orderItemLimitRespVos = this.dgOmsOrderInfoQueryDomain.countNormalOrderItem(orderCfgDto.getOrderType(), DgF2BOrderStatus.NORMAL_STATUS, receivingStoreId, customerId, skuIds, dgShopOrderReqDto.getSaleOrderNo());
            log.info("\u5386\u53f2\u4e0b\u5355\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)orderItemLimitRespVos));
            List afterOrderItemLimitRespVos = this.dgOmsOrderInfoQueryDomain.countAfterOrderItem(orderCfgDto.getOrderType(), DgF2BOrderStatus.NORMAL_STATUS, receivingStoreId, customerId, skuIds);
            log.info("\u5df2\u9000\u8d27\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)afterOrderItemLimitRespVos));
            Map<Long, BigDecimal> limitItemCountMap = orderItemLimitRespVos.stream().collect(Collectors.toMap(OrderItemLimitRespVo::getSkuId, OrderItemLimitRespVo::getNum, (e1, e2) -> e1));
            Map<Long, BigDecimal> limitAfterItemCountMap = afterOrderItemLimitRespVos.stream().collect(Collectors.toMap(OrderItemLimitRespVo::getSkuId, OrderItemLimitRespVo::getNum, (e1, e2) -> e1));
            for (int i = 0; i < itemList.size(); ++i) {
                DgPreviewPerformOrderItemReqDto itemReqDto = (DgPreviewPerformOrderItemReqDto)itemList.get(i);
                if (Objects.equals(itemReqDto.getItemAttribute(), "10")) continue;
                BigDecimal normalNum = BigDecimalUtils.subtract((BigDecimal)limitItemCountMap.getOrDefault(itemReqDto.getSkuId(), BigDecimal.ZERO), (BigDecimal)limitAfterItemCountMap.getOrDefault(itemReqDto.getSkuId(), BigDecimal.ZERO));
                AssertUtils.isTrue((boolean)BigDecimalUtils.le((BigDecimal)BigDecimalUtils.add((BigDecimal)normalNum, (BigDecimal)itemReqDto.getItemNum()), (BigDecimal)orderCfgDto.getLimitNum()), (String)String.format("\u7b2c%s\u884c\u5546\u54c1\uff0c\u5df2\u4e0b\u5355\u6570\u91cf\uff1a%s, \u8d85\u51fa\u9650\u8d2d\u6570\u91cf%s", i + 1, normalNum.setScale(0, RoundingMode.HALF_DOWN), orderCfgDto.getLimitNum().setScale(0, RoundingMode.HALF_DOWN)));
            }
        }
    }
}

