/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.BasePriceItemSkuQueryReqDto;
import com.yunxi.dg.base.center.price.dto.request.PriceTypeQueryReqDto;
import com.yunxi.dg.base.center.price.dto.response.BasePriceItemSkuQueryRespDto;
import com.yunxi.dg.base.center.price.dto.response.PriceTypeRespDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgBasePriceItemQueryApiProxy;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceTypeQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.help.PriceHelp;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="channelIntactItemServiceImpl")
public class ChannelIntactItemServiceImpl
implements IChannelItemService {
    private static final Logger log = LoggerFactory.getLogger(ChannelIntactItemServiceImpl.class);
    @Value(value="${factory_price_type:Factory_price}")
    private String factoryPriceType;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgBasePriceItemQueryApiProxy dgBasePriceItemQueryApiProxy;
    @Resource
    private IDgPriceTypeQueryApiProxy dgPriceTypeQueryApiProxy;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        List<Long> skuIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
        List<Long> itemIds = previewReqDto.getItemList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
        Map<Long, DgItemSkuPageRespDto> shelfItemMap = this.queryItemInfos(null, skuIds, itemIds);
        Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap = this.queryPrice(f2BOrderPreviewContext, previewReqDto);
        ItemRateDgRespDto itemRateDgRespDto = this.preInfoQueryAction.queryTaxRateByItemIds(itemIds);
        HashMap itemRateMap = null != itemRateDgRespDto && CollectionUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap()) ? itemRateDgRespDto.getItemRateMap() : new HashMap();
        dgF2BOrderContextVo.setItemRateDgRespDtoMap(itemRateMap);
        ArrayList list = Lists.newArrayList();
        AtomicLong lineNo = new AtomicLong(0L);
        for (int i = 0; i < previewReqDto.getItemList().size(); ++i) {
            OrderPreviewItemReqDto itemReqDto = (OrderPreviewItemReqDto)previewReqDto.getItemList().get(i);
            DgItemSkuPageRespDto itemSkuRespDto = shelfItemMap.get(itemReqDto.getSkuId());
            AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("\u7b2c%s\u884c\u5546\u54c1\u672a\u4e0a\u67b6", i + 1));
            BigDecimal dgPolicyPrice = this.getItemPrice(policyPriceDtoMap, itemReqDto);
            AssertUtils.notNull((Object)dgPolicyPrice, (String)String.format("%s\u5546\u54c1\u6682\u65e0\u62a5\u4ef7", itemSkuRespDto.getItemName()));
            ItemRateDgRespDto rateDgRespDto = (ItemRateDgRespDto)itemRateMap.get(itemReqDto.getItemId());
            DgPreviewPerformOrderItemReqDto previewItemReqDto = new DgPreviewPerformOrderItemReqDto();
            previewItemReqDto.setAllowModifyPrice(itemReqDto.isAllowModifyPrice());
            previewItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
            previewItemReqDto.setItemNum(itemReqDto.getItemNum());
            previewItemReqDto.setRemark(itemReqDto.getRemark());
            previewItemReqDto.setStocksCode(itemReqDto.getStocksCode());
            previewItemReqDto.setPlaceItemNum(Optional.ofNullable(itemReqDto.getPlaceItemNum()).orElse(itemReqDto.getItemNum()));
            previewItemReqDto.setOrderItemUnit(itemReqDto.getOrderItemUnit());
            previewItemReqDto.setOrderItemUnitName(itemReqDto.getOrderItemUnitName());
            previewItemReqDto.setBeforeOrderItemId(itemReqDto.getBeforeOrderItemId());
            previewItemReqDto.setBatchNo(itemReqDto.getBatchNo());
            this.SKU_ITEM_TO_PREVIEW_ITEM(previewItemReqDto, itemSkuRespDto, dgPolicyPrice, rateDgRespDto);
            this.setItemPrice(previewItemReqDto, dgPolicyPrice);
            previewItemReqDto.setShopId(itemReqDto.getShopId() + "");
            previewItemReqDto.setSortNo(Optional.ofNullable(itemReqDto.getItemLineNo()).orElse(lineNo.incrementAndGet()));
            previewItemReqDto.setGift(YesNoEnum.NO.getValue());
            previewItemReqDto.setMaterial(YesNoEnum.NO.getValue());
            previewItemReqDto.setPackingNumber(itemSkuRespDto.getPackageNum());
            previewItemReqDto.setPackageNum(itemSkuRespDto.getPackageNum());
            previewItemReqDto.setDiscountAmount(BigDecimal.ZERO);
            previewItemReqDto.setHandmadeDiscount(itemReqDto.getHandmadeDiscount());
            previewItemReqDto.setHandmadeDiscountAmount(itemReqDto.getHandmadeDiscountAmount());
            previewItemReqDto.setIsRebate(Optional.ofNullable(itemReqDto.getIsRebate()).orElse(YesNoEnum.YES.getValue()));
            previewItemReqDto.setAppointPrice(itemReqDto.getAppointPrice());
            previewItemReqDto.setAppointSubtotal(itemReqDto.getAppointSubtotal());
            previewItemReqDto.setTotalUseCostAmount(BigDecimal.ZERO);
            log.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f,\u5546\u54c1skuCode:{},\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7):{},\u9500\u552e\u91d1\u989d:{},\u6d3b\u52a8\u4f18\u60e0\u91d1\u989d:{},\u6210\u4ea4\u91d1\u989d:{},\u8d39\u7528\u62b5\u6263\u91d1\u989d:{},\u9700\u8981\u5b9e\u4ed8\u91d1\u989d:{},\u9500\u552e\u5355\u4f4d:{},\u9500\u552e\u5355\u4f4d\u540d\u79f0:{},\u8ba1\u4ef7\u5355\u4f4d:{},\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0:{},\u5546\u54c1\u7a0e\u7387:{}", new Object[]{previewItemReqDto.getSkuCode(), previewItemReqDto.getItemMarketPrice(), previewItemReqDto.getOrderTotalAmount(), previewItemReqDto.getDiscountAmount(), previewItemReqDto.getItemOrigAmount(), previewItemReqDto.getTotalUseCostAmount(), previewItemReqDto.getPayAmount(), previewItemReqDto.getOrderItemUnit(), previewItemReqDto.getOrderItemUnitName(), previewItemReqDto.getCalcUnit(), previewItemReqDto.getCalcUnitDesc(), previewItemReqDto.getTaxRate()});
            list.add(previewItemReqDto);
        }
        this.preInfoQueryAction.previewOrderItemExchangeUnitNum(list, policyPriceDtoMap);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        DgPerformOrderPaymentDto dgPerformOrderPaymentDto = new DgPerformOrderPaymentDto();
        f2BPerformOrderReqDto.setPerformOrderPaymentDto(dgPerformOrderPaymentDto);
        f2BPerformOrderReqDto.setItemList((List)list);
        f2BPerformOrderReqDto.setMaterialList((List)Lists.newArrayList());
    }

    protected BigDecimal getItemPrice(Map<Long, SkuPolicyPriceRespDto> policyPriceDtoMap, OrderPreviewItemReqDto itemReqDto) {
        SkuPolicyPriceRespDto skuPolicyPriceRespDto = policyPriceDtoMap.get(itemReqDto.getSkuId());
        return PriceHelp.getDgPolicyPrice(skuPolicyPriceRespDto, itemReqDto.getItemNum().intValue());
    }

    protected void setItemPrice(DgPreviewPerformOrderItemReqDto previewItemReqDto, BigDecimal dgPolicyPrice) {
        previewItemReqDto.setPrice(dgPolicyPrice);
        previewItemReqDto.setSalePrice(dgPolicyPrice);
        previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
        previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
    }

    protected Map<Long, DgItemSkuPageRespDto> queryItemInfos(List<Long> shopIds, List<Long> skuIds, List<Long> itemIds) {
        log.info("\u6210\u54c1\u9886\u7528\u8ba2\u5355\u67e5\u8be2\u57fa\u7840\u5546\u54c1\u5e93\u6210\u54c1\u5546\u54c1");
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuIds(skuIds);
        itemQueryDgReqDto.setSearchUnitConvert(Boolean.TRUE);
        itemQueryDgReqDto.setSubStatus(Integer.valueOf(1));
        itemQueryDgReqDto.setItemAttributeList((List)Lists.newArrayList((Object[])new Integer[]{0}));
        itemQueryDgReqDto.setPageSize(Integer.valueOf(skuIds.size() * 2));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(itemQueryDgReqDto));
        Map<Long, DgItemSkuPageRespDto> itemSkuPageRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        return itemSkuPageRespDtoMap;
    }

    protected Map<Long, SkuPolicyPriceRespDto> queryPrice(DgF2BOrderPreviewContext f2BOrderPreviewContext, DgOrderPreviewReqDto previewReqDto) {
        log.info("\u6210\u54c1\u9886\u7528\u5355\u67e5\u8be2\u57fa\u7840\u4ef7\u683c-\u51fa\u5382\u4ef7");
        PriceTypeQueryReqDto priceTypeQueryReqDto = new PriceTypeQueryReqDto();
        priceTypeQueryReqDto.setCategoryCode("0");
        priceTypeQueryReqDto.setTypeCodeList((List)Lists.newArrayList((Object[])new String[]{this.factoryPriceType}));
        List priceTypeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceTypeQueryApiProxy.queryPriceTypeByList(priceTypeQueryReqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)priceTypeRespDtos), (String)"\u4ef7\u683c\u7c7b\u578b\u51fa\u5382\u4ef7\u4fe1\u606f\u4e0d\u5b58\u5728");
        PriceTypeRespDto priceTypeRespDto = (PriceTypeRespDto)priceTypeRespDtos.get(0);
        HashMap handmadePriceMap = Maps.newHashMap();
        ArrayList skuIds = Lists.newArrayList();
        for (OrderPreviewItemReqDto itemReqDto2 : previewReqDto.getItemList()) {
            skuIds.add(itemReqDto2.getSkuId());
            Optional.ofNullable(itemReqDto2.getSupplyPrice()).ifPresent(price -> handmadePriceMap.put(itemReqDto2.getSkuId(), price));
        }
        BasePriceItemSkuQueryReqDto basePriceItemSkuQueryReqDto = new BasePriceItemSkuQueryReqDto();
        basePriceItemSkuQueryReqDto.setTypeId(priceTypeRespDto.getId());
        basePriceItemSkuQueryReqDto.setSkuIdList((List)skuIds);
        basePriceItemSkuQueryReqDto.setOrderTypeList((List)Lists.newArrayList((Object[])new String[]{previewReqDto.getOrderType()}));
        log.info("\u67e5\u8be2\u5546\u54c1\u51fa\u5382\u4ef7\u5165\u53c2={}", JSON.toJSON((Object)basePriceItemSkuQueryReqDto));
        List basePriceItemSkuQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgBasePriceItemQueryApiProxy.querySetPriceListByCondition(basePriceItemSkuQueryReqDto));
        log.info("\u67e5\u8be2\u5546\u54c1\u51fa\u5382\u4ef7\u51fa\u53c2={}", JSON.toJSON((Object)basePriceItemSkuQueryRespDtos));
        Map basePriceDtoMap = basePriceItemSkuQueryRespDtos.stream().collect(Collectors.toMap(BasePriceItemSkuQueryRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        Map<Long, SkuPolicyPriceRespDto> basePolicyPriceMap = previewReqDto.getItemList().stream().map(itemReqDto -> {
            boolean allowModifyPrice = false;
            BigDecimal price = null;
            BasePriceItemSkuQueryRespDto basePriceItemSkuQueryRespDto = (BasePriceItemSkuQueryRespDto)basePriceDtoMap.get(itemReqDto.getSkuId());
            if (basePriceItemSkuQueryRespDto != null && basePriceItemSkuQueryRespDto.getSkuPriceMap() != null) {
                price = (BigDecimal)basePriceItemSkuQueryRespDto.getSkuPriceMap().get(priceTypeRespDto.getId());
            }
            itemReqDto.setAllowModifyPrice(allowModifyPrice);
            AssertUtils.notNull((Object)price, (String)String.format("%s\u51fa\u5382\u4ef7\u672a\u914d\u7f6e", itemReqDto.getSkuId()));
            SkuPolicyPriceRespDto skuPolicyPriceRespDto = new SkuPolicyPriceRespDto();
            skuPolicyPriceRespDto.setSkuId(itemReqDto.getSkuId());
            skuPolicyPriceRespDto.setSupplyPrice(price);
            return skuPolicyPriceRespDto;
        }).collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        return basePolicyPriceMap;
    }

    private void SKU_ITEM_TO_PREVIEW_ITEM(DgPreviewPerformOrderItemReqDto previewItemReqDto, DgItemSkuPageRespDto itemSkuRespDto, BigDecimal dgPolicyPrice, ItemRateDgRespDto rateDgRespDto) {
        previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
        previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
        previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
        previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
        previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setSkuId(itemSkuRespDto.getId());
        previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
        previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
        previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
        previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
        previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
        previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
        previewItemReqDto.setOriginalSkuCode(itemSkuRespDto.getOriginalCode());
        previewItemReqDto.setBasicUnit(itemSkuRespDto.getUnit());
        previewItemReqDto.setBasicUnitName(itemSkuRespDto.getUnitName());
        previewItemReqDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
        previewItemReqDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
        previewItemReqDto.setType(itemSkuRespDto.getItemType() == null ? "" : itemSkuRespDto.getItemType().toString());
        previewItemReqDto.setItemAttribute(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setPackageNum(itemSkuRespDto.getPackageNum());
        previewItemReqDto.setLimitMin(itemSkuRespDto.getLimitMin());
        previewItemReqDto.setSaleAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setItemOrigAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setRealPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnit())) {
            previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit()));
        }
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnitName())) {
            previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName()));
        }
        if (rateDgRespDto != null) {
            previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
        }
        ItemUnitConversionDgDto unitConversionDgDto = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().filter(o -> Objects.equals(previewItemReqDto.getOrderItemUnit(), o.getConversionUnit())).findFirst().orElse(new ItemUnitConversionDgDto());
        BigDecimal weight = Optional.ofNullable(unitConversionDgDto.getGrossWeight()).orElse(BigDecimal.ZERO);
        String weightUnit = StringUtils.isBlank((CharSequence)unitConversionDgDto.getWeightUnit()) ? "KG" : unitConversionDgDto.getWeightUnit();
        BigDecimal volume = Optional.ofNullable(unitConversionDgDto.getVolume()).orElse(BigDecimal.ZERO);
        String volumeUnit = unitConversionDgDto.getVolumeUnit();
        previewItemReqDto.setLength(unitConversionDgDto.getLength());
        previewItemReqDto.setHeight(unitConversionDgDto.getHeight());
        previewItemReqDto.setWidth(unitConversionDgDto.getWidth());
        previewItemReqDto.setWeight(Optional.ofNullable(UnitConverUtil.toKg(weight, weightUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setWeightUnit("KG");
        previewItemReqDto.setVolume(Optional.ofNullable(UnitConverUtil.convertToCubicMeter(volume, volumeUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setUnitConvertList(itemSkuRespDto.getUnitConvertList());
    }

    private void MATERIAL_SKU_ITEM_TO_PREVIEW_ITEM(DgPreviewPerformOrderItemReqDto previewItemReqDto, DgItemSkuDetailRespDto itemSkuRespDto, BigDecimal dgPolicyPrice, ItemRateDgRespDto rateDgRespDto) {
        previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
        previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
        previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
        previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
        previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
        previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
        previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
        previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
        previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
        previewItemReqDto.setPrice(dgPolicyPrice);
        previewItemReqDto.setSkuId(itemSkuRespDto.getId());
        previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
        previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
        previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
        previewItemReqDto.setBasicUnit(itemSkuRespDto.getUnit());
        previewItemReqDto.setBasicUnitName(itemSkuRespDto.getUnitName());
        previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit()));
        previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName()));
        previewItemReqDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
        previewItemReqDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
        previewItemReqDto.setType(itemSkuRespDto.getItemType() == null ? "" : itemSkuRespDto.getItemType().toString());
        previewItemReqDto.setOrderTotalAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setItemOrigAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setRealPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        if (rateDgRespDto != null) {
            previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
        }
    }
}

