/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.share.constants.ShopWarehouseEnum;
import com.yunxi.dg.base.center.share.dto.calc.PreemptExtDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyQueryReqDto;
import com.yunxi.dg.base.center.share.dto.entity.DgShopInventoryDto;
import com.yunxi.dg.base.center.share.dto.entity.DgShopInventoryPageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigureDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigurePageReqDto;
import com.yunxi.dg.base.center.share.proxy.entity.ISupplyWarehouseSourcingConfigureApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionShopApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgShopInventoryApiProxy;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.CustomOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelInventoryService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelInventoryServiceImpl
implements IChannelInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryServiceImpl.class);
    @Resource
    private IDgInventorySupplyStrategyQueryApiProxy dgInventorySupplyStrategyQueryApiProxy;
    @Resource
    private IDgShopInventoryApiProxy dgShopInventoryApiProxy;
    @Resource
    private IDgInventoryPreemptionShopApiProxy dgInventoryPreemptionShopApiProxy;
    @Resource
    private ISupplyWarehouseSourcingConfigureApiProxy supplyWarehouseSourcingConfigureApiProxy;

    @Override
    public void supplementAndCheckInfo(DgF2BOrderContextVo dgF2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        ArrayList<String> shopCodes = new ArrayList<String>();
        String shopCode = dgF2BOrderContextVo.getShopRespDto().getStoreCode();
        shopCodes.add(shopCode);
        DgInventorySupplyStrategyQueryReqDto strategyQueryReqDto = new DgInventorySupplyStrategyQueryReqDto();
        strategyQueryReqDto.setShopCodeList(shopCodes);
        strategyQueryReqDto.setStatus(EnableEnum.ENABLE.getCodeEn());
        strategyQueryReqDto.setFunctionModule(ShopWarehouseEnum.SHOP.getCode().toUpperCase());
        List supplyStrategyDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventorySupplyStrategyQueryApiProxy.queryByList(strategyQueryReqDto));
        log.info("\u6e20\u9053\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)supplyStrategyDtos));
        Map supplyStrategyDtoMap = Optional.ofNullable(supplyStrategyDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(DgInventorySupplyStrategyDto::getShopCode, Function.identity(), (e1, e2) -> e1));
        dgF2BOrderContextVo.setSupplyStrategyDtoMap(supplyStrategyDtoMap);
        DgPerformOrderSnapshotDto snapshotDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().getPerformOrderSnapshotDto();
        if (snapshotDto.getChannelWarehouseId() == null || StringUtils.isBlank((CharSequence)snapshotDto.getChannelWarehouseCode())) {
            DgInventorySupplyStrategyDto supplyStrategyDto = (DgInventorySupplyStrategyDto)supplyStrategyDtoMap.get(dgF2BOrderContextVo.getShopRespDto().getStoreCode());
            if (supplyStrategyDto != null) {
                snapshotDto.setChannelWarehouseId(supplyStrategyDto.getRefEntityId());
                snapshotDto.setChannelWarehouseCode(supplyStrategyDto.getRefEntityCode());
                snapshotDto.setChannelWarehouseName(supplyStrategyDto.getRefEntityName());
            } else {
                log.warn("inventorySupplyStrategyDto\u4e0d\u5b58\u5728");
            }
        }
    }

    @Override
    public void vaildInventory(DgBizPerformOrderReqDto performOrderReqDto) {
        DgShopInventoryPageReqDto shopInventoryPageReqDto = new DgShopInventoryPageReqDto();
        shopInventoryPageReqDto.setShopClassify(ShopWarehouseEnum.CUSTOMER.getCode());
        shopInventoryPageReqDto.setCategory(performOrderReqDto.getOrderType());
        shopInventoryPageReqDto.setShopCode(performOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
        shopInventoryPageReqDto.setSkuCodeList(performOrderReqDto.getItemList().stream().map(DgPerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList()));
        List dgShopInventoryDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgShopInventoryApiProxy.queryTotalList(shopInventoryPageReqDto));
        if (CollectionUtils.isNotEmpty((Collection)dgShopInventoryDtos)) {
            Map inventoryDtoMap = dgShopInventoryDtos.stream().collect(Collectors.toMap(DgShopInventoryDto::getSkuCode, Function.identity(), (e1, e2) -> e1));
            for (DgPerformOrderItemReqDto itemReqDto : performOrderReqDto.getItemList()) {
                DgShopInventoryDto dgShopInventoryDto = (DgShopInventoryDto)inventoryDtoMap.get(itemReqDto.getSkuCode());
                AssertUtils.isTrue((dgShopInventoryDto == null || dgShopInventoryDto.getAvailable() != null && dgShopInventoryDto.getAvailable().compareTo(itemReqDto.getItemNum()) >= 0 ? 1 : 0) != 0, (String)String.format("%s\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3", itemReqDto.getSkuCode()));
            }
        }
    }

    @Override
    public void preemptByBatch(DgOrderResultRespDto resultRespDto, DgOrderReqDto dgOrderReqDto) {
        DgBizPerformOrderReqDto bizPerformOrderReqDto = resultRespDto.getDgBizPerformOrderReqDto();
        ArrayList preemptExtDtos = Lists.newArrayList();
        PreemptExtDto preemptExtDto = new PreemptExtDto();
        SupplyWarehouseSourcingConfigureDto dgVirtualWarehouseDto = null;
        List shoutVirtualWarehouseCodeList = Optional.ofNullable(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getShoutVirtualWarehouseList()).orElse(Lists.newArrayList()).stream().map(DgOrderWarehouseReqDto::getWarehouseCode).collect(Collectors.toList());
        if (CustomOrderTypeEnum.CUSTOM_ORDER_TYPE_LIST.contains(bizPerformOrderReqDto.getOrderType())) {
            SupplyWarehouseSourcingConfigurePageReqDto reqDto = new SupplyWarehouseSourcingConfigurePageReqDto();
            reqDto.setShopCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            List configureDtos = (List)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.list(reqDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)configureDtos), (String)"\u4f9b\u8d27\u4ed3\u5bfb\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
            dgVirtualWarehouseDto = (SupplyWarehouseSourcingConfigureDto)configureDtos.get(0);
            shoutVirtualWarehouseCodeList.add(dgVirtualWarehouseDto.getRecodingSupplyWarehouseCode());
            if (CustomOrderTypeEnum.CHANGE_DELIVERY_ORDER.getType().equals(bizPerformOrderReqDto.getOrderType())) {
                shoutVirtualWarehouseCodeList.add(dgVirtualWarehouseDto.getChannelDefaultWarehouseCode());
            } else if (CustomOrderTypeEnum.STOCK_REFORM_ORDER.getType().equals(bizPerformOrderReqDto.getOrderType())) {
                preemptExtDto.setValidChannelNegative(Boolean.FALSE);
            }
        }
        DgPerformOrderSnapshotDto performOrderSnapshotDto = bizPerformOrderReqDto.getPerformOrderSnapshotDto();
        AssertUtils.notNull((Object)bizPerformOrderReqDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)bizPerformOrderReqDto.getItemList(), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        preemptExtDto.setHasRecordForError(Boolean.TRUE);
        preemptExtDto.setShopCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
        preemptExtDto.setSourceNo(bizPerformOrderReqDto.getSaleOrderNo());
        preemptExtDto.setSourceType(bizPerformOrderReqDto.getOrderType());
        preemptExtDto.setPreemptSupply(Boolean.TRUE);
        preemptExtDto.setPreemptWarehouseCode(performOrderSnapshotDto.getChannelWarehouseCode());
        preemptExtDto.setIsShoutVirtualWarehouse(dgOrderReqDto.getIsShoutVirtualWarehouse());
        preemptExtDto.setShoutVirtualWarehouseCodeList(shoutVirtualWarehouseCodeList);
        preemptExtDto.setPreemptType(dgOrderReqDto.getPreemptType());
        preemptExtDto.setValidChannelNegative(dgOrderReqDto.getIsVerifyChannelInventory());
        preemptExtDto.setValidNegative(dgOrderReqDto.getIsVerifySupplyInventory());
        List operationDetailDtoList = bizPerformOrderReqDto.getItemList().stream().map(itemReqDto -> {
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(itemReqDto.getSkuCode());
            inventoryOperateCargoReqDto.setNum(itemReqDto.getBasicNum());
            inventoryOperateCargoReqDto.setPreOrderItemId(itemReqDto.getId());
            inventoryOperateCargoReqDto.setShopCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            inventoryOperateCargoReqDto.setValidNegative(dgOrderReqDto.getIsVerifySupplyInventory());
            inventoryOperateCargoReqDto.setWarehouseCode(performOrderSnapshotDto.getChannelWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)bizPerformOrderReqDto.getGiftList())) {
            List giftDetailDtoList = bizPerformOrderReqDto.getGiftList().stream().map(itemReqDto -> {
                OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                inventoryOperateCargoReqDto.setSkuCode(itemReqDto.getSkuCode());
                inventoryOperateCargoReqDto.setNum(itemReqDto.getBasicNum());
                inventoryOperateCargoReqDto.setPreOrderItemId(itemReqDto.getId());
                inventoryOperateCargoReqDto.setShopCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
                inventoryOperateCargoReqDto.setValidNegative(dgOrderReqDto.getIsVerifySupplyInventory());
                inventoryOperateCargoReqDto.setWarehouseCode(performOrderSnapshotDto.getChannelWarehouseCode());
                return inventoryOperateCargoReqDto;
            }).collect(Collectors.toList());
            operationDetailDtoList.addAll(giftDetailDtoList);
        }
        preemptExtDto.setDetails(operationDetailDtoList);
        preemptExtDtos.add(preemptExtDto);
        try {
            log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDtos));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.preemptByBatch((List)preemptExtDtos));
        }
        catch (Exception e) {
            log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
            throw new BizException("\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff0c" + e.getMessage());
        }
    }
}

