/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderErrorDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderErrorReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderOptLogReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.service.sys.IDgPerformOrderOptLogService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgCommonLabelManageServiceImpl
implements IDgCommonLabelManageService {
    private static final Logger log = LoggerFactory.getLogger(DgCommonLabelManageServiceImpl.class);
    private static final Set<DgOrderLabelEnum> EXTENDS_LABEL = Sets.newHashSet((Object[])new DgOrderLabelEnum[]{DgOrderLabelEnum.PRE_SALE_ORDER, DgOrderLabelEnum.SALE_ORDER_CREATE, DgOrderLabelEnum.ITEM_GIFT, DgOrderLabelEnum.ITEM_COMBINATION, DgOrderLabelEnum.REFUND_ITEM, DgOrderLabelEnum.SG_MODIFY_ADDRESS});
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private IDgPerformOrderOptLogService performOrderOptLogService;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgPerformOrderErrorDomain performOrderErrorDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgOrderLabelRecordDomain labelRecordDomain;

    @Override
    public void markByOrderCreate(DgBizPerformOrderReqDto reqDto) {
        List performOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(reqDto.getId());
        AssertUtils.notEmpty((Collection)performOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{reqDto.getId()});
        this.markGift(performOrderItemRespDtos);
        this.markCombination(performOrderItemRespDtos);
        this.markOrderSource((DgPerformOrderReqDto)reqDto);
        this.markOrderType((DgPerformOrderReqDto)reqDto);
    }

    @Override
    public void markGiftByOrderId(Long saleOrderId) {
        List performOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        AssertUtils.notEmpty((Collection)performOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markGift(performOrderItemRespDtos);
    }

    private void markGift(List<DgPerformOrderLineDto> orderItemLineDtos) {
        List orderGiftRespDtos = orderItemLineDtos.stream().filter(item -> DgGiftEnum.GIFT.getType().equals(item.getGiftFlag())).collect(Collectors.toList());
        log.debug("[\u8ba2\u5355\u5546\u54c1\u8d60\u54c1\u6253\u6807]\u9700\u8981\u6253\u8d60\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderGiftRespDtos));
        Optional.ofNullable(orderGiftRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemDomain.addOrderLabelItem(item.getOrderId(), item.getId(), DgOrderLabelEnum.ITEM_GIFT)));
        if (orderGiftRespDtos.size() == orderItemLineDtos.size()) {
            this.orderLabelRecordDomain.addOrderLabelRecord(orderItemLineDtos.get(0).getOrderId(), DgOrderLabelEnum.ORDER_GIFT);
        }
    }

    private void markCombination(List<DgPerformOrderLineDto> orderItemLineDtos) {
        List orderCombinationRespDtos = orderItemLineDtos.stream().filter(item -> DgSaleOrderItemTypeEnum.COMBINATION.getType().equals(item.getItemType())).collect(Collectors.toList());
        log.debug("[\u8ba2\u5355\u5546\u54c1\u7ec4\u5408\u5546\u54c1\u6253\u6807]\u9700\u8981\u6253\u7ec4\u5408\u5546\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderCombinationRespDtos));
        Optional.ofNullable(orderCombinationRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemDomain.addOrderLabelItem(item.getOrderId(), item.getId(), DgOrderLabelEnum.ITEM_COMBINATION)));
        if (CollectionUtils.isNotEmpty(orderCombinationRespDtos)) {
            this.orderLabelRecordDomain.addOrderLabelRecord(orderItemLineDtos.get(0).getOrderId(), DgOrderLabelEnum.ORDER_COMBINATION);
        }
    }

    private void markOrderSource(DgPerformOrderReqDto reqDto) {
        log.info("\u8ba2\u5355\u6765\u6e90:{}", (Object)reqDto.getOrderSource());
        ArrayList orderSourceOfHandLabelList = Lists.newArrayList((Object[])new Integer[]{DgSaleOrderSourceEnum.CREATE.getType(), DgSaleOrderSourceEnum.IMPORT.getType()});
        log.info("\u9700\u8981\u6253\u624b\u5de5\u5355\u7684\u6765\u6e90:{}", (Object)((Object)orderSourceOfHandLabelList).toString());
        if (DgSaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(reqDto.getOrderType())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u6362\u8d27\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            if (StringUtils.isNotBlank((CharSequence)reqDto.getExchangeOrderNo())) {
                log.info("[\u6253\u6807]\u8ba2\u5355={},\u662f\u901a\u8fc7\u6362\u8d27\u5355\u751f\u6210\u7684\u9500\u552e\u5355,\u5173\u8054\u7684\u6362\u8d27\u5355\u53f7:{},\u9700\u8981\u6253\u6362\u6807\u8bc6", (Object)reqDto.getId(), (Object)reqDto.getExchangeOrderNo());
                this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.HH);
            }
        }
        if (orderSourceOfHandLabelList.contains(reqDto.getOrderSource())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.SALE_ORDER_CREATE);
        }
    }

    private void markOrderType(DgPerformOrderReqDto reqDto) {
        if (DgSaleOrderTypeEnum.PRE_SALE_ORDER.getType().equals(reqDto.getOrderType())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.PRE_SALE_ORDER);
        }
    }

    @Override
    public void markLabelByExtendsParentOrder(List<DgPerformOrderRespDto> childOrderList) {
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(DgPerformOrderSplitReleationEo::getChildOrderId, (Collection)childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList()));
            List childOrderDtoList = this.performOrderSplitReleationDomain.getMapper().selectList((Wrapper)queryWrapper);
            DgPerformOrderSplitReleationEo splitReleationEo = (DgPerformOrderSplitReleationEo)childOrderDtoList.get(0);
            DgPerformOrderRespDto parentOrder = this.omsOrderInfoQueryDomain.queryDtoById(splitReleationEo.getOrderId());
            AssertUtils.notNull((Object)parentOrder, (String)"\u7236\u8ba2\u5355\u4e0d\u5b58\u5728");
            List extendsLabels = EXTENDS_LABEL.stream().map(DgOrderLabelEnum::getCode).collect(Collectors.toList());
            List labelRecordRespDtos = Optional.ofNullable(this.orderLabelRecordDomain.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{parentOrder.getId()}))).orElseGet(Collections::emptyList).stream().filter(orderLabelRecordRespDto -> extendsLabels.contains(orderLabelRecordRespDto.getLabelCode())).collect(Collectors.toList());
            List orderLabelItemRespDtos = Optional.ofNullable(this.orderLabelItemDomain.queryByOrderId(parentOrder.getId())).orElseGet(Collections::emptyList).stream().filter(orderLabelRecordRespDto -> extendsLabels.contains(orderLabelRecordRespDto.getLabelCode())).collect(Collectors.toList());
            Map<Long, List<DgOrderLabelItemDto>> orderItemLabelMap = orderLabelItemRespDtos.stream().collect(Collectors.groupingBy(DgOrderLabelItemDto::getOrderItemId));
            log.info("[\u6807\u8bc6\u7ee7\u627f]\u5b50\u8ba2\u5355\u9700\u8981\u7ee7\u627f\u7236\u8ba2\u5355\u7684\u8ba2\u5355\u6807\u8bc6\u6709\uff1a{}\uff0c \u5546\u54c1\u884c\u7ee7\u627f\u7684\u6807\u8bc6\u6709\uff1a{}", (Object)JSON.toJSONString(labelRecordRespDtos), (Object)JSON.toJSONString(orderLabelItemRespDtos));
            List parentOrderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(parentOrder.getId());
            AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)parentOrderLineDtos), (String)"\u7236\u8ba2\u5355\u8ba2\u5355\u884c\u4fe1\u606f\u672a\u67e5\u5230");
            Map parenOrderLineMap = parentOrderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
            List orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List performOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(orderIdList);
            Map<Long, List<DgPerformOrderLineDto>> orderItemMap = performOrderItemRespDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
            orderItemMap.forEach((orderId, saleOrderItemRespDtos) -> {
                log.info("[\u6807\u8bc6\u7ee7\u627f]\u8ba2\u5355id={}\uff0c \u8ba2\u5355\u9700\u8981\u7ee7\u627f\u7684\u6807\u8bc6\u6709\uff1a{}", orderId, (Object)JSON.toJSONString((Object)saleOrderItemRespDtos));
                labelRecordRespDtos.forEach(orderLabelRecordRespDto -> {
                    DgOrderLabelEnum orderLabelEnum = (DgOrderLabelEnum)DgOrderLabelEnum.CODE_LOOKUP.get(orderLabelRecordRespDto.getLabelCode());
                    this.orderLabelRecordDomain.addOrderLabelRecord(orderId, orderLabelEnum);
                    List giftOrderLineDtos = saleOrderItemRespDtos.stream().filter(dto -> dto.getGiftFlag().equals(YesOrNoEnum.YES.getType())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(giftOrderLineDtos) && giftOrderLineDtos.size() == saleOrderItemRespDtos.size()) {
                        this.orderLabelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.ORDER_GIFT);
                    }
                });
            });
            if (CollectionUtils.isNotEmpty(orderLabelItemRespDtos)) {
                for (DgOrderLabelItemDto orderLabelItemRespDto : orderLabelItemRespDtos) {
                    DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)parenOrderLineMap.get(orderLabelItemRespDto.getOrderItemId());
                    if (orderLineDto == null) continue;
                    for (DgPerformOrderLineDto performOrderItemRespDto : performOrderItemRespDtos) {
                        if (!performOrderItemRespDto.getSkuCode().equals(orderLineDto.getSkuCode()) || !Objects.equals(orderLineDto.getGiftFlag(), performOrderItemRespDto.getGiftFlag())) continue;
                        DgOrderLabelEnum orderLabelEnum = (DgOrderLabelEnum)DgOrderLabelEnum.CODE_LOOKUP.get(orderLabelItemRespDto.getLabelCode());
                        this.orderLabelItemDomain.addOrderLabelItem(performOrderItemRespDto.getOrderId(), performOrderItemRespDto.getId(), orderLabelEnum);
                    }
                }
            }
        }
    }

    @Override
    public void markTagForChildOrder(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DgPerformOrderSplitReleationEo::getOrderId, (Object)saleOrderId);
        List childOrderList = this.performOrderSplitReleationDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)childOrderList)) {
            for (DgPerformOrderSplitReleationEo releationEo : childOrderList) {
                this.orderLabelRecordDomain.addOrderLabelRecord(releationEo.getChildOrderId(), DgOrderLabelEnum.CHILD_ORDER);
            }
            log.info("[\u5b50\u8ba2\u5355\u6253\u6807]\u5b8c\u6210\u6253\u6807\u5b50\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)childOrderList));
        }
    }

    @Override
    public void markVirtualOrderLabel(Long orderId) {
        log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u865a\u62df\u8ba2\u5355\u6807\u8bc6", (Object)orderId);
        this.labelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.VIRTUAL_ORDER);
    }

    @Override
    public void markLabelForOrderItems(DgPerformOrderRespDto reqDto) {
        List performOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(reqDto.getId());
        this.markCombination(performOrderItemRespDtos);
        this.markGift(performOrderItemRespDtos);
    }

    @Override
    public void markLackByPreemtResult(InventoryOperateRespDto request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getFailList())) {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(request.getSourceNo());
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(performOrderRespDto.getId());
            List skuCodeOfLackList = request.getFailList().stream().map(InventoryOperateCargoRespDto::getLongCode).distinct().collect(Collectors.toList());
            List<DgPerformOrderLineDto> saleOrderItemsOfEnought = orderLineDtos.stream().filter(saleOrderItemRespDto -> !skuCodeOfLackList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            saleOrderItemsOfEnought.forEach(saleOrderItemRespDto -> this.orderLabelItemDomain.removeOrderLabelItemById(saleOrderItemRespDto.getOrderId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK));
            List<DgPerformOrderLineDto> saleOrderItemRespDtos = orderLineDtos.stream().filter(saleOrderItemRespDto -> skuCodeOfLackList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            log.info("[\u6253\u6807]\u9700\u8981\u6253\u7f3a\u8d27\u6807\u8bc6\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(saleOrderItemRespDtos));
            saleOrderItemRespDtos.forEach(saleOrderItemRespDto -> this.orderLabelItemDomain.addOrderLabelItem(saleOrderItemRespDto.getOrderId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK));
        }
    }

    @Override
    public void markLackBySourceResult(DgSourceOrderResultRespDto respDto) {
        if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(respDto.getSgStatus())) {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(respDto.getLinkOrderNo());
            List orderItemResultRespDtoList = respDto.getOrderItemResultRespDtoList();
            if (CollectionUtils.isEmpty((Collection)orderItemResultRespDtoList)) {
                log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5bfb\u6e90\u5931\u8d25\uff0c\u6574\u4e2a\u8ba2\u5355\u7684\u5546\u54c1\u90fd\u6253\u7f3a\u8d27\u6807\uff0c\u8ba2\u5355no={}", (Object)respDto.getLinkOrderNo());
                this.markLackByOrderId(performOrderRespDto.getId());
            } else {
                List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(performOrderRespDto.getId());
                AssertUtils.notEmpty((Collection)orderLineDtos, (String)"%s \u8ba2\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[]{performOrderRespDto.getSaleOrderNo()});
                Map sourceOrderItemsMap = orderItemResultRespDtoList.stream().collect(Collectors.toMap(DgOrderItemResultDto::getLinkOrderItemId, Function.identity(), (v1, v2) -> v2));
                log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5bfb\u6e90\u7ed3\u679c\u7684\u5546\u54c1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sourceOrderItemsMap));
                orderLineDtos.forEach(saleOrderItemRespDto -> {
                    DgOrderItemResultDto orderItemResultRespDto = (DgOrderItemResultDto)sourceOrderItemsMap.get(saleOrderItemRespDto.getId());
                    if (Objects.isNull(orderItemResultRespDto)) {
                        this.orderLabelItemDomain.addOrderLabelItem(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    } else if (saleOrderItemRespDto.getItemNum().compareTo(orderItemResultRespDto.getDeliveryItemNum()) > 0) {
                        log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5546\u54c1id\uff1a{}\u3001skucode={}\uff0c\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u53ef\u7528\u5e93\u5b58\u4e3a\uff1a{}", new Object[]{saleOrderItemRespDto.getId(), saleOrderItemRespDto.getSkuCode(), saleOrderItemRespDto.getItemNum(), orderItemResultRespDto.getDeliveryItemNum()});
                        this.orderLabelItemDomain.addOrderLabelItem(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    } else {
                        this.orderLabelItemDomain.removeOrderLabelItemById(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    }
                });
            }
        }
    }

    @Override
    public void markMainTag(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        if (StringUtils.isEmpty((CharSequence)performOrderInfoDto.getOriginalOrderNo())) {
            this.labelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.MAIN);
        }
    }

    @Override
    public void markLackByOrderId(Long saleOrderId) {
        this.markLackTagForItems(saleOrderId, null);
    }

    public void markLackTagForItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setOrderId(saleOrderId);
        reqDto.setSkuCodeList(skuCodeList);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(reqDto);
        log.debug("[\u8ba2\u5355\u5546\u54c1\u7f3a\u8d27\u6253\u6807]\u9700\u8981\u6253\u7f3a\u8d27\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderLineDtos));
        if (CollectionUtils.isNotEmpty((Collection)orderLineDtos)) {
            for (DgPerformOrderLineDto saleOrderItemRespDto : orderLineDtos) {
                this.orderLabelItemDomain.addOrderLabelItem(saleOrderId, saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
            }
        }
    }

    @Override
    public void markSplitTag(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.labelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.SPLIT);
    }

    @Override
    public void markOrderGiftByOrderId(DgPerformOrderRespDto respDto) {
        this.labelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.ORDER_GIFT);
    }

    @Override
    public void markArrWarehouseLabelByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u6307\u5b9a\u53d1\u8d27\u4ed3\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.ARRANGE_WAREHOUSE);
    }

    @Override
    public void removeErrorByOrderId(Long saleOrderId) {
        this.orderLabelItemDomain.removeOrderLabelRecord(saleOrderId, DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
    }

    @Override
    public void removeLackByOrderId(Long saleOrderId) {
        List orderLabelItemRespDtos = Optional.ofNullable(this.orderLabelItemDomain.queryByOrderId(saleOrderId)).orElseGet(Collections::emptyList).stream().filter(orderLabelItemRespDto -> DgOrderLabelEnum.ITEM_LACK.getCode().equals(orderLabelItemRespDto.getLabelCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderLabelItemRespDtos)) {
            log.info("[\u79fb\u9664\u7f3a\u8d27\u6807]\u8ba2\u5355id={}\u79fb\u9664\u7f3a\u8d27\u6807\u8bc6", (Object)saleOrderId);
            List idList = orderLabelItemRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            Collections.sort(idList);
            for (Long id : idList) {
                this.orderLabelItemDomain.removeOrderLabelItemById(id);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void markShipRelationErrorByOrderId(DgPerformOrderRespDto respDto, boolean addByPick) {
        this.orderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.WMS_SHIP_RELATION_ERROR);
        DgPerformOrderErrorReqDto saleOrderErrorReqDto = new DgPerformOrderErrorReqDto();
        saleOrderErrorReqDto.setOrderId(respDto.getId());
        if (addByPick) {
            saleOrderErrorReqDto.setErrorReason("\u914d\u8d27\u65f6\uff0cWMS\u7269\u6d41" + respDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseCode() + "\u6620\u5c04\u4e0d\u5230\u7269\u6d41\u7f16\u7801");
            saleOrderErrorReqDto.setErrorType("\u914d\u8d27\u8ba2\u5355\u914d\u8d27\u65f6WMS\u7269\u6d41\u6620\u5c04\u5f02\u5e38");
        } else {
            saleOrderErrorReqDto.setErrorReason("\u53d1\u8d27\u56de\u4f20\u540e\uff0cWMS\u7269\u6d41" + respDto.getPerformOrderWarehouseInfoDto().getShipmentEnterpriseCode() + "\u6620\u5c04\u4e0d\u5230\u7269\u6d41\u7f16\u7801");
            saleOrderErrorReqDto.setErrorType("\u914d\u8d27\u8ba2\u5355\u53d1\u8d27\u56de\u4f20\u65f6WMS\u7269\u6d41\u6620\u5c04\u5f02\u5e38");
        }
        this.performOrderErrorDomain.addSaleOrderError(saleOrderErrorReqDto);
    }

    @Override
    public void removeShipRelationErrorByOrderId(DgPerformOrderRespDto respDto) {
        this.orderLabelItemDomain.removeOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.WMS_SHIP_RELATION_ERROR);
    }

    @Override
    public boolean addRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
        this.saveOptLogRecord(orderId);
        return true;
    }

    private void saveOptLogRecord(Long orderId) {
        DgPerformOrderOptLogReqDto saleOrderOptLogReqDto = new DgPerformOrderOptLogReqDto();
        saleOrderOptLogReqDto.setSaleOrderId(orderId);
        saleOrderOptLogReqDto.setOptTime(new Date());
        saleOrderOptLogReqDto.setOptPerson("system");
        saleOrderOptLogReqDto.setOptType("\u9000\u6b3e\u62e6\u622a");
        saleOrderOptLogReqDto.setOptTypeEn("REFUND_INTERCEPT");
        this.performOrderOptLogService.addSaleOrderOptLog(saleOrderOptLogReqDto);
    }

    @Override
    public void removeRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            log.info("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355\u672a\u5904\u4e8e\u62e6\u622a\u4e2d\uff0c\u65e0\u9700\u79fb\u9664\u62e6\u622a\u6807\u8bc6orderId={}", (Object)orderId);
            return;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw DgPcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
    }

    @Override
    public void markOrderSourcePromotion(DgBizPerformOrderReqDto reqDto) {
        if (DgSaleOrderSourceEnum.PROMOTION.getType().equals(reqDto.getOrderSource())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u4fc3\u9500\u6d3b\u52a8\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.labelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.ORDER_PROMOTION);
        }
    }

    @Override
    public void markLogisticsSourceErrorByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u7269\u6d41\u5bfb\u6e90\u5f02\u5e38\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelItemDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.LOGISTICS_SOURCE_ERROR);
    }

    @Override
    public void removeLogisticsSourceErrorByOrderId(Long saleOrderId) {
        this.orderLabelItemDomain.removeOrderLabelRecord(saleOrderId, DgOrderLabelEnum.LOGISTICS_SOURCE_ERROR);
    }

    @Override
    public void markArrShipmentLabelByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u6307\u5b9a\u7269\u6d41\u5546\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelItemDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.ARRANGE_SHIPMENT);
    }

    @Override
    public boolean removeAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        log.info("\u5220\u9664\u6240\u6709\u6807\u8bb0\u548c\u62e6\u622a\u6807\u8bb0");
        this.orderLabelRecordDomain.removeOrderLabelRecordById(respDto.getId(), DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT);
        this.orderLabelRecordDomain.removeOrderLabelRecordById(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
        this.performOrderErrorDomain.removeSaleOrderErrorByOrderId(respDto.getId());
        return false;
    }

    @Override
    public void markAdvancedDeliverOrderLabel(Long orderId) {
        log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u865a\u62df\u8ba2\u5355\u6807\u8bc6", (Object)orderId);
        this.labelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.ADVANCED_DELIVER);
    }
}

