/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderConfig.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.convert.entity.DgOrderConfigurationConverter;
import com.yunxi.dg.base.center.trade.domain.config.IDgOrderConfigurationDomain;
import com.yunxi.dg.base.center.trade.domain.config.IDgOrderConfigurationPriorityDomain;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationDto;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationPageReqDto;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationPriorityDto;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationReqDto;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderConfigurationEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderConfigurationPriorityEo;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class DgOrderConfigurationServiceImpl
extends BaseServiceImpl<DgOrderConfigurationDto, DgOrderConfigurationEo, IDgOrderConfigurationDomain>
implements IDgOrderConfigurationService {
    @Resource
    private IDgOrderConfigurationDomain dgOrderConfigurationDomain;
    @Resource
    private IDgOrderConfigurationPriorityDomain dgOrderConfigurationPriorityDomain;
    @Resource
    private IDgShopQueryApiProxy dgShopQueryApiProxy;

    public DgOrderConfigurationServiceImpl(IDgOrderConfigurationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOrderConfigurationDto, DgOrderConfigurationEo> converter() {
        return DgOrderConfigurationConverter.INSTANCE;
    }

    @Override
    public Long addConfigInfo(DgOrderConfigurationReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!Objects.equals(addReqDto.getEnableLimit(), EnableEnum.ENABLE.getCode()) || addReqDto.getOrderType() != null ? 1 : 0) != 0, (String)"\u6837\u54c1\u8ba2\u5355\u9650\u8d2d\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        String shopCode = addReqDto.getShopCode();
        DgOrderConfigurationEo queryConfigEo = new DgOrderConfigurationEo();
        queryConfigEo.setShopCode(shopCode);
        DgOrderConfigurationEo configurationEo = (DgOrderConfigurationEo)this.dgOrderConfigurationDomain.selectOne((BaseEo)queryConfigEo);
        AssertUtils.isNull((Object)configurationEo, (String)("\u5e97\u94fa" + addReqDto.getShopName() + "[" + addReqDto.getShopCode() + "]\u5df2\u5b58\u5728\u914d\u7f6e"));
        DgOrderConfigurationEo dgOrderConfigurationEo = new DgOrderConfigurationEo();
        CubeBeanUtils.copyProperties((Object)dgOrderConfigurationEo, (Object)addReqDto, (String[])new String[0]);
        this.dgOrderConfigurationDomain.insert((BaseEo)dgOrderConfigurationEo);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getPriorityDtoList())) {
            ArrayList addPriorityEoList = Lists.newArrayList();
            for (DgOrderConfigurationPriorityDto priorityDto : addReqDto.getPriorityDtoList()) {
                DgOrderConfigurationPriorityEo priorityEo = new DgOrderConfigurationPriorityEo();
                CubeBeanUtils.copyProperties((Object)priorityEo, (Object)priorityDto, (String[])new String[0]);
                priorityEo.setConfigurationId(dgOrderConfigurationEo.getId());
                addPriorityEoList.add(priorityEo);
            }
            this.dgOrderConfigurationPriorityDomain.insertBatch((List)addPriorityEoList);
        }
        return dgOrderConfigurationEo.getId();
    }

    @Override
    public void modifyConfigInfo(DgOrderConfigurationReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getId(), (String)"\u66f4\u65b0ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getShopId(), (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        DgShopRespDto dgShopRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.dgShopQueryApiProxy.getShopDetailById(addReqDto.getShopId()));
        AssertUtils.notNull((Object)dgShopRespDto, (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgOrderConfigurationEo dgOrderConfigurationEo = new DgOrderConfigurationEo();
        CubeBeanUtils.copyProperties((Object)dgOrderConfigurationEo, (Object)addReqDto, (String[])new String[0]);
        dgOrderConfigurationEo.setShopCode(dgShopRespDto.getStoreCode());
        dgOrderConfigurationEo.setShopName(dgShopRespDto.getStoreName());
        this.dgOrderConfigurationDomain.update((BaseEo)dgOrderConfigurationEo);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getPriorityDtoList())) {
            ArrayList addPriorityEoList = Lists.newArrayList();
            for (DgOrderConfigurationPriorityDto priorityDto : addReqDto.getPriorityDtoList()) {
                DgOrderConfigurationPriorityEo priorityEo = new DgOrderConfigurationPriorityEo();
                CubeBeanUtils.copyProperties((Object)priorityEo, (Object)priorityDto, (String[])new String[0]);
                priorityEo.setConfigurationId(dgOrderConfigurationEo.getId());
                addPriorityEoList.add(priorityEo);
            }
            this.dgOrderConfigurationPriorityDomain.insertBatch((List)addPriorityEoList);
        }
    }

    @Override
    public DgOrderConfigurationRespDto queryDetailById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderConfigurationRespDto respDto = new DgOrderConfigurationRespDto();
        DgOrderConfigurationEo configurationEo = (DgOrderConfigurationEo)this.dgOrderConfigurationDomain.selectByPrimaryKey(id);
        CubeBeanUtils.copyProperties((Object)respDto, (Object)configurationEo, (String[])new String[0]);
        DgOrderConfigurationPriorityEo queryPriorityEo = new DgOrderConfigurationPriorityEo();
        queryPriorityEo.setConfigurationId(id);
        List dgOrderConfigurationPriorityEos = this.dgOrderConfigurationPriorityDomain.selectList((BaseEo)queryPriorityEo);
        ArrayList priorityDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dgOrderConfigurationPriorityEos)) {
            CubeBeanUtils.copyCollection((Collection)priorityDtoList, (Collection)dgOrderConfigurationPriorityEos, DgOrderConfigurationPriorityDto.class);
        }
        respDto.setPriorityDtoList((List)priorityDtoList);
        return respDto;
    }

    @Override
    public DgOrderConfigurationRespDto queryDetailByShopCode(String shopCode) {
        AssertUtils.notNull((Object)shopCode, (String)"\u5e97\u94faCode\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderConfigurationRespDto respDto = null;
        DgOrderConfigurationEo queryConfigEo = new DgOrderConfigurationEo();
        queryConfigEo.setShopCode(shopCode);
        DgOrderConfigurationEo configurationEo = (DgOrderConfigurationEo)this.dgOrderConfigurationDomain.selectOne((BaseEo)queryConfigEo);
        if (configurationEo != null) {
            respDto = new DgOrderConfigurationRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)configurationEo, (String[])new String[0]);
            DgOrderConfigurationPriorityEo queryPriorityEo = new DgOrderConfigurationPriorityEo();
            queryPriorityEo.setConfigurationId(configurationEo.getId());
            List dgOrderConfigurationPriorityEos = this.dgOrderConfigurationPriorityDomain.selectList((BaseEo)queryPriorityEo);
            ArrayList priorityDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dgOrderConfigurationPriorityEos)) {
                CubeBeanUtils.copyCollection((Collection)priorityDtoList, (Collection)dgOrderConfigurationPriorityEos, DgOrderConfigurationPriorityDto.class);
            }
            respDto.setPriorityDtoList((List)priorityDtoList);
        }
        return respDto;
    }

    @Override
    public DgOrderConfigurationRespDto queryDetailByShopId(Long shopId) {
        AssertUtils.notNull((Object)shopId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderConfigurationRespDto respDto = null;
        DgOrderConfigurationEo queryConfigEo = new DgOrderConfigurationEo();
        queryConfigEo.setShopId(shopId);
        DgOrderConfigurationEo configurationEo = (DgOrderConfigurationEo)this.dgOrderConfigurationDomain.selectOne((BaseEo)queryConfigEo);
        if (configurationEo != null) {
            respDto = new DgOrderConfigurationRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)configurationEo, (String[])new String[0]);
            DgOrderConfigurationPriorityEo queryPriorityEo = new DgOrderConfigurationPriorityEo();
            queryPriorityEo.setConfigurationId(configurationEo.getId());
            List dgOrderConfigurationPriorityEos = this.dgOrderConfigurationPriorityDomain.selectList((BaseEo)queryPriorityEo);
            ArrayList priorityDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dgOrderConfigurationPriorityEos)) {
                CubeBeanUtils.copyCollection((Collection)priorityDtoList, (Collection)dgOrderConfigurationPriorityEos, DgOrderConfigurationPriorityDto.class);
            }
            respDto.setPriorityDtoList((List)priorityDtoList);
        }
        return respDto;
    }

    @Override
    public PageInfo<DgOrderConfigurationDto> queryPage(DgOrderConfigurationPageReqDto dto) {
        PageInfo page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOrderConfigurationDomain.filter().setEntity(BeanUtil.copyProperties((Object)dto, DgOrderConfigurationEo.class, (String[])new String[0]))).in(CollectionUtils.isNotEmpty((Collection)dto.getShopIds()), (Object)"shop_id", (Collection)dto.getShopIds())).in(CollectionUtils.isNotEmpty((Collection)dto.getShopCodes()), (Object)"shop_code", (Collection)dto.getShopCodes())).page(dto.getPageNum(), dto.getPageSize());
        PageInfo pageRespInfo = new PageInfo();
        BeanUtil.copyProperties((Object)page, (Object)pageRespInfo, (String[])new String[]{"list"});
        pageRespInfo.setList(BeanUtil.copyToList((Collection)page.getList(), DgOrderConfigurationDto.class));
        return pageRespInfo;
    }
}

