/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderConfig.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.config.IShopAdjustmentWarehouseConfigDomain;
import com.yunxi.dg.base.center.trade.dto.config.ShopAdjustmentWarehouseConfigReqDto;
import com.yunxi.dg.base.center.trade.dto.config.ShopAdjustmentWarehouseConfigRespDto;
import com.yunxi.dg.base.center.trade.eo.ShopAdjustmentWarehouseConfigEo;
import com.yunxi.dg.base.center.trade.service.orderConfig.IShopAdjustmentWarehouseConfigService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShopAdjustmentWarehouseConfigServiceImpl
implements IShopAdjustmentWarehouseConfigService {
    private static final Logger log = LoggerFactory.getLogger(ShopAdjustmentWarehouseConfigServiceImpl.class);
    @Resource
    private IShopAdjustmentWarehouseConfigDomain ShopAdjustmentWarehouseConfigDomain;

    @Override
    public Long add(ShopAdjustmentWarehouseConfigReqDto reqDto) {
        log.info("\u65b0\u589e\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.checkParams(reqDto);
        List configEoList = ((ExtQueryChainWrapper)this.ShopAdjustmentWarehouseConfigDomain.filter().eq((Object)"shop_code", (Object)reqDto.getShopCode())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)configEoList), (String)"\u8be5\u5e97\u94fa\u5df2\u5b58\u5728\u914d\u7f6e");
        ShopAdjustmentWarehouseConfigEo eo = new ShopAdjustmentWarehouseConfigEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)reqDto, (String[])new String[0]);
        this.ShopAdjustmentWarehouseConfigDomain.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modify(ShopAdjustmentWarehouseConfigReqDto reqDto) {
        log.info("\u4fee\u6539\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)reqDto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParams(reqDto);
        ShopAdjustmentWarehouseConfigEo eo = (ShopAdjustmentWarehouseConfigEo)this.ShopAdjustmentWarehouseConfigDomain.selectByPrimaryKey(reqDto.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)eo), (String)"\u627e\u4e0d\u5230\u7f16\u8f91\u6765\u6e90");
        List configEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.ShopAdjustmentWarehouseConfigDomain.filter().eq((Object)"shop_code", (Object)reqDto.getShopCode())).ne((Object)"id", (Object)reqDto.getId())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)configEoList), (String)("\u8be5\u5e97\u94fa\u5df2\u5b58\u5728\u914d\u7f6e\uff1a" + reqDto.getShopCode()));
        ShopAdjustmentWarehouseConfigEo updateEo = new ShopAdjustmentWarehouseConfigEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)reqDto, (String[])new String[0]);
        updateEo.setWarehouseId(eo.getId());
        this.ShopAdjustmentWarehouseConfigDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void remove(Long id) {
        log.info("\u5220\u9664\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\uff1a{}", (Object)id);
        this.ShopAdjustmentWarehouseConfigDomain.logicDeleteById(id);
    }

    @Override
    public ShopAdjustmentWarehouseConfigRespDto queryByOne(ShopAdjustmentWarehouseConfigReqDto reqDto) {
        log.info("\u67e5\u8be2\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.isFalse((ObjectUtil.isEmpty((Object)reqDto.getId()) && StringUtils.isBlank((CharSequence)reqDto.getShopCode()) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        ShopAdjustmentWarehouseConfigEo one = (ShopAdjustmentWarehouseConfigEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.ShopAdjustmentWarehouseConfigDomain.filter().eq(ObjectUtil.isNotEmpty((Object)reqDto.getId()), (Object)"id", (Object)reqDto.getId())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getShopCode()), (Object)"shop_code", (Object)reqDto.getShopCode())).one();
        if (ObjectUtil.isNotEmpty((Object)one)) {
            ShopAdjustmentWarehouseConfigRespDto respDto = new ShopAdjustmentWarehouseConfigRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)one, (String[])new String[0]);
            return respDto;
        }
        return null;
    }

    @Override
    public PageInfo<ShopAdjustmentWarehouseConfigRespDto> queryByPage(ShopAdjustmentWarehouseConfigReqDto reqDto) {
        log.info("\u5e97\u94fa\u8c03\u8d26\u4ed3\u914d\u7f6e\u5206\u9875\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.ShopAdjustmentWarehouseConfigDomain.filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getShopCode()), (Object)"shop_code", (Object)reqDto.getShopCode())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseCode()), (Object)"warehouse_code", (Object)reqDto.getWarehouseCode())).orderByDesc((Object)"update_time")).page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), ShopAdjustmentWarehouseConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void checkParams(ShopAdjustmentWarehouseConfigReqDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getShopId()), (String)"shopId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getShopCode()), (String)"shopCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getShopName()), (String)"shopName\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getWarehouseId()), (String)"warehouseId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getWarehouseCode()), (String)"warehouseCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getWarehouseName()), (String)"warehouseName\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

