/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.data.api.IDictQueryApi;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.PickRuleDataEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyPoolReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.enums.NextOptTypeEnum;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPickRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgStrategyPickRuleServiceImpl
implements IDgStrategyPickRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgStrategyPickRuleServiceImpl.class);
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgStrategyPoolService strategyPoolService;

    @Override
    public void autoStrategyPick(List<DgStrategyPoolRespDto> strategyPoolRespDtoList) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApi.queryByGroupCodeAndCode(PickRuleDataEnum.AUTO_DISTRIBUTION.getGroupCode(), PickRuleDataEnum.AUTO_DISTRIBUTION.getCode()));
        if (StringUtils.isBlank((CharSequence)dictDto.getValue())) {
            LOGGER.info("[\u81ea\u52a8\u914d\u8d27\u4ed3\u5e93]\u6ca1\u6709\u914d\u7f6e\u81ea\u52a8\u914d\u8d27\u7b56\u7565");
            return;
        }
        Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
        LOGGER.info("[\u81ea\u52a8\u914d\u8d27\u4ed3\u5e93]\u914d\u7f6e\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)map));
        Map orderAutoMap = (Map)map.get("orderAuto");
        String enabled = MapUtils.getString((Map)orderAutoMap, (Object)"enabled");
        if (StringUtils.equals((CharSequence)enabled, (CharSequence)"0")) {
            LOGGER.info("[\u81ea\u52a8\u914d\u8d27\u4ed3\u5e93]\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5c1a\u672a\u5f00\u542f");
            return;
        }
        Integer delayTime = MapUtils.getInteger((Map)orderAutoMap, (Object)"delayTime", (Integer)0);
        for (DgStrategyPoolRespDto strategyPoolRespDto : strategyPoolRespDtoList) {
            DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(strategyPoolRespDto.getSaleOrderId());
            Date pickedTime = this.getPickedTime((DgPerformOrderInfoDto)saleOrderRespDto);
            if (pickedTime == null) continue;
            MessageVo messageVo = new MessageVo();
            SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
            saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
            saleTradeMessageVo.setStrategyOrderId(Long.valueOf(-1L));
            saleTradeMessageVo.setNextOptType(NextOptTypeEnum.PICK_AUTO_AUDIT.getType());
            messageVo.setData((Object)saleTradeMessageVo);
            Date planExeTime = DateUtil.addMinutes((Date)pickedTime, (int)delayTime);
            long delayTimeSeconds = planExeTime.getTime() / 1000L - new Date().getTime() / 1000L;
            if (delayTimeSeconds > 0L) continue;
            long delaySeconds = Math.max(delayTimeSeconds, 0L);
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{saleOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageVo), delaySeconds});
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "DELAY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(delaySeconds));
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)messageResponse));
            DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
            strategyPoolReqDto.setId(strategyPoolRespDto.getId());
            strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
            this.strategyPoolService.modifyStrategyPool(strategyPoolReqDto);
        }
    }

    private Date getPickedTime(DgPerformOrderInfoDto saleOrderRespDto) {
        String orderSteps = saleOrderRespDto.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<DgOrderStatusLogRespDto>> orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgOrderStatusLogRespDto::getOrderStatus));
            List<DgOrderStatusLogRespDto> orderStatusLogRespList = orderStatusHistoryListMap.get(DgOmsSaleOrderStatus.PICKED.getCode());
            if (CollectionUtils.isNotEmpty(orderStatusLogRespList)) {
                return orderStatusLogRespList.get(0).getOptDate();
            }
            return null;
        }
        return null;
    }
}

