/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.StrategyEnableEnum;
import com.yunxi.dg.base.center.trade.constants.TradeStatusFlowSelector;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeRangeEnum;
import com.yunxi.dg.base.center.trade.dao.vo.DgStrategyRuleVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyConfItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyConfItemSuitDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyRuleSuitDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOptLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgStrategyPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBizStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.enums.SaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.observer.EventStrategyListener;
import com.yunxi.dg.base.center.trade.service.sys.IDgPerformOrderOptLogService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.StrategyHelper;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgStrategyRuleServiceImpl")
public class DgStrategyRuleServiceImpl
implements IDgStrategyRuleService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DgStrategyRuleServiceImpl.class);
    protected static final ThreadLocal<DgStrategyOrderReqDto> CACHE_HIT_ITEM = new ThreadLocal();
    protected static final String ALL = DgStrategyRuleSuitTypeRangeEnum.ALL.getCode();
    protected static final String CLOSE = DgStrategyRuleSuitTypeRangeEnum.CLOSE.getCode();
    protected static final String SELECT = DgStrategyRuleSuitTypeRangeEnum.SELECT.getCode();
    protected static final String RANG = DgStrategyRuleSuitTypeRangeEnum.RANG.getCode();
    protected static final String NEED_PERSON_AUDIT_BY_REMARK = "0";
    protected static final Integer HANDLE_TASK_BY_MQ_DELAY_THRESHOLD = 120;
    private static final List<String> CUSTOMER_RANG_TYPE = Lists.newArrayList((Object[])new String[]{DgStrategyRuleSuitTypeEnum.SUITTYPE_BUSINESS_AREA.getCode(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_TYPE.getCode(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GRADE.getCode(), DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GROUP.getCode()});
    private static final List<String> OMS_STRATEGY_TYPE = Lists.newArrayList((Object[])new String[]{DgCisStrategyOrderTypeEnum.CUSTOMER.getCode(), DgCisStrategyOrderTypeEnum.BUSINESS.getCode(), DgCisStrategyOrderTypeEnum.PICK.getCode(), DgCisStrategyOrderTypeEnum.PICKED.getCode(), DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY.getCode()});
    @Resource
    protected IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    protected IDgStrategyConfItemDomain dgStrategyConfItemDomain;
    @Resource
    protected IDgStrategyConfItemSuitDomain dgStrategyConfItemSuitDomain;
    @Resource
    protected IDgStrategyRuleSuitDomain dgStrategyRuleSuitDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    protected IDgPerformOrderAddrExtDomain dgPerformOrderAddrExtDomain;
    @Resource
    protected ICommonOrderQueryService commonOrderQueryService;
    @Resource
    protected IDgStrategyOrderService strategyOrderService;
    @Resource
    protected IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    protected ICommonsMqService commonsMqService;
    @Resource
    protected IDgPerformOrderOptLogService saleOrderOptLogService;
    @Resource
    protected EventStrategyListener eventStrategyListener;
    @Resource
    protected IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    protected IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    protected IDgStrategyConfItemDomain strategyConfItemDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyRule(Long id) {
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.dgStrategyRuleDomain.selectByPrimaryKey(id);
        Integer ruleStatus = dgStrategyRuleEo.getRuleStatus();
        if (ruleStatus.equals(1)) {
            throw new BizException("\u8be5\u89c4\u5219\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664: " + dgStrategyRuleEo.getRuleName());
        }
        this.dgStrategyRuleDomain.logicDeleteById(id);
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(id);
        this.dgStrategyRuleSuitDomain.logicDeleteByExample(dgStrategyRuleSuitEo);
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(id);
        this.dgStrategyConfItemDomain.logicDeleteByExample(strategyConfItemEo);
        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
        confItemSuitEo.setRuleId(id);
        this.dgStrategyConfItemSuitDomain.logicDeleteByExample(confItemSuitEo);
        if (dgStrategyRuleEo.getStrategyType().equals(DgCisStrategyOrderTypeEnum.LABEL.getCode())) {
            try {
                this.eventStrategyListener.handle();
            }
            catch (Exception e) {
                LOGGER.info("\u66f4\u65b0\u81ea\u52a8\u6807\u7b7e\u6d4b\u8bd5\u7f13\u5b58\u5931\u8d25");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void modifyRuleStatus(Long id, Integer ruleStatus) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.dgStrategyRuleDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgStrategyRuleEo updateEo = new DgStrategyRuleEo();
        updateEo.setId(id);
        updateEo.setRuleStatus(ruleStatus);
        this.dgStrategyRuleDomain.updateSelective((BaseEo)updateEo);
        if (dgStrategyRuleEo.getStrategyType().equals(DgCisStrategyOrderTypeEnum.LABEL.getCode())) {
            try {
                this.eventStrategyListener.handle();
            }
            catch (Exception e) {
                LOGGER.info("\u66f4\u65b0\u81ea\u52a8\u6807\u7b7e\u6d4b\u8bd5\u7f13\u5b58\u5931\u8d25");
                e.printStackTrace();
            }
        }
    }

    @Override
    public PageInfo<DgStrategyRuleRespDto> queryByPage(DgBizStrategyRuleReqDto strategyRuleReqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (strategyRuleReqDto.getRuleStatus() != null) {
            queryWrapper.eq(DgStrategyRuleEo::getRuleStatus, (Object)strategyRuleReqDto.getRuleStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getStrategyType())) {
            queryWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)strategyRuleReqDto.getStrategyType());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getCreateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateStartTime())).le(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getUpdateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateStartTime())).le(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPeriodicStartTime())) {
            queryWrapper.ge(DgStrategyRuleEo::getPeriodicStart, (Object)strategyRuleReqDto.getPeriodicStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPeriodicEndTime())) {
            queryWrapper.le(DgStrategyRuleEo::getPeriodicEnd, (Object)strategyRuleReqDto.getPeriodicEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPlatForm())) {
            queryWrapper.eq(DgStrategyRuleEo::getPlatForm, (Object)strategyRuleReqDto.getPlatForm());
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyRuleReqDto.getLabelNameList())) {
            queryWrapper.in(DgStrategyRuleEo::getLabelName, (Collection)strategyRuleReqDto.getLabelNameList());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleName()) || StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleCode())) {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(DgStrategyRuleEo::getRuleName, (Object)("%" + strategyRuleReqDto.getRuleName() + "%"))).or(wp -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wp.like(DgStrategyRuleEo::getRuleCode, (Object)("%" + strategyRuleReqDto.getRuleCode() + "%"));
                });
            });
        }
        queryWrapper.orderByDesc(BaseEo::getUpdateTime);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleEos)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(dgStrategyRuleEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)info, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, DgStrategyRuleRespDto.class);
        for (DgStrategyRuleRespDto dgStrategyRuleRespDto : dtoList) {
            String effectiveDesc = "";
            if (dgStrategyRuleRespDto.getPeriodicStart() != null && dgStrategyRuleRespDto.getPeriodicEnd() != null) {
                Long time = new Date().getTime();
                effectiveDesc = dgStrategyRuleRespDto.getPeriodicStart().getTime() < time ? (dgStrategyRuleRespDto.getPeriodicEnd().getTime() > time ? "\u5df2\u751f\u6548" : "\u5df2\u5931\u6548") : "\u672a\u751f\u6548";
            }
            dgStrategyRuleRespDto.setEffectiveDesc(effectiveDesc);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgStrategyRuleVo> findAllStrategy(DgStrategyRuleReqDto dgStrategyRuleReqDto) {
        List longList = dgStrategyRuleReqDto.getLongList();
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.selectByIds(longList);
        String bizModel = dgStrategyRuleReqDto.getBizModel().equals(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode()) ? "2c" : "2b";
        List ids = dgStrategyRuleEos.stream().filter(e -> e.getRuleStatus().equals(1) && e.getPlatForm().equals(bizModel)).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper strategyConfItemEoQueryWrapper = new QueryWrapper();
            strategyConfItemEoQueryWrapper.in((Object)"rule_id", ids);
            strategyConfItemEoQueryWrapper.eq((Object)"dr", (Object)0);
            List strategyConfItemEos = this.dgStrategyConfItemDomain.getMapper().selectList((Wrapper)strategyConfItemEoQueryWrapper);
            Map<Long, List<StrategyConfItemEo>> StrategyConfItemEoMap = strategyConfItemEos.stream().collect(Collectors.groupingBy(StrategyConfItemEo::getRuleId));
            QueryWrapper strategyConfItemSuitEoQueryWrapper = new QueryWrapper();
            strategyConfItemSuitEoQueryWrapper.in((Object)"rule_id", ids);
            strategyConfItemSuitEoQueryWrapper.eq((Object)"dr", (Object)0);
            List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.getMapper().selectList((Wrapper)strategyConfItemSuitEoQueryWrapper);
            Map<Long, List<StrategyConfItemSuitEo>> StrategyConfItemSuitEoMap = strategyConfItemSuitEos.stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getRuleId));
            QueryWrapper dgStrategyRuleSuitEoQueryWrapper = new QueryWrapper();
            dgStrategyRuleSuitEoQueryWrapper.in((Object)"rule_id", ids);
            dgStrategyRuleSuitEoQueryWrapper.eq((Object)"dr", (Object)0);
            List dgStrategyRuleSuitEos = this.dgStrategyRuleSuitDomain.getMapper().selectList((Wrapper)dgStrategyRuleSuitEoQueryWrapper);
            Map<Long, List<DgStrategyRuleSuitEo>> dgStrategyRuleSuitEosMap = dgStrategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getRuleId));
            ArrayList<DgStrategyRuleVo> dgStrategyRuleVos = new ArrayList<DgStrategyRuleVo>();
            CubeBeanUtils.copyCollection(dgStrategyRuleVos, (Collection)dgStrategyRuleEos, DgStrategyRuleVo.class);
            for (DgStrategyRuleVo dgStrategyRuleVo : dgStrategyRuleVos) {
                List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEos1;
                List<StrategyConfItemSuitEo> strategyConfItemSuitEos1;
                List<StrategyConfItemEo> strategyConfItemEos1 = StrategyConfItemEoMap.get(dgStrategyRuleVo.getId());
                if (CollectionUtils.isNotEmpty(strategyConfItemEos1)) {
                    ArrayList dgStrategyConfItemDtos = new ArrayList();
                    CubeBeanUtils.copyCollection(dgStrategyConfItemDtos, strategyConfItemEos1, DgStrategyConfItemDto.class);
                    dgStrategyRuleVo.setDgStrategyConfItemDtos(dgStrategyConfItemDtos);
                }
                if (CollectionUtils.isNotEmpty(strategyConfItemSuitEos1 = StrategyConfItemSuitEoMap.get(dgStrategyRuleVo.getId()))) {
                    ArrayList dgStrategyConfItemSuitDtos = new ArrayList();
                    CubeBeanUtils.copyCollection(dgStrategyConfItemSuitDtos, strategyConfItemSuitEos1, DgStrategyConfItemSuitDto.class);
                    dgStrategyRuleVo.setDgStrategyConfItemSuitDtos(dgStrategyConfItemSuitDtos);
                }
                if (!CollectionUtils.isNotEmpty(dgStrategyRuleSuitEos1 = dgStrategyRuleSuitEosMap.get(dgStrategyRuleVo.getId()))) continue;
                ArrayList dgStrategyRuleSuitDtos = new ArrayList();
                CubeBeanUtils.copyCollection(dgStrategyRuleSuitDtos, dgStrategyRuleSuitEos1, DgStrategyRuleSuitDto.class);
                dgStrategyRuleVo.setDgStrategyRuleSuitDtos(dgStrategyRuleSuitDtos);
            }
            return dgStrategyRuleVos;
        }
        return new ArrayList<DgStrategyRuleVo>();
    }

    @Override
    public Boolean giftItemSplitOrder() {
        List ruleEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgStrategyRuleDomain.filter().eq((Object)"strategy_type", (Object)DgCisStrategyOrderTypeEnum.AUTOMATIC_ORDER_SPLIT)).eq((Object)"rule_status", (Object)YesNoEnum.YES.getValue())).list();
        if (CollectionUtils.isEmpty((Collection)ruleEos)) {
            return false;
        }
        List ruleIds = ruleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List confItemEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgStrategyConfItemDomain.filter().eq((Object)"enable", (Object)YesOrNoEnum.YES.getType())).in((Object)"rule_id", ruleIds)).list();
        return CollectionUtils.isNotEmpty((Collection)confItemEos);
    }

    protected DgStrategyRuleEo queryValidRule(DgPerformOrderRespDto saleOrderRespDto, String strategyType) {
        List<DgStrategyRuleEo> dgStrategyRuleEoList = this.matchStrategyRule(saleOrderRespDto, strategyType);
        if (CollectionUtils.isEmpty(dgStrategyRuleEoList)) {
            return null;
        }
        if (dgStrategyRuleEoList.get(0).getPriority() != null) {
            dgStrategyRuleEoList.sort(Comparator.comparing(DgStrategyRuleEo::getPriority).thenComparing(BaseEo::getUpdateTime, Comparator.reverseOrder()));
        }
        DgStrategyRuleEo dgStrategyRuleEo = dgStrategyRuleEoList.get(0);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7: {},\u5339\u914d\u5230\u7684\u7b56\u7565\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)dgStrategyRuleEo));
        if (StringUtils.isEmpty((CharSequence)saleOrderRespDto.getSaleOrderNo())) {
            return dgStrategyRuleEo;
        }
        DgStrategyOrderReqDto strategyOrderReqDto = this.getHitStrategyOrder();
        strategyOrderReqDto.setRuleId(dgStrategyRuleEo.getId());
        strategyOrderReqDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
        strategyOrderReqDto.setSaleOrderId(saleOrderRespDto.getId());
        strategyOrderReqDto.setPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        strategyOrderReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        strategyOrderReqDto.setType(strategyType);
        strategyOrderReqDto.setHitTime(new Date());
        Long id = this.strategyOrderService.addStrategyOrder(strategyOrderReqDto);
        strategyOrderReqDto.setId(id);
        this.setHitStrategyOrder(strategyOrderReqDto);
        return dgStrategyRuleEo;
    }

    protected Date matchStrategyDelayTime(DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum strategyType) {
        Date optDate = null;
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = this.commonOrderQueryService.queryOrderStatus(saleOrderRespDto.getId(), DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(saleOrderRespDto.getBizModel()) ? TradeStatusFlowSelector.B2C.getCode() : TradeStatusFlowSelector.B2B.getCode());
        switch (strategyType) {
            case BUSINESS: {
                optDate = this.getOptDate(orderStatusLogRespDtos, DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT);
                break;
            }
            case ORDER_CONFIRM: {
                optDate = this.getOptDate(orderStatusLogRespDtos, DgOmsSaleOrderStatus.WAIT_CHECK);
                break;
            }
            case CONFIRM_RECEIPT_STRATEGY: 
            case CONFIRM_RECEIPT_POLICY: {
                optDate = this.getOptDate(orderStatusLogRespDtos, DgOmsSaleOrderStatus.DELIVERED);
                break;
            }
            case PICKED: {
                optDate = this.getOptDate(orderStatusLogRespDtos, DgOmsSaleOrderStatus.PICKED);
                break;
            }
            case AUTOMATIC_ALLOCATION: {
                Date expectedDeliveryTime = saleOrderRespDto.getDeliveryTime();
                if (!Objects.nonNull(expectedDeliveryTime)) break;
                optDate = expectedDeliveryTime;
            }
        }
        if (Objects.isNull(optDate)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u672a\u83b7\u53d6\u5230\u7279\u5b9a\u7684\u64cd\u4f5c\u65f6\u95f4:{}", (Object)strategyType.getCode());
            return saleOrderRespDto.getSaleCreateTime();
        }
        return optDate;
    }

    private Date getOptDate(List<DgOrderStatusLogRespDto> orderStatusLogRespDtos, DgOmsSaleOrderStatus omsSaleOrderStatus) {
        DgOrderStatusLogRespDto statusLogRespDto = orderStatusLogRespDtos.stream().filter(e -> StringUtils.equals((CharSequence)omsSaleOrderStatus.getCode(), (CharSequence)e.getOrderStatusCode())).max(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate)).orElse(null);
        if (Objects.nonNull(statusLogRespDto) && Objects.nonNull(statusLogRespDto.getOptDate())) {
            return statusLogRespDto.getOptDate();
        }
        return null;
    }

    protected List<DgStrategyRuleEo> matchStrategyRule(DgPerformOrderRespDto saleOrderRespDto, String strategyType) {
        return this.matchStrategyRule(saleOrderRespDto, DgCisStrategyOrderTypeEnum.forCode((String)strategyType));
    }

    protected List<DgStrategyRuleEo> matchStrategyRule(DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum strategyType) {
        List dgStrategyRuleEoList;
        LOGGER.info("\u7b56\u7565\u679a\u4e3e\uff1a{}", (Object)strategyType.getCode());
        ArrayList<String> periodStrategy = new ArrayList<String>();
        periodStrategy.add(DgCisStrategyOrderTypeEnum.ORDER_REVIEW.getCode());
        periodStrategy.add(DgCisStrategyOrderTypeEnum.ORDER_CONFIRM.getCode());
        periodStrategy.add(DgCisStrategyOrderTypeEnum.AUTOMATIC_ALLOCATION.getCode());
        periodStrategy.add(DgCisStrategyOrderTypeEnum.AUTOMATIC_DELIVERY.getCode());
        periodStrategy.add(DgCisStrategyOrderTypeEnum.SALES.getCode());
        periodStrategy.add(DgCisStrategyOrderTypeEnum.PRODUCTION.getCode());
        LambdaQueryWrapper queryStrategyWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryStrategyWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleEo::getStrategyType, (Object)strategyType.getCode())).eq(DgStrategyRuleEo::getRuleStatus, (Object)StrategyEnableEnum.ENABLE.getType());
        if (periodStrategy.contains(strategyType.getCode())) {
            queryStrategyWrapper.and(wrapper -> wrapper.le(DgStrategyRuleEo::getPeriodicStart, (Object)new Date()));
            queryStrategyWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DgStrategyRuleEo::getPeriodicStatus, (Object)YesNoEnum.YES.getValue())).or()).ge(DgStrategyRuleEo::getPeriodicEnd, (Object)new Date()));
        }
        if (CollectionUtils.isEmpty((Collection)(dgStrategyRuleEoList = this.dgStrategyRuleDomain.list(queryStrategyWrapper)))) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            return Collections.emptyList();
        }
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u5339\u914d\u5230\u7684\u7b56\u7565\uff1a{}", dgStrategyRuleEoList.stream().map(BaseEo::getId).collect(Collectors.toList()));
        Map strategyRuleEoMap = dgStrategyRuleEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (a, b) -> a));
        List ruleIds = dgStrategyRuleEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryRuleSuitWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryRuleSuitWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getStrategyType, (Object)strategyType.getCode())).in(DgStrategyRuleSuitEo::getRuleId, ruleIds);
        List dgStrategyRuleSuitEos = this.dgStrategyRuleSuitDomain.list(queryRuleSuitWrapper);
        ArrayList<DgStrategyRuleEo> strategyRuleEos = new ArrayList<DgStrategyRuleEo>();
        if (CollectionUtil.isNotEmpty((Collection)dgStrategyRuleSuitEos)) {
            Map<Long, List<DgStrategyRuleSuitEo>> allocationGroupList = dgStrategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getRuleId));
            block15: for (Map.Entry<Long, List<DgStrategyRuleSuitEo>> entry : allocationGroupList.entrySet()) {
                LOGGER.info("\u5f53\u524d\u7b56\u7565\uff1a{}", (Object)entry.getKey());
                Boolean orderTypeCheckResult = Boolean.TRUE;
                Boolean customerCheckResult = Boolean.TRUE;
                Boolean shopCheckResult = Boolean.TRUE;
                Boolean enterpriseCheckResult = Boolean.TRUE;
                Boolean channelCheckResult = Boolean.TRUE;
                switch ((DgCisStrategyOrderTypeEnum)DgCisStrategyOrderTypeEnum.CODE_LOOKUP.get(strategyType.getCode())) {
                    case CUSTOMER: {
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        if (!shopCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case BUSINESS: {
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        if (!shopCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case PICK: {
                        continue block15;
                    }
                    case PICKED: {
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case CONFIRM_RECEIPT_POLICY: {
                        channelCheckResult = this.strategyRuleSuitCheckChannel(saleOrderRespDto, entry.getKey());
                        if (!channelCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case ORDER_CONFIRM: {
                        continue block15;
                    }
                    case ORDER_REVIEW: {
                        continue block15;
                    }
                    case AUTOMATIC_ALLOCATION: {
                        orderTypeCheckResult = this.strategyRuleSuitCheckOrderType(saleOrderRespDto, entry.getValue());
                        customerCheckResult = this.strategyRuleSuitCheckCustomerB2B(saleOrderRespDto, entry.getValue());
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        enterpriseCheckResult = this.strategyRuleSuitCheckEnterprise(saleOrderRespDto, entry.getValue());
                        if (!orderTypeCheckResult.booleanValue() || !customerCheckResult.booleanValue() || !shopCheckResult.booleanValue() || !enterpriseCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case AUTOMATIC_DELIVERY: {
                        orderTypeCheckResult = this.strategyRuleSuitCheckOrderType(saleOrderRespDto, entry.getValue());
                        customerCheckResult = this.strategyRuleSuitCheckCustomerB2B(saleOrderRespDto, entry.getValue());
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        enterpriseCheckResult = this.strategyRuleSuitCheckEnterprise(saleOrderRespDto, entry.getValue());
                        if (!orderTypeCheckResult.booleanValue() || !customerCheckResult.booleanValue() || !shopCheckResult.booleanValue() || !enterpriseCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case CONFIRM_RECEIPT_STRATEGY: {
                        channelCheckResult = this.strategyRuleSuitCheckChannel(saleOrderRespDto, entry.getKey());
                        if (!channelCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case FEE_SCALE_CONTROL: {
                        orderTypeCheckResult = this.strategyRuleSuitCheckOrderType(saleOrderRespDto, entry.getValue());
                        customerCheckResult = this.strategyRuleSuitCheckCustomerF2B(saleOrderRespDto, entry.getValue());
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        if (!orderTypeCheckResult.booleanValue() || !customerCheckResult.booleanValue() || !shopCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case SALES: {
                        orderTypeCheckResult = this.strategyRuleSuitCheckOrderType(saleOrderRespDto, entry.getValue());
                        customerCheckResult = this.strategyRuleSuitCheckCustomerF2B(saleOrderRespDto, entry.getValue());
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        enterpriseCheckResult = this.strategyRuleSuitCheckEnterprise(saleOrderRespDto, entry.getValue());
                        if (!orderTypeCheckResult.booleanValue() || !customerCheckResult.booleanValue() || !shopCheckResult.booleanValue() || !enterpriseCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                    case PRODUCTION: {
                        orderTypeCheckResult = this.strategyRuleSuitCheckOrderType(saleOrderRespDto, entry.getValue());
                        customerCheckResult = this.strategyRuleSuitCheckCustomerF2B(saleOrderRespDto, entry.getValue());
                        shopCheckResult = this.strategyRuleSuitCheckShop(saleOrderRespDto, entry.getValue());
                        enterpriseCheckResult = this.strategyRuleSuitCheckEnterprise(saleOrderRespDto, entry.getValue());
                        if (!orderTypeCheckResult.booleanValue() || !customerCheckResult.booleanValue() || !shopCheckResult.booleanValue() || !enterpriseCheckResult.booleanValue()) continue block15;
                        strategyRuleEos.add((DgStrategyRuleEo)strategyRuleEoMap.get(entry.getKey()));
                        continue block15;
                    }
                }
                throw new BizException("\u8be5\u9002\u7528\u7c7b\u578b\u672a\u914d\u7f6e\u67e5\u8be2\u6761\u4ef6");
            }
        }
        return strategyRuleEos;
    }

    private Boolean strategyRuleSuitCheckOrderType(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> list) {
        String orderType = saleOrderRespDto.getOrderType();
        Boolean result = Boolean.TRUE;
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = list.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<Object> hisOrderType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        if (CollectionUtil.isNotEmpty(hisOrderType)) {
            if (CollectionUtil.isEmpty(hisOrderType = hisOrderType.stream().filter(e -> e.getSuitSelectType().equals(ALL) || e.getSuitKey().equals(orderType)).collect(Collectors.toList()))) {
                result = Boolean.FALSE;
                LOGGER.info("\u7b56\u7565\u8ba2\u5355\u7c7b\u578b\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u8ba2\u5355\u7c7b\u578b\uff1a{}", (Object)orderType);
            }
        } else {
            result = Boolean.FALSE;
            LOGGER.error("\u7b56\u7565\u8ba2\u5355\u7c7b\u578b\u672a\u8bbe\u7f6e");
        }
        return result;
    }

    private Boolean strategyRuleSuitCheckCustomerF2B(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> list) {
        String customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        Boolean result = Boolean.TRUE;
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = list.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<Object> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        if (CollectionUtil.isNotEmpty(hisCustomer)) {
            DgStrategyRuleSuitEo ruleSuitEo = hisCustomer.get(0);
            if (ruleSuitEo.getSuitSelectType().equals(SELECT)) {
                if (CollectionUtil.isEmpty(hisCustomer = hisCustomer.stream().filter(e -> e.getSuitKey().equals(customerCode)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u6307\u5b9a\u5ba2\u6237\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u5ba2\u6237\uff1a{}", (Object)customerCode);
                }
            } else if (ruleSuitEo.getSuitSelectType().equals(RANG)) {
                DgStrategyPerformOrderRespDto dgStrategyPerformOrderRespDto = (DgStrategyPerformOrderRespDto)saleOrderRespDto;
                DgCustomerRespDto dgCustomerRespDto = Optional.ofNullable(dgStrategyPerformOrderRespDto.getDgCustomerRespDto()).orElse(new DgCustomerRespDto());
                List csOrgCustomerRelationDtos = dgStrategyPerformOrderRespDto.getCsOrgCustomerRelationDtos();
                CsOrgCustomerRelationDto csOrgCustomerRelationDto = Optional.ofNullable(csOrgCustomerRelationDtos).orElse(Lists.newArrayList()).stream().findFirst().orElse(new CsOrgCustomerRelationDto());
                String customerTypeId = Optional.ofNullable(csOrgCustomerRelationDto.getCustomerTypeId()).map(String::valueOf).orElse(null);
                String areaId = Optional.ofNullable(csOrgCustomerRelationDto.getAreaId()).map(String::valueOf).orElse(null);
                String levelId = Optional.ofNullable(csOrgCustomerRelationDto.getLevelId()).map(String::valueOf).orElse(null);
                String groupId = Optional.ofNullable(dgCustomerRespDto.getCustomerGroupId()).map(String::valueOf).orElse(null);
                if (StringUtils.isBlank((CharSequence)customerCode)) {
                    LOGGER.info("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                if (StringUtils.isBlank((CharSequence)customerTypeId)) {
                    LOGGER.info("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                if (StringUtils.isBlank((CharSequence)areaId)) {
                    LOGGER.info("\u5ba2\u6237\u533a\u57df\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                if (StringUtils.isBlank((CharSequence)levelId)) {
                    LOGGER.info("\u5ba2\u6237\u7b49\u7ea7\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                if (StringUtils.isBlank((CharSequence)groupId)) {
                    LOGGER.info("\u5ba2\u6237\u5206\u7ec4\u4e3a\u7a7a");
                    return Boolean.FALSE;
                }
                List<Object> hisClientType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_TYPE.getCode());
                if (CollectionUtil.isEmpty(hisClientType = hisClientType.stream().filter(e -> e.getSuitSelectType().equals(CLOSE) || e.getSuitKey().equals(customerTypeId)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u5ba2\u6237\u7c7b\u578b\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u5ba2\u6237\u7c7b\u578b\uff1a{}", (Object)customerTypeId);
                }
                List<Object> hisBusinessArea = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_BUSINESS_AREA.getCode());
                if (CollectionUtil.isEmpty(hisBusinessArea = hisBusinessArea.stream().filter(e -> e.getSuitSelectType().equals(CLOSE) || e.getSuitKey().equals(areaId)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u4e1a\u52a1\u533a\u57df\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u4e1a\u52a1\u533a\u57df\uff1a{}", (Object)areaId);
                }
                List<Object> hisClientGrade = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GRADE.getCode());
                if (CollectionUtil.isEmpty(hisClientGrade = hisClientGrade.stream().filter(e -> e.getSuitSelectType().equals(CLOSE) || e.getSuitKey().equals(levelId)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u5ba2\u6237\u7b49\u7ea7\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u5ba2\u6237\u7b49\u7ea7\uff1a{}", (Object)levelId);
                }
                List<Object> hisClientGroup = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_GROUP.getCode());
                if (CollectionUtil.isEmpty(hisClientGroup = hisClientGroup.stream().filter(e -> e.getSuitSelectType().equals(CLOSE) || e.getSuitKey().equals(groupId)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u5ba2\u6237\u5206\u7ec4\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u5ba2\u6237\u5206\u7ec4\uff1a{}", (Object)groupId);
                }
                List<Object> hisClientBlack = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_BLACK.getCode());
                if (CollectionUtil.isNotEmpty(hisClientBlack = hisClientBlack.stream().filter(e -> e.getSuitKey().equals(customerCode)).collect(Collectors.toList()))) {
                    result = Boolean.FALSE;
                    LOGGER.info("\u7b56\u7565\u5ba2\u6237\u9ed1\u540d\u5355\u547d\u4e2d\uff0c\u5f53\u524d\u5ba2\u6237\uff1a{}", (Object)customerCode);
                }
            }
        } else {
            result = Boolean.FALSE;
            LOGGER.error("\u7b56\u7565\u5ba2\u6237\u8303\u56f4\u672a\u8bbe\u7f6e");
        }
        return result;
    }

    private Boolean strategyRuleSuitCheckCustomerB2B(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> list) {
        String customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
        Boolean result = Boolean.TRUE;
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = list.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<Object> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        if (CollectionUtil.isNotEmpty(hisCustomer)) {
            if (CollectionUtil.isEmpty(hisCustomer = hisCustomer.stream().filter(e -> e.getSuitSelectType().equals(CLOSE) || e.getSuitKey().equals(customerCode)).collect(Collectors.toList()))) {
                result = Boolean.FALSE;
                LOGGER.info("\u7b56\u7565\u8ba2\u5355\u7c7b\u578b\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u8ba2\u5355\u7c7b\u578b\uff1a{}", (Object)customerCode);
            }
        } else {
            result = Boolean.FALSE;
            LOGGER.error("\u7b56\u7565\u5ba2\u6237\u8303\u56f4\u672a\u8bbe\u7f6e");
        }
        return result;
    }

    private Boolean strategyRuleSuitCheckShop(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> list) {
        String shopCode = saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode();
        Boolean result = Boolean.TRUE;
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = list.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<Object> hisShop = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        if (CollectionUtil.isNotEmpty(hisShop)) {
            if (CollectionUtil.isEmpty(hisShop = hisShop.stream().filter(e -> e.getSuitSelectType().equals(ALL) || e.getSuitKey().equals(shopCode)).collect(Collectors.toList()))) {
                result = Boolean.FALSE;
                LOGGER.info("\u7b56\u7565\u6307\u5b9a\u5e97\u94fa\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u5e97\u94fa\uff1a{}", (Object)shopCode);
            }
        } else {
            result = Boolean.FALSE;
            LOGGER.error("\u7b56\u7565\u6307\u5b9a\u5e97\u94fa\u672a\u8bbe\u7f6e");
        }
        return result;
    }

    private Boolean strategyRuleSuitCheckEnterprise(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> list) {
        String enterpriseCode = saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode();
        Boolean result = Boolean.TRUE;
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = list.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<Object> hisCompany = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_COMPANY.getCode());
        if (CollectionUtil.isNotEmpty(hisCompany)) {
            if (CollectionUtil.isEmpty(hisCompany = hisCompany.stream().filter(e -> e.getSuitSelectType().equals(ALL) || e.getSuitKey().equals(enterpriseCode)).collect(Collectors.toList()))) {
                result = Boolean.FALSE;
                LOGGER.info("\u7b56\u7565\u6307\u5b9a\u9500\u552e\u516c\u53f8\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u9500\u552e\u516c\u53f8\uff1a{}", (Object)enterpriseCode);
            }
        } else {
            result = Boolean.FALSE;
            LOGGER.error("\u7b56\u7565\u9500\u552e\u516c\u53f8\u672a\u8bbe\u7f6e");
        }
        return result;
    }

    private Boolean strategyRuleSuitCheckChannel(DgPerformOrderRespDto saleOrderRespDto, Long ruleId) {
        Boolean result = Boolean.TRUE;
        if (null != ruleId && StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getSaleChannel())) {
            LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getStrategyType, (Object)DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())).eq(StrategyConfItemEo::getRuleId, (Object)ruleId);
            List strategyConfItemEoList = this.strategyConfItemDomain.list(queryStrategyConfItemEo);
            if (CollectionUtil.isNotEmpty((Collection)strategyConfItemEoList)) {
                if (CollectionUtil.isEmpty(strategyConfItemEoList = strategyConfItemEoList.stream().filter(e -> e.getContent().contains(saleOrderRespDto.getSaleChannel())).collect(Collectors.toList()))) {
                    LOGGER.info("\u7b56\u7565\u6307\u5b9a\u8ba2\u5355\u6e20\u9053\u4e0d\u9002\u914d\uff0c\u5f53\u524d\u8ba2\u5355\u6e20\u9053\uff1a{}", (Object)saleOrderRespDto.getSaleChannel());
                    result = Boolean.FALSE;
                }
            } else {
                result = Boolean.FALSE;
                LOGGER.error("\u7b56\u7565\u8ba2\u5355\u6e20\u9053\u672a\u8bbe\u7f6e");
            }
        }
        return result;
    }

    private List<Long> queryRangStrategyRules(DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum strategyType) {
        if (Objects.equals(DgCisStrategyOrderTypeEnum.SALES, strategyType) || Objects.equals(DgCisStrategyOrderTypeEnum.PRODUCTION, strategyType)) {
            DgStrategyPerformOrderRespDto dgStrategyPerformOrderRespDto = (DgStrategyPerformOrderRespDto)saleOrderRespDto;
            DgCustomerRespDto dgCustomerRespDto = Optional.ofNullable(dgStrategyPerformOrderRespDto.getDgCustomerRespDto()).orElse(new DgCustomerRespDto());
            List csOrgCustomerRelationDtos = dgStrategyPerformOrderRespDto.getCsOrgCustomerRelationDtos();
            CsOrgCustomerRelationDto csOrgCustomerRelationDto = Optional.ofNullable(csOrgCustomerRelationDtos).orElse(Lists.newArrayList()).stream().findFirst().orElse(new CsOrgCustomerRelationDto());
            String customerTypeId = Optional.ofNullable(csOrgCustomerRelationDto.getCustomerTypeId()).map(String::valueOf).orElse(null);
            String levelId = Optional.ofNullable(csOrgCustomerRelationDto.getLevelId()).map(String::valueOf).orElse(null);
            String groupId = Optional.ofNullable(dgCustomerRespDto.getCustomerGroupId()).map(String::valueOf).orElse(null);
            String customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode();
            String areaId = Optional.ofNullable(csOrgCustomerRelationDto.getAreaId()).map(String::valueOf).orElse(null);
            List dgStrategyRuleSuitEos = this.dgStrategyRuleSuitDomain.matchCustomerRangSuits(strategyType.getCode(), customerTypeId, levelId, groupId, customerCode, areaId);
            ArrayList ruleIds = Lists.newArrayList();
            Map map = dgStrategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getRuleId, Collectors.toMap(DgStrategyRuleSuitEo::getSuitType, Function.identity(), (e1, e2) -> e1)));
            for (Map.Entry entry : map.entrySet()) {
                Map value = entry.getValue();
                if (value.containsKey(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLIENT_BLACK.getCode())) continue;
                Set<String> suitTypeSet = value.keySet();
                if (!CUSTOMER_RANG_TYPE.stream().allMatch(suitType -> suitTypeSet.contains(suitType))) continue;
                ruleIds.add(entry.getKey());
            }
            return ruleIds;
        }
        return Lists.newArrayList();
    }

    protected ArrayList<Long> getAdaptChannelLongs(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEos) {
        List longList = dgStrategyRuleSuitEos.stream().map(DgStrategyRuleSuitEo::getRuleId).collect(Collectors.toList());
        LOGGER.info("\u5f53\u524d\u5339\u914d\u7684\u8ba2\u5355\u7b56\u7565\uff1a{}", (Object)JSON.toJSONString(longList));
        DgStrategyRuleReqDto dgStrategyRuleReqDto = new DgStrategyRuleReqDto();
        dgStrategyRuleReqDto.setLongList(longList);
        dgStrategyRuleReqDto.setBizModel(saleOrderRespDto.getBizModel());
        List<DgStrategyRuleVo> allStrategy = this.findAllStrategy(dgStrategyRuleReqDto);
        if (!allStrategy.isEmpty()) {
            Map dgStrategyRuleVoMap = allStrategy.stream().collect(Collectors.toMap(DgStrategyRuleRespDto::getId, Function.identity()));
            String channelCode = saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode();
            ArrayList<Long> longs = new ArrayList<Long>();
            dgStrategyRuleVoMap.forEach((k, v) -> {
                AtomicReference<Boolean> adapt = new AtomicReference<Boolean>(true);
                List dgStrategyConfItemDtos = v.getDgStrategyConfItemDtos();
                if (CollectionUtils.isNotEmpty((Collection)dgStrategyConfItemDtos)) {
                    Optional<String> adaptationChannel = dgStrategyConfItemDtos.stream().filter(e -> e.getStrategyType().equals("ADAPTATION_CHANNEL")).map(DgStrategyConfItemDto::getContent).findFirst();
                    adaptationChannel.ifPresent(e -> {
                        HashMap parseObject = (HashMap)JSONObject.parseObject((String)e, HashMap.class);
                        Set strings = parseObject.keySet();
                        if (!strings.contains(channelCode)) {
                            adapt.set(false);
                        }
                    });
                    if (adapt.get().booleanValue()) {
                        longs.add((Long)k);
                    }
                }
            });
            LOGGER.info("\u5f53\u524d\u5b50\u89c4\u5219\u9002\u914d\u7b56\u7565\uff1a{}", (Object)JSON.toJSONString(longs));
            return longs;
        }
        return new ArrayList<Long>();
    }

    protected ArrayList<Long> getAdaptLongs(DgPerformOrderRespDto saleOrderRespDto, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEos) {
        List longList = dgStrategyRuleSuitEos.stream().map(DgStrategyRuleSuitEo::getRuleId).collect(Collectors.toList());
        LOGGER.info("\u5f53\u524d\u5339\u914d\u7684\u8ba2\u5355\u7b56\u7565\uff1a{}", (Object)JSON.toJSONString(longList));
        DgStrategyRuleReqDto dgStrategyRuleReqDto = new DgStrategyRuleReqDto();
        dgStrategyRuleReqDto.setLongList(longList);
        dgStrategyRuleReqDto.setBizModel(saleOrderRespDto.getBizModel());
        List<DgStrategyRuleVo> allStrategy = this.findAllStrategy(dgStrategyRuleReqDto);
        if (!allStrategy.isEmpty()) {
            Map dgStrategyRuleVoMap = allStrategy.stream().collect(Collectors.toMap(DgStrategyRuleRespDto::getId, Function.identity()));
            String channelCode = saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode();
            String orderType = saleOrderRespDto.getOrderType();
            ArrayList<Long> longs = new ArrayList<Long>();
            dgStrategyRuleVoMap.forEach((k, v) -> {
                List orderTypeCollect;
                AtomicReference<Boolean> adapt = new AtomicReference<Boolean>(true);
                List dgStrategyConfItemDtos = v.getDgStrategyConfItemDtos();
                if (CollectionUtils.isNotEmpty((Collection)dgStrategyConfItemDtos)) {
                    Optional<String> adaptationChannel = dgStrategyConfItemDtos.stream().filter(e -> e.getStrategyType().equals("ADAPTATION_CHANNEL")).map(DgStrategyConfItemDto::getContent).findFirst();
                    adaptationChannel.ifPresent(e -> {
                        HashMap parseObject = (HashMap)JSONObject.parseObject((String)e, HashMap.class);
                        Set strings = parseObject.keySet();
                        if (!strings.contains(channelCode)) {
                            adapt.set(false);
                        }
                    });
                }
                if (!(orderTypeCollect = Optional.ofNullable(v.getDgStrategyConfItemSuitDtos()).orElse(Lists.newArrayList()).stream().map(DgStrategyConfItemSuitDto::getSuitValue).collect(Collectors.toList())).contains(orderType)) {
                    adapt.set(false);
                }
                if (adapt.get().booleanValue()) {
                    longs.add((Long)k);
                }
            });
            LOGGER.info("\u5f53\u524d\u5b50\u89c4\u5219\u9002\u914d\u7b56\u7565\uff1a{}", (Object)JSON.toJSONString(longs));
            return longs;
        }
        return new ArrayList<Long>();
    }

    protected boolean matchAllSuitCode(List<DgStrategyRuleSuitEo> strategyRuleSuitEos) {
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = strategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<DgStrategyRuleSuitEo> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        List<DgStrategyRuleSuitEo> hisOrderType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        List<DgStrategyRuleSuitEo> hisShop = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        List<DgStrategyRuleSuitEo> hisCompany = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_COMPANY.getCode());
        List<DgStrategyRuleSuitEo> hisOrderLabel = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_LABEL.getCode());
        return !CollectionUtils.isEmpty(hisShop) && !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisCompany) && !CollectionUtils.isEmpty(hisOrderType) && !CollectionUtils.isEmpty(hisOrderLabel);
    }

    protected boolean matchFeeScaleAllSuitCode(List<DgStrategyRuleSuitEo> strategyRuleSuitEos) {
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = strategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<DgStrategyRuleSuitEo> hisShop = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        List<DgStrategyRuleSuitEo> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        List<DgStrategyRuleSuitEo> hisOrderType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        return !CollectionUtils.isEmpty(hisShop) && !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisOrderType);
    }

    protected Boolean checkRule(List<StrategyConfItemEo> strategyConfItemEoList, DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        for (StrategyConfItemEo confItemEo : strategyConfItemEoList) {
            DgStrategyConfItemTypeEnum strategyTypeEnum = DgStrategyConfItemTypeEnum.forCode((String)confItemEo.getStrategyType());
            LOGGER.info("\u6821\u9a8c\u914d\u7f6e\u9879\uff1a{}", (Object)(null != strategyTypeEnum ? strategyTypeEnum.getDesc() : "null"));
            Boolean checkResult = Boolean.TRUE;
            switch (strategyTypeEnum) {
                case SPECIAL_ORDER_TPYE: {
                    if (DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY.equals((Object)dgCisStrategyOrderTypeEnum)) break;
                    checkResult = this.checkOrderType(saleOrderRespDto, confItemEo);
                    break;
                }
                case ADAPTATION_CHANNEL: {
                    if (DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY.equals((Object)dgCisStrategyOrderTypeEnum) || DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY.equals((Object)dgCisStrategyOrderTypeEnum)) break;
                    checkResult = this.checkChannel(saleOrderRespDto, confItemEo);
                    break;
                }
                case NEEDLESS_PERSON_AUDIT: {
                    Boolean result = this.checkPersonAudit(saleOrderRespDto, confItemEo);
                    if (!result.booleanValue()) break;
                    DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                    hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode());
                    hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getDesc());
                    return Boolean.TRUE;
                }
                case SPECIAL_AMOUNT: {
                    checkResult = this.checkSpecialAmount(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_PAYTIME: {
                    checkResult = this.checkSpecialPaytime(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_WAREHOUSE: {
                    checkResult = this.checkSpecialWarehouse(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_SKU: {
                    checkResult = this.checkSpecialSku(confItemEo, saleOrderRespDto, dgCisStrategyOrderTypeEnum);
                    break;
                }
                case SPECIAL_AREA: {
                    checkResult = this.checkSpecialArea(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_CUSTOMER: {
                    checkResult = this.checkSpecialCustomer(confItemEo, saleOrderRespDto);
                    break;
                }
                case BUYER_REMARK: {
                    checkResult = this.checkBuyerRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case SELLER_REMARK: {
                    checkResult = this.checkSellerRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case INTERNAL_REMARK: {
                    checkResult = this.checkInternalRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case MANUAL_ORDER_NEED_PERSON_AUDIT: {
                    checkResult = this.checkManualOrderAudit(confItemEo, saleOrderRespDto);
                    break;
                }
                case IMPORT_ORDER_NEED_PERSON_AUDIT: {
                    checkResult = this.checkImportOrderAudit(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_ITEM_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderItem(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_ADDR_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderAddr(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_SHIPMENT_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderShipment(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_LABEL: {
                    checkResult = this.checkSpecialLabel(confItemEo, saleOrderRespDto);
                    break;
                }
                case ORDER_NUMBER_JUDGMENT: {
                    checkResult = this.checkSpecialOrderNumber(confItemEo, saleOrderRespDto);
                    break;
                }
            }
            if (!Boolean.FALSE.equals(checkResult)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkSpecialOrderNumber(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        BigDecimal goodsTotalNum = saleOrderRespDto.getGoodsTotalNum();
        AssertUtils.notNull((Object)goodsTotalNum, (String)"\u6821\u9a8c\u81ea\u52a8\u5ba2\u5ba1\u7b56\u7565\uff1a\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        String value = map.get("value").toString();
        BigDecimal bigDecimal = new BigDecimal(value);
        if (goodsTotalNum.compareTo(bigDecimal) >= 0) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9a\u5546\u54c1\u6570\u91cf\u9700\u8981\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.ORDER_NUMBER_JUDGMENT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.ORDER_NUMBER_JUDGMENT.getDesc());
            return false;
        }
        return true;
    }

    protected Boolean checkSpecialLabel(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(saleOrderRespDto.getId());
        List tagRespDtos = this.orderTagRecordDomain.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)tagRespDtos)) {
            List tagCodes = tagRespDtos.stream().map(DgOrderTagRecordDto::getTagCode).collect(Collectors.toList());
            LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, tagCodes);
            List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
            if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9a\u6807\u7b7e\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
                DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_LABEL.getDesc());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialArea(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgPerformOrderAddrExtDomain.queryAddressByOrderId(saleOrderRespDto.getId());
        ArrayList addCodeList = new ArrayList();
        Optional.ofNullable(dgPerformOrderAddrDto.getProvinceCode()).ifPresent(addCodeList::add);
        Optional.ofNullable(dgPerformOrderAddrDto.getCityCode()).ifPresent(addCodeList::add);
        Optional.ofNullable(dgPerformOrderAddrDto.getCountyCode()).ifPresent(addCodeList::add);
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, addCodeList);
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9a\u533a\u57df\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_AREA.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkOrderType(DgPerformOrderRespDto saleOrderRespDto, StrategyConfItemEo confItemEo) {
        String orderType = saleOrderRespDto.getOrderType();
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, new Object[]{orderType});
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u8ba2\u5355\u7c7b\u578b\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkChannel(DgPerformOrderRespDto saleOrderRespDto, StrategyConfItemEo confItemEo) {
        HashMap hashMap;
        Set channelCode;
        LOGGER.info("[\u8ba2\u5355\u7b56\u7565]\u6e20\u9053\u8ba2\u5355\u4f7f\u7528\u8303\u56f4");
        String saleChannel = saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode();
        if (confItemEo != null && (channelCode = (hashMap = (HashMap)JSON.parseObject((String)confItemEo.getContent(), HashMap.class)).keySet()).contains(saleChannel)) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getDesc());
            return false;
        }
        return true;
    }

    private boolean matchF2bOrderAllSuitCode(List<DgStrategyRuleSuitEo> strategyRuleSuitEos) {
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = strategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<DgStrategyRuleSuitEo> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        List<DgStrategyRuleSuitEo> hisOrderType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        List<DgStrategyRuleSuitEo> hisShop = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        List<DgStrategyRuleSuitEo> hisCompany = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_COMPANY.getCode());
        return !CollectionUtils.isEmpty(hisShop) && !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisCompany) && !CollectionUtils.isEmpty(hisOrderType);
    }

    protected Boolean checkModifyOrderShipment(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> saleOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u7269\u6d41\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (saleOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> DgStrategyConfItemTypeEnum.ARRANGE_SHIPMENT_ENTERPRISE.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4fee\u6539\u7269\u6d41\u5747\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkModifyOrderAddr(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> saleOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (saleOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> DgStrategyConfItemTypeEnum.MODIFY_ADDRESS.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4fee\u6539\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkModifyOrderItem(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> dgPerformOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u5546\u54c1\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (dgPerformOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> DgStrategyConfItemTypeEnum.MANUAL_ADD_ITEMS.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn()) || DgStrategyConfItemTypeEnum.MANUAL_MODIFY_ITEMS.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn()) || DgStrategyConfItemTypeEnum.MANUAL_MODIFY_ITEMS_SKUCODE.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn()) || DgStrategyConfItemTypeEnum.MANUAL_MODIFY_ITEMS_FOR_DIFFERENCE.getCode().equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u624b\u5de5\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkImportOrderAudit(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u5bfc\u5165\u8ba2\u5355/\u5bfc\u5165\u8d60\u54c1\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && SaleOrderSourceEnum.IMPORT.getType().equals(saleOrderRespDto.getOrderSource())) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5bfc\u5165\u8ba2\u5355/\u5bfc\u5165\u8d60\u54c1\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkManualOrderAudit(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && StrategyEnableEnum.ENABLE.getType().equals(confItemEo.getEnable()) && SaleOrderSourceEnum.CREATE.getType().equals(saleOrderRespDto.getOrderSource())) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkInternalRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={},\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto.getRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    protected Boolean checkSellerRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto.getSellerRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    protected Boolean checkBuyerRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={},\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto.getBuyerRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.BUYER_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    protected Boolean checkRemark(StrategyConfItemEo confItemEo, String remark) {
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        String remarkType = MapUtils.getString((Map)map, (Object)"remarkType");
        if (StringUtils.equals((CharSequence)remarkType, (CharSequence)NEED_PERSON_AUDIT_BY_REMARK)) {
            if (StringUtils.isNotBlank((CharSequence)remark)) {
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u6709\u5907\u6ce8\u5747\u505a\u4eba\u5de5\u5ba1\u6838\u547d\u4e2d\u914d\u7f6e\u9879\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
                DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                hitStrategyOrder.setHitConfItemName("\u6709\u5907\u6ce8\u5747\u505a\u4eba\u5de5\u5ba1\u6838");
                return Boolean.FALSE;
            }
        } else {
            String[] keywords;
            String keyWords = MapUtils.getString((Map)map, (Object)"keyWords");
            for (String keyword : keywords = keyWords.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)remark) || !remark.contains(keyword)) continue;
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u547d\u4e2d\u5173\u952e\u8bcd\u505a\u4eba\u5de5\u5ba1\u6838\u547d\u4e2d\u914d\u7f6e\u9879\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
                DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                hitStrategyOrder.setHitConfItemName("\u547d\u4e2d\u5173\u952e\u8bcd\u505a\u4eba\u5de5\u5ba1\u6838");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialCustomer(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, new Object[]{saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode()});
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9a\u5ba2\u6237\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialSku(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        List<Object> skuCodeList = new ArrayList();
        skuCodeList = OMS_STRATEGY_TYPE.contains(dgCisStrategyOrderTypeEnum.getCode()) ? Optional.ofNullable(this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderRespDto.getId())).orElseGet(Collections::emptyList).stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList()) : Optional.ofNullable(this.dgPerformOrderItemDomain.queryNormalItemByOrderId(saleOrderRespDto.getId())).orElseGet(Collections::emptyList).stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)confItemEo.getContent()) && confItemEo.getContent().equals("ALL")) {
            return true;
        }
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, skuCodeList);
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9aSKU\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_SKU.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialWarehouse(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).eq(StrategyConfItemSuitEo::getSuitValue, (Object)saleOrderRespDto.getLogicalWarehouseCode());
        List strategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u5b9e\u7269\u4ed3\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialPaytime(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        if (saleOrderRespDto.getPerformOrderPaymentDto().getPayTime() == null) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u8ba2\u5355\u6ca1\u6709\u652f\u4ed8\u65f6\u95f4", (Object)saleOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        Date startTime = DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss");
        Date endTime = DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss");
        if (saleOrderRespDto.getPerformOrderPaymentDto().getPayTime().compareTo(startTime) >= 0 && saleOrderRespDto.getPerformOrderPaymentDto().getPayTime().compareTo(endTime) <= 0) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u65f6\u95f4\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean checkSpecialAmount(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        BigDecimal minAmount = new BigDecimal(MapUtils.getString((Map)map, (Object)"minAmount"));
        BigDecimal maxAmount = new BigDecimal(MapUtils.getString((Map)map, (Object)"maxAmount"));
        BigDecimal merchantReceivableAmount = saleOrderRespDto.getPayAmount() != null ? saleOrderRespDto.getPayAmount() : saleOrderRespDto.getPerformOrderAmountDto().getPayAmount();
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u300a\u6307\u5b9a\u91d1\u989d\u300b\uff0c\u8ba2\u5355\u53f7={}\uff0c\u5546\u5bb6\u5e94\u6536\u5c0f\u4e8e\u7b49\u4e8e\u914d\u7f6e\u6700\u5c0f\u91d1\u989d,\u9700\u8981\u4eba\u5de5\u5ba1\u6838\uff0c\u5546\u5bb6\u5e94\u6536\u4e3a\uff1a{}\uff0c\u914d\u7f6e\u7684\u6700\u5c0f\u91d1\u989d\u4e3a\uff1a{},\u914d\u7f6e\u6700\u5927\u91d1\u989d\u4e3a\uff1a{}", new Object[]{saleOrderRespDto.getSaleOrderNo(), merchantReceivableAmount, minAmount, maxAmount});
        if (minAmount.compareTo(saleOrderRespDto.getMerchantReceivableAmount()) >= 0 || maxAmount.compareTo(saleOrderRespDto.getMerchantReceivableAmount()) <= 0) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u91d1\u989d\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}\uff0c\u5546\u5bb6\u5e94\u6536\u5c0f\u4e8e\u7b49\u4e8e\u914d\u7f6e\u6700\u5c0f\u91d1\u989d,\u9700\u8981\u4eba\u5de5\u5ba1\u6838\uff0c\u5546\u5bb6\u5e94\u6536\u4e3a\uff1a{}\uff0c\u914d\u7f6e\u7684\u6700\u5c0f\u91d1\u989d\u4e3a\uff1a{},\u914d\u7f6e\u6700\u5927\u91d1\u989d\u4e3a\uff1a{}", new Object[]{saleOrderRespDto.getSaleOrderNo(), merchantReceivableAmount, minAmount, maxAmount});
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(DgStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode());
            hitStrategyOrder.setHitConfItemName(DgStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected List<StrategyConfItemEo> queryValidRuleConfItemList(DgStrategyRuleEo dgStrategyRuleEo) {
        LambdaQueryWrapper queryConfItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)dgStrategyRuleEo.getId())).eq(StrategyConfItemEo::getEnable, (Object)StrategyEnableEnum.ENABLE.getType());
        List strategyConfItemEos = this.dgStrategyConfItemDomain.list(queryConfItemWrapper);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u4e2d\u751f\u6548\u7684\u914d\u7f6e\u9879\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)strategyConfItemEos));
        AssertUtils.notEmpty((Collection)strategyConfItemEos, (String)(dgStrategyRuleEo.getRuleCode() + "\u7b56\u7565\u7684\u914d\u7f6e\u9879\u5747\u4e3a\u5173\u95ed"));
        return strategyConfItemEos;
    }

    protected Boolean checkPersonAudit(DgPerformOrderRespDto saleOrderRespDto, StrategyConfItemEo confItemEo) {
        if (confItemEo != null && StrategyEnableEnum.ENABLE.getType().equals(confItemEo.getEnable())) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u7b56\u7565\u5f00\u542f\u4e86\u300a\u8ba2\u5355\u5747\u4e0d\u505a\u4eba\u5de5\u5ba1\u6838\u300b", (Object)saleOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void handleDelayAuditByConf(StrategyConfItemEo strategyConfItemEo, DgPerformOrderRespDto saleOrderRespDto, Date startTime, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        Integer delayTimeExe = this.getDelayTimeExe(strategyConfItemEo);
        Date planExeTime = DateUtil.addMinutes((Date)startTime, (int)delayTimeExe);
        if (DateUtil.getDifferMinute((Date)new Date(), (Date)planExeTime) > HANDLE_TASK_BY_MQ_DELAY_THRESHOLD) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setPlanExeTime(planExeTime);
            updateReqDto.setDelayExe(delayTimeExe);
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
        } else {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setPlanExeTime(planExeTime);
            updateReqDto.setDelayExe(delayTimeExe);
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
            MessageVo messageVo = new MessageVo();
            SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
            saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
            saleTradeMessageVo.setRuleId(strategyConfItemEo.getRuleId());
            saleTradeMessageVo.setStrategyOrderId(hitStrategyOrder.getId());
            saleTradeMessageVo.setNextOptType(StrategyHelper.chooseNextOptTypeByStrategyType(dgCisStrategyOrderTypeEnum));
            AssertUtils.notBlank((String)saleTradeMessageVo.getNextOptType(), (String)"nextOptType \u4e0d\u80fd\u4e3a\u7a7a");
            messageVo.setData((Object)saleTradeMessageVo);
            long delayTimeSeconds = planExeTime.getTime() / 1000L - new Date().getTime() / 1000L;
            long delaySeconds = Math.max(delayTimeSeconds, 2L);
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{saleOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageVo), delaySeconds});
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "DELAY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(delaySeconds));
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)messageResponse));
        }
    }

    private Integer getDelayTimeExe(StrategyConfItemEo strategyConfItemEo) {
        Integer delayTimeExe = 0;
        String content = Optional.ofNullable(strategyConfItemEo.getContent()).orElse(NEED_PERSON_AUDIT_BY_REMARK);
        if (Objects.isNull(strategyConfItemEo.getContentType()) || strategyConfItemEo.getContentType().equals(CisStrategyContentTypeEnum.NUMBER.getCode())) {
            delayTimeExe = Integer.parseInt(Optional.of(content).orElse(NEED_PERSON_AUDIT_BY_REMARK));
        } else if (strategyConfItemEo.getContentType().equals(CisStrategyContentTypeEnum.STRING.getCode()) && StringUtils.isNotEmpty((CharSequence)content)) {
            HashMap map = (HashMap)JSON.parseObject((String)content, HashMap.class);
            delayTimeExe = Integer.parseInt(Optional.ofNullable(map.get("value").toString()).orElse(NEED_PERSON_AUDIT_BY_REMARK));
        }
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u83b7\u53d6\u7b56\u7565\u5ef6\u8fdf\u65f6\u95f4\u4e3a\uff1a{}", (Object)delayTimeExe);
        return delayTimeExe;
    }

    protected void saveHitConfItem() {
        DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
        DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
        updateReqDto.setId(hitStrategyOrder.getId());
        updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
        updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
        this.strategyOrderService.modifyStrategyOrder(updateReqDto);
        if (hitStrategyOrder.getSaleOrderId() != null) {
            DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
            modifyReqDto.setId(hitStrategyOrder.getSaleOrderId());
            modifyReqDto.setInterceptType(hitStrategyOrder.getType() + "_" + hitStrategyOrder.getHitConfItemType());
            DgStrategyConfItemTypeEnum dgStrategyConfItemTypeEnum = DgStrategyConfItemTypeEnum.forCode((String)hitStrategyOrder.getHitConfItemType());
            modifyReqDto.setInterceptReason("\u547d\u4e2d\u300a" + dgStrategyConfItemTypeEnum.getDesc() + "\u300b\u7b56\u7565\u914d\u7f6e\u9879");
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u7684\u62e6\u622a\u4fe1\u606f\u4e3a {}", (Object)JSON.toJSONString((Object)modifyReqDto));
            this.omsOrderInfoDomain.update(modifyReqDto);
        }
    }

    protected void setHitStrategyOrder(DgStrategyOrderReqDto strategyOrderReqDto) {
        AssertUtils.notNull((Object)strategyOrderReqDto, (String)"strategyOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        CACHE_HIT_ITEM.set(strategyOrderReqDto);
    }

    protected DgStrategyOrderReqDto getHitStrategyOrder() {
        DgStrategyOrderReqDto strategyOrderReqDto = CACHE_HIT_ITEM.get();
        if (strategyOrderReqDto == null) {
            strategyOrderReqDto = new DgStrategyOrderReqDto();
            CACHE_HIT_ITEM.set(strategyOrderReqDto);
        }
        return strategyOrderReqDto;
    }

    protected void cleanHitStrategyOrder() {
        CACHE_HIT_ITEM.remove();
    }

    public static class MatchStrategyResult {
        protected Boolean matchStrategy = Boolean.TRUE;
        protected Boolean intercepted = Boolean.FALSE;

        public Boolean getMatchStrategy() {
            return this.matchStrategy;
        }

        public void setMatchStrategy(Boolean matchStrategy) {
            this.matchStrategy = matchStrategy;
        }

        public Boolean getIntercepted() {
            return this.intercepted;
        }

        public void setIntercepted(Boolean intercepted) {
            this.intercepted = intercepted;
        }
    }
}

