/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderReqDto;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderLogisticsConfigService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgPolicySubRuleProcessingLogicService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.StrategyHelper;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IDgPolicySubRuleProcessingLogicServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgPolicySubRuleProcessingLogicService {
    private static Logger logger = LoggerFactory.getLogger(IDgPolicySubRuleProcessingLogicServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    protected IDgStrategyOrderService strategyOrderService;
    @Resource
    private IDgOrderLogisticsConfigService dgOrderLogisticsConfigService;
    protected static Integer time;

    @Override
    public Date automaticConfirmationOfReceiptTime(StrategyConfItemEo strategyConfItemEo, Date delayTime) {
        String content = "0";
        if (!Objects.isNull(strategyConfItemEo.getContent())) {
            content = strategyConfItemEo.getContent();
        }
        time = Integer.valueOf(content);
        Date planExeTime = com.dtyunxi.util.DateUtil.addMinutes((Date)delayTime, (int)Integer.valueOf(content));
        return planExeTime;
    }

    @Override
    public Date automaticDelayMinAudit(StrategyConfItemEo strategyConfItemEo, Date delayTime) {
        String content = "0";
        if (!Objects.isNull(strategyConfItemEo.getContent())) {
            content = strategyConfItemEo.getContent();
        }
        return com.dtyunxi.util.DateUtil.addMinutes((Date)delayTime, (int)Integer.parseInt(content));
    }

    @Override
    public Date automaticDelayAudit(StrategyConfItemEo strategyConfItemEo, Date delayTime) {
        String content = "0";
        if (!Objects.isNull(strategyConfItemEo.getContent())) {
            content = strategyConfItemEo.getContent();
        }
        time = Integer.valueOf(content);
        Date planExeTime = com.dtyunxi.util.DateUtil.addDay((Date)delayTime, (int)Integer.valueOf(content));
        return planExeTime;
    }

    @Override
    public Date automaticDelayAudit2b(StrategyConfItemEo strategyAOrderConfItemEo, Date delayTime) {
        HashMap map;
        Integer type;
        Integer delayTimeExe = 0;
        String content = "";
        if (!Objects.isNull(strategyAOrderConfItemEo.getContent())) {
            content = strategyAOrderConfItemEo.getContent();
        }
        if (Objects.equals(type = Integer.valueOf(Optional.ofNullable((map = (HashMap)JSON.parseObject((String)content, HashMap.class)).get("type").toString()).orElse("0")), 3)) {
            logger.info("\u81ea\u52a8\u5ef6\u65f6\u5ba1\u68382b\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\u95f4\u6bb5\uff0c\u5ef6\u8fdf\u65f6\u95f4\u8fd4\u56denull");
            return null;
        }
        time = delayTimeExe = Integer.valueOf(Optional.ofNullable(map.get("value").toString()).orElse("0"));
        Date planExeTime = com.dtyunxi.util.DateUtil.addMinutes((Date)delayTime, (int)delayTimeExe);
        return planExeTime;
    }

    @Override
    public Date automaticDeliveryDelayAudit2b(StrategyConfItemEo strategyAOrderConfItemEo, Date delayTime, DgPerformOrderRespDto performOrderRespDto) {
        HashMap map;
        Integer type;
        Integer delayTimeExe = 0;
        String content = "";
        if (!Objects.isNull(strategyAOrderConfItemEo.getContent())) {
            content = strategyAOrderConfItemEo.getContent();
        }
        if (Objects.equals(type = Integer.valueOf(Optional.ofNullable((map = (HashMap)JSON.parseObject((String)content, HashMap.class)).get("type").toString()).orElse("0")), 3) && this.dgOrderLogisticsConfigService.isEnableAutoLogistics(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode(), DgSaleOrderTypeEnum.enumOf((String)performOrderRespDto.getOrderType())).booleanValue()) {
            logger.info("\u81ea\u52a8\u5ef6\u65f6\u5ba1\u68382b\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\u95f4\u6bb5\uff0c\u5ef6\u8fdf\u65f6\u95f4\u8fd4\u56denull");
            return null;
        }
        time = delayTimeExe = Integer.valueOf(Optional.ofNullable(map.get("value").toString()).orElse("0"));
        Date planExeTime = com.dtyunxi.util.DateUtil.addMinutes((Date)delayTime, (int)delayTimeExe);
        return planExeTime;
    }

    @Override
    public Date automaticDelaySync2b(StrategyConfItemEo strategyAOrderConfItemEo, Date delayTime) {
        HashMap map;
        Integer type;
        String content = "";
        if (!Objects.isNull(strategyAOrderConfItemEo.getContent())) {
            content = strategyAOrderConfItemEo.getContent();
        }
        if (!Objects.equals(type = Integer.valueOf(Optional.ofNullable((map = (HashMap)JSON.parseObject((String)content, HashMap.class)).get("type").toString()).orElse("0")), 3) || Objects.isNull(map.get("timeArray"))) {
            logger.info("\u81ea\u52a8\u5ef6\u65f6\u5ba1\u68382b\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\u95f4\u6bb5\uff0c\u5ef6\u8fdf\u65f6\u95f4\u8fd4\u56denull");
            return delayTime;
        }
        List timeArray = JSON.parseArray((String)map.get("timeArray").toString(), String.class);
        if (CollectionUtils.isEmpty((Collection)timeArray)) {
            logger.info("\u81ea\u52a8\u5ef6\u65f6\u5ba1\u68382b\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\u95f4\u6bb5\u4e3a\u7a7a");
            return delayTime;
        }
        TreeSet<Date> dateTreeSet = new TreeSet<Date>();
        TreeSet<Date> dateAllTreeSet = new TreeSet<Date>();
        String toDayStr = com.dtyunxi.util.DateUtil.getCurrenDate();
        Date sysDate = new Date();
        for (String time : timeArray) {
            String delayDateStr = toDayStr + " " + time;
            Date parse = com.dtyunxi.util.DateUtil.parse((String)delayDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            dateAllTreeSet.add(parse);
            if (parse.compareTo(sysDate) < 0) continue;
            dateTreeSet.add(parse);
        }
        logger.info("\u5168\u90e8\u65f6\u95f4\u6bb5={}", JSON.toJSON(dateAllTreeSet));
        logger.info("\u7b5b\u9009\u540e\u65f6\u95f4\u6bb5={}", JSON.toJSON(dateTreeSet));
        if (dateTreeSet.isEmpty()) {
            logger.info("\u5f53\u524d\u65f6\u95f4\u6bb5\u672a\u7b26\u5408\u5f53\u524d\u65f6\u95f4={}", (Object)com.dtyunxi.util.DateUtil.format((Date)sysDate, (String)"yyyy-MM-dd HH:mm:ss"));
            return DateUtil.addDays((Date)((Date)dateAllTreeSet.first()), (int)1);
        }
        return (Date)dateTreeSet.first();
    }

    @Override
    public Date automaticDelayMinAudit2c(StrategyConfItemEo strategyConfItemEo, Date delayTime) {
        HashMap map;
        logger.info("\u5ef6\u65f6\u65f6\u95f4\u8ba1\u7b97\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)strategyConfItemEo), (Object)delayTime);
        int delayTimeExe = 0;
        if (StringUtils.isNotBlank((CharSequence)strategyConfItemEo.getContent()) && ObjectUtils.isNotEmpty((map = (HashMap)JSON.parseObject((String)strategyConfItemEo.getContent(), HashMap.class)).get("value"))) {
            delayTimeExe = Integer.parseInt(map.get("value").toString());
        }
        return com.dtyunxi.util.DateUtil.addMinutes((Date)delayTime, (int)delayTimeExe);
    }

    @Override
    public void extractedDgPerformOrder(StrategyConfItemEo strategyConfItemEo, DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum, Date planExeTime) {
        if (com.dtyunxi.util.DateUtil.getDifferMinute((Date)new Date(), (Date)planExeTime) > HANDLE_TASK_BY_MQ_DELAY_THRESHOLD) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setPlanExeTime(planExeTime);
            if (dgCisStrategyOrderTypeEnum.equals((Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY) || dgCisStrategyOrderTypeEnum.equals((Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY)) {
                updateReqDto.setDelayExe(Integer.valueOf(time * 24 * 60));
            } else {
                updateReqDto.setDelayExe(time);
            }
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
        } else {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setPlanExeTime(planExeTime);
            if (dgCisStrategyOrderTypeEnum.equals((Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_STRATEGY) || dgCisStrategyOrderTypeEnum.equals((Object)DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY)) {
                updateReqDto.setDelayExe(Integer.valueOf(time * 24 * 60));
            } else {
                updateReqDto.setDelayExe(time);
            }
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
            MessageVo messageVo = new MessageVo();
            SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
            saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
            saleTradeMessageVo.setRuleId(strategyConfItemEo.getRuleId());
            saleTradeMessageVo.setStrategyOrderId(hitStrategyOrder.getId());
            saleTradeMessageVo.setNextOptType(StrategyHelper.chooseNextOptTypeByStrategyType(dgCisStrategyOrderTypeEnum));
            AssertUtils.notBlank((String)saleTradeMessageVo.getNextOptType(), (String)"nextOptType \u4e0d\u80fd\u4e3a\u7a7a");
            messageVo.setData((Object)saleTradeMessageVo);
            long delayTimeSeconds = planExeTime.getTime() / 1000L - new Date().getTime() / 1000L;
            long delaySeconds = Math.max(delayTimeSeconds, 2L);
            logger.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{saleOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageVo), delaySeconds});
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "DELAY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(delaySeconds));
            logger.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{},\u5f53\u524d\u7b56\u7565\u4fe1\u606f\uff1a{}", new Object[]{saleOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageResponse), JSON.toJSONString((Object)StrategyHelper.chooseNextOptTypeByStrategyType(dgCisStrategyOrderTypeEnum))});
        }
    }
}

