/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.proxy.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.dto.request.ItemExchangeUnitDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemExchangeUnitDgRespDto;
import com.yunxi.dg.base.center.item.proxy.item.IItemDgQueryApiProxy;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderAddrPageReqDto;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemPageReqDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultReqDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.source.proxy.option.IDgOrderOptApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgSupplyGroupMatchSupportService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgSourceApiService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgSourceApiServiceImpl
implements IDgSourceApiService {
    private static final Logger log = LoggerFactory.getLogger(DgSourceApiServiceImpl.class);
    @Resource
    private IDgOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IDgOrderOptApiProxy orderOptApi;
    @Value(value="${oms.source.split.tagCode:TAG202209010066}")
    private String splitTagCode;
    @Resource
    private IDgSupplyGroupMatchSupportService supplyGroupMatchSupportService;
    @Resource
    private IItemDgQueryApiProxy itemDgQueryApiProxy;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;

    public BigDecimal batchExchangeUnitByItem(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            log.info("\u5165\u53c2itemList\u4e3a\u7a7a");
            return BigDecimal.ZERO;
        }
        Set skuIdsSet = itemList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toSet());
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryItemListByPage(new ArrayList<String>(skuIdsSet));
        Map shelfItemMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        BigDecimal totalSaleUnitNum = saleOrderRespDto.getGoodsTotalNum();
        ArrayList exchangeUnitList = Lists.newArrayList();
        for (DgPerformOrderLineDto item2 : itemList) {
            DgItemSkuPageRespDto itemSkuRespDto = (DgItemSkuPageRespDto)shelfItemMap.get(item2.getSkuId());
            AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("%s\u5546\u54c1\u672a\u4e0a\u67b6", item2.getSkuCode()));
            String saleUnit = Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit());
            ItemExchangeUnitDgReqDto calcUnitDgReqDto = new ItemExchangeUnitDgReqDto();
            calcUnitDgReqDto.setLineNo(item2.getId());
            calcUnitDgReqDto.setSkuCode(item2.getSkuCode());
            calcUnitDgReqDto.setCurrentUnit(item2.getOrderItemUnit());
            calcUnitDgReqDto.setCurrentNum(item2.getItemNum());
            calcUnitDgReqDto.setTargetUnit(saleUnit);
            exchangeUnitList.add(calcUnitDgReqDto);
        }
        if (CollectionUtils.isEmpty((Collection)exchangeUnitList)) {
            log.info("batchExchangeUnitByItem\u5165\u53c2List\u4e3a\u7a7a");
            return totalSaleUnitNum;
        }
        long startTime = System.currentTimeMillis();
        log.info("\u7269\u6d41\u5bfb\u6e90batchExchangeUnitByItem\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exchangeUnitList));
        List itemExchangeUnitDgRespDtos = new ArrayList();
        try {
            itemExchangeUnitDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemDgQueryApiProxy.batchExchangeUnit((List)exchangeUnitList));
        }
        catch (Exception e) {
            log.error("\u5355\u4f4d\u6362\u7b97\u5f02\u5e38\uff1a{}", (Throwable)e);
            return totalSaleUnitNum;
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7269\u6d41\u5bfb\u6e90\u5355\u4f4d\u8f6c\u6362\u8c03\u7528\u63a5\u53e3itemDgQueryApiProxy.batchExchangeUnit\uff1a{},\u8017\u65f6:{}", (Object)JSON.toJSONString(itemExchangeUnitDgRespDtos), (Object)(endTime - startTime));
        Map<Object, Object> skuUnitMap = new HashMap();
        if (CollectionUtils.isNotEmpty(itemExchangeUnitDgRespDtos)) {
            skuUnitMap = itemExchangeUnitDgRespDtos.stream().filter(item -> null != item.getTargetNum() && StringUtils.isNotBlank((CharSequence)item.getTargetUnit())).collect(Collectors.toMap(x -> x.getLineNo() + "_" + x.getCode(), ItemExchangeUnitDgRespDto::getTargetNum, (k1, k2) -> k1));
        }
        totalSaleUnitNum = BigDecimal.ZERO;
        for (DgPerformOrderLineDto item3 : itemList) {
            String saleKey = item3.getId() + "_" + item3.getSkuCode();
            if (skuUnitMap.containsKey(saleKey)) {
                totalSaleUnitNum = totalSaleUnitNum.add((BigDecimal)skuUnitMap.get(saleKey));
                continue;
            }
            totalSaleUnitNum = totalSaleUnitNum.add(item3.getItemNum());
        }
        return totalSaleUnitNum;
    }

    private void setLinkOrderCustomer(DgSourceOrderResultReqDto sourceOrderResultReqDto, DgPerformOrderRespDto saleOrderRespDto) {
        if (DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode().equals(saleOrderRespDto.getBizModel())) {
            sourceOrderResultReqDto.setLinkOrderCustomerId(saleOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerId());
            sourceOrderResultReqDto.setLinkOrderCustomerName(saleOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerName());
            sourceOrderResultReqDto.setLinkOrderCustomerCode(saleOrderRespDto.getPerformOrderSnapshotDto().getHsCustomerCode());
        } else if (DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode().equals(saleOrderRespDto.getBizModel())) {
            sourceOrderResultReqDto.setLinkOrderCustomerId(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
            sourceOrderResultReqDto.setLinkOrderCustomerName(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
            sourceOrderResultReqDto.setLinkOrderCustomerCode(saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
        } else {
            throw new BizException("\u5bfb\u6e90\u672a\u914d\u7f6e\u53ef\u7528\u5ba2\u6237\u7f16\u7801");
        }
    }

    private void setLinkOrderLabelCode(DgSourceOrderResultReqDto sourceOrderResultReqDto, DgPerformOrderRespDto saleOrderRespDto) {
        List tagRecordRespDtos = this.orderTagRecordDomain.queryTagById(saleOrderRespDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)tagRecordRespDtos)) {
            sourceOrderResultReqDto.setLinkOrderLabelCodeList(tagRecordRespDtos.stream().map(DgOrderTagRecordDto::getTagCode).collect(Collectors.toList()));
        }
    }

    @Override
    public DgSourceOrderResultRespDto searchSourceV2(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> orderLineDtos, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        log.info("[\u5bfb\u6e90]\u5f00\u59cb\u5bfb\u6e90");
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        DgSourceOrderResultReqDto sourceOrderResultReqDto = new DgSourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setId(null);
        sourceOrderResultReqDto.setLinkOrderNo(saleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelId());
        this.setLinkOrderCustomer(sourceOrderResultReqDto, saleOrderRespDto);
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrderRespDto.getDefaultLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getDefaultLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrderRespDto.getDefaultLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setBizModel(saleOrderRespDto.getBizModel());
        sourceOrderResultReqDto.setLinkOrderCompanyCode(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        sourceOrderResultReqDto.setLinkOrderCompanyName(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseName());
        this.setLinkOrderLabelCode(sourceOrderResultReqDto, saleOrderRespDto);
        sourceOrderResultReqDto.setSgType(ClueTypeEnum.WAREHOUSE.getCode());
        sourceOrderResultReqDto.setLinkShopId(saleOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        sourceOrderResultReqDto.setLinkOrderShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        sourceOrderResultReqDto.setLinkOrderShopName(saleOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        sourceOrderResultReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        DgOrderAddrPageReqDto orderAddrReqDto = new DgOrderAddrPageReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        List orderItemReqDtoList = orderLineDtos.stream().map(saleOrderItemExtRespDto -> {
            DgOrderItemPageReqDto orderItemReqDto = new DgOrderItemPageReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemSkuName(saleOrderItemExtRespDto.getSkuName());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            orderItemReqDto.setOrderItemUnit(saleOrderItemExtRespDto.getOrderItemUnit());
            orderItemReqDto.setBasicUnit(saleOrderItemExtRespDto.getBasicUnit());
            orderItemReqDto.setItemGiftType(saleOrderItemExtRespDto.getGiftFlag());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApi.addSourceOrder(sourceOrderResultReqDto);
        DgSourceOrderResultRespDto sourceOrderResultRespDto = (DgSourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
        log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        return sourceOrderResultRespDto;
    }

    private DgSourceOrderResultReqDto getDgSourceOrderResultReqDto(DgPerformOrderRespDto saleOrderRespDto, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        DgSourceOrderResultReqDto sourceOrderResultReqDto = new DgSourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setId(null);
        sourceOrderResultReqDto.setLinkOrderNo(saleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(saleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelId());
        this.setLinkOrderCustomer(sourceOrderResultReqDto, saleOrderRespDto);
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrderRespDto.getDefaultLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getDefaultLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrderRespDto.getDefaultLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setBizModel(saleOrderRespDto.getBizModel());
        sourceOrderResultReqDto.setLinkOrderCompanyCode(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        sourceOrderResultReqDto.setLinkOrderCompanyName(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseName());
        this.setLinkOrderLabelCode(sourceOrderResultReqDto, saleOrderRespDto);
        sourceOrderResultReqDto.setSgType(ClueTypeEnum.WAREHOUSE.getCode());
        sourceOrderResultReqDto.setLinkShopId(saleOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        sourceOrderResultReqDto.setLinkOrderShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        sourceOrderResultReqDto.setLinkOrderShopName(saleOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        sourceOrderResultReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        DgOrderAddrPageReqDto orderAddrReqDto = new DgOrderAddrPageReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        return sourceOrderResultReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgSourceOrderResultRespDto searchSourceByChangeDeliveryOrderV2(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> orderLineDtos, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        log.info("[\u5373\u6539\u5373\u53d1\u5bfb\u6e90]\u5f00\u59cb\u5bfb\u6e90");
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        IDgSupplyGroupMatchSupportService.MatchBo matchBo = new IDgSupplyGroupMatchSupportService.MatchBo();
        matchBo.setOrderNo(saleOrderRespDto.getSaleOrderNo());
        matchBo.setPreOrderNo(saleOrderRespDto.getParentOrderNo());
        matchBo.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        ArrayList lineBoList = Lists.newArrayList();
        for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
            IDgSupplyGroupMatchSupportService.MatchLineBo matchLineBo = new IDgSupplyGroupMatchSupportService.MatchLineBo();
            matchLineBo.setOrderLineId(Long.valueOf(orderLineDto.getPlatformOrderItemNo()));
            matchLineBo.setSkuCode(orderLineDto.getSkuCode());
            matchLineBo.setSupplyNum(orderLineDto.getItemNum());
            lineBoList.add(matchLineBo);
        }
        matchBo.setLineBoList(lineBoList);
        log.info("[\u5373\u6539\u5373\u53d1\u5bfb\u6e90]\u5f00\u59cb\u5339\u914d\u4f9b\u8d27\u7ec4\u4fe1\u606f\u5165\u53c2={}", JSON.toJSON((Object)matchBo));
        List<IDgSupplyGroupMatchSupportService.MatchResultBo> matchResultBos = this.supplyGroupMatchSupportService.matchAndSave(matchBo);
        AssertUtils.notEmpty(matchResultBos, (String)"\u4f9b\u8d27\u4ed3\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728");
        log.info("[\u5373\u6539\u5373\u53d1\u5bfb\u6e90]\u5f00\u59cb\u5339\u914d\u4f9b\u8d27\u7ec4\u4fe1\u606f\u5165\u53c2={}", JSON.toJSON(matchResultBos));
        ArrayList dgSourceOrderResultReqDtoList = Lists.newArrayList();
        for (IDgSupplyGroupMatchSupportService.MatchResultBo matchResultBo : matchResultBos) {
            List<IDgSupplyGroupMatchSupportService.MatchLineBo> lineList = matchResultBo.getLineBoList();
            Map<Long, BigDecimal> supplyItemNumMap = lineList.stream().collect(Collectors.toMap(IDgSupplyGroupMatchSupportService.MatchLineBo::getOrderLineId, IDgSupplyGroupMatchSupportService.MatchLineBo::getSupplyNum, (k1, k2) -> {
                k1.add((BigDecimal)k2);
                return k1;
            }));
            List orderItemReqDtoList = orderLineDtos.stream().map(saleOrderItemExtRespDto -> {
                Long key = Long.valueOf(saleOrderItemExtRespDto.getPlatformOrderItemNo());
                BigDecimal itemNum = (BigDecimal)supplyItemNumMap.get(key);
                if (itemNum != null) {
                    DgOrderItemPageReqDto orderItemReqDto = new DgOrderItemPageReqDto();
                    CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
                    orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
                    orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
                    orderItemReqDto.setItemSkuName(saleOrderItemExtRespDto.getSkuName());
                    orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
                    orderItemReqDto.setOrderItemUnit(saleOrderItemExtRespDto.getOrderItemUnit());
                    orderItemReqDto.setBasicUnit(saleOrderItemExtRespDto.getBasicUnit());
                    orderItemReqDto.setItemGiftType(saleOrderItemExtRespDto.getGiftFlag());
                    orderItemReqDto.setItemNum(itemNum);
                    return orderItemReqDto;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            AssertUtils.notEmpty(orderItemReqDtoList, (String)"\u5bfb\u6e90\u4f9b\u8d27\u7ec4\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            DgSourceOrderResultReqDto sourceOrderResultReqDto = this.getDgSourceOrderResultReqDto(saleOrderRespDto, saleOrderAddrRespDto);
            sourceOrderResultReqDto.setGroupCode(matchResultBo.getGroupCode());
            sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
            dgSourceOrderResultReqDtoList.add(sourceOrderResultReqDto);
        }
        DgSourceOrderResultRespDto sourceOrderResultGroup = new DgSourceOrderResultRespDto();
        for (DgSourceOrderResultReqDto sourceOrderResultReqDto : dgSourceOrderResultReqDtoList) {
            log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
            RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApi.addSourceOrder(sourceOrderResultReqDto);
            DgSourceOrderResultRespDto sourceOrderResultRespDto = (DgSourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
            log.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
            if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                throw new BizException("\u5bfb\u6e90\u5931\u8d25:" + sourceOrderResultRespDto.getSgFailResultDesc());
            }
            CubeBeanUtils.copyProperties((Object)sourceOrderResultGroup, (Object)sourceOrderResultRespDto, (String[])new String[]{"orderItemResultRespDtoList", "orderItemRespDtoList"});
            sourceOrderResultGroup.getOrderItemRespDtoList().addAll((Collection)ObjectUtils.defaultIfNull((Object)sourceOrderResultRespDto.getOrderItemRespDtoList(), (Object)Lists.newArrayList()));
            sourceOrderResultGroup.getOrderItemResultRespDtoList().addAll((Collection)ObjectUtils.defaultIfNull((Object)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (Object)Lists.newArrayList()));
            sourceOrderResultGroup.setOrderAddrRespDto(sourceOrderResultRespDto.getOrderAddrRespDto());
        }
        log.info("[\u5373\u6539\u5373\u53d1\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultGroup));
        return sourceOrderResultGroup;
    }

    @Override
    public DgSourceOrderResultRespDto shippingSearchSourceV2(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderLineDto> orderLineDtoList, DgPerformOrderAddrDto saleOrderAddrRespDto) {
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u5f00\u59cb\u7269\u6d41\u5bfb\u6e90");
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        BigDecimal totalSaleUnitNum = this.batchExchangeUnitByItem(saleOrderRespDto, orderLineDtoList);
        DgSourceOrderResultReqDto sourceOrderResultReqDto = new DgSourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)saleOrderRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setId(null);
        sourceOrderResultReqDto.setLinkOrderNo(saleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(saleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelId());
        this.setLinkOrderCustomer(sourceOrderResultReqDto, saleOrderRespDto);
        if (StringUtils.isNotEmpty((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode())) {
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseId());
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode());
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseName());
        } else {
            sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode());
        }
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(totalSaleUnitNum);
        sourceOrderResultReqDto.setLinkPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        sourceOrderResultReqDto.setLinkOrderChannelName(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelName());
        sourceOrderResultReqDto.setSgSourceCanSplit(saleOrderRespDto.getAllowSplitFlag());
        sourceOrderResultReqDto.setBizModel(saleOrderRespDto.getBizModel());
        sourceOrderResultReqDto.setLinkOrderCompanyCode(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        sourceOrderResultReqDto.setLinkOrderCompanyName(saleOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseName());
        this.setLinkOrderLabelCode(sourceOrderResultReqDto, saleOrderRespDto);
        sourceOrderResultReqDto.setSgType(ClueTypeEnum.SHIPMENT.getCode());
        sourceOrderResultReqDto.setLinkShopId(saleOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        sourceOrderResultReqDto.setLinkOrderShopCode(saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        sourceOrderResultReqDto.setLinkOrderShopName(saleOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        DgOrderAddrPageReqDto orderAddrReqDto = new DgOrderAddrPageReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)saleOrderAddrRespDto, (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)saleOrderRespDto));
        sourceOrderResultReqDto.setMerchantReceivableAmount(saleOrderRespDto.getMerchantReceivableAmount());
        sourceOrderResultReqDto.setMerchantOriginReceivableAmount(saleOrderRespDto.getMerchantOriginReceivableAmount());
        List orderItemReqDtoList = orderLineDtoList.stream().map(saleOrderItemExtRespDto -> {
            DgOrderItemPageReqDto orderItemReqDto = new DgOrderItemPageReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemSkuName(saleOrderItemExtRespDto.getSkuName());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            orderItemReqDto.setItemBackCategoryOneCode(saleOrderItemExtRespDto.getItemBackCategoryOneCode());
            orderItemReqDto.setItemBackCategoryTwoCode(saleOrderItemExtRespDto.getItemBackCategoryTwoCode());
            orderItemReqDto.setItemBackCategoryThirdCode(saleOrderItemExtRespDto.getItemBackCategoryThirdCode());
            orderItemReqDto.setItemBackCategoryFourthCode(saleOrderItemExtRespDto.getItemBackCategoryFourthCode());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u7269\u6d41\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApi.addSourceOrder(sourceOrderResultReqDto);
        DgSourceOrderResultRespDto sourceOrderResultRespDto = (DgSourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
        log.info("[\u7269\u6d41\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u7269\u6d41\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        return sourceOrderResultRespDto;
    }
}

