/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2b.aftersale.config.engine.guard.impl;

import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.report.api.inventory.IDgOutNoticeOrderApi;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.impl.DgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.constants.DgSendBackEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderCheckModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.statemachine.b2b.aftersale.config.engine.guard.IDgB2BAfterSaleOrderGuard;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgB2BAfterSaleOrderGuardImpl
implements IDgB2BAfterSaleOrderGuard {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgOutNoticeOrderApi outNoticeOrderApi;
    @Resource
    private DgAfterSaleOrderBasicQueryOptAction afterSaleOrderBasicQueryOptAction;

    @Override
    public Boolean validationAfterSaleOrder(DgBizAfterSaleOrderReqDto reqDto, String checkModel) {
        DgPerformOrderInfoDto dgPerformOrderInfoDto = new DgPerformOrderInfoDto();
        this.logger.info("validationAfterSaleOrder checkModel: {}, reqDto: {}", (Object)checkModel, (Object)JacksonUtil.toJson((Object)reqDto));
        this.logger.info("validationAfterSaleOrder checkModel: {}, reqDto: {}", (Object)checkModel, (Object)JacksonUtil.toJson((Object)dgPerformOrderInfoDto));
        switch (DgAfterSaleOrderCheckModelEnum.forCode((String)checkModel)) {
            case CREATE: 
            case CHANNEL_SYNC: {
                AssertUtils.notBlank((String)reqDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801(customerCode)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237ID(customerId)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)reqDto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0(customerName)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)reqDto.getOrderSource(), (String)"\u8ba2\u5355\u6765\u6e90(orderSource)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notBlank((String)reqDto.getStatus(), (String)"\u8ba2\u5355\u72b6\u6001(status)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)reqDto.getRefundFee(), (String)"\u9000\u6b3e\u91d1\u989d(refundFee)\u4e0d\u80fd\u4e3a\u7a7a");
                reqDto.getAfterSaleOrderItemReqDtoList().forEach(dto -> this.checkItemParam((DgAfterSaleOrderItemModifyReqDto)dto, reqDto.getRelateToPlatformOrder()));
            }
        }
        return true;
    }

    @Override
    public boolean isManualSource(DgBizAfterSaleOrderReqDto reqDto) {
        return DgAfterSaleOrderSourceEnum.CREATE.getType().equals(reqDto.getOrderSource());
    }

    @Override
    public Boolean validationWmsSendBack(DgBizAfterSaleOrderReqDto reqDto, DgSendBackEnum sendBackEnum) {
        return Objects.nonNull(reqDto.getTypeFlag()) && sendBackEnum.getCode().equals(reqDto.getTypeFlag());
    }

    @Override
    public Boolean validPortionInWarehouse(DgBizAfterSaleOrderReqDto reqDto) {
        List afterSaleOrderItemRespDtos = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(reqDto.getId());
        boolean isAllInWarehouse = afterSaleOrderItemRespDtos.stream().allMatch(e -> Objects.equals(e.getReturnNum(), e.getActualReturnNum()));
        return !isAllInWarehouse;
    }

    private void checkItemParam(DgAfterSaleOrderItemModifyReqDto itemReqDto, Integer checkType) {
        AssertUtils.notBlank((String)itemReqDto.getSkuCode(), (String)"\u5185\u90e8\u552e\u540e\u5355(skuCode)\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)itemReqDto.getItemCode(), (String)"\u5185\u90e8\u552e\u540e\u5355(itemCode)\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)itemReqDto.getUnit(), (String)"\u5185\u90e8\u552e\u540e\u5355(unit)\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemReqDto.getReturnNum(), (String)"\u5185\u90e8\u552e\u540e\u5355(returnNum)\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemReqDto.getRefundPrice(), (String)"\u5185\u90e8\u552e\u540e\u5355(refundPrice)\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)itemReqDto.getRefundAmount(), (String)"\u5185\u90e8\u552e\u540e\u5355(refundAmount)\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

