/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FactoryDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ResultOrderOptReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BAuditRevokeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderRejectReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgGeneralOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderAllotInventoryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderBatchPushReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderFulfillmentReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.dto.pay.PaymentMqNotifyReqDto;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.execute.DgF2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DgF2BOrderStatemachineHandleImpl
implements IDgF2BOrderStatemachineHandle {
    @Resource
    private DgF2BOrderStatemachineExecutor dgF2BOrderStatemachineExecutor;

    @Override
    public RestResponse<Long> createOrder(String bizModel, OrderReqDto addReqDto) {
        OrderCreateBo bo = null;
        Long orderId = addReqDto.getId();
        bo = orderId != null && Objects.equals(addReqDto.getSubmitType(), "2") ? (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_CHECK_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)) : (orderId != null && Objects.equals(addReqDto.getSubmitType(), "1") ? (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)) : (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, null, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_CREATE_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)));
        return new RestResponse((Object)bo.getOrderEo().getId());
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> submitOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_SUBMIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> modifyOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER_NEW).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> checkOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_CHECK_ORDER_NEW).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> batchPush(String bizModel, OrderBatchPushReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, reqDto.getOrderId(), reqDto, (Object)DgF2BOrderMachineEvents.F2B_BATCH_SUBMIT_ORDER_SINGLE).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<DgOrderResultRespDto> recalculateOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        if (Objects.equals(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType(), DgSaleOrderTypeEnum.INTACT_GOODS_RECEIVE.getType())) {
            return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.INTACT_ORDER_RECALCULATE_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
        }
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.RECALCULATE_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyOrderInfo(String bizModel, OrderModTobReqDto orderModTobReq) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> logicDeleteOrder(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.F2B_DELETE_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<String> modifyPayMethod(String bizModel, PayMethodReqDto payMethodReqDto) {
        PayMethodBo payMethodBo = (PayMethodBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, payMethodReqDto.getOrderId(), payMethodReqDto, (Object)DgF2BOrderMachineEvents.ORDER_PAY).getActionResultSubRestResponse(PayMethodBo.class)).orElseGet(RestResponse::new));
        return new RestResponse((Object)payMethodBo.getPayRecordEo().getPayNo());
    }

    @Override
    public RestResponse<Void> cancelByOrder(String bizModel, Long id, String reason) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.CANCEL);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> closeOrder(String bizModel, Long id, String reason) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.CLOSE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> csAuditOrder(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.CS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> financeAuditOrder(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.FINANCE_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> orderRefundAudit(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.RETURN_AUDIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> orderCsRefundAudit(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.CS_RETURN_AUDIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> delivery(String bizModel, Long id) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, null, (Object)DgF2BOrderMachineEvents.ORDER_DELIVERY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<String> factoryDelivery(String bizModel, FactoryDeliveryReqDto factoryDeliveryReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, factoryDeliveryReqDto.getOrderId(), factoryDeliveryReqDto, (Object)DgF2BOrderMachineEvents.FACTORY_DELIVERY).getActionResultSubRestResponse(String.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> confirmOrder(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.CONFIRM).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Long> addStockBatch(String bizModel, OrderStockBatchDto orderStockBatch) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderStockBatch.getOrderId(), orderStockBatch, (Object)DgF2BOrderMachineEvents.ADD_STOCK_BATCH).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> clearTradeItemBatch(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.CLEAR_TRADE_ITEM_BATCH).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> pay(String bizModel, DgPerformOrderPayReqDto dgPerformOrderPayReqDto) {
        dgPerformOrderPayReqDto.setRefreshAccountDto(Boolean.TRUE.booleanValue());
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, dgPerformOrderPayReqDto.getOrderId(), dgPerformOrderPayReqDto, (Object)DgF2BOrderMachineEvents.F2B_ORDER_PAY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> externalOrderDelivery(String bizModel, DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, dgBizPerformNoticeSyncRecordDto.getBusinessId(), dgBizPerformNoticeSyncRecordDto, (Object)DgF2BOrderMachineEvents.SYNC_ORDER_DELIVER_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> cancelExternalDelivery(String bizModel, Long orderId, ResultOrderOptReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, reqDto, (Object)DgF2BOrderMachineEvents.CANCEL_SYNC_DELIVER_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> partCancelOrder(String bizModel, Long id, String reason) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.ORDER_COMPLETED);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderInternalRemark(String bizModel, Long id, String remark) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, remark, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_INTERNAL_REMARK).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> assignShipmentEnterprise(String bizModel, Long orderId, DgArrangeShipmentEnterpriseReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, reqDto, (Object)DgF2BOrderMachineEvents.F2B_ASSIGN_SHIPMENT_ENTERPRISE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> businessAuditRevoke(String bizModel, DgF2BAuditRevokeReqDto request) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, request.getOrderId(), request, (Object)DgF2BOrderMachineEvents.BUSINESS_AUDIT_REVOKE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> financialAuditRevoke(String bizModel, DgF2BAuditRevokeReqDto request) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, request.getOrderId(), request, (Object)DgF2BOrderMachineEvents.FINANCIAL_AUDIT_REVOKE);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> reject(String bizModel, DgF2BOrderRejectReqDto request) {
        return this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, request.getOrderId(), request, (Object)DgF2BOrderMachineEvents.REJECT_WAIT_CHECK).getActionResultSubRestResponse(Void.class);
    }

    @Override
    public RestResponse<Void> modifyOrderRemark(String bizModel, OrderRemarkReqDto request) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, request.getId(), request, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER_REMARK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> statusLock(String bizModel, Long saleOrderId, String desc) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgF2BOrderMachineEvents.STATUS_LOCK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> statusUnLock(String bizModel, Long saleOrderId, String desc) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(this.chooseBizModel(bizModel), saleOrderId, desc, (Object)DgF2BOrderMachineEvents.STATUS_UNLOCK);
        return RestResponse.VOID;
    }

    private String chooseBizModel(String bizModel) {
        return DgPerformOrderBizModelEnum.F2B_ORDER.getCode();
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageSubmitOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), null, dgOrderReqDto, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_SUBMIT_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageSaveOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), null, dgOrderReqDto, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_SAVE_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageCheckOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto.getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_CHECK_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageRecalculateOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto.getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_RECALCULATE_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageModifyOrder(DgCustomPackageOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), dgOrderReqDto.getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_MODIFY_ORDER).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> customPackageSubmitOrderById(Long id) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), id, null, (Object)DgF2BOrderMachineEvents.CUSTOM_PACKAGE_SUBMIT_ORDER_BY_ID);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> fulfillment(OrderFulfillmentReqDto req) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), req.getOrderId(), req, (Object)DgF2BOrderMachineEvents.ORDER_FULFILLMENT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> allotInventory(OrderAllotInventoryReqDto req) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), req.getOrderId(), req, (Object)DgF2BOrderMachineEvents.ALLOT_INVENTORY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyOrderStayTime(String bizModel, OrderStayReqDto reqDto) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, reqDto.getId(), reqDto, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER_STAY);
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> reloanByOrderId(String bizModel, Long orderId) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.RELOAN);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> generalOrderCreate(DgGeneralOrderReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), null, reqDto, (Object)DgF2BOrderMachineEvents.GENERAL_ORDER_CREATE).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> generalOrderUpdate(DgGeneralOrderReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), null, reqDto, (Object)DgF2BOrderMachineEvents.GENERAL_ORDER_UPDATE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> debtOrderOver(Long orderId) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderId, null, (Object)DgF2BOrderMachineEvents.DEBT_ORDER_OVER);
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> orderExternalAudit(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.EXTERNAL_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> pushExternalSystem(String bizModel, Long orderId) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.PUSH_OA_SYSTEM);
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> manualPick(String bizModel, Long orderId) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.ORDER_PICK);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> paymentCallback(String bizModel, PaymentMqNotifyReqDto reqDto) {
        if ("S".equalsIgnoreCase(reqDto.getStatus())) {
            this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, reqDto.getOrderId(), reqDto, (Object)DgF2BOrderMachineEvents.PAYMENT_CALLBACK_SUCCESS);
        } else if ("F".equalsIgnoreCase(reqDto.getStatus())) {
            this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, reqDto.getOrderId(), reqDto, (Object)DgF2BOrderMachineEvents.PAYMENT_CALLBACK_FAIL);
        } else {
            return RestResponse.VOID;
        }
        return RestResponse.VOID;
    }
}

