/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataChange;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.dataChange.DataChangeIntercept;
import com.yunxi.dg.base.commons.dataChange.DataChangeInterceptUtils;
import com.yunxi.dg.base.commons.dataChange.DataChangeProperties;
import com.yunxi.dg.base.commons.dataChange.DataChangeUpdateInterceptor;
import com.yunxi.dg.base.commons.mq.DgSendMqHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnExpression(value="${dg.base.data.change.enable:false}==true")
public class DataChangeEnableRunner {
    private static final Logger log = LoggerFactory.getLogger(DataChangeEnableRunner.class);

    public DataChangeEnableRunner() {
        log.info("\u6570\u636e\u53d8\u66f4\u76d1\u542c\u6807\u8bc6\u5f00\u542f");
        DataChangeInterceptUtils.LIMIT_FLAG = true;
    }

    @Bean
    @RefreshScope
    public DataChangeProperties dataChangeProperties() {
        return new DataChangeProperties();
    }

    @Bean
    public DataChangeIntercept dataChangeIntercept(DataChangeProperties dataChangeProperties) {
        Optional.ofNullable(dataChangeProperties.getTables()).filter(CollUtil::isNotEmpty).map(r -> r.stream().map(Pattern::compile).collect(Collectors.toList())).ifPresent(tables -> DataChangeInterceptUtils.REGISTER_TABLE.addAll((Collection<Pattern>)tables));
        return new DataChangeIntercept();
    }

    @Bean
    public DataChangeUpdateInterceptor dataChangeUpdateInterceptor() {
        return new DataChangeUpdateInterceptor();
    }

    @Bean
    @Primary
    public DgSendMqHelper dgSendMqHelper() {
        return new DgSendMqHelper();
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer(DataChangeIntercept dataChangeIntercept, DataChangeUpdateInterceptor dataChangeUpdateInterceptor) {
        return configuration -> {
            configuration.addInterceptor((Interceptor)dataChangeIntercept);
            configuration.addInterceptor((Interceptor)dataChangeUpdateInterceptor);
        };
    }

    @PostConstruct
    public void init() {
        Environment bean = (Environment)SpringBeanUtil.getBean(Environment.class);
        String property = bean.getProperty("DATA_CHANGE_FOCUS_TABLE");
        Optional.ofNullable(property).filter(CharSequenceUtil::isNotBlank).map(r -> Lists.newArrayList((Object[])r.split(","))).map(r -> r.stream().map(Pattern::compile).collect(Collectors.toList())).ifPresent(tables -> DataChangeInterceptUtils.REGISTER_TABLE.addAll((Collection<Pattern>)tables));
    }
}

