/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataChange;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealSqlStrategyUtil {
    private static final Logger log = LoggerFactory.getLogger(RealSqlStrategyUtil.class);
    static Map<String, Function<PreparedStatement, String>> map = new HashMap<String, Function<PreparedStatement, String>>();

    public static String getSql(PreparedStatement ps) throws SQLException {
        if (ps == null || ps.getConnection() == null) {
            log.error("PreparedStatement is null ! ps = {}", (Object)ps);
            return null;
        }
        String dbType = ps.getConnection().getMetaData().getDatabaseProductName().toUpperCase();
        return RealSqlStrategyUtil.getRealSqlByPreparedStatement(dbType, ps);
    }

    public static String getRealSqlByPreparedStatement(String dbType, PreparedStatement ps) {
        Function<PreparedStatement, String> statementStringFunction = map.get(dbType);
        if (statementStringFunction == null) {
            throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301 " + map.keySet() + " \u6570\u636e\u6e90\uff01");
        }
        return statementStringFunction.apply(ps).replaceAll("\\s+", " ");
    }

    static {
        map.put("MYSQL", ps -> {
            String temp = ps.toString();
            return temp.substring(temp.indexOf(58) + 1);
        });
        map.put("POSTGRESQL", Object::toString);
    }
}

