/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.datalimit.aop.DataLimitAspect;
import com.yunxi.dg.base.commons.dataLimit.DataLimitSettingUtils;
import com.yunxi.dg.base.commons.dataLimit.SceneUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class DataLimitHeadInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataLimitHeadInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String skipTables;
        String requestMethod = request.getMethod();
        if (!HttpMethod.OPTIONS.name().equalsIgnoreCase(requestMethod)) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String value;
                String headerName = (String)headerNames.nextElement();
                if ("yx.dg.data.limit.enable.header".equals(headerName)) {
                    value = request.getHeader(headerName);
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    ServiceContext.getContext().setAttachment("yx.dg.data.limit.enable.header", value);
                    continue;
                }
                if (!SceneUtil.equals(headerName)) continue;
                value = request.getHeader(headerName);
                if (StrUtil.isBlank((CharSequence)value)) {
                    value = SceneUtil.getSceneCode();
                }
                if (!StrUtil.isNotBlank((CharSequence)value)) continue;
                log.info("DataLimitHeadInterceptor sceneCode: {}", (Object)value);
                ServiceContext.getContext().setAttachment("yes.req.sceneCode", URLDecoder.decode((String)value, (Charset)StandardCharsets.UTF_8));
            }
        }
        if (StringUtils.isEmpty((CharSequence)(skipTables = ServiceContext.getContext().getAttachment("yes-data-limit-skip-tables"))) && StringUtils.isNotEmpty((CharSequence)(skipTables = request.getHeader("yes-data-limit-skip-tables")))) {
            log.debug("\u900f\u4f20\u4fe1\u606f\u8bbe\u5b9a\u4e86\u6570\u636e\u6743\u9650\u5ffd\u7565\u5185\u5bb9:{}", (Object)skipTables);
            ServiceContext.getContext().setAttachment("yes-data-limit-skip-tables", skipTables);
        }
        if (StringUtils.isNotEmpty((CharSequence)skipTables)) {
            log.debug("\u4f7f\u7528\u900f\u4f20\u4fe1\u606f\u8bbe\u5b9a\u7684\u6570\u636e\u6743\u9650\u5ffd\u7565\u5185\u5bb9:{}", (Object)skipTables);
            DataLimitAspect.skipTables((String[])skipTables.split(","));
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        DataLimitSettingUtils.disableDataLimit();
    }
}

