/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dto.serializer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yunxi.dg.base.commons.helper.ExtensionDtoClassMapHelper;
import java.lang.reflect.Type;
import java.util.Objects;

public class DgExtJsonDeserializer
implements ObjectDeserializer {
    public Object deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object obj = this.deserializerType(parser, type, fieldName);
        return obj;
    }

    public Object deserializerType(DefaultJSONParser parser, Type type, Object fieldName) {
        Class extClass = ExtensionDtoClassMapHelper.getExtClass((Class)type);
        JSONObject jsonObject = parser.parseObject();
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (extClass != null) {
            if (Objects.nonNull(fieldName)) {
                JSONObject fieldObj = jsonObject.getJSONObject(fieldName.toString());
                if (fieldObj != null) {
                    return objectMapper.convertValue((Object)fieldObj, extClass);
                }
                return objectMapper.convertValue((Object)jsonObject, extClass);
            }
            objectMapper.convertValue((Object)jsonObject, extClass);
        }
        return objectMapper.convertValue((Object)jsonObject, (Class)type);
    }

    public int getFastMatchToken() {
        return 12;
    }
}

