/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    private static final Logger logger = LoggerFactory.getLogger(MD5Util.class);
    private static final String KEY_MD5 = "MD5";
    private static final String[] STR_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String getMd5ByString(String sourceString) {
        String result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(KEY_MD5);
            digest.update(sourceString.getBytes());
            byte[] b = digest.digest();
            StringBuilder buf = new StringBuilder("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8be5\u5b57\u7b26\u4e32\u7684MD5\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
        return result;
    }

    public static String getMD5ByInputStream(InputStream is) {
        StringBuffer md5 = new StringBuffer();
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance(KEY_MD5);
            byte[] dataBytes = new byte[1024];
            boolean var4 = false;
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                md5.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8be5\u8f93\u5165\u6d41\u7684MD5\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
        return md5.toString();
    }

    public static String getMD5ByFile(File file) {
        String md5 = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            md5 = MD5Util.getMD5ByInputStream(fis);
        }
        catch (FileNotFoundException e) {
            logger.error("\u83b7\u53d6\u8be5\u6587\u4ef6\u7684MD5\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
        return md5;
    }

    public static String getMD5Code(String strObj) {
        try {
            MessageDigest md = MessageDigest.getInstance(KEY_MD5);
            return MD5Util.byteToString(md.digest(strObj.getBytes()));
        }
        catch (Exception e) {
            logger.error("\u524d\u7aefjquery.md5.js\u52a0\u5bc6 \u5bf9\u5e94 \u540e\u7aefMD5\u52a0\u5bc6\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private static String byteToArrayString(byte bByte) {
        int iRet = bByte;
        if (bByte < 0) {
            iRet = bByte + 256;
        }
        int iD1 = iRet / 16;
        int iD2 = iRet % 16;
        return STR_DIGITS[iD1] + STR_DIGITS[iD2];
    }

    private static String byteToString(byte[] bByte) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < bByte.length; ++i) {
            sBuffer.append(MD5Util.byteToArrayString(bByte[i]));
        }
        return sBuffer.toString();
    }
}

