/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.utils;

import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpelUtil.class);
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public static String parse(String spel, Method method, Object[] arguments) {
        if (StringUtils.isBlank((CharSequence)spel)) {
            LOGGER.info("spel\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff01");
            return "";
        }
        if (!spel.contains("#")) {
            return spel;
        }
        String parseSpel = SpelUtil.parseSpel(spel, method, arguments, String.class);
        if (parseSpel == null) {
            return "";
        }
        return parseSpel;
    }

    public static Boolean parseBoolean(String spel, Method method, Object[] arguments) {
        if (StringUtils.isBlank((CharSequence)spel)) {
            LOGGER.info("spel\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff01");
            return Boolean.TRUE;
        }
        Boolean parseSpel = SpelUtil.parseSpel(spel, method, arguments, Boolean.class);
        if (parseSpel == null) {
            return Boolean.TRUE;
        }
        return parseSpel;
    }

    public static <T> T parseSpel(String spel, Method method, Object[] arguments, Class<T> tClass) {
        String[] params = discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (params == null || params.length == 0) {
            LOGGER.info("spel\u8868\u8fbe\u5f0f\u89e3\u6790\u5bf9\u8c61\u5bf9\u7a7a\uff01");
            return null;
        }
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], arguments[len]);
        }
        try {
            Expression expression = parser.parseExpression(spel);
            return (T)expression.getValue((EvaluationContext)context, tClass);
        }
        catch (Exception e) {
            LOGGER.error("spel\u5f02\u5e38\u8868\u8fbe\u5f0f:{}", (Object)spel);
            return null;
        }
    }
}

