/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.mq.comsumer;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.commons.vo.DgMessageVo;
import com.yunxi.dg.base.commons.vo.DgTypeUtils;
import com.yunxi.dg.base.framework.core.mq.bean.DgMqBean;
import com.yunxi.dg.base.framework.core.mq.serialize.IDgMqSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public interface IDgMessageProcessor<T>
extends IMessageProcessor<String> {
    public static final Logger LOG = LoggerFactory.getLogger(IDgMessageProcessor.class);
    public static final DgMqBean dgMqBean = DgMqBean.builder().build();

    public MessageResponse dgProcess(DgMessageVo<T> var1);

    default public IDgMqSerialization<String> mqSerialization() {
        if (dgMqBean.getDgMqSerialization() == null) {
            dgMqBean.setDgMqSerialization((IDgMqSerialization)SpringBeanUtil.getBean(IDgMqSerialization.class));
        }
        return dgMqBean.getDgMqSerialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public MessageResponse process(MQMessageVo message) {
        String reqId = RequestId.createReqId();
        try {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            LOG.info("[DG-MQ] \u6d88\u8d39\u8005\u63a5\u6536\u5230MQ messageId={} topic={} tag={}", new Object[]{message.getMessageId(), message.getTopic(), message.getTag()});
            MessageResponse messageResponse = super.process(message);
            return messageResponse;
        }
        finally {
            MDC.remove((String)"yes.req.requestId");
            ServiceContext.getContext().removeAttachment("yes.req.requestId");
        }
    }

    default public MessageResponse process(String message) {
        try {
            return this.dgProcess(this.mqSerialization().deSerialize(message, DgTypeUtils.getTargetClassType(this.getClass(), IDgMessageProcessor.class)));
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

