/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.mq.producer;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.commons.vo.DgMessageVo;
import com.yunxi.dg.base.framework.core.mq.bean.DgMqBean;
import com.yunxi.dg.base.framework.core.mq.serialize.IDgMqSerialization;
import com.yunxi.dg.base.framework.core.mq.utils.AroundMqUtils;

public interface IDgCommonsMqService {
    public static final DgMqBean dgMqBean = DgMqBean.builder().build();

    default public ICommonsMqService mqService() {
        if (dgMqBean.getCommonsMqService() == null) {
            dgMqBean.setCommonsMqService((ICommonsMqService)SpringBeanUtil.getBean(ICommonsMqService.class));
        }
        return dgMqBean.getCommonsMqService();
    }

    default public IDgMqSerialization mqSerialization() {
        if (dgMqBean.getDgMqSerialization() == null) {
            dgMqBean.setDgMqSerialization((IDgMqSerialization)SpringBeanUtil.getBean(IDgMqSerialization.class));
        }
        return dgMqBean.getDgMqSerialization();
    }

    default public <T> MessageResponse sendSingleMessage(String tag, DgMessageVo<T> msg) {
        return AroundMqUtils.sendAround(null, tag, msg, null, o -> this.mqService().sendSingleMessage(tag, this.mqSerialization().serialize(o)));
    }

    default public <T> MessageResponse sendSingleMessage(String topic, String tag, DgMessageVo<T> msg) {
        return AroundMqUtils.sendAround(topic, tag, msg, null, o -> this.mqService().sendSingleMessage(topic, tag, this.mqSerialization().serialize(o)));
    }

    default public <T> MessageResponse sendDelaySingleMessage(String tag, DgMessageVo<T> msg, Long delayTime) {
        return AroundMqUtils.sendAround(null, tag, msg, delayTime, o -> this.mqService().sendDelaySingleMessage(tag, this.mqSerialization().serialize(o), delayTime));
    }

    default public <T> MessageResponse sendDelaySingleMessage(String topic, String tag, DgMessageVo<T> msg, Long delayTime) {
        return AroundMqUtils.sendAround(topic, tag, msg, delayTime, o -> this.mqService().sendDelaySingleMessage(topic, tag, this.mqSerialization().serialize(o), delayTime));
    }

    default public <T> MessageResponse publishMessage(String tag, DgMessageVo<T> msg) {
        return AroundMqUtils.publishAround(null, tag, msg, null, o -> this.mqService().publishMessage(tag, this.mqSerialization().serialize(o)));
    }

    default public <T> MessageResponse publishMessage(String topic, String tag, DgMessageVo<T> msg) {
        return AroundMqUtils.publishAround(topic, tag, msg, null, o -> this.mqService().publishMessage(topic, tag, this.mqSerialization().serialize(o)));
    }

    default public <T> MessageResponse publishDelayMessage(String tag, DgMessageVo<T> msg, Long delayTime) {
        return AroundMqUtils.publishAround(null, tag, msg, delayTime, o -> this.mqService().publishDelayMessage(tag, this.mqSerialization().serialize(o), delayTime));
    }

    default public <T> MessageResponse publishDelayMessage(String topic, String tag, DgMessageVo<T> msg, Long delayTime) {
        return AroundMqUtils.publishAround(topic, tag, msg, delayTime, o -> this.mqService().publishDelayMessage(topic, tag, this.mqSerialization().serialize(o), delayTime));
    }
}

