/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.metrics;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.RedisCommand;
import io.micrometer.core.instrument.Tags;
import java.time.Duration;
import java.util.HashSet;
import java.util.function.Predicate;

public class MicrometerOptions {
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_HISTOGRAM = false;
    public static final boolean DEFAULT_LOCAL_DISTINCTION = false;
    public static final Duration DEFAULT_MAX_LATENCY = Duration.ofMinutes(5L);
    public static final Duration DEFAULT_MIN_LATENCY = Duration.ofMillis(1L);
    public static final double[] DEFAULT_TARGET_PERCENTILES = new double[]{0.5, 0.9, 0.95, 0.99, 0.999};
    private static final MicrometerOptions DISABLED = MicrometerOptions.builder().disable().build();
    private final Builder builder;
    private final boolean enabled;
    private final boolean histogram;
    private final boolean localDistinction;
    private final Duration maxLatency;
    private final Duration minLatency;
    private final Predicate<RedisCommand<?, ?, ?>> metricsFilter;
    private final Tags tags;
    private final double[] targetPercentiles;

    protected MicrometerOptions(Builder builder) {
        this.builder = builder;
        this.enabled = builder.enabled;
        this.histogram = builder.histogram;
        this.localDistinction = builder.localDistinction;
        this.metricsFilter = builder.metricsFilter;
        this.maxLatency = builder.maxLatency;
        this.minLatency = builder.minLatency;
        this.tags = builder.tags;
        this.targetPercentiles = builder.targetPercentiles;
    }

    public static MicrometerOptions create() {
        return MicrometerOptions.builder().build();
    }

    public static MicrometerOptions disabled() {
        return DISABLED;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder mutate() {
        return this.builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public boolean localDistinction() {
        return this.localDistinction;
    }

    public Predicate<RedisCommand<?, ?, ?>> getMetricsFilter() {
        return this.metricsFilter;
    }

    public Duration maxLatency() {
        return this.maxLatency;
    }

    public Duration minLatency() {
        return this.minLatency;
    }

    public Tags tags() {
        return this.tags;
    }

    public double[] targetPercentiles() {
        double[] result = new double[this.targetPercentiles.length];
        System.arraycopy(this.targetPercentiles, 0, result, 0, this.targetPercentiles.length);
        return result;
    }

    public static class Builder {
        private boolean enabled = true;
        private boolean histogram = false;
        private boolean localDistinction = false;
        private Predicate<RedisCommand<?, ?, ?>> metricsFilter = command -> true;
        private Duration maxLatency = DEFAULT_MAX_LATENCY;
        private Duration minLatency = DEFAULT_MIN_LATENCY;
        private Tags tags = Tags.empty();
        private double[] targetPercentiles = DEFAULT_TARGET_PERCENTILES;

        private Builder() {
        }

        public Builder disable() {
            this.enabled = false;
            return this;
        }

        public Builder enable() {
            this.enabled = true;
            return this;
        }

        public Builder histogram(boolean histogram) {
            this.histogram = histogram;
            return this;
        }

        public Builder localDistinction(boolean localDistinction) {
            this.localDistinction = localDistinction;
            return this;
        }

        public Builder enabledCommands(CommandType ... commands) {
            LettuceAssert.notNull((Object)commands, "Commands must not be null");
            if (commands.length == 0) {
                return this.metricsFilter(command -> true);
            }
            HashSet<String> enabledCommands = new HashSet<String>(commands.length);
            for (CommandType enabledCommand : commands) {
                enabledCommands.add(enabledCommand.name());
            }
            return this.metricsFilter(command -> enabledCommands.contains(command.getType().name()));
        }

        public Builder metricsFilter(Predicate<RedisCommand<?, ?, ?>> filter) {
            LettuceAssert.notNull(filter, "Metrics filter predicate must not be null");
            this.metricsFilter = filter;
            return this;
        }

        public Builder maxLatency(Duration maxLatency) {
            LettuceAssert.notNull((Object)maxLatency, "Max Latency must not be null");
            this.maxLatency = maxLatency;
            return this;
        }

        public Builder minLatency(Duration minLatency) {
            LettuceAssert.notNull((Object)minLatency, "Min Latency must not be null");
            this.minLatency = minLatency;
            return this;
        }

        public Builder tags(Tags tags) {
            LettuceAssert.notNull((Object)tags, "Tags must not be null");
            this.tags = tags;
            return this;
        }

        public Builder targetPercentiles(double[] targetPercentiles) {
            LettuceAssert.notNull((Object)targetPercentiles, "TargetPercentiles must not be null");
            this.targetPercentiles = targetPercentiles;
            return this;
        }

        public MicrometerOptions build() {
            return new MicrometerOptions(this);
        }
    }
}

