/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.SessionFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class SessionView
extends ActiveMQAbstractView<ServerSession> {
    private static final String defaultSortColumn = "creationTime";

    public SessionView() {
        this.predicate = new SessionFilterPredicate();
    }

    @Override
    public Class getClassT() {
        return ServerSession.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerSession session) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(session.getName())).add("user", this.toString(session.getUsername())).add(defaultSortColumn, new Date(session.getCreationTime()).toString()).add("consumerCount", session.getServerConsumers().size()).add("producerCount", session.getServerProducers().size()).add("connectionID", session.getConnectionID().toString());
        return obj;
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

