/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.Base64Variants;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public final class StringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;

    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = jp.getValueAsString();
        if (text != null) {
            return text;
        }
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }

    @Override
    public String deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return this.deserialize(jp, ctxt);
    }
}

