/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.io.NumberOutput;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.node.NumericNode;

public final class IntNode
extends NumericNode {
    static final int MIN_CANONICAL = -1;
    static final int MAX_CANONICAL = 10;
    private static final IntNode[] CANONICALS;
    final int _value;

    public IntNode(int v) {
        this._value = v;
    }

    public static IntNode valueOf(int i) {
        if (i > 10 || i < -1) {
            return new IntNode(i);
        }
        return CANONICALS[i - -1];
    }

    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.INT;
    }

    public boolean isIntegralNumber() {
        return true;
    }

    public boolean isInt() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public Number numberValue() {
        return this._value;
    }

    public int intValue() {
        return this._value;
    }

    public long longValue() {
        return this._value;
    }

    public double doubleValue() {
        return this._value;
    }

    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    public String asText() {
        return NumberOutput.toString(this._value);
    }

    public boolean asBoolean(boolean defaultValue) {
        return this._value != 0;
    }

    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNumber(this._value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((IntNode)o)._value == this._value;
    }

    public int hashCode() {
        return this._value;
    }

    static {
        int count = 12;
        CANONICALS = new IntNode[count];
        for (int i = 0; i < count; ++i) {
            IntNode.CANONICALS[i] = new IntNode(-1 + i);
        }
    }
}

