/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializable;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.annotation.NoClass;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.SerializerFactory;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.Serializers;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.DateSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.NullSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.StdContainerSerializers;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.StringSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.ArrayType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.CollectionType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.MapType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.util.EnumValues;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.util.TokenBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    private static final long serialVersionUID = -1416617628045738132L;
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(additional));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(additional));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(modifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config, JavaType type) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(type.getRawClass());
        JsonSerializer<?> ser = null;
        Iterator<Serializers> i$ = this._factoryConfig.keySerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, type, beanDesc)) == null) {
        }
        return ser;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config, JavaType baseType) {
        BeanDescription bean = config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        if (b == null) {
            return null;
        }
        return b.buildTypeSerializer(config, baseType, subtypes);
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription beanDesc, boolean staticTyping) {
        Class<?> raw = type.getRawClass();
        String clsName = raw.getName();
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser != null) {
            return ser;
        }
        Class<JsonSerializer<?>> serClass = _concreteLazy.get(clsName);
        if (serClass != null) {
            try {
                return serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider prov, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(raw)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            Method m = valueMethod.getAnnotated();
            if (prov.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m);
            }
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(prov, valueMethod);
            return new JsonValueSerializer(m, ser);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<Enum<?>> raw = type.getRawClass();
        if (InetAddress.class.isAssignableFrom(raw)) {
            return InetAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(raw)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        JsonSerializer<?> ser = this.optionalHandlers.findSerializer(prov.getConfig(), type);
        if (ser != null) {
            return ser;
        }
        if (Number.class.isAssignableFrom(raw)) {
            return NumberSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(raw)) {
            JsonFormat.Value format = beanDesc.findExpectedFormat(null);
            if (format != null && format.getShape() == JsonFormat.Shape.OBJECT) {
                ((BasicBeanDescription)beanDesc).removeProperty("declaringClass");
            } else {
                Class<Enum<?>> enumClass = raw;
                return EnumSerializer.construct(enumClass, prov.getConfig(), beanDesc, format);
            }
        }
        if (Calendar.class.isAssignableFrom(raw)) {
            return CalendarSerializer.instance;
        }
        if (java.util.Date.class.isAssignableFrom(raw)) {
            return DateSerializer.instance;
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig config, JavaType javaType, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<?> type = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            return this.buildIteratorSerializer(config, javaType, beanDesc, staticTyping);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.buildIterableSerializer(config, javaType, beanDesc, staticTyping);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object serDef = prov.getAnnotationIntrospector().findSerializer(a);
        if (serDef == null) {
            return null;
        }
        return prov.serializerInstance(a, serDef);
    }

    @Deprecated
    protected final JsonSerializer<?> buildContainerSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, BeanProperty property, boolean staticTyping) throws JsonMappingException {
        return this.buildContainerSerializer(prov, type, beanDesc, staticTyping);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType elementType;
        SerializationConfig config = prov.getConfig();
        TypeSerializer elementTypeSerializer = this.createTypeSerializer(config, elementType = type.getContentType());
        if (elementTypeSerializer != null) {
            staticTyping = false;
        }
        JsonSerializer<Object> elementValueSerializer = this._findContentSerializer(prov, beanDesc.getClassInfo());
        if (type.isMapLikeType()) {
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = this._findKeySerializer(prov, beanDesc.getClassInfo());
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(config, (MapType)mlt, beanDesc, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> ser = serializers.findMapLikeSerializer(config, (MapLikeType)type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                return ser;
            }
            return null;
        }
        if (type.isCollectionLikeType()) {
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                CollectionType trueCT = (CollectionType)clt;
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> ser = serializers.findCollectionSerializer(config, trueCT, beanDesc, elementTypeSerializer, elementValueSerializer);
                    if (ser == null) continue;
                    return ser;
                }
                JsonFormat.Value format = beanDesc.findExpectedFormat(null);
                if (format == null || format.getShape() != JsonFormat.Shape.OBJECT) {
                    return this.buildCollectionSerializer(config, trueCT, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            } else {
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> ser = serializers.findCollectionLikeSerializer(config, (CollectionLikeType)type, beanDesc, elementTypeSerializer, elementValueSerializer);
                    if (ser == null) continue;
                    return ser;
                }
                return null;
            }
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(config, (ArrayType)type, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    @Deprecated
    protected final JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        return this.buildCollectionSerializer(config, type, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (EnumSet.class.isAssignableFrom(raw)) {
            JavaType enumType = type.getContentType();
            if (!enumType.isEnumType()) {
                enumType = null;
            }
            return StdContainerSerializers.enumSetSerializer(enumType);
        }
        Class<?> elementRaw = type.getContentType().getRawClass();
        if (this.isIndexedList(raw)) {
            if (elementRaw == String.class && (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer))) {
                return IndexedStringListSerializer.instance;
            }
            return StdContainerSerializers.indexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        if (elementRaw == String.class && (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer))) {
            return StringCollectionSerializer.instance;
        }
        return StdContainerSerializers.collectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findMapSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        if (EnumMap.class.isAssignableFrom(type.getRawClass())) {
            JavaType keyType = type.getKeyType();
            EnumValues enums = null;
            if (keyType.isEnumType()) {
                Class<Enum<?>> enumClass = keyType.getRawClass();
                enums = EnumValues.construct(enumClass, config.getAnnotationIntrospector());
            }
            return new EnumMapSerializer(type.getContentType(), staticTyping, enums, elementTypeSerializer, elementValueSerializer);
        }
        return MapSerializer.construct(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()), type, staticTyping, elementTypeSerializer, keySerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig config, ArrayType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findArraySerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
            if (ser == null) continue;
            return ser;
        }
        Class<?> raw = type.getRawClass();
        if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
            if (String[].class == raw) {
                return StringArraySerializer.instance;
            }
            JsonSerializer<?> ser = StdArraySerializers.findStandardImpl(raw);
            if (ser != null) {
                return ser;
            }
        }
        return new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return StdContainerSerializers.iteratorSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return StdContainerSerializers.iterableSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig config, Annotated a, T type) {
        Class<?> superclass = config.getAnnotationIntrospector().findSerializationType(a);
        if (superclass != null) {
            try {
                type = type.widenBy(superclass);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Failed to widen type " + type + " with concrete-type annotation (value " + superclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(config, a, type);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig config, Annotated a, T type) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (((JavaType)type).isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findSerializationKeyType(a, ((JavaType)type).getKeyType());
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).widenKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage());
                }
            }
            if ((cc = intr.findSerializationContentType(a, ((JavaType)type).getContentType())) != null) {
                try {
                    type = ((JavaType)type).widenContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage());
                }
            }
        }
        return (T)type;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    @Deprecated
    protected final boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer, BeanProperty property) {
        return this.usesStaticTyping(config, beanDesc, typeSer);
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(beanDesc.getClassInfo());
        return t != null ? t == JsonSerialize.Typing.STATIC : config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || cls == NoClass.class) {
            return null;
        }
        return cls;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializers.NumberSerializer ns = new NumberSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSer = DateSerializer.instance;
        _concrete.put(java.util.Date.class.getName(), dateSer);
        _concrete.put(Timestamp.class.getName(), dateSer);
        _concrete.put(Date.class.getName(), new SqlDateSerializer());
        _concrete.put(Time.class.getName(), new SqlTimeSerializer());
        for (Map.Entry<Class<?>, Object> en : new StdJdkSerializers().provide()) {
            Object value = en.getValue();
            if (value instanceof JsonSerializer) {
                _concrete.put(en.getKey().getName(), (JsonSerializer)value);
                continue;
            }
            if (value instanceof Class) {
                Class cls = (Class)value;
                _concreteLazy.put(en.getKey().getName(), cls);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + en.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

