/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>>
implements ContextualSerializer {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();
    protected final JsonSerializer<String> _serializer;

    protected StringCollectionSerializer() {
        this((JsonSerializer<?>)null);
    }

    protected StringCollectionSerializer(JsonSerializer<?> ser) {
        super(Collection.class);
        this._serializer = ser;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._serializer;
        }
        if (ser == null) {
            ser = provider.findValueSerializer(String.class, property);
        } else if (ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(provider, property);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        if (ser == this._serializer) {
            return this;
        }
        return new StringCollectionSerializer(ser);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
        jgen.writeEndArray();
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray(value, jgen);
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider);
        } else {
            this.serializeUsingCustom(value, jgen, provider);
        }
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._serializer != null) {
            this.serializeUsingCustom(value, jgen, provider);
            return;
        }
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                } else {
                    jgen.writeString(str);
                }
                ++i;
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }

    private void serializeUsingCustom(Collection<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<String> ser = this._serializer;
        int i = 0;
        for (String str : value) {
            try {
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                ser.serialize(str, jgen, provider);
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }
}

